/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.fs;

import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.filecache.FileCacheSettings;
import org.opensearch.indices.IndicesService;
import org.opensearch.monitor.fs.FsService;
import org.opensearch.monitor.fs.WarmFsService;

public class FsServiceProvider {
    private final Settings settings;
    private final NodeEnvironment nodeEnvironment;
    private final FileCache fileCache;
    private final FileCacheSettings fileCacheSettings;
    private final IndicesService indicesService;

    public FsServiceProvider(Settings settings, NodeEnvironment nodeEnvironment, FileCache fileCache, ClusterSettings clusterSettings, IndicesService indicesService) {
        this.settings = settings;
        this.nodeEnvironment = nodeEnvironment;
        this.fileCache = fileCache;
        this.fileCacheSettings = new FileCacheSettings(settings, clusterSettings);
        this.indicesService = indicesService;
    }

    public FsService createFsService() {
        if (DiscoveryNode.isWarmNode(this.settings)) {
            return new WarmFsService(this.settings, this.nodeEnvironment, this.fileCacheSettings, this.indicesService, this.fileCache);
        }
        return new FsService(this.settings, this.nodeEnvironment, this.fileCache);
    }
}

