/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;
import org.opensearch.cluster.metadata.CryptoMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.VersionedCodecStreamWrapper;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.store.RemoteDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectoryFactory;
import org.opensearch.index.store.lockmanager.FileLockInfo;
import org.opensearch.index.store.lockmanager.RemoteStoreCommitLevelLockManager;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManager;
import org.opensearch.index.store.lockmanager.RemoteStoreMetadataLockManager;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadataHandlerFactory;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.node.remotestore.RemoteStorePinnedTimestampService;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="2.3.0")
public final class RemoteSegmentStoreDirectory
extends FilterDirectory
implements RemoteStoreCommitLevelLockManager {
    public static final String SEGMENT_NAME_UUID_SEPARATOR = "__";
    private final RemoteDirectory remoteDataDirectory;
    private final RemoteDirectory remoteMetadataDirectory;
    private final RemoteStoreLockManager mdLockManager;
    private final Map<Long, String> metadataFilePinnedTimestampMap;
    private final ThreadPool threadPool;
    private final Map<String, String> pendingDownloadMergedSegments;
    private Map<String, UploadedSegmentMetadata> segmentsUploadedToRemoteStore;
    private static final VersionedCodecStreamWrapper<RemoteSegmentMetadata> metadataStreamWrapper = new VersionedCodecStreamWrapper<RemoteSegmentMetadata>(new RemoteSegmentMetadataHandlerFactory(), 1, 2, "segment_md");
    private static final Logger staticLogger = LogManager.getLogger(RemoteSegmentStoreDirectory.class);
    private final Logger logger;
    protected final AtomicBoolean canDeleteStaleCommits = new AtomicBoolean(true);
    private final AtomicLong metadataUploadCounter = new AtomicLong(0L);
    public static final int METADATA_FILES_TO_FETCH = 10;

    public RemoteSegmentStoreDirectory(RemoteDirectory remoteDataDirectory, RemoteDirectory remoteMetadataDirectory, RemoteStoreLockManager mdLockManager, ThreadPool threadPool, ShardId shardId) throws IOException {
        this(remoteDataDirectory, remoteMetadataDirectory, mdLockManager, threadPool, shardId, null);
    }

    @InternalApi
    public RemoteSegmentStoreDirectory(RemoteDirectory remoteDataDirectory, RemoteDirectory remoteMetadataDirectory, RemoteStoreLockManager mdLockManager, ThreadPool threadPool, ShardId shardId, @Nullable Map<String, String> pendingDownloadMergedSegments) throws IOException {
        super((Directory)remoteDataDirectory);
        this.remoteDataDirectory = remoteDataDirectory;
        this.remoteMetadataDirectory = remoteMetadataDirectory;
        this.mdLockManager = mdLockManager;
        this.threadPool = threadPool;
        this.metadataFilePinnedTimestampMap = new HashMap<Long, String>();
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
        this.pendingDownloadMergedSegments = pendingDownloadMergedSegments;
        this.init();
    }

    public RemoteSegmentMetadata init() throws IOException {
        this.logger.debug("Start initialisation of remote segment metadata");
        RemoteSegmentMetadata remoteSegmentMetadata = this.readLatestMetadataFile();
        this.segmentsUploadedToRemoteStore = remoteSegmentMetadata != null ? new ConcurrentHashMap<String, UploadedSegmentMetadata>(remoteSegmentMetadata.getMetadata()) : new ConcurrentHashMap<String, UploadedSegmentMetadata>();
        this.logger.debug("Initialisation of remote segment metadata completed");
        return remoteSegmentMetadata;
    }

    public RemoteSegmentMetadata initializeToSpecificCommit(long primaryTerm, long commitGeneration, String acquirerId) throws IOException {
        String metadataFilePrefix = MetadataFilenameUtils.getMetadataFilePrefixForCommit(primaryTerm, commitGeneration);
        String metadataFile = ((RemoteStoreMetadataLockManager)this.mdLockManager).fetchLockedMetadataFile(metadataFilePrefix, acquirerId);
        RemoteSegmentMetadata remoteSegmentMetadata = this.readMetadataFile(metadataFile);
        this.segmentsUploadedToRemoteStore = remoteSegmentMetadata != null ? new ConcurrentHashMap<String, UploadedSegmentMetadata>(remoteSegmentMetadata.getMetadata()) : new ConcurrentHashMap<String, UploadedSegmentMetadata>();
        return remoteSegmentMetadata;
    }

    public RemoteSegmentMetadata initializeToSpecificTimestamp(long timestamp) throws IOException {
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", Integer.MAX_VALUE);
        Set<String> lockedMetadataFiles = RemoteStoreUtils.getPinnedTimestampLockedFiles(metadataFiles, Set.of(Long.valueOf(timestamp)), MetadataFilenameUtils::getTimestamp, MetadataFilenameUtils::getNodeIdByPrimaryTermAndGen, true);
        if (lockedMetadataFiles.isEmpty()) {
            return null;
        }
        if (lockedMetadataFiles.size() > 1) {
            throw new IOException("Expected exactly one metadata file matching timestamp: " + timestamp + " but got " + String.valueOf(lockedMetadataFiles));
        }
        String metadataFile = lockedMetadataFiles.iterator().next();
        RemoteSegmentMetadata remoteSegmentMetadata = this.readMetadataFile(metadataFile);
        this.segmentsUploadedToRemoteStore = remoteSegmentMetadata != null ? new ConcurrentHashMap<String, UploadedSegmentMetadata>(remoteSegmentMetadata.getMetadata()) : new ConcurrentHashMap<String, UploadedSegmentMetadata>();
        return remoteSegmentMetadata;
    }

    public RemoteSegmentMetadata readLatestMetadataFile() throws IOException {
        RemoteSegmentMetadata remoteSegmentMetadata = null;
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", 10);
        RemoteStoreUtils.verifyNoMultipleWriters(metadataFiles, MetadataFilenameUtils::getNodeIdByPrimaryTermAndGen);
        if (!metadataFiles.isEmpty()) {
            String latestMetadataFile = metadataFiles.get(0);
            this.logger.trace("Reading latest Metadata file {}", (Object)latestMetadataFile);
            remoteSegmentMetadata = this.readMetadataFile(latestMetadataFile);
        } else {
            this.logger.trace("No metadata file found, this can happen for new index with no data uploaded to remote segment store");
        }
        return remoteSegmentMetadata;
    }

    private RemoteSegmentMetadata readMetadataFile(String metadataFilename) throws IOException {
        try (InputStream inputStream = this.remoteMetadataDirectory.getBlobStream(metadataFilename);){
            byte[] metadataBytes = inputStream.readAllBytes();
            RemoteSegmentMetadata remoteSegmentMetadata = metadataStreamWrapper.readStream(new ByteArrayIndexInput(metadataFilename, metadataBytes));
            return remoteSegmentMetadata;
        }
    }

    public Map<String, RemoteSegmentMetadata> readLatestNMetadataFiles(int count) throws IOException {
        LinkedHashMap<String, RemoteSegmentMetadata> metadataMap = new LinkedHashMap<String, RemoteSegmentMetadata>();
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", count);
        for (String file : metadataFiles) {
            try {
                InputStream inputStream = this.remoteMetadataDirectory.getBlobStream(file);
                try {
                    byte[] bytes = inputStream.readAllBytes();
                    RemoteSegmentMetadata metadata = metadataStreamWrapper.readStream(new ByteArrayIndexInput(file, bytes));
                    metadataMap.put(file, metadata);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to parse segment metadata file", (Throwable)e);
            }
        }
        return metadataMap;
    }

    public String[] listAll() throws IOException {
        return this.readLatestMetadataFile().getMetadata().keySet().toArray(new String[0]);
    }

    public void deleteFile(String name) throws IOException {
        String remoteFilename = this.getExistingRemoteFilename(name);
        if (remoteFilename != null) {
            this.remoteDataDirectory.deleteFile(remoteFilename);
            this.segmentsUploadedToRemoteStore.remove(name);
        }
    }

    public long fileLength(String name) throws IOException {
        if (this.segmentsUploadedToRemoteStore.containsKey(name)) {
            return this.segmentsUploadedToRemoteStore.get(name).getLength();
        }
        String remoteFilename = this.getExistingRemoteFilename(name);
        if (remoteFilename != null) {
            return this.remoteDataDirectory.fileLength(remoteFilename);
        }
        throw new NoSuchFileException(name);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.remoteDataDirectory.createOutput(this.getNewRemoteSegmentFilename(name), context);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        String remoteFilename = this.getExistingRemoteFilename(name);
        long fileLength = this.fileLength(name);
        if (remoteFilename != null) {
            return this.remoteDataDirectory.openInput(remoteFilename, fileLength, context);
        }
        throw new NoSuchFileException(name);
    }

    public IndexInput openBlockInput(String name, long position, long length, IOContext context) throws IOException {
        String remoteFilename = this.getExistingRemoteFilename(name);
        long fileLength = this.fileLength(name);
        if (remoteFilename != null) {
            return this.remoteDataDirectory.openBlockInput(remoteFilename, position, length, fileLength, context);
        }
        throw new NoSuchFileException(name);
    }

    public void copyFrom(Directory from, String src, IOContext context, ActionListener<Void> listener, boolean lowPriorityUpload) {
        this.copyFrom(from, src, context, listener, lowPriorityUpload, null);
    }

    public void copyFrom(Directory from, String src, IOContext context, ActionListener<Void> listener, boolean lowPriorityUpload, CryptoMetadata cryptoMetadata) {
        try {
            String remoteFileName = this.getNewRemoteSegmentFilename(src);
            boolean uploaded = false;
            if (!src.startsWith("segments")) {
                uploaded = this.remoteDataDirectory.copyFrom(from, src, remoteFileName, context, () -> {
                    try {
                        this.postUpload(from, src, remoteFileName, this.getChecksumOfLocalFile(from, src));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception in segment postUpload for file " + src, e);
                    }
                }, listener, lowPriorityUpload, cryptoMetadata);
            }
            if (!uploaded) {
                this.copyFrom(from, src, src, context);
                listener.onResponse(null);
            }
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("Exception while uploading file {} to the remote segment store", (Object)src), (Throwable)e);
            listener.onFailure(e);
        }
    }

    @Override
    public void acquireLock(long primaryTerm, long generation, String acquirerId) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, generation);
        this.mdLockManager.acquire(FileLockInfo.getLockInfoBuilder().withFileToLock(metadataFile).withAcquirerId(acquirerId).build());
    }

    @Override
    public void releaseLock(long primaryTerm, long generation, String acquirerId) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, generation);
        this.mdLockManager.release(FileLockInfo.getLockInfoBuilder().withFileToLock(metadataFile).withAcquirerId(acquirerId).build());
    }

    @Override
    public Boolean isLockAcquired(long primaryTerm, long generation) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, generation);
        return this.isLockAcquired(metadataFile);
    }

    Boolean isLockAcquired(String metadataFile) throws IOException {
        return this.mdLockManager.isAcquired(FileLockInfo.getLockInfoBuilder().withFileToLock(metadataFile).build());
    }

    String getMetadataFileForCommit(long primaryTerm, long generation) throws IOException {
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder(MetadataFilenameUtils.getMetadataFilePrefixForCommit(primaryTerm, generation), 1);
        if (metadataFiles.isEmpty()) {
            throw new NoSuchFileException("Metadata file is not present for given primary term " + primaryTerm + " and generation " + generation);
        }
        if (metadataFiles.size() != 1) {
            throw new IllegalStateException("there should be only one metadata file for given primary term " + primaryTerm + "and generation " + generation + " but found " + metadataFiles.size());
        }
        return metadataFiles.get(0);
    }

    private void postUpload(Directory from, String src, String remoteFilename, String checksum) throws IOException {
        UploadedSegmentMetadata segmentMetadata = new UploadedSegmentMetadata(src, remoteFilename, checksum, from.fileLength(src));
        this.segmentsUploadedToRemoteStore.put(src, segmentMetadata);
    }

    public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        String remoteFilename = this.getNewRemoteSegmentFilename(dest);
        this.remoteDataDirectory.copyFrom(from, src, remoteFilename, context);
        this.postUpload(from, src, remoteFilename, this.getChecksumOfLocalFile(from, src));
    }

    public boolean containsFile(String localFilename, String checksum) {
        return this.segmentsUploadedToRemoteStore.containsKey(localFilename) && this.segmentsUploadedToRemoteStore.get((Object)localFilename).checksum.equals(checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadMetadata(Collection<String> segmentFiles, SegmentInfos segmentInfosSnapshot, Directory storeDirectory, long translogGeneration, ReplicationCheckpoint replicationCheckpoint, String nodeId) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this;
        synchronized (remoteSegmentStoreDirectory) {
            String metadataFilename = MetadataFilenameUtils.getMetadataFilename(replicationCheckpoint.getPrimaryTerm(), segmentInfosSnapshot.getGeneration(), translogGeneration, this.metadataUploadCounter.incrementAndGet(), 2, nodeId);
            try {
                try (IndexOutput indexOutput = storeDirectory.createOutput(metadataFilename, IOContext.DEFAULT);){
                    Map<String, Integer> segmentToLuceneVersion = this.getSegmentToLuceneVersion(segmentFiles, segmentInfosSnapshot);
                    HashMap<String, String> uploadedSegments = new HashMap<String, String>();
                    for (String file : segmentFiles) {
                        if (this.segmentsUploadedToRemoteStore.containsKey(file)) {
                            UploadedSegmentMetadata metadata = this.segmentsUploadedToRemoteStore.get(file);
                            metadata.setWrittenByMajor(segmentToLuceneVersion.get(metadata.originalFilename));
                            uploadedSegments.put(file, metadata.toString());
                            continue;
                        }
                        throw new NoSuchFileException(file);
                    }
                    ByteBuffersDataOutput byteBuffersIndexOutput = new ByteBuffersDataOutput();
                    segmentInfosSnapshot.write((IndexOutput)new ByteBuffersIndexOutput(byteBuffersIndexOutput, "Snapshot of SegmentInfos", "SegmentInfos"));
                    byte[] segmentInfoSnapshotByteArray = byteBuffersIndexOutput.toArrayCopy();
                    metadataStreamWrapper.writeStream(indexOutput, new RemoteSegmentMetadata(RemoteSegmentMetadata.fromMapOfStrings(uploadedSegments), segmentInfoSnapshotByteArray, replicationCheckpoint));
                }
                storeDirectory.sync(Collections.singleton(metadataFilename));
                this.remoteMetadataDirectory.copyFrom(storeDirectory, metadataFilename, metadataFilename, IOContext.DEFAULT);
            }
            finally {
                this.tryAndDeleteLocalFile(metadataFilename, storeDirectory);
            }
        }
    }

    private Map<String, Integer> getSegmentToLuceneVersion(Collection<String> segmentFiles, SegmentInfos segmentInfosSnapshot) {
        HashMap<String, Integer> segmentToLuceneVersion = new HashMap<String, Integer>();
        for (SegmentCommitInfo segmentCommitInfo : segmentInfosSnapshot) {
            SegmentInfo info = segmentCommitInfo.info;
            Set segFiles = info.files();
            for (String file : segFiles) {
                segmentToLuceneVersion.put(file, info.getVersion().major);
            }
        }
        for (String file : segmentFiles) {
            if (segmentToLuceneVersion.containsKey(file)) continue;
            if (file.equals(segmentInfosSnapshot.getSegmentsFileName())) {
                segmentToLuceneVersion.put(file, segmentInfosSnapshot.getCommitLuceneVersion().major);
                continue;
            }
            String segmentInfoFileName = RemoteStoreUtils.getSegmentName(file) + ".si";
            segmentToLuceneVersion.put(file, (Integer)segmentToLuceneVersion.get(segmentInfoFileName));
        }
        return segmentToLuceneVersion;
    }

    private void tryAndDeleteLocalFile(String filename, Directory directory) {
        try {
            this.logger.debug("Deleting file: " + filename);
            directory.deleteFile(filename);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.logger.trace("Exception while deleting. Missing file : " + filename, (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("Exception while deleting: " + filename, (Throwable)e);
        }
    }

    private String getChecksumOfLocalFile(Directory directory, String file) throws IOException {
        try (IndexInput indexInput = directory.openInput(file, IOContext.READONCE);){
            String string = Long.toString(CodecUtil.retrieveChecksum((IndexInput)indexInput));
            return string;
        }
    }

    public String getExistingRemoteFilename(String localFilename) {
        if (this.segmentsUploadedToRemoteStore.containsKey(localFilename)) {
            return this.segmentsUploadedToRemoteStore.get((Object)localFilename).uploadedFilename;
        }
        if (this.isMergedSegmentPendingDownload(localFilename)) {
            return this.pendingDownloadMergedSegments.get(localFilename);
        }
        return null;
    }

    private String getNewRemoteSegmentFilename(String localFilename) {
        return localFilename + SEGMENT_NAME_UUID_SEPARATOR + UUIDs.base64UUID();
    }

    private String getLocalSegmentFilename(String remoteFilename) {
        return remoteFilename.split(SEGMENT_NAME_UUID_SEPARATOR)[0];
    }

    public Map<String, UploadedSegmentMetadata> getSegmentsUploadedToRemoteStore() {
        return Collections.unmodifiableMap(this.segmentsUploadedToRemoteStore);
    }

    Set<String> getMetadataFilesToFilterActiveSegments(int lastNMetadataFilesToKeep, List<String> sortedMetadataFiles, Set<String> lockedMetadataFiles) {
        HashSet<String> metadataFilesToFilterActiveSegments = new HashSet<String>();
        for (int idx = lastNMetadataFilesToKeep; idx < sortedMetadataFiles.size(); ++idx) {
            String nextMetadata;
            if (lockedMetadataFiles.contains(sortedMetadataFiles.get(idx))) continue;
            String prevMetadata = idx - 1 >= 0 ? sortedMetadataFiles.get(idx - 1) : null;
            String string = nextMetadata = idx + 1 < sortedMetadataFiles.size() ? sortedMetadataFiles.get(idx + 1) : null;
            if (prevMetadata != null && (lockedMetadataFiles.contains(prevMetadata) || idx == lastNMetadataFilesToKeep)) {
                metadataFilesToFilterActiveSegments.add(prevMetadata);
            }
            if (nextMetadata == null || !lockedMetadataFiles.contains(nextMetadata)) continue;
            metadataFilesToFilterActiveSegments.add(nextMetadata);
        }
        return metadataFilesToFilterActiveSegments;
    }

    public void deleteStaleSegments(int lastNMetadataFilesToKeep) throws IOException {
        if (lastNMetadataFilesToKeep == -1) {
            this.logger.info("Stale segment deletion is disabled if cluster.remote_store.index.segment_metadata.retention.max_count is set to -1");
            return;
        }
        List<String> sortedMetadataFileList = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", Integer.MAX_VALUE);
        if (sortedMetadataFileList.size() <= lastNMetadataFilesToKeep) {
            this.logger.debug("Number of commits in remote segment store={}, lastNMetadataFilesToKeep={}", (Object)sortedMetadataFileList.size(), (Object)lastNMetadataFilesToKeep);
            return;
        }
        if (lastNMetadataFilesToKeep != 0 && RemoteStoreUtils.isPinnedTimestampStateStale()) {
            this.logger.warn("Skipping remote segment store garbage collection as last fetch of pinned timestamp is stale");
            return;
        }
        Tuple<Long, Set<Long>> pinnedTimestampsState = RemoteStorePinnedTimestampService.getPinnedTimestamps();
        HashSet<Long> pinnedTimestamps = new HashSet<Long>((Collection)pinnedTimestampsState.v2());
        pinnedTimestamps.add((Long)pinnedTimestampsState.v1());
        Set<String> implicitLockedFiles = RemoteStoreUtils.getPinnedTimestampLockedFiles(sortedMetadataFileList, pinnedTimestamps, this.metadataFilePinnedTimestampMap, MetadataFilenameUtils::getTimestamp, MetadataFilenameUtils::getNodeIdByPrimaryTermAndGen);
        HashSet<String> allLockFiles = new HashSet<String>(implicitLockedFiles);
        try {
            allLockFiles.addAll(((RemoteStoreMetadataLockManager)this.mdLockManager).fetchLockedMetadataFiles("metadata"));
        }
        catch (Exception e) {
            this.logger.error("Exception while fetching segment metadata lock files, skipping deleteStaleSegments", (Throwable)e);
            return;
        }
        List<String> metadataFilesEligibleToDelete = new ArrayList<String>(sortedMetadataFileList.subList(lastNMetadataFilesToKeep, sortedMetadataFileList.size()));
        long lastSuccessfulFetchOfPinnedTimestamps = (Long)pinnedTimestampsState.v1();
        metadataFilesEligibleToDelete = RemoteStoreUtils.filterOutMetadataFilesBasedOnAge(metadataFilesEligibleToDelete, MetadataFilenameUtils::getTimestamp, lastSuccessfulFetchOfPinnedTimestamps);
        if (metadataFilesEligibleToDelete.isEmpty()) {
            this.logger.debug("No metadata files are eligible to be deleted based on lastNMetadataFilesToKeep and age");
            return;
        }
        List metadataFilesToBeDeleted = metadataFilesEligibleToDelete.stream().filter(metadataFile -> !allLockFiles.contains(metadataFile)).collect(Collectors.toList());
        this.logger.debug("metadataFilesEligibleToDelete={} metadataFilesToBeDeleted={}", metadataFilesEligibleToDelete, metadataFilesToBeDeleted);
        HashMap<String, UploadedSegmentMetadata> activeSegmentFilesMetadataMap = new HashMap<String, UploadedSegmentMetadata>();
        HashSet activeSegmentRemoteFilenames = new HashSet();
        Set<String> metadataFilesToFilterActiveSegments = this.getMetadataFilesToFilterActiveSegments(sortedMetadataFileList.indexOf(metadataFilesEligibleToDelete.get(0)), sortedMetadataFileList, allLockFiles);
        for (String metadataFile2 : metadataFilesToFilterActiveSegments) {
            Map<String, UploadedSegmentMetadata> segmentMetadataMap = this.readMetadataFile(metadataFile2).getMetadata();
            activeSegmentFilesMetadataMap.putAll(segmentMetadataMap);
            activeSegmentRemoteFilenames.addAll(segmentMetadataMap.values().stream().map(metadata -> metadata.uploadedFilename).collect(Collectors.toSet()));
        }
        HashSet<String> deletedSegmentFiles = new HashSet<String>();
        for (String metadataFile3 : metadataFilesToBeDeleted) {
            Map<String, UploadedSegmentMetadata> staleSegmentFilesMetadataMap = this.readMetadataFile(metadataFile3).getMetadata();
            Set staleSegmentRemoteFilenames = staleSegmentFilesMetadataMap.values().stream().map(metadata -> metadata.uploadedFilename).collect(Collectors.toSet());
            List<String> filesToDelete = staleSegmentRemoteFilenames.stream().filter(file -> !activeSegmentRemoteFilenames.contains(file)).filter(file -> !deletedSegmentFiles.contains(file)).collect(Collectors.toList());
            AtomicBoolean deletionSuccessful = new AtomicBoolean(true);
            try {
                this.remoteDataDirectory.deleteFiles(filesToDelete);
                deletedSegmentFiles.addAll(filesToDelete);
                for (String file2 : filesToDelete) {
                    if (activeSegmentFilesMetadataMap.containsKey(this.getLocalSegmentFilename(file2))) continue;
                    this.segmentsUploadedToRemoteStore.remove(this.getLocalSegmentFilename(file2));
                }
            }
            catch (IOException e) {
                deletionSuccessful.set(false);
                this.logger.warn(() -> new ParameterizedMessage("Exception while deleting segment files corresponding to metadata file {}. Deletion will be re-tried", (Object)metadataFile3), (Throwable)e);
            }
            if (!deletionSuccessful.get()) continue;
            this.logger.debug("Deleting stale metadata file {} from remote segment store", (Object)metadataFile3);
            this.remoteMetadataDirectory.deleteFile(metadataFile3);
        }
        this.logger.debug("deletedSegmentFiles={}", deletedSegmentFiles);
    }

    public void deleteStaleSegmentsAsync(int lastNMetadataFilesToKeep) {
        this.deleteStaleSegmentsAsync(lastNMetadataFilesToKeep, (ActionListener<Void>)ActionListener.wrap(r -> {}, e -> {}));
    }

    public void deleteStaleSegmentsAsync(int lastNMetadataFilesToKeep, ActionListener<Void> listener) {
        if (this.canDeleteStaleCommits.compareAndSet(true, false)) {
            try {
                this.threadPool.executor("remote_purge").execute(() -> {
                    try {
                        this.deleteStaleSegments(lastNMetadataFilesToKeep);
                        listener.onResponse(null);
                    }
                    catch (Exception e) {
                        this.logger.error("Exception while deleting stale commits from remote segment store, will retry delete post next commit", (Throwable)e);
                        listener.onFailure(e);
                    }
                    finally {
                        this.canDeleteStaleCommits.set(true);
                    }
                });
            }
            catch (Exception e) {
                this.logger.error("Exception occurred while scheduling deleteStaleCommits", (Throwable)e);
                this.canDeleteStaleCommits.set(true);
                listener.onFailure(e);
            }
        }
    }

    public static void remoteDirectoryCleanup(RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory, String remoteStoreRepoForIndex, String indexUUID, ShardId shardId, RemoteStorePathStrategy pathStrategy, boolean forceClean) {
        try {
            RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = (RemoteSegmentStoreDirectory)remoteDirectoryFactory.newDirectory(remoteStoreRepoForIndex, indexUUID, shardId, pathStrategy);
            if (forceClean) {
                remoteSegmentStoreDirectory.delete();
            } else {
                remoteSegmentStoreDirectory.deleteStaleSegments(0);
                remoteSegmentStoreDirectory.deleteIfEmpty();
            }
        }
        catch (Exception e) {
            staticLogger.error("Exception occurred while deleting directory", (Throwable)e);
        }
    }

    private boolean deleteIfEmpty() throws IOException {
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", 1);
        if (metadataFiles.size() != 0) {
            this.logger.info("Remote directory still has files, not deleting the path");
            return false;
        }
        return this.delete();
    }

    public boolean delete() {
        try {
            this.remoteDataDirectory.delete();
            this.remoteMetadataDirectory.delete();
            this.mdLockManager.delete();
        }
        catch (Exception e) {
            this.logger.error("Exception occurred while deleting directory", (Throwable)e);
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        this.deleteStaleSegmentsAsync(0, (ActionListener<Void>)ActionListener.wrap(r -> this.deleteIfEmpty(), e -> this.logger.error("Failed to cleanup remote directory")));
    }

    public void markMergedSegmentsPendingDownload(Map<String, String> localToRemoteFilenames) {
        this.pendingDownloadMergedSegments.putAll(localToRemoteFilenames);
    }

    public void unmarkMergedSegmentsPendingDownload(Set<String> localFilenames) {
        localFilenames.forEach(this.pendingDownloadMergedSegments::remove);
    }

    public boolean isMergedSegmentPendingDownload(String localFilename) {
        return this.pendingDownloadMergedSegments != null && this.pendingDownloadMergedSegments.containsKey(localFilename);
    }

    public static class MetadataFilenameUtils {
        public static final String SEPARATOR = "__";
        public static final String METADATA_PREFIX = "metadata";

        static String getMetadataFilePrefixForCommit(long primaryTerm, long generation) {
            return String.join((CharSequence)"__", METADATA_PREFIX, RemoteStoreUtils.invertLong(primaryTerm), RemoteStoreUtils.invertLong(generation));
        }

        public static String getMetadataFilename(long primaryTerm, long generation, long translogGeneration, long uploadCounter, int metadataVersion, String nodeId, long creationTimestamp) {
            return String.join((CharSequence)"__", METADATA_PREFIX, RemoteStoreUtils.invertLong(primaryTerm), RemoteStoreUtils.invertLong(generation), RemoteStoreUtils.invertLong(translogGeneration), RemoteStoreUtils.invertLong(uploadCounter), String.valueOf(Objects.hash(nodeId)), RemoteStoreUtils.invertLong(creationTimestamp), String.valueOf(metadataVersion));
        }

        public static String getMetadataFilename(long primaryTerm, long generation, long translogGeneration, long uploadCounter, int metadataVersion, String nodeId) {
            return MetadataFilenameUtils.getMetadataFilename(primaryTerm, generation, translogGeneration, uploadCounter, metadataVersion, nodeId, System.currentTimeMillis());
        }

        static long getPrimaryTerm(String[] filenameTokens) {
            return RemoteStoreUtils.invertLong(filenameTokens[1]);
        }

        static long getGeneration(String[] filenameTokens) {
            return RemoteStoreUtils.invertLong(filenameTokens[2]);
        }

        public static long getTimestamp(String filename) {
            String[] filenameTokens = filename.split("__");
            return RemoteStoreUtils.invertLong(filenameTokens[filenameTokens.length - 2]);
        }

        public static Tuple<String, String> getNodeIdByPrimaryTermAndGen(String filename) {
            String[] tokens = filename.split("__");
            if (tokens.length < 8) {
                return null;
            }
            String primaryTermAndGen = String.join((CharSequence)"__", tokens[1], tokens[2], tokens[3]);
            String nodeId = tokens[5];
            return new Tuple((Object)primaryTermAndGen, (Object)nodeId);
        }
    }

    @PublicApi(since="2.3.0")
    public static class UploadedSegmentMetadata {
        static final String SEPARATOR = "::";
        private final String originalFilename;
        private final String uploadedFilename;
        private final String checksum;
        private final long length;
        private int writtenByMajor;

        UploadedSegmentMetadata(String originalFilename, String uploadedFilename, String checksum, long length) {
            this.originalFilename = originalFilename;
            this.uploadedFilename = uploadedFilename;
            this.checksum = checksum;
            this.length = length;
        }

        public String toString() {
            return String.join((CharSequence)SEPARATOR, this.originalFilename, this.uploadedFilename, this.checksum, String.valueOf(this.length), String.valueOf(this.writtenByMajor));
        }

        public String getChecksum() {
            return this.checksum;
        }

        public long getLength() {
            return this.length;
        }

        public static UploadedSegmentMetadata fromString(String uploadedFilename) {
            String[] values = uploadedFilename.split(SEPARATOR);
            UploadedSegmentMetadata metadata = new UploadedSegmentMetadata(values[0], values[1], values[2], Long.parseLong(values[3]));
            if (values.length < 5) {
                staticLogger.error("Lucene version is missing for UploadedSegmentMetadata: " + uploadedFilename);
            }
            metadata.setWrittenByMajor(Integer.parseInt(values[4]));
            return metadata;
        }

        public String getOriginalFilename() {
            return this.originalFilename;
        }

        public String getUploadedFilename() {
            return this.uploadedFilename;
        }

        public void setWrittenByMajor(int writtenByMajor) {
            if (writtenByMajor > Version.LATEST.major || writtenByMajor < Version.MIN_SUPPORTED_MAJOR) {
                throw new IllegalArgumentException("Lucene major version supplied (" + writtenByMajor + ") is incorrect. Should be between Version.LATEST (" + Version.LATEST.major + ") and Version.MIN_SUPPORTED_MAJOR (" + Version.MIN_SUPPORTED_MAJOR + ").");
            }
            this.writtenByMajor = writtenByMajor;
        }
    }
}

