/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.common;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Objects;
import org.opensearch.common.Numbers;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.protobufs.FieldValue;
import org.opensearch.protobufs.GeneralNumber;

public class FieldValueProtoUtils {
    private FieldValueProtoUtils() {
    }

    public static FieldValue toProto(Object javaObject) {
        FieldValue.Builder fieldValueBuilder = FieldValue.newBuilder();
        FieldValueProtoUtils.toProto(javaObject, fieldValueBuilder);
        return fieldValueBuilder.build();
    }

    public static void toProto(Object javaObject, FieldValue.Builder fieldValueBuilder) {
        if (javaObject == null) {
            throw new IllegalArgumentException("Cannot convert null to FieldValue");
        }
        Object object = javaObject;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class, Enum.class, BigInteger.class}, (Object)object2, n)) {
            case 0: {
                String s = (String)object2;
                fieldValueBuilder.setString(s);
                break;
            }
            case 1: {
                Integer i = (Integer)object2;
                GeneralNumber.Builder num = GeneralNumber.newBuilder();
                num.setInt32Value(i.intValue());
                fieldValueBuilder.setGeneralNumber(num.build());
                break;
            }
            case 2: {
                Long l = (Long)object2;
                GeneralNumber.Builder num = GeneralNumber.newBuilder();
                num.setInt64Value(l.longValue());
                fieldValueBuilder.setGeneralNumber(num.build());
                break;
            }
            case 3: {
                Double d = (Double)object2;
                GeneralNumber.Builder num = GeneralNumber.newBuilder();
                num.setDoubleValue(d.doubleValue());
                fieldValueBuilder.setGeneralNumber(num.build());
                break;
            }
            case 4: {
                Float f = (Float)object2;
                GeneralNumber.Builder num = GeneralNumber.newBuilder();
                num.setFloatValue(f.floatValue());
                fieldValueBuilder.setGeneralNumber(num.build());
                break;
            }
            case 5: {
                Boolean b = (Boolean)object2;
                fieldValueBuilder.setBool(b.booleanValue());
                break;
            }
            case 6: {
                Enum e = (Enum)object2;
                fieldValueBuilder.setString(e.toString());
                break;
            }
            case 7: {
                BigInteger bi = (BigInteger)object2;
                Numbers.toUnsignedLongExact((Number)bi);
                GeneralNumber.Builder num = GeneralNumber.newBuilder();
                num.setUint64Value(bi.longValue());
                fieldValueBuilder.setGeneralNumber(num.build());
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(javaObject) + " to FieldValue");
            }
        }
    }

    public static Object fromProto(FieldValue fieldValue) {
        return FieldValueProtoUtils.fromProto(fieldValue, true);
    }

    public static Object fromProto(FieldValue fieldValue, boolean convertStringsToBytesRef) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue.hasGeneralNumber()) {
            GeneralNumber generalNumber = fieldValue.getGeneralNumber();
            switch (generalNumber.getValueCase()) {
                case INT32_VALUE: {
                    return generalNumber.getInt32Value();
                }
                case INT64_VALUE: {
                    return generalNumber.getInt64Value();
                }
                case FLOAT_VALUE: {
                    return Float.valueOf(generalNumber.getFloatValue());
                }
                case DOUBLE_VALUE: {
                    return generalNumber.getDoubleValue();
                }
                case UINT64_VALUE: {
                    long uint64Value = generalNumber.getUint64Value();
                    if (uint64Value < 0L) {
                        return Numbers.toUnsignedBigInteger((long)uint64Value);
                    }
                    return uint64Value;
                }
            }
            throw new IllegalArgumentException("Unsupported general number type: " + String.valueOf(generalNumber.getValueCase()));
        }
        if (fieldValue.hasString()) {
            return convertStringsToBytesRef ? AbstractQueryBuilder.maybeConvertToBytesRef((Object)fieldValue.getString()) : fieldValue.getString();
        }
        if (fieldValue.hasBool()) {
            return fieldValue.getBool();
        }
        if (fieldValue.hasNullValue()) {
            return null;
        }
        throw new IllegalArgumentException("FieldValue type not recognized");
    }
}

