/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state.threshold;

import com.amazon.randomcutforest.parkservices.state.statistics.DeviationMapper;
import com.amazon.randomcutforest.parkservices.state.threshold.BasicThresholderState;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.state.IStateMapper;

public class BasicThresholderMapper
implements IStateMapper<BasicThresholder, BasicThresholderState> {
    public BasicThresholder toModel(BasicThresholderState state, long seed) {
        DeviationMapper deviationMapper = new DeviationMapper();
        Deviation primaryDeviation = (Deviation)deviationMapper.toModel(state.getPrimaryDeviationState());
        Deviation secondaryDeviation = (Deviation)deviationMapper.toModel(state.getSecondaryDeviationState());
        Deviation thresholdDeviation = (Deviation)deviationMapper.toModel(state.getThresholdDeviationState());
        BasicThresholder thresholder = new BasicThresholder(primaryDeviation, secondaryDeviation, thresholdDeviation);
        thresholder.setAbsoluteThreshold(state.getAbsoluteThreshold());
        thresholder.setLowerThreshold(state.getLowerThreshold(), state.isAutoThreshold());
        thresholder.setUpperThreshold(state.getUpperThreshold());
        thresholder.setInitialThreshold(state.getInitialThreshold());
        thresholder.setElasticity(state.getElasticity());
        thresholder.setInPotentialAnomaly(state.isInAnomaly());
        thresholder.setHorizon(state.getHorizon());
        thresholder.setCount(state.getCount());
        thresholder.setMinimumScores(state.getMinimumScores());
        thresholder.setAbsoluteScoreFraction(state.getAbsoluteScoreFraction());
        thresholder.setUpperZfactor(state.getUpperZfactor());
        thresholder.setZfactor(state.getZFactor());
        return thresholder;
    }

    public BasicThresholderState toState(BasicThresholder model) {
        BasicThresholderState state = new BasicThresholderState();
        DeviationMapper deviationMapper = new DeviationMapper();
        state.setZFactor(model.getZFactor());
        state.setUpperZfactor(model.getUpperZfactor());
        state.setUpperThreshold(model.getUpperThreshold());
        state.setLowerThreshold(model.getLowerThreshold());
        state.setAbsoluteThreshold(model.getAbsoluteThreshold());
        state.setInitialThreshold(model.getInitialThreshold());
        state.setAbsoluteScoreFraction(model.getAbsoluteScoreFraction());
        state.setElasticity(model.getElasticity());
        state.setCount(model.getCount());
        state.setInAnomaly(model.isInPotentialAnomaly());
        state.setAutoThreshold(model.isAutoThreshold());
        state.setMinimumScores(model.getMinimumScores());
        state.setPrimaryDeviationState(deviationMapper.toState(model.getPrimaryDeviation()));
        state.setSecondaryDeviationState(deviationMapper.toState(model.getSecondaryDeviation()));
        state.setThresholdDeviationState(deviationMapper.toState(model.getThresholdDeviation()));
        state.setHorizon(model.getHorizon());
        return state;
    }
}

