/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.response;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.ConfigurableName;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.columnar.ResponseProcessor;
import org.tribuo.data.columnar.processors.response.Quartile;

public class QuartileResponseProcessor<T extends Output<T>>
implements ResponseProcessor<T> {
    @Config(mandatory=true, description="The string to emit.")
    @Deprecated
    private String name;
    @Config(description="The field name to read.")
    @Deprecated
    private String fieldName;
    @Config(description="The quartile to use.")
    private Quartile quartile;
    @Config(mandatory=true, description="The output factory to use.")
    private OutputFactory<T> outputFactory;
    @Config(description="A list of field names to read, you should use only one of this or fieldName.")
    private List<String> fieldNames;
    @Config(description="A list of quartiles to use, should have the same length as fieldNames")
    private List<Quartile> quartiles;
    @ConfigurableName
    private String configName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postConfig() throws PropertyException, IOException {
        if (this.fieldName != null && this.fieldNames != null) {
            throw new PropertyException(this.configName, "fieldName, FieldNames", "only one of fieldName or fieldNames can be populated");
        }
        if (this.fieldNames != null) {
            if (this.quartile == null) {
                throw new PropertyException(this.configName, "quartile, quartiles", "one of quartile or quartiles must be populated");
            }
            this.quartiles = this.quartiles == null ? Collections.nCopies(this.fieldNames.size(), this.quartile) : this.quartiles;
            if (this.quartiles.size() == this.fieldNames.size()) return;
            throw new PropertyException(this.configName, "quartiles", "must either be empty or match the length of fieldNames");
        }
        if (this.fieldName == null) throw new PropertyException(this.configName, "fieldName, fieldNames", "One of fieldName or fieldNames must be populated");
        if (this.quartiles != null) {
            throw new PropertyException(this.configName, "quartiles", "if fieldName is populated, quartiles must be blank");
        }
        this.fieldNames = Collections.singletonList(this.fieldName);
        if (this.quartile == null) throw new PropertyException(this.configName, "quartile", "if fieldName is populated, quartile must be populated");
        this.quartiles = Collections.singletonList(this.quartile);
    }

    private QuartileResponseProcessor() {
    }

    public QuartileResponseProcessor(String name, String fieldName, Quartile quartile, OutputFactory<T> outputFactory) {
        this(Collections.singletonList(fieldName), Collections.singletonList(quartile), outputFactory);
        this.name = name;
    }

    public QuartileResponseProcessor(List<String> fieldNames, List<Quartile> quartiles, OutputFactory<T> outputFactory) {
        this.fieldNames = fieldNames;
        this.quartiles = quartiles;
        this.outputFactory = outputFactory;
    }

    @Override
    @Deprecated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    @Override
    @Deprecated
    public String getFieldName() {
        return this.fieldNames.get(0);
    }

    @Override
    @Deprecated
    public Optional<T> process(String value) {
        if (value == null) {
            return Optional.of(this.outputFactory.generateOutput((Object)(this.name + ":NONE")));
        }
        double dv = Double.parseDouble(value);
        Output output = dv <= this.quartile.getLowerMedian() ? this.outputFactory.generateOutput((Object)(this.name + ":first")) : (dv > this.quartile.getLowerMedian() && dv <= this.quartile.getMedian() ? this.outputFactory.generateOutput((Object)(this.name + ":second")) : (dv > this.quartile.getMedian() && dv <= this.quartile.getUpperMedian() ? this.outputFactory.generateOutput((Object)(this.name + ":third")) : this.outputFactory.generateOutput((Object)(this.name + ":fourth"))));
        return Optional.of(output);
    }

    @Override
    public Optional<T> process(List<String> values) {
        if (values.size() != this.fieldNames.size()) {
            throw new IllegalArgumentException("values must have the same length as fieldNames. Got values: " + values.size() + " fieldNames: " + this.fieldNames.size());
        }
        ArrayList<String> response = new ArrayList<String>();
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String value = values.get(i);
            String prefix = this.name == null || this.name.isEmpty() ? this.fieldNames.get(i) : this.name;
            Quartile q = this.quartiles.get(i);
            if (value == null) {
                response.add(prefix + ":NONE");
                continue;
            }
            double dv = Double.parseDouble(value);
            if (dv <= q.getLowerMedian()) {
                response.add(prefix + ":first");
                continue;
            }
            if (dv > q.getLowerMedian() && dv <= q.getMedian()) {
                response.add(prefix + ":second");
                continue;
            }
            if (dv > q.getMedian() && dv <= q.getUpperMedian()) {
                response.add(prefix + ":third");
                continue;
            }
            response.add(prefix + ":fourth");
        }
        return Optional.of(this.outputFactory.generateOutput(response.size() == 1 ? response.get(0) : response));
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return "QuartileResponseProcessor(fieldNames=" + this.fieldNames.toString() + ",quartiles=" + this.quartiles.toString() + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "ResponseProcessor");
    }
}

