/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Visual
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 32;
    }

    @Override
    public int getDataSize() {
        return Visual.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public Visual(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public Visual() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Visual.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(n * 16)) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_visualid() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_visualid(long l) {
        log.finest("");
        Native.putLong(this.pData + 4L, l);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_class(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public long get_red_mask() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_red_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 12L, l);
    }

    public long get_green_mask() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_green_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 16L, l);
    }

    public long get_blue_mask() {
        log.finest("");
        return Native.getLong(this.pData + 20L);
    }

    public void set_blue_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 20L, l);
    }

    public int get_bits_per_rgb() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_bits_per_rgb(int n) {
        log.finest("");
        Native.putInt(this.pData + 24L, n);
    }

    public int get_map_entries() {
        log.finest("");
        return Native.getInt(this.pData + 28L);
    }

    public void set_map_entries(int n) {
        log.finest("");
        Native.putInt(this.pData + 28L, n);
    }

    @Override
    String getName() {
        return "Visual";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(320);
        stringBuilder.append("ext_data = ").append(this.get_ext_data()).append(", ");
        stringBuilder.append("visualid = ").append(this.get_visualid()).append(", ");
        stringBuilder.append("class = ").append(this.get_class()).append(", ");
        stringBuilder.append("red_mask = ").append(this.get_red_mask()).append(", ");
        stringBuilder.append("green_mask = ").append(this.get_green_mask()).append(", ");
        stringBuilder.append("blue_mask = ").append(this.get_blue_mask()).append(", ");
        stringBuilder.append("bits_per_rgb = ").append(this.get_bits_per_rgb()).append(", ");
        stringBuilder.append("map_entries = ").append(this.get_map_entries()).append(", ");
        return stringBuilder.toString();
    }
}

