/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEditorKitOntologyShortFormProvider;
import org.protege.editor.owl.model.OWLEditorKitShortFormProvider;
import org.protege.editor.owl.model.search.AxiomBasedSearchMetadataImporter;
import org.protege.editor.owl.model.search.EntityBasedSearchMDImporter;
import org.protege.editor.owl.model.search.OntologyBasedSearchMDImporter;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchMetadataDB;
import org.protege.editor.owl.model.search.SearchMetadataImportContext;
import org.protege.editor.owl.model.search.SearchMetadataImporter;
import org.protege.editor.owl.model.search.importer.AxiomAnnotationSearchMetadataImporter;
import org.protege.editor.owl.model.search.importer.DisplayNameSearchMetadataImporter;
import org.protege.editor.owl.model.search.importer.EntityAnnotationValueSearchMetadataImporter;
import org.protege.editor.owl.model.search.importer.EntityIRISearchMetadataImporter;
import org.protege.editor.owl.model.search.importer.LogicalAxiomRenderingSearchMetadataImporter;
import org.protege.editor.owl.model.search.importer.OntologyAnnotationSearchMetadataImporter;
import org.protege.editor.owl.ui.renderer.context.OWLObjectRenderingContext;
import org.protege.editor.owl.ui.renderer.styledstring.OWLObjectStyledStringRenderer;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.AxiomSubjectProvider;

public class DefaultSearchMetadataImporter
implements SearchMetadataImporter {
    @Override
    public SearchMetadataDB getSearchMetadata(OWLEditorKit editorKit, Set<SearchCategory> categories) {
        SearchMetadataImportContext context = new SearchMetadataImportContext(editorKit);
        SearchMetadataDB db = new SearchMetadataDB();
        this.getEntityBasedSearchMetadata(categories, context, db);
        this.getAxiomBasedSearchMetadata(categories, context, db);
        this.getOntologyBasedSearchMetadata(categories, context, db);
        return db;
    }

    private void getEntityBasedSearchMetadata(Set<SearchCategory> categories, SearchMetadataImportContext context, SearchMetadataDB db) {
        List<EntityBasedSearchMDImporter> importers = this.getEntityBasedSearchMetadataImporters(categories);
        HashSet<OWLEntity> processed = new HashSet<OWLEntity>();
        for (OWLOntology ontology : context.getOntologies()) {
            for (OWLEntity entity : ontology.getSignature()) {
                if (!processed.add(entity)) continue;
                this.getSearchMetadataForEntity(entity, context, db, importers);
            }
        }
    }

    private void getSearchMetadataForEntity(OWLEntity entity, SearchMetadataImportContext context, SearchMetadataDB db, List<EntityBasedSearchMDImporter> importers) {
        String entityRendering = context.getRendering((OWLObject)entity);
        for (EntityBasedSearchMDImporter importer : importers) {
            importer.generateSearchMetadataFor(entity, entityRendering, context, db);
        }
    }

    private void getAxiomBasedSearchMetadata(Set<SearchCategory> categories, SearchMetadataImportContext context, SearchMetadataDB db) {
        for (AxiomType axiomType : AxiomType.AXIOM_TYPES) {
            this.getSearchMetadataForAxiomsOfType(axiomType, categories, context, db);
        }
    }

    private void getSearchMetadataForAxiomsOfType(AxiomType<?> axiomType, Set<SearchCategory> categories, SearchMetadataImportContext context, SearchMetadataDB db) {
        for (AxiomBasedSearchMetadataImporter importer : this.getAxiomBasedSearchMetadataImporters(categories, axiomType)) {
            for (OWLOntology ontology : context.getOntologies()) {
                for (OWLAxiom ax : ontology.getAxioms(axiomType)) {
                    OWLObject subject = new AxiomSubjectProvider().getSubject(ax);
                    if (!(subject instanceof OWLEntity)) continue;
                    OWLEntity entSubject = (OWLEntity)subject;
                    String rendering = context.getRendering((OWLObject)entSubject);
                    importer.generateSearchMetadataFor(ax, entSubject, rendering, context, db);
                }
            }
        }
    }

    private void getOntologyBasedSearchMetadata(Set<SearchCategory> categories, SearchMetadataImportContext context, SearchMetadataDB db) {
        List<OntologyBasedSearchMDImporter> ontologyBasedSearchMDImporters = this.getOntologyBasedSearchMetadataImporters(categories);
        for (OWLOntology ontology : context.getOntologies()) {
            for (OntologyBasedSearchMDImporter importer : ontologyBasedSearchMDImporters) {
                importer.generateSearchMetadata(ontology, context, db);
            }
        }
    }

    private StyledString getStyledStringRendering(OWLEditorKit editorKit, OWLObject object) {
        OWLEditorKitShortFormProvider sfp = new OWLEditorKitShortFormProvider(editorKit);
        OWLEditorKitOntologyShortFormProvider ontologySfp = new OWLEditorKitOntologyShortFormProvider(editorKit);
        OWLObjectRenderingContext renderingContext = new OWLObjectRenderingContext(sfp, ontologySfp);
        OWLObjectStyledStringRenderer renderer = new OWLObjectStyledStringRenderer(renderingContext);
        return renderer.getRendering(object);
    }

    private List<EntityBasedSearchMDImporter> getEntityBasedSearchMetadataImporters(Set<SearchCategory> categories) {
        ArrayList<EntityBasedSearchMDImporter> entityBasedSearchMDImporters = new ArrayList<EntityBasedSearchMDImporter>();
        entityBasedSearchMDImporters.add(new DisplayNameSearchMetadataImporter());
        entityBasedSearchMDImporters.add(new EntityIRISearchMetadataImporter());
        entityBasedSearchMDImporters.add(new EntityAnnotationValueSearchMetadataImporter());
        ArrayList<EntityBasedSearchMDImporter> result = new ArrayList<EntityBasedSearchMDImporter>();
        for (EntityBasedSearchMDImporter importer : entityBasedSearchMDImporters) {
            if (!importer.isImporterFor(categories)) continue;
            result.add(importer);
        }
        return result;
    }

    private List<AxiomBasedSearchMetadataImporter> getAxiomBasedSearchMetadataImporters(Set<SearchCategory> categories, AxiomType<?> axiomType) {
        ArrayList<AxiomBasedSearchMetadataImporter> axiomBasedSearchMetadataImporters = new ArrayList<AxiomBasedSearchMetadataImporter>();
        axiomBasedSearchMetadataImporters.add(new AxiomAnnotationSearchMetadataImporter());
        axiomBasedSearchMetadataImporters.add(new LogicalAxiomRenderingSearchMetadataImporter());
        ArrayList<AxiomBasedSearchMetadataImporter> result = new ArrayList<AxiomBasedSearchMetadataImporter>();
        for (AxiomBasedSearchMetadataImporter importer : axiomBasedSearchMetadataImporters) {
            if (!importer.isImporterFor(axiomType, categories)) continue;
            result.add(importer);
        }
        return result;
    }

    private List<OntologyBasedSearchMDImporter> getOntologyBasedSearchMetadataImporters(Set<SearchCategory> categories) {
        ArrayList<OntologyAnnotationSearchMetadataImporter> ontologyBasedSearchMDImporters = new ArrayList<OntologyAnnotationSearchMetadataImporter>();
        ontologyBasedSearchMDImporters.add(new OntologyAnnotationSearchMetadataImporter());
        ArrayList<OntologyBasedSearchMDImporter> result = new ArrayList<OntologyBasedSearchMDImporter>();
        for (OntologyBasedSearchMDImporter ontologyBasedSearchMDImporter : ontologyBasedSearchMDImporters) {
            if (!ontologyBasedSearchMDImporter.isImporterFor(categories)) continue;
            result.add(ontologyBasedSearchMDImporter);
        }
        return result;
    }
}

