/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.ermodel.associations.ExtensionTableMatcher;
import schemacrawler.ermodel.associations.IdMatcher;
import schemacrawler.ermodel.associations.ImplicitAssociationsAnalyzer;
import schemacrawler.ermodel.associations.TableMatchKeys;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import us.fatehi.utility.Builder;

public class ImplicitAssociationsAnalyzerBuilder
implements Builder<ImplicitAssociationsAnalyzer> {
    private final TableMatchKeys tableMatchKeys;
    private Predicate<ColumnReference> implicitAssociationsRule;

    public static ImplicitAssociationsAnalyzerBuilder builder(Collection<Table> allTables) {
        Objects.requireNonNull(allTables, "No tables provided");
        ArrayList<Table> tables = new ArrayList<Table>(allTables);
        Collections.sort(tables);
        return new ImplicitAssociationsAnalyzerBuilder(List.copyOf(tables));
    }

    private ImplicitAssociationsAnalyzerBuilder(List<Table> allTables) {
        this.tableMatchKeys = new TableMatchKeys(allTables);
        this.implicitAssociationsRule = colRef -> false;
    }

    @Override
    public ImplicitAssociationsAnalyzer build() {
        return new ImplicitAssociationsAnalyzer(this.tableMatchKeys, this.implicitAssociationsRule);
    }

    public ImplicitAssociationsAnalyzerBuilder withExtensionTableMatcher() {
        this.implicitAssociationsRule = this.implicitAssociationsRule.or(new ExtensionTableMatcher(this.tableMatchKeys));
        return this;
    }

    public ImplicitAssociationsAnalyzerBuilder withIdMatcher() {
        this.implicitAssociationsRule = this.implicitAssociationsRule.or(new IdMatcher());
        return this;
    }
}

