/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintDispatch;
import schemacrawler.tools.lint.LintUtility;
import schemacrawler.tools.lint.Linter;
import schemacrawler.tools.lint.LinterInitializer;
import schemacrawler.tools.lint.Lints;
import schemacrawler.tools.lint.config.LinterConfig;
import schemacrawler.tools.lint.config.LinterConfigs;
import us.fatehi.utility.string.StringFormat;

public final class Linters {
    private static final Logger LOGGER = Logger.getLogger(Linters.class.getName());
    private final LinterConfigs linterConfigs;
    private final boolean runAllLinters;
    private List<Linter> linters;
    private LintCollector collector;

    public Linters(LinterConfigs linterConfigs, boolean runAllLinters) {
        this.linterConfigs = Objects.requireNonNull(linterConfigs, "No linter configs provided");
        this.runAllLinters = runAllLinters;
        this.linters = new ArrayList<Linter>();
        this.collector = new LintCollector();
    }

    public void dispatch(LintDispatch lintDispatch) {
        LOGGER.log(Level.INFO, this::getLintSummary);
        if (lintDispatch == null || lintDispatch == LintDispatch.none) {
            return;
        }
        if (!this.linters.isEmpty() && this.exceedsThreshold()) {
            LOGGER.log(Level.INFO, "Dispatching lint results");
            System.err.println(this.getLintSummary());
            lintDispatch.dispatch();
        }
    }

    public boolean exceedsThreshold() {
        for (Linter linter : this.linters) {
            if (!linter.exceedsThreshold()) continue;
            return true;
        }
        return false;
    }

    public Lints getLints() {
        return new Lints(this.collector.getLints());
    }

    public String getLintSummary() {
        ArrayList<Linter> linters = new ArrayList<Linter>(this.linters);
        linters.sort(LintUtility.LINTER_COMPARATOR);
        StringBuilder buffer = new StringBuilder(1024);
        for (Linter linter : linters) {
            if (linter.getLintCount() <= 0) continue;
            buffer.append("%10s%s %5d - %s%n".formatted("[" + String.valueOf((Object)linter.getSeverity()) + "]", linter.exceedsThreshold() ? "*" : " ", linter.getLintCount(), linter.getSummary()));
        }
        if (!buffer.isEmpty()) {
            buffer.insert(0, "Summary of schema lints:\n");
        }
        return buffer.toString();
    }

    public void initialize(LinterInitializer linterInitializer) {
        Objects.requireNonNull(linterInitializer, "No linter initializer provided");
        this.linters = new ArrayList<Linter>();
        this.collector = new LintCollector();
        Set<String> registeredLinters = linterInitializer.getRegisteredLinters();
        for (LinterConfig linterConfig : this.linterConfigs) {
            if (linterConfig == null) continue;
            String linterId = linterConfig.getLinterId();
            registeredLinters.remove(linterId);
            if (!linterConfig.isRunLinter()) {
                LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Not running configured linter <%s>", new Object[]{linterConfig}));
                continue;
            }
            Linter linter = linterInitializer.newLinter(linterId, this.collector);
            if (linter == null) continue;
            linter.configure(linterConfig);
            this.linters.add(linter);
        }
        if (this.runAllLinters) {
            for (String linterId : registeredLinters) {
                Linter linter = linterInitializer.newLinter(linterId, this.collector);
                this.linters.add(linter);
            }
        }
    }

    public void lint(Catalog catalog, Connection connection) {
        Objects.requireNonNull(this.linters, "No linters provided");
        Objects.requireNonNull(this.collector, "No lint collectpr provided");
        if (this.linters.isEmpty()) {
            return;
        }
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(connection, "No connection provided");
        this.runLinters(catalog, connection);
    }

    public int size() {
        return this.linters.size();
    }

    private void runLinters(Catalog catalog, Connection connection) {
        this.linters.parallelStream().forEach(linter -> {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Linting with <%s>", new Object[]{linter.getLinterInstanceId()}));
            try {
                linter.initialize();
                linter.setCatalog(catalog);
                if (linter.usesConnection()) {
                    linter.setConnection(connection);
                }
                linter.call();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not run linter <%s>", new Object[]{linter.getLinterInstanceId()}));
            }
        });
    }
}

