/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    OracleStatement.SqlKind sqlKind;
    int sqlParserParamCount;
    String[] sqlParserParamList;
    boolean useNamedParameter;
    int current_argument;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    static final char QMARK = '?';
    int[] returnTypes;
    private boolean isInitialized;
    Accessor[] returnAccessors;
    private static final ThreadLocal<OracleSql> SQL_PARSER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    AutoKeyInfo(String sql) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$29, null, sql);
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.isInitialized = false;
            this.originalSql = sql;
            this.autoKeyType = 0;
            this.returnTypes = new int[1];
            this.returnTypes[0] = 104;
            this.isInitialized = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$29, null);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$29, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    AutoKeyInfo(String sql, String[] colNames) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$30, null, sql, colNames);
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.isInitialized = false;
            this.originalSql = sql;
            this.columnNames = colNames;
            this.autoKeyType = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$30, null);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    AutoKeyInfo(String sql, int[] colIndexes) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$31, null, sql, colIndexes);
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.isInitialized = false;
            this.originalSql = sql;
            this.columnIndexes = colIndexes;
            this.autoKeyType = 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    private void parseSql() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.originalSql == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            OracleSql sqlParser = SQL_PARSER.get();
            sqlParser.initialize(this.originalSql);
            this.sqlKind = sqlParser.getSqlKind();
            if (this.sqlKind == OracleStatement.SqlKind.INSERT) {
                this.sqlParserParamCount = sqlParser.getParameterCount();
                this.sqlParserParamList = sqlParser.getParameterList();
                if (this.sqlParserParamList == OracleSql.EMPTY_LIST) {
                    this.useNamedParameter = false;
                } else {
                    this.useNamedParameter = true;
                    this.current_argument = this.sqlParserParamCount;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    private String generateUniqueNamedParameter() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String nextArg;
            boolean retry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$1, this, new Object[0]);
            }
            block2: do {
                retry = false;
                nextArg = Integer.toString(++this.current_argument).intern();
                for (int i2 = 0; i2 < this.sqlParserParamCount; ++i2) {
                    if (this.sqlParserParamList[i2] != nextArg) continue;
                    retry = true;
                    continue block2;
                }
            } while (retry);
            String string = ":" + nextArg;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    String getNewSql() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block16: {
                block14: {
                    String string2;
                    block15: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, new Object[0]);
                        }
                        try {
                            if (this.newSql == null) break block14;
                            string2 = this.newSql;
                            if (!bl) break block15;
                        }
                        catch (Exception e2) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, sQLException);
                            }
                            throw sQLException;
                        }
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, string2);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, null);
                    }
                    return string2;
                }
                if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                    this.parseSql();
                }
                switch (this.autoKeyType) {
                    case 0: {
                        this.newSql = this.originalSql + " RETURNING ROWID INTO " + (Serializable)(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
                        break;
                    }
                    case 1: {
                        this.getNewSqlByColumnName();
                        break;
                    }
                    case 2: {
                        this.getNewSqlByColumnIndexes();
                    }
                }
                this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
                this.sqlParserParamList = null;
                string = this.newSql;
                if (!bl) break block16;
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isInitialized() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$3, this, new Object[0]);
            }
            boolean bl2 = this.isInitialized;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initialize(PhysicalConnection physicalConnection) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$4, this, physicalConnection);
            }
            if (!this.isInitialized) {
                void connection;
                connection.doDescribeTable(this);
                this.setInitialized();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    CompletionStage<Void> initializeAsync(PhysicalConnection physicalConnection) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$5, this, physicalConnection);
            }
            if (!this.isInitialized) {
                void connection;
                CompletionStage<Void> completionStage = connection.doDescribeTableAsync(this).thenRun(this::setInitialized);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$5, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$5, this, null);
                }
                return completionStage;
            }
            CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$5, this, completableFuture);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$5, this, null);
            }
            return completableFuture;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    private void setInitialized() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.autoKeyType == 1) {
                this.initializeIndexesAndTypesByName();
            }
            this.isInitialized = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initializeIndexesAndTypesByName() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$7, this, new Object[0]);
            }
            this.returnTypes = new int[this.columnNames.length];
            this.columnIndexes = new int[this.columnNames.length];
            for (int i2 = 0; i2 < this.columnNames.length; ++i2) {
                int type;
                this.returnTypes[i2] = type = this.getReturnParamTypeCode(i2, this.columnNames[i2], this.columnIndexes);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    private String getNewSqlByColumnName() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$8, this, new Object[0]);
            }
            StringBuffer newSqlBuf = new StringBuffer(this.originalSql);
            newSqlBuf.append(" RETURNING ");
            for (i2 = 0; i2 < this.columnNames.length; ++i2) {
                newSqlBuf.append(this.columnNames[i2]);
                if (i2 >= this.columnNames.length - 1) continue;
                newSqlBuf.append(", ");
            }
            newSqlBuf.append(" INTO ");
            for (i2 = 0; i2 < this.columnNames.length - 1; ++i2) {
                newSqlBuf.append((Serializable)(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
            }
            newSqlBuf.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
            String string = this.newSql = new String(newSqlBuf);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$8, this, string);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$8, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    private String getNewSqlByColumnIndexes() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$9, this, new Object[0]);
            }
            this.returnTypes = new int[this.columnIndexes.length];
            StringBuffer newSqlBuf = new StringBuffer(this.originalSql);
            newSqlBuf.append(" RETURNING ");
            for (i2 = 0; i2 < this.columnIndexes.length; ++i2) {
                int index = this.columnIndexes[i2] - 1;
                if (index < 0 || index > this.tableColumnNames.length) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null, DatabaseError.createSqlException(3, Integer.toString(index)).fillInStackTrace()).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$9, this, sQLException);
                    }
                    throw sQLException;
                }
                int type = this.tableColumnTypes[index];
                String name = this.tableColumnNames[index];
                this.returnTypes[i2] = type;
                newSqlBuf.append(name.contains(" ") ? String.format("\"%s\"", name) : name);
                if (i2 >= this.columnIndexes.length - 1) continue;
                newSqlBuf.append(", ");
            }
            newSqlBuf.append(" INTO ");
            for (i2 = 0; i2 < this.columnIndexes.length - 1; ++i2) {
                newSqlBuf.append((Serializable)(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
            }
            newSqlBuf.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
            String string = this.newSql = new String(newSqlBuf);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$9, this, string);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$9, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    private final int getReturnParamTypeCode(int n2, String string, int[] nArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String columnName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$10, this, n2, string, nArray);
            }
            columnName = columnName.replace("\"", "");
            for (int i2 = 0; i2 < this.tableColumnNames.length; ++i2) {
                if (!columnName.equalsIgnoreCase(this.tableColumnNames[i2])) continue;
                columnIndexes[pos] = i2 + 1;
                int n3 = this.tableColumnTypes[i2];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$10, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$10, this, null);
                }
                return n3;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null, DatabaseError.createSqlException(6, columnName).fillInStackTrace()).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isInsertSqlStmt() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.parseSql();
            }
            boolean bl3 = bl2 = this.sqlKind == OracleStatement.SqlKind.INSERT;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$11, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$11, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isUpdateSqlStmt() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.parseSql();
            }
            boolean bl3 = bl2 = this.sqlKind == OracleStatement.SqlKind.UPDATE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$12, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isInsertOrUpdateSqlStmt() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$13, this, new Object[0]);
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.parseSql();
            }
            boolean bl3 = bl2 = this.sqlKind == OracleStatement.SqlKind.INSERT || this.sqlKind == OracleStatement.SqlKind.UPDATE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$13, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$13, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    String getTableName() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, new Object[0]);
            }
            if (this.tableName != null) {
                String string = this.tableName;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, string);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, null);
                }
                return string;
            }
            if (this.isUpdateSqlStmt()) {
                String string = this.getTableNameForUpdateStmt(this.originalSql);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, string);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, null);
                }
                return string;
            }
            if (this.isInsertSqlStmt()) {
                String string = this.getTableNameForInsertStmt(this.originalSql);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, string);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, null);
                }
                return string;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTableNameForInsertStmt(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$15, this, string);
            }
            String sL = sql.trim();
            String sU = sL.toUpperCase();
            int pos = sU.indexOf("INSERT");
            if ((pos = sU.indexOf("INTO", pos)) < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$15, this, sQLException);
                }
                throw sQLException;
            }
            String s1 = sL.substring(pos + 5).trim();
            String string2 = this.tableName = this.extractTablename(s1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$15, this, string2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$15, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTableNameForUpdateStmt(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            String sL;
            String sU;
            int pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$16, this, string);
            }
            if ((pos = (sU = (sL = sql.trim()).toUpperCase()).indexOf("UPDATE")) != 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$16, this, sQLException);
                }
                throw sQLException;
            }
            String s1 = sL.substring(6).trim();
            String string2 = this.tableName = this.extractTablename(s1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$16, this, string2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$16, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String extractTablename(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int start;
            void s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, string);
            }
            int len = s2.length();
            for (start = 0; start < len && s2.charAt(start) == ' '; ++start) {
            }
            if (start >= len) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, sQLException);
                }
                throw sQLException;
            }
            int end = 0;
            String id1 = null;
            String id2 = null;
            boolean bDone = false;
            do {
                if (s2.charAt(start) == '.') {
                    if (id1 != null) {
                        ++start;
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                if (s2.charAt(start) == '\"') {
                    end = start + 1;
                    if (start >= (end = s2.indexOf(34, end) + 1) - 2) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (id1 == null) {
                        id1 = s2.substring(start, end);
                        start = end;
                        if (s2.charAt(start) == '.') continue;
                        bDone = true;
                        continue;
                    }
                    id2 = s2.substring(start, end);
                    bDone = true;
                    continue;
                }
                for (end = start; end < len && s2.charAt(end) != ' ' && s2.charAt(end) != '(' && s2.charAt(end) != '.'; ++end) {
                }
                if (start >= end) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, sQLException);
                    }
                    throw sQLException;
                }
                if (id1 == null) {
                    id1 = s2.substring(start, end);
                    start = end;
                    if (s2.charAt(start) == '.') continue;
                    bDone = true;
                    continue;
                }
                id2 = s2.substring(start, end);
                bDone = true;
            } while (!bDone);
            if (id2 == null) {
                String string2 = id1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, string2);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, null);
                }
                return string2;
            }
            String string3 = id1 + "." + id2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, string3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void allocateSpaceForDescribedData(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void numColumns;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$18, this, n2);
            }
            this.numColumns = numColumns;
            this.tableColumnNames = new String[numColumns];
            this.tableColumnTypes = new int[numColumns];
            this.tableMaxLengths = new int[numColumns];
            this.tableNullables = new boolean[numColumns];
            this.tableFormOfUses = new short[numColumns];
            this.tablePrecisions = new int[numColumns];
            this.tableScales = new int[numColumns];
            this.tableTypeNames = new String[numColumns];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void fillDescribedData(int n2, String string, int n3, int n4, boolean bl, short s2, int n5, int n6, String string2) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void scale;
            void precision;
            void form;
            void nullable;
            void maxLength;
            void type;
            void colName;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$19, this, n2, string, n3, n4, bl, s2, n5, n6, string2);
            }
            this.tableColumnNames[index] = colName;
            this.tableColumnTypes[index] = type;
            this.tableMaxLengths[index] = maxLength;
            this.tableNullables[index] = nullable;
            this.tableFormOfUses[index] = form;
            this.tablePrecisions[index] = precision;
            this.tableScales[index] = scale;
            this.tableTypeNames[index] = typeName;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initMetaData(OracleResultSet oracleResultSet) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void rset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this, oracleResultSet);
            }
            if (this.returnAccessors != null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this);
                    ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this, null);
                }
                return;
            }
            int numReturnParams = rset.getOracleStatement().numReturnParams;
            if (numReturnParams == 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this, sQLException);
                }
                throw sQLException;
            }
            this.returnAccessors = new Accessor[numReturnParams];
            Accessor[] accessors = rset.getOracleStatement().accessors;
            int numberOfBindPositions = rset.getOracleStatement().numberOfBindPositions;
            int j2 = 0;
            for (int i2 = 0; i2 < numberOfBindPositions; ++i2) {
                Accessor accessor = accessors[i2];
                if (accessor == null) continue;
                this.returnAccessors[j2++] = accessor;
            }
            switch (this.autoKeyType) {
                case 0: {
                    this.initMetaDataKeyFlag();
                    break;
                }
                case 1: 
                case 2: {
                    this.initMetaDataColumnIndexes();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$21, this, new Object[0]);
            }
            this.returnAccessors[0].columnName = "ROWID";
            this.returnAccessors[0].describeType = 104;
            this.returnAccessors[0].describeMaxLength = 4;
            this.returnAccessors[0].nullable = true;
            this.returnAccessors[0].precision = 0;
            this.returnAccessors[0].scale = 0;
            this.returnAccessors[0].formOfUse = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    void initMetaDataColumnIndexes() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$22, this, new Object[0]);
            }
            for (int i2 = 0; i2 < this.returnAccessors.length; ++i2) {
                Accessor accessor = this.returnAccessors[i2];
                int index = this.columnIndexes[i2] - 1;
                accessor.columnName = this.tableColumnNames[index];
                accessor.describeType = this.tableColumnTypes[index];
                accessor.describeMaxLength = this.tableMaxLengths[index];
                accessor.nullable = this.tableNullables[index];
                accessor.precision = this.tablePrecisions[index];
                accessor.scale = this.tablePrecisions[index];
                accessor.formOfUse = this.tableFormOfUses[index];
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getValidColumnIndex(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$23, this, n2);
            }
            this.checkColumnIndex((int)column);
            void var3_3 = column - true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$23, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$23, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$24, this, new Object[0]);
            }
            int n2 = this.returnAccessors.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$24, this, n2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$24, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnName(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$25, this, n2);
            }
            this.checkColumnIndex((int)column);
            String string = this.returnAccessors[column - true].columnName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$25, this, string);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$25, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getTableName(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$26, this, n2);
            }
            this.checkColumnIndex((int)column);
            String string = this.getTableName();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$26, this, string);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$26, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    Accessor[] getDescription() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$27, this, new Object[0]);
            }
            Accessor[] accessorArray = this.returnAccessors;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$27, this, accessorArray);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$27, this, null);
            }
            return this.returnAccessors;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkColumnIndex(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void column;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$28, this, n2);
            }
            if (column <= 0 || column > this.returnAccessors.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, Integer.toString((int)column)).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$28, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, AutoKeyInfo.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$31 = AutoKeyInfo.class.getDeclaredConstructor(String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = AutoKeyInfo.class.getDeclaredConstructor(String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = AutoKeyInfo.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = AutoKeyInfo.class.getDeclaredMethod("checkColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = AutoKeyInfo.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = AutoKeyInfo.class.getDeclaredMethod("getTableName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = AutoKeyInfo.class.getDeclaredMethod("getColumnName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = AutoKeyInfo.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = AutoKeyInfo.class.getDeclaredMethod("getValidColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = AutoKeyInfo.class.getDeclaredMethod("initMetaDataColumnIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = AutoKeyInfo.class.getDeclaredMethod("initMetaDataKeyFlag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = AutoKeyInfo.class.getDeclaredMethod("initMetaData", OracleResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = AutoKeyInfo.class.getDeclaredMethod("fillDescribedData", Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = AutoKeyInfo.class.getDeclaredMethod("allocateSpaceForDescribedData", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = AutoKeyInfo.class.getDeclaredMethod("extractTablename", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = AutoKeyInfo.class.getDeclaredMethod("getTableNameForUpdateStmt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = AutoKeyInfo.class.getDeclaredMethod("getTableNameForInsertStmt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = AutoKeyInfo.class.getDeclaredMethod("getTableName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = AutoKeyInfo.class.getDeclaredMethod("isInsertOrUpdateSqlStmt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = AutoKeyInfo.class.getDeclaredMethod("isUpdateSqlStmt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AutoKeyInfo.class.getDeclaredMethod("isInsertSqlStmt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AutoKeyInfo.class.getDeclaredMethod("getReturnParamTypeCode", Integer.TYPE, String.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AutoKeyInfo.class.getDeclaredMethod("getNewSqlByColumnIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AutoKeyInfo.class.getDeclaredMethod("getNewSqlByColumnName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AutoKeyInfo.class.getDeclaredMethod("initializeIndexesAndTypesByName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AutoKeyInfo.class.getDeclaredMethod("setInitialized", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AutoKeyInfo.class.getDeclaredMethod("initializeAsync", PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AutoKeyInfo.class.getDeclaredMethod("initialize", PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AutoKeyInfo.class.getDeclaredMethod("isInitialized", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AutoKeyInfo.class.getDeclaredMethod("getNewSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AutoKeyInfo.class.getDeclaredMethod("generateUniqueNamedParameter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AutoKeyInfo.class.getDeclaredMethod("parseSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SQL_PARSER = new ThreadLocal<OracleSql>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected OracleSql initialValue() {
                return new OracleSql(null);
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("initialValue", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }
}

