"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const commandRunner_1 = require("../../src/utils/commandRunner");
const chai_1 = require("chai");
const workspaceManager_1 = require("../../src/services/workspaceManager");
const node_1 = require("vscode-languageserver/node");
const helper_1 = require("../helper");
const path = __importStar(require("path"));
describe("commandRunner", () => {
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    const pkgJSON = require(path.resolve(__dirname, "..", "..", "package.json"));
    const tests = [
        {
            args: [
                path.join(path.resolve(__dirname, "..", ".."), "bin", "ansible-language-server"),
                "--version",
            ],
            rc: 0,
            stdout: `${pkgJSON["version"]}`,
            stderr: "",
        },
        {
            args: ["ansible-config", "dump"],
            rc: 0,
            stdout: "ANSIBLE_FORCE_COLOR",
            stderr: "",
        },
        {
            args: ["ansible", "--version"],
            rc: 0,
            stdout: "configured module search path",
            stderr: "",
        },
        {
            args: ["ansible-lint", "--version"],
            rc: 0,
            stdout: "using ansible",
            stderr: "",
        },
        {
            args: ["ansible-playbook", "missing-file"],
            rc: 1,
            stdout: "",
            stderr: "ERROR! the playbook: missing-file could not be found",
        },
    ];
    tests.forEach(({ args, rc, stdout, stderr }) => {
        it(`call ${args.join(" ")}`, function () {
            return __awaiter(this, void 0, void 0, function* () {
                this.timeout(10000);
                // try to enforce ansible to output ANSI in order to check if we are
                // still able to disable it at runtime in order to keep output parseable.
                process.env.ANSIBLE_FORCE_COLOR = "1";
                process.argv.push("--node-ipc");
                const connection = (0, node_1.createConnection)();
                const workspaceManager = new workspaceManager_1.WorkspaceManager(connection);
                const textDoc = yield (0, helper_1.getDoc)("yaml/ancestryBuilder.yml");
                const context = workspaceManager.getContext(textDoc.uri);
                const settings = yield context.documentSettings.get(textDoc.uri);
                const commandRunner = new commandRunner_1.CommandRunner(connection, context, settings);
                try {
                    const proc = yield commandRunner.runCommand(args[0], args.slice(1).join(" "));
                    (0, chai_1.expect)(proc.stdout, proc.stderr).contains(stdout);
                    (0, chai_1.expect)(proc.stderr, proc.stdout).contains(stderr);
                }
                catch (e) {
                    if (e instanceof chai_1.AssertionError) {
                        throw e;
                    }
                    (0, chai_1.expect)(e.code, e).equals(rc);
                    (0, chai_1.expect)(e.stdout, e).contains(stdout);
                    (0, chai_1.expect)(e.stderr, e).contains(stderr);
                }
            });
        });
    });
});
//# sourceMappingURL=runCommand.test.js.map