/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperLogger;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.ExceptionUtils;
import org.apache.jasper.util.FastRemovalDequeue;

public final class JspRuntimeContext {
    private final JasperLogger log = JasperLogger.ROOT_LOGGER;
    private final AtomicInteger jspReloadCount = new AtomicInteger(0);
    private final AtomicInteger jspUnloadCount = new AtomicInteger(0);
    private final ServletContext context;
    private final Options options;
    private final ClassLoader parentClassLoader;
    private final PermissionCollection permissionCollection;
    private final CodeSource codeSource;
    private final String classpath;
    private volatile long lastCompileCheck = -1L;
    private volatile long lastJspQueueUpdate = System.currentTimeMillis();
    private long jspIdleTimeout;
    private final Map<String, JspServletWrapper> jsps = new ConcurrentHashMap<String, JspServletWrapper>();
    private FastRemovalDequeue<JspServletWrapper> jspQueue = null;

    public JspRuntimeContext(ServletContext context, Options options) {
        this.context = context;
        this.options = options;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (this.log.isDebugEnabled()) {
            if (loader != null) {
                this.log.debugf("Parent class loader is: '%s' ", loader.toString());
            } else {
                this.log.debugf("Parent class loader is: '%s' ", "<none>");
            }
        }
        this.parentClassLoader = loader;
        this.classpath = this.initClassPath();
        if (Constants.IS_SECURITY_ENABLED) {
            SecurityHolder holder = this.initSecurity();
            this.codeSource = holder.cs;
            this.permissionCollection = holder.pc;
        } else {
            this.codeSource = null;
            this.permissionCollection = null;
        }
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getCheckInterval() > 0) {
            this.lastCompileCheck = System.currentTimeMillis();
        }
        if (options.getMaxLoadedJsps() > 0) {
            this.jspQueue = new FastRemovalDequeue(options.getMaxLoadedJsps());
            if (this.log.isDebugEnabled()) {
                this.log.debugf("Created jsp queue with length {%s} for context [%s]", options.getMaxLoadedJsps(), context.getContextPath());
            }
        }
        this.jspIdleTimeout = options.getJspIdleTimeout() * 1000;
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public FastRemovalDequeue.Entry push(JspServletWrapper jsw) {
        FastRemovalDequeue.Entry entry;
        JspServletWrapper replaced;
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Adding JSP for path [%s] to queue of context [%s]", jsw.getJspUri(), this.context.getContextPath());
        }
        if ((replaced = (JspServletWrapper)(entry = this.jspQueue.push(jsw)).getReplaced()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debugf("Removing excess JSP for path [%s] from queue of context [%s]", replaced.getJspUri(), this.context.getContextPath());
            }
            this.unloadJspServletWrapper(replaced);
            entry.clearReplaced();
        }
        return entry;
    }

    public void makeYoungest(FastRemovalDequeue.Entry unloadHandle) {
        if (this.log.isTraceEnabled()) {
            JspServletWrapper jsw = (JspServletWrapper)unloadHandle.getContent();
            this.log.tracef("Updating JSP for path [%s] in queue of context [%s]", jsw.getJspUri(), this.context.getContextPath());
        }
        this.jspQueue.moveFirst(unloadHandle);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        Iterator<JspServletWrapper> servlets = this.jsps.values().iterator();
        while (servlets.hasNext()) {
            servlets.next().destroy();
        }
    }

    public void incrementJspReloadCount() {
        this.jspReloadCount.incrementAndGet();
    }

    public void setJspReloadCount(int count) {
        this.jspReloadCount.set(count);
    }

    public int getJspReloadCount() {
        return this.jspReloadCount.intValue();
    }

    public int getJspQueueLength() {
        if (this.jspQueue != null) {
            return this.jspQueue.getSize();
        }
        return -1;
    }

    public int getJspUnloadCount() {
        return this.jspUnloadCount.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCompile() {
        if (this.lastCompileCheck < 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now <= this.lastCompileCheck + (long)this.options.getCheckInterval() * 1000L) {
            return;
        }
        this.lastCompileCheck = now;
        Object[] wrappers = this.jsps.values().toArray();
        for (int i = 0; i < wrappers.length; ++i) {
            JspServletWrapper jsw = (JspServletWrapper)wrappers[i];
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    jsw.getServletContext().log(JasperMessages.MESSAGES.backgroundCompilationFailed(), t);
                }
                continue;
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    public long getLastJspQueueUpdate() {
        return this.lastJspQueueUpdate;
    }

    private String initClassPath() {
        StringBuilder cpath = new StringBuilder();
        if (this.parentClassLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this.parentClassLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                try {
                    String decoded = URLDecoder.decode(urls[i].getPath(), "UTF-8");
                    cpath.append(decoded + File.pathSeparator);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        cpath.append(this.options.getScratchDir() + File.pathSeparator);
        String cp = (String)this.context.getAttribute(Constants.SERVLET_CLASSPATH);
        if (cp == null || cp.equals("")) {
            cp = this.options.getClassPath();
        }
        String path = cpath.toString() + cp;
        JasperLogger.COMPILER_LOGGER.logCompilationClasspath(this.getClassPath());
        return path;
    }

    private SecurityHolder initSecurity() {
        Policy policy = Policy.getPolicy();
        CodeSource source = null;
        PermissionCollection permissions = null;
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURI().toURL();
                URL providedCodeSource = (URL)this.context.getAttribute("org.apache.jasper.Constants.CODE_SOURCE_ATTRIBUTE_NAME");
                source = providedCodeSource != null ? new CodeSource(providedCodeSource, (Certificate[])null) : new CodeSource(url, (Certificate[])null);
                permissions = policy.getPermissions(source);
                PermissionCollection userPermissions = (PermissionCollection)this.context.getAttribute("org.apache.jasper.Constants.PERMISSION_COLLECTION_ATTRIBUTE_NAME");
                if (userPermissions != null) {
                    Enumeration<Permission> elements = userPermissions.elements();
                    while (elements.hasMoreElements()) {
                        permissions.add(elements.nextElement());
                    }
                }
                if (!docBase.endsWith(File.separator)) {
                    permissions.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    permissions.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                permissions.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    permissions.add(new FilePermission(workDir, "read,write"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                permissions.add(new FilePermission(workDir, "read,write,delete"));
                permissions.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)this.parentClassLoader).getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        permissions.add(new FilePermission(jarUrl, "read"));
                        permissions.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        permissions.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log(JasperMessages.MESSAGES.errorInitializingSecurity(), (Throwable)e);
            }
        }
        return new SecurityHolder(source, permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadJspServletWrapper(JspServletWrapper jsw) {
        this.removeWrapper(jsw.getJspUri());
        JspServletWrapper jspServletWrapper = jsw;
        synchronized (jspServletWrapper) {
            jsw.destroy();
        }
        this.jspUnloadCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUnload() {
        if (this.log.isTraceEnabled()) {
            int queueLength = -1;
            if (this.jspQueue != null) {
                queueLength = this.jspQueue.getSize();
            }
            this.log.tracef("Checking JSPs for unload in context [%s], JSP count: {%s} queue length: {%s}", this.context.getContextPath(), "" + this.jsps.size(), "" + queueLength);
        }
        long now = System.currentTimeMillis();
        if (this.jspIdleTimeout > 0L) {
            long unloadBefore = now - this.jspIdleTimeout;
            Object[] wrappers = this.jsps.values().toArray();
            for (int i = 0; i < wrappers.length; ++i) {
                JspServletWrapper jsw;
                JspServletWrapper jspServletWrapper = jsw = (JspServletWrapper)wrappers[i];
                synchronized (jspServletWrapper) {
                    if (jsw.getLastUsageTime() < unloadBefore) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debugf("Removing idle JSP for path [%s] in context [%s] after %s seconds", jsw.getJspUri(), this.context.getContextPath(), "" + (now - jsw.getLastUsageTime()));
                        }
                        if (this.jspQueue != null) {
                            this.jspQueue.remove(jsw.getUnloadHandle());
                        }
                        this.unloadJspServletWrapper(jsw);
                    }
                    continue;
                }
            }
        }
        this.lastJspQueueUpdate = now;
    }

    public void handleFileChange(Set<String> changedResource) {
        for (String resource : changedResource) {
            String slashResource = resource.startsWith("/") ? resource : "/" + resource;
            JspServletWrapper wrapper = this.jsps.get(slashResource);
            if (wrapper == null) continue;
            wrapper.jspFileChanged();
        }
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(((Object)((Object)factory)).getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.jasper.";
            try {
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                ((Object)((Object)factory)).getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        JspFactory.setDefaultFactory((JspFactory)factory);
    }

    private static class SecurityHolder {
        private final CodeSource cs;
        private final PermissionCollection pc;

        private SecurityHolder(CodeSource cs, PermissionCollection pc) {
            this.cs = cs;
            this.pc = pc;
        }
    }
}

