/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ConverterUtil;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class JsonConverter {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private ObjectMapper jsonMapper;
    private CborConverter cborConverter;

    JsonConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper, CborConverter cborConverter) {
        AssertUtil.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        AssertUtil.notNull((Object)cborMapper, (String)"cborMapper must not be null");
        AssertUtil.isTrue((!(jsonMapper.getFactory() instanceof CBORFactory) ? 1 : 0) != 0, (String)"factory of jsonMapper must be JsonFactory.");
        AssertUtil.isTrue((boolean)(cborMapper.getFactory() instanceof CBORFactory), (String)"factory of cborMapper must be CBORFactory.");
        this.jsonMapper = jsonMapper;
        this.cborConverter = cborConverter;
        if (this.cborConverter == null) {
            this.cborConverter = new CborConverter(jsonMapper, cborMapper, this);
            ConverterUtil.initializeJsonMapper(jsonMapper, this, this.cborConverter);
            ConverterUtil.initializeCborMapper(cborMapper, this, this.cborConverter);
        }
    }

    public JsonConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper) {
        this(jsonMapper, cborMapper, null);
    }

    public JsonConverter() {
        this(new ObjectMapper(new JsonFactory()), new ObjectMapper((JsonFactory)new CBORFactory()));
    }

    public <T> T readValue(String src, Class valueType) {
        try {
            return (T)this.jsonMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, Class valueType) {
        try {
            return (T)this.jsonMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(String src, TypeReference valueTypeRef) {
        try {
            return (T)this.jsonMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, TypeReference valueTypeRef) {
        try {
            return (T)this.jsonMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return this.jsonMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public String writeValueAsString(Object value) {
        try {
            return this.jsonMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public CborConverter getCborConverter() {
        return this.cborConverter;
    }
}

