/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import javax.batch.api.Batchlet;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.job.model.RefArtifact;
import org.jberet.runtime.JobStopNotificationListener;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.runtime.runner.ScriptBatchlet;
import org.jberet.spi.JobTask;
import org.jberet.spi.PartitionWorker;

public final class BatchletRunner
extends AbstractRunner<StepContextImpl>
implements JobTask,
JobStopNotificationListener {
    private final RefArtifact batchlet;
    private PartitionCollector collector;
    private Batchlet batchletObj;
    private PartitionWorker partitionWorker;

    public BatchletRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner, RefArtifact batchlet, PartitionWorker partitionWorker) {
        super(stepContext, enclosingRunner);
        this.batchlet = batchlet;
        this.partitionWorker = partitionWorker;
    }

    @Override
    public void stopRequested(long jobExecutionId) {
        if (((StepContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
            ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPING);
            if (this.batchletObj != null) {
                try {
                    this.batchletObj.stop();
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.failToStopJob(e, this.jobContext.getJobName(), ((StepContextImpl)this.batchContext).getStepName(), this.batchletObj);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block24: {
            block22: {
                RefArtifact collectorConfig;
                if (this.partitionWorker != null && (collectorConfig = ((StepContextImpl)this.batchContext).getStep().getPartition().getCollector()) != null) {
                    this.collector = (PartitionCollector)this.jobContext.createArtifact(collectorConfig.getRef(), null, collectorConfig.getProperties(), (StepContextImpl)this.batchContext);
                }
                this.batchletObj = (Batchlet)this.createArtifact(this.batchlet, (StepContextImpl)this.batchContext, ScriptBatchlet.class);
                String exitStatus = null;
                if (this.jobContext.getJobExecution().isStopRequested()) {
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPING);
                } else {
                    this.jobContext.getJobExecution().registerJobStopNotifier(this);
                    exitStatus = this.batchletObj.process();
                    this.jobContext.getJobExecution().unregisterJobStopNotifier(this);
                }
                switch (((StepContextImpl)this.batchContext).getBatchStatus()) {
                    case STARTED: {
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
                        break;
                    }
                    case STOPPING: {
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                    }
                }
                ((StepContextImpl)this.batchContext).setExitStatus(exitStatus);
                if (this.collector != null) {
                    this.partitionWorker.reportData(this.collector.collectPartitionData(), ((StepContextImpl)this.batchContext).getStepExecution());
                }
                if (this.partitionWorker == null) break block22;
                try {
                    JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                    this.partitionWorker.partitionDone(((StepContextImpl)this.batchContext).getStepExecution());
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.problemFinalizingPartitionExecution(e, ((StepContextImpl)this.batchContext).getStepExecutionId());
                }
            }
            this.jobContext.destroyArtifact(this.batchletObj, this.collector);
            break block24;
            catch (Throwable e) {
                block23: {
                    try {
                        try {
                            if (this.collector != null) {
                                this.partitionWorker.reportData(this.collector.collectPartitionData(), ((StepContextImpl)this.batchContext).getStepExecution());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((StepContextImpl)this.batchContext).setException(e instanceof Exception ? (Exception)e : new BatchRuntimeException(e));
                        BatchLogger.LOGGER.failToRunBatchlet(e, this.batchlet);
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                        if (this.partitionWorker == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (this.partitionWorker != null) {
                            try {
                                JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                                this.partitionWorker.partitionDone(((StepContextImpl)this.batchContext).getStepExecution());
                            }
                            catch (Exception e2) {
                                BatchLogger.LOGGER.problemFinalizingPartitionExecution(e2, ((StepContextImpl)this.batchContext).getStepExecutionId());
                            }
                        }
                        this.jobContext.destroyArtifact(this.batchletObj, this.collector);
                        throw throwable;
                    }
                    try {
                        JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                        this.partitionWorker.partitionDone(((StepContextImpl)this.batchContext).getStepExecution());
                    }
                    catch (Exception e3) {
                        BatchLogger.LOGGER.problemFinalizingPartitionExecution(e3, ((StepContextImpl)this.batchContext).getStepExecutionId());
                    }
                }
                this.jobContext.destroyArtifact(this.batchletObj, this.collector);
            }
        }
    }
}

