/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.extension;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.server.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.server.extension.ThemeResourceDefinition;

public class ThemeResourceAddHandler
extends AbstractAddStepHandler {
    public static ThemeResourceAddHandler INSTANCE = new ThemeResourceAddHandler();

    private ThemeResourceAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (!operation.get("operation").asString().equals("add")) {
            throw new OperationFailedException("Unexpected operation for add Theme. operation=" + operation.toString());
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathElement last = address.getLastElement();
        if (!last.getValue().equals("defaults")) {
            throw new OperationFailedException("Theme resource with name " + last.getValue() + " not allowed.");
        }
        for (AttributeDefinition def : ThemeResourceDefinition.ALL_ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
        KeycloakAdapterConfigService.INSTANCE.updateConfig(operation, model);
    }
}

