/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.sasl.SaslException;
import org.jboss.as.cli.AwaiterModelControllerClient;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.xnio.http.RedirectException;

public class ReloadHandler
extends BaseOperationCommand {
    private static final String ADMIN_ONLY = "admin-only";
    private static final String NORMAL = "normal";
    private static final String SUSPEND = "suspend";
    private static final String START_MODE = "start-mode";
    private final ArgumentWithValue adminOnly;
    private final ArgumentWithValue startMode;
    private final ArgumentWithValue useCurrentServerConfig;
    private final ArgumentWithValue serverConfig;
    private final ArgumentWithValue host;
    private final ArgumentWithValue restartServers;
    private final ArgumentWithValue useCurrentDomainConfig;
    private final ArgumentWithValue useCurrentHostConfig;
    private final AtomicReference<EmbeddedProcessLaunch> embeddedServerRef;
    private final ArgumentWithValue domainConfig;
    private final ArgumentWithValue hostConfig;
    private PerNodeOperationAccess hostReloadPermission;

    public ReloadHandler(CommandContext ctx, AtomicReference<EmbeddedProcessLaunch> embeddedServerRef) {
        super(ctx, "reload", true);
        this.embeddedServerRef = embeddedServerRef;
        this.adminOnly = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--admin-only"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.startMode = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                return Arrays.asList(ReloadHandler.ADMIN_ONLY, ReloadHandler.NORMAL, ReloadHandler.SUSPEND);
            }
        }), "--start-mode"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.startMode.addCantAppearAfter(this.adminOnly);
        this.adminOnly.addCantAppearAfter(this.startMode);
        this.useCurrentServerConfig = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--use-current-server-config"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverConfig = new ArgumentWithValue(this, "--server-config"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.restartServers = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--restart-servers"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.useCurrentDomainConfig = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--use-current-domain-config"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.useCurrentHostConfig = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--use-current-host-config"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.hostConfig = new ArgumentWithValue(this, "--host-config"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.domainConfig = new ArgumentWithValue(this, "--domain-config"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.host = new ArgumentWithValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return ReloadHandler.this.hostReloadPermission.getAllowedOn(ctx);
            }
        }, "--host"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.hostReloadPermission = new PerNodeOperationAccess(ctx, "host", null, "reload");
        return AccessRequirementBuilder.Factory.create(ctx).any().operation("reload").requirement(this.hostReloadPermission).build();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelControllerClient client;
        block6: {
            client = ctx.getModelControllerClient();
            if (client == null) {
                throw new CommandLineException("Connection is not available.");
            }
            if (this.embeddedServerRef != null && this.embeddedServerRef.get() != null) {
                this.doHandleEmbedded(ctx, client);
                return;
            }
            if (!(client instanceof AwaiterModelControllerClient)) {
                throw new CommandLineException("Unsupported ModelControllerClient implementation " + client.getClass().getName());
            }
            AwaiterModelControllerClient cliClient = (AwaiterModelControllerClient)((Object)client);
            ModelNode op = this.buildRequestWithoutHeaders(ctx);
            try {
                ModelNode response = cliClient.execute(op, true);
                if (!Util.isSuccess(response)) {
                    throw new CommandLineException(Util.getFailureDescription(response));
                }
            }
            catch (IOException e) {
                if (!cliClient.isConnected()) break block6;
                StreamUtils.safeClose(client);
                throw new CommandLineException("Failed to execute :reload", e);
            }
        }
        this.ensureServerRebootComplete(ctx, client);
    }

    private boolean isAdminOnly(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean legacy = this.adminOnly.isPresent(args) && "TRUE".equalsIgnoreCase(this.adminOnly.getValue(args));
        boolean mode = this.startMode.isPresent(args) && ADMIN_ONLY.equalsIgnoreCase(this.startMode.getValue(args));
        return mode || legacy;
    }

    private void doHandleEmbedded(CommandContext ctx, ModelControllerClient client) throws CommandLineException {
        assert (this.embeddedServerRef != null);
        assert (this.embeddedServerRef.get() != null);
        ModelNode op = this.buildRequestWithoutHeaders(ctx);
        if (this.embeddedServerRef.get().isHostController() && !this.isAdminOnly(ctx)) {
            throw new CommandLineException("Reload into running mode is not supported, --admin-only must be specified.");
        }
        try {
            ModelNode response = client.execute(op);
            if (!Util.isSuccess(response)) {
                throw new CommandLineException(Util.getFailureDescription(response));
            }
        }
        catch (IOException e) {
            StreamUtils.safeClose(client);
            throw new CommandLineException("Failed to execute :reload", e);
        }
        this.ensureServerRebootComplete(ctx, client);
    }

    private void ensureServerRebootComplete(CommandContext ctx, ModelControllerClient client) throws CommandLineException {
        long start = System.currentTimeMillis();
        long timeoutMillis = ctx.getConfig().getConnectionTimeout() + 1000;
        ModelNode getStateOp = new ModelNode();
        if (ctx.isDomainMode()) {
            ParsedCommandLine args = ctx.getParsedCommandLine();
            String hostName = this.host.getValue(args);
            getStateOp.get("address").add("host", hostName);
        }
        getStateOp.get("operation").set("read-attribute");
        if (ctx.isDomainMode()) {
            getStateOp.get("name").set("host-state");
        } else {
            getStateOp.get("name").set("server-state");
        }
        while (true) {
            String serverState = null;
            try {
                ModelNode response = client.execute(getStateOp);
                if (Util.isSuccess(response) && ("running".equals(serverState = response.get("result").asString()) || "restart-required".equals(serverState))) {
                    break;
                }
            }
            catch (IOException e) {
                for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                    if (ex instanceof RedirectException) {
                        if (!Util.reconnectContext((RedirectException)ex, ctx)) continue;
                        return;
                    }
                    if (!(ex instanceof SaslException)) continue;
                    try {
                        ctx.connectController();
                        return;
                    }
                    catch (CommandLineException commandLineException) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start > timeoutMillis && !"starting".equals(serverState)) {
                ctx.disconnectController();
                throw new CommandLineException("Failed to establish connection in " + (System.currentTimeMillis() - start) + "ms");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                ctx.disconnectController();
                throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
            }
        }
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        ModelNode op = new ModelNode();
        if (ctx.isDomainMode()) {
            if (this.useCurrentServerConfig.isPresent(args)) {
                throw new CommandFormatException(this.useCurrentServerConfig.getFullName() + " is not allowed in the domain mode.");
            }
            if (this.serverConfig.isPresent(args)) {
                throw new CommandFormatException(this.serverConfig.getFullName() + " is not allowed in the domain mode.");
            }
            String hostName = this.host.getValue(args);
            if (hostName == null) {
                throw new CommandFormatException("Missing required argument " + this.host.getFullName());
            }
            op.get("address").add("host", hostName);
            this.setBooleanArgument(args, op, this.restartServers, "restart-servers");
            this.setBooleanArgument(args, op, this.useCurrentDomainConfig, "use-current-domain-config");
            this.setBooleanArgument(args, op, this.useCurrentHostConfig, "use-current-host-config");
            this.setStringValue(args, op, this.hostConfig, "host-config");
            this.setStringValue(args, op, this.domainConfig, "domain-config");
        } else {
            if (this.host.isPresent(args)) {
                throw new CommandFormatException(this.host.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.useCurrentDomainConfig.isPresent(args)) {
                throw new CommandFormatException(this.useCurrentDomainConfig.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.useCurrentHostConfig.isPresent(args)) {
                throw new CommandFormatException(this.useCurrentHostConfig.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.restartServers.isPresent(args)) {
                throw new CommandFormatException(this.restartServers.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.hostConfig.isPresent(args)) {
                throw new CommandFormatException(this.hostConfig.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.domainConfig.isPresent(args)) {
                throw new CommandFormatException(this.domainConfig.getFullName() + " is not allowed in the standalone mode.");
            }
            op.get("address").setEmptyList();
            this.setBooleanArgument(args, op, this.useCurrentServerConfig, "use-current-server-config");
            this.setStringValue(args, op, this.serverConfig, "server-config");
        }
        op.get("operation").set("reload");
        this.setStartMode(ctx, args, op);
        return op;
    }

    private void setStartMode(CommandContext ctx, ParsedCommandLine args, ModelNode op) throws CommandFormatException {
        String value;
        if (this.startMode.isPresent(args) && ctx.isDomainMode()) {
            throw new CommandFormatException("--start-mode can't be used in domain mode.");
        }
        if (this.adminOnly.isPresent(args) && this.startMode.isPresent(args)) {
            throw new CommandFormatException("--start-mode and --admin-only can't be used all together.");
        }
        if (this.startMode.isPresent(args) && "true".equals(value = this.startMode.getValue(args, true))) {
            throw new CommandFormatException("--start-mode is missing value.");
        }
        if (this.isAdminOnly(ctx)) {
            if (ctx.isDomainMode()) {
                op.get(ADMIN_ONLY).set(true);
            } else {
                op.get(START_MODE).set(ADMIN_ONLY);
            }
        } else {
            this.setStringValue(args, op, this.startMode, START_MODE);
        }
    }

    protected void setBooleanArgument(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        if (value.equalsIgnoreCase("true")) {
            op.get(paramName).set(true);
        } else if (value.equalsIgnoreCase("false")) {
            op.get(paramName).set(false);
        } else {
            throw new CommandFormatException("Invalid value for " + arg.getFullName() + ": '" + value + "'");
        }
    }

    private void setStringValue(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        op.get(paramName).set(value);
    }
}

