/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;

public class ByteBufferImpl
implements ByteBuffer {
    private final byte[] buf;
    private final int offset;
    private final int length;

    public ByteBufferImpl(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteBufferImpl(byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new IllegalArgumentException("Null buff not allowed!");
        }
        if (buf.length < offset + length) {
            throw new IllegalArgumentException("Incorrect arguments: buff.length" + buf.length + ", offset=" + offset + ", length=" + length);
        }
        this.buf = buf;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte[] getBuf() {
        return this.buf;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ByteBufferImpl copy() {
        int new_length;
        byte[] new_buf = this.buf != null ? new byte[this.length] : null;
        int n = new_length = new_buf != null ? new_buf.length : 0;
        if (new_buf != null) {
            System.arraycopy(this.buf, this.offset, new_buf, 0, this.length);
        }
        return new ByteBufferImpl(new_buf, 0, new_length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.length).append(" bytes");
        if (this.offset > 0) {
            sb.append(" (offset=").append(this.offset).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteBufferImpl)) {
            return false;
        }
        ByteBufferImpl that = (ByteBufferImpl)o;
        if (this.length != that.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.buf[this.offset + i] == that.buf[that.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.buf == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.buf[this.offset + i];
        }
        return result;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.getBuf(), this.getOffset(), this.getLength());
    }

    public java.nio.ByteBuffer toJDKByteBuffer() {
        return java.nio.ByteBuffer.wrap(this.buf, this.offset, this.length);
    }

    public static class Externalizer
    extends AbstractExternalizer<ByteBufferImpl> {
        private static final long serialVersionUID = -5291318076267612501L;

        @Override
        public void writeObject(ObjectOutput output, ByteBufferImpl b) throws IOException {
            UnsignedNumeric.writeUnsignedInt(output, b.length);
            output.write(b.buf, b.offset, b.length);
        }

        @Override
        public ByteBufferImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int length = UnsignedNumeric.readUnsignedInt(input);
            byte[] data = new byte[length];
            input.readFully(data, 0, length);
            return new ByteBufferImpl(data, 0, length);
        }

        @Override
        public Integer getId() {
            return 106;
        }

        @Override
        public Set<Class<? extends ByteBufferImpl>> getTypeClasses() {
            return Collections.singleton(ByteBufferImpl.class);
        }
    }
}

