/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.RelativeFile;
import org.jboss.as.cli.impl.aesh.cmd.RelativeFilePathConverter;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactory;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthMechanism;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.EmptyConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ExistingKeyStoreConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ExistingPropertiesRealmConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.FileSystemRealmConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStoreConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.LocalUserConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.MechanismConfiguration;
import org.jboss.as.cli.impl.aesh.cmd.security.model.PropertiesRealmConfiguration;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="abstract-auth-enable", description="")
public abstract class AbstractEnableAuthenticationCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="file-system-realm-name", activator=OptionActivators.FilesystemRealmActivator.class, completer=SecurityCommand.OptionCompleters.FileSystemRealmCompleter.class)
    String fileSystemRealmName;
    @Option(name="properties-realm-name", activator=OptionActivators.PropertiesRealmActivator.class, completer=SecurityCommand.OptionCompleters.PropertiesRealmCompleter.class)
    String propertiesRealmName;
    @Option(name="user-role-decoder", activator=OptionActivators.FileSystemRoleDecoderActivator.class, completer=SecurityCommand.OptionCompleters.SimpleDecoderCompleter.class)
    String userRoleDecoder;
    @Option(name="user-properties-file", activator=OptionActivators.PropertiesFileRealmActivator.class, converter=RelativeFilePathConverter.class, completer=FileOptionCompleter.class)
    RelativeFile userPropertiesFile;
    @Option(name="group-properties-file", activator=OptionActivators.GroupPropertiesFileActivator.class, converter=RelativeFilePathConverter.class, completer=FileOptionCompleter.class)
    RelativeFile groupPropertiesFile;
    @Option(name="exposed-realm", activator=OptionActivators.MechanismWithRealmActivator.class)
    String exposedRealm;
    @Option(name="relative-to", activator=OptionActivators.RelativeToActivator.class)
    String relativeTo;
    @Option(name="no-reload", hasValue=false)
    boolean noReload;
    @Option(name="super-user", hasValue=false, activator=OptionActivators.SuperUserActivator.class)
    boolean superUser;
    @Option(name="new-security-domain-name", activator=OptionActivators.DependsOnMechanism.class)
    String newSecurityDomain;
    @Option(name="new-auth-factory-name", activator=OptionActivators.DependsOnMechanism.class)
    String newAuthFactoryName;
    @Option(name="new-realm-name", activator=OptionActivators.NewSecurityRealmActivator.class)
    String newRealmName;
    @Option(name="key-store-name", activator=OptionActivators.KeyStoreActivator.class, completer=SecurityCommand.OptionCompleters.KeyStoreNameCompleter.class)
    String keyStoreName;
    @Option(name="key-store-realm-name", activator=OptionActivators.KeyStoreRealmActivator.class, completer=SecurityCommand.OptionCompleters.KeyStoreRealmCompleter.class)
    String keyStoreRealmName;
    @Option(name="roles", activator=OptionActivators.RolesActivator.class)
    String roles;
    private final AuthFactorySpec factorySpec;

    protected AbstractEnableAuthenticationCommand(AuthFactorySpec factorySpec) {
        this.factorySpec = factorySpec;
    }

    public AuthFactorySpec getFactorySpec() {
        return this.factorySpec;
    }

    protected abstract String getMechanism();

    protected abstract void secure(CommandContext var1, AuthSecurityBuilder var2) throws Exception;

    protected abstract String getOOTBFactory(CommandContext var1) throws Exception;

    protected abstract String getSecuredEndpoint(CommandContext var1);

    protected abstract String getEnabledFactory(CommandContext var1) throws Exception;

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        AuthSecurityBuilder builder;
        CommandContext ctx = commandInvocation.getCommandContext();
        try {
            builder = this.buildSecurityRequest(ctx);
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        if (!builder.isEmpty()) {
            SecurityCommand.execute(ctx, builder.getRequest(), SecurityCommand.DEFAULT_FAILURE_CONSUMER, !this.shouldReload());
            commandInvocation.getCommandContext().printLine("Command success.");
            commandInvocation.getCommandContext().printLine("Authentication configured for " + this.getSecuredEndpoint(commandInvocation.getCommandContext()));
            if (builder.getReferencedSecurityDomain() != null) {
                commandInvocation.getCommandContext().printLine("security domain=" + builder.getReferencedSecurityDomain());
            } else {
                commandInvocation.getCommandContext().printLine(this.factorySpec.getName() + " authentication-factory=" + builder.getAuthFactory().getName());
                commandInvocation.getCommandContext().printLine("security-domain=" + builder.getAuthFactory().getSecurityDomain().getName());
            }
        } else {
            commandInvocation.getCommandContext().printLine("Authentication is already enabled for " + this.getSecuredEndpoint(commandInvocation.getCommandContext()));
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        try {
            return this.buildSecurityRequest(context).getRequest();
        }
        catch (Exception ex) {
            throw new CommandFormatException(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage());
        }
    }

    protected AuthSecurityBuilder buildSecurityRequest(CommandContext context) throws Exception {
        AuthSecurityBuilder builder = this.buildSecurityBuilder(context);
        if (builder == null) {
            String factoryName = this.getOOTBFactory(context);
            AuthFactory factory = ElytronUtil.getAuthFactory(factoryName, this.getFactorySpec(), context);
            if (factory == null) {
                throw new Exception("Can't enable " + this.factorySpec.getName() + " authentication, " + factoryName + " doesn't exist");
            }
            builder = new AuthSecurityBuilder(factory);
        }
        builder.buildRequest(context);
        if (!builder.isFactoryAlreadySet()) {
            this.secure(context, builder);
        }
        return builder;
    }

    private AuthSecurityBuilder buildSecurityBuilder(CommandContext context) throws Exception {
        AuthMechanism mec = this.buildAuthMechanism(context);
        if (mec != null) {
            return this.buildSecurityBuilder(context, mec);
        }
        return null;
    }

    private AuthSecurityBuilder buildSecurityBuilder(CommandContext ctx, AuthMechanism mec) throws Exception {
        String existingFactory = this.getEnabledFactory(ctx);
        AuthSecurityBuilder builder = new AuthSecurityBuilder(mec, this.getFactorySpec());
        builder.setActiveFactoryName(existingFactory);
        this.configureBuilder(builder);
        return builder;
    }

    protected MechanismConfiguration buildLocalUserConfiguration(CommandContext ctx, boolean superUser) throws CommandException, IOException, OperationFormatException {
        if (!ElytronUtil.localUserExists(ctx)) {
            throw new CommandException("Can't configure 'local' user, no such identity.");
        }
        return new LocalUserConfiguration(superUser);
    }

    public static void throwInvalidOptions() throws CommandException {
        throw new CommandException("You must only set a single mechanism.");
    }

    protected static MechanismConfiguration buildExternalConfiguration(CommandContext ctx, String keyStore, String keyStoreRealmName, String roles) throws CommandException, IOException, OperationFormatException {
        if (keyStore == null && keyStoreRealmName == null) {
            throw new CommandException("A key-store name or key-store realm name must be set");
        }
        if (keyStore != null && keyStoreRealmName != null) {
            throw new CommandException("Only one of a key-store name or key-store realm name must be set");
        }
        ArrayList<String> parsedRoles = null;
        if (roles != null) {
            String[] lst = roles.split(",");
            parsedRoles = new ArrayList<String>();
            for (String r : lst) {
                parsedRoles.add(r.trim());
            }
        }
        if (keyStore != null) {
            if (!ElytronUtil.keyStoreExists(ctx, keyStore)) {
                throw new CommandException("Can't configure 'certificate' authentication, no key-store " + keyStore);
            }
            return new KeyStoreConfiguration(keyStore, parsedRoles);
        }
        return new ExistingKeyStoreConfiguration(keyStoreRealmName, parsedRoles);
    }

    protected static MechanismConfiguration buildUserPasswordConfiguration(RelativeFile userPropertiesFile, String fileSystemRealm, String userRoleDecoder, String exposedRealmName, RelativeFile groupPropertiesFile, String propertiesRealmName, String relativeTo) throws CommandException, IOException {
        if (userPropertiesFile == null && fileSystemRealm == null && propertiesRealmName == null) {
            throw new CommandException("A properties file or propertie-realm name or a filesystem-realm name must be provided");
        }
        int num = 0;
        if (userPropertiesFile != null) {
            ++num;
        }
        if (propertiesRealmName != null) {
            ++num;
        }
        if (fileSystemRealm != null) {
            ++num;
        }
        if (num > 1) {
            throw new CommandException("Only one of properties file, propertie-realm name or filesystem-realm name must be provided");
        }
        if (userPropertiesFile != null) {
            if (exposedRealmName == null) {
                throw new CommandException(SecurityCommand.formatOption("exposed-realm") + " must be set when using a user properties file");
            }
            PropertiesRealmConfiguration config = new PropertiesRealmConfiguration(exposedRealmName, userPropertiesFile, groupPropertiesFile, relativeTo);
            return config;
        }
        if (propertiesRealmName != null) {
            if (exposedRealmName == null) {
                throw new CommandException(SecurityCommand.formatOption("exposed-realm") + " must be set when using a properties file realm");
            }
            return new ExistingPropertiesRealmConfiguration(propertiesRealmName, exposedRealmName);
        }
        FileSystemRealmConfiguration config = new FileSystemRealmConfiguration(exposedRealmName, fileSystemRealm, userRoleDecoder);
        return config;
    }

    private AuthMechanism buildAuthMechanism(CommandContext context) throws Exception {
        AuthMechanism mec = null;
        if (this.getMechanism() == null) {
            return null;
        }
        List<String> available = ElytronUtil.getAvailableMechanisms(context, this.getFactorySpec());
        if (!available.contains(this.getMechanism())) {
            throw new CommandException("Unavailable mechanism " + this.getMechanism());
        }
        if (ElytronUtil.getMechanismsWithRealm().contains(this.getMechanism())) {
            MechanismConfiguration config = AbstractEnableAuthenticationCommand.buildUserPasswordConfiguration(this.userPropertiesFile, this.fileSystemRealmName, this.userRoleDecoder, this.exposedRealm, this.groupPropertiesFile, this.propertiesRealmName, this.relativeTo);
            mec = new AuthMechanism(this.getMechanism(), config);
        } else if (ElytronUtil.getMechanismsWithTrustStore().contains(this.getMechanism())) {
            MechanismConfiguration config = AbstractEnableAuthenticationCommand.buildExternalConfiguration(context, this.keyStoreName, this.keyStoreRealmName, this.roles);
            mec = new AuthMechanism(this.getMechanism(), config);
        } else if (ElytronUtil.getMechanismsLocalUser().contains(this.getMechanism())) {
            MechanismConfiguration config = this.buildLocalUserConfiguration(context, this.superUser);
            mec = new AuthMechanism(this.getMechanism(), config);
        } else {
            mec = new AuthMechanism(this.getMechanism(), new EmptyConfiguration());
        }
        return mec;
    }

    private boolean shouldReload() {
        return !this.noReload;
    }

    private void configureBuilder(AuthSecurityBuilder builder) {
        builder.setNewRealmName(this.newRealmName).setAuthFactoryName(this.newAuthFactoryName).setSecurityDomainName(this.newSecurityDomain);
    }
}

