/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.jstl.core;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.PageContext;

public class Config {
    public static final String FMT_LOCALE = "jakarta.servlet.jsp.jstl.fmt.locale";
    public static final String FMT_FALLBACK_LOCALE = "jakarta.servlet.jsp.jstl.fmt.fallbackLocale";
    public static final String FMT_LOCALIZATION_CONTEXT = "jakarta.servlet.jsp.jstl.fmt.localizationContext";
    public static final String FMT_TIME_ZONE = "jakarta.servlet.jsp.jstl.fmt.timeZone";
    public static final String SQL_DATA_SOURCE = "jakarta.servlet.jsp.jstl.sql.dataSource";
    public static final String SQL_MAX_ROWS = "jakarta.servlet.jsp.jstl.sql.maxRows";
    private static final String PAGE_SCOPE_SUFFIX = ".page";
    private static final String REQUEST_SCOPE_SUFFIX = ".request";
    private static final String SESSION_SCOPE_SUFFIX = ".session";
    private static final String APPLICATION_SCOPE_SUFFIX = ".application";

    public static Object get(PageContext pageContext, String name, int scope) {
        switch (scope) {
            case 1: {
                return pageContext.getAttribute(name + PAGE_SCOPE_SUFFIX, scope);
            }
            case 2: {
                return pageContext.getAttribute(name + REQUEST_SCOPE_SUFFIX, scope);
            }
            case 3: {
                return Config.get(pageContext.getSession(), name);
            }
            case 4: {
                return pageContext.getAttribute(name + APPLICATION_SCOPE_SUFFIX, scope);
            }
        }
        throw new IllegalArgumentException("unknown scope");
    }

    public static Object get(ServletRequest request, String name) {
        return request.getAttribute(name + REQUEST_SCOPE_SUFFIX);
    }

    public static Object get(HttpSession session, String name) {
        Object ret = null;
        if (session != null) {
            try {
                ret = session.getAttribute(name + SESSION_SCOPE_SUFFIX);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Object get(ServletContext context, String name) {
        return context.getAttribute(name + APPLICATION_SCOPE_SUFFIX);
    }

    public static void set(PageContext pageContext, String name, Object value, int scope) {
        switch (scope) {
            case 1: {
                pageContext.setAttribute(name + PAGE_SCOPE_SUFFIX, value, scope);
                break;
            }
            case 2: {
                pageContext.setAttribute(name + REQUEST_SCOPE_SUFFIX, value, scope);
                break;
            }
            case 3: {
                pageContext.setAttribute(name + SESSION_SCOPE_SUFFIX, value, scope);
                break;
            }
            case 4: {
                pageContext.setAttribute(name + APPLICATION_SCOPE_SUFFIX, value, scope);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
    }

    public static void set(ServletRequest request, String name, Object value) {
        request.setAttribute(name + REQUEST_SCOPE_SUFFIX, value);
    }

    public static void set(HttpSession session, String name, Object value) {
        session.setAttribute(name + SESSION_SCOPE_SUFFIX, value);
    }

    public static void set(ServletContext context, String name, Object value) {
        context.setAttribute(name + APPLICATION_SCOPE_SUFFIX, value);
    }

    public static void remove(PageContext pageContext, String name, int scope) {
        switch (scope) {
            case 1: {
                pageContext.removeAttribute(name + PAGE_SCOPE_SUFFIX, scope);
                break;
            }
            case 2: {
                pageContext.removeAttribute(name + REQUEST_SCOPE_SUFFIX, scope);
                break;
            }
            case 3: {
                pageContext.removeAttribute(name + SESSION_SCOPE_SUFFIX, scope);
                break;
            }
            case 4: {
                pageContext.removeAttribute(name + APPLICATION_SCOPE_SUFFIX, scope);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
    }

    public static void remove(ServletRequest request, String name) {
        request.removeAttribute(name + REQUEST_SCOPE_SUFFIX);
    }

    public static void remove(HttpSession session, String name) {
        session.removeAttribute(name + SESSION_SCOPE_SUFFIX);
    }

    public static void remove(ServletContext context, String name) {
        context.removeAttribute(name + APPLICATION_SCOPE_SUFFIX);
    }

    public static Object find(PageContext pageContext, String name) {
        Object ret = Config.get(pageContext, name, 1);
        if (ret == null && (ret = Config.get(pageContext, name, 2)) == null) {
            if (pageContext.getSession() != null) {
                ret = Config.get(pageContext, name, 3);
            }
            if (ret == null && (ret = Config.get(pageContext, name, 4)) == null) {
                ret = pageContext.getServletContext().getInitParameter(name);
            }
        }
        return ret;
    }
}

