"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../../src/lib/documents");
const getSelectionRanges_1 = require("../../../../src/plugins/svelte/features/getSelectionRanges");
const SvelteDocument_1 = require("../../../../src/plugins/svelte/SvelteDocument");
describe('SveltePlugin#getSelectionRange', () => {
    const CURSOR = '|';
    async function expectToEqual(contentWithCursor, expected) {
        const svelteDoc = new SvelteDocument_1.SvelteDocument(new documents_1.Document('url', contentWithCursor.replace(CURSOR, '')));
        const selectionRange = await (0, getSelectionRanges_1.getSelectionRange)(svelteDoc, vscode_languageserver_1.Position.create(0, contentWithCursor.indexOf(CURSOR)));
        assert.deepStrictEqual(selectionRange, expected);
    }
    it('should return null for style and script', async () => {
        await expectToEqual('<style>|</style>', null);
        await expectToEqual('<script>|</script>', null);
    });
    it('get selection range for element and attribute', () => {
        return expectToEqual('<h1 title="foo|"></h1>', {
            parent: {
                parent: {
                    parent: undefined,
                    range: {
                        start: {
                            line: 0,
                            character: 0
                        },
                        end: {
                            line: 0,
                            character: 21
                        }
                    }
                },
                range: {
                    start: {
                        line: 0,
                        character: 4
                    },
                    end: {
                        line: 0,
                        character: 15
                    }
                }
            },
            range: {
                start: {
                    line: 0,
                    character: 11
                },
                end: {
                    line: 0,
                    character: 14
                }
            }
        });
    });
    it('get selection range for svelte blocks', () => {
        return expectToEqual('{#if a > 1}|foo{/if}', {
            parent: {
                parent: undefined,
                // if block
                range: {
                    start: {
                        line: 0,
                        character: 0
                    },
                    end: {
                        line: 0,
                        character: 19
                    }
                }
            },
            // text
            range: {
                start: {
                    line: 0,
                    character: 11
                },
                end: {
                    line: 0,
                    character: 14
                }
            }
        });
    });
});
//# sourceMappingURL=getSelectionRange.test.js.map