/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import org.apache.tomcat.util.digester.ArrayStack;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class CallParamRule
extends Rule {
    protected final String attributeName;
    protected final int paramIndex;
    protected final boolean fromStack;
    protected final int stackIndex;
    protected ArrayStack<String> bodyTextStack;

    public CallParamRule(int n) {
        this(n, null);
    }

    public CallParamRule(int n, String string) {
        this(string, n, 0, false);
    }

    private CallParamRule(String string, int n, int n2, boolean bl) {
        this.attributeName = string;
        this.paramIndex = n;
        this.stackIndex = n2;
        this.fromStack = bl;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Object object;
        Object object2 = null;
        if (this.attributeName != null) {
            object2 = attributes.getValue(this.attributeName);
        } else if (this.fromStack) {
            object2 = this.digester.peek(this.stackIndex);
            if (this.digester.log.isTraceEnabled()) {
                object = new StringBuilder("[CallParamRule]{");
                ((StringBuilder)object).append(this.digester.match);
                ((StringBuilder)object).append("} Save from stack; from stack?").append(this.fromStack);
                ((StringBuilder)object).append("; object=").append(object2);
                this.digester.log.trace((Object)((StringBuilder)object).toString());
            }
        }
        if (object2 != null) {
            object = (Object[])this.digester.peekParams();
            object[this.paramIndex] = object2;
        }
    }

    @Override
    public void body(String string, String string2, String string3) throws Exception {
        if (this.attributeName == null && !this.fromStack) {
            if (this.bodyTextStack == null) {
                this.bodyTextStack = new ArrayStack();
            }
            this.bodyTextStack.push(string3.trim());
        }
    }

    @Override
    public void end(String string, String string2) {
        if (this.bodyTextStack != null && !this.bodyTextStack.empty()) {
            Object[] objectArray = (Object[])this.digester.peekParams();
            objectArray[this.paramIndex] = this.bodyTextStack.pop();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CallParamRule[");
        stringBuilder.append("paramIndex=");
        stringBuilder.append(this.paramIndex);
        stringBuilder.append(", attributeName=");
        stringBuilder.append(this.attributeName);
        stringBuilder.append(", from stack=");
        stringBuilder.append(this.fromStack);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

