/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm;

import net.sourceforge.plantuml.project.ngm.math.Fraction;

public final class NGMTotalEffort {
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private final long seconds;

    private NGMTotalEffort(long seconds) {
        if (seconds < 0L) {
            throw new IllegalArgumentException("Effort cannot be negative: " + seconds);
        }
        this.seconds = seconds;
    }

    public static NGMTotalEffort ofSeconds(long seconds) {
        return new NGMTotalEffort(seconds);
    }

    public static NGMTotalEffort ofMinutes(long minutes) {
        return new NGMTotalEffort(minutes * 60L);
    }

    public static NGMTotalEffort ofHours(long hours) {
        return new NGMTotalEffort(hours * 3600L);
    }

    public static NGMTotalEffort ofHoursAndMinutes(long hours, long minutes) {
        return new NGMTotalEffort(hours * 3600L + minutes * 60L);
    }

    public static NGMTotalEffort ofDays(long days) {
        return new NGMTotalEffort(days * 86400L);
    }

    public static NGMTotalEffort zero() {
        return new NGMTotalEffort(0L);
    }

    public Fraction toSeconds() {
        return new Fraction(this.seconds, 1L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NGMTotalEffort)) {
            return false;
        }
        NGMTotalEffort other = (NGMTotalEffort)obj;
        return this.seconds == other.seconds;
    }

    public String toString() {
        return super.toString();
    }
}

