/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;

public class ShardTerms
implements MapWriter {
    private static final String RECOVERING_TERM_SUFFIX = "_recovering";
    private final Map<String, Long> values;
    private final long maxTerm;
    private final int version;

    public ShardTerms() {
        this(new HashMap<String, Long>(), 0);
    }

    public ShardTerms(ShardTerms newTerms, int version) {
        this(newTerms.values, version);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.values.forEach(ew.getBiConsumer());
    }

    public ShardTerms(Map<String, Long> values, int version) {
        this.values = values;
        this.version = version;
        this.maxTerm = values.isEmpty() ? 0L : Collections.max(values.values());
    }

    public boolean canBecomeLeader(String coreNodeName) {
        return this.haveHighestTermValue(coreNodeName) && !this.values.containsKey(ShardTerms.recoveringTerm(coreNodeName));
    }

    public boolean haveHighestTermValue(String coreNodeName) {
        if (this.values.isEmpty()) {
            return true;
        }
        return this.values.getOrDefault(coreNodeName, 0L) == this.maxTerm;
    }

    public Long getTerm(String coreNodeName) {
        return this.values.get(coreNodeName);
    }

    public ShardTerms increaseTerms(String leader, Set<String> replicasNeedingRecovery) {
        if (!this.values.containsKey(leader)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find leader's term " + leader);
        }
        boolean saveChanges = false;
        boolean foundReplicasInLowerTerms = false;
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        long leaderTerm = newValues.get(leader);
        for (Map.Entry<String, Long> entry : newValues.entrySet()) {
            String key = entry.getKey();
            if (replicasNeedingRecovery.contains(key)) {
                foundReplicasInLowerTerms = true;
            }
            if (!Objects.equals(entry.getValue(), leaderTerm)) continue;
            if (this.skipIncreaseTermOf(key, replicasNeedingRecovery)) {
                saveChanges = true;
                continue;
            }
            entry.setValue(leaderTerm + 1L);
        }
        if (!saveChanges && foundReplicasInLowerTerms) {
            return null;
        }
        return new ShardTerms(newValues, this.version);
    }

    private boolean skipIncreaseTermOf(String key, Set<String> replicasNeedingRecovery) {
        if (key.endsWith(RECOVERING_TERM_SUFFIX)) {
            key = key.substring(0, key.length() - RECOVERING_TERM_SUFFIX.length());
        }
        return replicasNeedingRecovery.contains(key);
    }

    public ShardTerms ensureHighestTermsAreNotZero() {
        if (this.maxTerm > 0L) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        for (String replica : this.values.keySet()) {
            newValues.put(replica, 1L);
        }
        return new ShardTerms(newValues, this.version);
    }

    public ShardTerms removeTerm(String coreNodeName) {
        if (!this.values.containsKey(ShardTerms.recoveringTerm(coreNodeName)) && !this.values.containsKey(coreNodeName)) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        newValues.remove(coreNodeName);
        newValues.remove(ShardTerms.recoveringTerm(coreNodeName));
        return new ShardTerms(newValues, this.version);
    }

    public ShardTerms registerTerm(String coreNodeName) {
        if (this.values.containsKey(coreNodeName)) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        newValues.put(coreNodeName, 0L);
        return new ShardTerms(newValues, this.version);
    }

    public ShardTerms setTermToZero(String coreNodeName) {
        if (this.values.getOrDefault(coreNodeName, -1L) == 0L) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        newValues.put(coreNodeName, 0L);
        return new ShardTerms(newValues, this.version);
    }

    public ShardTerms setTermEqualsToLeader(String coreNodeName) {
        if (this.values.get(coreNodeName) == this.maxTerm) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        newValues.put(coreNodeName, this.maxTerm);
        newValues.remove(ShardTerms.recoveringTerm(coreNodeName));
        return new ShardTerms(newValues, this.version);
    }

    public long getMaxTerm() {
        return this.maxTerm;
    }

    public ShardTerms startRecovering(String coreNodeName) {
        if (this.values.get(coreNodeName) == this.maxTerm) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        if (!newValues.containsKey(ShardTerms.recoveringTerm(coreNodeName))) {
            long currentTerm = newValues.getOrDefault(coreNodeName, 0L);
            newValues.put(ShardTerms.recoveringTerm(coreNodeName), currentTerm);
        }
        newValues.put(coreNodeName, this.maxTerm);
        return new ShardTerms(newValues, this.version);
    }

    public ShardTerms doneRecovering(String coreNodeName) {
        if (!this.values.containsKey(ShardTerms.recoveringTerm(coreNodeName))) {
            return null;
        }
        HashMap<String, Long> newValues = new HashMap<String, Long>(this.values);
        newValues.remove(ShardTerms.recoveringTerm(coreNodeName));
        return new ShardTerms(newValues, this.version);
    }

    public static String recoveringTerm(String coreNodeName) {
        return coreNodeName + RECOVERING_TERM_SUFFIX;
    }

    public String toString() {
        return "Terms{values=" + String.valueOf(this.values) + ", version=" + this.version + "}";
    }

    public int getVersion() {
        return this.version;
    }

    public Map<String, Long> getTerms() {
        return new HashMap<String, Long>(this.values);
    }

    public boolean isRecovering(String name) {
        return this.values.containsKey(ShardTerms.recoveringTerm(name));
    }
}

