/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeSpace;
import org.apache.calcite.materialize.LatticeTable;
import org.apache.calcite.materialize.MutableNode;
import org.apache.calcite.materialize.Path;
import org.apache.calcite.materialize.Step;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.graph.AttributedDirectedGraph;
import org.apache.calcite.util.graph.CycleDetector;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.calcite.util.mapping.IntPair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LatticeSuggester {
    final LatticeSpace space;
    private static final HepProgram PROGRAM = new HepProgramBuilder().addRuleInstance(CoreRules.FILTER_INTO_JOIN).addRuleInstance(CoreRules.JOIN_CONDITION_PUSH).build();
    final Map<String, Lattice> latticeMap = new LinkedHashMap<String, Lattice>();
    private final Map<Lattice, Lattice> obsoleteLatticeMap = new HashMap<Lattice, Lattice>();
    private final boolean evolve;

    public LatticeSuggester(FrameworkConfig config) {
        this.evolve = config.isEvolveLattice();
        this.space = new LatticeSpace(config.getStatisticProvider());
    }

    public Set<Lattice> getLatticeSet() {
        LinkedHashSet<Lattice> set = new LinkedHashSet<Lattice>(this.latticeMap.values());
        set.removeAll(this.obsoleteLatticeMap.keySet());
        return ImmutableSet.copyOf(set);
    }

    public RexNode toRex(LatticeTable table, int column) {
        List<RelDataTypeField> fieldList = table.t.getRowType().getFieldList();
        if (column < fieldList.size()) {
            return new RexInputRef(column, fieldList.get(column).getType());
        }
        return Objects.requireNonNull(this.space.tableExpressions.get(table), () -> "space.tableExpressions.get(table) is null for " + table).get(column - fieldList.size());
    }

    public List<Lattice> addQuery(RelNode r) {
        HepPlanner planner = new HepPlanner(PROGRAM, null, true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(r);
        RelNode r2 = planner.findBestExp();
        Query q = new Query(this.space);
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        LatticeSuggester.frames(frameList, q, r2);
        ArrayList lattices = new ArrayList();
        frameList.forEach(frame -> this.addFrame(q, (Frame)frame, lattices));
        return ImmutableList.copyOf(lattices);
    }

    private void addFrame(Query q, Frame frame, List<Lattice> lattices) {
        AttributedDirectedGraph<TableRef, StepRef> g = AttributedDirectedGraph.create(new StepRef.Factory());
        LinkedListMultimap map = LinkedListMultimap.create();
        for (TableRef tableRef : frame.tableRefs) {
            g.addVertex(tableRef);
        }
        for (Hop hop : frame.hops) {
            map.put(Pair.of(hop.source.tableRef(), hop.target.tableRef()), (Object)IntPair.of(hop.source.col(this.space), hop.target.col(this.space)));
        }
        for (Map.Entry entry : map.asMap().entrySet()) {
            TableRef source = (TableRef)((Pair)entry.getKey()).left;
            TableRef target = (TableRef)((Pair)entry.getKey()).right;
            StepRef stepRef = q.stepRef(source, target, (List<IntPair>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            g.addVertex(stepRef.source());
            g.addVertex(stepRef.target());
            g.addEdge(stepRef.source(), stepRef.target(), stepRef.step, stepRef.ordinalInQuery);
        }
        Set<TableRef> cycles = new CycleDetector<TableRef, StepRef>(g).findCycles();
        if (!cycles.isEmpty()) {
            return;
        }
        IdentityHashMap<TableRef, @Nullable MutableNode> identityHashMap = new IdentityHashMap<TableRef, MutableNode>();
        HashMap<List<List<IntPair>>, MutableNode> nodesByParent = new HashMap<List<List<IntPair>>, MutableNode>();
        ArrayList<MutableNode> rootNodes = new ArrayList<MutableNode>();
        for (TableRef tableRef : TopologicalOrderIterator.of(g)) {
            MutableNode node;
            List edges = g.getInwardEdges(tableRef);
            switch (edges.size()) {
                case 0: {
                    node = new MutableNode(tableRef.table);
                    rootNodes.add(node);
                    break;
                }
                case 1: {
                    StepRef edge = (StepRef)edges.get(0);
                    MutableNode parent = (MutableNode)identityHashMap.get(edge.source());
                    List<List<IntPair>> key = FlatLists.of(parent, tableRef.table, edge.step.keys);
                    MutableNode existingNode = (MutableNode)nodesByParent.get(key);
                    if (existingNode == null) {
                        node = new MutableNode(tableRef.table, parent, edge.step);
                        nodesByParent.put(key, node);
                        break;
                    }
                    node = existingNode;
                    break;
                }
                default: {
                    for (StepRef edge2 : edges) {
                        MutableNode parent2 = (MutableNode)identityHashMap.get(edge2.source());
                        Objects.requireNonNull(parent2, () -> "parent for " + edge2.source());
                        MutableNode node2 = new MutableNode(tableRef.table, parent2, edge2.step);
                        parent2.children.add(node2);
                    }
                    node = null;
                }
            }
            identityHashMap.put(tableRef, node);
        }
        for (MutableNode rootNode : rootNodes) {
            if (rootNode.isCyclic()) continue;
            CalciteSchema rootSchema = CalciteSchema.createRootSchema(false);
            Lattice.Builder latticeBuilder = new Lattice.Builder(this.space, rootSchema, rootNode);
            ArrayList<MutableNode> flatNodes = new ArrayList<MutableNode>();
            rootNode.flatten(flatNodes);
            for (MutableMeasure measure : frame.measures) {
                for (ColRef colRef2 : measure.arguments) {
                    if (colRef2 != null) continue;
                    return;
                }
                latticeBuilder.addMeasure(new Lattice.Measure(measure.aggregate, measure.distinct, measure.name, Util.transform(measure.arguments, colRef -> {
                    Lattice.Column column;
                    if (colRef instanceof BaseColRef) {
                        BaseColRef baseColRef = (BaseColRef)colRef;
                        MutableNode node = (MutableNode)nodes.get(baseColRef.t);
                        int table = flatNodes.indexOf(node);
                        column = latticeBuilder.column(table, baseColRef.c);
                    } else if (colRef instanceof DerivedColRef) {
                        DerivedColRef derivedColRef = (DerivedColRef)colRef;
                        String alias = LatticeSuggester.deriveAlias(measure, derivedColRef);
                        column = latticeBuilder.expression(derivedColRef.e, alias, derivedColRef.tableAliases());
                    } else {
                        throw new AssertionError((Object)"expression in measure");
                    }
                    latticeBuilder.use(column, true);
                    return column;
                })));
            }
            for (int i = 0; i < frame.columnCount; ++i) {
                ColRef c = frame.column(i);
                if (!(c instanceof DerivedColRef)) continue;
                DerivedColRef derivedColRef = (DerivedColRef)c;
                Lattice.Column column = latticeBuilder.expression(derivedColRef.e, derivedColRef.alias, derivedColRef.tableAliases());
                latticeBuilder.use(column, false);
            }
            Lattice lattice0 = latticeBuilder.build();
            Lattice lattice1 = this.findMatch(lattice0, rootNode);
            lattices.add(lattice1);
        }
    }

    private static String deriveAlias(MutableMeasure measure, DerivedColRef derivedColRef) {
        if (!derivedColRef.alias.contains("$")) {
            return derivedColRef.alias;
        }
        String alias = Objects.requireNonNull(measure.name, "measure.name");
        if (alias.contains("$")) {
            return derivedColRef.alias;
        }
        String aggUpper = measure.aggregate.getName().toUpperCase(Locale.ROOT);
        String aliasUpper = alias.toUpperCase(Locale.ROOT);
        if (aliasUpper.startsWith(aggUpper + "_")) {
            return alias.substring((aggUpper + "_").length());
        }
        if (aliasUpper.startsWith(aggUpper)) {
            return alias.substring(aggUpper.length());
        }
        if (aliasUpper.endsWith("_" + aggUpper)) {
            return alias.substring(0, alias.length() - ("_" + aggUpper).length());
        }
        if (aliasUpper.endsWith(aggUpper)) {
            return alias.substring(0, alias.length() - aggUpper.length());
        }
        return alias;
    }

    private Lattice findMatch(Lattice lattice, MutableNode mutableNode) {
        Lattice lattice1 = this.latticeMap.get(lattice.toString());
        if (lattice1 != null) {
            return lattice1;
        }
        if (this.evolve) {
            int bestMatchQuality = 0;
            Lattice bestMatch = null;
            for (Lattice lattice2 : this.latticeMap.values()) {
                int q = LatticeSuggester.matchQuality(lattice2, lattice);
                if (q > bestMatchQuality) {
                    bestMatch = lattice2;
                    bestMatchQuality = q;
                    continue;
                }
                if (q != bestMatchQuality || bestMatch == null || lattice2.rootNode.paths.equals(bestMatch.rootNode.paths) || !lattice2.rootNode.paths.containsAll(bestMatch.rootNode.paths)) continue;
                bestMatch = lattice2;
            }
            if (bestMatch != null) {
                for (Path path : LatticeSuggester.minus(bestMatch.rootNode.paths, lattice.rootNode.paths)) {
                    mutableNode.addPath(path, null);
                }
                CalciteSchema rootSchema = CalciteSchema.createRootSchema(false);
                Lattice.Builder builder = new Lattice.Builder(this.space, rootSchema, mutableNode);
                LatticeSuggester.copyMeasures(builder, bestMatch);
                LatticeSuggester.copyMeasures(builder, lattice);
                Lattice lattice2 = builder.build();
                this.latticeMap.remove(bestMatch.toString());
                this.obsoleteLatticeMap.put(bestMatch, lattice2);
                this.latticeMap.put(lattice2.toString(), lattice2);
                return lattice2;
            }
        }
        this.latticeMap.put(lattice.toString(), lattice);
        return lattice;
    }

    private static void copyMeasures(Lattice.Builder builder, Lattice lattice) {
        Function<Lattice.Column, Lattice.Column> mapper = c -> {
            if (c instanceof Lattice.BaseColumn) {
                Lattice.BaseColumn baseColumn = (Lattice.BaseColumn)c;
                Pair<Path, Integer> p = lattice.columnToPathOffset(baseColumn);
                return builder.pathOffsetToColumn((Path)p.left, (Integer)p.right);
            }
            Lattice.DerivedColumn derivedColumn = (Lattice.DerivedColumn)c;
            return builder.expression(derivedColumn.e, derivedColumn.alias, derivedColumn.tables);
        };
        for (Lattice.Measure measure : lattice.defaultMeasures) {
            builder.addMeasure(measure.copy(mapper));
        }
        for (Map.Entry entry : lattice.columnUses.entries()) {
            Lattice.Column column = (Lattice.Column)lattice.columns.get(((Integer)entry.getKey()).intValue());
            builder.use(mapper.apply(column), (Boolean)entry.getValue());
        }
    }

    private static int matchQuality(Lattice lattice, Lattice target) {
        if (!lattice.rootNode.table.equals(target.rootNode.table)) {
            return 0;
        }
        if (lattice.rootNode.paths.equals(target.rootNode.paths)) {
            return 3;
        }
        if (lattice.rootNode.paths.containsAll(target.rootNode.paths)) {
            return 2;
        }
        return 1;
    }

    private static <E> Set<E> minus(Collection<E> c, Collection<E> c2) {
        LinkedHashSet<E> c3 = new LinkedHashSet<E>(c);
        c3.removeAll(c2);
        return c3;
    }

    private static void frames(List<Frame> frames, Query q, RelNode r) {
        if (r instanceof SetOp) {
            r.getInputs().forEach(input -> LatticeSuggester.frames(frames, q, input));
        } else {
            Frame frame = LatticeSuggester.frame(q, r);
            if (frame != null) {
                frames.add(frame);
            }
        }
    }

    private static @Nullable Frame frame(Query q, RelNode r) {
        if (r instanceof Sort) {
            Sort sort = (Sort)r;
            return LatticeSuggester.frame(q, sort.getInput());
        }
        if (r instanceof Filter) {
            Filter filter = (Filter)r;
            return LatticeSuggester.frame(q, filter.getInput());
        }
        if (r instanceof Aggregate) {
            final Aggregate aggregate = (Aggregate)r;
            final Frame h = LatticeSuggester.frame(q, aggregate.getInput());
            if (h == null) {
                return null;
            }
            ArrayList<MutableMeasure> measures = new ArrayList<MutableMeasure>();
            for (AggregateCall call : aggregate.getAggCallList()) {
                measures.add(new MutableMeasure(call.getAggregation(), call.isDistinct(), Util.transform(call.getArgList(), h::column), call.name));
            }
            int fieldCount = r.getRowType().getFieldCount();
            return new Frame(fieldCount, h.hops, measures, (List)ImmutableList.of((Object)h)){

                @Override
                @Nullable ColRef column(int offset) {
                    if (offset < aggregate.getGroupSet().cardinality()) {
                        return h.column(aggregate.getGroupSet().nth(offset));
                    }
                    return null;
                }
            };
        }
        if (r instanceof Project) {
            final Project project = (Project)r;
            final Frame h = LatticeSuggester.frame(q, project.getInput());
            if (h == null) {
                return null;
            }
            int fieldCount = r.getRowType().getFieldCount();
            return new Frame(fieldCount, h.hops, h.measures, (List)ImmutableList.of((Object)h)){
                final List<@Nullable ColRef> columns;
                {
                    super(columnCount, (List<Hop>)hops, (List<MutableMeasure>)measures, inputs);
                    ImmutableNullableList.Builder<ColRef> columnBuilder = ImmutableNullableList.builder();
                    for (Pair<RexNode, String> p : project.getNamedProjects()) {
                        ColRef colRef = this.toColRef((RexNode)p.left, (String)p.right);
                        columnBuilder.add(colRef);
                    }
                    this.columns = columnBuilder.build();
                }

                @Override
                @Nullable ColRef column(int offset) {
                    return this.columns.get(offset);
                }

                private @Nullable ColRef toColRef(RexNode e, String alias) {
                    if (e instanceof RexInputRef) {
                        return h.column(((RexInputRef)e).getIndex());
                    }
                    ImmutableBitSet bits = RelOptUtil.InputFinder.bits(e);
                    ImmutableList.Builder tableRefs = ImmutableList.builder();
                    int c = 0;
                    for (TableRef tableRef : h.tableRefs) {
                        int prev = c;
                        if (!bits.intersects(ImmutableBitSet.range(prev, c += tableRef.table.t.getRowType().getFieldCount()))) continue;
                        tableRefs.add((Object)tableRef);
                    }
                    ImmutableList tableRefList = tableRefs.build();
                    switch (tableRefList.size()) {
                        case 1: {
                            return new SingleTableDerivedColRef((TableRef)tableRefList.get(0), e, alias);
                        }
                    }
                    return new DerivedColRef((Iterable<TableRef>)tableRefList, e, alias);
                }
            };
        }
        if (r instanceof Join) {
            Join join = (Join)r;
            final int leftCount = join.getLeft().getRowType().getFieldCount();
            final Frame left = LatticeSuggester.frame(q, join.getLeft());
            final Frame right = LatticeSuggester.frame(q, join.getRight());
            if (left == null || right == null) {
                return null;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(left.hops);
            for (IntPair p : join.analyzeCondition().pairs()) {
                ColRef source = left.column(p.source);
                ColRef target = right.column(p.target);
                assert (source instanceof SingleTableColRef);
                assert (target instanceof SingleTableColRef);
                builder.add((Object)new Hop((SingleTableColRef)((Object)source), (SingleTableColRef)((Object)target)));
            }
            builder.addAll(right.hops);
            int fieldCount = r.getRowType().getFieldCount();
            return new Frame(fieldCount, (List)builder.build(), CompositeList.of(left.measures, right.measures), (List)ImmutableList.of((Object)left, (Object)right)){

                @Override
                @Nullable ColRef column(int offset) {
                    if (offset < leftCount) {
                        return left.column(offset);
                    }
                    return right.column(offset - leftCount);
                }
            };
        }
        if (r instanceof TableScan) {
            final TableScan scan = (TableScan)r;
            final TableRef tableRef = q.tableRef(scan);
            int fieldCount = r.getRowType().getFieldCount();
            return new Frame(fieldCount, (List)ImmutableList.of(), (List)ImmutableList.of(), (Collection)ImmutableSet.of((Object)tableRef)){

                @Override
                ColRef column(int offset) {
                    if (offset >= scan.getTable().getRowType().getFieldCount()) {
                        throw new IndexOutOfBoundsException("field " + offset + " out of range in " + scan.getTable().getRowType());
                    }
                    return new BaseColRef(tableRef, offset);
                }
            };
        }
        return null;
    }

    private static class MutableMeasure {
        final SqlAggFunction aggregate;
        final boolean distinct;
        final List<? extends @Nullable ColRef> arguments;
        final @Nullable String name;

        private MutableMeasure(SqlAggFunction aggregate, boolean distinct, List<? extends @Nullable ColRef> arguments, @Nullable String name) {
            this.aggregate = aggregate;
            this.arguments = arguments;
            this.distinct = distinct;
            this.name = name;
        }
    }

    private static class SingleTableDerivedColRef
    extends DerivedColRef
    implements SingleTableColRef {
        SingleTableDerivedColRef(TableRef tableRef, RexNode e, String alias) {
            super((Iterable<TableRef>)ImmutableList.of((Object)tableRef), e, alias);
        }

        @Override
        public TableRef tableRef() {
            return (TableRef)this.tableRefs.get(0);
        }

        @Override
        public int col(LatticeSpace space) {
            return space.registerExpression(this.tableRef().table, this.e);
        }
    }

    private static class DerivedColRef
    extends ColRef {
        final List<TableRef> tableRefs;
        final RexNode e;
        final String alias;

        DerivedColRef(Iterable<TableRef> tableRefs, RexNode e, String alias) {
            this.tableRefs = ImmutableList.copyOf(tableRefs);
            this.e = e;
            this.alias = alias;
        }

        List<String> tableAliases() {
            return Util.transform(this.tableRefs, tableRef -> tableRef.table.alias);
        }
    }

    private static class BaseColRef
    extends ColRef
    implements SingleTableColRef {
        final TableRef t;
        final int c;

        private BaseColRef(TableRef t, int c) {
            this.t = t;
            this.c = c;
        }

        @Override
        public TableRef tableRef() {
            return this.t;
        }

        @Override
        public int col(LatticeSpace space) {
            return this.c;
        }
    }

    private static interface SingleTableColRef {
        public TableRef tableRef();

        public int col(LatticeSpace var1);
    }

    private static abstract class ColRef {
        private ColRef() {
        }
    }

    private static class Hop {
        final SingleTableColRef source;
        final SingleTableColRef target;

        private Hop(SingleTableColRef source, SingleTableColRef target) {
            this.source = source;
            this.target = target;
        }
    }

    private static class StepRef
    extends DefaultEdge {
        final Step step;
        private final int ordinalInQuery;

        StepRef(TableRef source, TableRef target, Step step, int ordinalInQuery) {
            super(source, target);
            this.step = Objects.requireNonNull(step, "step");
            this.ordinalInQuery = ordinalInQuery;
        }

        @Override
        public int hashCode() {
            return this.ordinalInQuery;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof StepRef && ((StepRef)obj).ordinalInQuery == this.ordinalInQuery;
        }

        @Override
        public String toString() {
            return "StepRef(" + this.source + ", " + this.target + "," + this.step.keyString + "):" + this.ordinalInQuery;
        }

        TableRef source() {
            return (TableRef)this.source;
        }

        TableRef target() {
            return (TableRef)this.target;
        }

        private static class Factory
        implements AttributedDirectedGraph.AttributedEdgeFactory<TableRef, StepRef> {
            private Factory() {
            }

            @Override
            public StepRef createEdge(TableRef source, TableRef target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public StepRef createEdge(TableRef source, TableRef target, Object ... attributes) {
                Step step = (Step)attributes[0];
                Integer ordinalInQuery = (Integer)attributes[1];
                return new StepRef(source, target, step, ordinalInQuery);
            }
        }
    }

    private static class TableRef {
        final LatticeTable table;
        private final int ordinalInQuery;

        private TableRef(LatticeTable table, int ordinalInQuery) {
            this.table = Objects.requireNonNull(table, "table");
            this.ordinalInQuery = ordinalInQuery;
        }

        public int hashCode() {
            return this.ordinalInQuery;
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof TableRef && this.ordinalInQuery == ((TableRef)obj).ordinalInQuery;
        }

        public String toString() {
            return this.table + ":" + this.ordinalInQuery;
        }
    }

    static abstract class Frame {
        final List<Hop> hops;
        final List<MutableMeasure> measures;
        final Set<TableRef> tableRefs;
        final int columnCount;

        Frame(int columnCount, List<Hop> hops, List<MutableMeasure> measures, Collection<TableRef> tableRefs) {
            this.hops = ImmutableList.copyOf(hops);
            this.measures = ImmutableList.copyOf(measures);
            this.tableRefs = ImmutableSet.copyOf(tableRefs);
            this.columnCount = columnCount;
        }

        Frame(int columnCount, List<Hop> hops, List<MutableMeasure> measures, List<Frame> inputs) {
            this(columnCount, hops, measures, Frame.collectTableRefs(inputs, hops));
        }

        abstract @Nullable ColRef column(int var1);

        public String toString() {
            return "Frame(" + this.hops + ")";
        }

        static Set<TableRef> collectTableRefs(List<Frame> inputs, List<Hop> hops) {
            LinkedHashSet<TableRef> set = new LinkedHashSet<TableRef>();
            for (Hop hop : hops) {
                set.add(hop.source.tableRef());
                set.add(hop.target.tableRef());
            }
            for (Frame frame : inputs) {
                set.addAll(frame.tableRefs);
            }
            return set;
        }
    }

    private static class Query {
        final LatticeSpace space;
        final Map<Integer, TableRef> tableRefs = new HashMap<Integer, TableRef>();
        int stepRefCount = 0;

        Query(LatticeSpace space) {
            this.space = space;
        }

        TableRef tableRef(TableScan scan) {
            TableRef r = this.tableRefs.get(scan.getId());
            if (r != null) {
                return r;
            }
            LatticeTable t = this.space.register(scan.getTable());
            TableRef r2 = new TableRef(t, this.tableRefs.size());
            this.tableRefs.put(scan.getId(), r2);
            return r2;
        }

        StepRef stepRef(TableRef source, TableRef target, List<IntPair> keys) {
            Step h = Step.create(source.table, target.table, keys = LatticeSpace.sortUnique(keys), this.space);
            if (h.isBackwards(this.space.statisticProvider)) {
                List<IntPair> keys1 = LatticeSpace.swap(h.keys);
                Step h2 = this.space.addEdge(h.target(), h.source(), keys1);
                return new StepRef(target, source, h2, this.stepRefCount++);
            }
            Step h2 = this.space.addEdge(h.source(), h.target(), h.keys);
            return new StepRef(source, target, h2, this.stepRefCount++);
        }
    }
}

