/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public class SimpleTextStoredFieldsWriter
extends StoredFieldsWriter {
    private int numDocsWritten = 0;
    private IndexOutput out;
    static final String FIELDS_EXTENSION = "fld";
    static final BytesRef TYPE_STRING = new BytesRef((CharSequence)"string");
    static final BytesRef TYPE_BINARY = new BytesRef((CharSequence)"binary");
    static final BytesRef TYPE_INT = new BytesRef((CharSequence)"int");
    static final BytesRef TYPE_LONG = new BytesRef((CharSequence)"long");
    static final BytesRef TYPE_FLOAT = new BytesRef((CharSequence)"float");
    static final BytesRef TYPE_DOUBLE = new BytesRef((CharSequence)"double");
    static final BytesRef END = new BytesRef((CharSequence)"END");
    static final BytesRef DOC = new BytesRef((CharSequence)"doc ");
    static final BytesRef FIELD = new BytesRef((CharSequence)"  field ");
    static final BytesRef NAME = new BytesRef((CharSequence)"    name ");
    static final BytesRef TYPE = new BytesRef((CharSequence)"    type ");
    static final BytesRef VALUE = new BytesRef((CharSequence)"    value ");
    private final BytesRefBuilder scratch = new BytesRefBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTextStoredFieldsWriter(Directory directory, String segment, IOContext context) throws IOException {
        boolean success = false;
        try {
            this.out = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)FIELDS_EXTENSION), context);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void startDocument() throws IOException {
        this.write(DOC);
        this.write(Integer.toString(this.numDocsWritten));
        this.newLine();
        ++this.numDocsWritten;
    }

    public void writeField(FieldInfo info, int value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_INT);
        this.newLine();
        this.write(VALUE);
        this.write(Integer.toString(value));
        this.newLine();
    }

    public void writeField(FieldInfo info, long value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_LONG);
        this.newLine();
        this.write(VALUE);
        this.write(Long.toString(value));
        this.newLine();
    }

    public void writeField(FieldInfo info, float value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_FLOAT);
        this.newLine();
        this.write(VALUE);
        this.write(Float.toString(value));
        this.newLine();
    }

    public void writeField(FieldInfo info, double value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_DOUBLE);
        this.newLine();
        this.write(VALUE);
        this.write(Double.toString(value));
        this.newLine();
    }

    public void writeField(FieldInfo info, BytesRef value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_BINARY);
        this.newLine();
        this.write(VALUE);
        this.write(value);
        this.newLine();
    }

    public void writeField(FieldInfo info, String value) throws IOException {
        this.writeField(info);
        this.write(TYPE);
        this.write(TYPE_STRING);
        this.newLine();
        this.write(VALUE);
        this.write(value);
        this.newLine();
    }

    private void writeField(FieldInfo info) throws IOException {
        this.write(FIELD);
        this.write(Integer.toString(info.number));
        this.newLine();
        this.write(NAME);
        this.write(info.name);
        this.newLine();
    }

    public void finish(int numDocs) throws IOException {
        if (this.numDocsWritten != numDocs) {
            throw new RuntimeException("mergeFields produced an invalid result: docCount is " + numDocs + " but only saw " + this.numDocsWritten + " file=" + this.out.toString() + "; now aborting this merge to prevent index corruption");
        }
        this.write(END);
        this.newLine();
        SimpleTextUtil.writeChecksum(this.out, this.scratch);
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.out});
        }
        finally {
            this.out = null;
        }
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write((DataOutput)this.out, s, this.scratch);
    }

    private void write(BytesRef bytes) throws IOException {
        SimpleTextUtil.write((DataOutput)this.out, bytes);
    }

    private void newLine() throws IOException {
        SimpleTextUtil.writeNewline((DataOutput)this.out);
    }

    public long ramBytesUsed() {
        return 4L;
    }
}

