/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.api.endpoint.ConfigsetsApi;
import org.apache.solr.client.api.model.CloneConfigsetRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CloneConfigSet
extends ConfigSetAPIBase
implements ConfigsetsApi.Clone {
    @Inject
    public CloneConfigSet(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public SolrJerseyResponse cloneExistingConfigSet(CloneConfigsetRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (this.configSetService.checkConfigExists(requestBody.name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet already exists: " + requestBody.name);
        }
        if (!this.configSetService.checkConfigExists(requestBody.baseConfigSet)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Base ConfigSet does not exist: " + requestBody.baseConfigSet);
        }
        if (!ConfigSetsHandler.DISABLE_CREATE_AUTH_CHECKS.booleanValue() && !CloneConfigSet.isTrusted(this.solrQueryRequest.getUserPrincipal(), this.coreContainer.getAuthenticationPlugin()) && this.configSetService.isConfigSetTrusted(requestBody.baseConfigSet)) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Can't create a configset with an unauthenticated request from a trusted baseConfigSet");
        }
        HashMap<String, Object> configsetCommandMsg = new HashMap<String, Object>();
        configsetCommandMsg.put("name", requestBody.name);
        configsetCommandMsg.put("baseConfigSet", requestBody.baseConfigSet);
        if (requestBody.properties != null) {
            for (Map.Entry e : requestBody.properties.entrySet()) {
                configsetCommandMsg.put("configSetProp." + (String)e.getKey(), e.getValue());
            }
        }
        this.runConfigSetCommand(this.solrQueryResponse, ConfigSetParams.ConfigSetAction.CREATE, configsetCommandMsg);
        return response;
    }
}

