/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.Arrays;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.util.ArgumentChecks;

final class SubEnvelope
extends GeneralEnvelope {
    private static final long serialVersionUID = 7241242611077979466L;
    private final int beginIndex;
    private final int endIndex;

    SubEnvelope(double[] dArray, int n, int n2) {
        super(dArray);
        this.beginIndex = n;
        this.endIndex = n2;
    }

    @Override
    final int beginIndex() {
        return this.beginIndex;
    }

    @Override
    final int endIndex() {
        return this.endIndex;
    }

    @Override
    public int getDimension() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public double getLower(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex, n);
        return this.coordinates[n + this.beginIndex];
    }

    @Override
    public double getUpper(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex, n);
        return this.coordinates[n + this.beginIndex + (this.coordinates.length >>> 1)];
    }

    @Override
    public void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex, n);
        if (d > d2 && this.crs != null && !SubEnvelope.isWrapAround(this.crs, n)) {
            throw new IllegalArgumentException(SubEnvelope.illegalRange(this.crs, n, d, d2));
        }
        this.coordinates[(n += this.beginIndex) + (this.coordinates.length >>> 1)] = d2;
        this.coordinates[n] = d;
    }

    @Override
    public void setEnvelope(double ... dArray) {
        int n = this.getDimension();
        SubEnvelope.verifyArrayLength(n, dArray);
        SubEnvelope.verifyRanges(this.crs, dArray);
        int n2 = this.coordinates.length >>> 1;
        System.arraycopy(dArray, 0, this.coordinates, this.beginIndex, n);
        System.arraycopy(dArray, n, this.coordinates, this.beginIndex + n2, n);
    }

    @Override
    public boolean isAllNaN() {
        int n = this.coordinates.length >>> 1;
        for (int i = this.beginIndex; i < this.endIndex; ++i) {
            if (Double.isNaN(this.coordinates[i]) && Double.isNaN(this.coordinates[i + n])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    @Override
    public void setToNaN() {
        int n = this.coordinates.length >>> 1;
        Arrays.fill(this.coordinates, this.beginIndex, this.endIndex, Double.NaN);
        Arrays.fill(this.coordinates, this.beginIndex + n, this.endIndex + n, Double.NaN);
        assert (this.isAllNaN()) : this;
    }

    @Override
    public int hashCode() {
        return this.hashCodeByAPI();
    }

    @Override
    public boolean equals(Object object) {
        return this.equalsByAPI(object);
    }

    @Override
    public GeneralEnvelope subEnvelope(int n, int n2) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndexRange(this.endIndex - this.beginIndex, n, n2);
        return new SubEnvelope(this.coordinates, n + this.beginIndex, n2 + this.beginIndex);
    }

    @Override
    public GeneralEnvelope clone() {
        int n = this.coordinates.length >>> 1;
        int n2 = this.endIndex - this.beginIndex;
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(this.endIndex - this.beginIndex);
        System.arraycopy(this.coordinates, this.beginIndex, generalEnvelope.coordinates, 0, n2);
        System.arraycopy(this.coordinates, this.beginIndex + n, generalEnvelope.coordinates, n2, n2);
        generalEnvelope.crs = this.crs;
        return generalEnvelope;
    }
}

