/*******************************************************************************
 * Copyright 2009-2016 Jörg Müller
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

#include "respec/JOSResampleReader.h"

// sinc filter coefficients, Nz = 136, L = 2304, freq = 0.963904, Kaiser Window B = 16

AUD_NAMESPACE_BEGIN

const int JOSResampleReader::m_len_high = 325078;
const int JOSResampleReader::m_L_high = 2304;

const float JOSResampleReader::m_coeff_high[m_len_high + 1] = {
9.639035268e-01f, 9.639032492e-01f, 9.639024165e-01f, 9.639010286e-01f, 9.638990855e-01f, 9.638965872e-01f, 9.638935338e-01f, 9.638899253e-01f, 9.638857615e-01f, 9.638810427e-01f,
9.638757686e-01f, 9.638699395e-01f, 9.638635552e-01f, 9.638566158e-01f, 9.638491212e-01f, 9.638410716e-01f, 9.638324668e-01f, 9.638233070e-01f, 9.638135921e-01f, 9.638033220e-01f,
9.637924970e-01f, 9.637811168e-01f, 9.637691817e-01f, 9.637566915e-01f, 9.637436463e-01f, 9.637300461e-01f, 9.637158908e-01f, 9.637011807e-01f, 9.636859155e-01f, 9.636700955e-01f,
9.636537204e-01f, 9.636367905e-01f, 9.636193057e-01f, 9.636012660e-01f, 9.635826715e-01f, 9.635635221e-01f, 9.635438179e-01f, 9.635235590e-01f, 9.635027452e-01f, 9.634813767e-01f,
9.634594535e-01f, 9.634369755e-01f, 9.634139429e-01f, 9.633903556e-01f, 9.633662137e-01f, 9.633415171e-01f, 9.633162660e-01f, 9.632904603e-01f, 9.632641001e-01f, 9.632371854e-01f,
9.632097162e-01f, 9.631816925e-01f, 9.631531144e-01f, 9.631239820e-01f, 9.630942951e-01f, 9.630640540e-01f, 9.630332585e-01f, 9.630019088e-01f, 9.629700049e-01f, 9.629375467e-01f,
9.629045344e-01f, 9.628709680e-01f, 9.628368474e-01f, 9.628021728e-01f, 9.627669442e-01f, 9.627311616e-01f, 9.626948250e-01f, 9.626579345e-01f, 9.626204901e-01f, 9.625824919e-01f,
9.625439399e-01f, 9.625048342e-01f, 9.624651747e-01f, 9.624249615e-01f, 9.623841947e-01f, 9.623428743e-01f, 9.623010004e-01f, 9.622585730e-01f, 9.622155921e-01f, 9.621720577e-01f,
9.621279700e-01f, 9.620833290e-01f, 9.620381347e-01f, 9.619923872e-01f, 9.619460865e-01f, 9.618992326e-01f, 9.618518256e-01f, 9.618038656e-01f, 9.617553527e-01f, 9.617062867e-01f,
9.616566679e-01f, 9.616064963e-01f, 9.615557718e-01f, 9.615044946e-01f, 9.614526648e-01f, 9.614002823e-01f, 9.613473472e-01f, 9.612938597e-01f, 9.612398196e-01f, 9.611852272e-01f,
9.611300824e-01f, 9.610743853e-01f, 9.610181360e-01f, 9.609613345e-01f, 9.609039809e-01f, 9.608460752e-01f, 9.607876175e-01f, 9.607286079e-01f, 9.606690464e-01f, 9.606089331e-01f,
9.605482681e-01f, 9.604870514e-01f, 9.604252830e-01f, 9.603629631e-01f, 9.603000916e-01f, 9.602366688e-01f, 9.601726945e-01f, 9.601081690e-01f, 9.600430923e-01f, 9.599774643e-01f,
9.599112853e-01f, 9.598445553e-01f, 9.597772742e-01f, 9.597094423e-01f, 9.596410596e-01f, 9.595721262e-01f, 9.595026420e-01f, 9.594326073e-01f, 9.593620220e-01f, 9.592908862e-01f,
9.592192001e-01f, 9.591469636e-01f, 9.590741770e-01f, 9.590008401e-01f, 9.589269532e-01f, 9.588525163e-01f, 9.587775294e-01f, 9.587019927e-01f, 9.586259062e-01f, 9.585492700e-01f,
9.584720842e-01f, 9.583943488e-01f, 9.583160640e-01f, 9.582372298e-01f, 9.581578463e-01f, 9.580779136e-01f, 9.579974318e-01f, 9.579164010e-01f, 9.578348211e-01f, 9.577526924e-01f,
9.576700149e-01f, 9.575867887e-01f, 9.575030139e-01f, 9.574186906e-01f, 9.573338188e-01f, 9.572483986e-01f, 9.571624302e-01f, 9.570759136e-01f, 9.569888489e-01f, 9.569012362e-01f,
9.568130756e-01f, 9.567243672e-01f, 9.566351110e-01f, 9.565453072e-01f, 9.564549559e-01f, 9.563640571e-01f, 9.562726110e-01f, 9.561806176e-01f, 9.560880771e-01f, 9.559949895e-01f,
9.559013549e-01f, 9.558071734e-01f, 9.557124452e-01f, 9.556171703e-01f, 9.555213488e-01f, 9.554249808e-01f, 9.553280665e-01f, 9.552306058e-01f, 9.551325990e-01f, 9.550340461e-01f,
9.549349473e-01f, 9.548353025e-01f, 9.547351120e-01f, 9.546343759e-01f, 9.545330941e-01f, 9.544312670e-01f, 9.543288944e-01f, 9.542259766e-01f, 9.541225137e-01f, 9.540185058e-01f,
9.539139529e-01f, 9.538088552e-01f, 9.537032128e-01f, 9.535970258e-01f, 9.534902944e-01f, 9.533830185e-01f, 9.532751984e-01f, 9.531668341e-01f, 9.530579258e-01f, 9.529484736e-01f,
9.528384775e-01f, 9.527279378e-01f, 9.526168545e-01f, 9.525052276e-01f, 9.523930575e-01f, 9.522803441e-01f, 9.521670875e-01f, 9.520532880e-01f, 9.519389456e-01f, 9.518240604e-01f,
9.517086326e-01f, 9.515926622e-01f, 9.514761494e-01f, 9.513590944e-01f, 9.512414971e-01f, 9.511233578e-01f, 9.510046766e-01f, 9.508854536e-01f, 9.507656889e-01f, 9.506453827e-01f,
9.505245350e-01f, 9.504031460e-01f, 9.502812159e-01f, 9.501587447e-01f, 9.500357325e-01f, 9.499121796e-01f, 9.497880860e-01f, 9.496634518e-01f, 9.495382773e-01f, 9.494125624e-01f,
9.492863074e-01f, 9.491595124e-01f, 9.490321775e-01f, 9.489043028e-01f, 9.487758886e-01f, 9.486469348e-01f, 9.485174416e-01f, 9.483874092e-01f, 9.482568378e-01f, 9.481257273e-01f,
9.479940781e-01f, 9.478618902e-01f, 9.477291637e-01f, 9.475958988e-01f, 9.474620956e-01f, 9.473277543e-01f, 9.471928750e-01f, 9.470574579e-01f, 9.469215030e-01f, 9.467850106e-01f,
9.466479807e-01f, 9.465104136e-01f, 9.463723093e-01f, 9.462336679e-01f, 9.460944898e-01f, 9.459547749e-01f, 9.458145234e-01f, 9.456737355e-01f, 9.455324113e-01f, 9.453905510e-01f,
9.452481547e-01f, 9.451052225e-01f, 9.449617546e-01f, 9.448177513e-01f, 9.446732125e-01f, 9.445281384e-01f, 9.443825293e-01f, 9.442363852e-01f, 9.440897063e-01f, 9.439424928e-01f,
9.437947447e-01f, 9.436464624e-01f, 9.434976458e-01f, 9.433482953e-01f, 9.431984108e-01f, 9.430479926e-01f, 9.428970409e-01f, 9.427455557e-01f, 9.425935373e-01f, 9.424409858e-01f,
9.422879014e-01f, 9.421342841e-01f, 9.419801343e-01f, 9.418254520e-01f, 9.416702374e-01f, 9.415144906e-01f, 9.413582119e-01f, 9.412014013e-01f, 9.410440591e-01f, 9.408861854e-01f,
9.407277804e-01f, 9.405688442e-01f, 9.404093770e-01f, 9.402493790e-01f, 9.400888502e-01f, 9.399277910e-01f, 9.397662015e-01f, 9.396040817e-01f, 9.394414320e-01f, 9.392782524e-01f,
9.391145432e-01f, 9.389503045e-01f, 9.387855364e-01f, 9.386202392e-01f, 9.384544130e-01f, 9.382880579e-01f, 9.381211743e-01f, 9.379537621e-01f, 9.377858217e-01f, 9.376173531e-01f,
9.374483566e-01f, 9.372788323e-01f, 9.371087804e-01f, 9.369382011e-01f, 9.367670945e-01f, 9.365954609e-01f, 9.364233003e-01f, 9.362506131e-01f, 9.360773993e-01f, 9.359036592e-01f,
9.357293928e-01f, 9.355546005e-01f, 9.353792824e-01f, 9.352034386e-01f, 9.350270693e-01f, 9.348501748e-01f, 9.346727552e-01f, 9.344948107e-01f, 9.343163415e-01f, 9.341373477e-01f,
9.339578296e-01f, 9.337777873e-01f, 9.335972210e-01f, 9.334161310e-01f, 9.332345173e-01f, 9.330523802e-01f, 9.328697199e-01f, 9.326865365e-01f, 9.325028302e-01f, 9.323186014e-01f,
9.321338500e-01f, 9.319485763e-01f, 9.317627806e-01f, 9.315764629e-01f, 9.313896236e-01f, 9.312022627e-01f, 9.310143805e-01f, 9.308259772e-01f, 9.306370529e-01f, 9.304476080e-01f,
9.302576424e-01f, 9.300671565e-01f, 9.298761505e-01f, 9.296846245e-01f, 9.294925788e-01f, 9.293000135e-01f, 9.291069289e-01f, 9.289133251e-01f, 9.287192023e-01f, 9.285245608e-01f,
9.283294007e-01f, 9.281337223e-01f, 9.279375257e-01f, 9.277408112e-01f, 9.275435789e-01f, 9.273458291e-01f, 9.271475619e-01f, 9.269487776e-01f, 9.267494764e-01f, 9.265496585e-01f,
9.263493240e-01f, 9.261484732e-01f, 9.259471064e-01f, 9.257452236e-01f, 9.255428251e-01f, 9.253399112e-01f, 9.251364820e-01f, 9.249325378e-01f, 9.247280787e-01f, 9.245231049e-01f,
9.243176167e-01f, 9.241116144e-01f, 9.239050980e-01f, 9.236980678e-01f, 9.234905241e-01f, 9.232824670e-01f, 9.230738967e-01f, 9.228648135e-01f, 9.226552177e-01f, 9.224451093e-01f,
9.222344886e-01f, 9.220233559e-01f, 9.218117113e-01f, 9.215995551e-01f, 9.213868875e-01f, 9.211737087e-01f, 9.209600189e-01f, 9.207458184e-01f, 9.205311074e-01f, 9.203158860e-01f,
9.201001546e-01f, 9.198839133e-01f, 9.196671624e-01f, 9.194499020e-01f, 9.192321325e-01f, 9.190138540e-01f, 9.187950667e-01f, 9.185757710e-01f, 9.183559669e-01f, 9.181356548e-01f,
9.179148349e-01f, 9.176935073e-01f, 9.174716724e-01f, 9.172493303e-01f, 9.170264813e-01f, 9.168031256e-01f, 9.165792634e-01f, 9.163548950e-01f, 9.161300207e-01f, 9.159046405e-01f,
9.156787548e-01f, 9.154523638e-01f, 9.152254678e-01f, 9.149980669e-01f, 9.147701614e-01f, 9.145417515e-01f, 9.143128376e-01f, 9.140834197e-01f, 9.138534981e-01f, 9.136230732e-01f,
9.133921450e-01f, 9.131607140e-01f, 9.129287802e-01f, 9.126963439e-01f, 9.124634054e-01f, 9.122299649e-01f, 9.119960227e-01f, 9.117615790e-01f, 9.115266340e-01f, 9.112911880e-01f,
9.110552412e-01f, 9.108187939e-01f, 9.105818463e-01f, 9.103443986e-01f, 9.101064511e-01f, 9.098680041e-01f, 9.096290577e-01f, 9.093896123e-01f, 9.091496681e-01f, 9.089092253e-01f,
9.086682841e-01f, 9.084268449e-01f, 9.081849079e-01f, 9.079424733e-01f, 9.076995413e-01f, 9.074561123e-01f, 9.072121864e-01f, 9.069677640e-01f, 9.067228453e-01f, 9.064774304e-01f,
9.062315198e-01f, 9.059851135e-01f, 9.057382120e-01f, 9.054908154e-01f, 9.052429240e-01f, 9.049945380e-01f, 9.047456578e-01f, 9.044962835e-01f, 9.042464154e-01f, 9.039960539e-01f,
9.037451990e-01f, 9.034938511e-01f, 9.032420105e-01f, 9.029896774e-01f, 9.027368521e-01f, 9.024835348e-01f, 9.022297258e-01f, 9.019754253e-01f, 9.017206336e-01f, 9.014653511e-01f,
9.012095778e-01f, 9.009533142e-01f, 9.006965604e-01f, 9.004393168e-01f, 9.001815836e-01f, 8.999233610e-01f, 8.996646493e-01f, 8.994054488e-01f, 8.991457598e-01f, 8.988855825e-01f,
8.986249173e-01f, 8.983637642e-01f, 8.981021237e-01f, 8.978399960e-01f, 8.975773814e-01f, 8.973142801e-01f, 8.970506924e-01f, 8.967866186e-01f, 8.965220589e-01f, 8.962570137e-01f,
8.959914832e-01f, 8.957254676e-01f, 8.954589673e-01f, 8.951919825e-01f, 8.949245135e-01f, 8.946565605e-01f, 8.943881239e-01f, 8.941192039e-01f, 8.938498008e-01f, 8.935799149e-01f,
8.933095464e-01f, 8.930386957e-01f, 8.927673629e-01f, 8.924955485e-01f, 8.922232526e-01f, 8.919504756e-01f, 8.916772176e-01f, 8.914034791e-01f, 8.911292603e-01f, 8.908545614e-01f,
8.905793828e-01f, 8.903037247e-01f, 8.900275875e-01f, 8.897509713e-01f, 8.894738765e-01f, 8.891963034e-01f, 8.889182522e-01f, 8.886397233e-01f, 8.883607169e-01f, 8.880812334e-01f,
8.878012729e-01f, 8.875208358e-01f, 8.872399224e-01f, 8.869585329e-01f, 8.866766677e-01f, 8.863943271e-01f, 8.861115112e-01f, 8.858282205e-01f, 8.855444553e-01f, 8.852602157e-01f,
8.849755021e-01f, 8.846903148e-01f, 8.844046541e-01f, 8.841185202e-01f, 8.838319136e-01f, 8.835448344e-01f, 8.832572829e-01f, 8.829692595e-01f, 8.826807645e-01f, 8.823917981e-01f,
8.821023607e-01f, 8.818124525e-01f, 8.815220738e-01f, 8.812312249e-01f, 8.809399062e-01f, 8.806481180e-01f, 8.803558604e-01f, 8.800631339e-01f, 8.797699387e-01f, 8.794762752e-01f,
8.791821436e-01f, 8.788875442e-01f, 8.785924774e-01f, 8.782969434e-01f, 8.780009425e-01f, 8.777044751e-01f, 8.774075415e-01f, 8.771101419e-01f, 8.768122767e-01f, 8.765139461e-01f,
8.762151505e-01f, 8.759158902e-01f, 8.756161655e-01f, 8.753159767e-01f, 8.750153240e-01f, 8.747142079e-01f, 8.744126286e-01f, 8.741105865e-01f, 8.738080818e-01f, 8.735051148e-01f,
8.732016859e-01f, 8.728977953e-01f, 8.725934435e-01f, 8.722886306e-01f, 8.719833570e-01f, 8.716776231e-01f, 8.713714291e-01f, 8.710647753e-01f, 8.707576621e-01f, 8.704500898e-01f,
8.701420586e-01f, 8.698335690e-01f, 8.695246212e-01f, 8.692152155e-01f, 8.689053523e-01f, 8.685950319e-01f, 8.682842545e-01f, 8.679730206e-01f, 8.676613304e-01f, 8.673491842e-01f,
8.670365825e-01f, 8.667235254e-01f, 8.664100133e-01f, 8.660960465e-01f, 8.657816254e-01f, 8.654667503e-01f, 8.651514214e-01f, 8.648356392e-01f, 8.645194039e-01f, 8.642027159e-01f,
8.638855755e-01f, 8.635679830e-01f, 8.632499387e-01f, 8.629314431e-01f, 8.626124962e-01f, 8.622930987e-01f, 8.619732506e-01f, 8.616529525e-01f, 8.613322045e-01f, 8.610110071e-01f,
8.606893605e-01f, 8.603672651e-01f, 8.600447213e-01f, 8.597217293e-01f, 8.593982894e-01f, 8.590744021e-01f, 8.587500676e-01f, 8.584252863e-01f, 8.581000585e-01f, 8.577743845e-01f,
8.574482647e-01f, 8.571216994e-01f, 8.567946889e-01f, 8.564672336e-01f, 8.561393339e-01f, 8.558109899e-01f, 8.554822022e-01f, 8.551529709e-01f, 8.548232966e-01f, 8.544931794e-01f,
8.541626197e-01f, 8.538316179e-01f, 8.535001743e-01f, 8.531682892e-01f, 8.528359631e-01f, 8.525031961e-01f, 8.521699887e-01f, 8.518363412e-01f, 8.515022540e-01f, 8.511677273e-01f,
8.508327616e-01f, 8.504973571e-01f, 8.501615143e-01f, 8.498252334e-01f, 8.494885148e-01f, 8.491513588e-01f, 8.488137659e-01f, 8.484757362e-01f, 8.481372703e-01f, 8.477983683e-01f,
8.474590308e-01f, 8.471192579e-01f, 8.467790502e-01f, 8.464384078e-01f, 8.460973312e-01f, 8.457558207e-01f, 8.454138767e-01f, 8.450714994e-01f, 8.447286893e-01f, 8.443854468e-01f,
8.440417721e-01f, 8.436976656e-01f, 8.433531276e-01f, 8.430081586e-01f, 8.426627588e-01f, 8.423169286e-01f, 8.419706685e-01f, 8.416239786e-01f, 8.412768594e-01f, 8.409293112e-01f,
8.405813345e-01f, 8.402329294e-01f, 8.398840965e-01f, 8.395348360e-01f, 8.391851483e-01f, 8.388350338e-01f, 8.384844928e-01f, 8.381335257e-01f, 8.377821328e-01f, 8.374303146e-01f,
8.370780713e-01f, 8.367254032e-01f, 8.363723109e-01f, 8.360187946e-01f, 8.356648547e-01f, 8.353104916e-01f, 8.349557056e-01f, 8.346004970e-01f, 8.342448663e-01f, 8.338888138e-01f,
8.335323399e-01f, 8.331754449e-01f, 8.328181292e-01f, 8.324603932e-01f, 8.321022372e-01f, 8.317436615e-01f, 8.313846667e-01f, 8.310252529e-01f, 8.306654207e-01f, 8.303051703e-01f,
8.299445021e-01f, 8.295834165e-01f, 8.292219138e-01f, 8.288599945e-01f, 8.284976589e-01f, 8.281349074e-01f, 8.277717402e-01f, 8.274081579e-01f, 8.270441608e-01f, 8.266797492e-01f,
8.263149235e-01f, 8.259496841e-01f, 8.255840313e-01f, 8.252179656e-01f, 8.248514873e-01f, 8.244845968e-01f, 8.241172944e-01f, 8.237495806e-01f, 8.233814556e-01f, 8.230129199e-01f,
8.226439739e-01f, 8.222746179e-01f, 8.219048523e-01f, 8.215346775e-01f, 8.211640938e-01f, 8.207931017e-01f, 8.204217015e-01f, 8.200498935e-01f, 8.196776783e-01f, 8.193050560e-01f,
8.189320272e-01f, 8.185585922e-01f, 8.181847514e-01f, 8.178105051e-01f, 8.174358538e-01f, 8.170607978e-01f, 8.166853376e-01f, 8.163094734e-01f, 8.159332057e-01f, 8.155565348e-01f,
8.151794612e-01f, 8.148019852e-01f, 8.144241072e-01f, 8.140458276e-01f, 8.136671467e-01f, 8.132880650e-01f, 8.129085829e-01f, 8.125287007e-01f, 8.121484188e-01f, 8.117677376e-01f,
8.113866575e-01f, 8.110051789e-01f, 8.106233021e-01f, 8.102410276e-01f, 8.098583558e-01f, 8.094752869e-01f, 8.090918215e-01f, 8.087079599e-01f, 8.083237025e-01f, 8.079390497e-01f,
8.075540018e-01f, 8.071685594e-01f, 8.067827227e-01f, 8.063964921e-01f, 8.060098681e-01f, 8.056228510e-01f, 8.052354413e-01f, 8.048476393e-01f, 8.044594454e-01f, 8.040708600e-01f,
8.036818836e-01f, 8.032925164e-01f, 8.029027589e-01f, 8.025126116e-01f, 8.021220747e-01f, 8.017311487e-01f, 8.013398340e-01f, 8.009481310e-01f, 8.005560400e-01f, 8.001635615e-01f,
7.997706959e-01f, 7.993774436e-01f, 7.989838049e-01f, 7.985897804e-01f, 7.981953702e-01f, 7.978005750e-01f, 7.974053950e-01f, 7.970098307e-01f, 7.966138825e-01f, 7.962175508e-01f,
7.958208359e-01f, 7.954237383e-01f, 7.950262584e-01f, 7.946283966e-01f, 7.942301532e-01f, 7.938315288e-01f, 7.934325236e-01f, 7.930331382e-01f, 7.926333728e-01f, 7.922332280e-01f,
7.918327041e-01f, 7.914318015e-01f, 7.910305206e-01f, 7.906288619e-01f, 7.902268257e-01f, 7.898244125e-01f, 7.894216226e-01f, 7.890184565e-01f, 7.886149145e-01f, 7.882109972e-01f,
7.878067048e-01f, 7.874020378e-01f, 7.869969967e-01f, 7.865915818e-01f, 7.861857935e-01f, 7.857796322e-01f, 7.853730984e-01f, 7.849661925e-01f, 7.845589148e-01f, 7.841512658e-01f,
7.837432459e-01f, 7.833348556e-01f, 7.829260952e-01f, 7.825169651e-01f, 7.821074658e-01f, 7.816975976e-01f, 7.812873610e-01f, 7.808767565e-01f, 7.804657843e-01f, 7.800544450e-01f,
7.796427389e-01f, 7.792306665e-01f, 7.788182282e-01f, 7.784054244e-01f, 7.779922554e-01f, 7.775787219e-01f, 7.771648240e-01f, 7.767505624e-01f, 7.763359373e-01f, 7.759209493e-01f,
7.755055986e-01f, 7.750898858e-01f, 7.746738113e-01f, 7.742573755e-01f, 7.738405788e-01f, 7.734234216e-01f, 7.730059044e-01f, 7.725880275e-01f, 7.721697915e-01f, 7.717511966e-01f,
7.713322434e-01f, 7.709129323e-01f, 7.704932637e-01f, 7.700732379e-01f, 7.696528555e-01f, 7.692321169e-01f, 7.688110225e-01f, 7.683895726e-01f, 7.679677678e-01f, 7.675456085e-01f,
7.671230951e-01f, 7.667002279e-01f, 7.662770076e-01f, 7.658534344e-01f, 7.654295087e-01f, 7.650052312e-01f, 7.645806020e-01f, 7.641556218e-01f, 7.637302908e-01f, 7.633046096e-01f,
7.628785786e-01f, 7.624521982e-01f, 7.620254688e-01f, 7.615983909e-01f, 7.611709648e-01f, 7.607431911e-01f, 7.603150701e-01f, 7.598866024e-01f, 7.594577882e-01f, 7.590286281e-01f,
7.585991225e-01f, 7.581692718e-01f, 7.577390764e-01f, 7.573085368e-01f, 7.568776535e-01f, 7.564464267e-01f, 7.560148571e-01f, 7.555829450e-01f, 7.551506909e-01f, 7.547180951e-01f,
7.542851582e-01f, 7.538518805e-01f, 7.534182626e-01f, 7.529843047e-01f, 7.525500075e-01f, 7.521153713e-01f, 7.516803965e-01f, 7.512450836e-01f, 7.508094330e-01f, 7.503734452e-01f,
7.499371206e-01f, 7.495004596e-01f, 7.490634628e-01f, 7.486261304e-01f, 7.481884630e-01f, 7.477504610e-01f, 7.473121249e-01f, 7.468734550e-01f, 7.464344519e-01f, 7.459951159e-01f,
7.455554476e-01f, 7.451154473e-01f, 7.446751155e-01f, 7.442344526e-01f, 7.437934591e-01f, 7.433521355e-01f, 7.429104821e-01f, 7.424684994e-01f, 7.420261879e-01f, 7.415835480e-01f,
7.411405801e-01f, 7.406972848e-01f, 7.402536623e-01f, 7.398097133e-01f, 7.393654381e-01f, 7.389208372e-01f, 7.384759109e-01f, 7.380306599e-01f, 7.375850845e-01f, 7.371391851e-01f,
7.366929623e-01f, 7.362464164e-01f, 7.357995480e-01f, 7.353523574e-01f, 7.349048451e-01f, 7.344570115e-01f, 7.340088572e-01f, 7.335603826e-01f, 7.331115880e-01f, 7.326624740e-01f,
7.322130410e-01f, 7.317632895e-01f, 7.313132199e-01f, 7.308628327e-01f, 7.304121282e-01f, 7.299611071e-01f, 7.295097696e-01f, 7.290581164e-01f, 7.286061478e-01f, 7.281538642e-01f,
7.277012662e-01f, 7.272483542e-01f, 7.267951286e-01f, 7.263415899e-01f, 7.258877386e-01f, 7.254335751e-01f, 7.249790999e-01f, 7.245243133e-01f, 7.240692160e-01f, 7.236138083e-01f,
7.231580906e-01f, 7.227020635e-01f, 7.222457275e-01f, 7.217890828e-01f, 7.213321301e-01f, 7.208748698e-01f, 7.204173023e-01f, 7.199594281e-01f, 7.195012476e-01f, 7.190427614e-01f,
7.185839698e-01f, 7.181248734e-01f, 7.176654725e-01f, 7.172057677e-01f, 7.167457594e-01f, 7.162854481e-01f, 7.158248342e-01f, 7.153639182e-01f, 7.149027005e-01f, 7.144411817e-01f,
7.139793621e-01f, 7.135172423e-01f, 7.130548227e-01f, 7.125921037e-01f, 7.121290859e-01f, 7.116657696e-01f, 7.112021554e-01f, 7.107382438e-01f, 7.102740351e-01f, 7.098095298e-01f,
7.093447285e-01f, 7.088796315e-01f, 7.084142394e-01f, 7.079485526e-01f, 7.074825716e-01f, 7.070162968e-01f, 7.065497287e-01f, 7.060828677e-01f, 7.056157144e-01f, 7.051482692e-01f,
7.046805326e-01f, 7.042125050e-01f, 7.037441869e-01f, 7.032755788e-01f, 7.028066812e-01f, 7.023374944e-01f, 7.018680190e-01f, 7.013982555e-01f, 7.009282043e-01f, 7.004578659e-01f,
6.999872407e-01f, 6.995163293e-01f, 6.990451320e-01f, 6.985736494e-01f, 6.981018820e-01f, 6.976298301e-01f, 6.971574944e-01f, 6.966848751e-01f, 6.962119729e-01f, 6.957387882e-01f,
6.952653215e-01f, 6.947915732e-01f, 6.943175438e-01f, 6.938432338e-01f, 6.933686437e-01f, 6.928937738e-01f, 6.924186248e-01f, 6.919431971e-01f, 6.914674911e-01f, 6.909915073e-01f,
6.905152463e-01f, 6.900387084e-01f, 6.895618941e-01f, 6.890848040e-01f, 6.886074385e-01f, 6.881297980e-01f, 6.876518831e-01f, 6.871736943e-01f, 6.866952319e-01f, 6.862164965e-01f,
6.857374886e-01f, 6.852582086e-01f, 6.847786570e-01f, 6.842988343e-01f, 6.838187410e-01f, 6.833383775e-01f, 6.828577443e-01f, 6.823768420e-01f, 6.818956709e-01f, 6.814142315e-01f,
6.809325245e-01f, 6.804505501e-01f, 6.799683089e-01f, 6.794858014e-01f, 6.790030281e-01f, 6.785199894e-01f, 6.780366858e-01f, 6.775531178e-01f, 6.770692859e-01f, 6.765851905e-01f,
6.761008322e-01f, 6.756162114e-01f, 6.751313286e-01f, 6.746461843e-01f, 6.741607790e-01f, 6.736751131e-01f, 6.731891871e-01f, 6.727030016e-01f, 6.722165569e-01f, 6.717298537e-01f,
6.712428923e-01f, 6.707556732e-01f, 6.702681970e-01f, 6.697804641e-01f, 6.692924750e-01f, 6.688042302e-01f, 6.683157302e-01f, 6.678269754e-01f, 6.673379664e-01f, 6.668487036e-01f,
6.663591875e-01f, 6.658694186e-01f, 6.653793973e-01f, 6.648891243e-01f, 6.643985999e-01f, 6.639078246e-01f, 6.634167990e-01f, 6.629255235e-01f, 6.624339986e-01f, 6.619422248e-01f,
6.614502026e-01f, 6.609579324e-01f, 6.604654148e-01f, 6.599726502e-01f, 6.594796392e-01f, 6.589863821e-01f, 6.584928796e-01f, 6.579991321e-01f, 6.575051401e-01f, 6.570109040e-01f,
6.565164245e-01f, 6.560217018e-01f, 6.555267366e-01f, 6.550315294e-01f, 6.545360806e-01f, 6.540403907e-01f, 6.535444602e-01f, 6.530482896e-01f, 6.525518794e-01f, 6.520552300e-01f,
6.515583421e-01f, 6.510612160e-01f, 6.505638522e-01f, 6.500662513e-01f, 6.495684138e-01f, 6.490703401e-01f, 6.485720307e-01f, 6.480734861e-01f, 6.475747069e-01f, 6.470756934e-01f,
6.465764462e-01f, 6.460769659e-01f, 6.455772528e-01f, 6.450773075e-01f, 6.445771305e-01f, 6.440767222e-01f, 6.435760832e-01f, 6.430752140e-01f, 6.425741150e-01f, 6.420727867e-01f,
6.415712297e-01f, 6.410694445e-01f, 6.405674314e-01f, 6.400651911e-01f, 6.395627240e-01f, 6.390600307e-01f, 6.385571115e-01f, 6.380539671e-01f, 6.375505979e-01f, 6.370470044e-01f,
6.365431871e-01f, 6.360391465e-01f, 6.355348831e-01f, 6.350303974e-01f, 6.345256898e-01f, 6.340207610e-01f, 6.335156114e-01f, 6.330102414e-01f, 6.325046516e-01f, 6.319988426e-01f,
6.314928147e-01f, 6.309865684e-01f, 6.304801044e-01f, 6.299734230e-01f, 6.294665249e-01f, 6.289594104e-01f, 6.284520800e-01f, 6.279445344e-01f, 6.274367739e-01f, 6.269287991e-01f,
6.264206105e-01f, 6.259122086e-01f, 6.254035938e-01f, 6.248947667e-01f, 6.243857278e-01f, 6.238764776e-01f, 6.233670166e-01f, 6.228573452e-01f, 6.223474641e-01f, 6.218373736e-01f,
6.213270743e-01f, 6.208165667e-01f, 6.203058513e-01f, 6.197949286e-01f, 6.192837991e-01f, 6.187724633e-01f, 6.182609217e-01f, 6.177491748e-01f, 6.172372231e-01f, 6.167250671e-01f,
6.162127074e-01f, 6.157001444e-01f, 6.151873785e-01f, 6.146744105e-01f, 6.141612406e-01f, 6.136478695e-01f, 6.131342976e-01f, 6.126205255e-01f, 6.121065536e-01f, 6.115923824e-01f,
6.110780126e-01f, 6.105634444e-01f, 6.100486786e-01f, 6.095337155e-01f, 6.090185557e-01f, 6.085031997e-01f, 6.079876480e-01f, 6.074719010e-01f, 6.069559594e-01f, 6.064398236e-01f,
6.059234941e-01f, 6.054069714e-01f, 6.048902560e-01f, 6.043733485e-01f, 6.038562493e-01f, 6.033389590e-01f, 6.028214780e-01f, 6.023038069e-01f, 6.017859461e-01f, 6.012678962e-01f,
6.007496577e-01f, 6.002312311e-01f, 5.997126169e-01f, 5.991938156e-01f, 5.986748277e-01f, 5.981556537e-01f, 5.976362942e-01f, 5.971167496e-01f, 5.965970204e-01f, 5.960771072e-01f,
5.955570105e-01f, 5.950367307e-01f, 5.945162684e-01f, 5.939956242e-01f, 5.934747984e-01f, 5.929537916e-01f, 5.924326044e-01f, 5.919112371e-01f, 5.913896904e-01f, 5.908679648e-01f,
5.903460607e-01f, 5.898239787e-01f, 5.893017193e-01f, 5.887792830e-01f, 5.882566702e-01f, 5.877338816e-01f, 5.872109176e-01f, 5.866877787e-01f, 5.861644655e-01f, 5.856409784e-01f,
5.851173180e-01f, 5.845934848e-01f, 5.840694793e-01f, 5.835453019e-01f, 5.830209533e-01f, 5.824964339e-01f, 5.819717442e-01f, 5.814468848e-01f, 5.809218561e-01f, 5.803966587e-01f,
5.798712931e-01f, 5.793457598e-01f, 5.788200593e-01f, 5.782941921e-01f, 5.777681588e-01f, 5.772419598e-01f, 5.767155956e-01f, 5.761890668e-01f, 5.756623739e-01f, 5.751355174e-01f,
5.746084979e-01f, 5.740813157e-01f, 5.735539715e-01f, 5.730264657e-01f, 5.724987989e-01f, 5.719709716e-01f, 5.714429842e-01f, 5.709148374e-01f, 5.703865316e-01f, 5.698580673e-01f,
5.693294451e-01f, 5.688006655e-01f, 5.682717289e-01f, 5.677426359e-01f, 5.672133870e-01f, 5.666839827e-01f, 5.661544236e-01f, 5.656247101e-01f, 5.650948428e-01f, 5.645648222e-01f,
5.640346488e-01f, 5.635043230e-01f, 5.629738456e-01f, 5.624432168e-01f, 5.619124373e-01f, 5.613815076e-01f, 5.608504282e-01f, 5.603191995e-01f, 5.597878222e-01f, 5.592562967e-01f,
5.587246236e-01f, 5.581928034e-01f, 5.576608365e-01f, 5.571287235e-01f, 5.565964650e-01f, 5.560640614e-01f, 5.555315132e-01f, 5.549988210e-01f, 5.544659853e-01f, 5.539330066e-01f,
5.533998853e-01f, 5.528666222e-01f, 5.523332175e-01f, 5.517996720e-01f, 5.512659860e-01f, 5.507321601e-01f, 5.501981949e-01f, 5.496640908e-01f, 5.491298483e-01f, 5.485954680e-01f,
5.480609504e-01f, 5.475262960e-01f, 5.469915053e-01f, 5.464565788e-01f, 5.459215172e-01f, 5.453863207e-01f, 5.448509901e-01f, 5.443155258e-01f, 5.437799283e-01f, 5.432441982e-01f,
5.427083359e-01f, 5.421723421e-01f, 5.416362171e-01f, 5.410999615e-01f, 5.405635759e-01f, 5.400270607e-01f, 5.394904165e-01f, 5.389536438e-01f, 5.384167432e-01f, 5.378797150e-01f,
5.373425599e-01f, 5.368052784e-01f, 5.362678709e-01f, 5.357303381e-01f, 5.351926804e-01f, 5.346548983e-01f, 5.341169924e-01f, 5.335789631e-01f, 5.330408111e-01f, 5.325025368e-01f,
5.319641407e-01f, 5.314256234e-01f, 5.308869854e-01f, 5.303482272e-01f, 5.298093493e-01f, 5.292703522e-01f, 5.287312365e-01f, 5.281920026e-01f, 5.276526512e-01f, 5.271131826e-01f,
5.265735975e-01f, 5.260338964e-01f, 5.254940797e-01f, 5.249541480e-01f, 5.244141019e-01f, 5.238739417e-01f, 5.233336681e-01f, 5.227932816e-01f, 5.222527827e-01f, 5.217121719e-01f,
5.211714498e-01f, 5.206306168e-01f, 5.200896734e-01f, 5.195486203e-01f, 5.190074579e-01f, 5.184661867e-01f, 5.179248072e-01f, 5.173833201e-01f, 5.168417257e-01f, 5.163000247e-01f,
5.157582175e-01f, 5.152163046e-01f, 5.146742867e-01f, 5.141321641e-01f, 5.135899374e-01f, 5.130476072e-01f, 5.125051740e-01f, 5.119626382e-01f, 5.114200004e-01f, 5.108772612e-01f,
5.103344210e-01f, 5.097914803e-01f, 5.092484398e-01f, 5.087052998e-01f, 5.081620610e-01f, 5.076187238e-01f, 5.070752888e-01f, 5.065317565e-01f, 5.059881274e-01f, 5.054444020e-01f,
5.049005809e-01f, 5.043566646e-01f, 5.038126535e-01f, 5.032685483e-01f, 5.027243494e-01f, 5.021800573e-01f, 5.016356727e-01f, 5.010911959e-01f, 5.005466275e-01f, 5.000019681e-01f,
4.994572182e-01f, 4.989123782e-01f, 4.983674488e-01f, 4.978224304e-01f, 4.972773235e-01f, 4.967321287e-01f, 4.961868464e-01f, 4.956414773e-01f, 4.950960219e-01f, 4.945504805e-01f,
4.940048539e-01f, 4.934591424e-01f, 4.929133467e-01f, 4.923674672e-01f, 4.918215045e-01f, 4.912754590e-01f, 4.907293314e-01f, 4.901831221e-01f, 4.896368316e-01f, 4.890904605e-01f,
4.885440092e-01f, 4.879974784e-01f, 4.874508685e-01f, 4.869041801e-01f, 4.863574136e-01f, 4.858105697e-01f, 4.852636487e-01f, 4.847166513e-01f, 4.841695779e-01f, 4.836224291e-01f,
4.830752055e-01f, 4.825279074e-01f, 4.819805355e-01f, 4.814330902e-01f, 4.808855722e-01f, 4.803379818e-01f, 4.797903197e-01f, 4.792425863e-01f, 4.786947822e-01f, 4.781469079e-01f,
4.775989639e-01f, 4.770509507e-01f, 4.765028689e-01f, 4.759547190e-01f, 4.754065014e-01f, 4.748582168e-01f, 4.743098656e-01f, 4.737614484e-01f, 4.732129656e-01f, 4.726644179e-01f,
4.721158057e-01f, 4.715671295e-01f, 4.710183899e-01f, 4.704695874e-01f, 4.699207225e-01f, 4.693717957e-01f, 4.688228076e-01f, 4.682737586e-01f, 4.677246493e-01f, 4.671754803e-01f,
4.666262520e-01f, 4.660769649e-01f, 4.655276196e-01f, 4.649782166e-01f, 4.644287564e-01f, 4.638792396e-01f, 4.633296666e-01f, 4.627800380e-01f, 4.622303543e-01f, 4.616806160e-01f,
4.611308236e-01f, 4.605809777e-01f, 4.600310788e-01f, 4.594811274e-01f, 4.589311240e-01f, 4.583810692e-01f, 4.578309634e-01f, 4.572808072e-01f, 4.567306011e-01f, 4.561803457e-01f,
4.556300413e-01f, 4.550796887e-01f, 4.545292882e-01f, 4.539788404e-01f, 4.534283459e-01f, 4.528778051e-01f, 4.523272186e-01f, 4.517765868e-01f, 4.512259104e-01f, 4.506751897e-01f,
4.501244255e-01f, 4.495736181e-01f, 4.490227680e-01f, 4.484718759e-01f, 4.479209422e-01f, 4.473699674e-01f, 4.468189522e-01f, 4.462678968e-01f, 4.457168020e-01f, 4.451656682e-01f,
4.446144960e-01f, 4.440632858e-01f, 4.435120382e-01f, 4.429607537e-01f, 4.424094328e-01f, 4.418580760e-01f, 4.413066839e-01f, 4.407552570e-01f, 4.402037958e-01f, 4.396523008e-01f,
4.391007725e-01f, 4.385492115e-01f, 4.379976182e-01f, 4.374459932e-01f, 4.368943371e-01f, 4.363426502e-01f, 4.357909332e-01f, 4.352391866e-01f, 4.346874108e-01f, 4.341356065e-01f,
4.335837741e-01f, 4.330319141e-01f, 4.324800270e-01f, 4.319281134e-01f, 4.313761739e-01f, 4.308242088e-01f, 4.302722188e-01f, 4.297202043e-01f, 4.291681658e-01f, 4.286161040e-01f,
4.280640192e-01f, 4.275119121e-01f, 4.269597831e-01f, 4.264076327e-01f, 4.258554615e-01f, 4.253032700e-01f, 4.247510587e-01f, 4.241988281e-01f, 4.236465788e-01f, 4.230943112e-01f,
4.225420259e-01f, 4.219897233e-01f, 4.214374041e-01f, 4.208850687e-01f, 4.203327176e-01f, 4.197803514e-01f, 4.192279706e-01f, 4.186755757e-01f, 4.181231671e-01f, 4.175707455e-01f,
4.170183113e-01f, 4.164658651e-01f, 4.159134073e-01f, 4.153609385e-01f, 4.148084593e-01f, 4.142559700e-01f, 4.137034713e-01f, 4.131509636e-01f, 4.125984475e-01f, 4.120459235e-01f,
4.114933920e-01f, 4.109408537e-01f, 4.103883090e-01f, 4.098357585e-01f, 4.092832026e-01f, 4.087306418e-01f, 4.081780768e-01f, 4.076255080e-01f, 4.070729358e-01f, 4.065203609e-01f,
4.059677838e-01f, 4.054152049e-01f, 4.048626248e-01f, 4.043100440e-01f, 4.037574630e-01f, 4.032048823e-01f, 4.026523024e-01f, 4.020997239e-01f, 4.015471472e-01f, 4.009945729e-01f,
4.004420015e-01f, 3.998894335e-01f, 3.993368694e-01f, 3.987843097e-01f, 3.982317550e-01f, 3.976792057e-01f, 3.971266624e-01f, 3.965741256e-01f, 3.960215958e-01f, 3.954690734e-01f,
3.949165591e-01f, 3.943640533e-01f, 3.938115566e-01f, 3.932590694e-01f, 3.927065923e-01f, 3.921541257e-01f, 3.916016703e-01f, 3.910492264e-01f, 3.904967947e-01f, 3.899443756e-01f,
3.893919697e-01f, 3.888395773e-01f, 3.882871992e-01f, 3.877348357e-01f, 3.871824874e-01f, 3.866301548e-01f, 3.860778384e-01f, 3.855255387e-01f, 3.849732563e-01f, 3.844209916e-01f,
3.838687451e-01f, 3.833165174e-01f, 3.827643090e-01f, 3.822121203e-01f, 3.816599519e-01f, 3.811078044e-01f, 3.805556781e-01f, 3.800035737e-01f, 3.794514916e-01f, 3.788994323e-01f,
3.783473964e-01f, 3.777953843e-01f, 3.772433966e-01f, 3.766914338e-01f, 3.761394963e-01f, 3.755875848e-01f, 3.750356996e-01f, 3.744838414e-01f, 3.739320106e-01f, 3.733802077e-01f,
3.728284332e-01f, 3.722766877e-01f, 3.717249716e-01f, 3.711732855e-01f, 3.706216299e-01f, 3.700700052e-01f, 3.695184120e-01f, 3.689668508e-01f, 3.684153221e-01f, 3.678638264e-01f,
3.673123642e-01f, 3.667609360e-01f, 3.662095423e-01f, 3.656581837e-01f, 3.651068606e-01f, 3.645555735e-01f, 3.640043230e-01f, 3.634531095e-01f, 3.629019336e-01f, 3.623507958e-01f,
3.617996965e-01f, 3.612486363e-01f, 3.606976157e-01f, 3.601466352e-01f, 3.595956952e-01f, 3.590447964e-01f, 3.584939392e-01f, 3.579431240e-01f, 3.573923515e-01f, 3.568416221e-01f,
3.562909363e-01f, 3.557402946e-01f, 3.551896975e-01f, 3.546391456e-01f, 3.540886393e-01f, 3.535381791e-01f, 3.529877656e-01f, 3.524373992e-01f, 3.518870805e-01f, 3.513368099e-01f,
3.507865880e-01f, 3.502364152e-01f, 3.496862920e-01f, 3.491362191e-01f, 3.485861967e-01f, 3.480362256e-01f, 3.474863061e-01f, 3.469364388e-01f, 3.463866241e-01f, 3.458368626e-01f,
3.452871548e-01f, 3.447375011e-01f, 3.441879021e-01f, 3.436383583e-01f, 3.430888701e-01f, 3.425394382e-01f, 3.419900628e-01f, 3.414407447e-01f, 3.408914842e-01f, 3.403422820e-01f,
3.397931383e-01f, 3.392440539e-01f, 3.386950291e-01f, 3.381460645e-01f, 3.375971605e-01f, 3.370483177e-01f, 3.364995366e-01f, 3.359508177e-01f, 3.354021614e-01f, 3.348535682e-01f,
3.343050388e-01f, 3.337565734e-01f, 3.332081728e-01f, 3.326598372e-01f, 3.321115674e-01f, 3.315633636e-01f, 3.310152266e-01f, 3.304671566e-01f, 3.299191543e-01f, 3.293712201e-01f,
3.288233546e-01f, 3.282755581e-01f, 3.277278313e-01f, 3.271801746e-01f, 3.266325885e-01f, 3.260850735e-01f, 3.255376301e-01f, 3.249902589e-01f, 3.244429602e-01f, 3.238957346e-01f,
3.233485825e-01f, 3.228015046e-01f, 3.222545012e-01f, 3.217075729e-01f, 3.211607201e-01f, 3.206139434e-01f, 3.200672432e-01f, 3.195206201e-01f, 3.189740744e-01f, 3.184276069e-01f,
3.178812178e-01f, 3.173349077e-01f, 3.167886772e-01f, 3.162425266e-01f, 3.156964565e-01f, 3.151504674e-01f, 3.146045597e-01f, 3.140587340e-01f, 3.135129908e-01f, 3.129673305e-01f,
3.124217536e-01f, 3.118762607e-01f, 3.113308522e-01f, 3.107855285e-01f, 3.102402903e-01f, 3.096951380e-01f, 3.091500720e-01f, 3.086050929e-01f, 3.080602011e-01f, 3.075153972e-01f,
3.069706816e-01f, 3.064260548e-01f, 3.058815174e-01f, 3.053370697e-01f, 3.047927123e-01f, 3.042484457e-01f, 3.037042703e-01f, 3.031601867e-01f, 3.026161953e-01f, 3.020722967e-01f,
3.015284912e-01f, 3.009847795e-01f, 3.004411619e-01f, 2.998976390e-01f, 2.993542113e-01f, 2.988108792e-01f, 2.982676432e-01f, 2.977245038e-01f, 2.971814615e-01f, 2.966385168e-01f,
2.960956702e-01f, 2.955529221e-01f, 2.950102731e-01f, 2.944677236e-01f, 2.939252741e-01f, 2.933829251e-01f, 2.928406770e-01f, 2.922985304e-01f, 2.917564857e-01f, 2.912145435e-01f,
2.906727042e-01f, 2.901309682e-01f, 2.895893362e-01f, 2.890478084e-01f, 2.885063855e-01f, 2.879650680e-01f, 2.874238562e-01f, 2.868827507e-01f, 2.863417520e-01f, 2.858008605e-01f,
2.852600767e-01f, 2.847194011e-01f, 2.841788342e-01f, 2.836383765e-01f, 2.830980284e-01f, 2.825577905e-01f, 2.820176631e-01f, 2.814776468e-01f, 2.809377421e-01f, 2.803979494e-01f,
2.798582693e-01f, 2.793187021e-01f, 2.787792484e-01f, 2.782399087e-01f, 2.777006833e-01f, 2.771615729e-01f, 2.766225779e-01f, 2.760836987e-01f, 2.755449359e-01f, 2.750062899e-01f,
2.744677612e-01f, 2.739293502e-01f, 2.733910575e-01f, 2.728528835e-01f, 2.723148287e-01f, 2.717768936e-01f, 2.712390786e-01f, 2.707013842e-01f, 2.701638109e-01f, 2.696263592e-01f,
2.690890295e-01f, 2.685518224e-01f, 2.680147382e-01f, 2.674777775e-01f, 2.669409407e-01f, 2.664042284e-01f, 2.658676409e-01f, 2.653311787e-01f, 2.647948424e-01f, 2.642586324e-01f,
2.637225492e-01f, 2.631865932e-01f, 2.626507649e-01f, 2.621150648e-01f, 2.615794933e-01f, 2.610440510e-01f, 2.605087382e-01f, 2.599735555e-01f, 2.594385034e-01f, 2.589035822e-01f,
2.583687926e-01f, 2.578341348e-01f, 2.572996095e-01f, 2.567652170e-01f, 2.562309579e-01f, 2.556968326e-01f, 2.551628416e-01f, 2.546289854e-01f, 2.540952643e-01f, 2.535616790e-01f,
2.530282298e-01f, 2.524949172e-01f, 2.519617417e-01f, 2.514287037e-01f, 2.508958038e-01f, 2.503630424e-01f, 2.498304198e-01f, 2.492979367e-01f, 2.487655935e-01f, 2.482333906e-01f,
2.477013286e-01f, 2.471694078e-01f, 2.466376287e-01f, 2.461059918e-01f, 2.455744976e-01f, 2.450431465e-01f, 2.445119390e-01f, 2.439808755e-01f, 2.434499566e-01f, 2.429191826e-01f,
2.423885541e-01f, 2.418580714e-01f, 2.413277351e-01f, 2.407975457e-01f, 2.402675035e-01f, 2.397376090e-01f, 2.392078628e-01f, 2.386782652e-01f, 2.381488167e-01f, 2.376195178e-01f,
2.370903690e-01f, 2.365613706e-01f, 2.360325232e-01f, 2.355038272e-01f, 2.349752831e-01f, 2.344468913e-01f, 2.339186523e-01f, 2.333905666e-01f, 2.328626345e-01f, 2.323348566e-01f,
2.318072333e-01f, 2.312797651e-01f, 2.307524524e-01f, 2.302252958e-01f, 2.296982955e-01f, 2.291714521e-01f, 2.286447661e-01f, 2.281182379e-01f, 2.275918679e-01f, 2.270656567e-01f,
2.265396046e-01f, 2.260137121e-01f, 2.254879797e-01f, 2.249624079e-01f, 2.244369970e-01f, 2.239117475e-01f, 2.233866599e-01f, 2.228617347e-01f, 2.223369722e-01f, 2.218123730e-01f,
2.212879375e-01f, 2.207636661e-01f, 2.202395593e-01f, 2.197156175e-01f, 2.191918412e-01f, 2.186682309e-01f, 2.181447870e-01f, 2.176215098e-01f, 2.170984000e-01f, 2.165754579e-01f,
2.160526840e-01f, 2.155300787e-01f, 2.150076425e-01f, 2.144853759e-01f, 2.139632792e-01f, 2.134413529e-01f, 2.129195975e-01f, 2.123980134e-01f, 2.118766010e-01f, 2.113553609e-01f,
2.108342934e-01f, 2.103133990e-01f, 2.097926782e-01f, 2.092721313e-01f, 2.087517588e-01f, 2.082315613e-01f, 2.077115390e-01f, 2.071916925e-01f, 2.066720222e-01f, 2.061525286e-01f,
2.056332120e-01f, 2.051140730e-01f, 2.045951119e-01f, 2.040763293e-01f, 2.035577255e-01f, 2.030393010e-01f, 2.025210562e-01f, 2.020029917e-01f, 2.014851077e-01f, 2.009674048e-01f,
2.004498834e-01f, 1.999325439e-01f, 1.994153868e-01f, 1.988984125e-01f, 1.983816214e-01f, 1.978650141e-01f, 1.973485909e-01f, 1.968323522e-01f, 1.963162985e-01f, 1.958004303e-01f,
1.952847480e-01f, 1.947692519e-01f, 1.942539426e-01f, 1.937388205e-01f, 1.932238860e-01f, 1.927091396e-01f, 1.921945816e-01f, 1.916802126e-01f, 1.911660329e-01f, 1.906520431e-01f,
1.901382434e-01f, 1.896246344e-01f, 1.891112165e-01f, 1.885979901e-01f, 1.880849557e-01f, 1.875721136e-01f, 1.870594644e-01f, 1.865470084e-01f, 1.860347461e-01f, 1.855226779e-01f,
1.850108042e-01f, 1.844991255e-01f, 1.839876422e-01f, 1.834763548e-01f, 1.829652636e-01f, 1.824543691e-01f, 1.819436717e-01f, 1.814331719e-01f, 1.809228700e-01f, 1.804127665e-01f,
1.799028619e-01f, 1.793931565e-01f, 1.788836508e-01f, 1.783743452e-01f, 1.778652401e-01f, 1.773563360e-01f, 1.768476332e-01f, 1.763391323e-01f, 1.758308336e-01f, 1.753227376e-01f,
1.748148447e-01f, 1.743071552e-01f, 1.737996697e-01f, 1.732923886e-01f, 1.727853122e-01f, 1.722784410e-01f, 1.717717754e-01f, 1.712653159e-01f, 1.707590628e-01f, 1.702530167e-01f,
1.697471778e-01f, 1.692415466e-01f, 1.687361236e-01f, 1.682309092e-01f, 1.677259038e-01f, 1.672211077e-01f, 1.667165215e-01f, 1.662121455e-01f, 1.657079802e-01f, 1.652040259e-01f,
1.647002832e-01f, 1.641967523e-01f, 1.636934338e-01f, 1.631903281e-01f, 1.626874354e-01f, 1.621847564e-01f, 1.616822914e-01f, 1.611800408e-01f, 1.606780050e-01f, 1.601761844e-01f,
1.596745795e-01f, 1.591731906e-01f, 1.586720183e-01f, 1.581710628e-01f, 1.576703246e-01f, 1.571698042e-01f, 1.566695019e-01f, 1.561694181e-01f, 1.556695532e-01f, 1.551699078e-01f,
1.546704821e-01f, 1.541712766e-01f, 1.536722917e-01f, 1.531735278e-01f, 1.526749853e-01f, 1.521766647e-01f, 1.516785662e-01f, 1.511806904e-01f, 1.506830377e-01f, 1.501856084e-01f,
1.496884030e-01f, 1.491914219e-01f, 1.486946654e-01f, 1.481981341e-01f, 1.477018282e-01f, 1.472057482e-01f, 1.467098945e-01f, 1.462142675e-01f, 1.457188677e-01f, 1.452236953e-01f,
1.447287509e-01f, 1.442340348e-01f, 1.437395474e-01f, 1.432452892e-01f, 1.427512604e-01f, 1.422574617e-01f, 1.417638932e-01f, 1.412705555e-01f, 1.407774490e-01f, 1.402845739e-01f,
1.397919308e-01f, 1.392995201e-01f, 1.388073421e-01f, 1.383153972e-01f, 1.378236859e-01f, 1.373322085e-01f, 1.368409655e-01f, 1.363499572e-01f, 1.358591840e-01f, 1.353686463e-01f,
1.348783446e-01f, 1.343882792e-01f, 1.338984505e-01f, 1.334088589e-01f, 1.329195049e-01f, 1.324303887e-01f, 1.319415109e-01f, 1.314528717e-01f, 1.309644716e-01f, 1.304763110e-01f,
1.299883903e-01f, 1.295007099e-01f, 1.290132701e-01f, 1.285260714e-01f, 1.280391141e-01f, 1.275523986e-01f, 1.270659254e-01f, 1.265796948e-01f, 1.260937072e-01f, 1.256079630e-01f,
1.251224626e-01f, 1.246372064e-01f, 1.241521947e-01f, 1.236674280e-01f, 1.231829067e-01f, 1.226986310e-01f, 1.222146015e-01f, 1.217308185e-01f, 1.212472824e-01f, 1.207639936e-01f,
1.202809524e-01f, 1.197981593e-01f, 1.193156147e-01f, 1.188333188e-01f, 1.183512722e-01f, 1.178694751e-01f, 1.173879280e-01f, 1.169066313e-01f, 1.164255854e-01f, 1.159447905e-01f,
1.154642472e-01f, 1.149839557e-01f, 1.145039165e-01f, 1.140241300e-01f, 1.135445965e-01f, 1.130653164e-01f, 1.125862901e-01f, 1.121075179e-01f, 1.116290004e-01f, 1.111507377e-01f,
1.106727304e-01f, 1.101949787e-01f, 1.097174832e-01f, 1.092402440e-01f, 1.087632617e-01f, 1.082865366e-01f, 1.078100690e-01f, 1.073338594e-01f, 1.068579081e-01f, 1.063822156e-01f,
1.059067821e-01f, 1.054316080e-01f, 1.049566938e-01f, 1.044820397e-01f, 1.040076463e-01f, 1.035335138e-01f, 1.030596425e-01f, 1.025860330e-01f, 1.021126856e-01f, 1.016396005e-01f,
1.011667783e-01f, 1.006942193e-01f, 1.002219237e-01f, 9.974989215e-02f, 9.927812483e-02f, 9.880662216e-02f, 9.833538451e-02f, 9.786441225e-02f, 9.739370575e-02f, 9.692326537e-02f,
9.645309148e-02f, 9.598318444e-02f, 9.551354463e-02f, 9.504417241e-02f, 9.457506815e-02f, 9.410623220e-02f, 9.363766494e-02f, 9.316936673e-02f, 9.270133793e-02f, 9.223357891e-02f,
9.176609003e-02f, 9.129887166e-02f, 9.083192415e-02f, 9.036524786e-02f, 8.989884317e-02f, 8.943271042e-02f, 8.896684999e-02f, 8.850126223e-02f, 8.803594750e-02f, 8.757090617e-02f,
8.710613858e-02f, 8.664164511e-02f, 8.617742610e-02f, 8.571348192e-02f, 8.524981292e-02f, 8.478641947e-02f, 8.432330191e-02f, 8.386046061e-02f, 8.339789592e-02f, 8.293560819e-02f,
8.247359779e-02f, 8.201186507e-02f, 8.155041037e-02f, 8.108923407e-02f, 8.062833650e-02f, 8.016771802e-02f, 7.970737899e-02f, 7.924731976e-02f, 7.878754068e-02f, 7.832804210e-02f,
7.786882438e-02f, 7.740988785e-02f, 7.695123289e-02f, 7.649285983e-02f, 7.603476902e-02f, 7.557696082e-02f, 7.511943556e-02f, 7.466219362e-02f, 7.420523532e-02f, 7.374856101e-02f,
7.329217105e-02f, 7.283606579e-02f, 7.238024556e-02f, 7.192471071e-02f, 7.146946159e-02f, 7.101449855e-02f, 7.055982192e-02f, 7.010543206e-02f, 6.965132931e-02f, 6.919751401e-02f,
6.874398651e-02f, 6.829074714e-02f, 6.783779625e-02f, 6.738513418e-02f, 6.693276128e-02f, 6.648067787e-02f, 6.602888432e-02f, 6.557738095e-02f, 6.512616811e-02f, 6.467524613e-02f,
6.422461535e-02f, 6.377427612e-02f, 6.332422876e-02f, 6.287447363e-02f, 6.242501105e-02f, 6.197584137e-02f, 6.152696491e-02f, 6.107838202e-02f, 6.063009303e-02f, 6.018209828e-02f,
5.973439810e-02f, 5.928699283e-02f, 5.883988279e-02f, 5.839306833e-02f, 5.794654978e-02f, 5.750032747e-02f, 5.705440173e-02f, 5.660877290e-02f, 5.616344130e-02f, 5.571840727e-02f,
5.527367114e-02f, 5.482923323e-02f, 5.438509389e-02f, 5.394125343e-02f, 5.349771219e-02f, 5.305447049e-02f, 5.261152867e-02f, 5.216888705e-02f, 5.172654596e-02f, 5.128450572e-02f,
5.084276667e-02f, 5.040132912e-02f, 4.996019341e-02f, 4.951935986e-02f, 4.907882879e-02f, 4.863860054e-02f, 4.819867541e-02f, 4.775905374e-02f, 4.731973585e-02f, 4.688072206e-02f,
4.644201270e-02f, 4.600360808e-02f, 4.556550853e-02f, 4.512771437e-02f, 4.469022592e-02f, 4.425304350e-02f, 4.381616743e-02f, 4.337959802e-02f, 4.294333561e-02f, 4.250738049e-02f,
4.207173301e-02f, 4.163639346e-02f, 4.120136217e-02f, 4.076663946e-02f, 4.033222564e-02f, 3.989812103e-02f, 3.946432594e-02f, 3.903084069e-02f, 3.859766558e-02f, 3.816480095e-02f,
3.773224710e-02f, 3.730000434e-02f, 3.686807298e-02f, 3.643645335e-02f, 3.600514574e-02f, 3.557415048e-02f, 3.514346787e-02f, 3.471309823e-02f, 3.428304186e-02f, 3.385329907e-02f,
3.342387018e-02f, 3.299475549e-02f, 3.256595531e-02f, 3.213746995e-02f, 3.170929971e-02f, 3.128144491e-02f, 3.085390585e-02f, 3.042668284e-02f, 2.999977618e-02f, 2.957318618e-02f,
2.914691314e-02f, 2.872095737e-02f, 2.829531916e-02f, 2.786999884e-02f, 2.744499669e-02f, 2.702031303e-02f, 2.659594815e-02f, 2.617190235e-02f, 2.574817595e-02f, 2.532476923e-02f,
2.490168249e-02f, 2.447891605e-02f, 2.405647020e-02f, 2.363434523e-02f, 2.321254146e-02f, 2.279105916e-02f, 2.236989865e-02f, 2.194906023e-02f, 2.152854417e-02f, 2.110835080e-02f,
2.068848039e-02f, 2.026893325e-02f, 1.984970967e-02f, 1.943080995e-02f, 1.901223438e-02f, 1.859398325e-02f, 1.817605686e-02f, 1.775845551e-02f, 1.734117947e-02f, 1.692422906e-02f,
1.650760455e-02f, 1.609130624e-02f, 1.567533442e-02f, 1.525968938e-02f, 1.484437141e-02f, 1.442938080e-02f, 1.401471784e-02f, 1.360038282e-02f, 1.318637602e-02f, 1.277269773e-02f,
1.235934825e-02f, 1.194632785e-02f, 1.153363683e-02f, 1.112127546e-02f, 1.070924405e-02f, 1.029754286e-02f, 9.886172181e-03f, 9.475132304e-03f, 9.064423510e-03f, 8.654046081e-03f,
8.244000300e-03f, 7.834286450e-03f, 7.424904811e-03f, 7.015855667e-03f, 6.607139296e-03f, 6.198755981e-03f, 5.790706001e-03f, 5.382989635e-03f, 4.975607163e-03f, 4.568558863e-03f,
4.161845013e-03f, 3.755465892e-03f, 3.349421777e-03f, 2.943712943e-03f, 2.538339669e-03f, 2.133302229e-03f, 1.728600899e-03f, 1.324235955e-03f, 9.202076702e-04f, 5.165163192e-04f,
1.131621758e-04f, -2.898544871e-04f, -6.925333965e-04f, -1.094874280e-03f, -1.496876867e-03f, -1.898540884e-03f, -2.299866062e-03f, -2.700852130e-03f, -3.101498817e-03f, -3.501805855e-03f,
-3.901772975e-03f, -4.301399907e-03f, -4.700686383e-03f, -5.099632136e-03f, -5.498236900e-03f, -5.896500405e-03f, -6.294422388e-03f, -6.692002581e-03f, -7.089240720e-03f, -7.486136539e-03f,
-7.882689775e-03f, -8.278900162e-03f, -8.674767438e-03f, -9.070291339e-03f, -9.465471603e-03f, -9.860307968e-03f, -1.025480017e-02f, -1.064894795e-02f, -1.104275105e-02f, -1.143620921e-02f,
-1.182932216e-02f, -1.222208965e-02f, -1.261451142e-02f, -1.300658721e-02f, -1.339831676e-02f, -1.378969982e-02f, -1.418073612e-02f, -1.457142542e-02f, -1.496176745e-02f, -1.535176196e-02f,
-1.574140869e-02f, -1.613070739e-02f, -1.651965781e-02f, -1.690825969e-02f, -1.729651278e-02f, -1.768441683e-02f, -1.807197158e-02f, -1.845917678e-02f, -1.884603217e-02f, -1.923253752e-02f,
-1.961869257e-02f, -2.000449706e-02f, -2.038995076e-02f, -2.077505340e-02f, -2.115980474e-02f, -2.154420454e-02f, -2.192825254e-02f, -2.231194850e-02f, -2.269529218e-02f, -2.307828331e-02f,
-2.346092167e-02f, -2.384320700e-02f, -2.422513906e-02f, -2.460671760e-02f, -2.498794239e-02f, -2.536881317e-02f, -2.574932971e-02f, -2.612949175e-02f, -2.650929907e-02f, -2.688875142e-02f,
-2.726784855e-02f, -2.764659023e-02f, -2.802497622e-02f, -2.840300628e-02f, -2.878068016e-02f, -2.915799763e-02f, -2.953495845e-02f, -2.991156238e-02f, -3.028780919e-02f, -3.066369864e-02f,
-3.103923050e-02f, -3.141440451e-02f, -3.178922046e-02f, -3.216367811e-02f, -3.253777722e-02f, -3.291151756e-02f, -3.328489889e-02f, -3.365792098e-02f, -3.403058360e-02f, -3.440288652e-02f,
-3.477482951e-02f, -3.514641232e-02f, -3.551763475e-02f, -3.588849654e-02f, -3.625899748e-02f, -3.662913734e-02f, -3.699891588e-02f, -3.736833287e-02f, -3.773738810e-02f, -3.810608133e-02f,
-3.847441234e-02f, -3.884238089e-02f, -3.920998677e-02f, -3.957722975e-02f, -3.994410960e-02f, -4.031062611e-02f, -4.067677903e-02f, -4.104256816e-02f, -4.140799327e-02f, -4.177305413e-02f,
-4.213775053e-02f, -4.250208224e-02f, -4.286604904e-02f, -4.322965071e-02f, -4.359288703e-02f, -4.395575779e-02f, -4.431826276e-02f, -4.468040172e-02f, -4.504217446e-02f, -4.540358075e-02f,
-4.576462039e-02f, -4.612529315e-02f, -4.648559882e-02f, -4.684553718e-02f, -4.720510801e-02f, -4.756431111e-02f, -4.792314626e-02f, -4.828161324e-02f, -4.863971184e-02f, -4.899744185e-02f,
-4.935480305e-02f, -4.971179524e-02f, -5.006841820e-02f, -5.042467172e-02f, -5.078055559e-02f, -5.113606961e-02f, -5.149121355e-02f, -5.184598722e-02f, -5.220039040e-02f, -5.255442289e-02f,
-5.290808447e-02f, -5.326137495e-02f, -5.361429411e-02f, -5.396684175e-02f, -5.431901767e-02f, -5.467082165e-02f, -5.502225350e-02f, -5.537331300e-02f, -5.572399996e-02f, -5.607431418e-02f,
-5.642425544e-02f, -5.677382356e-02f, -5.712301832e-02f, -5.747183952e-02f, -5.782028697e-02f, -5.816836046e-02f, -5.851605980e-02f, -5.886338479e-02f, -5.921033522e-02f, -5.955691089e-02f,
-5.990311162e-02f, -6.024893720e-02f, -6.059438744e-02f, -6.093946214e-02f, -6.128416111e-02f, -6.162848414e-02f, -6.197243105e-02f, -6.231600163e-02f, -6.265919570e-02f, -6.300201307e-02f,
-6.334445354e-02f, -6.368651691e-02f, -6.402820300e-02f, -6.436951161e-02f, -6.471044255e-02f, -6.505099564e-02f, -6.539117068e-02f, -6.573096749e-02f, -6.607038587e-02f, -6.640942563e-02f,
-6.674808660e-02f, -6.708636857e-02f, -6.742427137e-02f, -6.776179481e-02f, -6.809893869e-02f, -6.843570284e-02f, -6.877208708e-02f, -6.910809121e-02f, -6.944371505e-02f, -6.977895842e-02f,
-7.011382113e-02f, -7.044830301e-02f, -7.078240387e-02f, -7.111612353e-02f, -7.144946180e-02f, -7.178241852e-02f, -7.211499349e-02f, -7.244718654e-02f, -7.277899749e-02f, -7.311042616e-02f,
-7.344147237e-02f, -7.377213594e-02f, -7.410241671e-02f, -7.443231448e-02f, -7.476182909e-02f, -7.509096036e-02f, -7.541970811e-02f, -7.574807217e-02f, -7.607605237e-02f, -7.640364853e-02f,
-7.673086048e-02f, -7.705768804e-02f, -7.738413104e-02f, -7.771018932e-02f, -7.803586270e-02f, -7.836115101e-02f, -7.868605407e-02f, -7.901057173e-02f, -7.933470381e-02f, -7.965845014e-02f,
-7.998181056e-02f, -8.030478489e-02f, -8.062737297e-02f, -8.094957463e-02f, -8.127138971e-02f, -8.159281804e-02f, -8.191385945e-02f, -8.223451379e-02f, -8.255478088e-02f, -8.287466056e-02f,
-8.319415267e-02f, -8.351325705e-02f, -8.383197354e-02f, -8.415030196e-02f, -8.446824217e-02f, -8.478579399e-02f, -8.510295728e-02f, -8.541973187e-02f, -8.573611760e-02f, -8.605211431e-02f,
-8.636772185e-02f, -8.668294005e-02f, -8.699776876e-02f, -8.731220782e-02f, -8.762625708e-02f, -8.793991638e-02f, -8.825318557e-02f, -8.856606448e-02f, -8.887855297e-02f, -8.919065089e-02f,
-8.950235807e-02f, -8.981367437e-02f, -9.012459963e-02f, -9.043513370e-02f, -9.074527644e-02f, -9.105502769e-02f, -9.136438729e-02f, -9.167335511e-02f, -9.198193098e-02f, -9.229011477e-02f,
-9.259790632e-02f, -9.290530549e-02f, -9.321231213e-02f, -9.351892608e-02f, -9.382514722e-02f, -9.413097538e-02f, -9.443641043e-02f, -9.474145222e-02f, -9.504610060e-02f, -9.535035544e-02f,
-9.565421658e-02f, -9.595768389e-02f, -9.626075722e-02f, -9.656343643e-02f, -9.686572139e-02f, -9.716761194e-02f, -9.746910795e-02f, -9.777020929e-02f, -9.807091580e-02f, -9.837122735e-02f,
-9.867114381e-02f, -9.897066503e-02f, -9.926979088e-02f, -9.956852123e-02f, -9.986685592e-02f, -1.001647948e-01f, -1.004623378e-01f, -1.007594848e-01f, -1.010562356e-01f, -1.013525900e-01f,
-1.016485480e-01f, -1.019441094e-01f, -1.022392741e-01f, -1.025340419e-01f, -1.028284128e-01f, -1.031223866e-01f, -1.034159631e-01f, -1.037091422e-01f, -1.040019239e-01f, -1.042943079e-01f,
-1.045862941e-01f, -1.048778825e-01f, -1.051690729e-01f, -1.054598651e-01f, -1.057502590e-01f, -1.060402546e-01f, -1.063298517e-01f, -1.066190501e-01f, -1.069078497e-01f, -1.071962505e-01f,
-1.074842522e-01f, -1.077718548e-01f, -1.080590582e-01f, -1.083458622e-01f, -1.086322667e-01f, -1.089182715e-01f, -1.092038766e-01f, -1.094890819e-01f, -1.097738872e-01f, -1.100582924e-01f,
-1.103422973e-01f, -1.106259020e-01f, -1.109091062e-01f, -1.111919098e-01f, -1.114743127e-01f, -1.117563149e-01f, -1.120379161e-01f, -1.123191163e-01f, -1.125999153e-01f, -1.128803131e-01f,
-1.131603095e-01f, -1.134399045e-01f, -1.137190978e-01f, -1.139978895e-01f, -1.142762793e-01f, -1.145542672e-01f, -1.148318531e-01f, -1.151090368e-01f, -1.153858182e-01f, -1.156621973e-01f,
-1.159381739e-01f, -1.162137480e-01f, -1.164889193e-01f, -1.167636879e-01f, -1.170380535e-01f, -1.173120162e-01f, -1.175855757e-01f, -1.178587320e-01f, -1.181314850e-01f, -1.184038346e-01f,
-1.186757807e-01f, -1.189473231e-01f, -1.192184618e-01f, -1.194891966e-01f, -1.197595276e-01f, -1.200294545e-01f, -1.202989772e-01f, -1.205680958e-01f, -1.208368100e-01f, -1.211051197e-01f,
-1.213730249e-01f, -1.216405256e-01f, -1.219076214e-01f, -1.221743125e-01f, -1.224405987e-01f, -1.227064798e-01f, -1.229719558e-01f, -1.232370267e-01f, -1.235016922e-01f, -1.237659523e-01f,
-1.240298070e-01f, -1.242932561e-01f, -1.245562995e-01f, -1.248189372e-01f, -1.250811690e-01f, -1.253429949e-01f, -1.256044148e-01f, -1.258654285e-01f, -1.261260360e-01f, -1.263862373e-01f,
-1.266460321e-01f, -1.269054205e-01f, -1.271644023e-01f, -1.274229775e-01f, -1.276811460e-01f, -1.279389076e-01f, -1.281962624e-01f, -1.284532101e-01f, -1.287097508e-01f, -1.289658843e-01f,
-1.292216106e-01f, -1.294769296e-01f, -1.297318412e-01f, -1.299863453e-01f, -1.302404419e-01f, -1.304941308e-01f, -1.307474120e-01f, -1.310002854e-01f, -1.312527509e-01f, -1.315048084e-01f,
-1.317564579e-01f, -1.320076993e-01f, -1.322585326e-01f, -1.325089575e-01f, -1.327589741e-01f, -1.330085823e-01f, -1.332577820e-01f, -1.335065732e-01f, -1.337549557e-01f, -1.340029294e-01f,
-1.342504944e-01f, -1.344976506e-01f, -1.347443978e-01f, -1.349907360e-01f, -1.352366652e-01f, -1.354821852e-01f, -1.357272960e-01f, -1.359719975e-01f, -1.362162896e-01f, -1.364601724e-01f,
-1.367036456e-01f, -1.369467093e-01f, -1.371893634e-01f, -1.374316078e-01f, -1.376734425e-01f, -1.379148673e-01f, -1.381558823e-01f, -1.383964873e-01f, -1.386366823e-01f, -1.388764672e-01f,
-1.391158420e-01f, -1.393548066e-01f, -1.395933610e-01f, -1.398315050e-01f, -1.400692386e-01f, -1.403065618e-01f, -1.405434745e-01f, -1.407799767e-01f, -1.410160682e-01f, -1.412517490e-01f,
-1.414870192e-01f, -1.417218785e-01f, -1.419563270e-01f, -1.421903645e-01f, -1.424239912e-01f, -1.426572068e-01f, -1.428900113e-01f, -1.431224047e-01f, -1.433543869e-01f, -1.435859579e-01f,
-1.438171177e-01f, -1.440478661e-01f, -1.442782031e-01f, -1.445081286e-01f, -1.447376427e-01f, -1.449667453e-01f, -1.451954362e-01f, -1.454237155e-01f, -1.456515832e-01f, -1.458790391e-01f,
-1.461060832e-01f, -1.463327155e-01f, -1.465589359e-01f, -1.467847444e-01f, -1.470101409e-01f, -1.472351255e-01f, -1.474596979e-01f, -1.476838583e-01f, -1.479076065e-01f, -1.481309426e-01f,
-1.483538664e-01f, -1.485763779e-01f, -1.487984772e-01f, -1.490201640e-01f, -1.492414385e-01f, -1.494623006e-01f, -1.496827501e-01f, -1.499027872e-01f, -1.501224117e-01f, -1.503416236e-01f,
-1.505604229e-01f, -1.507788096e-01f, -1.509967835e-01f, -1.512143447e-01f, -1.514314931e-01f, -1.516482288e-01f, -1.518645516e-01f, -1.520804615e-01f, -1.522959585e-01f, -1.525110425e-01f,
-1.527257136e-01f, -1.529399717e-01f, -1.531538167e-01f, -1.533672487e-01f, -1.535802676e-01f, -1.537928733e-01f, -1.540050659e-01f, -1.542168453e-01f, -1.544282115e-01f, -1.546391644e-01f,
-1.548497041e-01f, -1.550598304e-01f, -1.552695435e-01f, -1.554788432e-01f, -1.556877295e-01f, -1.558962024e-01f, -1.561042619e-01f, -1.563119079e-01f, -1.565191405e-01f, -1.567259596e-01f,
-1.569323651e-01f, -1.571383571e-01f, -1.573439356e-01f, -1.575491004e-01f, -1.577538517e-01f, -1.579581893e-01f, -1.581621133e-01f, -1.583656237e-01f, -1.585687203e-01f, -1.587714033e-01f,
-1.589736725e-01f, -1.591755280e-01f, -1.593769697e-01f, -1.595779977e-01f, -1.597786119e-01f, -1.599788123e-01f, -1.601785989e-01f, -1.603779717e-01f, -1.605769306e-01f, -1.607754757e-01f,
-1.609736069e-01f, -1.611713242e-01f, -1.613686277e-01f, -1.615655172e-01f, -1.617619929e-01f, -1.619580546e-01f, -1.621537024e-01f, -1.623489362e-01f, -1.625437561e-01f, -1.627381621e-01f,
-1.629321541e-01f, -1.631257321e-01f, -1.633188962e-01f, -1.635116462e-01f, -1.637039823e-01f, -1.638959044e-01f, -1.640874124e-01f, -1.642785065e-01f, -1.644691866e-01f, -1.646594527e-01f,
-1.648493047e-01f, -1.650387428e-01f, -1.652277668e-01f, -1.654163768e-01f, -1.656045728e-01f, -1.657923548e-01f, -1.659797228e-01f, -1.661666767e-01f, -1.663532167e-01f, -1.665393426e-01f,
-1.667250545e-01f, -1.669103524e-01f, -1.670952363e-01f, -1.672797062e-01f, -1.674637622e-01f, -1.676474041e-01f, -1.678306320e-01f, -1.680134460e-01f, -1.681958460e-01f, -1.683778320e-01f,
-1.685594040e-01f, -1.687405621e-01f, -1.689213063e-01f, -1.691016365e-01f, -1.692815528e-01f, -1.694610552e-01f, -1.696401437e-01f, -1.698188183e-01f, -1.699970790e-01f, -1.701749259e-01f,
-1.703523588e-01f, -1.705293780e-01f, -1.707059833e-01f, -1.708821748e-01f, -1.710579524e-01f, -1.712333163e-01f, -1.714082664e-01f, -1.715828028e-01f, -1.717569254e-01f, -1.719306343e-01f,
-1.721039295e-01f, -1.722768109e-01f, -1.724492787e-01f, -1.726213329e-01f, -1.727929734e-01f, -1.729642003e-01f, -1.731350136e-01f, -1.733054133e-01f, -1.734753995e-01f, -1.736449721e-01f,
-1.738141313e-01f, -1.739828769e-01f, -1.741512091e-01f, -1.743191278e-01f, -1.744866331e-01f, -1.746537250e-01f, -1.748204036e-01f, -1.749866688e-01f, -1.751525207e-01f, -1.753179592e-01f,
-1.754829846e-01f, -1.756475967e-01f, -1.758117955e-01f, -1.759755813e-01f, -1.761389538e-01f, -1.763019132e-01f, -1.764644596e-01f, -1.766265928e-01f, -1.767883131e-01f, -1.769496203e-01f,
-1.771105146e-01f, -1.772709959e-01f, -1.774310644e-01f, -1.775907199e-01f, -1.777499627e-01f, -1.779087926e-01f, -1.780672097e-01f, -1.782252142e-01f, -1.783828059e-01f, -1.785399850e-01f,
-1.786967514e-01f, -1.788531053e-01f, -1.790090466e-01f, -1.791645754e-01f, -1.793196917e-01f, -1.794743956e-01f, -1.796286871e-01f, -1.797825663e-01f, -1.799360331e-01f, -1.800890876e-01f,
-1.802417300e-01f, -1.803939601e-01f, -1.805457781e-01f, -1.806971840e-01f, -1.808481778e-01f, -1.809987597e-01f, -1.811489295e-01f, -1.812986874e-01f, -1.814480335e-01f, -1.815969677e-01f,
-1.817454901e-01f, -1.818936007e-01f, -1.820412997e-01f, -1.821885870e-01f, -1.823354628e-01f, -1.824819269e-01f, -1.826279796e-01f, -1.827736208e-01f, -1.829188507e-01f, -1.830636691e-01f,
-1.832080763e-01f, -1.833520722e-01f, -1.834956570e-01f, -1.836388305e-01f, -1.837815930e-01f, -1.839239445e-01f, -1.840658850e-01f, -1.842074145e-01f, -1.843485332e-01f, -1.844892410e-01f,
-1.846295381e-01f, -1.847694245e-01f, -1.849089002e-01f, -1.850479654e-01f, -1.851866200e-01f, -1.853248641e-01f, -1.854626979e-01f, -1.856001212e-01f, -1.857371343e-01f, -1.858737371e-01f,
-1.860099298e-01f, -1.861457123e-01f, -1.862810848e-01f, -1.864160473e-01f, -1.865505998e-01f, -1.866847425e-01f, -1.868184754e-01f, -1.869517985e-01f, -1.870847120e-01f, -1.872172159e-01f,
-1.873493102e-01f, -1.874809951e-01f, -1.876122705e-01f, -1.877431366e-01f, -1.878735934e-01f, -1.880036410e-01f, -1.881332794e-01f, -1.882625088e-01f, -1.883913292e-01f, -1.885197407e-01f,
-1.886477433e-01f, -1.887753371e-01f, -1.889025221e-01f, -1.890292985e-01f, -1.891556664e-01f, -1.892816257e-01f, -1.894071766e-01f, -1.895323192e-01f, -1.896570534e-01f, -1.897813795e-01f,
-1.899052974e-01f, -1.900288073e-01f, -1.901519091e-01f, -1.902746031e-01f, -1.903968892e-01f, -1.905187676e-01f, -1.906402383e-01f, -1.907613014e-01f, -1.908819570e-01f, -1.910022051e-01f,
-1.911220459e-01f, -1.912414794e-01f, -1.913605057e-01f, -1.914791248e-01f, -1.915973370e-01f, -1.917151422e-01f, -1.918325405e-01f, -1.919495320e-01f, -1.920661168e-01f, -1.921822950e-01f,
-1.922980666e-01f, -1.924134318e-01f, -1.925283906e-01f, -1.926429431e-01f, -1.927570895e-01f, -1.928708297e-01f, -1.929841639e-01f, -1.930970922e-01f, -1.932096146e-01f, -1.933217312e-01f,
-1.934334422e-01f, -1.935447476e-01f, -1.936556475e-01f, -1.937661420e-01f, -1.938762312e-01f, -1.939859152e-01f, -1.940951940e-01f, -1.942040678e-01f, -1.943125367e-01f, -1.944206007e-01f,
-1.945282599e-01f, -1.946355145e-01f, -1.947423645e-01f, -1.948488101e-01f, -1.949548513e-01f, -1.950604881e-01f, -1.951657208e-01f, -1.952705494e-01f, -1.953749741e-01f, -1.954789948e-01f,
-1.955826117e-01f, -1.956858249e-01f, -1.957886345e-01f, -1.958910407e-01f, -1.959930434e-01f, -1.960946428e-01f, -1.961958390e-01f, -1.962966322e-01f, -1.963970223e-01f, -1.964970096e-01f,
-1.965965940e-01f, -1.966957758e-01f, -1.967945549e-01f, -1.968929316e-01f, -1.969909060e-01f, -1.970884780e-01f, -1.971856479e-01f, -1.972824158e-01f, -1.973787816e-01f, -1.974747457e-01f,
-1.975703080e-01f, -1.976654686e-01f, -1.977602278e-01f, -1.978545855e-01f, -1.979485419e-01f, -1.980420972e-01f, -1.981352513e-01f, -1.982280045e-01f, -1.983203568e-01f, -1.984123083e-01f,
-1.985038592e-01f, -1.985950096e-01f, -1.986857596e-01f, -1.987761093e-01f, -1.988660587e-01f, -1.989556081e-01f, -1.990447576e-01f, -1.991335072e-01f, -1.992218570e-01f, -1.993098073e-01f,
-1.993973581e-01f, -1.994845094e-01f, -1.995712615e-01f, -1.996576145e-01f, -1.997435684e-01f, -1.998291235e-01f, -1.999142797e-01f, -1.999990373e-01f, -2.000833963e-01f, -2.001673569e-01f,
-2.002509191e-01f, -2.003340832e-01f, -2.004168492e-01f, -2.004992173e-01f, -2.005811875e-01f, -2.006627601e-01f, -2.007439351e-01f, -2.008247126e-01f, -2.009050928e-01f, -2.009850758e-01f,
-2.010646617e-01f, -2.011438506e-01f, -2.012226428e-01f, -2.013010382e-01f, -2.013790371e-01f, -2.014566395e-01f, -2.015338456e-01f, -2.016106555e-01f, -2.016870694e-01f, -2.017630873e-01f,
-2.018387094e-01f, -2.019139358e-01f, -2.019887668e-01f, -2.020632023e-01f, -2.021372425e-01f, -2.022108876e-01f, -2.022841376e-01f, -2.023569928e-01f, -2.024294532e-01f, -2.025015191e-01f,
-2.025731904e-01f, -2.026444674e-01f, -2.027153502e-01f, -2.027858389e-01f, -2.028559337e-01f, -2.029256346e-01f, -2.029949419e-01f, -2.030638557e-01f, -2.031323761e-01f, -2.032005032e-01f,
-2.032682372e-01f, -2.033355783e-01f, -2.034025265e-01f, -2.034690820e-01f, -2.035352449e-01f, -2.036010154e-01f, -2.036663937e-01f, -2.037313798e-01f, -2.037959739e-01f, -2.038601762e-01f,
-2.039239868e-01f, -2.039874058e-01f, -2.040504334e-01f, -2.041130697e-01f, -2.041753149e-01f, -2.042371691e-01f, -2.042986324e-01f, -2.043597051e-01f, -2.044203872e-01f, -2.044806789e-01f,
-2.045405803e-01f, -2.046000917e-01f, -2.046592131e-01f, -2.047179446e-01f, -2.047762866e-01f, -2.048342390e-01f, -2.048918020e-01f, -2.049489758e-01f, -2.050057606e-01f, -2.050621564e-01f,
-2.051181635e-01f, -2.051737820e-01f, -2.052290120e-01f, -2.052838537e-01f, -2.053383073e-01f, -2.053923729e-01f, -2.054460506e-01f, -2.054993406e-01f, -2.055522432e-01f, -2.056047583e-01f,
-2.056568862e-01f, -2.057086270e-01f, -2.057599810e-01f, -2.058109481e-01f, -2.058615287e-01f, -2.059117229e-01f, -2.059615307e-01f, -2.060109525e-01f, -2.060599882e-01f, -2.061086382e-01f,
-2.061569025e-01f, -2.062047814e-01f, -2.062522749e-01f, -2.062993833e-01f, -2.063461066e-01f, -2.063924452e-01f, -2.064383990e-01f, -2.064839684e-01f, -2.065291534e-01f, -2.065739542e-01f,
-2.066183710e-01f, -2.066624039e-01f, -2.067060531e-01f, -2.067493188e-01f, -2.067922012e-01f, -2.068347004e-01f, -2.068768165e-01f, -2.069185498e-01f, -2.069599003e-01f, -2.070008684e-01f,
-2.070414541e-01f, -2.070816576e-01f, -2.071214791e-01f, -2.071609187e-01f, -2.071999767e-01f, -2.072386531e-01f, -2.072769482e-01f, -2.073148621e-01f, -2.073523951e-01f, -2.073895472e-01f,
-2.074263187e-01f, -2.074627096e-01f, -2.074987203e-01f, -2.075343509e-01f, -2.075696014e-01f, -2.076044723e-01f, -2.076389634e-01f, -2.076730752e-01f, -2.077068077e-01f, -2.077401611e-01f,
-2.077731356e-01f, -2.078057314e-01f, -2.078379487e-01f, -2.078697875e-01f, -2.079012482e-01f, -2.079323308e-01f, -2.079630356e-01f, -2.079933628e-01f, -2.080233124e-01f, -2.080528848e-01f,
-2.080820801e-01f, -2.081108984e-01f, -2.081393399e-01f, -2.081674049e-01f, -2.081950935e-01f, -2.082224059e-01f, -2.082493422e-01f, -2.082759027e-01f, -2.083020876e-01f, -2.083278970e-01f,
-2.083533310e-01f, -2.083783900e-01f, -2.084030741e-01f, -2.084273834e-01f, -2.084513182e-01f, -2.084748786e-01f, -2.084980648e-01f, -2.085208771e-01f, -2.085433155e-01f, -2.085653804e-01f,
-2.085870718e-01f, -2.086083899e-01f, -2.086293351e-01f, -2.086499074e-01f, -2.086701070e-01f, -2.086899341e-01f, -2.087093890e-01f, -2.087284717e-01f, -2.087471826e-01f, -2.087655218e-01f,
-2.087834894e-01f, -2.088010857e-01f, -2.088183109e-01f, -2.088351652e-01f, -2.088516487e-01f, -2.088677616e-01f, -2.088835042e-01f, -2.088988767e-01f, -2.089138792e-01f, -2.089285119e-01f,
-2.089427751e-01f, -2.089566689e-01f, -2.089701935e-01f, -2.089833491e-01f, -2.089961360e-01f, -2.090085543e-01f, -2.090206042e-01f, -2.090322859e-01f, -2.090435996e-01f, -2.090545456e-01f,
-2.090651239e-01f, -2.090753349e-01f, -2.090851787e-01f, -2.090946556e-01f, -2.091037656e-01f, -2.091125091e-01f, -2.091208862e-01f, -2.091288971e-01f, -2.091365421e-01f, -2.091438213e-01f,
-2.091507350e-01f, -2.091572833e-01f, -2.091634664e-01f, -2.091692846e-01f, -2.091747381e-01f, -2.091798271e-01f, -2.091845517e-01f, -2.091889122e-01f, -2.091929088e-01f, -2.091965417e-01f,
-2.091998111e-01f, -2.092027172e-01f, -2.092052602e-01f, -2.092074404e-01f, -2.092092579e-01f, -2.092107130e-01f, -2.092118058e-01f, -2.092125366e-01f, -2.092129056e-01f, -2.092129130e-01f,
-2.092125589e-01f, -2.092118438e-01f, -2.092107676e-01f, -2.092093307e-01f, -2.092075332e-01f, -2.092053754e-01f, -2.092028575e-01f, -2.091999797e-01f, -2.091967423e-01f, -2.091931453e-01f,
-2.091891891e-01f, -2.091848739e-01f, -2.091801998e-01f, -2.091751672e-01f, -2.091697761e-01f, -2.091640269e-01f, -2.091579197e-01f, -2.091514548e-01f, -2.091446324e-01f, -2.091374527e-01f,
-2.091299159e-01f, -2.091220222e-01f, -2.091137719e-01f, -2.091051652e-01f, -2.090962023e-01f, -2.090868834e-01f, -2.090772088e-01f, -2.090671787e-01f, -2.090567932e-01f, -2.090460526e-01f,
-2.090349572e-01f, -2.090235072e-01f, -2.090117027e-01f, -2.089995440e-01f, -2.089870314e-01f, -2.089741650e-01f, -2.089609451e-01f, -2.089473719e-01f, -2.089334457e-01f, -2.089191666e-01f,
-2.089045348e-01f, -2.088895507e-01f, -2.088742145e-01f, -2.088585263e-01f, -2.088424864e-01f, -2.088260951e-01f, -2.088093524e-01f, -2.087922588e-01f, -2.087748144e-01f, -2.087570194e-01f,
-2.087388741e-01f, -2.087203787e-01f, -2.087015335e-01f, -2.086823386e-01f, -2.086627943e-01f, -2.086429008e-01f, -2.086226584e-01f, -2.086020673e-01f, -2.085811277e-01f, -2.085598398e-01f,
-2.085382040e-01f, -2.085162204e-01f, -2.084938892e-01f, -2.084712108e-01f, -2.084481853e-01f, -2.084248129e-01f, -2.084010940e-01f, -2.083770287e-01f, -2.083526173e-01f, -2.083278600e-01f,
-2.083027570e-01f, -2.082773086e-01f, -2.082515151e-01f, -2.082253766e-01f, -2.081988935e-01f, -2.081720658e-01f, -2.081448940e-01f, -2.081173782e-01f, -2.080895186e-01f, -2.080613156e-01f,
-2.080327692e-01f, -2.080038799e-01f, -2.079746478e-01f, -2.079450732e-01f, -2.079151563e-01f, -2.078848973e-01f, -2.078542965e-01f, -2.078233542e-01f, -2.077920705e-01f, -2.077604458e-01f,
-2.077284802e-01f, -2.076961741e-01f, -2.076635276e-01f, -2.076305410e-01f, -2.075972146e-01f, -2.075635486e-01f, -2.075295432e-01f, -2.074951987e-01f, -2.074605154e-01f, -2.074254934e-01f,
-2.073901330e-01f, -2.073544346e-01f, -2.073183982e-01f, -2.072820243e-01f, -2.072453129e-01f, -2.072082645e-01f, -2.071708791e-01f, -2.071331572e-01f, -2.070950988e-01f, -2.070567044e-01f,
-2.070179741e-01f, -2.069789081e-01f, -2.069395068e-01f, -2.068997703e-01f, -2.068596990e-01f, -2.068192931e-01f, -2.067785528e-01f, -2.067374784e-01f, -2.066960701e-01f, -2.066543283e-01f,
-2.066122531e-01f, -2.065698448e-01f, -2.065271037e-01f, -2.064840300e-01f, -2.064406240e-01f, -2.063968859e-01f, -2.063528159e-01f, -2.063084145e-01f, -2.062636817e-01f, -2.062186179e-01f,
-2.061732233e-01f, -2.061274982e-01f, -2.060814428e-01f, -2.060350574e-01f, -2.059883422e-01f, -2.059412976e-01f, -2.058939237e-01f, -2.058462209e-01f, -2.057981893e-01f, -2.057498293e-01f,
-2.057011411e-01f, -2.056521250e-01f, -2.056027812e-01f, -2.055531100e-01f, -2.055031116e-01f, -2.054527864e-01f, -2.054021345e-01f, -2.053511563e-01f, -2.052998520e-01f, -2.052482219e-01f,
-2.051962662e-01f, -2.051439852e-01f, -2.050913791e-01f, -2.050384483e-01f, -2.049851930e-01f, -2.049316135e-01f, -2.048777099e-01f, -2.048234827e-01f, -2.047689320e-01f, -2.047140582e-01f,
-2.046588614e-01f, -2.046033420e-01f, -2.045475002e-01f, -2.044913363e-01f, -2.044348506e-01f, -2.043780433e-01f, -2.043209147e-01f, -2.042634651e-01f, -2.042056947e-01f, -2.041476039e-01f,
-2.040891928e-01f, -2.040304618e-01f, -2.039714111e-01f, -2.039120409e-01f, -2.038523517e-01f, -2.037923436e-01f, -2.037320169e-01f, -2.036713718e-01f, -2.036104088e-01f, -2.035491279e-01f,
-2.034875296e-01f, -2.034256140e-01f, -2.033633815e-01f, -2.033008323e-01f, -2.032379666e-01f, -2.031747849e-01f, -2.031112873e-01f, -2.030474741e-01f, -2.029833457e-01f, -2.029189022e-01f,
-2.028541439e-01f, -2.027890712e-01f, -2.027236843e-01f, -2.026579834e-01f, -2.025919689e-01f, -2.025256411e-01f, -2.024590002e-01f, -2.023920464e-01f, -2.023247802e-01f, -2.022572016e-01f,
-2.021893111e-01f, -2.021211090e-01f, -2.020525954e-01f, -2.019837706e-01f, -2.019146351e-01f, -2.018451889e-01f, -2.017754325e-01f, -2.017053660e-01f, -2.016349899e-01f, -2.015643043e-01f,
-2.014933095e-01f, -2.014220058e-01f, -2.013503936e-01f, -2.012784730e-01f, -2.012062444e-01f, -2.011337081e-01f, -2.010608643e-01f, -2.009877133e-01f, -2.009142555e-01f, -2.008404910e-01f,
-2.007664202e-01f, -2.006920433e-01f, -2.006173608e-01f, -2.005423727e-01f, -2.004670795e-01f, -2.003914813e-01f, -2.003155786e-01f, -2.002393715e-01f, -2.001628605e-01f, -2.000860456e-01f,
-2.000089273e-01f, -1.999315059e-01f, -1.998537815e-01f, -1.997757546e-01f, -1.996974254e-01f, -1.996187941e-01f, -1.995398612e-01f, -1.994606268e-01f, -1.993810912e-01f, -1.993012548e-01f,
-1.992211179e-01f, -1.991406807e-01f, -1.990599434e-01f, -1.989789066e-01f, -1.988975703e-01f, -1.988159349e-01f, -1.987340007e-01f, -1.986517680e-01f, -1.985692370e-01f, -1.984864081e-01f,
-1.984032816e-01f, -1.983198577e-01f, -1.982361368e-01f, -1.981521192e-01f, -1.980678050e-01f, -1.979831947e-01f, -1.978982886e-01f, -1.978130868e-01f, -1.977275898e-01f, -1.976417978e-01f,
-1.975557111e-01f, -1.974693300e-01f, -1.973826548e-01f, -1.972956858e-01f, -1.972084233e-01f, -1.971208676e-01f, -1.970330190e-01f, -1.969448778e-01f, -1.968564443e-01f, -1.967677187e-01f,
-1.966787015e-01f, -1.965893928e-01f, -1.964997931e-01f, -1.964099025e-01f, -1.963197214e-01f, -1.962292501e-01f, -1.961384889e-01f, -1.960474380e-01f, -1.959560979e-01f, -1.958644687e-01f,
-1.957725508e-01f, -1.956803446e-01f, -1.955878502e-01f, -1.954950680e-01f, -1.954019983e-01f, -1.953086414e-01f, -1.952149976e-01f, -1.951210673e-01f, -1.950268506e-01f, -1.949323480e-01f,
-1.948375596e-01f, -1.947424859e-01f, -1.946471272e-01f, -1.945514836e-01f, -1.944555556e-01f, -1.943593435e-01f, -1.942628475e-01f, -1.941660679e-01f, -1.940690051e-01f, -1.939716594e-01f,
-1.938740310e-01f, -1.937761204e-01f, -1.936779277e-01f, -1.935794533e-01f, -1.934806975e-01f, -1.933816606e-01f, -1.932823430e-01f, -1.931827449e-01f, -1.930828666e-01f, -1.929827084e-01f,
-1.928822707e-01f, -1.927815538e-01f, -1.926805579e-01f, -1.925792834e-01f, -1.924777307e-01f, -1.923758999e-01f, -1.922737914e-01f, -1.921714055e-01f, -1.920687426e-01f, -1.919658029e-01f,
-1.918625868e-01f, -1.917590946e-01f, -1.916553265e-01f, -1.915512829e-01f, -1.914469642e-01f, -1.913423705e-01f, -1.912375023e-01f, -1.911323598e-01f, -1.910269434e-01f, -1.909212533e-01f,
-1.908152899e-01f, -1.907090536e-01f, -1.906025445e-01f, -1.904957631e-01f, -1.903887096e-01f, -1.902813844e-01f, -1.901737877e-01f, -1.900659199e-01f, -1.899577813e-01f, -1.898493723e-01f,
-1.897406931e-01f, -1.896317440e-01f, -1.895225254e-01f, -1.894130376e-01f, -1.893032809e-01f, -1.891932556e-01f, -1.890829620e-01f, -1.889724005e-01f, -1.888615714e-01f, -1.887504750e-01f,
-1.886391115e-01f, -1.885274814e-01f, -1.884155850e-01f, -1.883034225e-01f, -1.881909943e-01f, -1.880783007e-01f, -1.879653420e-01f, -1.878521186e-01f, -1.877386307e-01f, -1.876248788e-01f,
-1.875108630e-01f, -1.873965837e-01f, -1.872820413e-01f, -1.871672361e-01f, -1.870521684e-01f, -1.869368384e-01f, -1.868212466e-01f, -1.867053933e-01f, -1.865892787e-01f, -1.864729033e-01f,
-1.863562673e-01f, -1.862393710e-01f, -1.861222147e-01f, -1.860047989e-01f, -1.858871238e-01f, -1.857691898e-01f, -1.856509971e-01f, -1.855325461e-01f, -1.854138371e-01f, -1.852948704e-01f,
-1.851756464e-01f, -1.850561654e-01f, -1.849364277e-01f, -1.848164337e-01f, -1.846961836e-01f, -1.845756778e-01f, -1.844549167e-01f, -1.843339005e-01f, -1.842126295e-01f, -1.840911042e-01f,
-1.839693247e-01f, -1.838472916e-01f, -1.837250050e-01f, -1.836024653e-01f, -1.834796728e-01f, -1.833566280e-01f, -1.832333310e-01f, -1.831097822e-01f, -1.829859820e-01f, -1.828619306e-01f,
-1.827376285e-01f, -1.826130759e-01f, -1.824882732e-01f, -1.823632206e-01f, -1.822379186e-01f, -1.821123675e-01f, -1.819865675e-01f, -1.818605190e-01f, -1.817342224e-01f, -1.816076780e-01f,
-1.814808861e-01f, -1.813538470e-01f, -1.812265611e-01f, -1.810990287e-01f, -1.809712501e-01f, -1.808432257e-01f, -1.807149558e-01f, -1.805864408e-01f, -1.804576809e-01f, -1.803286765e-01f,
-1.801994279e-01f, -1.800699355e-01f, -1.799401996e-01f, -1.798102205e-01f, -1.796799986e-01f, -1.795495342e-01f, -1.794188276e-01f, -1.792878792e-01f, -1.791566892e-01f, -1.790252582e-01f,
-1.788935862e-01f, -1.787616738e-01f, -1.786295213e-01f, -1.784971289e-01f, -1.783644970e-01f, -1.782316260e-01f, -1.780985162e-01f, -1.779651679e-01f, -1.778315814e-01f, -1.776977571e-01f,
-1.775636954e-01f, -1.774293965e-01f, -1.772948609e-01f, -1.771600887e-01f, -1.770250805e-01f, -1.768898365e-01f, -1.767543570e-01f, -1.766186424e-01f, -1.764826931e-01f, -1.763465093e-01f,
-1.762100914e-01f, -1.760734398e-01f, -1.759365547e-01f, -1.757994366e-01f, -1.756620858e-01f, -1.755245025e-01f, -1.753866872e-01f, -1.752486402e-01f, -1.751103618e-01f, -1.749718524e-01f,
-1.748331122e-01f, -1.746941417e-01f, -1.745549412e-01f, -1.744155110e-01f, -1.742758515e-01f, -1.741359630e-01f, -1.739958458e-01f, -1.738555003e-01f, -1.737149269e-01f, -1.735741258e-01f,
-1.734330975e-01f, -1.732918422e-01f, -1.731503603e-01f, -1.730086521e-01f, -1.728667180e-01f, -1.727245584e-01f, -1.725821735e-01f, -1.724395637e-01f, -1.722967294e-01f, -1.721536709e-01f,
-1.720103885e-01f, -1.718668826e-01f, -1.717231536e-01f, -1.715792017e-01f, -1.714350273e-01f, -1.712906308e-01f, -1.711460125e-01f, -1.710011728e-01f, -1.708561120e-01f, -1.707108304e-01f,
-1.705653284e-01f, -1.704196063e-01f, -1.702736645e-01f, -1.701275033e-01f, -1.699811231e-01f, -1.698345242e-01f, -1.696877070e-01f, -1.695406718e-01f, -1.693934189e-01f, -1.692459488e-01f,
-1.690982617e-01f, -1.689503579e-01f, -1.688022380e-01f, -1.686539021e-01f, -1.685053506e-01f, -1.683565840e-01f, -1.682076024e-01f, -1.680584064e-01f, -1.679089961e-01f, -1.677593721e-01f,
-1.676095346e-01f, -1.674594839e-01f, -1.673092205e-01f, -1.671587446e-01f, -1.670080567e-01f, -1.668571570e-01f, -1.667060459e-01f, -1.665547238e-01f, -1.664031910e-01f, -1.662514479e-01f,
-1.660994948e-01f, -1.659473320e-01f, -1.657949600e-01f, -1.656423790e-01f, -1.654895895e-01f, -1.653365917e-01f, -1.651833860e-01f, -1.650299728e-01f, -1.648763524e-01f, -1.647225251e-01f,
-1.645684914e-01f, -1.644142516e-01f, -1.642598059e-01f, -1.641051549e-01f, -1.639502987e-01f, -1.637952379e-01f, -1.636399726e-01f, -1.634845034e-01f, -1.633288305e-01f, -1.631729542e-01f,
-1.630168750e-01f, -1.628605932e-01f, -1.627041091e-01f, -1.625474231e-01f, -1.623905356e-01f, -1.622334468e-01f, -1.620761573e-01f, -1.619186672e-01f, -1.617609769e-01f, -1.616030869e-01f,
-1.614449975e-01f, -1.612867089e-01f, -1.611282217e-01f, -1.609695361e-01f, -1.608106524e-01f, -1.606515711e-01f, -1.604922925e-01f, -1.603328169e-01f, -1.601731447e-01f, -1.600132763e-01f,
-1.598532120e-01f, -1.596929521e-01f, -1.595324971e-01f, -1.593718472e-01f, -1.592110029e-01f, -1.590499645e-01f, -1.588887323e-01f, -1.587273066e-01f, -1.585656880e-01f, -1.584038766e-01f,
-1.582418730e-01f, -1.580796773e-01f, -1.579172900e-01f, -1.577547115e-01f, -1.575919420e-01f, -1.574289820e-01f, -1.572658318e-01f, -1.571024917e-01f, -1.569389622e-01f, -1.567752435e-01f,
-1.566113361e-01f, -1.564472402e-01f, -1.562829563e-01f, -1.561184847e-01f, -1.559538258e-01f, -1.557889799e-01f, -1.556239473e-01f, -1.554587285e-01f, -1.552933238e-01f, -1.551277336e-01f,
-1.549619581e-01f, -1.547959978e-01f, -1.546298531e-01f, -1.544635242e-01f, -1.542970115e-01f, -1.541303155e-01f, -1.539634364e-01f, -1.537963747e-01f, -1.536291306e-01f, -1.534617046e-01f,
-1.532940969e-01f, -1.531263081e-01f, -1.529583383e-01f, -1.527901880e-01f, -1.526218575e-01f, -1.524533473e-01f, -1.522846576e-01f, -1.521157888e-01f, -1.519467413e-01f, -1.517775154e-01f,
-1.516081115e-01f, -1.514385300e-01f, -1.512687711e-01f, -1.510988354e-01f, -1.509287231e-01f, -1.507584346e-01f, -1.505879703e-01f, -1.504173304e-01f, -1.502465155e-01f, -1.500755258e-01f,
-1.499043617e-01f, -1.497330236e-01f, -1.495615118e-01f, -1.493898266e-01f, -1.492179686e-01f, -1.490459379e-01f, -1.488737350e-01f, -1.487013603e-01f, -1.485288140e-01f, -1.483560966e-01f,
-1.481832084e-01f, -1.480101498e-01f, -1.478369212e-01f, -1.476635228e-01f, -1.474899552e-01f, -1.473162185e-01f, -1.471423133e-01f, -1.469682398e-01f, -1.467939984e-01f, -1.466195895e-01f,
-1.464450135e-01f, -1.462702706e-01f, -1.460953614e-01f, -1.459202860e-01f, -1.457450450e-01f, -1.455696386e-01f, -1.453940673e-01f, -1.452183313e-01f, -1.450424311e-01f, -1.448663670e-01f,
-1.446901394e-01f, -1.445137486e-01f, -1.443371950e-01f, -1.441604790e-01f, -1.439836010e-01f, -1.438065612e-01f, -1.436293601e-01f, -1.434519980e-01f, -1.432744753e-01f, -1.430967924e-01f,
-1.429189496e-01f, -1.427409473e-01f, -1.425627858e-01f, -1.423844655e-01f, -1.422059868e-01f, -1.420273501e-01f, -1.418485556e-01f, -1.416696038e-01f, -1.414904951e-01f, -1.413112298e-01f,
-1.411318082e-01f, -1.409522308e-01f, -1.407724978e-01f, -1.405926098e-01f, -1.404125669e-01f, -1.402323697e-01f, -1.400520184e-01f, -1.398715134e-01f, -1.396908551e-01f, -1.395100439e-01f,
-1.393290801e-01f, -1.391479640e-01f, -1.389666962e-01f, -1.387852768e-01f, -1.386037064e-01f, -1.384219851e-01f, -1.382401135e-01f, -1.380580919e-01f, -1.378759206e-01f, -1.376936001e-01f,
-1.375111306e-01f, -1.373285126e-01f, -1.371457464e-01f, -1.369628323e-01f, -1.367797708e-01f, -1.365965623e-01f, -1.364132070e-01f, -1.362297053e-01f, -1.360460577e-01f, -1.358622644e-01f,
-1.356783259e-01f, -1.354942425e-01f, -1.353100146e-01f, -1.351256425e-01f, -1.349411266e-01f, -1.347564673e-01f, -1.345716650e-01f, -1.343867200e-01f, -1.342016327e-01f, -1.340164034e-01f,
-1.338310325e-01f, -1.336455204e-01f, -1.334598675e-01f, -1.332740740e-01f, -1.330881405e-01f, -1.329020672e-01f, -1.327158546e-01f, -1.325295029e-01f, -1.323430126e-01f, -1.321563840e-01f,
-1.319696175e-01f, -1.317827134e-01f, -1.315956722e-01f, -1.314084942e-01f, -1.312211797e-01f, -1.310337291e-01f, -1.308461429e-01f, -1.306584213e-01f, -1.304705648e-01f, -1.302825736e-01f,
-1.300944483e-01f, -1.299061890e-01f, -1.297177963e-01f, -1.295292704e-01f, -1.293406118e-01f, -1.291518208e-01f, -1.289628978e-01f, -1.287738431e-01f, -1.285846571e-01f, -1.283953403e-01f,
-1.282058928e-01f, -1.280163152e-01f, -1.278266078e-01f, -1.276367709e-01f, -1.274468050e-01f, -1.272567103e-01f, -1.270664873e-01f, -1.268761363e-01f, -1.266856578e-01f, -1.264950520e-01f,
-1.263043193e-01f, -1.261134601e-01f, -1.259224749e-01f, -1.257313638e-01f, -1.255401274e-01f, -1.253487659e-01f, -1.251572798e-01f, -1.249656694e-01f, -1.247739351e-01f, -1.245820772e-01f,
-1.243900962e-01f, -1.241979924e-01f, -1.240057661e-01f, -1.238134177e-01f, -1.236209477e-01f, -1.234283563e-01f, -1.232356439e-01f, -1.230428110e-01f, -1.228498578e-01f, -1.226567847e-01f,
-1.224635922e-01f, -1.222702806e-01f, -1.220768502e-01f, -1.218833014e-01f, -1.216896346e-01f, -1.214958502e-01f, -1.213019485e-01f, -1.211079298e-01f, -1.209137947e-01f, -1.207195434e-01f,
-1.205251762e-01f, -1.203306937e-01f, -1.201360961e-01f, -1.199413838e-01f, -1.197465572e-01f, -1.195516166e-01f, -1.193565624e-01f, -1.191613950e-01f, -1.189661148e-01f, -1.187707221e-01f,
-1.185752173e-01f, -1.183796007e-01f, -1.181838728e-01f, -1.179880339e-01f, -1.177920844e-01f, -1.175960245e-01f, -1.173998548e-01f, -1.172035756e-01f, -1.170071872e-01f, -1.168106900e-01f,
-1.166140845e-01f, -1.164173708e-01f, -1.162205495e-01f, -1.160236209e-01f, -1.158265853e-01f, -1.156294432e-01f, -1.154321948e-01f, -1.152348407e-01f, -1.150373810e-01f, -1.148398163e-01f,
-1.146421468e-01f, -1.144443730e-01f, -1.142464952e-01f, -1.140485138e-01f, -1.138504291e-01f, -1.136522416e-01f, -1.134539515e-01f, -1.132555593e-01f, -1.130570653e-01f, -1.128584700e-01f,
-1.126597735e-01f, -1.124609765e-01f, -1.122620791e-01f, -1.120630818e-01f, -1.118639849e-01f, -1.116647888e-01f, -1.114654940e-01f, -1.112661006e-01f, -1.110666092e-01f, -1.108670201e-01f,
-1.106673336e-01f, -1.104675501e-01f, -1.102676701e-01f, -1.100676937e-01f, -1.098676216e-01f, -1.096674539e-01f, -1.094671911e-01f, -1.092668335e-01f, -1.090663815e-01f, -1.088658355e-01f,
-1.086651958e-01f, -1.084644629e-01f, -1.082636370e-01f, -1.080627186e-01f, -1.078617080e-01f, -1.076606055e-01f, -1.074594117e-01f, -1.072581267e-01f, -1.070567510e-01f, -1.068552850e-01f,
-1.066537291e-01f, -1.064520835e-01f, -1.062503486e-01f, -1.060485249e-01f, -1.058466128e-01f, -1.056446124e-01f, -1.054425243e-01f, -1.052403489e-01f, -1.050380863e-01f, -1.048357372e-01f,
-1.046333017e-01f, -1.044307803e-01f, -1.042281734e-01f, -1.040254812e-01f, -1.038227043e-01f, -1.036198429e-01f, -1.034168974e-01f, -1.032138682e-01f, -1.030107557e-01f, -1.028075601e-01f,
-1.026042820e-01f, -1.024009216e-01f, -1.021974794e-01f, -1.019939556e-01f, -1.017903507e-01f, -1.015866650e-01f, -1.013828989e-01f, -1.011790528e-01f, -1.009751270e-01f, -1.007711219e-01f,
-1.005670379e-01f, -1.003628753e-01f, -1.001586345e-01f, -9.995431581e-02f, -9.974991970e-02f, -9.954544649e-02f, -9.934089655e-02f, -9.913627025e-02f, -9.893156794e-02f, -9.872679000e-02f,
-9.852193680e-02f, -9.831700870e-02f, -9.811200607e-02f, -9.790692927e-02f, -9.770177868e-02f, -9.749655465e-02f, -9.729125757e-02f, -9.708588778e-02f, -9.688044566e-02f, -9.667493158e-02f,
-9.646934590e-02f, -9.626368899e-02f, -9.605796122e-02f, -9.585216294e-02f, -9.564629454e-02f, -9.544035636e-02f, -9.523434879e-02f, -9.502827218e-02f, -9.482212690e-02f, -9.461591333e-02f,
-9.440963181e-02f, -9.420328273e-02f, -9.399686644e-02f, -9.379038331e-02f, -9.358383371e-02f, -9.337721800e-02f, -9.317053654e-02f, -9.296378972e-02f, -9.275697788e-02f, -9.255010139e-02f,
-9.234316063e-02f, -9.213615595e-02f, -9.192908772e-02f, -9.172195630e-02f, -9.151476207e-02f, -9.130750538e-02f, -9.110018660e-02f, -9.089280610e-02f, -9.068536424e-02f, -9.047786138e-02f,
-9.027029789e-02f, -9.006267414e-02f, -8.985499049e-02f, -8.964724729e-02f, -8.943944493e-02f, -8.923158376e-02f, -8.902366414e-02f, -8.881568645e-02f, -8.860765104e-02f, -8.839955828e-02f,
-8.819140853e-02f, -8.798320216e-02f, -8.777493953e-02f, -8.756662100e-02f, -8.735824695e-02f, -8.714981772e-02f, -8.694133369e-02f, -8.673279522e-02f, -8.652420267e-02f, -8.631555641e-02f,
-8.610685680e-02f, -8.589810419e-02f, -8.568929897e-02f, -8.548044148e-02f, -8.527153210e-02f, -8.506257117e-02f, -8.485355908e-02f, -8.464449618e-02f, -8.443538282e-02f, -8.422621939e-02f,
-8.401700623e-02f, -8.380774371e-02f, -8.359843219e-02f, -8.338907204e-02f, -8.317966362e-02f, -8.297020728e-02f, -8.276070340e-02f, -8.255115233e-02f, -8.234155443e-02f, -8.213191007e-02f,
-8.192221961e-02f, -8.171248341e-02f, -8.150270183e-02f, -8.129287523e-02f, -8.108300398e-02f, -8.087308843e-02f, -8.066312895e-02f, -8.045312590e-02f, -8.024307963e-02f, -8.003299052e-02f,
-7.982285891e-02f, -7.961268518e-02f, -7.940246968e-02f, -7.919221277e-02f, -7.898191481e-02f, -7.877157617e-02f, -7.856119719e-02f, -7.835077826e-02f, -7.814031971e-02f, -7.792982192e-02f,
-7.771928525e-02f, -7.750871004e-02f, -7.729809667e-02f, -7.708744549e-02f, -7.687675687e-02f, -7.666603115e-02f, -7.645526871e-02f, -7.624446990e-02f, -7.603363507e-02f, -7.582276459e-02f,
-7.561185882e-02f, -7.540091812e-02f, -7.518994284e-02f, -7.497893334e-02f, -7.476788999e-02f, -7.455681314e-02f, -7.434570314e-02f, -7.413456036e-02f, -7.392338516e-02f, -7.371217788e-02f,
-7.350093890e-02f, -7.328966857e-02f, -7.307836724e-02f, -7.286703528e-02f, -7.265567304e-02f, -7.244428088e-02f, -7.223285915e-02f, -7.202140822e-02f, -7.180992843e-02f, -7.159842015e-02f,
-7.138688374e-02f, -7.117531955e-02f, -7.096372794e-02f, -7.075210925e-02f, -7.054046386e-02f, -7.032879212e-02f, -7.011709438e-02f, -6.990537099e-02f, -6.969362233e-02f, -6.948184873e-02f,
-6.927005056e-02f, -6.905822817e-02f, -6.884638192e-02f, -6.863451216e-02f, -6.842261925e-02f, -6.821070354e-02f, -6.799876539e-02f, -6.778680516e-02f, -6.757482319e-02f, -6.736281984e-02f,
-6.715079548e-02f, -6.693875044e-02f, -6.672668509e-02f, -6.651459978e-02f, -6.630249487e-02f, -6.609037070e-02f, -6.587822764e-02f, -6.566606603e-02f, -6.545388624e-02f, -6.524168860e-02f,
-6.502947349e-02f, -6.481724124e-02f, -6.460499221e-02f, -6.439272677e-02f, -6.418044525e-02f, -6.396814801e-02f, -6.375583541e-02f, -6.354350779e-02f, -6.333116552e-02f, -6.311880893e-02f,
-6.290643839e-02f, -6.269405424e-02f, -6.248165685e-02f, -6.226924655e-02f, -6.205682370e-02f, -6.184438866e-02f, -6.163194177e-02f, -6.141948338e-02f, -6.120701385e-02f, -6.099453353e-02f,
-6.078204277e-02f, -6.056954191e-02f, -6.035703132e-02f, -6.014451133e-02f, -5.993198231e-02f, -5.971944459e-02f, -5.950689854e-02f, -5.929434449e-02f, -5.908178281e-02f, -5.886921383e-02f,
-5.865663792e-02f, -5.844405541e-02f, -5.823146667e-02f, -5.801887203e-02f, -5.780627184e-02f, -5.759366646e-02f, -5.738105624e-02f, -5.716844151e-02f, -5.695582264e-02f, -5.674319996e-02f,
-5.653057384e-02f, -5.631794460e-02f, -5.610531261e-02f, -5.589267822e-02f, -5.568004176e-02f, -5.546740358e-02f, -5.525476404e-02f, -5.504212348e-02f, -5.482948224e-02f, -5.461684068e-02f,
-5.440419914e-02f, -5.419155797e-02f, -5.397891751e-02f, -5.376627811e-02f, -5.355364011e-02f, -5.334100387e-02f, -5.312836973e-02f, -5.291573803e-02f, -5.270310912e-02f, -5.249048334e-02f,
-5.227786104e-02f, -5.206524257e-02f, -5.185262827e-02f, -5.164001848e-02f, -5.142741356e-02f, -5.121481383e-02f, -5.100221966e-02f, -5.078963137e-02f, -5.057704932e-02f, -5.036447386e-02f,
-5.015190532e-02f, -4.993934404e-02f, -4.972679038e-02f, -4.951424467e-02f, -4.930170725e-02f, -4.908917848e-02f, -4.887665869e-02f, -4.866414823e-02f, -4.845164744e-02f, -4.823915665e-02f,
-4.802667622e-02f, -4.781420649e-02f, -4.760174779e-02f, -4.738930047e-02f, -4.717686487e-02f, -4.696444133e-02f, -4.675203019e-02f, -4.653963180e-02f, -4.632724649e-02f, -4.611487461e-02f,
-4.590251650e-02f, -4.569017249e-02f, -4.547784293e-02f, -4.526552815e-02f, -4.505322850e-02f, -4.484094432e-02f, -4.462867594e-02f, -4.441642371e-02f, -4.420418797e-02f, -4.399196905e-02f,
-4.377976729e-02f, -4.356758303e-02f, -4.335541662e-02f, -4.314326838e-02f, -4.293113866e-02f, -4.271902780e-02f, -4.250693612e-02f, -4.229486398e-02f, -4.208281171e-02f, -4.187077965e-02f,
-4.165876812e-02f, -4.144677748e-02f, -4.123480806e-02f, -4.102286019e-02f, -4.081093421e-02f, -4.059903045e-02f, -4.038714926e-02f, -4.017529097e-02f, -3.996345592e-02f, -3.975164444e-02f,
-3.953985686e-02f, -3.932809352e-02f, -3.911635477e-02f, -3.890464092e-02f, -3.869295232e-02f, -3.848128930e-02f, -3.826965220e-02f, -3.805804135e-02f, -3.784645709e-02f, -3.763489974e-02f,
-3.742336964e-02f, -3.721186713e-02f, -3.700039254e-02f, -3.678894621e-02f, -3.657752846e-02f, -3.636613962e-02f, -3.615478004e-02f, -3.594345004e-02f, -3.573214996e-02f, -3.552088013e-02f,
-3.530964088e-02f, -3.509843254e-02f, -3.488725544e-02f, -3.467610992e-02f, -3.446499630e-02f, -3.425391492e-02f, -3.404286611e-02f, -3.383185020e-02f, -3.362086752e-02f, -3.340991840e-02f,
-3.319900317e-02f, -3.298812215e-02f, -3.277727569e-02f, -3.256646411e-02f, -3.235568773e-02f, -3.214494690e-02f, -3.193424193e-02f, -3.172357315e-02f, -3.151294090e-02f, -3.130234550e-02f,
-3.109178728e-02f, -3.088126658e-02f, -3.067078370e-02f, -3.046033900e-02f, -3.024993278e-02f, -3.003956538e-02f, -2.982923713e-02f, -2.961894836e-02f, -2.940869938e-02f, -2.919849053e-02f,
-2.898832213e-02f, -2.877819451e-02f, -2.856810799e-02f, -2.835806291e-02f, -2.814805958e-02f, -2.793809833e-02f, -2.772817949e-02f, -2.751830338e-02f, -2.730847033e-02f, -2.709868065e-02f,
-2.688893469e-02f, -2.667923275e-02f, -2.646957516e-02f, -2.625996225e-02f, -2.605039434e-02f, -2.584087176e-02f, -2.563139482e-02f, -2.542196385e-02f, -2.521257917e-02f, -2.500324111e-02f,
-2.479394998e-02f, -2.458470612e-02f, -2.437550984e-02f, -2.416636146e-02f, -2.395726130e-02f, -2.374820969e-02f, -2.353920695e-02f, -2.333025339e-02f, -2.312134935e-02f, -2.291249513e-02f,
-2.270369106e-02f, -2.249493746e-02f, -2.228623465e-02f, -2.207758295e-02f, -2.186898268e-02f, -2.166043416e-02f, -2.145193770e-02f, -2.124349363e-02f, -2.103510226e-02f, -2.082676392e-02f,
-2.061847892e-02f, -2.041024757e-02f, -2.020207020e-02f, -1.999394713e-02f, -1.978587867e-02f, -1.957786513e-02f, -1.936990685e-02f, -1.916200412e-02f, -1.895415727e-02f, -1.874636662e-02f,
-1.853863248e-02f, -1.833095517e-02f, -1.812333500e-02f, -1.791577229e-02f, -1.770826735e-02f, -1.750082050e-02f, -1.729343205e-02f, -1.708610232e-02f, -1.687883162e-02f, -1.667162027e-02f,
-1.646446858e-02f, -1.625737686e-02f, -1.605034543e-02f, -1.584337460e-02f, -1.563646468e-02f, -1.542961599e-02f, -1.522282884e-02f, -1.501610354e-02f, -1.480944040e-02f, -1.460283974e-02f,
-1.439630187e-02f, -1.418982709e-02f, -1.398341573e-02f, -1.377706808e-02f, -1.357078447e-02f, -1.336456520e-02f, -1.315841058e-02f, -1.295232093e-02f, -1.274629654e-02f, -1.254033775e-02f,
-1.233444484e-02f, -1.212861813e-02f, -1.192285794e-02f, -1.171716456e-02f, -1.151153831e-02f, -1.130597950e-02f, -1.110048843e-02f, -1.089506541e-02f, -1.068971075e-02f, -1.048442476e-02f,
-1.027920775e-02f, -1.007406001e-02f, -9.868981867e-03f, -9.663973615e-03f, -9.459035564e-03f, -9.254168019e-03f, -9.049371287e-03f, -8.844645674e-03f, -8.639991484e-03f, -8.435409022e-03f,
-8.230898595e-03f, -8.026460505e-03f, -7.822095059e-03f, -7.617802559e-03f, -7.413583310e-03f, -7.209437616e-03f, -7.005365780e-03f, -6.801368105e-03f, -6.597444894e-03f, -6.393596451e-03f,
-6.189823077e-03f, -5.986125075e-03f, -5.782502747e-03f, -5.578956395e-03f, -5.375486321e-03f, -5.172092825e-03f, -4.968776209e-03f, -4.765536774e-03f, -4.562374821e-03f, -4.359290649e-03f,
-4.156284560e-03f, -3.953356852e-03f, -3.750507827e-03f, -3.547737782e-03f, -3.345047017e-03f, -3.142435832e-03f, -2.939904524e-03f, -2.737453394e-03f, -2.535082737e-03f, -2.332792854e-03f,
-2.130584040e-03f, -1.928456595e-03f, -1.726410815e-03f, -1.524446997e-03f, -1.322565438e-03f, -1.120766434e-03f, -9.190502822e-04f, -7.174172781e-04f, -5.158677175e-04f, -3.144018961e-04f,
-1.130201090e-04f, 8.827734866e-05f, 2.894901821e-04f, 4.906180967e-04f, 6.916607982e-04f, 8.926179926e-04f, 1.093489386e-03f, 1.294274685e-03f, 1.494973596e-03f, 1.695585826e-03f,
1.896111083e-03f, 2.096549073e-03f, 2.296899505e-03f, 2.497162086e-03f, 2.697336525e-03f, 2.897422530e-03f, 3.097419810e-03f, 3.297328073e-03f, 3.497147029e-03f, 3.696876388e-03f,
3.896515859e-03f, 4.096065151e-03f, 4.295523976e-03f, 4.494892044e-03f, 4.694169066e-03f, 4.893354751e-03f, 5.092448813e-03f, 5.291450961e-03f, 5.490360909e-03f, 5.689178368e-03f,
5.887903049e-03f, 6.086534667e-03f, 6.285072933e-03f, 6.483517561e-03f, 6.681868263e-03f, 6.880124754e-03f, 7.078286747e-03f, 7.276353957e-03f, 7.474326097e-03f, 7.672202883e-03f,
7.869984028e-03f, 8.067669249e-03f, 8.265258260e-03f, 8.462750778e-03f, 8.660146518e-03f, 8.857445196e-03f, 9.054646528e-03f, 9.251750232e-03f, 9.448756025e-03f, 9.645663623e-03f,
9.842472744e-03f, 1.003918311e-02f, 1.023579443e-02f, 1.043230642e-02f, 1.062871882e-02f, 1.082503132e-02f, 1.102124366e-02f, 1.121735556e-02f, 1.141336672e-02f, 1.160927688e-02f,
1.180508575e-02f, 1.200079305e-02f, 1.219639851e-02f, 1.239190184e-02f, 1.258730277e-02f, 1.278260101e-02f, 1.297779629e-02f, 1.317288833e-02f, 1.336787686e-02f, 1.356276159e-02f,
1.375754225e-02f, 1.395221856e-02f, 1.414679024e-02f, 1.434125703e-02f, 1.453561863e-02f, 1.472987478e-02f, 1.492402521e-02f, 1.511806962e-02f, 1.531200776e-02f, 1.550583935e-02f,
1.569956410e-02f, 1.589318175e-02f, 1.608669203e-02f, 1.628009465e-02f, 1.647338936e-02f, 1.666657586e-02f, 1.685965389e-02f, 1.705262318e-02f, 1.724548346e-02f, 1.743823445e-02f,
1.763087588e-02f, 1.782340748e-02f, 1.801582898e-02f, 1.820814011e-02f, 1.840034060e-02f, 1.859243017e-02f, 1.878440856e-02f, 1.897627550e-02f, 1.916803071e-02f, 1.935967393e-02f,
1.955120490e-02f, 1.974262333e-02f, 1.993392896e-02f, 2.012512153e-02f, 2.031620077e-02f, 2.050716640e-02f, 2.069801817e-02f, 2.088875580e-02f, 2.107937903e-02f, 2.126988759e-02f,
2.146028121e-02f, 2.165055964e-02f, 2.184072259e-02f, 2.203076982e-02f, 2.222070105e-02f, 2.241051602e-02f, 2.260021446e-02f, 2.278979611e-02f, 2.297926071e-02f, 2.316860799e-02f,
2.335783769e-02f, 2.354694955e-02f, 2.373594330e-02f, 2.392481868e-02f, 2.411357543e-02f, 2.430221329e-02f, 2.449073199e-02f, 2.467913128e-02f, 2.486741089e-02f, 2.505557056e-02f,
2.524361003e-02f, 2.543152904e-02f, 2.561932734e-02f, 2.580700466e-02f, 2.599456074e-02f, 2.618199533e-02f, 2.636930816e-02f, 2.655649897e-02f, 2.674356752e-02f, 2.693051353e-02f,
2.711733676e-02f, 2.730403695e-02f, 2.749061383e-02f, 2.767706715e-02f, 2.786339667e-02f, 2.804960211e-02f, 2.823568322e-02f, 2.842163975e-02f, 2.860747145e-02f, 2.879317805e-02f,
2.897875931e-02f, 2.916421497e-02f, 2.934954477e-02f, 2.953474846e-02f, 2.971982579e-02f, 2.990477651e-02f, 3.008960035e-02f, 3.027429708e-02f, 3.045886643e-02f, 3.064330816e-02f,
3.082762201e-02f, 3.101180773e-02f, 3.119586507e-02f, 3.137979379e-02f, 3.156359362e-02f, 3.174726432e-02f, 3.193080564e-02f, 3.211421733e-02f, 3.229749914e-02f, 3.248065082e-02f,
3.266367213e-02f, 3.284656280e-02f, 3.302932261e-02f, 3.321195129e-02f, 3.339444860e-02f, 3.357681430e-02f, 3.375904813e-02f, 3.394114985e-02f, 3.412311922e-02f, 3.430495598e-02f,
3.448665989e-02f, 3.466823072e-02f, 3.484966820e-02f, 3.503097210e-02f, 3.521214217e-02f, 3.539317816e-02f, 3.557407985e-02f, 3.575484697e-02f, 3.593547929e-02f, 3.611597656e-02f,
3.629633854e-02f, 3.647656499e-02f, 3.665665567e-02f, 3.683661033e-02f, 3.701642874e-02f, 3.719611065e-02f, 3.737565582e-02f, 3.755506401e-02f, 3.773433498e-02f, 3.791346849e-02f,
3.809246431e-02f, 3.827132218e-02f, 3.845004188e-02f, 3.862862316e-02f, 3.880706578e-02f, 3.898536951e-02f, 3.916353412e-02f, 3.934155935e-02f, 3.951944498e-02f, 3.969719076e-02f,
3.987479647e-02f, 4.005226186e-02f, 4.022958671e-02f, 4.040677076e-02f, 4.058381379e-02f, 4.076071557e-02f, 4.093747585e-02f, 4.111409441e-02f, 4.129057101e-02f, 4.146690542e-02f,
4.164309739e-02f, 4.181914671e-02f, 4.199505313e-02f, 4.217081643e-02f, 4.234643637e-02f, 4.252191272e-02f, 4.269724524e-02f, 4.287243372e-02f, 4.304747791e-02f, 4.322237758e-02f,
4.339713251e-02f, 4.357174247e-02f, 4.374620722e-02f, 4.392052653e-02f, 4.409470019e-02f, 4.426872795e-02f, 4.444260959e-02f, 4.461634488e-02f, 4.478993360e-02f, 4.496337551e-02f,
4.513667039e-02f, 4.530981801e-02f, 4.548281815e-02f, 4.565567058e-02f, 4.582837507e-02f, 4.600093140e-02f, 4.617333934e-02f, 4.634559867e-02f, 4.651770916e-02f, 4.668967059e-02f,
4.686148273e-02f, 4.703314536e-02f, 4.720465827e-02f, 4.737602121e-02f, 4.754723398e-02f, 4.771829634e-02f, 4.788920809e-02f, 4.805996898e-02f, 4.823057882e-02f, 4.840103736e-02f,
4.857134439e-02f, 4.874149970e-02f, 4.891150306e-02f, 4.908135425e-02f, 4.925105305e-02f, 4.942059924e-02f, 4.958999261e-02f, 4.975923293e-02f, 4.992831998e-02f, 5.009725356e-02f,
5.026603343e-02f, 5.043465939e-02f, 5.060313122e-02f, 5.077144870e-02f, 5.093961161e-02f, 5.110761974e-02f, 5.127547287e-02f, 5.144317078e-02f, 5.161071327e-02f, 5.177810012e-02f,
5.194533111e-02f, 5.211240602e-02f, 5.227932466e-02f, 5.244608679e-02f, 5.261269221e-02f, 5.277914071e-02f, 5.294543207e-02f, 5.311156608e-02f, 5.327754253e-02f, 5.344336121e-02f,
5.360902190e-02f, 5.377452440e-02f, 5.393986850e-02f, 5.410505398e-02f, 5.427008064e-02f, 5.443494826e-02f, 5.459965664e-02f, 5.476420557e-02f, 5.492859484e-02f, 5.509282424e-02f,
5.525689356e-02f, 5.542080260e-02f, 5.558455114e-02f, 5.574813899e-02f, 5.591156594e-02f, 5.607483177e-02f, 5.623793629e-02f, 5.640087928e-02f, 5.656366055e-02f, 5.672627989e-02f,
5.688873708e-02f, 5.705103194e-02f, 5.721316425e-02f, 5.737513382e-02f, 5.753694043e-02f, 5.769858389e-02f, 5.786006399e-02f, 5.802138053e-02f, 5.818253331e-02f, 5.834352213e-02f,
5.850434678e-02f, 5.866500707e-02f, 5.882550279e-02f, 5.898583375e-02f, 5.914599974e-02f, 5.930600057e-02f, 5.946583603e-02f, 5.962550593e-02f, 5.978501007e-02f, 5.994434824e-02f,
6.010352026e-02f, 6.026252593e-02f, 6.042136504e-02f, 6.058003740e-02f, 6.073854281e-02f, 6.089688109e-02f, 6.105505202e-02f, 6.121305542e-02f, 6.137089109e-02f, 6.152855884e-02f,
6.168605847e-02f, 6.184338979e-02f, 6.200055260e-02f, 6.215754671e-02f, 6.231437192e-02f, 6.247102806e-02f, 6.262751491e-02f, 6.278383229e-02f, 6.293998001e-02f, 6.309595787e-02f,
6.325176569e-02f, 6.340740328e-02f, 6.356287043e-02f, 6.371816697e-02f, 6.387329271e-02f, 6.402824745e-02f, 6.418303100e-02f, 6.433764318e-02f, 6.449208380e-02f, 6.464635266e-02f,
6.480044959e-02f, 6.495437439e-02f, 6.510812688e-02f, 6.526170687e-02f, 6.541511417e-02f, 6.556834861e-02f, 6.572140998e-02f, 6.587429811e-02f, 6.602701281e-02f, 6.617955391e-02f,
6.633192120e-02f, 6.648411451e-02f, 6.663613366e-02f, 6.678797845e-02f, 6.693964872e-02f, 6.709114427e-02f, 6.724246493e-02f, 6.739361051e-02f, 6.754458083e-02f, 6.769537570e-02f,
6.784599496e-02f, 6.799643841e-02f, 6.814670588e-02f, 6.829679719e-02f, 6.844671215e-02f, 6.859645060e-02f, 6.874601234e-02f, 6.889539720e-02f, 6.904460501e-02f, 6.919363558e-02f,
6.934248873e-02f, 6.949116430e-02f, 6.963966210e-02f, 6.978798196e-02f, 6.993612370e-02f, 7.008408714e-02f, 7.023187212e-02f, 7.037947844e-02f, 7.052690595e-02f, 7.067415446e-02f,
7.082122381e-02f, 7.096811381e-02f, 7.111482429e-02f, 7.126135509e-02f, 7.140770603e-02f, 7.155387693e-02f, 7.169986762e-02f, 7.184567794e-02f, 7.199130771e-02f, 7.213675676e-02f,
7.228202492e-02f, 7.242711202e-02f, 7.257201789e-02f, 7.271674236e-02f, 7.286128526e-02f, 7.300564642e-02f, 7.314982568e-02f, 7.329382286e-02f, 7.343763780e-02f, 7.358127033e-02f,
7.372472028e-02f, 7.386798749e-02f, 7.401107178e-02f, 7.415397301e-02f, 7.429669099e-02f, 7.443922556e-02f, 7.458157656e-02f, 7.472374382e-02f, 7.486572719e-02f, 7.500752648e-02f,
7.514914155e-02f, 7.529057223e-02f, 7.543181835e-02f, 7.557287975e-02f, 7.571375628e-02f, 7.585444776e-02f, 7.599495404e-02f, 7.613527496e-02f, 7.627541035e-02f, 7.641536005e-02f,
7.655512391e-02f, 7.669470177e-02f, 7.683409346e-02f, 7.697329882e-02f, 7.711231771e-02f, 7.725114995e-02f, 7.738979539e-02f, 7.752825388e-02f, 7.766652526e-02f, 7.780460936e-02f,
7.794250604e-02f, 7.808021513e-02f, 7.821773648e-02f, 7.835506994e-02f, 7.849221535e-02f, 7.862917255e-02f, 7.876594140e-02f, 7.890252173e-02f, 7.903891339e-02f, 7.917511624e-02f,
7.931113011e-02f, 7.944695485e-02f, 7.958259032e-02f, 7.971803635e-02f, 7.985329281e-02f, 7.998835952e-02f, 8.012323636e-02f, 8.025792316e-02f, 8.039241977e-02f, 8.052672605e-02f,
8.066084185e-02f, 8.079476701e-02f, 8.092850139e-02f, 8.106204484e-02f, 8.119539721e-02f, 8.132855835e-02f, 8.146152812e-02f, 8.159430636e-02f, 8.172689294e-02f, 8.185928771e-02f,
8.199149051e-02f, 8.212350121e-02f, 8.225531966e-02f, 8.238694571e-02f, 8.251837923e-02f, 8.264962006e-02f, 8.278066806e-02f, 8.291152308e-02f, 8.304218500e-02f, 8.317265365e-02f,
8.330292891e-02f, 8.343301063e-02f, 8.356289866e-02f, 8.369259286e-02f, 8.382209310e-02f, 8.395139924e-02f, 8.408051112e-02f, 8.420942862e-02f, 8.433815160e-02f, 8.446667991e-02f,
8.459501341e-02f, 8.472315198e-02f, 8.485109546e-02f, 8.497884372e-02f, 8.510639663e-02f, 8.523375404e-02f, 8.536091583e-02f, 8.548788185e-02f, 8.561465197e-02f, 8.574122605e-02f,
8.586760396e-02f, 8.599378556e-02f, 8.611977072e-02f, 8.624555931e-02f, 8.637115118e-02f, 8.649654621e-02f, 8.662174427e-02f, 8.674674521e-02f, 8.687154892e-02f, 8.699615525e-02f,
8.712056407e-02f, 8.724477526e-02f, 8.736878869e-02f, 8.749260421e-02f, 8.761622171e-02f, 8.773964105e-02f, 8.786286210e-02f, 8.798588474e-02f, 8.810870883e-02f, 8.823133425e-02f,
8.835376087e-02f, 8.847598856e-02f, 8.859801719e-02f, 8.871984664e-02f, 8.884147677e-02f, 8.896290748e-02f, 8.908413862e-02f, 8.920517007e-02f, 8.932600171e-02f, 8.944663341e-02f,
8.956706505e-02f, 8.968729651e-02f, 8.980732765e-02f, 8.992715836e-02f, 9.004678852e-02f, 9.016621800e-02f, 9.028544667e-02f, 9.040447443e-02f, 9.052330114e-02f, 9.064192668e-02f,
9.076035094e-02f, 9.087857379e-02f, 9.099659512e-02f, 9.111441480e-02f, 9.123203271e-02f, 9.134944874e-02f, 9.146666276e-02f, 9.158367466e-02f, 9.170048433e-02f, 9.181709163e-02f,
9.193349646e-02f, 9.204969870e-02f, 9.216569824e-02f, 9.228149494e-02f, 9.239708871e-02f, 9.251247943e-02f, 9.262766697e-02f, 9.274265123e-02f, 9.285743209e-02f, 9.297200944e-02f,
9.308638316e-02f, 9.320055315e-02f, 9.331451928e-02f, 9.342828144e-02f, 9.354183953e-02f, 9.365519343e-02f, 9.376834303e-02f, 9.388128822e-02f, 9.399402889e-02f, 9.410656493e-02f,
9.421889622e-02f, 9.433102266e-02f, 9.444294414e-02f, 9.455466056e-02f, 9.466617179e-02f, 9.477747774e-02f, 9.488857830e-02f, 9.499947335e-02f, 9.511016279e-02f, 9.522064652e-02f,
9.533092443e-02f, 9.544099642e-02f, 9.555086237e-02f, 9.566052218e-02f, 9.576997575e-02f, 9.587922297e-02f, 9.598826374e-02f, 9.609709796e-02f, 9.620572552e-02f, 9.631414631e-02f,
9.642236025e-02f, 9.653036721e-02f, 9.663816711e-02f, 9.674575984e-02f, 9.685314530e-02f, 9.696032339e-02f, 9.706729400e-02f, 9.717405704e-02f, 9.728061241e-02f, 9.738696001e-02f,
9.749309974e-02f, 9.759903150e-02f, 9.770475519e-02f, 9.781027072e-02f, 9.791557798e-02f, 9.802067689e-02f, 9.812556734e-02f, 9.823024923e-02f, 9.833472248e-02f, 9.843898698e-02f,
9.854304264e-02f, 9.864688936e-02f, 9.875052706e-02f, 9.885395563e-02f, 9.895717498e-02f, 9.906018503e-02f, 9.916298566e-02f, 9.926557680e-02f, 9.936795835e-02f, 9.947013022e-02f,
9.957209232e-02f, 9.967384455e-02f, 9.977538682e-02f, 9.987671905e-02f, 9.997784114e-02f, 1.000787530e-01f, 1.001794545e-01f, 1.002799457e-01f, 1.003802263e-01f, 1.004802964e-01f,
1.005801558e-01f, 1.006798044e-01f, 1.007792422e-01f, 1.008784691e-01f, 1.009774849e-01f, 1.010762897e-01f, 1.011748832e-01f, 1.012732655e-01f, 1.013714364e-01f, 1.014693958e-01f,
1.015671438e-01f, 1.016646801e-01f, 1.017620047e-01f, 1.018591175e-01f, 1.019560185e-01f, 1.020527075e-01f, 1.021491845e-01f, 1.022454494e-01f, 1.023415021e-01f, 1.024373425e-01f,
1.025329705e-01f, 1.026283862e-01f, 1.027235893e-01f, 1.028185798e-01f, 1.029133576e-01f, 1.030079227e-01f, 1.031022750e-01f, 1.031964143e-01f, 1.032903407e-01f, 1.033840540e-01f,
1.034775541e-01f, 1.035708411e-01f, 1.036639147e-01f, 1.037567750e-01f, 1.038494218e-01f, 1.039418551e-01f, 1.040340748e-01f, 1.041260808e-01f, 1.042178731e-01f, 1.043094516e-01f,
1.044008162e-01f, 1.044919668e-01f, 1.045829033e-01f, 1.046736258e-01f, 1.047641341e-01f, 1.048544281e-01f, 1.049445078e-01f, 1.050343731e-01f, 1.051240240e-01f, 1.052134603e-01f,
1.053026819e-01f, 1.053916890e-01f, 1.054804812e-01f, 1.055690587e-01f, 1.056574213e-01f, 1.057455689e-01f, 1.058335015e-01f, 1.059212190e-01f, 1.060087214e-01f, 1.060960086e-01f,
1.061830804e-01f, 1.062699370e-01f, 1.063565781e-01f, 1.064430037e-01f, 1.065292138e-01f, 1.066152083e-01f, 1.067009871e-01f, 1.067865501e-01f, 1.068718974e-01f, 1.069570288e-01f,
1.070419443e-01f, 1.071266438e-01f, 1.072111272e-01f, 1.072953945e-01f, 1.073794457e-01f, 1.074632806e-01f, 1.075468993e-01f, 1.076303016e-01f, 1.077134874e-01f, 1.077964568e-01f,
1.078792097e-01f, 1.079617460e-01f, 1.080440656e-01f, 1.081261686e-01f, 1.082080548e-01f, 1.082897241e-01f, 1.083711766e-01f, 1.084524121e-01f, 1.085334307e-01f, 1.086142322e-01f,
1.086948167e-01f, 1.087751839e-01f, 1.088553340e-01f, 1.089352668e-01f, 1.090149823e-01f, 1.090944804e-01f, 1.091737611e-01f, 1.092528244e-01f, 1.093316701e-01f, 1.094102982e-01f,
1.094887087e-01f, 1.095669015e-01f, 1.096448766e-01f, 1.097226339e-01f, 1.098001734e-01f, 1.098774950e-01f, 1.099545987e-01f, 1.100314844e-01f, 1.101081520e-01f, 1.101846016e-01f,
1.102608331e-01f, 1.103368464e-01f, 1.104126415e-01f, 1.104882183e-01f, 1.105635768e-01f, 1.106387169e-01f, 1.107136386e-01f, 1.107883419e-01f, 1.108628267e-01f, 1.109370930e-01f,
1.110111406e-01f, 1.110849697e-01f, 1.111585801e-01f, 1.112319717e-01f, 1.113051446e-01f, 1.113780987e-01f, 1.114508340e-01f, 1.115233504e-01f, 1.115956479e-01f, 1.116677264e-01f,
1.117395859e-01f, 1.118112263e-01f, 1.118826477e-01f, 1.119538499e-01f, 1.120248330e-01f, 1.120955969e-01f, 1.121661415e-01f, 1.122364669e-01f, 1.123065729e-01f, 1.123764596e-01f,
1.124461269e-01f, 1.125155748e-01f, 1.125848032e-01f, 1.126538121e-01f, 1.127226015e-01f, 1.127911713e-01f, 1.128595215e-01f, 1.129276520e-01f, 1.129955629e-01f, 1.130632541e-01f,
1.131307256e-01f, 1.131979772e-01f, 1.132650091e-01f, 1.133318211e-01f, 1.133984133e-01f, 1.134647855e-01f, 1.135309378e-01f, 1.135968702e-01f, 1.136625826e-01f, 1.137280749e-01f,
1.137933472e-01f, 1.138583994e-01f, 1.139232315e-01f, 1.139878434e-01f, 1.140522352e-01f, 1.141164068e-01f, 1.141803581e-01f, 1.142440892e-01f, 1.143076001e-01f, 1.143708906e-01f,
1.144339608e-01f, 1.144968106e-01f, 1.145594401e-01f, 1.146218491e-01f, 1.146840377e-01f, 1.147460059e-01f, 1.148077536e-01f, 1.148692807e-01f, 1.149305874e-01f, 1.149916735e-01f,
1.150525390e-01f, 1.151131839e-01f, 1.151736083e-01f, 1.152338119e-01f, 1.152937949e-01f, 1.153535573e-01f, 1.154130989e-01f, 1.154724198e-01f, 1.155315200e-01f, 1.155903994e-01f,
1.156490581e-01f, 1.157074959e-01f, 1.157657129e-01f, 1.158237091e-01f, 1.158814845e-01f, 1.159390390e-01f, 1.159963726e-01f, 1.160534853e-01f, 1.161103770e-01f, 1.161670479e-01f,
1.162234978e-01f, 1.162797267e-01f, 1.163357347e-01f, 1.163915217e-01f, 1.164470876e-01f, 1.165024326e-01f, 1.165575565e-01f, 1.166124593e-01f, 1.166671412e-01f, 1.167216019e-01f,
1.167758416e-01f, 1.168298601e-01f, 1.168836576e-01f, 1.169372340e-01f, 1.169905892e-01f, 1.170437233e-01f, 1.170966362e-01f, 1.171493280e-01f, 1.172017987e-01f, 1.172540481e-01f,
1.173060764e-01f, 1.173578835e-01f, 1.174094694e-01f, 1.174608341e-01f, 1.175119776e-01f, 1.175628999e-01f, 1.176136009e-01f, 1.176640808e-01f, 1.177143394e-01f, 1.177643767e-01f,
1.178141929e-01f, 1.178637877e-01f, 1.179131614e-01f, 1.179623137e-01f, 1.180112449e-01f, 1.180599547e-01f, 1.181084433e-01f, 1.181567107e-01f, 1.182047567e-01f, 1.182525815e-01f,
1.183001851e-01f, 1.183475673e-01f, 1.183947283e-01f, 1.184416680e-01f, 1.184883865e-01f, 1.185348837e-01f, 1.185811596e-01f, 1.186272143e-01f, 1.186730477e-01f, 1.187186598e-01f,
1.187640507e-01f, 1.188092203e-01f, 1.188541686e-01f, 1.188988957e-01f, 1.189434016e-01f, 1.189876862e-01f, 1.190317496e-01f, 1.190755918e-01f, 1.191192127e-01f, 1.191626124e-01f,
1.192057909e-01f, 1.192487482e-01f, 1.192914842e-01f, 1.193339991e-01f, 1.193762928e-01f, 1.194183653e-01f, 1.194602166e-01f, 1.195018468e-01f, 1.195432558e-01f, 1.195844437e-01f,
1.196254105e-01f, 1.196661561e-01f, 1.197066806e-01f, 1.197469839e-01f, 1.197870662e-01f, 1.198269274e-01f, 1.198665676e-01f, 1.199059867e-01f, 1.199451847e-01f, 1.199841617e-01f,
1.200229176e-01f, 1.200614526e-01f, 1.200997666e-01f, 1.201378595e-01f, 1.201757316e-01f, 1.202133826e-01f, 1.202508128e-01f, 1.202880220e-01f, 1.203250103e-01f, 1.203617777e-01f,
1.203983242e-01f, 1.204346499e-01f, 1.204707547e-01f, 1.205066387e-01f, 1.205423019e-01f, 1.205777444e-01f, 1.206129660e-01f, 1.206479669e-01f, 1.206827471e-01f, 1.207173066e-01f,
1.207516454e-01f, 1.207857635e-01f, 1.208196610e-01f, 1.208533378e-01f, 1.208867940e-01f, 1.209200297e-01f, 1.209530448e-01f, 1.209858393e-01f, 1.210184133e-01f, 1.210507669e-01f,
1.210828999e-01f, 1.211148125e-01f, 1.211465047e-01f, 1.211779765e-01f, 1.212092279e-01f, 1.212402590e-01f, 1.212710698e-01f, 1.213016602e-01f, 1.213320304e-01f, 1.213621803e-01f,
1.213921100e-01f, 1.214218195e-01f, 1.214513089e-01f, 1.214805781e-01f, 1.215096272e-01f, 1.215384563e-01f, 1.215670653e-01f, 1.215954542e-01f, 1.216236232e-01f, 1.216515722e-01f,
1.216793013e-01f, 1.217068105e-01f, 1.217340998e-01f, 1.217611693e-01f, 1.217880190e-01f, 1.218146489e-01f, 1.218410590e-01f, 1.218672495e-01f, 1.218932202e-01f, 1.219189714e-01f,
1.219445029e-01f, 1.219698148e-01f, 1.219949072e-01f, 1.220197801e-01f, 1.220444336e-01f, 1.220688676e-01f, 1.220930822e-01f, 1.221170774e-01f, 1.221408533e-01f, 1.221644099e-01f,
1.221877473e-01f, 1.222108654e-01f, 1.222337644e-01f, 1.222564442e-01f, 1.222789049e-01f, 1.223011466e-01f, 1.223231692e-01f, 1.223449729e-01f, 1.223665576e-01f, 1.223879234e-01f,
1.224090703e-01f, 1.224299984e-01f, 1.224507078e-01f, 1.224711984e-01f, 1.224914703e-01f, 1.225115235e-01f, 1.225313581e-01f, 1.225509742e-01f, 1.225703717e-01f, 1.225895508e-01f,
1.226085114e-01f, 1.226272536e-01f, 1.226457774e-01f, 1.226640830e-01f, 1.226821703e-01f, 1.227000394e-01f, 1.227176903e-01f, 1.227351230e-01f, 1.227523377e-01f, 1.227693344e-01f,
1.227861131e-01f, 1.228026739e-01f, 1.228190167e-01f, 1.228351418e-01f, 1.228510490e-01f, 1.228667385e-01f, 1.228822103e-01f, 1.228974644e-01f, 1.229125010e-01f, 1.229273200e-01f,
1.229419215e-01f, 1.229563056e-01f, 1.229704723e-01f, 1.229844217e-01f, 1.229981537e-01f, 1.230116686e-01f, 1.230249662e-01f, 1.230380467e-01f, 1.230509102e-01f, 1.230635566e-01f,
1.230759860e-01f, 1.230881986e-01f, 1.231001942e-01f, 1.231119731e-01f, 1.231235352e-01f, 1.231348807e-01f, 1.231460094e-01f, 1.231569216e-01f, 1.231676173e-01f, 1.231780965e-01f,
1.231883593e-01f, 1.231984057e-01f, 1.232082359e-01f, 1.232178498e-01f, 1.232272475e-01f, 1.232364291e-01f, 1.232453946e-01f, 1.232541442e-01f, 1.232626777e-01f, 1.232709954e-01f,
1.232790973e-01f, 1.232869834e-01f, 1.232946539e-01f, 1.233021086e-01f, 1.233093478e-01f, 1.233163715e-01f, 1.233231797e-01f, 1.233297726e-01f, 1.233361501e-01f, 1.233423123e-01f,
1.233482594e-01f, 1.233539913e-01f, 1.233595081e-01f, 1.233648099e-01f, 1.233698968e-01f, 1.233747688e-01f, 1.233794260e-01f, 1.233838685e-01f, 1.233880962e-01f, 1.233921094e-01f,
1.233959080e-01f, 1.233994921e-01f, 1.234028618e-01f, 1.234060172e-01f, 1.234089583e-01f, 1.234116852e-01f, 1.234141979e-01f, 1.234164966e-01f, 1.234185813e-01f, 1.234204521e-01f,
1.234221090e-01f, 1.234235521e-01f, 1.234247815e-01f, 1.234257972e-01f, 1.234265994e-01f, 1.234271880e-01f, 1.234275633e-01f, 1.234277251e-01f, 1.234276737e-01f, 1.234274091e-01f,
1.234269313e-01f, 1.234262405e-01f, 1.234253367e-01f, 1.234242199e-01f, 1.234228903e-01f, 1.234213480e-01f, 1.234195929e-01f, 1.234176252e-01f, 1.234154450e-01f, 1.234130523e-01f,
1.234104473e-01f, 1.234076299e-01f, 1.234046003e-01f, 1.234013585e-01f, 1.233979046e-01f, 1.233942388e-01f, 1.233903610e-01f, 1.233862714e-01f, 1.233819700e-01f, 1.233774569e-01f,
1.233727322e-01f, 1.233677960e-01f, 1.233626483e-01f, 1.233572893e-01f, 1.233517190e-01f, 1.233459375e-01f, 1.233399448e-01f, 1.233337412e-01f, 1.233273265e-01f, 1.233207010e-01f,
1.233138647e-01f, 1.233068177e-01f, 1.232995600e-01f, 1.232920919e-01f, 1.232844132e-01f, 1.232765242e-01f, 1.232684249e-01f, 1.232601154e-01f, 1.232515957e-01f, 1.232428661e-01f,
1.232339265e-01f, 1.232247770e-01f, 1.232154177e-01f, 1.232058488e-01f, 1.231960702e-01f, 1.231860822e-01f, 1.231758847e-01f, 1.231654779e-01f, 1.231548618e-01f, 1.231440366e-01f,
1.231330023e-01f, 1.231217590e-01f, 1.231103068e-01f, 1.230986459e-01f, 1.230867762e-01f, 1.230746979e-01f, 1.230624110e-01f, 1.230499157e-01f, 1.230372121e-01f, 1.230243002e-01f,
1.230111801e-01f, 1.229978520e-01f, 1.229843159e-01f, 1.229705719e-01f, 1.229566201e-01f, 1.229424606e-01f, 1.229280935e-01f, 1.229135189e-01f, 1.228987369e-01f, 1.228837476e-01f,
1.228685510e-01f, 1.228531473e-01f, 1.228375366e-01f, 1.228217189e-01f, 1.228056943e-01f, 1.227894631e-01f, 1.227730251e-01f, 1.227563807e-01f, 1.227395297e-01f, 1.227224724e-01f,
1.227052089e-01f, 1.226877392e-01f, 1.226700634e-01f, 1.226521817e-01f, 1.226340941e-01f, 1.226158007e-01f, 1.225973017e-01f, 1.225785971e-01f, 1.225596870e-01f, 1.225405716e-01f,
1.225212509e-01f, 1.225017251e-01f, 1.224819941e-01f, 1.224620583e-01f, 1.224419176e-01f, 1.224215721e-01f, 1.224010220e-01f, 1.223802673e-01f, 1.223593082e-01f, 1.223381448e-01f,
1.223167771e-01f, 1.222952053e-01f, 1.222734295e-01f, 1.222514497e-01f, 1.222292661e-01f, 1.222068788e-01f, 1.221842880e-01f, 1.221614936e-01f, 1.221384958e-01f, 1.221152948e-01f,
1.220918905e-01f, 1.220682832e-01f, 1.220444730e-01f, 1.220204598e-01f, 1.219962440e-01f, 1.219718255e-01f, 1.219472044e-01f, 1.219223810e-01f, 1.218973552e-01f, 1.218721272e-01f,
1.218466972e-01f, 1.218210651e-01f, 1.217952312e-01f, 1.217691956e-01f, 1.217429583e-01f, 1.217165194e-01f, 1.216898791e-01f, 1.216630375e-01f, 1.216359947e-01f, 1.216087509e-01f,
1.215813060e-01f, 1.215536603e-01f, 1.215258138e-01f, 1.214977667e-01f, 1.214695191e-01f, 1.214410711e-01f, 1.214124227e-01f, 1.213835742e-01f, 1.213545257e-01f, 1.213252772e-01f,
1.212958288e-01f, 1.212661808e-01f, 1.212363331e-01f, 1.212062860e-01f, 1.211760395e-01f, 1.211455937e-01f, 1.211149488e-01f, 1.210841049e-01f, 1.210530622e-01f, 1.210218206e-01f,
1.209903804e-01f, 1.209587416e-01f, 1.209269044e-01f, 1.208948689e-01f, 1.208626352e-01f, 1.208302035e-01f, 1.207975738e-01f, 1.207647463e-01f, 1.207317211e-01f, 1.206984984e-01f,
1.206650781e-01f, 1.206314606e-01f, 1.205976458e-01f, 1.205636339e-01f, 1.205294251e-01f, 1.204950194e-01f, 1.204604170e-01f, 1.204256179e-01f, 1.203906225e-01f, 1.203554306e-01f,
1.203200425e-01f, 1.202844584e-01f, 1.202486782e-01f, 1.202127022e-01f, 1.201765305e-01f, 1.201401631e-01f, 1.201036003e-01f, 1.200668421e-01f, 1.200298887e-01f, 1.199927402e-01f,
1.199553968e-01f, 1.199178584e-01f, 1.198801254e-01f, 1.198421978e-01f, 1.198040757e-01f, 1.197657593e-01f, 1.197272487e-01f, 1.196885440e-01f, 1.196496453e-01f, 1.196105529e-01f,
1.195712667e-01f, 1.195317870e-01f, 1.194921139e-01f, 1.194522474e-01f, 1.194121878e-01f, 1.193719352e-01f, 1.193314897e-01f, 1.192908513e-01f, 1.192500204e-01f, 1.192089969e-01f,
1.191677811e-01f, 1.191263730e-01f, 1.190847728e-01f, 1.190429806e-01f, 1.190009966e-01f, 1.189588209e-01f, 1.189164536e-01f, 1.188738948e-01f, 1.188311448e-01f, 1.187882035e-01f,
1.187450713e-01f, 1.187017481e-01f, 1.186582342e-01f, 1.186145296e-01f, 1.185706345e-01f, 1.185265491e-01f, 1.184822734e-01f, 1.184378077e-01f, 1.183931520e-01f, 1.183483065e-01f,
1.183032714e-01f, 1.182580466e-01f, 1.182126325e-01f, 1.181670292e-01f, 1.181212367e-01f, 1.180752552e-01f, 1.180290849e-01f, 1.179827259e-01f, 1.179361783e-01f, 1.178894423e-01f,
1.178425181e-01f, 1.177954056e-01f, 1.177481052e-01f, 1.177006169e-01f, 1.176529409e-01f, 1.176050773e-01f, 1.175570263e-01f, 1.175087880e-01f, 1.174603625e-01f, 1.174117501e-01f,
1.173629507e-01f, 1.173139647e-01f, 1.172647920e-01f, 1.172154329e-01f, 1.171658876e-01f, 1.171161561e-01f, 1.170662385e-01f, 1.170161352e-01f, 1.169658461e-01f, 1.169153714e-01f,
1.168647113e-01f, 1.168138659e-01f, 1.167628355e-01f, 1.167116200e-01f, 1.166602197e-01f, 1.166086346e-01f, 1.165568651e-01f, 1.165049111e-01f, 1.164527729e-01f, 1.164004506e-01f,
1.163479443e-01f, 1.162952543e-01f, 1.162423805e-01f, 1.161893233e-01f, 1.161360827e-01f, 1.160826589e-01f, 1.160290520e-01f, 1.159752622e-01f, 1.159212896e-01f, 1.158671345e-01f,
1.158127968e-01f, 1.157582769e-01f, 1.157035748e-01f, 1.156486907e-01f, 1.155936247e-01f, 1.155383770e-01f, 1.154829478e-01f, 1.154273372e-01f, 1.153715453e-01f, 1.153155723e-01f,
1.152594184e-01f, 1.152030837e-01f, 1.151465683e-01f, 1.150898725e-01f, 1.150329963e-01f, 1.149759400e-01f, 1.149187036e-01f, 1.148612874e-01f, 1.148036914e-01f, 1.147459159e-01f,
1.146879610e-01f, 1.146298269e-01f, 1.145715136e-01f, 1.145130215e-01f, 1.144543505e-01f, 1.143955009e-01f, 1.143364729e-01f, 1.142772665e-01f, 1.142178820e-01f, 1.141583195e-01f,
1.140985792e-01f, 1.140386612e-01f, 1.139785657e-01f, 1.139182928e-01f, 1.138578427e-01f, 1.137972156e-01f, 1.137364115e-01f, 1.136754308e-01f, 1.136142735e-01f, 1.135529398e-01f,
1.134914298e-01f, 1.134297438e-01f, 1.133678818e-01f, 1.133058441e-01f, 1.132436307e-01f, 1.131812420e-01f, 1.131186779e-01f, 1.130559387e-01f, 1.129930246e-01f, 1.129299357e-01f,
1.128666721e-01f, 1.128032341e-01f, 1.127396218e-01f, 1.126758353e-01f, 1.126118748e-01f, 1.125477406e-01f, 1.124834327e-01f, 1.124189513e-01f, 1.123542965e-01f, 1.122894686e-01f,
1.122244677e-01f, 1.121592940e-01f, 1.120939477e-01f, 1.120284288e-01f, 1.119627376e-01f, 1.118968742e-01f, 1.118308388e-01f, 1.117646316e-01f, 1.116982527e-01f, 1.116317023e-01f,
1.115649806e-01f, 1.114980877e-01f, 1.114310239e-01f, 1.113637891e-01f, 1.112963838e-01f, 1.112288079e-01f, 1.111610617e-01f, 1.110931453e-01f, 1.110250590e-01f, 1.109568028e-01f,
1.108883770e-01f, 1.108197817e-01f, 1.107510170e-01f, 1.106820833e-01f, 1.106129805e-01f, 1.105437090e-01f, 1.104742688e-01f, 1.104046602e-01f, 1.103348833e-01f, 1.102649382e-01f,
1.101948252e-01f, 1.101245445e-01f, 1.100540961e-01f, 1.099834803e-01f, 1.099126973e-01f, 1.098417471e-01f, 1.097706301e-01f, 1.096993463e-01f, 1.096278959e-01f, 1.095562791e-01f,
1.094844961e-01f, 1.094125471e-01f, 1.093404322e-01f, 1.092681516e-01f, 1.091957055e-01f, 1.091230940e-01f, 1.090503174e-01f, 1.089773757e-01f, 1.089042693e-01f, 1.088309981e-01f,
1.087575625e-01f, 1.086839627e-01f, 1.086101986e-01f, 1.085362707e-01f, 1.084621790e-01f, 1.083879237e-01f, 1.083135049e-01f, 1.082389230e-01f, 1.081641780e-01f, 1.080892701e-01f,
1.080141995e-01f, 1.079389663e-01f, 1.078635708e-01f, 1.077880132e-01f, 1.077122936e-01f, 1.076364121e-01f, 1.075603690e-01f, 1.074841645e-01f, 1.074077987e-01f, 1.073312718e-01f,
1.072545840e-01f, 1.071777355e-01f, 1.071007264e-01f, 1.070235569e-01f, 1.069462273e-01f, 1.068687376e-01f, 1.067910881e-01f, 1.067132790e-01f, 1.066353104e-01f, 1.065571825e-01f,
1.064788955e-01f, 1.064004496e-01f, 1.063218449e-01f, 1.062430817e-01f, 1.061641601e-01f, 1.060850804e-01f, 1.060058426e-01f, 1.059264470e-01f, 1.058468938e-01f, 1.057671831e-01f,
1.056873151e-01f, 1.056072901e-01f, 1.055271081e-01f, 1.054467694e-01f, 1.053662742e-01f, 1.052856227e-01f, 1.052048150e-01f, 1.051238513e-01f, 1.050427318e-01f, 1.049614567e-01f,
1.048800262e-01f, 1.047984404e-01f, 1.047166996e-01f, 1.046348040e-01f, 1.045527537e-01f, 1.044705488e-01f, 1.043881897e-01f, 1.043056765e-01f, 1.042230093e-01f, 1.041401884e-01f,
1.040572140e-01f, 1.039740862e-01f, 1.038908052e-01f, 1.038073712e-01f, 1.037237845e-01f, 1.036400451e-01f, 1.035561533e-01f, 1.034721093e-01f, 1.033879132e-01f, 1.033035653e-01f,
1.032190657e-01f, 1.031344147e-01f, 1.030496124e-01f, 1.029646590e-01f, 1.028795547e-01f, 1.027942996e-01f, 1.027088941e-01f, 1.026233382e-01f, 1.025376322e-01f, 1.024517763e-01f,
1.023657706e-01f, 1.022796153e-01f, 1.021933107e-01f, 1.021068569e-01f, 1.020202541e-01f, 1.019335025e-01f, 1.018466023e-01f, 1.017595538e-01f, 1.016723570e-01f, 1.015850121e-01f,
1.014975195e-01f, 1.014098792e-01f, 1.013220915e-01f, 1.012341566e-01f, 1.011460746e-01f, 1.010578457e-01f, 1.009694702e-01f, 1.008809482e-01f, 1.007922799e-01f, 1.007034656e-01f,
1.006145054e-01f, 1.005253995e-01f, 1.004361481e-01f, 1.003467514e-01f, 1.002572096e-01f, 1.001675229e-01f, 1.000776915e-01f, 9.998771561e-02f, 9.989759539e-02f, 9.980733106e-02f,
9.971692281e-02f, 9.962637084e-02f, 9.953567535e-02f, 9.944483653e-02f, 9.935385458e-02f, 9.926272970e-02f, 9.917146209e-02f, 9.908005194e-02f, 9.898849946e-02f, 9.889680484e-02f,
9.880496828e-02f, 9.871298998e-02f, 9.862087014e-02f, 9.852860896e-02f, 9.843620664e-02f, 9.834366337e-02f, 9.825097936e-02f, 9.815815481e-02f, 9.806518992e-02f, 9.797208489e-02f,
9.787883991e-02f, 9.778545519e-02f, 9.769193093e-02f, 9.759826734e-02f, 9.750446460e-02f, 9.741052293e-02f, 9.731644252e-02f, 9.722222358e-02f, 9.712786630e-02f, 9.703337090e-02f,
9.693873756e-02f, 9.684396650e-02f, 9.674905792e-02f, 9.665401202e-02f, 9.655882900e-02f, 9.646350906e-02f, 9.636805241e-02f, 9.627245925e-02f, 9.617672978e-02f, 9.608086422e-02f,
9.598486275e-02f, 9.588872559e-02f, 9.579245294e-02f, 9.569604501e-02f, 9.559950199e-02f, 9.550282409e-02f, 9.540601152e-02f, 9.530906448e-02f, 9.521198318e-02f, 9.511476783e-02f,
9.501741861e-02f, 9.491993576e-02f, 9.482231946e-02f, 9.472456992e-02f, 9.462668735e-02f, 9.452867196e-02f, 9.443052396e-02f, 9.433224354e-02f, 9.423383091e-02f, 9.413528629e-02f,
9.403660988e-02f, 9.393780188e-02f, 9.383886250e-02f, 9.373979196e-02f, 9.364059045e-02f, 9.354125818e-02f, 9.344179537e-02f, 9.334220222e-02f, 9.324247894e-02f, 9.314262573e-02f,
9.304264281e-02f, 9.294253039e-02f, 9.284228866e-02f, 9.274191785e-02f, 9.264141815e-02f, 9.254078979e-02f, 9.244003296e-02f, 9.233914788e-02f, 9.223813476e-02f, 9.213699380e-02f,
9.203572522e-02f, 9.193432923e-02f, 9.183280603e-02f, 9.173115584e-02f, 9.162937886e-02f, 9.152747531e-02f, 9.142544540e-02f, 9.132328934e-02f, 9.122100734e-02f, 9.111859961e-02f,
9.101606636e-02f, 9.091340781e-02f, 9.081062416e-02f, 9.070771562e-02f, 9.060468242e-02f, 9.050152475e-02f, 9.039824284e-02f, 9.029483689e-02f, 9.019130711e-02f, 9.008765373e-02f,
8.998387695e-02f, 8.987997698e-02f, 8.977595404e-02f, 8.967180834e-02f, 8.956754009e-02f, 8.946314951e-02f, 8.935863681e-02f, 8.925400220e-02f, 8.914924591e-02f, 8.904436813e-02f,
8.893936909e-02f, 8.883424899e-02f, 8.872900806e-02f, 8.862364651e-02f, 8.851816455e-02f, 8.841256240e-02f, 8.830684026e-02f, 8.820099837e-02f, 8.809503692e-02f, 8.798895615e-02f,
8.788275625e-02f, 8.777643745e-02f, 8.766999997e-02f, 8.756344401e-02f, 8.745676980e-02f, 8.734997755e-02f, 8.724306747e-02f, 8.713603979e-02f, 8.702889471e-02f, 8.692163246e-02f,
8.681425325e-02f, 8.670675730e-02f, 8.659914482e-02f, 8.649141604e-02f, 8.638357116e-02f, 8.627561042e-02f, 8.616753401e-02f, 8.605934217e-02f, 8.595103510e-02f, 8.584261303e-02f,
8.573407617e-02f, 8.562542475e-02f, 8.551665897e-02f, 8.540777906e-02f, 8.529878524e-02f, 8.518967773e-02f, 8.508045673e-02f, 8.497112248e-02f, 8.486167519e-02f, 8.475211508e-02f,
8.464244236e-02f, 8.453265726e-02f, 8.442276000e-02f, 8.431275080e-02f, 8.420262987e-02f, 8.409239743e-02f, 8.398205371e-02f, 8.387159893e-02f, 8.376103330e-02f, 8.365035704e-02f,
8.353957038e-02f, 8.342867353e-02f, 8.331766672e-02f, 8.320655016e-02f, 8.309532408e-02f, 8.298398869e-02f, 8.287254422e-02f, 8.276099090e-02f, 8.264932893e-02f, 8.253755854e-02f,
8.242567995e-02f, 8.231369339e-02f, 8.220159907e-02f, 8.208939722e-02f, 8.197708806e-02f, 8.186467181e-02f, 8.175214868e-02f, 8.163951892e-02f, 8.152678273e-02f, 8.141394033e-02f,
8.130099196e-02f, 8.118793783e-02f, 8.107477817e-02f, 8.096151320e-02f, 8.084814313e-02f, 8.073466820e-02f, 8.062108863e-02f, 8.050740464e-02f, 8.039361645e-02f, 8.027972429e-02f,
8.016572838e-02f, 8.005162894e-02f, 7.993742620e-02f, 7.982312038e-02f, 7.970871170e-02f, 7.959420039e-02f, 7.947958668e-02f, 7.936487078e-02f, 7.925005292e-02f, 7.913513333e-02f,
7.902011223e-02f, 7.890498984e-02f, 7.878976639e-02f, 7.867444211e-02f, 7.855901721e-02f, 7.844349193e-02f, 7.832786648e-02f, 7.821214110e-02f, 7.809631600e-02f, 7.798039142e-02f,
7.786436758e-02f, 7.774824471e-02f, 7.763202302e-02f, 7.751570275e-02f, 7.739928412e-02f, 7.728276736e-02f, 7.716615269e-02f, 7.704944034e-02f, 7.693263054e-02f, 7.681572351e-02f,
7.669871947e-02f, 7.658161867e-02f, 7.646442131e-02f, 7.634712763e-02f, 7.622973785e-02f, 7.611225221e-02f, 7.599467092e-02f, 7.587699422e-02f, 7.575922233e-02f, 7.564135548e-02f,
7.552339390e-02f, 7.540533780e-02f, 7.528718743e-02f, 7.516894301e-02f, 7.505060477e-02f, 7.493217293e-02f, 7.481364772e-02f, 7.469502936e-02f, 7.457631810e-02f, 7.445751415e-02f,
7.433861774e-02f, 7.421962911e-02f, 7.410054847e-02f, 7.398137607e-02f, 7.386211212e-02f, 7.374275685e-02f, 7.362331050e-02f, 7.350377328e-02f, 7.338414544e-02f, 7.326442720e-02f,
7.314461879e-02f, 7.302472043e-02f, 7.290473236e-02f, 7.278465481e-02f, 7.266448800e-02f, 7.254423216e-02f, 7.242388753e-02f, 7.230345433e-02f, 7.218293280e-02f, 7.206232315e-02f,
7.194162563e-02f, 7.182084045e-02f, 7.169996786e-02f, 7.157900808e-02f, 7.145796134e-02f, 7.133682787e-02f, 7.121560791e-02f, 7.109430167e-02f, 7.097290940e-02f, 7.085143131e-02f,
7.072986765e-02f, 7.060821864e-02f, 7.048648452e-02f, 7.036466551e-02f, 7.024276184e-02f, 7.012077375e-02f, 6.999870147e-02f, 6.987654522e-02f, 6.975430524e-02f, 6.963198176e-02f,
6.950957501e-02f, 6.938708522e-02f, 6.926451262e-02f, 6.914185745e-02f, 6.901911993e-02f, 6.889630030e-02f, 6.877339879e-02f, 6.865041563e-02f, 6.852735105e-02f, 6.840420528e-02f,
6.828097856e-02f, 6.815767111e-02f, 6.803428318e-02f, 6.791081498e-02f, 6.778726676e-02f, 6.766363874e-02f, 6.753993115e-02f, 6.741614424e-02f, 6.729227823e-02f, 6.716833335e-02f,
6.704430984e-02f, 6.692020793e-02f, 6.679602785e-02f, 6.667176983e-02f, 6.654743410e-02f, 6.642302091e-02f, 6.629853048e-02f, 6.617396304e-02f, 6.604931883e-02f, 6.592459809e-02f,
6.579980103e-02f, 6.567492790e-02f, 6.554997893e-02f, 6.542495436e-02f, 6.529985440e-02f, 6.517467931e-02f, 6.504942931e-02f, 6.492410464e-02f, 6.479870552e-02f, 6.467323220e-02f,
6.454768491e-02f, 6.442206387e-02f, 6.429636933e-02f, 6.417060151e-02f, 6.404476066e-02f, 6.391884700e-02f, 6.379286077e-02f, 6.366680220e-02f, 6.354067153e-02f, 6.341446898e-02f,
6.328819480e-02f, 6.316184922e-02f, 6.303543248e-02f, 6.290894480e-02f, 6.278238642e-02f, 6.265575757e-02f, 6.252905850e-02f, 6.240228943e-02f, 6.227545060e-02f, 6.214854224e-02f,
6.202156459e-02f, 6.189451788e-02f, 6.176740234e-02f, 6.164021822e-02f, 6.151296574e-02f, 6.138564515e-02f, 6.125825667e-02f, 6.113080054e-02f, 6.100327699e-02f, 6.087568626e-02f,
6.074802859e-02f, 6.062030421e-02f, 6.049251336e-02f, 6.036465626e-02f, 6.023673316e-02f, 6.010874429e-02f, 5.998068988e-02f, 5.985257018e-02f, 5.972438541e-02f, 5.959613581e-02f,
5.946782162e-02f, 5.933944307e-02f, 5.921100039e-02f, 5.908249383e-02f, 5.895392362e-02f, 5.882528999e-02f, 5.869659319e-02f, 5.856783343e-02f, 5.843901097e-02f, 5.831012603e-02f,
5.818117885e-02f, 5.805216968e-02f, 5.792309873e-02f, 5.779396625e-02f, 5.766477248e-02f, 5.753551765e-02f, 5.740620200e-02f, 5.727682576e-02f, 5.714738916e-02f, 5.701789245e-02f,
5.688833587e-02f, 5.675871963e-02f, 5.662904400e-02f, 5.649930918e-02f, 5.636951544e-02f, 5.623966299e-02f, 5.610975209e-02f, 5.597978295e-02f, 5.584975583e-02f, 5.571967095e-02f,
5.558952855e-02f, 5.545932887e-02f, 5.532907215e-02f, 5.519875861e-02f, 5.506838851e-02f, 5.493796206e-02f, 5.480747952e-02f, 5.467694112e-02f, 5.454634709e-02f, 5.441569766e-02f,
5.428499309e-02f, 5.415423360e-02f, 5.402341942e-02f, 5.389255080e-02f, 5.376162798e-02f, 5.363065118e-02f, 5.349962065e-02f, 5.336853662e-02f, 5.323739933e-02f, 5.310620902e-02f,
5.297496592e-02f, 5.284367027e-02f, 5.271232231e-02f, 5.258092226e-02f, 5.244947038e-02f, 5.231796690e-02f, 5.218641204e-02f, 5.205480606e-02f, 5.192314918e-02f, 5.179144165e-02f,
5.165968370e-02f, 5.152787557e-02f, 5.139601749e-02f, 5.126410970e-02f, 5.113215244e-02f, 5.100014595e-02f, 5.086809046e-02f, 5.073598621e-02f, 5.060383343e-02f, 5.047163237e-02f,
5.033938326e-02f, 5.020708633e-02f, 5.007474183e-02f, 4.994235000e-02f, 4.980991106e-02f, 4.967742525e-02f, 4.954489282e-02f, 4.941231400e-02f, 4.927968902e-02f, 4.914701813e-02f,
4.901430156e-02f, 4.888153955e-02f, 4.874873233e-02f, 4.861588015e-02f, 4.848298323e-02f, 4.835004182e-02f, 4.821705616e-02f, 4.808402647e-02f, 4.795095300e-02f, 4.781783599e-02f,
4.768467567e-02f, 4.755147228e-02f, 4.741822606e-02f, 4.728493724e-02f, 4.715160606e-02f, 4.701823276e-02f, 4.688481758e-02f, 4.675136074e-02f, 4.661786250e-02f, 4.648432308e-02f,
4.635074273e-02f, 4.621712168e-02f, 4.608346016e-02f, 4.594975842e-02f, 4.581601670e-02f, 4.568223522e-02f, 4.554841423e-02f, 4.541455396e-02f, 4.528065466e-02f, 4.514671655e-02f,
4.501273988e-02f, 4.487872488e-02f, 4.474467179e-02f, 4.461058084e-02f, 4.447645228e-02f, 4.434228634e-02f, 4.420808326e-02f, 4.407384328e-02f, 4.393956662e-02f, 4.380525354e-02f,
4.367090426e-02f, 4.353651903e-02f, 4.340209807e-02f, 4.326764163e-02f, 4.313314995e-02f, 4.299862326e-02f, 4.286406180e-02f, 4.272946580e-02f, 4.259483550e-02f, 4.246017115e-02f,
4.232547297e-02f, 4.219074120e-02f, 4.205597609e-02f, 4.192117786e-02f, 4.178634675e-02f, 4.165148301e-02f, 4.151658686e-02f, 4.138165855e-02f, 4.124669831e-02f, 4.111170638e-02f,
4.097668300e-02f, 4.084162839e-02f, 4.070654281e-02f, 4.057142648e-02f, 4.043627964e-02f, 4.030110253e-02f, 4.016589539e-02f, 4.003065845e-02f, 3.989539195e-02f, 3.976009613e-02f,
3.962477122e-02f, 3.948941745e-02f, 3.935403508e-02f, 3.921862432e-02f, 3.908318543e-02f, 3.894771863e-02f, 3.881222416e-02f, 3.867670226e-02f, 3.854115317e-02f, 3.840557711e-02f,
3.826997434e-02f, 3.813434508e-02f, 3.799868957e-02f, 3.786300805e-02f, 3.772730075e-02f, 3.759156791e-02f, 3.745580976e-02f, 3.732002655e-02f, 3.718421851e-02f, 3.704838587e-02f,
3.691252887e-02f, 3.677664775e-02f, 3.664074274e-02f, 3.650481408e-02f, 3.636886201e-02f, 3.623288676e-02f, 3.609688856e-02f, 3.596086766e-02f, 3.582482429e-02f, 3.568875868e-02f,
3.555267107e-02f, 3.541656170e-02f, 3.528043081e-02f, 3.514427862e-02f, 3.500810538e-02f, 3.487191131e-02f, 3.473569666e-02f, 3.459946167e-02f, 3.446320656e-02f, 3.432693157e-02f,
3.419063694e-02f, 3.405432291e-02f, 3.391798970e-02f, 3.378163756e-02f, 3.364526672e-02f, 3.350887742e-02f, 3.337246988e-02f, 3.323604435e-02f, 3.309960107e-02f, 3.296314025e-02f,
3.282666216e-02f, 3.269016700e-02f, 3.255365504e-02f, 3.241712648e-02f, 3.228058158e-02f, 3.214402057e-02f, 3.200744368e-02f, 3.187085115e-02f, 3.173424321e-02f, 3.159762009e-02f,
3.146098204e-02f, 3.132432929e-02f, 3.118766206e-02f, 3.105098060e-02f, 3.091428514e-02f, 3.077757592e-02f, 3.064085317e-02f, 3.050411712e-02f, 3.036736801e-02f, 3.023060607e-02f,
3.009383154e-02f, 2.995704465e-02f, 2.982024564e-02f, 2.968343474e-02f, 2.954661218e-02f, 2.940977820e-02f, 2.927293303e-02f, 2.913607691e-02f, 2.899921007e-02f, 2.886233275e-02f,
2.872544517e-02f, 2.858854758e-02f, 2.845164020e-02f, 2.831472327e-02f, 2.817779703e-02f, 2.804086170e-02f, 2.790391752e-02f, 2.776696473e-02f, 2.763000356e-02f, 2.749303423e-02f,
2.735605699e-02f, 2.721907207e-02f, 2.708207970e-02f, 2.694508012e-02f, 2.680807355e-02f, 2.667106024e-02f, 2.653404040e-02f, 2.639701429e-02f, 2.625998212e-02f, 2.612294414e-02f,
2.598590057e-02f, 2.584885166e-02f, 2.571179762e-02f, 2.557473869e-02f, 2.543767512e-02f, 2.530060712e-02f, 2.516353493e-02f, 2.502645879e-02f, 2.488937892e-02f, 2.475229556e-02f,
2.461520894e-02f, 2.447811930e-02f, 2.434102686e-02f, 2.420393186e-02f, 2.406683452e-02f, 2.392973509e-02f, 2.379263379e-02f, 2.365553086e-02f, 2.351842652e-02f, 2.338132102e-02f,
2.324421457e-02f, 2.310710741e-02f, 2.296999978e-02f, 2.283289190e-02f, 2.269578401e-02f, 2.255867633e-02f, 2.242156911e-02f, 2.228446256e-02f, 2.214735692e-02f, 2.201025243e-02f,
2.187314931e-02f, 2.173604779e-02f, 2.159894811e-02f, 2.146185049e-02f, 2.132475517e-02f, 2.118766238e-02f, 2.105057235e-02f, 2.091348530e-02f, 2.077640147e-02f, 2.063932109e-02f,
2.050224439e-02f, 2.036517160e-02f, 2.022810295e-02f, 2.009103866e-02f, 1.995397898e-02f, 1.981692413e-02f, 1.967987434e-02f, 1.954282984e-02f, 1.940579085e-02f, 1.926875762e-02f,
1.913173036e-02f, 1.899470931e-02f, 1.885769470e-02f, 1.872068675e-02f, 1.858368570e-02f, 1.844669178e-02f, 1.830970521e-02f, 1.817272623e-02f, 1.803575505e-02f, 1.789879192e-02f,
1.776183706e-02f, 1.762489070e-02f, 1.748795306e-02f, 1.735102438e-02f, 1.721410489e-02f, 1.707719480e-02f, 1.694029436e-02f, 1.680340379e-02f, 1.666652332e-02f, 1.652965318e-02f,
1.639279358e-02f, 1.625594477e-02f, 1.611910697e-02f, 1.598228041e-02f, 1.584546532e-02f, 1.570866191e-02f, 1.557187043e-02f, 1.543509109e-02f, 1.529832414e-02f, 1.516156978e-02f,
1.502482825e-02f, 1.488809978e-02f, 1.475138460e-02f, 1.461468293e-02f, 1.447799499e-02f, 1.434132102e-02f, 1.420466124e-02f, 1.406801588e-02f, 1.393138516e-02f, 1.379476932e-02f,
1.365816857e-02f, 1.352158315e-02f, 1.338501327e-02f, 1.324845917e-02f, 1.311192108e-02f, 1.297539921e-02f, 1.283889380e-02f, 1.270240506e-02f, 1.256593323e-02f, 1.242947853e-02f,
1.229304119e-02f, 1.215662143e-02f, 1.202021948e-02f, 1.188383555e-02f, 1.174746989e-02f, 1.161112271e-02f, 1.147479423e-02f, 1.133848469e-02f, 1.120219430e-02f, 1.106592329e-02f,
1.092967189e-02f, 1.079344032e-02f, 1.065722880e-02f, 1.052103757e-02f, 1.038486683e-02f, 1.024871683e-02f, 1.011258777e-02f, 9.976479888e-03f, 9.840393405e-03f, 9.704328544e-03f,
9.568285529e-03f, 9.432264583e-03f, 9.296265930e-03f, 9.160289793e-03f, 9.024336395e-03f, 8.888405959e-03f, 8.752498709e-03f, 8.616614866e-03f, 8.480754655e-03f, 8.344918297e-03f,
8.209106015e-03f, 8.073318031e-03f, 7.937554569e-03f, 7.801815850e-03f, 7.666102096e-03f, 7.530413530e-03f, 7.394750373e-03f, 7.259112847e-03f, 7.123501175e-03f, 6.987915577e-03f,
6.852356276e-03f, 6.716823492e-03f, 6.581317447e-03f, 6.445838363e-03f, 6.310386460e-03f, 6.174961960e-03f, 6.039565083e-03f, 5.904196050e-03f, 5.768855082e-03f, 5.633542399e-03f,
5.498258223e-03f, 5.363002773e-03f, 5.227776270e-03f, 5.092578933e-03f, 4.957410983e-03f, 4.822272640e-03f, 4.687164124e-03f, 4.552085654e-03f, 4.417037451e-03f, 4.282019732e-03f,
4.147032719e-03f, 4.012076630e-03f, 3.877151684e-03f, 3.742258101e-03f, 3.607396099e-03f, 3.472565897e-03f, 3.337767714e-03f, 3.203001769e-03f, 3.068268280e-03f, 2.933567466e-03f,
2.798899544e-03f, 2.664264733e-03f, 2.529663251e-03f, 2.395095316e-03f, 2.260561146e-03f, 2.126060958e-03f, 1.991594970e-03f, 1.857163399e-03f, 1.722766463e-03f, 1.588404380e-03f,
1.454077365e-03f, 1.319785637e-03f, 1.185529411e-03f, 1.051308906e-03f, 9.171243363e-04f, 7.829759199e-04f, 6.488638730e-04f, 5.147884117e-04f, 3.807497521e-04f, 2.467481105e-04f,
1.127837026e-04f, -2.114325572e-05f, -1.550325488e-04f, -2.888839610e-04f, -4.226972769e-04f, -5.564722813e-04f, -6.902087588e-04f, -8.239064945e-04f, -9.575652734e-04f, -1.091184881e-03f,
-1.224765101e-03f, -1.358305721e-03f, -1.491806526e-03f, -1.625267301e-03f, -1.758687832e-03f, -1.892067905e-03f, -2.025407306e-03f, -2.158705821e-03f, -2.291963236e-03f, -2.425179339e-03f,
-2.558353915e-03f, -2.691486751e-03f, -2.824577634e-03f, -2.957626351e-03f, -3.090632689e-03f, -3.223596435e-03f, -3.356517376e-03f, -3.489395300e-03f, -3.622229995e-03f, -3.755021248e-03f,
-3.887768846e-03f, -4.020472579e-03f, -4.153132234e-03f, -4.285747599e-03f, -4.418318462e-03f, -4.550844613e-03f, -4.683325839e-03f, -4.815761930e-03f, -4.948152674e-03f, -5.080497860e-03f,
-5.212797278e-03f, -5.345050717e-03f, -5.477257965e-03f, -5.609418814e-03f, -5.741533052e-03f, -5.873600469e-03f, -6.005620855e-03f, -6.137594000e-03f, -6.269519695e-03f, -6.401397730e-03f,
-6.533227895e-03f, -6.665009981e-03f, -6.796743778e-03f, -6.928429078e-03f, -7.060065672e-03f, -7.191653350e-03f, -7.323191905e-03f, -7.454681127e-03f, -7.586120808e-03f, -7.717510741e-03f,
-7.848850715e-03f, -7.980140525e-03f, -8.111379961e-03f, -8.242568817e-03f, -8.373706884e-03f, -8.504793955e-03f, -8.635829823e-03f, -8.766814281e-03f, -8.897747122e-03f, -9.028628138e-03f,
-9.159457123e-03f, -9.290233871e-03f, -9.420958175e-03f, -9.551629828e-03f, -9.682248625e-03f, -9.812814360e-03f, -9.943326826e-03f, -1.007378582e-02f, -1.020419113e-02f, -1.033454256e-02f,
-1.046483990e-02f, -1.059508294e-02f, -1.072527148e-02f, -1.085540531e-02f, -1.098548424e-02f, -1.111550805e-02f, -1.124547654e-02f, -1.137538951e-02f, -1.150524675e-02f, -1.163504806e-02f,
-1.176479324e-02f, -1.189448207e-02f, -1.202411436e-02f, -1.215368991e-02f, -1.228320851e-02f, -1.241266995e-02f, -1.254207404e-02f, -1.267142057e-02f, -1.280070935e-02f, -1.292994015e-02f,
-1.305911280e-02f, -1.318822707e-02f, -1.331728278e-02f, -1.344627971e-02f, -1.357521767e-02f, -1.370409646e-02f, -1.383291587e-02f, -1.396167570e-02f, -1.409037575e-02f, -1.421901582e-02f,
-1.434759572e-02f, -1.447611523e-02f, -1.460457416e-02f, -1.473297231e-02f, -1.486130947e-02f, -1.498958546e-02f, -1.511780006e-02f, -1.524595308e-02f, -1.537404431e-02f, -1.550207357e-02f,
-1.563004065e-02f, -1.575794534e-02f, -1.588578746e-02f, -1.601356681e-02f, -1.614128317e-02f, -1.626893636e-02f, -1.639652618e-02f, -1.652405243e-02f, -1.665151491e-02f, -1.677891343e-02f,
-1.690624778e-02f, -1.703351776e-02f, -1.716072319e-02f, -1.728786386e-02f, -1.741493958e-02f, -1.754195015e-02f, -1.766889537e-02f, -1.779577505e-02f, -1.792258899e-02f, -1.804933699e-02f,
-1.817601886e-02f, -1.830263440e-02f, -1.842918342e-02f, -1.855566572e-02f, -1.868208110e-02f, -1.880842937e-02f, -1.893471034e-02f, -1.906092381e-02f, -1.918706958e-02f, -1.931314746e-02f,
-1.943915726e-02f, -1.956509878e-02f, -1.969097182e-02f, -1.981677620e-02f, -1.994251172e-02f, -2.006817819e-02f, -2.019377541e-02f, -2.031930318e-02f, -2.044476133e-02f, -2.057014964e-02f,
-2.069546794e-02f, -2.082071603e-02f, -2.094589371e-02f, -2.107100079e-02f, -2.119603708e-02f, -2.132100240e-02f, -2.144589654e-02f, -2.157071931e-02f, -2.169547053e-02f, -2.182015001e-02f,
-2.194475754e-02f, -2.206929295e-02f, -2.219375603e-02f, -2.231814661e-02f, -2.244246448e-02f, -2.256670947e-02f, -2.269088137e-02f, -2.281498000e-02f, -2.293900517e-02f, -2.306295669e-02f,
-2.318683437e-02f, -2.331063802e-02f, -2.343436745e-02f, -2.355802247e-02f, -2.368160290e-02f, -2.380510855e-02f, -2.392853922e-02f, -2.405189473e-02f, -2.417517490e-02f, -2.429837952e-02f,
-2.442150843e-02f, -2.454456142e-02f, -2.466753831e-02f, -2.479043892e-02f, -2.491326305e-02f, -2.503601052e-02f, -2.515868115e-02f, -2.528127474e-02f, -2.540379112e-02f, -2.552623009e-02f,
-2.564859147e-02f, -2.577087507e-02f, -2.589308071e-02f, -2.601520820e-02f, -2.613725736e-02f, -2.625922800e-02f, -2.638111994e-02f, -2.650293299e-02f, -2.662466697e-02f, -2.674632170e-02f,
-2.686789698e-02f, -2.698939264e-02f, -2.711080850e-02f, -2.723214436e-02f, -2.735340005e-02f, -2.747457538e-02f, -2.759567016e-02f, -2.771668423e-02f, -2.783761739e-02f, -2.795846946e-02f,
-2.807924026e-02f, -2.819992960e-02f, -2.832053732e-02f, -2.844106321e-02f, -2.856150711e-02f, -2.868186883e-02f, -2.880214818e-02f, -2.892234500e-02f, -2.904245909e-02f, -2.916249028e-02f,
-2.928243838e-02f, -2.940230322e-02f, -2.952208462e-02f, -2.964178240e-02f, -2.976139637e-02f, -2.988092635e-02f, -3.000037218e-02f, -3.011973366e-02f, -3.023901063e-02f, -3.035820289e-02f,
-3.047731028e-02f, -3.059633261e-02f, -3.071526971e-02f, -3.083412139e-02f, -3.095288749e-02f, -3.107156781e-02f, -3.119016219e-02f, -3.130867045e-02f, -3.142709241e-02f, -3.154542790e-02f,
-3.166367673e-02f, -3.178183873e-02f, -3.189991372e-02f, -3.201790154e-02f, -3.213580199e-02f, -3.225361491e-02f, -3.237134013e-02f, -3.248897746e-02f, -3.260652672e-02f, -3.272398776e-02f,
-3.284136039e-02f, -3.295864443e-02f, -3.307583971e-02f, -3.319294606e-02f, -3.330996331e-02f, -3.342689127e-02f, -3.354372978e-02f, -3.366047867e-02f, -3.377713775e-02f, -3.389370686e-02f,
-3.401018582e-02f, -3.412657447e-02f, -3.424287262e-02f, -3.435908011e-02f, -3.447519677e-02f, -3.459122241e-02f, -3.470715688e-02f, -3.482300000e-02f, -3.493875159e-02f, -3.505441150e-02f,
-3.516997954e-02f, -3.528545554e-02f, -3.540083934e-02f, -3.551613076e-02f, -3.563132964e-02f, -3.574643581e-02f, -3.586144909e-02f, -3.597636931e-02f, -3.609119631e-02f, -3.620592992e-02f,
-3.632056997e-02f, -3.643511629e-02f, -3.654956870e-02f, -3.666392706e-02f, -3.677819117e-02f, -3.689236089e-02f, -3.700643603e-02f, -3.712041643e-02f, -3.723430193e-02f, -3.734809236e-02f,
-3.746178755e-02f, -3.757538733e-02f, -3.768889154e-02f, -3.780230001e-02f, -3.791561257e-02f, -3.802882907e-02f, -3.814194932e-02f, -3.825497318e-02f, -3.836790047e-02f, -3.848073103e-02f,
-3.859346469e-02f, -3.870610129e-02f, -3.881864066e-02f, -3.893108264e-02f, -3.904342707e-02f, -3.915567378e-02f, -3.926782260e-02f, -3.937987339e-02f, -3.949182596e-02f, -3.960368016e-02f,
-3.971543583e-02f, -3.982709280e-02f, -3.993865091e-02f, -4.005011000e-02f, -4.016146991e-02f, -4.027273047e-02f, -4.038389153e-02f, -4.049495292e-02f, -4.060591447e-02f, -4.071677604e-02f,
-4.082753746e-02f, -4.093819856e-02f, -4.104875920e-02f, -4.115921920e-02f, -4.126957841e-02f, -4.137983667e-02f, -4.148999381e-02f, -4.160004969e-02f, -4.171000414e-02f, -4.181985700e-02f,
-4.192960811e-02f, -4.203925732e-02f, -4.214880446e-02f, -4.225824938e-02f, -4.236759193e-02f, -4.247683193e-02f, -4.258596924e-02f, -4.269500371e-02f, -4.280393516e-02f, -4.291276344e-02f,
-4.302148841e-02f, -4.313010990e-02f, -4.323862775e-02f, -4.334704182e-02f, -4.345535193e-02f, -4.356355795e-02f, -4.367165971e-02f, -4.377965706e-02f, -4.388754984e-02f, -4.399533791e-02f,
-4.410302109e-02f, -4.421059925e-02f, -4.431807222e-02f, -4.442543986e-02f, -4.453270201e-02f, -4.463985851e-02f, -4.474690921e-02f, -4.485385397e-02f, -4.496069262e-02f, -4.506742502e-02f,
-4.517405101e-02f, -4.528057044e-02f, -4.538698316e-02f, -4.549328901e-02f, -4.559948785e-02f, -4.570557953e-02f, -4.581156389e-02f, -4.591744078e-02f, -4.602321006e-02f, -4.612887156e-02f,
-4.623442515e-02f, -4.633987067e-02f, -4.644520798e-02f, -4.655043691e-02f, -4.665555733e-02f, -4.676056909e-02f, -4.686547203e-02f, -4.697026601e-02f, -4.707495088e-02f, -4.717952649e-02f,
-4.728399269e-02f, -4.738834934e-02f, -4.749259628e-02f, -4.759673338e-02f, -4.770076048e-02f, -4.780467744e-02f, -4.790848411e-02f, -4.801218034e-02f, -4.811576599e-02f, -4.821924091e-02f,
-4.832260496e-02f, -4.842585799e-02f, -4.852899985e-02f, -4.863203041e-02f, -4.873494951e-02f, -4.883775702e-02f, -4.894045278e-02f, -4.904303665e-02f, -4.914550849e-02f, -4.924786816e-02f,
-4.935011551e-02f, -4.945225039e-02f, -4.955427268e-02f, -4.965618221e-02f, -4.975797886e-02f, -4.985966247e-02f, -4.996123291e-02f, -5.006269004e-02f, -5.016403370e-02f, -5.026526377e-02f,
-5.036638009e-02f, -5.046738254e-02f, -5.056827096e-02f, -5.066904522e-02f, -5.076970518e-02f, -5.087025069e-02f, -5.097068162e-02f, -5.107099783e-02f, -5.117119917e-02f, -5.127128552e-02f,
-5.137125672e-02f, -5.147111264e-02f, -5.157085315e-02f, -5.167047810e-02f, -5.176998736e-02f, -5.186938079e-02f, -5.196865825e-02f, -5.206781960e-02f, -5.216686470e-02f, -5.226579343e-02f,
-5.236460564e-02f, -5.246330119e-02f, -5.256187996e-02f, -5.266034180e-02f, -5.275868658e-02f, -5.285691416e-02f, -5.295502441e-02f, -5.305301719e-02f, -5.315089237e-02f, -5.324864981e-02f,
-5.334628938e-02f, -5.344381094e-02f, -5.354121437e-02f, -5.363849952e-02f, -5.373566626e-02f, -5.383271447e-02f, -5.392964400e-02f, -5.402645473e-02f, -5.412314651e-02f, -5.421971923e-02f,
-5.431617275e-02f, -5.441250693e-02f, -5.450872164e-02f, -5.460481676e-02f, -5.470079215e-02f, -5.479664768e-02f, -5.489238322e-02f, -5.498799864e-02f, -5.508349380e-02f, -5.517886859e-02f,
-5.527412287e-02f, -5.536925650e-02f, -5.546426937e-02f, -5.555916134e-02f, -5.565393228e-02f, -5.574858207e-02f, -5.584311057e-02f, -5.593751766e-02f, -5.603180321e-02f, -5.612596709e-02f,
-5.622000917e-02f, -5.631392934e-02f, -5.640772745e-02f, -5.650140339e-02f, -5.659495703e-02f, -5.668838823e-02f, -5.678169689e-02f, -5.687488286e-02f, -5.696794603e-02f, -5.706088626e-02f,
-5.715370344e-02f, -5.724639744e-02f, -5.733896813e-02f, -5.743141539e-02f, -5.752373910e-02f, -5.761593913e-02f, -5.770801536e-02f, -5.779996766e-02f, -5.789179592e-02f, -5.798350000e-02f,
-5.807507979e-02f, -5.816653517e-02f, -5.825786600e-02f, -5.834907218e-02f, -5.844015357e-02f, -5.853111006e-02f, -5.862194153e-02f, -5.871264784e-02f, -5.880322890e-02f, -5.889368456e-02f,
-5.898401472e-02f, -5.907421925e-02f, -5.916429803e-02f, -5.925425095e-02f, -5.934407788e-02f, -5.943377870e-02f, -5.952335330e-02f, -5.961280156e-02f, -5.970212335e-02f, -5.979131857e-02f,
-5.988038709e-02f, -5.996932879e-02f, -6.005814356e-02f, -6.014683128e-02f, -6.023539184e-02f, -6.032382511e-02f, -6.041213099e-02f, -6.050030934e-02f, -6.058836007e-02f, -6.067628305e-02f,
-6.076407816e-02f, -6.085174530e-02f, -6.093928434e-02f, -6.102669517e-02f, -6.111397769e-02f, -6.120113176e-02f, -6.128815729e-02f, -6.137505415e-02f, -6.146182223e-02f, -6.154846142e-02f,
-6.163497161e-02f, -6.172135267e-02f, -6.180760451e-02f, -6.189372701e-02f, -6.197972005e-02f, -6.206558353e-02f, -6.215131732e-02f, -6.223692133e-02f, -6.232239544e-02f, -6.240773954e-02f,
-6.249295351e-02f, -6.257803726e-02f, -6.266299066e-02f, -6.274781361e-02f, -6.283250599e-02f, -6.291706771e-02f, -6.300149864e-02f, -6.308579869e-02f, -6.316996773e-02f, -6.325400568e-02f,
-6.333791240e-02f, -6.342168781e-02f, -6.350533178e-02f, -6.358884421e-02f, -6.367222501e-02f, -6.375547404e-02f, -6.383859122e-02f, -6.392157644e-02f, -6.400442958e-02f, -6.408715055e-02f,
-6.416973924e-02f, -6.425219553e-02f, -6.433451933e-02f, -6.441671054e-02f, -6.449876904e-02f, -6.458069473e-02f, -6.466248751e-02f, -6.474414727e-02f, -6.482567392e-02f, -6.490706734e-02f,
-6.498832744e-02f, -6.506945410e-02f, -6.515044723e-02f, -6.523130673e-02f, -6.531203249e-02f, -6.539262442e-02f, -6.547308240e-02f, -6.555340634e-02f, -6.563359613e-02f, -6.571365168e-02f,
-6.579357289e-02f, -6.587335965e-02f, -6.595301186e-02f, -6.603252943e-02f, -6.611191225e-02f, -6.619116023e-02f, -6.627027326e-02f, -6.634925125e-02f, -6.642809410e-02f, -6.650680170e-02f,
-6.658537397e-02f, -6.666381079e-02f, -6.674211209e-02f, -6.682027775e-02f, -6.689830768e-02f, -6.697620178e-02f, -6.705395996e-02f, -6.713158212e-02f, -6.720906816e-02f, -6.728641799e-02f,
-6.736363151e-02f, -6.744070863e-02f, -6.751764925e-02f, -6.759445328e-02f, -6.767112061e-02f, -6.774765117e-02f, -6.782404484e-02f, -6.790030155e-02f, -6.797642119e-02f, -6.805240367e-02f,
-6.812824889e-02f, -6.820395677e-02f, -6.827952722e-02f, -6.835496013e-02f, -6.843025542e-02f, -6.850541300e-02f, -6.858043277e-02f, -6.865531464e-02f, -6.873005853e-02f, -6.880466433e-02f,
-6.887913196e-02f, -6.895346133e-02f, -6.902765235e-02f, -6.910170493e-02f, -6.917561897e-02f, -6.924939440e-02f, -6.932303111e-02f, -6.939652903e-02f, -6.946988806e-02f, -6.954310811e-02f,
-6.961618910e-02f, -6.968913093e-02f, -6.976193353e-02f, -6.983459680e-02f, -6.990712065e-02f, -6.997950500e-02f, -7.005174976e-02f, -7.012385485e-02f, -7.019582018e-02f, -7.026764566e-02f,
-7.033933121e-02f, -7.041087674e-02f, -7.048228217e-02f, -7.055354741e-02f, -7.062467237e-02f, -7.069565698e-02f, -7.076650115e-02f, -7.083720479e-02f, -7.090776783e-02f, -7.097819017e-02f,
-7.104847174e-02f, -7.111861244e-02f, -7.118861221e-02f, -7.125847096e-02f, -7.132818860e-02f, -7.139776505e-02f, -7.146720023e-02f, -7.153649407e-02f, -7.160564647e-02f, -7.167465736e-02f,
-7.174352666e-02f, -7.181225429e-02f, -7.188084016e-02f, -7.194928420e-02f, -7.201758633e-02f, -7.208574646e-02f, -7.215376453e-02f, -7.222164045e-02f, -7.228937413e-02f, -7.235696552e-02f,
-7.242441452e-02f, -7.249172105e-02f, -7.255888505e-02f, -7.262590643e-02f, -7.269278512e-02f, -7.275952103e-02f, -7.282611410e-02f, -7.289256425e-02f, -7.295887140e-02f, -7.302503547e-02f,
-7.309105639e-02f, -7.315693409e-02f, -7.322266849e-02f, -7.328825951e-02f, -7.335370708e-02f, -7.341901113e-02f, -7.348417158e-02f, -7.354918836e-02f, -7.361406140e-02f, -7.367879062e-02f,
-7.374337594e-02f, -7.380781731e-02f, -7.387211464e-02f, -7.393626786e-02f, -7.400027690e-02f, -7.406414169e-02f, -7.412786216e-02f, -7.419143824e-02f, -7.425486985e-02f, -7.431815692e-02f,
-7.438129939e-02f, -7.444429719e-02f, -7.450715024e-02f, -7.456985848e-02f, -7.463242183e-02f, -7.469484023e-02f, -7.475711361e-02f, -7.481924190e-02f, -7.488122503e-02f, -7.494306293e-02f,
-7.500475554e-02f, -7.506630279e-02f, -7.512770461e-02f, -7.518896094e-02f, -7.525007170e-02f, -7.531103684e-02f, -7.537185628e-02f, -7.543252996e-02f, -7.549305781e-02f, -7.555343977e-02f,
-7.561367577e-02f, -7.567376576e-02f, -7.573370965e-02f, -7.579350740e-02f, -7.585315893e-02f, -7.591266418e-02f, -7.597202309e-02f, -7.603123560e-02f, -7.609030164e-02f, -7.614922114e-02f,
-7.620799405e-02f, -7.626662031e-02f, -7.632509985e-02f, -7.638343260e-02f, -7.644161852e-02f, -7.649965753e-02f, -7.655754958e-02f, -7.661529461e-02f, -7.667289255e-02f, -7.673034335e-02f,
-7.678764694e-02f, -7.684480326e-02f, -7.690181227e-02f, -7.695867389e-02f, -7.701538806e-02f, -7.707195474e-02f, -7.712837386e-02f, -7.718464536e-02f, -7.724076919e-02f, -7.729674528e-02f,
-7.735257358e-02f, -7.740825404e-02f, -7.746378659e-02f, -7.751917118e-02f, -7.757440776e-02f, -7.762949626e-02f, -7.768443663e-02f, -7.773922882e-02f, -7.779387277e-02f, -7.784836843e-02f,
-7.790271574e-02f, -7.795691464e-02f, -7.801096509e-02f, -7.806486702e-02f, -7.811862039e-02f, -7.817222514e-02f, -7.822568122e-02f, -7.827898857e-02f, -7.833214715e-02f, -7.838515689e-02f,
-7.843801776e-02f, -7.849072969e-02f, -7.854329263e-02f, -7.859570654e-02f, -7.864797136e-02f, -7.870008704e-02f, -7.875205353e-02f, -7.880387078e-02f, -7.885553874e-02f, -7.890705737e-02f,
-7.895842660e-02f, -7.900964640e-02f, -7.906071670e-02f, -7.911163748e-02f, -7.916240866e-02f, -7.921303022e-02f, -7.926350209e-02f, -7.931382424e-02f, -7.936399661e-02f, -7.941401916e-02f,
-7.946389183e-02f, -7.951361459e-02f, -7.956318739e-02f, -7.961261018e-02f, -7.966188292e-02f, -7.971100555e-02f, -7.975997804e-02f, -7.980880033e-02f, -7.985747239e-02f, -7.990599417e-02f,
-7.995436563e-02f, -8.000258672e-02f, -8.005065739e-02f, -8.009857761e-02f, -8.014634733e-02f, -8.019396651e-02f, -8.024143510e-02f, -8.028875306e-02f, -8.033592036e-02f, -8.038293694e-02f,
-8.042980277e-02f, -8.047651781e-02f, -8.052308201e-02f, -8.056949533e-02f, -8.061575774e-02f, -8.066186919e-02f, -8.070782964e-02f, -8.075363905e-02f, -8.079929738e-02f, -8.084480460e-02f,
-8.089016066e-02f, -8.093536553e-02f, -8.098041917e-02f, -8.102532153e-02f, -8.107007258e-02f, -8.111467229e-02f, -8.115912061e-02f, -8.120341751e-02f, -8.124756295e-02f, -8.129155690e-02f,
-8.133539931e-02f, -8.137909015e-02f, -8.142262939e-02f, -8.146601699e-02f, -8.150925292e-02f, -8.155233713e-02f, -8.159526960e-02f, -8.163805029e-02f, -8.168067916e-02f, -8.172315619e-02f,
-8.176548133e-02f, -8.180765456e-02f, -8.184967584e-02f, -8.189154513e-02f, -8.193326241e-02f, -8.197482764e-02f, -8.201624080e-02f, -8.205750184e-02f, -8.209861073e-02f, -8.213956745e-02f,
-8.218037197e-02f, -8.222102424e-02f, -8.226152425e-02f, -8.230187196e-02f, -8.234206734e-02f, -8.238211037e-02f, -8.242200100e-02f, -8.246173922e-02f, -8.250132498e-02f, -8.254075828e-02f,
-8.258003906e-02f, -8.261916732e-02f, -8.265814301e-02f, -8.269696612e-02f, -8.273563661e-02f, -8.277415445e-02f, -8.281251962e-02f, -8.285073210e-02f, -8.288879185e-02f, -8.292669885e-02f,
-8.296445308e-02f, -8.300205450e-02f, -8.303950310e-02f, -8.307679884e-02f, -8.311394170e-02f, -8.315093166e-02f, -8.318776870e-02f, -8.322445278e-02f, -8.326098389e-02f, -8.329736200e-02f,
-8.333358708e-02f, -8.336965912e-02f, -8.340557809e-02f, -8.344134398e-02f, -8.347695674e-02f, -8.351241638e-02f, -8.354772285e-02f, -8.358287615e-02f, -8.361787624e-02f, -8.365272312e-02f,
-8.368741675e-02f, -8.372195712e-02f, -8.375634420e-02f, -8.379057799e-02f, -8.382465845e-02f, -8.385858557e-02f, -8.389235932e-02f, -8.392597970e-02f, -8.395944668e-02f, -8.399276024e-02f,
-8.402592036e-02f, -8.405892703e-02f, -8.409178023e-02f, -8.412447994e-02f, -8.415702614e-02f, -8.418941882e-02f, -8.422165796e-02f, -8.425374355e-02f, -8.428567556e-02f, -8.431745399e-02f,
-8.434907881e-02f, -8.438055001e-02f, -8.441186758e-02f, -8.444303150e-02f, -8.447404175e-02f, -8.450489833e-02f, -8.453560122e-02f, -8.456615040e-02f, -8.459654586e-02f, -8.462678759e-02f,
-8.465687557e-02f, -8.468680980e-02f, -8.471659025e-02f, -8.474621693e-02f, -8.477568980e-02f, -8.480500888e-02f, -8.483417413e-02f, -8.486318555e-02f, -8.489204314e-02f, -8.492074687e-02f,
-8.494929674e-02f, -8.497769274e-02f, -8.500593486e-02f, -8.503402309e-02f, -8.506195742e-02f, -8.508973784e-02f, -8.511736434e-02f, -8.514483691e-02f, -8.517215555e-02f, -8.519932024e-02f,
-8.522633099e-02f, -8.525318777e-02f, -8.527989059e-02f, -8.530643944e-02f, -8.533283431e-02f, -8.535907519e-02f, -8.538516207e-02f, -8.541109496e-02f, -8.543687385e-02f, -8.546249872e-02f,
-8.548796958e-02f, -8.551328642e-02f, -8.553844923e-02f, -8.556345802e-02f, -8.558831277e-02f, -8.561301348e-02f, -8.563756015e-02f, -8.566195278e-02f, -8.568619136e-02f, -8.571027589e-02f,
-8.573420636e-02f, -8.575798278e-02f, -8.578160514e-02f, -8.580507344e-02f, -8.582838768e-02f, -8.585154786e-02f, -8.587455397e-02f, -8.589740602e-02f, -8.592010400e-02f, -8.594264792e-02f,
-8.596503777e-02f, -8.598727355e-02f, -8.600935527e-02f, -8.603128292e-02f, -8.605305651e-02f, -8.607467604e-02f, -8.609614150e-02f, -8.611745291e-02f, -8.613861026e-02f, -8.615961355e-02f,
-8.618046279e-02f, -8.620115798e-02f, -8.622169913e-02f, -8.624208623e-02f, -8.626231928e-02f, -8.628239831e-02f, -8.630232330e-02f, -8.632209426e-02f, -8.634171119e-02f, -8.636117411e-02f,
-8.638048301e-02f, -8.639963791e-02f, -8.641863880e-02f, -8.643748569e-02f, -8.645617859e-02f, -8.647471751e-02f, -8.649310245e-02f, -8.651133342e-02f, -8.652941042e-02f, -8.654733346e-02f,
-8.656510256e-02f, -8.658271771e-02f, -8.660017893e-02f, -8.661748622e-02f, -8.663463960e-02f, -8.665163907e-02f, -8.666848463e-02f, -8.668517631e-02f, -8.670171411e-02f, -8.671809804e-02f,
-8.673432811e-02f, -8.675040433e-02f, -8.676632671e-02f, -8.678209526e-02f, -8.679771000e-02f, -8.681317093e-02f, -8.682847806e-02f, -8.684363142e-02f, -8.685863100e-02f, -8.687347683e-02f,
-8.688816891e-02f, -8.690270726e-02f, -8.691709189e-02f, -8.693132281e-02f, -8.694540005e-02f, -8.695932360e-02f, -8.697309350e-02f, -8.698670974e-02f, -8.700017235e-02f, -8.701348134e-02f,
-8.702663672e-02f, -8.703963852e-02f, -8.705248674e-02f, -8.706518141e-02f, -8.707772253e-02f, -8.709011013e-02f, -8.710234423e-02f, -8.711442483e-02f, -8.712635196e-02f, -8.713812563e-02f,
-8.714974586e-02f, -8.716121267e-02f, -8.717252609e-02f, -8.718368611e-02f, -8.719469277e-02f, -8.720554609e-02f, -8.721624608e-02f, -8.722679276e-02f, -8.723718615e-02f, -8.724742628e-02f,
-8.725751316e-02f, -8.726744681e-02f, -8.727722725e-02f, -8.728685451e-02f, -8.729632861e-02f, -8.730564956e-02f, -8.731481739e-02f, -8.732383212e-02f, -8.733269378e-02f, -8.734140238e-02f,
-8.734995795e-02f, -8.735836052e-02f, -8.736661009e-02f, -8.737470671e-02f, -8.738265038e-02f, -8.739044115e-02f, -8.739807902e-02f, -8.740556403e-02f, -8.741289619e-02f, -8.742007554e-02f,
-8.742710211e-02f, -8.743397590e-02f, -8.744069696e-02f, -8.744726530e-02f, -8.745368096e-02f, -8.745994395e-02f, -8.746605431e-02f, -8.747201207e-02f, -8.747781724e-02f, -8.748346986e-02f,
-8.748896996e-02f, -8.749431756e-02f, -8.749951270e-02f, -8.750455539e-02f, -8.750944567e-02f, -8.751418357e-02f, -8.751876912e-02f, -8.752320234e-02f, -8.752748327e-02f, -8.753161193e-02f,
-8.753558836e-02f, -8.753941259e-02f, -8.754308464e-02f, -8.754660456e-02f, -8.754997236e-02f, -8.755318808e-02f, -8.755625176e-02f, -8.755916342e-02f, -8.756192309e-02f, -8.756453082e-02f,
-8.756698662e-02f, -8.756929054e-02f, -8.757144261e-02f, -8.757344286e-02f, -8.757529132e-02f, -8.757698804e-02f, -8.757853303e-02f, -8.757992634e-02f, -8.758116800e-02f, -8.758225805e-02f,
-8.758319652e-02f, -8.758398345e-02f, -8.758461887e-02f, -8.758510282e-02f, -8.758543533e-02f, -8.758561644e-02f, -8.758564619e-02f, -8.758552462e-02f, -8.758525175e-02f, -8.758482763e-02f,
-8.758425230e-02f, -8.758352579e-02f, -8.758264815e-02f, -8.758161940e-02f, -8.758043959e-02f, -8.757910876e-02f, -8.757762695e-02f, -8.757599419e-02f, -8.757421053e-02f, -8.757227600e-02f,
-8.757019064e-02f, -8.756795450e-02f, -8.756556762e-02f, -8.756303003e-02f, -8.756034178e-02f, -8.755750290e-02f, -8.755451345e-02f, -8.755137345e-02f, -8.754808296e-02f, -8.754464202e-02f,
-8.754105066e-02f, -8.753730893e-02f, -8.753341688e-02f, -8.752937454e-02f, -8.752518196e-02f, -8.752083918e-02f, -8.751634625e-02f, -8.751170322e-02f, -8.750691011e-02f, -8.750196699e-02f,
-8.749687389e-02f, -8.749163086e-02f, -8.748623795e-02f, -8.748069519e-02f, -8.747500265e-02f, -8.746916035e-02f, -8.746316835e-02f, -8.745702670e-02f, -8.745073544e-02f, -8.744429462e-02f,
-8.743770428e-02f, -8.743096448e-02f, -8.742407525e-02f, -8.741703666e-02f, -8.740984874e-02f, -8.740251155e-02f, -8.739502513e-02f, -8.738738953e-02f, -8.737960481e-02f, -8.737167100e-02f,
-8.736358817e-02f, -8.735535636e-02f, -8.734697561e-02f, -8.733844599e-02f, -8.732976754e-02f, -8.732094031e-02f, -8.731196435e-02f, -8.730283972e-02f, -8.729356646e-02f, -8.728414463e-02f,
-8.727457428e-02f, -8.726485546e-02f, -8.725498822e-02f, -8.724497262e-02f, -8.723480871e-02f, -8.722449655e-02f, -8.721403617e-02f, -8.720342765e-02f, -8.719267103e-02f, -8.718176636e-02f,
-8.717071371e-02f, -8.715951312e-02f, -8.714816466e-02f, -8.713666836e-02f, -8.712502430e-02f, -8.711323253e-02f, -8.710129310e-02f, -8.708920606e-02f, -8.707697148e-02f, -8.706458941e-02f,
-8.705205990e-02f, -8.703938302e-02f, -8.702655882e-02f, -8.701358736e-02f, -8.700046869e-02f, -8.698720288e-02f, -8.697378998e-02f, -8.696023005e-02f, -8.694652314e-02f, -8.693266932e-02f,
-8.691866865e-02f, -8.690452119e-02f, -8.689022698e-02f, -8.687578610e-02f, -8.686119861e-02f, -8.684646456e-02f, -8.683158401e-02f, -8.681655703e-02f, -8.680138367e-02f, -8.678606400e-02f,
-8.677059807e-02f, -8.675498596e-02f, -8.673922772e-02f, -8.672332341e-02f, -8.670727309e-02f, -8.669107683e-02f, -8.667473469e-02f, -8.665824674e-02f, -8.664161303e-02f, -8.662483362e-02f,
-8.660790860e-02f, -8.659083800e-02f, -8.657362191e-02f, -8.655626038e-02f, -8.653875349e-02f, -8.652110128e-02f, -8.650330384e-02f, -8.648536121e-02f, -8.646727348e-02f, -8.644904070e-02f,
-8.643066294e-02f, -8.641214027e-02f, -8.639347275e-02f, -8.637466045e-02f, -8.635570344e-02f, -8.633660178e-02f, -8.631735554e-02f, -8.629796478e-02f, -8.627842959e-02f, -8.625875001e-02f,
-8.623892613e-02f, -8.621895800e-02f, -8.619884570e-02f, -8.617858930e-02f, -8.615818887e-02f, -8.613764446e-02f, -8.611695617e-02f, -8.609612404e-02f, -8.607514816e-02f, -8.605402860e-02f,
-8.603276541e-02f, -8.601135869e-02f, -8.598980848e-02f, -8.596811488e-02f, -8.594627794e-02f, -8.592429774e-02f, -8.590217435e-02f, -8.587990784e-02f, -8.585749828e-02f, -8.583494576e-02f,
-8.581225033e-02f, -8.578941207e-02f, -8.576643106e-02f, -8.574330737e-02f, -8.572004107e-02f, -8.569663223e-02f, -8.567308094e-02f, -8.564938725e-02f, -8.562555126e-02f, -8.560157302e-02f,
-8.557745263e-02f, -8.555319014e-02f, -8.552878564e-02f, -8.550423921e-02f, -8.547955091e-02f, -8.545472082e-02f, -8.542974903e-02f, -8.540463560e-02f, -8.537938062e-02f, -8.535398415e-02f,
-8.532844628e-02f, -8.530276708e-02f, -8.527694663e-02f, -8.525098502e-02f, -8.522488231e-02f, -8.519863858e-02f, -8.517225391e-02f, -8.514572839e-02f, -8.511906208e-02f, -8.509225508e-02f,
-8.506530745e-02f, -8.503821928e-02f, -8.501099064e-02f, -8.498362163e-02f, -8.495611230e-02f, -8.492846276e-02f, -8.490067307e-02f, -8.487274332e-02f, -8.484467358e-02f, -8.481646395e-02f,
-8.478811449e-02f, -8.475962530e-02f, -8.473099646e-02f, -8.470222803e-02f, -8.467332012e-02f, -8.464427280e-02f, -8.461508614e-02f, -8.458576025e-02f, -8.455629519e-02f, -8.452669106e-02f,
-8.449694793e-02f, -8.446706588e-02f, -8.443704501e-02f, -8.440688540e-02f, -8.437658713e-02f, -8.434615028e-02f, -8.431557495e-02f, -8.428486121e-02f, -8.425400914e-02f, -8.422301885e-02f,
-8.419189040e-02f, -8.416062389e-02f, -8.412921941e-02f, -8.409767703e-02f, -8.406599685e-02f, -8.403417894e-02f, -8.400222341e-02f, -8.397013033e-02f, -8.393789980e-02f, -8.390553190e-02f,
-8.387302671e-02f, -8.384038433e-02f, -8.380760484e-02f, -8.377468833e-02f, -8.374163490e-02f, -8.370844462e-02f, -8.367511759e-02f, -8.364165390e-02f, -8.360805364e-02f, -8.357431689e-02f,
-8.354044374e-02f, -8.350643429e-02f, -8.347228863e-02f, -8.343800684e-02f, -8.340358902e-02f, -8.336903526e-02f, -8.333434564e-02f, -8.329952026e-02f, -8.326455922e-02f, -8.322946259e-02f,
-8.319423048e-02f, -8.315886298e-02f, -8.312336017e-02f, -8.308772216e-02f, -8.305194903e-02f, -8.301604087e-02f, -8.297999778e-02f, -8.294381986e-02f, -8.290750719e-02f, -8.287105987e-02f,
-8.283447799e-02f, -8.279776165e-02f, -8.276091094e-02f, -8.272392595e-02f, -8.268680679e-02f, -8.264955354e-02f, -8.261216630e-02f, -8.257464517e-02f, -8.253699024e-02f, -8.249920160e-02f,
-8.246127936e-02f, -8.242322360e-02f, -8.238503443e-02f, -8.234671194e-02f, -8.230825623e-02f, -8.226966739e-02f, -8.223094553e-02f, -8.219209073e-02f, -8.215310310e-02f, -8.211398273e-02f,
-8.207472973e-02f, -8.203534418e-02f, -8.199582620e-02f, -8.195617586e-02f, -8.191639329e-02f, -8.187647857e-02f, -8.183643180e-02f, -8.179625308e-02f, -8.175594252e-02f, -8.171550020e-02f,
-8.167492624e-02f, -8.163422073e-02f, -8.159338377e-02f, -8.155241546e-02f, -8.151131591e-02f, -8.147008521e-02f, -8.142872346e-02f, -8.138723077e-02f, -8.134560723e-02f, -8.130385295e-02f,
-8.126196803e-02f, -8.121995258e-02f, -8.117780669e-02f, -8.113553047e-02f, -8.109312401e-02f, -8.105058743e-02f, -8.100792082e-02f, -8.096512429e-02f, -8.092219794e-02f, -8.087914188e-02f,
-8.083595621e-02f, -8.079264103e-02f, -8.074919644e-02f, -8.070562256e-02f, -8.066191948e-02f, -8.061808731e-02f, -8.057412616e-02f, -8.053003613e-02f, -8.048581732e-02f, -8.044146985e-02f,
-8.039699381e-02f, -8.035238931e-02f, -8.030765647e-02f, -8.026279537e-02f, -8.021780614e-02f, -8.017268888e-02f, -8.012744369e-02f, -8.008207068e-02f, -8.003656996e-02f, -7.999094164e-02f,
-7.994518582e-02f, -7.989930261e-02f, -7.985329213e-02f, -7.980715446e-02f, -7.976088974e-02f, -7.971449806e-02f, -7.966797953e-02f, -7.962133426e-02f, -7.957456237e-02f, -7.952766395e-02f,
-7.948063912e-02f, -7.943348800e-02f, -7.938621068e-02f, -7.933880728e-02f, -7.929127791e-02f, -7.924362268e-02f, -7.919584169e-02f, -7.914793507e-02f, -7.909990292e-02f, -7.905174536e-02f,
-7.900346248e-02f, -7.895505441e-02f, -7.890652126e-02f, -7.885786314e-02f, -7.880908016e-02f, -7.876017243e-02f, -7.871114007e-02f, -7.866198318e-02f, -7.861270189e-02f, -7.856329630e-02f,
-7.851376652e-02f, -7.846411268e-02f, -7.841433488e-02f, -7.836443323e-02f, -7.831440786e-02f, -7.826425887e-02f, -7.821398638e-02f, -7.816359051e-02f, -7.811307136e-02f, -7.806242906e-02f,
-7.801166371e-02f, -7.796077543e-02f, -7.790976435e-02f, -7.785863057e-02f, -7.780737420e-02f, -7.775599538e-02f, -7.770449420e-02f, -7.765287079e-02f, -7.760112526e-02f, -7.754925773e-02f,
-7.749726832e-02f, -7.744515715e-02f, -7.739292432e-02f, -7.734056996e-02f, -7.728809419e-02f, -7.723549712e-02f, -7.718277887e-02f, -7.712993956e-02f, -7.707697931e-02f, -7.702389823e-02f,
-7.697069644e-02f, -7.691737407e-02f, -7.686393123e-02f, -7.681036804e-02f, -7.675668461e-02f, -7.670288108e-02f, -7.664895755e-02f, -7.659491415e-02f, -7.654075100e-02f, -7.648646821e-02f,
-7.643206591e-02f, -7.637754422e-02f, -7.632290326e-02f, -7.626814315e-02f, -7.621326401e-02f, -7.615826596e-02f, -7.610314912e-02f, -7.604791361e-02f, -7.599255957e-02f, -7.593708709e-02f,
-7.588149632e-02f, -7.582578737e-02f, -7.576996036e-02f, -7.571401542e-02f, -7.565795267e-02f, -7.560177222e-02f, -7.554547421e-02f, -7.548905876e-02f, -7.543252599e-02f, -7.537587603e-02f,
-7.531910899e-02f, -7.526222500e-02f, -7.520522419e-02f, -7.514810667e-02f, -7.509087258e-02f, -7.503352204e-02f, -7.497605517e-02f, -7.491847210e-02f, -7.486077295e-02f, -7.480295785e-02f,
-7.474502692e-02f, -7.468698029e-02f, -7.462881808e-02f, -7.457054043e-02f, -7.451214745e-02f, -7.445363927e-02f, -7.439501602e-02f, -7.433627782e-02f, -7.427742480e-02f, -7.421845709e-02f,
-7.415937482e-02f, -7.410017811e-02f, -7.404086708e-02f, -7.398144188e-02f, -7.392190261e-02f, -7.386224942e-02f, -7.380248243e-02f, -7.374260176e-02f, -7.368260756e-02f, -7.362249993e-02f,
-7.356227902e-02f, -7.350194495e-02f, -7.344149785e-02f, -7.338093785e-02f, -7.332026507e-02f, -7.325947966e-02f, -7.319858173e-02f, -7.313757142e-02f, -7.307644886e-02f, -7.301521417e-02f,
-7.295386749e-02f, -7.289240895e-02f, -7.283083867e-02f, -7.276915680e-02f, -7.270736345e-02f, -7.264545876e-02f, -7.258344286e-02f, -7.252131589e-02f, -7.245907796e-02f, -7.239672923e-02f,
-7.233426981e-02f, -7.227169984e-02f, -7.220901944e-02f, -7.214622877e-02f, -7.208332793e-02f, -7.202031708e-02f, -7.195719633e-02f, -7.189396583e-02f, -7.183062571e-02f, -7.176717609e-02f,
-7.170361711e-02f, -7.163994891e-02f, -7.157617162e-02f, -7.151228538e-02f, -7.144829031e-02f, -7.138418655e-02f, -7.131997423e-02f, -7.125565350e-02f, -7.119122448e-02f, -7.112668730e-02f,
-7.106204211e-02f, -7.099728904e-02f, -7.093242822e-02f, -7.086745979e-02f, -7.080238388e-02f, -7.073720063e-02f, -7.067191018e-02f, -7.060651266e-02f, -7.054100820e-02f, -7.047539695e-02f,
-7.040967903e-02f, -7.034385459e-02f, -7.027792376e-02f, -7.021188668e-02f, -7.014574349e-02f, -7.007949432e-02f, -7.001313931e-02f, -6.994667859e-02f, -6.988011231e-02f, -6.981344060e-02f,
-6.974666360e-02f, -6.967978145e-02f, -6.961279428e-02f, -6.954570224e-02f, -6.947850545e-02f, -6.941120407e-02f, -6.934379823e-02f, -6.927628806e-02f, -6.920867372e-02f, -6.914095532e-02f,
-6.907313302e-02f, -6.900520696e-02f, -6.893717727e-02f, -6.886904409e-02f, -6.880080756e-02f, -6.873246783e-02f, -6.866402503e-02f, -6.859547930e-02f, -6.852683079e-02f, -6.845807962e-02f,
-6.838922596e-02f, -6.832026992e-02f, -6.825121167e-02f, -6.818205133e-02f, -6.811278904e-02f, -6.804342496e-02f, -6.797395922e-02f, -6.790439195e-02f, -6.783472332e-02f, -6.776495344e-02f,
-6.769508248e-02f, -6.762511056e-02f, -6.755503784e-02f, -6.748486445e-02f, -6.741459054e-02f, -6.734421624e-02f, -6.727374171e-02f, -6.720316709e-02f, -6.713249251e-02f, -6.706171812e-02f,
-6.699084407e-02f, -6.691987049e-02f, -6.684879754e-02f, -6.677762535e-02f, -6.670635407e-02f, -6.663498385e-02f, -6.656351482e-02f, -6.649194713e-02f, -6.642028093e-02f, -6.634851636e-02f,
-6.627665357e-02f, -6.620469270e-02f, -6.613263389e-02f, -6.606047729e-02f, -6.598822304e-02f, -6.591587130e-02f, -6.584342220e-02f, -6.577087589e-02f, -6.569823252e-02f, -6.562549224e-02f,
-6.555265518e-02f, -6.547972150e-02f, -6.540669134e-02f, -6.533356485e-02f, -6.526034217e-02f, -6.518702345e-02f, -6.511360884e-02f, -6.504009848e-02f, -6.496649253e-02f, -6.489279112e-02f,
-6.481899441e-02f, -6.474510254e-02f, -6.467111567e-02f, -6.459703393e-02f, -6.452285748e-02f, -6.444858646e-02f, -6.437422102e-02f, -6.429976132e-02f, -6.422520749e-02f, -6.415055969e-02f,
-6.407581806e-02f, -6.400098276e-02f, -6.392605393e-02f, -6.385103173e-02f, -6.377591629e-02f, -6.370070777e-02f, -6.362540632e-02f, -6.355001209e-02f, -6.347452523e-02f, -6.339894589e-02f,
-6.332327421e-02f, -6.324751035e-02f, -6.317165445e-02f, -6.309570668e-02f, -6.301966717e-02f, -6.294353607e-02f, -6.286731355e-02f, -6.279099974e-02f, -6.271459481e-02f, -6.263809889e-02f,
-6.256151215e-02f, -6.248483472e-02f, -6.240806677e-02f, -6.233120845e-02f, -6.225425990e-02f, -6.217722128e-02f, -6.210009273e-02f, -6.202287442e-02f, -6.194556649e-02f, -6.186816910e-02f,
-6.179068239e-02f, -6.171310652e-02f, -6.163544165e-02f, -6.155768791e-02f, -6.147984548e-02f, -6.140191449e-02f, -6.132389511e-02f, -6.124578747e-02f, -6.116759175e-02f, -6.108930809e-02f,
-6.101093664e-02f, -6.093247756e-02f, -6.085393101e-02f, -6.077529712e-02f, -6.069657607e-02f, -6.061776799e-02f, -6.053887306e-02f, -6.045989141e-02f, -6.038082321e-02f, -6.030166860e-02f,
-6.022242775e-02f, -6.014310081e-02f, -6.006368793e-02f, -5.998418926e-02f, -5.990460497e-02f, -5.982493520e-02f, -5.974518012e-02f, -5.966533987e-02f, -5.958541461e-02f, -5.950540450e-02f,
-5.942530969e-02f, -5.934513034e-02f, -5.926486661e-02f, -5.918451864e-02f, -5.910408660e-02f, -5.902357065e-02f, -5.894297093e-02f, -5.886228760e-02f, -5.878152082e-02f, -5.870067075e-02f,
-5.861973755e-02f, -5.853872136e-02f, -5.845762235e-02f, -5.837644067e-02f, -5.829517649e-02f, -5.821382995e-02f, -5.813240121e-02f, -5.805089044e-02f, -5.796929778e-02f, -5.788762341e-02f,
-5.780586746e-02f, -5.772403011e-02f, -5.764211151e-02f, -5.756011181e-02f, -5.747803118e-02f, -5.739586977e-02f, -5.731362775e-02f, -5.723130526e-02f, -5.714890248e-02f, -5.706641954e-02f,
-5.698385663e-02f, -5.690121389e-02f, -5.681849148e-02f, -5.673568956e-02f, -5.665280829e-02f, -5.656984783e-02f, -5.648680834e-02f, -5.640368998e-02f, -5.632049291e-02f, -5.623721728e-02f,
-5.615386326e-02f, -5.607043100e-02f, -5.598692067e-02f, -5.590333242e-02f, -5.581966642e-02f, -5.573592283e-02f, -5.565210180e-02f, -5.556820349e-02f, -5.548422807e-02f, -5.540017570e-02f,
-5.531604653e-02f, -5.523184074e-02f, -5.514755847e-02f, -5.506319988e-02f, -5.497876515e-02f, -5.489425443e-02f, -5.480966788e-02f, -5.472500566e-02f, -5.464026794e-02f, -5.455545487e-02f,
-5.447056662e-02f, -5.438560334e-02f, -5.430056521e-02f, -5.421545238e-02f, -5.413026501e-02f, -5.404500326e-02f, -5.395966731e-02f, -5.387425730e-02f, -5.378877340e-02f, -5.370321577e-02f,
-5.361758459e-02f, -5.353188000e-02f, -5.344610216e-02f, -5.336025126e-02f, -5.327432744e-02f, -5.318833086e-02f, -5.310226170e-02f, -5.301612011e-02f, -5.292990626e-02f, -5.284362031e-02f,
-5.275726242e-02f, -5.267083276e-02f, -5.258433149e-02f, -5.249775877e-02f, -5.241111477e-02f, -5.232439965e-02f, -5.223761357e-02f, -5.215075670e-02f, -5.206382921e-02f, -5.197683124e-02f,
-5.188976298e-02f, -5.180262458e-02f, -5.171541621e-02f, -5.162813803e-02f, -5.154079021e-02f, -5.145337290e-02f, -5.136588629e-02f, -5.127833052e-02f, -5.119070576e-02f, -5.110301219e-02f,
-5.101524996e-02f, -5.092741924e-02f, -5.083952019e-02f, -5.075155298e-02f, -5.066351777e-02f, -5.057541474e-02f, -5.048724403e-02f, -5.039900583e-02f, -5.031070029e-02f, -5.022232758e-02f,
-5.013388787e-02f, -5.004538132e-02f, -4.995680810e-02f, -4.986816837e-02f, -4.977946230e-02f, -4.969069005e-02f, -4.960185180e-02f, -4.951294770e-02f, -4.942397793e-02f, -4.933494265e-02f,
-4.924584202e-02f, -4.915667621e-02f, -4.906744539e-02f, -4.897814973e-02f, -4.888878939e-02f, -4.879936454e-02f, -4.870987534e-02f, -4.862032197e-02f, -4.853070459e-02f, -4.844102336e-02f,
-4.835127845e-02f, -4.826147004e-02f, -4.817159828e-02f, -4.808166334e-02f, -4.799166540e-02f, -4.790160462e-02f, -4.781148116e-02f, -4.772129520e-02f, -4.763104690e-02f, -4.754073643e-02f,
-4.745036396e-02f, -4.735992965e-02f, -4.726943367e-02f, -4.717887620e-02f, -4.708825739e-02f, -4.699757742e-02f, -4.690683646e-02f, -4.681603467e-02f, -4.672517222e-02f, -4.663424928e-02f,
-4.654326602e-02f, -4.645222260e-02f, -4.636111920e-02f, -4.626995598e-02f, -4.617873312e-02f, -4.608745078e-02f, -4.599610912e-02f, -4.590470833e-02f, -4.581324856e-02f, -4.572172999e-02f,
-4.563015278e-02f, -4.553851711e-02f, -4.544682314e-02f, -4.535507105e-02f, -4.526326099e-02f, -4.517139315e-02f, -4.507946769e-02f, -4.498748478e-02f, -4.489544459e-02f, -4.480334729e-02f,
-4.471119305e-02f, -4.461898203e-02f, -4.452671442e-02f, -4.443439037e-02f, -4.434201006e-02f, -4.424957365e-02f, -4.415708133e-02f, -4.406453325e-02f, -4.397192959e-02f, -4.387927052e-02f,
-4.378655621e-02f, -4.369378683e-02f, -4.360096254e-02f, -4.350808352e-02f, -4.341514995e-02f, -4.332216198e-02f, -4.322911979e-02f, -4.313602356e-02f, -4.304287344e-02f, -4.294966962e-02f,
-4.285641226e-02f, -4.276310153e-02f, -4.266973761e-02f, -4.257632067e-02f, -4.248285087e-02f, -4.238932839e-02f, -4.229575340e-02f, -4.220212606e-02f, -4.210844656e-02f, -4.201471506e-02f,
-4.192093173e-02f, -4.182709675e-02f, -4.173321028e-02f, -4.163927250e-02f, -4.154528358e-02f, -4.145124369e-02f, -4.135715300e-02f, -4.126301168e-02f, -4.116881991e-02f, -4.107457785e-02f,
-4.098028569e-02f, -4.088594358e-02f, -4.079155170e-02f, -4.069711023e-02f, -4.060261934e-02f, -4.050807919e-02f, -4.041348996e-02f, -4.031885182e-02f, -4.022416495e-02f, -4.012942951e-02f,
-4.003464568e-02f, -3.993981363e-02f, -3.984493353e-02f, -3.975000556e-02f, -3.965502988e-02f, -3.956000668e-02f, -3.946493611e-02f, -3.936981836e-02f, -3.927465360e-02f, -3.917944199e-02f,
-3.908418372e-02f, -3.898887896e-02f, -3.889352787e-02f, -3.879813063e-02f, -3.870268741e-02f, -3.860719839e-02f, -3.851166374e-02f, -3.841608363e-02f, -3.832045823e-02f, -3.822478772e-02f,
-3.812907227e-02f, -3.803331206e-02f, -3.793750725e-02f, -3.784165802e-02f, -3.774576454e-02f, -3.764982699e-02f, -3.755384554e-02f, -3.745782036e-02f, -3.736175163e-02f, -3.726563951e-02f,
-3.716948419e-02f, -3.707328583e-02f, -3.697704461e-02f, -3.688076071e-02f, -3.678443429e-02f, -3.668806553e-02f, -3.659165460e-02f, -3.649520168e-02f, -3.639870694e-02f, -3.630217056e-02f,
-3.620559270e-02f, -3.610897355e-02f, -3.601231326e-02f, -3.591561203e-02f, -3.581887002e-02f, -3.572208741e-02f, -3.562526437e-02f, -3.552840107e-02f, -3.543149770e-02f, -3.533455441e-02f,
-3.523757139e-02f, -3.514054881e-02f, -3.504348685e-02f, -3.494638567e-02f, -3.484924546e-02f, -3.475206638e-02f, -3.465484862e-02f, -3.455759234e-02f, -3.446029772e-02f, -3.436296493e-02f,
-3.426559415e-02f, -3.416818556e-02f, -3.407073932e-02f, -3.397325561e-02f, -3.387573461e-02f, -3.377817649e-02f, -3.368058142e-02f, -3.358294958e-02f, -3.348528114e-02f, -3.338757628e-02f,
-3.328983518e-02f, -3.319205800e-02f, -3.309424492e-02f, -3.299639611e-02f, -3.289851176e-02f, -3.280059204e-02f, -3.270263711e-02f, -3.260464716e-02f, -3.250662236e-02f, -3.240856288e-02f,
-3.231046890e-02f, -3.221234059e-02f, -3.211417813e-02f, -3.201598170e-02f, -3.191775146e-02f, -3.181948760e-02f, -3.172119028e-02f, -3.162285969e-02f, -3.152449599e-02f, -3.142609937e-02f,
-3.132766999e-02f, -3.122920803e-02f, -3.113071368e-02f, -3.103218709e-02f, -3.093362845e-02f, -3.083503794e-02f, -3.073641572e-02f, -3.063776197e-02f, -3.053907688e-02f, -3.044036060e-02f,
-3.034161332e-02f, -3.024283521e-02f, -3.014402646e-02f, -3.004518722e-02f, -2.994631768e-02f, -2.984741802e-02f, -2.974848841e-02f, -2.964952901e-02f, -2.955054002e-02f, -2.945152160e-02f,
-2.935247393e-02f, -2.925339719e-02f, -2.915429154e-02f, -2.905515717e-02f, -2.895599425e-02f, -2.885680296e-02f, -2.875758347e-02f, -2.865833595e-02f, -2.855906058e-02f, -2.845975754e-02f,
-2.836042701e-02f, -2.826106915e-02f, -2.816168414e-02f, -2.806227216e-02f, -2.796283339e-02f, -2.786336799e-02f, -2.776387615e-02f, -2.766435804e-02f, -2.756481383e-02f, -2.746524370e-02f,
-2.736564783e-02f, -2.726602639e-02f, -2.716637956e-02f, -2.706670751e-02f, -2.696701041e-02f, -2.686728845e-02f, -2.676754180e-02f, -2.666777063e-02f, -2.656797512e-02f, -2.646815545e-02f,
-2.636831178e-02f, -2.626844430e-02f, -2.616855318e-02f, -2.606863860e-02f, -2.596870073e-02f, -2.586873975e-02f, -2.576875583e-02f, -2.566874914e-02f, -2.556871987e-02f, -2.546866819e-02f,
-2.536859428e-02f, -2.526849831e-02f, -2.516838045e-02f, -2.506824088e-02f, -2.496807977e-02f, -2.486789731e-02f, -2.476769367e-02f, -2.466746902e-02f, -2.456722354e-02f, -2.446695740e-02f,
-2.436667078e-02f, -2.426636385e-02f, -2.416603680e-02f, -2.406568979e-02f, -2.396532300e-02f, -2.386493661e-02f, -2.376453079e-02f, -2.366410571e-02f, -2.356366156e-02f, -2.346319850e-02f,
-2.336271672e-02f, -2.326221639e-02f, -2.316169768e-02f, -2.306116077e-02f, -2.296060584e-02f, -2.286003305e-02f, -2.275944259e-02f, -2.265883464e-02f, -2.255820935e-02f, -2.245756692e-02f,
-2.235690752e-02f, -2.225623132e-02f, -2.215553849e-02f, -2.205482922e-02f, -2.195410368e-02f, -2.185336204e-02f, -2.175260447e-02f, -2.165183116e-02f, -2.155104229e-02f, -2.145023801e-02f,
-2.134941851e-02f, -2.124858397e-02f, -2.114773456e-02f, -2.104687045e-02f, -2.094599183e-02f, -2.084509886e-02f, -2.074419172e-02f, -2.064327058e-02f, -2.054233563e-02f, -2.044138703e-02f,
-2.034042496e-02f, -2.023944960e-02f, -2.013846112e-02f, -2.003745969e-02f, -1.993644550e-02f, -1.983541871e-02f, -1.973437950e-02f, -1.963332805e-02f, -1.953226453e-02f, -1.943118912e-02f,
-1.933010199e-02f, -1.922900331e-02f, -1.912789326e-02f, -1.902677202e-02f, -1.892563976e-02f, -1.882449666e-02f, -1.872334288e-02f, -1.862217861e-02f, -1.852100402e-02f, -1.841981928e-02f,
-1.831862458e-02f, -1.821742007e-02f, -1.811620595e-02f, -1.801498238e-02f, -1.791374953e-02f, -1.781250759e-02f, -1.771125673e-02f, -1.760999712e-02f, -1.750872893e-02f, -1.740745234e-02f,
-1.730616753e-02f, -1.720487467e-02f, -1.710357394e-02f, -1.700226550e-02f, -1.690094953e-02f, -1.679962622e-02f, -1.669829572e-02f, -1.659695822e-02f, -1.649561390e-02f, -1.639426291e-02f,
-1.629290545e-02f, -1.619154168e-02f, -1.609017178e-02f, -1.598879592e-02f, -1.588741427e-02f, -1.578602702e-02f, -1.568463432e-02f, -1.558323637e-02f, -1.548183333e-02f, -1.538042538e-02f,
-1.527901269e-02f, -1.517759543e-02f, -1.507617378e-02f, -1.497474791e-02f, -1.487331800e-02f, -1.477188421e-02f, -1.467044673e-02f, -1.456900573e-02f, -1.446756138e-02f, -1.436611386e-02f,
-1.426466333e-02f, -1.416320998e-02f, -1.406175397e-02f, -1.396029549e-02f, -1.385883469e-02f, -1.375737176e-02f, -1.365590688e-02f, -1.355444020e-02f, -1.345297192e-02f, -1.335150219e-02f,
-1.325003120e-02f, -1.314855911e-02f, -1.304708611e-02f, -1.294561236e-02f, -1.284413803e-02f, -1.274266331e-02f, -1.264118836e-02f, -1.253971336e-02f, -1.243823847e-02f, -1.233676388e-02f,
-1.223528976e-02f, -1.213381627e-02f, -1.203234359e-02f, -1.193087190e-02f, -1.182940137e-02f, -1.172793216e-02f, -1.162646446e-02f, -1.152499844e-02f, -1.142353426e-02f, -1.132207210e-02f,
-1.122061214e-02f, -1.111915454e-02f, -1.101769948e-02f, -1.091624714e-02f, -1.081479767e-02f, -1.071335127e-02f, -1.061190809e-02f, -1.051046831e-02f, -1.040903211e-02f, -1.030759965e-02f,
-1.020617110e-02f, -1.010474665e-02f, -1.000332646e-02f, -9.901910704e-03f, -9.800499553e-03f, -9.699093180e-03f, -9.597691756e-03f, -9.496295454e-03f, -9.394904446e-03f, -9.293518904e-03f,
-9.192138998e-03f, -9.090764901e-03f, -8.989396785e-03f, -8.888034821e-03f, -8.786679180e-03f, -8.685330035e-03f, -8.583987557e-03f, -8.482651916e-03f, -8.381323286e-03f, -8.280001836e-03f,
-8.178687738e-03f, -8.077381164e-03f, -7.976082284e-03f, -7.874791270e-03f, -7.773508293e-03f, -7.672233524e-03f, -7.570967134e-03f, -7.469709294e-03f, -7.368460174e-03f, -7.267219946e-03f,
-7.165988780e-03f, -7.064766848e-03f, -6.963554319e-03f, -6.862351365e-03f, -6.761158156e-03f, -6.659974862e-03f, -6.558801654e-03f, -6.457638703e-03f, -6.356486179e-03f, -6.255344252e-03f,
-6.154213092e-03f, -6.053092871e-03f, -5.951983757e-03f, -5.850885920e-03f, -5.749799532e-03f, -5.648724762e-03f, -5.547661780e-03f, -5.446610756e-03f, -5.345571859e-03f, -5.244545260e-03f,
-5.143531128e-03f, -5.042529632e-03f, -4.941540944e-03f, -4.840565231e-03f, -4.739602663e-03f, -4.638653410e-03f, -4.537717642e-03f, -4.436795527e-03f, -4.335887235e-03f, -4.234992935e-03f,
-4.134112796e-03f, -4.033246988e-03f, -3.932395679e-03f, -3.831559037e-03f, -3.730737233e-03f, -3.629930435e-03f, -3.529138812e-03f, -3.428362532e-03f, -3.327601764e-03f, -3.226856677e-03f,
-3.126127439e-03f, -3.025414219e-03f, -2.924717185e-03f, -2.824036505e-03f, -2.723372349e-03f, -2.622724883e-03f, -2.522094276e-03f, -2.421480696e-03f, -2.320884312e-03f, -2.220305291e-03f,
-2.119743801e-03f, -2.019200009e-03f, -1.918674085e-03f, -1.818166195e-03f, -1.717676507e-03f, -1.617205189e-03f, -1.516752407e-03f, -1.416318331e-03f, -1.315903126e-03f, -1.215506960e-03f,
-1.115130001e-03f, -1.014772416e-03f, -9.144343714e-04f, -8.141160346e-04f, -7.138175726e-04f, -6.135391523e-04f, -5.132809405e-04f, -4.130431039e-04f, -3.128258093e-04f, -2.126292233e-04f,
-1.124535124e-04f, -1.229884321e-05f, 8.783461798e-05f, 1.879467048e-04f, 2.880372509e-04f, 3.881060902e-04f, 4.881530565e-04f, 5.881779837e-04f, 6.881807059e-04f, 7.881610572e-04f,
8.881188716e-04f, 9.880539835e-04f, 1.087966227e-03f, 1.187855437e-03f, 1.287721447e-03f, 1.387564092e-03f, 1.487383207e-03f, 1.587178627e-03f, 1.686950185e-03f, 1.786697718e-03f,
1.886421059e-03f, 1.986120044e-03f, 2.085794508e-03f, 2.185444286e-03f, 2.285069213e-03f, 2.384669124e-03f, 2.484243855e-03f, 2.583793241e-03f, 2.683317118e-03f, 2.782815322e-03f,
2.882287687e-03f, 2.981734050e-03f, 3.081154246e-03f, 3.180548112e-03f, 3.279915483e-03f, 3.379256196e-03f, 3.478570086e-03f, 3.577856990e-03f, 3.677116744e-03f, 3.776349184e-03f,
3.875554147e-03f, 3.974731470e-03f, 4.073880989e-03f, 4.173002540e-03f, 4.272095961e-03f, 4.371161088e-03f, 4.470197758e-03f, 4.569205808e-03f, 4.668185076e-03f, 4.767135399e-03f,
4.866056613e-03f, 4.964948557e-03f, 5.063811067e-03f, 5.162643981e-03f, 5.261447136e-03f, 5.360220372e-03f, 5.458963524e-03f, 5.557676431e-03f, 5.656358932e-03f, 5.755010863e-03f,
5.853632063e-03f, 5.952222371e-03f, 6.050781624e-03f, 6.149309661e-03f, 6.247806320e-03f, 6.346271440e-03f, 6.444704860e-03f, 6.543106417e-03f, 6.641475952e-03f, 6.739813303e-03f,
6.838118308e-03f, 6.936390808e-03f, 7.034630640e-03f, 7.132837645e-03f, 7.231011661e-03f, 7.329152529e-03f, 7.427260087e-03f, 7.525334175e-03f, 7.623374633e-03f, 7.721381300e-03f,
7.819354017e-03f, 7.917292623e-03f, 8.015196959e-03f, 8.113066864e-03f, 8.210902179e-03f, 8.308702744e-03f, 8.406468400e-03f, 8.504198986e-03f, 8.601894344e-03f, 8.699554315e-03f,
8.797178738e-03f, 8.894767456e-03f, 8.992320308e-03f, 9.089837136e-03f, 9.187317782e-03f, 9.284762086e-03f, 9.382169889e-03f, 9.479541034e-03f, 9.576875361e-03f, 9.674172712e-03f,
9.771432930e-03f, 9.868655855e-03f, 9.965841330e-03f, 1.006298920e-02f, 1.016009930e-02f, 1.025717147e-02f, 1.035420557e-02f, 1.045120142e-02f, 1.054815888e-02f, 1.064507779e-02f,
1.074195798e-02f, 1.083879930e-02f, 1.093560160e-02f, 1.103236472e-02f, 1.112908849e-02f, 1.122577277e-02f, 1.132241740e-02f, 1.141902221e-02f, 1.151558706e-02f, 1.161211179e-02f,
1.170859623e-02f, 1.180504024e-02f, 1.190144366e-02f, 1.199780634e-02f, 1.209412810e-02f, 1.219040881e-02f, 1.228664830e-02f, 1.238284643e-02f, 1.247900302e-02f, 1.257511794e-02f,
1.267119102e-02f, 1.276722210e-02f, 1.286321104e-02f, 1.295915767e-02f, 1.305506185e-02f, 1.315092342e-02f, 1.324674222e-02f, 1.334251810e-02f, 1.343825090e-02f, 1.353394047e-02f,
1.362958666e-02f, 1.372518930e-02f, 1.382074826e-02f, 1.391626337e-02f, 1.401173448e-02f, 1.410716143e-02f, 1.420254408e-02f, 1.429788226e-02f, 1.439317583e-02f, 1.448842463e-02f,
1.458362851e-02f, 1.467878732e-02f, 1.477390090e-02f, 1.486896909e-02f, 1.496399176e-02f, 1.505896873e-02f, 1.515389987e-02f, 1.524878502e-02f, 1.534362403e-02f, 1.543841673e-02f,
1.553316300e-02f, 1.562786266e-02f, 1.572251557e-02f, 1.581712157e-02f, 1.591168052e-02f, 1.600619227e-02f, 1.610065665e-02f, 1.619507353e-02f, 1.628944275e-02f, 1.638376415e-02f,
1.647803759e-02f, 1.657226292e-02f, 1.666643998e-02f, 1.676056862e-02f, 1.685464870e-02f, 1.694868007e-02f, 1.704266256e-02f, 1.713659604e-02f, 1.723048036e-02f, 1.732431535e-02f,
1.741810088e-02f, 1.751183679e-02f, 1.760552294e-02f, 1.769915916e-02f, 1.779274533e-02f, 1.788628127e-02f, 1.797976686e-02f, 1.807320193e-02f, 1.816658634e-02f, 1.825991993e-02f,
1.835320257e-02f, 1.844643410e-02f, 1.853961437e-02f, 1.863274324e-02f, 1.872582055e-02f, 1.881884616e-02f, 1.891181992e-02f, 1.900474169e-02f, 1.909761130e-02f, 1.919042863e-02f,
1.928319351e-02f, 1.937590581e-02f, 1.946856537e-02f, 1.956117204e-02f, 1.965372569e-02f, 1.974622616e-02f, 1.983867331e-02f, 1.993106698e-02f, 2.002340704e-02f, 2.011569334e-02f,
2.020792572e-02f, 2.030010405e-02f, 2.039222818e-02f, 2.048429795e-02f, 2.057631324e-02f, 2.066827388e-02f, 2.076017974e-02f, 2.085203067e-02f, 2.094382652e-02f, 2.103556714e-02f,
2.112725240e-02f, 2.121888215e-02f, 2.131045625e-02f, 2.140197454e-02f, 2.149343688e-02f, 2.158484313e-02f, 2.167619315e-02f, 2.176748679e-02f, 2.185872390e-02f, 2.194990434e-02f,
2.204102798e-02f, 2.213209466e-02f, 2.222310423e-02f, 2.231405657e-02f, 2.240495152e-02f, 2.249578894e-02f, 2.258656869e-02f, 2.267729062e-02f, 2.276795459e-02f, 2.285856046e-02f,
2.294910809e-02f, 2.303959733e-02f, 2.313002804e-02f, 2.322040009e-02f, 2.331071331e-02f, 2.340096758e-02f, 2.349116276e-02f, 2.358129869e-02f, 2.367137525e-02f, 2.376139228e-02f,
2.385134965e-02f, 2.394124721e-02f, 2.403108483e-02f, 2.412086236e-02f, 2.421057967e-02f, 2.430023660e-02f, 2.438983303e-02f, 2.447936880e-02f, 2.456884379e-02f, 2.465825785e-02f,
2.474761083e-02f, 2.483690261e-02f, 2.492613304e-02f, 2.501530197e-02f, 2.510440928e-02f, 2.519345482e-02f, 2.528243845e-02f, 2.537136004e-02f, 2.546021943e-02f, 2.554901651e-02f,
2.563775112e-02f, 2.572642313e-02f, 2.581503239e-02f, 2.590357878e-02f, 2.599206215e-02f, 2.608048237e-02f, 2.616883929e-02f, 2.625713279e-02f, 2.634536271e-02f, 2.643352893e-02f,
2.652163130e-02f, 2.660966969e-02f, 2.669764397e-02f, 2.678555399e-02f, 2.687339962e-02f, 2.696118072e-02f, 2.704889715e-02f, 2.713654878e-02f, 2.722413548e-02f, 2.731165710e-02f,
2.739911351e-02f, 2.748650458e-02f, 2.757383016e-02f, 2.766109013e-02f, 2.774828434e-02f, 2.783541267e-02f, 2.792247497e-02f, 2.800947111e-02f, 2.809640096e-02f, 2.818326439e-02f,
2.827006125e-02f, 2.835679141e-02f, 2.844345474e-02f, 2.853005111e-02f, 2.861658037e-02f, 2.870304240e-02f, 2.878943707e-02f, 2.887576423e-02f, 2.896202376e-02f, 2.904821551e-02f,
2.913433937e-02f, 2.922039520e-02f, 2.930638285e-02f, 2.939230221e-02f, 2.947815313e-02f, 2.956393549e-02f, 2.964964914e-02f, 2.973529397e-02f, 2.982086984e-02f, 2.990637661e-02f,
2.999181416e-02f, 3.007718235e-02f, 3.016248105e-02f, 3.024771012e-02f, 3.033286945e-02f, 3.041795889e-02f, 3.050297832e-02f, 3.058792761e-02f, 3.067280662e-02f, 3.075761522e-02f,
3.084235329e-02f, 3.092702069e-02f, 3.101161729e-02f, 3.109614297e-02f, 3.118059759e-02f, 3.126498103e-02f, 3.134929315e-02f, 3.143353382e-02f, 3.151770293e-02f, 3.160180032e-02f,
3.168582589e-02f, 3.176977950e-02f, 3.185366101e-02f, 3.193747031e-02f, 3.202120726e-02f, 3.210487174e-02f, 3.218846362e-02f, 3.227198276e-02f, 3.235542905e-02f, 3.243880235e-02f,
3.252210254e-02f, 3.260532949e-02f, 3.268848307e-02f, 3.277156316e-02f, 3.285456962e-02f, 3.293750234e-02f, 3.302036119e-02f, 3.310314603e-02f, 3.318585675e-02f, 3.326849321e-02f,
3.335105529e-02f, 3.343354287e-02f, 3.351595582e-02f, 3.359829402e-02f, 3.368055733e-02f, 3.376274563e-02f, 3.384485881e-02f, 3.392689673e-02f, 3.400885926e-02f, 3.409074629e-02f,
3.417255770e-02f, 3.425429334e-02f, 3.433595311e-02f, 3.441753688e-02f, 3.449904452e-02f, 3.458047591e-02f, 3.466183093e-02f, 3.474310945e-02f, 3.482431135e-02f, 3.490543651e-02f,
3.498648481e-02f, 3.506745611e-02f, 3.514835030e-02f, 3.522916727e-02f, 3.530990687e-02f, 3.539056900e-02f, 3.547115353e-02f, 3.555166033e-02f, 3.563208930e-02f, 3.571244030e-02f,
3.579271321e-02f, 3.587290792e-02f, 3.595302429e-02f, 3.603306222e-02f, 3.611302158e-02f, 3.619290225e-02f, 3.627270411e-02f, 3.635242704e-02f, 3.643207092e-02f, 3.651163563e-02f,
3.659112104e-02f, 3.667052705e-02f, 3.674985353e-02f, 3.682910035e-02f, 3.690826742e-02f, 3.698735459e-02f, 3.706636176e-02f, 3.714528880e-02f, 3.722413560e-02f, 3.730290204e-02f,
3.738158800e-02f, 3.746019336e-02f, 3.753871801e-02f, 3.761716183e-02f, 3.769552469e-02f, 3.777380649e-02f, 3.785200710e-02f, 3.793012641e-02f, 3.800816430e-02f, 3.808612066e-02f,
3.816399536e-02f, 3.824178830e-02f, 3.831949935e-02f, 3.839712840e-02f, 3.847467533e-02f, 3.855214003e-02f, 3.862952238e-02f, 3.870682227e-02f, 3.878403958e-02f, 3.886117420e-02f,
3.893822601e-02f, 3.901519489e-02f, 3.909208073e-02f, 3.916888343e-02f, 3.924560285e-02f, 3.932223890e-02f, 3.939879145e-02f, 3.947526039e-02f, 3.955164560e-02f, 3.962794699e-02f,
3.970416442e-02f, 3.978029779e-02f, 3.985634698e-02f, 3.993231189e-02f, 4.000819239e-02f, 4.008398838e-02f, 4.015969975e-02f, 4.023532638e-02f, 4.031086816e-02f, 4.038632497e-02f,
4.046169672e-02f, 4.053698328e-02f, 4.061218454e-02f, 4.068730039e-02f, 4.076233073e-02f, 4.083727544e-02f, 4.091213441e-02f, 4.098690752e-02f, 4.106159468e-02f, 4.113619577e-02f,
4.121071067e-02f, 4.128513929e-02f, 4.135948150e-02f, 4.143373720e-02f, 4.150790629e-02f, 4.158198865e-02f, 4.165598417e-02f, 4.172989274e-02f, 4.180371426e-02f, 4.187744862e-02f,
4.195109570e-02f, 4.202465541e-02f, 4.209812763e-02f, 4.217151225e-02f, 4.224480917e-02f, 4.231801828e-02f, 4.239113947e-02f, 4.246417264e-02f, 4.253711767e-02f, 4.260997447e-02f,
4.268274292e-02f, 4.275542292e-02f, 4.282801436e-02f, 4.290051714e-02f, 4.297293115e-02f, 4.304525628e-02f, 4.311749243e-02f, 4.318963949e-02f, 4.326169737e-02f, 4.333366594e-02f,
4.340554511e-02f, 4.347733478e-02f, 4.354903483e-02f, 4.362064517e-02f, 4.369216569e-02f, 4.376359629e-02f, 4.383493686e-02f, 4.390618729e-02f, 4.397734750e-02f, 4.404841736e-02f,
4.411939678e-02f, 4.419028566e-02f, 4.426108389e-02f, 4.433179137e-02f, 4.440240800e-02f, 4.447293367e-02f, 4.454336829e-02f, 4.461371175e-02f, 4.468396394e-02f, 4.475412478e-02f,
4.482419415e-02f, 4.489417195e-02f, 4.496405809e-02f, 4.503385247e-02f, 4.510355497e-02f, 4.517316551e-02f, 4.524268398e-02f, 4.531211028e-02f, 4.538144431e-02f, 4.545068597e-02f,
4.551983516e-02f, 4.558889179e-02f, 4.565785575e-02f, 4.572672694e-02f, 4.579550527e-02f, 4.586419063e-02f, 4.593278293e-02f, 4.600128207e-02f, 4.606968794e-02f, 4.613800047e-02f,
4.620621953e-02f, 4.627434504e-02f, 4.634237690e-02f, 4.641031502e-02f, 4.647815928e-02f, 4.654590961e-02f, 4.661356589e-02f, 4.668112804e-02f, 4.674859596e-02f, 4.681596955e-02f,
4.688324871e-02f, 4.695043335e-02f, 4.701752338e-02f, 4.708451869e-02f, 4.715141920e-02f, 4.721822480e-02f, 4.728493540e-02f, 4.735155092e-02f, 4.741807124e-02f, 4.748449628e-02f,
4.755082594e-02f, 4.761706014e-02f, 4.768319877e-02f, 4.774924174e-02f, 4.781518896e-02f, 4.788104033e-02f, 4.794679576e-02f, 4.801245517e-02f, 4.807801844e-02f, 4.814348550e-02f,
4.820885625e-02f, 4.827413060e-02f, 4.833930845e-02f, 4.840438972e-02f, 4.846937430e-02f, 4.853426212e-02f, 4.859905307e-02f, 4.866374708e-02f, 4.872834403e-02f, 4.879284386e-02f,
4.885724646e-02f, 4.892155174e-02f, 4.898575961e-02f, 4.904986999e-02f, 4.911388278e-02f, 4.917779790e-02f, 4.924161524e-02f, 4.930533474e-02f, 4.936895629e-02f, 4.943247980e-02f,
4.949590519e-02f, 4.955923237e-02f, 4.962246125e-02f, 4.968559174e-02f, 4.974862375e-02f, 4.981155720e-02f, 4.987439200e-02f, 4.993712806e-02f, 4.999976528e-02f, 5.006230360e-02f,
5.012474291e-02f, 5.018708314e-02f, 5.024932418e-02f, 5.031146597e-02f, 5.037350841e-02f, 5.043545141e-02f, 5.049729489e-02f, 5.055903877e-02f, 5.062068296e-02f, 5.068222736e-02f,
5.074367191e-02f, 5.080501651e-02f, 5.086626108e-02f, 5.092740552e-02f, 5.098844977e-02f, 5.104939373e-02f, 5.111023733e-02f, 5.117098047e-02f, 5.123162307e-02f, 5.129216505e-02f,
5.135260632e-02f, 5.141294681e-02f, 5.147318643e-02f, 5.153332510e-02f, 5.159336272e-02f, 5.165329924e-02f, 5.171313455e-02f, 5.177286857e-02f, 5.183250124e-02f, 5.189203245e-02f,
5.195146214e-02f, 5.201079022e-02f, 5.207001661e-02f, 5.212914123e-02f, 5.218816400e-02f, 5.224708484e-02f, 5.230590366e-02f, 5.236462039e-02f, 5.242323495e-02f, 5.248174726e-02f,
5.254015723e-02f, 5.259846479e-02f, 5.265666986e-02f, 5.271477236e-02f, 5.277277221e-02f, 5.283066934e-02f, 5.288846366e-02f, 5.294615509e-02f, 5.300374357e-02f, 5.306122900e-02f,
5.311861132e-02f, 5.317589043e-02f, 5.323306628e-02f, 5.329013878e-02f, 5.334710785e-02f, 5.340397342e-02f, 5.346073540e-02f, 5.351739373e-02f, 5.357394833e-02f, 5.363039912e-02f,
5.368674602e-02f, 5.374298897e-02f, 5.379912788e-02f, 5.385516268e-02f, 5.391109329e-02f, 5.396691964e-02f, 5.402264165e-02f, 5.407825926e-02f, 5.413377238e-02f, 5.418918094e-02f,
5.424448488e-02f, 5.429968410e-02f, 5.435477855e-02f, 5.440976814e-02f, 5.446465281e-02f, 5.451943247e-02f, 5.457410707e-02f, 5.462867652e-02f, 5.468314076e-02f, 5.473749971e-02f,
5.479175329e-02f, 5.484590145e-02f, 5.489994409e-02f, 5.495388117e-02f, 5.500771259e-02f, 5.506143830e-02f, 5.511505822e-02f, 5.516857229e-02f, 5.522198042e-02f, 5.527528255e-02f,
5.532847861e-02f, 5.538156853e-02f, 5.543455224e-02f, 5.548742967e-02f, 5.554020076e-02f, 5.559286542e-02f, 5.564542360e-02f, 5.569787523e-02f, 5.575022023e-02f, 5.580245854e-02f,
5.585459009e-02f, 5.590661481e-02f, 5.595853263e-02f, 5.601034350e-02f, 5.606204733e-02f, 5.611364406e-02f, 5.616513363e-02f, 5.621651596e-02f, 5.626779100e-02f, 5.631895867e-02f,
5.637001892e-02f, 5.642097166e-02f, 5.647181685e-02f, 5.652255440e-02f, 5.657318426e-02f, 5.662370637e-02f, 5.667412064e-02f, 5.672442703e-02f, 5.677462547e-02f, 5.682471589e-02f,
5.687469823e-02f, 5.692457242e-02f, 5.697433840e-02f, 5.702399611e-02f, 5.707354548e-02f, 5.712298645e-02f, 5.717231895e-02f, 5.722154293e-02f, 5.727065832e-02f, 5.731966506e-02f,
5.736856309e-02f, 5.741735234e-02f, 5.746603275e-02f, 5.751460426e-02f, 5.756306682e-02f, 5.761142035e-02f, 5.765966479e-02f, 5.770780009e-02f, 5.775582619e-02f, 5.780374302e-02f,
5.785155053e-02f, 5.789924865e-02f, 5.794683732e-02f, 5.799431649e-02f, 5.804168610e-02f, 5.808894607e-02f, 5.813609637e-02f, 5.818313692e-02f, 5.823006767e-02f, 5.827688856e-02f,
5.832359954e-02f, 5.837020053e-02f, 5.841669150e-02f, 5.846307237e-02f, 5.850934309e-02f, 5.855550360e-02f, 5.860155385e-02f, 5.864749377e-02f, 5.869332332e-02f, 5.873904244e-02f,
5.878465106e-02f, 5.883014914e-02f, 5.887553661e-02f, 5.892081343e-02f, 5.896597953e-02f, 5.901103486e-02f, 5.905597936e-02f, 5.910081298e-02f, 5.914553567e-02f, 5.919014737e-02f,
5.923464803e-02f, 5.927903759e-02f, 5.932331599e-02f, 5.936748319e-02f, 5.941153913e-02f, 5.945548376e-02f, 5.949931702e-02f, 5.954303886e-02f, 5.958664923e-02f, 5.963014807e-02f,
5.967353534e-02f, 5.971681098e-02f, 5.975997494e-02f, 5.980302716e-02f, 5.984596760e-02f, 5.988879620e-02f, 5.993151292e-02f, 5.997411769e-02f, 6.001661048e-02f, 6.005899123e-02f,
6.010125989e-02f, 6.014341640e-02f, 6.018546073e-02f, 6.022739281e-02f, 6.026921261e-02f, 6.031092006e-02f, 6.035251513e-02f, 6.039399776e-02f, 6.043536790e-02f, 6.047662551e-02f,
6.051777053e-02f, 6.055880292e-02f, 6.059972264e-02f, 6.064052962e-02f, 6.068122383e-02f, 6.072180521e-02f, 6.076227373e-02f, 6.080262933e-02f, 6.084287196e-02f, 6.088300159e-02f,
6.092301815e-02f, 6.096292162e-02f, 6.100271193e-02f, 6.104238905e-02f, 6.108195293e-02f, 6.112140352e-02f, 6.116074078e-02f, 6.119996467e-02f, 6.123907513e-02f, 6.127807213e-02f,
6.131695561e-02f, 6.135572554e-02f, 6.139438188e-02f, 6.143292457e-02f, 6.147135357e-02f, 6.150966885e-02f, 6.154787035e-02f, 6.158595804e-02f, 6.162393186e-02f, 6.166179179e-02f,
6.169953777e-02f, 6.173716977e-02f, 6.177468774e-02f, 6.181209164e-02f, 6.184938143e-02f, 6.188655706e-02f, 6.192361851e-02f, 6.196056571e-02f, 6.199739864e-02f, 6.203411726e-02f,
6.207072152e-02f, 6.210721138e-02f, 6.214358680e-02f, 6.217984774e-02f, 6.221599417e-02f, 6.225202605e-02f, 6.228794333e-02f, 6.232374597e-02f, 6.235943394e-02f, 6.239500720e-02f,
6.243046571e-02f, 6.246580944e-02f, 6.250103833e-02f, 6.253615236e-02f, 6.257115149e-02f, 6.260603569e-02f, 6.264080490e-02f, 6.267545910e-02f, 6.270999826e-02f, 6.274442232e-02f,
6.277873126e-02f, 6.281292505e-02f, 6.284700364e-02f, 6.288096700e-02f, 6.291481509e-02f, 6.294854788e-02f, 6.298216533e-02f, 6.301566741e-02f, 6.304905409e-02f, 6.308232532e-02f,
6.311548108e-02f, 6.314852132e-02f, 6.318144603e-02f, 6.321425515e-02f, 6.324694867e-02f, 6.327952654e-02f, 6.331198873e-02f, 6.334433522e-02f, 6.337656595e-02f, 6.340868092e-02f,
6.344068007e-02f, 6.347256339e-02f, 6.350433083e-02f, 6.353598237e-02f, 6.356751797e-02f, 6.359893761e-02f, 6.363024125e-02f, 6.366142885e-02f, 6.369250040e-02f, 6.372345586e-02f,
6.375429520e-02f, 6.378501839e-02f, 6.381562539e-02f, 6.384611619e-02f, 6.387649075e-02f, 6.390674904e-02f, 6.393689102e-02f, 6.396691669e-02f, 6.399682599e-02f, 6.402661891e-02f,
6.405629542e-02f, 6.408585549e-02f, 6.411529909e-02f, 6.414462619e-02f, 6.417383677e-02f, 6.420293080e-02f, 6.423190825e-02f, 6.426076909e-02f, 6.428951331e-02f, 6.431814086e-02f,
6.434665173e-02f, 6.437504589e-02f, 6.440332331e-02f, 6.443148397e-02f, 6.445952784e-02f, 6.448745490e-02f, 6.451526512e-02f, 6.454295848e-02f, 6.457053495e-02f, 6.459799451e-02f,
6.462533713e-02f, 6.465256279e-02f, 6.467967147e-02f, 6.470666314e-02f, 6.473353778e-02f, 6.476029536e-02f, 6.478693587e-02f, 6.481345927e-02f, 6.483986555e-02f, 6.486615469e-02f,
6.489232666e-02f, 6.491838144e-02f, 6.494431901e-02f, 6.497013934e-02f, 6.499584242e-02f, 6.502142822e-02f, 6.504689673e-02f, 6.507224792e-02f, 6.509748177e-02f, 6.512259826e-02f,
6.514759738e-02f, 6.517247909e-02f, 6.519724339e-02f, 6.522189025e-02f, 6.524641965e-02f, 6.527083157e-02f, 6.529512600e-02f, 6.531930291e-02f, 6.534336229e-02f, 6.536730411e-02f,
6.539112837e-02f, 6.541483504e-02f, 6.543842410e-02f, 6.546189554e-02f, 6.548524934e-02f, 6.550848549e-02f, 6.553160395e-02f, 6.555460473e-02f, 6.557748780e-02f, 6.560025314e-02f,
6.562290074e-02f, 6.564543059e-02f, 6.566784266e-02f, 6.569013695e-02f, 6.571231343e-02f, 6.573437210e-02f, 6.575631293e-02f, 6.577813591e-02f, 6.579984103e-02f, 6.582142828e-02f,
6.584289763e-02f, 6.586424908e-02f, 6.588548261e-02f, 6.590659820e-02f, 6.592759585e-02f, 6.594847555e-02f, 6.596923727e-02f, 6.598988100e-02f, 6.601040674e-02f, 6.603081447e-02f,
6.605110418e-02f, 6.607127586e-02f, 6.609132949e-02f, 6.611126506e-02f, 6.613108257e-02f, 6.615078200e-02f, 6.617036334e-02f, 6.618982657e-02f, 6.620917170e-02f, 6.622839871e-02f,
6.624750758e-02f, 6.626649831e-02f, 6.628537089e-02f, 6.630412531e-02f, 6.632276157e-02f, 6.634127964e-02f, 6.635967952e-02f, 6.637796121e-02f, 6.639612469e-02f, 6.641416996e-02f,
6.643209701e-02f, 6.644990583e-02f, 6.646759642e-02f, 6.648516875e-02f, 6.650262284e-02f, 6.651995867e-02f, 6.653717623e-02f, 6.655427552e-02f, 6.657125654e-02f, 6.658811926e-02f,
6.660486370e-02f, 6.662148984e-02f, 6.663799767e-02f, 6.665438720e-02f, 6.667065842e-02f, 6.668681132e-02f, 6.670284589e-02f, 6.671876214e-02f, 6.673456005e-02f, 6.675023963e-02f,
6.676580086e-02f, 6.678124375e-02f, 6.679656830e-02f, 6.681177449e-02f, 6.682686233e-02f, 6.684183181e-02f, 6.685668293e-02f, 6.687141568e-02f, 6.688603007e-02f, 6.690052609e-02f,
6.691490375e-02f, 6.692916303e-02f, 6.694330393e-02f, 6.695732646e-02f, 6.697123062e-02f, 6.698501640e-02f, 6.699868380e-02f, 6.701223282e-02f, 6.702566346e-02f, 6.703897572e-02f,
6.705216960e-02f, 6.706524510e-02f, 6.707820223e-02f, 6.709104097e-02f, 6.710376134e-02f, 6.711636333e-02f, 6.712884695e-02f, 6.714121219e-02f, 6.715345906e-02f, 6.716558756e-02f,
6.717759769e-02f, 6.718948945e-02f, 6.720126284e-02f, 6.721291788e-02f, 6.722445456e-02f, 6.723587288e-02f, 6.724717285e-02f, 6.725835446e-02f, 6.726941774e-02f, 6.728036267e-02f,
6.729118926e-02f, 6.730189751e-02f, 6.731248744e-02f, 6.732295904e-02f, 6.733331233e-02f, 6.734354729e-02f, 6.735366395e-02f, 6.736366230e-02f, 6.737354235e-02f, 6.738330411e-02f,
6.739294758e-02f, 6.740247276e-02f, 6.741187968e-02f, 6.742116832e-02f, 6.743033870e-02f, 6.743939083e-02f, 6.744832471e-02f, 6.745714035e-02f, 6.746583775e-02f, 6.747441694e-02f,
6.748287790e-02f, 6.749122065e-02f, 6.749944521e-02f, 6.750755157e-02f, 6.751553974e-02f, 6.752340975e-02f, 6.753116158e-02f, 6.753879526e-02f, 6.754631080e-02f, 6.755370820e-02f,
6.756098747e-02f, 6.756814862e-02f, 6.757519167e-02f, 6.758211662e-02f, 6.758892348e-02f, 6.759561227e-02f, 6.760218300e-02f, 6.760863568e-02f, 6.761497031e-02f, 6.762118692e-02f,
6.762728551e-02f, 6.763326609e-02f, 6.763912869e-02f, 6.764487330e-02f, 6.765049994e-02f, 6.765600864e-02f, 6.766139938e-02f, 6.766667221e-02f, 6.767182711e-02f, 6.767686412e-02f,
6.768178324e-02f, 6.768658448e-02f, 6.769126787e-02f, 6.769583341e-02f, 6.770028113e-02f, 6.770461103e-02f, 6.770882313e-02f, 6.771291744e-02f, 6.771689399e-02f, 6.772075278e-02f,
6.772449384e-02f, 6.772811717e-02f, 6.773162280e-02f, 6.773501074e-02f, 6.773828101e-02f, 6.774143362e-02f, 6.774446859e-02f, 6.774738595e-02f, 6.775018570e-02f, 6.775286786e-02f,
6.775543245e-02f, 6.775787950e-02f, 6.776020901e-02f, 6.776242101e-02f, 6.776451552e-02f, 6.776649254e-02f, 6.776835211e-02f, 6.777009425e-02f, 6.777171896e-02f, 6.777322628e-02f,
6.777461621e-02f, 6.777588879e-02f, 6.777704402e-02f, 6.777808194e-02f, 6.777900256e-02f, 6.777980590e-02f, 6.778049198e-02f, 6.778106083e-02f, 6.778151246e-02f, 6.778184691e-02f,
6.778206418e-02f, 6.778216430e-02f, 6.778214729e-02f, 6.778201318e-02f, 6.778176198e-02f, 6.778139373e-02f, 6.778090844e-02f, 6.778030613e-02f, 6.777958684e-02f, 6.777875057e-02f,
6.777779737e-02f, 6.777672724e-02f, 6.777554022e-02f, 6.777423633e-02f, 6.777281559e-02f, 6.777127803e-02f, 6.776962367e-02f, 6.776785253e-02f, 6.776596465e-02f, 6.776396005e-02f,
6.776183875e-02f, 6.775960078e-02f, 6.775724617e-02f, 6.775477494e-02f, 6.775218711e-02f, 6.774948272e-02f, 6.774666179e-02f, 6.774372435e-02f, 6.774067042e-02f, 6.773750004e-02f,
6.773421323e-02f, 6.773081001e-02f, 6.772729042e-02f, 6.772365448e-02f, 6.771990222e-02f, 6.771603368e-02f, 6.771204887e-02f, 6.770794783e-02f, 6.770373059e-02f, 6.769939717e-02f,
6.769494761e-02f, 6.769038193e-02f, 6.768570017e-02f, 6.768090236e-02f, 6.767598851e-02f, 6.767095868e-02f, 6.766581288e-02f, 6.766055114e-02f, 6.765517351e-02f, 6.764968000e-02f,
6.764407065e-02f, 6.763834549e-02f, 6.763250456e-02f, 6.762654788e-02f, 6.762047549e-02f, 6.761428742e-02f, 6.760798370e-02f, 6.760156437e-02f, 6.759502945e-02f, 6.758837898e-02f,
6.758161300e-02f, 6.757473153e-02f, 6.756773462e-02f, 6.756062229e-02f, 6.755339458e-02f, 6.754605152e-02f, 6.753859314e-02f, 6.753101949e-02f, 6.752333060e-02f, 6.751552649e-02f,
6.750760722e-02f, 6.749957280e-02f, 6.749142328e-02f, 6.748315869e-02f, 6.747477908e-02f, 6.746628446e-02f, 6.745767489e-02f, 6.744895040e-02f, 6.744011102e-02f, 6.743115679e-02f,
6.742208774e-02f, 6.741290393e-02f, 6.740360537e-02f, 6.739419212e-02f, 6.738466420e-02f, 6.737502166e-02f, 6.736526453e-02f, 6.735539285e-02f, 6.734540666e-02f, 6.733530601e-02f,
6.732509092e-02f, 6.731476144e-02f, 6.730431760e-02f, 6.729375945e-02f, 6.728308702e-02f, 6.727230036e-02f, 6.726139951e-02f, 6.725038450e-02f, 6.723925537e-02f, 6.722801218e-02f,
6.721665494e-02f, 6.720518372e-02f, 6.719359855e-02f, 6.718189946e-02f, 6.717008651e-02f, 6.715815973e-02f, 6.714611916e-02f, 6.713396485e-02f, 6.712169685e-02f, 6.710931518e-02f,
6.709681990e-02f, 6.708421104e-02f, 6.707148865e-02f, 6.705865278e-02f, 6.704570346e-02f, 6.703264075e-02f, 6.701946467e-02f, 6.700617529e-02f, 6.699277263e-02f, 6.697925675e-02f,
6.696562769e-02f, 6.695188550e-02f, 6.693803022e-02f, 6.692406189e-02f, 6.690998056e-02f, 6.689578627e-02f, 6.688147907e-02f, 6.686705901e-02f, 6.685252614e-02f, 6.683788049e-02f,
6.682312211e-02f, 6.680825106e-02f, 6.679326737e-02f, 6.677817110e-02f, 6.676296229e-02f, 6.674764098e-02f, 6.673220724e-02f, 6.671666109e-02f, 6.670100260e-02f, 6.668523180e-02f,
6.666934875e-02f, 6.665335350e-02f, 6.663724609e-02f, 6.662102657e-02f, 6.660469499e-02f, 6.658825140e-02f, 6.657169586e-02f, 6.655502839e-02f, 6.653824907e-02f, 6.652135794e-02f,
6.650435504e-02f, 6.648724043e-02f, 6.647001415e-02f, 6.645267627e-02f, 6.643522682e-02f, 6.641766586e-02f, 6.639999345e-02f, 6.638220962e-02f, 6.636431444e-02f, 6.634630795e-02f,
6.632819020e-02f, 6.630996126e-02f, 6.629162116e-02f, 6.627316997e-02f, 6.625460773e-02f, 6.623593450e-02f, 6.621715032e-02f, 6.619825526e-02f, 6.617924937e-02f, 6.616013269e-02f,
6.614090529e-02f, 6.612156721e-02f, 6.610211851e-02f, 6.608255925e-02f, 6.606288947e-02f, 6.604310924e-02f, 6.602321860e-02f, 6.600321761e-02f, 6.598310633e-02f, 6.596288481e-02f,
6.594255311e-02f, 6.592211128e-02f, 6.590155938e-02f, 6.588089746e-02f, 6.586012558e-02f, 6.583924379e-02f, 6.581825216e-02f, 6.579715073e-02f, 6.577593957e-02f, 6.575461873e-02f,
6.573318827e-02f, 6.571164825e-02f, 6.568999871e-02f, 6.566823973e-02f, 6.564637136e-02f, 6.562439365e-02f, 6.560230666e-02f, 6.558011046e-02f, 6.555780510e-02f, 6.553539064e-02f,
6.551286713e-02f, 6.549023464e-02f, 6.546749323e-02f, 6.544464295e-02f, 6.542168387e-02f, 6.539861604e-02f, 6.537543953e-02f, 6.535215439e-02f, 6.532876068e-02f, 6.530525846e-02f,
6.528164780e-02f, 6.525792876e-02f, 6.523410139e-02f, 6.521016576e-02f, 6.518612193e-02f, 6.516196996e-02f, 6.513770990e-02f, 6.511334183e-02f, 6.508886581e-02f, 6.506428189e-02f,
6.503959014e-02f, 6.501479062e-02f, 6.498988339e-02f, 6.496486852e-02f, 6.493974607e-02f, 6.491451610e-02f, 6.488917868e-02f, 6.486373386e-02f, 6.483818172e-02f, 6.481252231e-02f,
6.478675571e-02f, 6.476088196e-02f, 6.473490115e-02f, 6.470881332e-02f, 6.468261856e-02f, 6.465631691e-02f, 6.462990845e-02f, 6.460339325e-02f, 6.457677136e-02f, 6.455004285e-02f,
6.452320779e-02f, 6.449626625e-02f, 6.446921828e-02f, 6.444206396e-02f, 6.441480335e-02f, 6.438743652e-02f, 6.435996354e-02f, 6.433238446e-02f, 6.430469937e-02f, 6.427690832e-02f,
6.424901138e-02f, 6.422100863e-02f, 6.419290012e-02f, 6.416468592e-02f, 6.413636611e-02f, 6.410794076e-02f, 6.407940992e-02f, 6.405077367e-02f, 6.402203208e-02f, 6.399318521e-02f,
6.396423314e-02f, 6.393517593e-02f, 6.390601365e-02f, 6.387674638e-02f, 6.384737418e-02f, 6.381789712e-02f, 6.378831527e-02f, 6.375862870e-02f, 6.372883749e-02f, 6.369894170e-02f,
6.366894140e-02f, 6.363883666e-02f, 6.360862756e-02f, 6.357831416e-02f, 6.354789654e-02f, 6.351737477e-02f, 6.348674892e-02f, 6.345601906e-02f, 6.342518526e-02f, 6.339424760e-02f,
6.336320615e-02f, 6.333206097e-02f, 6.330081215e-02f, 6.326945975e-02f, 6.323800386e-02f, 6.320644453e-02f, 6.317478184e-02f, 6.314301588e-02f, 6.311114670e-02f, 6.307917439e-02f,
6.304709902e-02f, 6.301492066e-02f, 6.298263938e-02f, 6.295025527e-02f, 6.291776839e-02f, 6.288517883e-02f, 6.285248664e-02f, 6.281969192e-02f, 6.278679473e-02f, 6.275379516e-02f,
6.272069326e-02f, 6.268748913e-02f, 6.265418284e-02f, 6.262077446e-02f, 6.258726406e-02f, 6.255365173e-02f, 6.251993755e-02f, 6.248612158e-02f, 6.245220390e-02f, 6.241818460e-02f,
6.238406375e-02f, 6.234984142e-02f, 6.231551769e-02f, 6.228109265e-02f, 6.224656636e-02f, 6.221193891e-02f, 6.217721037e-02f, 6.214238083e-02f, 6.210745035e-02f, 6.207241903e-02f,
6.203728693e-02f, 6.200205413e-02f, 6.196672073e-02f, 6.193128678e-02f, 6.189575238e-02f, 6.186011760e-02f, 6.182438253e-02f, 6.178854723e-02f, 6.175261180e-02f, 6.171657631e-02f,
6.168044084e-02f, 6.164420547e-02f, 6.160787029e-02f, 6.157143537e-02f, 6.153490079e-02f, 6.149826664e-02f, 6.146153299e-02f, 6.142469993e-02f, 6.138776754e-02f, 6.135073590e-02f,
6.131360509e-02f, 6.127637519e-02f, 6.123904629e-02f, 6.120161847e-02f, 6.116409181e-02f, 6.112646638e-02f, 6.108874229e-02f, 6.105091960e-02f, 6.101299840e-02f, 6.097497878e-02f,
6.093686081e-02f, 6.089864459e-02f, 6.086033019e-02f, 6.082191769e-02f, 6.078340719e-02f, 6.074479876e-02f, 6.070609249e-02f, 6.066728847e-02f, 6.062838677e-02f, 6.058938748e-02f,
6.055029070e-02f, 6.051109649e-02f, 6.047180495e-02f, 6.043241617e-02f, 6.039293022e-02f, 6.035334720e-02f, 6.031366718e-02f, 6.027389026e-02f, 6.023401652e-02f, 6.019404604e-02f,
6.015397892e-02f, 6.011381524e-02f, 6.007355508e-02f, 6.003319854e-02f, 5.999274569e-02f, 5.995219664e-02f, 5.991155145e-02f, 5.987081022e-02f, 5.982997304e-02f, 5.978904000e-02f,
5.974801118e-02f, 5.970688667e-02f, 5.966566656e-02f, 5.962435094e-02f, 5.958293989e-02f, 5.954143351e-02f, 5.949983187e-02f, 5.945813508e-02f, 5.941634322e-02f, 5.937445637e-02f,
5.933247464e-02f, 5.929039810e-02f, 5.924822685e-02f, 5.920596097e-02f, 5.916360056e-02f, 5.912114571e-02f, 5.907859650e-02f, 5.903595302e-02f, 5.899321538e-02f, 5.895038365e-02f,
5.890745792e-02f, 5.886443830e-02f, 5.882132486e-02f, 5.877811770e-02f, 5.873481692e-02f, 5.869142259e-02f, 5.864793482e-02f, 5.860435369e-02f, 5.856067931e-02f, 5.851691175e-02f,
5.847305111e-02f, 5.842909748e-02f, 5.838505096e-02f, 5.834091163e-02f, 5.829667960e-02f, 5.825235495e-02f, 5.820793777e-02f, 5.816342817e-02f, 5.811882622e-02f, 5.807413203e-02f,
5.802934569e-02f, 5.798446729e-02f, 5.793949693e-02f, 5.789443469e-02f, 5.784928068e-02f, 5.780403499e-02f, 5.775869771e-02f, 5.771326893e-02f, 5.766774876e-02f, 5.762213728e-02f,
5.757643459e-02f, 5.753064078e-02f, 5.748475596e-02f, 5.743878021e-02f, 5.739271363e-02f, 5.734655632e-02f, 5.730030837e-02f, 5.725396987e-02f, 5.720754093e-02f, 5.716102164e-02f,
5.711441210e-02f, 5.706771240e-02f, 5.702092263e-02f, 5.697404290e-02f, 5.692707330e-02f, 5.688001393e-02f, 5.683286488e-02f, 5.678562626e-02f, 5.673829816e-02f, 5.669088067e-02f,
5.664337390e-02f, 5.659577794e-02f, 5.654809289e-02f, 5.650031884e-02f, 5.645245591e-02f, 5.640450417e-02f, 5.635646374e-02f, 5.630833471e-02f, 5.626011718e-02f, 5.621181125e-02f,
5.616341701e-02f, 5.611493457e-02f, 5.606636402e-02f, 5.601770547e-02f, 5.596895901e-02f, 5.592012475e-02f, 5.587120278e-02f, 5.582219320e-02f, 5.577309611e-02f, 5.572391161e-02f,
5.567463981e-02f, 5.562528079e-02f, 5.557583468e-02f, 5.552630155e-02f, 5.547668152e-02f, 5.542697468e-02f, 5.537718114e-02f, 5.532730100e-02f, 5.527733436e-02f, 5.522728131e-02f,
5.517714197e-02f, 5.512691642e-02f, 5.507660478e-02f, 5.502620715e-02f, 5.497572363e-02f, 5.492515431e-02f, 5.487449931e-02f, 5.482375872e-02f, 5.477293265e-02f, 5.472202120e-02f,
5.467102447e-02f, 5.461994256e-02f, 5.456877558e-02f, 5.451752364e-02f, 5.446618683e-02f, 5.441476525e-02f, 5.436325902e-02f, 5.431166823e-02f, 5.425999299e-02f, 5.420823340e-02f,
5.415638957e-02f, 5.410446160e-02f, 5.405244959e-02f, 5.400035365e-02f, 5.394817388e-02f, 5.389591039e-02f, 5.384356329e-02f, 5.379113267e-02f, 5.373861864e-02f, 5.368602131e-02f,
5.363334079e-02f, 5.358057717e-02f, 5.352773056e-02f, 5.347480108e-02f, 5.342178881e-02f, 5.336869388e-02f, 5.331551638e-02f, 5.326225643e-02f, 5.320891412e-02f, 5.315548957e-02f,
5.310198288e-02f, 5.304839416e-02f, 5.299472351e-02f, 5.294097104e-02f, 5.288713686e-02f, 5.283322108e-02f, 5.277922379e-02f, 5.272514512e-02f, 5.267098516e-02f, 5.261674403e-02f,
5.256242183e-02f, 5.250801866e-02f, 5.245353465e-02f, 5.239896989e-02f, 5.234432449e-02f, 5.228959857e-02f, 5.223479222e-02f, 5.217990556e-02f, 5.212493870e-02f, 5.206989174e-02f,
5.201476480e-02f, 5.195955798e-02f, 5.190427139e-02f, 5.184890515e-02f, 5.179345935e-02f, 5.173793411e-02f, 5.168232955e-02f, 5.162664576e-02f, 5.157088286e-02f, 5.151504095e-02f,
5.145912016e-02f, 5.140312058e-02f, 5.134704233e-02f, 5.129088552e-02f, 5.123465026e-02f, 5.117833666e-02f, 5.112194483e-02f, 5.106547488e-02f, 5.100892692e-02f, 5.095230106e-02f,
5.089559741e-02f, 5.083881609e-02f, 5.078195721e-02f, 5.072502088e-02f, 5.066800720e-02f, 5.061091629e-02f, 5.055374827e-02f, 5.049650323e-02f, 5.043918131e-02f, 5.038178260e-02f,
5.032430722e-02f, 5.026675529e-02f, 5.020912691e-02f, 5.015142220e-02f, 5.009364126e-02f, 5.003578422e-02f, 4.997785119e-02f, 4.991984227e-02f, 4.986175759e-02f, 4.980359725e-02f,
4.974536136e-02f, 4.968705005e-02f, 4.962866342e-02f, 4.957020159e-02f, 4.951166468e-02f, 4.945305278e-02f, 4.939436603e-02f, 4.933560453e-02f, 4.927676840e-02f, 4.921785775e-02f,
4.915887270e-02f, 4.909981336e-02f, 4.904067984e-02f, 4.898147226e-02f, 4.892219074e-02f, 4.886283538e-02f, 4.880340631e-02f, 4.874390364e-02f, 4.868432749e-02f, 4.862467796e-02f,
4.856495518e-02f, 4.850515926e-02f, 4.844529031e-02f, 4.838534846e-02f, 4.832533382e-02f, 4.826524650e-02f, 4.820508662e-02f, 4.814485429e-02f, 4.808454964e-02f, 4.802417277e-02f,
4.796372381e-02f, 4.790320287e-02f, 4.784261007e-02f, 4.778194552e-02f, 4.772120934e-02f, 4.766040165e-02f, 4.759952257e-02f, 4.753857221e-02f, 4.747755068e-02f, 4.741645812e-02f,
4.735529462e-02f, 4.729406032e-02f, 4.723275533e-02f, 4.717137977e-02f, 4.710993375e-02f, 4.704841739e-02f, 4.698683082e-02f, 4.692517414e-02f, 4.686344748e-02f, 4.680165095e-02f,
4.673978468e-02f, 4.667784878e-02f, 4.661584337e-02f, 4.655376857e-02f, 4.649162450e-02f, 4.642941127e-02f, 4.636712901e-02f, 4.630477784e-02f, 4.624235787e-02f, 4.617986922e-02f,
4.611731201e-02f, 4.605468637e-02f, 4.599199241e-02f, 4.592923025e-02f, 4.586640001e-02f, 4.580350182e-02f, 4.574053578e-02f, 4.567750202e-02f, 4.561440067e-02f, 4.555123184e-02f,
4.548799564e-02f, 4.542469221e-02f, 4.536132167e-02f, 4.529788412e-02f, 4.523437970e-02f, 4.517080852e-02f, 4.510717071e-02f, 4.504346638e-02f, 4.497969566e-02f, 4.491585867e-02f,
4.485195553e-02f, 4.478798636e-02f, 4.472395128e-02f, 4.465985042e-02f, 4.459568389e-02f, 4.453145181e-02f, 4.446715432e-02f, 4.440279152e-02f, 4.433836355e-02f, 4.427387052e-02f,
4.420931256e-02f, 4.414468979e-02f, 4.408000233e-02f, 4.401525030e-02f, 4.395043383e-02f, 4.388555303e-02f, 4.382060804e-02f, 4.375559897e-02f, 4.369052595e-02f, 4.362538909e-02f,
4.356018853e-02f, 4.349492439e-02f, 4.342959678e-02f, 4.336420583e-02f, 4.329875167e-02f, 4.323323442e-02f, 4.316765420e-02f, 4.310201114e-02f, 4.303630536e-02f, 4.297053697e-02f,
4.290470612e-02f, 4.283881292e-02f, 4.277285749e-02f, 4.270683996e-02f, 4.264076045e-02f, 4.257461909e-02f, 4.250841600e-02f, 4.244215131e-02f, 4.237582514e-02f, 4.230943761e-02f,
4.224298886e-02f, 4.217647900e-02f, 4.210990816e-02f, 4.204327646e-02f, 4.197658403e-02f, 4.190983100e-02f, 4.184301748e-02f, 4.177614361e-02f, 4.170920951e-02f, 4.164221531e-02f,
4.157516113e-02f, 4.150804709e-02f, 4.144087333e-02f, 4.137363996e-02f, 4.130634712e-02f, 4.123899492e-02f, 4.117158351e-02f, 4.110411299e-02f, 4.103658350e-02f, 4.096899517e-02f,
4.090134811e-02f, 4.083364247e-02f, 4.076587835e-02f, 4.069805590e-02f, 4.063017523e-02f, 4.056223647e-02f, 4.049423975e-02f, 4.042618520e-02f, 4.035807294e-02f, 4.028990310e-02f,
4.022167581e-02f, 4.015339119e-02f, 4.008504937e-02f, 4.001665048e-02f, 3.994819465e-02f, 3.987968200e-02f, 3.981111266e-02f, 3.974248676e-02f, 3.967380443e-02f, 3.960506578e-02f,
3.953627096e-02f, 3.946742009e-02f, 3.939851330e-02f, 3.932955071e-02f, 3.926053245e-02f, 3.919145866e-02f, 3.912232945e-02f, 3.905314496e-02f, 3.898390532e-02f, 3.891461065e-02f,
3.884526108e-02f, 3.877585675e-02f, 3.870639778e-02f, 3.863688429e-02f, 3.856731642e-02f, 3.849769430e-02f, 3.842801806e-02f, 3.835828781e-02f, 3.828850370e-02f, 3.821866586e-02f,
3.814877440e-02f, 3.807882947e-02f, 3.800883118e-02f, 3.793877968e-02f, 3.786867508e-02f, 3.779851753e-02f, 3.772830714e-02f, 3.765804404e-02f, 3.758772838e-02f, 3.751736027e-02f,
3.744693985e-02f, 3.737646725e-02f, 3.730594259e-02f, 3.723536601e-02f, 3.716473764e-02f, 3.709405760e-02f, 3.702332603e-02f, 3.695254306e-02f, 3.688170882e-02f, 3.681082344e-02f,
3.673988704e-02f, 3.666889977e-02f, 3.659786174e-02f, 3.652677310e-02f, 3.645563397e-02f, 3.638444448e-02f, 3.631320476e-02f, 3.624191495e-02f, 3.617057517e-02f, 3.609918556e-02f,
3.602774625e-02f, 3.595625737e-02f, 3.588471904e-02f, 3.581313141e-02f, 3.574149460e-02f, 3.566980874e-02f, 3.559807397e-02f, 3.552629042e-02f, 3.545445821e-02f, 3.538257749e-02f,
3.531064837e-02f, 3.523867100e-02f, 3.516664551e-02f, 3.509457202e-02f, 3.502245068e-02f, 3.495028160e-02f, 3.487806493e-02f, 3.480580080e-02f, 3.473348933e-02f, 3.466113066e-02f,
3.458872493e-02f, 3.451627226e-02f, 3.444377279e-02f, 3.437122664e-02f, 3.429863396e-02f, 3.422599488e-02f, 3.415330952e-02f, 3.408057802e-02f, 3.400780052e-02f, 3.393497714e-02f,
3.386210802e-02f, 3.378919329e-02f, 3.371623309e-02f, 3.364322754e-02f, 3.357017679e-02f, 3.349708095e-02f, 3.342394018e-02f, 3.335075460e-02f, 3.327752433e-02f, 3.320424953e-02f,
3.313093032e-02f, 3.305756683e-02f, 3.298415919e-02f, 3.291070755e-02f, 3.283721203e-02f, 3.276367277e-02f, 3.269008990e-02f, 3.261646356e-02f, 3.254279388e-02f, 3.246908099e-02f,
3.239532502e-02f, 3.232152612e-02f, 3.224768441e-02f, 3.217380003e-02f, 3.209987312e-02f, 3.202590380e-02f, 3.195189221e-02f, 3.187783849e-02f, 3.180374277e-02f, 3.172960518e-02f,
3.165542586e-02f, 3.158120495e-02f, 3.150694257e-02f, 3.143263887e-02f, 3.135829397e-02f, 3.128390801e-02f, 3.120948113e-02f, 3.113501346e-02f, 3.106050514e-02f, 3.098595629e-02f,
3.091136707e-02f, 3.083673759e-02f, 3.076206799e-02f, 3.068735842e-02f, 3.061260900e-02f, 3.053781987e-02f, 3.046299117e-02f, 3.038812303e-02f, 3.031321558e-02f, 3.023826897e-02f,
3.016328332e-02f, 3.008825877e-02f, 3.001319546e-02f, 2.993809352e-02f, 2.986295309e-02f, 2.978777430e-02f, 2.971255729e-02f, 2.963730220e-02f, 2.956200915e-02f, 2.948667829e-02f,
2.941130976e-02f, 2.933590368e-02f, 2.926046019e-02f, 2.918497943e-02f, 2.910946154e-02f, 2.903390665e-02f, 2.895831489e-02f, 2.888268641e-02f, 2.880702133e-02f, 2.873131980e-02f,
2.865558195e-02f, 2.857980792e-02f, 2.850399784e-02f, 2.842815185e-02f, 2.835227008e-02f, 2.827635268e-02f, 2.820039977e-02f, 2.812441150e-02f, 2.804838800e-02f, 2.797232941e-02f,
2.789623586e-02f, 2.782010749e-02f, 2.774394444e-02f, 2.766774684e-02f, 2.759151483e-02f, 2.751524855e-02f, 2.743894813e-02f, 2.736261371e-02f, 2.728624543e-02f, 2.720984342e-02f,
2.713340782e-02f, 2.705693877e-02f, 2.698043641e-02f, 2.690390086e-02f, 2.682733228e-02f, 2.675073078e-02f, 2.667409652e-02f, 2.659742963e-02f, 2.652073025e-02f, 2.644399850e-02f,
2.636723454e-02f, 2.629043850e-02f, 2.621361051e-02f, 2.613675071e-02f, 2.605985924e-02f, 2.598293624e-02f, 2.590598184e-02f, 2.582899619e-02f, 2.575197941e-02f, 2.567493165e-02f,
2.559785304e-02f, 2.552074372e-02f, 2.544360383e-02f, 2.536643350e-02f, 2.528923288e-02f, 2.521200210e-02f, 2.513474130e-02f, 2.505745062e-02f, 2.498013019e-02f, 2.490278015e-02f,
2.482540064e-02f, 2.474799179e-02f, 2.467055376e-02f, 2.459308666e-02f, 2.451559064e-02f, 2.443806585e-02f, 2.436051240e-02f, 2.428293046e-02f, 2.420532014e-02f, 2.412768159e-02f,
2.405001496e-02f, 2.397232036e-02f, 2.389459796e-02f, 2.381684787e-02f, 2.373907024e-02f, 2.366126521e-02f, 2.358343292e-02f, 2.350557350e-02f, 2.342768709e-02f, 2.334977384e-02f,
2.327183387e-02f, 2.319386733e-02f, 2.311587435e-02f, 2.303785508e-02f, 2.295980965e-02f, 2.288173819e-02f, 2.280364086e-02f, 2.272551778e-02f, 2.264736910e-02f, 2.256919495e-02f,
2.249099548e-02f, 2.241277081e-02f, 2.233452109e-02f, 2.225624646e-02f, 2.217794705e-02f, 2.209962301e-02f, 2.202127447e-02f, 2.194290157e-02f, 2.186450445e-02f, 2.178608325e-02f,
2.170763810e-02f, 2.162916915e-02f, 2.155067653e-02f, 2.147216039e-02f, 2.139362086e-02f, 2.131505807e-02f, 2.123647218e-02f, 2.115786331e-02f, 2.107923161e-02f, 2.100057721e-02f,
2.092190025e-02f, 2.084320088e-02f, 2.076447922e-02f, 2.068573543e-02f, 2.060696963e-02f, 2.052818198e-02f, 2.044937259e-02f, 2.037054162e-02f, 2.029168921e-02f, 2.021281549e-02f,
2.013392060e-02f, 2.005500467e-02f, 1.997606786e-02f, 1.989711030e-02f, 1.981813212e-02f, 1.973913346e-02f, 1.966011448e-02f, 1.958107529e-02f, 1.950201605e-02f, 1.942293689e-02f,
1.934383795e-02f, 1.926471937e-02f, 1.918558128e-02f, 1.910642384e-02f, 1.902724717e-02f, 1.894805141e-02f, 1.886883671e-02f, 1.878960320e-02f, 1.871035103e-02f, 1.863108033e-02f,
1.855179123e-02f, 1.847248389e-02f, 1.839315844e-02f, 1.831381501e-02f, 1.823445375e-02f, 1.815507480e-02f, 1.807567829e-02f, 1.799626436e-02f, 1.791683316e-02f, 1.783738482e-02f,
1.775791948e-02f, 1.767843728e-02f, 1.759893836e-02f, 1.751942286e-02f, 1.743989092e-02f, 1.736034268e-02f, 1.728077827e-02f, 1.720119784e-02f, 1.712160152e-02f, 1.704198945e-02f,
1.696236178e-02f, 1.688271864e-02f, 1.680306017e-02f, 1.672338651e-02f, 1.664369780e-02f, 1.656399418e-02f, 1.648427578e-02f, 1.640454276e-02f, 1.632479524e-02f, 1.624503336e-02f,
1.616525727e-02f, 1.608546710e-02f, 1.600566299e-02f, 1.592584509e-02f, 1.584601353e-02f, 1.576616845e-02f, 1.568630998e-02f, 1.560643828e-02f, 1.552655347e-02f, 1.544665570e-02f,
1.536674511e-02f, 1.528682183e-02f, 1.520688601e-02f, 1.512693778e-02f, 1.504697728e-02f, 1.496700465e-02f, 1.488702004e-02f, 1.480702357e-02f, 1.472701539e-02f, 1.464699565e-02f,
1.456696447e-02f, 1.448692199e-02f, 1.440686836e-02f, 1.432680372e-02f, 1.424672820e-02f, 1.416664194e-02f, 1.408654509e-02f, 1.400643778e-02f, 1.392632014e-02f, 1.384619233e-02f,
1.376605447e-02f, 1.368590672e-02f, 1.360574920e-02f, 1.352558205e-02f, 1.344540542e-02f, 1.336521944e-02f, 1.328502426e-02f, 1.320482000e-02f, 1.312460682e-02f, 1.304438485e-02f,
1.296415423e-02f, 1.288391509e-02f, 1.280366758e-02f, 1.272341184e-02f, 1.264314800e-02f, 1.256287620e-02f, 1.248259659e-02f, 1.240230930e-02f, 1.232201447e-02f, 1.224171224e-02f,
1.216140274e-02f, 1.208108612e-02f, 1.200076252e-02f, 1.192043208e-02f, 1.184009492e-02f, 1.175975120e-02f, 1.167940105e-02f, 1.159904462e-02f, 1.151868202e-02f, 1.143831342e-02f,
1.135793895e-02f, 1.127755873e-02f, 1.119717293e-02f, 1.111678166e-02f, 1.103638508e-02f, 1.095598331e-02f, 1.087557651e-02f, 1.079516480e-02f, 1.071474833e-02f, 1.063432723e-02f,
1.055390165e-02f, 1.047347171e-02f, 1.039303757e-02f, 1.031259936e-02f, 1.023215721e-02f, 1.015171127e-02f, 1.007126168e-02f, 9.990808568e-03f, 9.910352077e-03f, 9.829892347e-03f,
9.749429515e-03f, 9.668963720e-03f, 9.588495100e-03f, 9.508023794e-03f, 9.427549940e-03f, 9.347073677e-03f, 9.266595142e-03f, 9.186114474e-03f, 9.105631811e-03f, 9.025147292e-03f,
8.944661055e-03f, 8.864173238e-03f, 8.783683979e-03f, 8.703193417e-03f, 8.622701689e-03f, 8.542208934e-03f, 8.461715290e-03f, 8.381220895e-03f, 8.300725887e-03f, 8.220230404e-03f,
8.139734585e-03f, 8.059238566e-03f, 7.978742487e-03f, 7.898246485e-03f, 7.817750698e-03f, 7.737255264e-03f, 7.656760320e-03f, 7.576266006e-03f, 7.495772458e-03f, 7.415279815e-03f,
7.334788214e-03f, 7.254297792e-03f, 7.173808689e-03f, 7.093321041e-03f, 7.012834986e-03f, 6.932350661e-03f, 6.851868206e-03f, 6.771387756e-03f, 6.690909450e-03f, 6.610433425e-03f,
6.529959818e-03f, 6.449488768e-03f, 6.369020412e-03f, 6.288554887e-03f, 6.208092330e-03f, 6.127632879e-03f, 6.047176672e-03f, 5.966723845e-03f, 5.886274536e-03f, 5.805828882e-03f,
5.725387021e-03f, 5.644949089e-03f, 5.564515225e-03f, 5.484085564e-03f, 5.403660244e-03f, 5.323239403e-03f, 5.242823176e-03f, 5.162411703e-03f, 5.082005118e-03f, 5.001603560e-03f,
4.921207165e-03f, 4.840816070e-03f, 4.760430412e-03f, 4.680050327e-03f, 4.599675954e-03f, 4.519307428e-03f, 4.438944886e-03f, 4.358588464e-03f, 4.278238301e-03f, 4.197894531e-03f,
4.117557292e-03f, 4.037226721e-03f, 3.956902953e-03f, 3.876586126e-03f, 3.796276376e-03f, 3.715973838e-03f, 3.635678651e-03f, 3.555390949e-03f, 3.475110870e-03f, 3.394838550e-03f,
3.314574124e-03f, 3.234317729e-03f, 3.154069502e-03f, 3.073829578e-03f, 2.993598093e-03f, 2.913375185e-03f, 2.833160987e-03f, 2.752955638e-03f, 2.672759271e-03f, 2.592572025e-03f,
2.512394033e-03f, 2.432225433e-03f, 2.352066360e-03f, 2.271916949e-03f, 2.191777337e-03f, 2.111647659e-03f, 2.031528051e-03f, 1.951418648e-03f, 1.871319586e-03f, 1.791231000e-03f,
1.711153027e-03f, 1.631085800e-03f, 1.551029456e-03f, 1.470984131e-03f, 1.390949959e-03f, 1.310927075e-03f, 1.230915616e-03f, 1.150915715e-03f, 1.070927509e-03f, 9.909511317e-04f,
9.109867191e-04f, 8.310344058e-04f, 7.510943269e-04f, 6.711666172e-04f, 5.912514117e-04f, 5.113488453e-04f, 4.314590526e-04f, 3.515821684e-04f, 2.717183275e-04f, 1.918676644e-04f,
1.120303139e-04f, 3.220641052e-05f, -4.760391130e-05f, -1.274005170e-04f, -2.071832723e-04f, -2.869520426e-04f, -3.667066937e-04f, -4.464470913e-04f, -5.261731011e-04f, -6.058845889e-04f,
-6.855814206e-04f, -7.652634621e-04f, -8.449305794e-04f, -9.245826383e-04f, -1.004219505e-03f, -1.083841046e-03f, -1.163447126e-03f, -1.243037613e-03f, -1.322612372e-03f, -1.402171270e-03f,
-1.481714173e-03f, -1.561240947e-03f, -1.640751460e-03f, -1.720245576e-03f, -1.799723164e-03f, -1.879184089e-03f, -1.958628218e-03f, -2.038055418e-03f, -2.117465555e-03f, -2.196858497e-03f,
-2.276234110e-03f, -2.355592261e-03f, -2.434932817e-03f, -2.514255646e-03f, -2.593560613e-03f, -2.672847586e-03f, -2.752116433e-03f, -2.831367021e-03f, -2.910599216e-03f, -2.989812886e-03f,
-3.069007899e-03f, -3.148184122e-03f, -3.227341423e-03f, -3.306479668e-03f, -3.385598726e-03f, -3.464698464e-03f, -3.543778750e-03f, -3.622839452e-03f, -3.701880437e-03f, -3.780901574e-03f,
-3.859902730e-03f, -3.938883773e-03f, -4.017844572e-03f, -4.096784993e-03f, -4.175704907e-03f, -4.254604180e-03f, -4.333482681e-03f, -4.412340279e-03f, -4.491176841e-03f, -4.569992237e-03f,
-4.648786334e-03f, -4.727559001e-03f, -4.806310108e-03f, -4.885039522e-03f, -4.963747112e-03f, -5.042432747e-03f, -5.121096296e-03f, -5.199737627e-03f, -5.278356611e-03f, -5.356953115e-03f,
-5.435527010e-03f, -5.514078163e-03f, -5.592606444e-03f, -5.671111723e-03f, -5.749593869e-03f, -5.828052752e-03f, -5.906488240e-03f, -5.984900203e-03f, -6.063288511e-03f, -6.141653033e-03f,
-6.219993640e-03f, -6.298310200e-03f, -6.376602585e-03f, -6.454870663e-03f, -6.533114304e-03f, -6.611333380e-03f, -6.689527759e-03f, -6.767697311e-03f, -6.845841908e-03f, -6.923961420e-03f,
-7.002055716e-03f, -7.080124667e-03f, -7.158168143e-03f, -7.236186016e-03f, -7.314178156e-03f, -7.392144433e-03f, -7.470084718e-03f, -7.547998882e-03f, -7.625886795e-03f, -7.703748330e-03f,
-7.781583356e-03f, -7.859391745e-03f, -7.937173368e-03f, -8.014928096e-03f, -8.092655800e-03f, -8.170356352e-03f, -8.248029623e-03f, -8.325675485e-03f, -8.403293809e-03f, -8.480884466e-03f,
-8.558447329e-03f, -8.635982269e-03f, -8.713489158e-03f, -8.790967868e-03f, -8.868418271e-03f, -8.945840238e-03f, -9.023233642e-03f, -9.100598356e-03f, -9.177934250e-03f, -9.255241198e-03f,
-9.332519073e-03f, -9.409767745e-03f, -9.486987089e-03f, -9.564176976e-03f, -9.641337279e-03f, -9.718467871e-03f, -9.795568624e-03f, -9.872639413e-03f, -9.949680108e-03f, -1.002669058e-02f,
-1.010367071e-02f, -1.018062037e-02f, -1.025753943e-02f, -1.033442776e-02f, -1.041128523e-02f, -1.048811173e-02f, -1.056490712e-02f, -1.064167128e-02f, -1.071840408e-02f, -1.079510539e-02f,
-1.087177509e-02f, -1.094841306e-02f, -1.102501916e-02f, -1.110159327e-02f, -1.117813527e-02f, -1.125464502e-02f, -1.133112241e-02f, -1.140756731e-02f, -1.148397958e-02f, -1.156035912e-02f,
-1.163670578e-02f, -1.171301945e-02f, -1.178930000e-02f, -1.186554731e-02f, -1.194176124e-02f, -1.201794169e-02f, -1.209408851e-02f, -1.217020158e-02f, -1.224628079e-02f, -1.232232600e-02f,
-1.239833710e-02f, -1.247431395e-02f, -1.255025643e-02f, -1.262616442e-02f, -1.270203779e-02f, -1.277787643e-02f, -1.285368019e-02f, -1.292944897e-02f, -1.300518264e-02f, -1.308088107e-02f,
-1.315654413e-02f, -1.323217172e-02f, -1.330776369e-02f, -1.338331993e-02f, -1.345884032e-02f, -1.353432473e-02f, -1.360977303e-02f, -1.368518512e-02f, -1.376056085e-02f, -1.383590011e-02f,
-1.391120277e-02f, -1.398646872e-02f, -1.406169783e-02f, -1.413688997e-02f, -1.421204503e-02f, -1.428716288e-02f, -1.436224340e-02f, -1.443728646e-02f, -1.451229195e-02f, -1.458725974e-02f,
-1.466218971e-02f, -1.473708174e-02f, -1.481193570e-02f, -1.488675148e-02f, -1.496152895e-02f, -1.503626798e-02f, -1.511096847e-02f, -1.518563028e-02f, -1.526025330e-02f, -1.533483740e-02f,
-1.540938247e-02f, -1.548388837e-02f, -1.555835500e-02f, -1.563278222e-02f, -1.570716993e-02f, -1.578151799e-02f, -1.585582628e-02f, -1.593009470e-02f, -1.600432310e-02f, -1.607851138e-02f,
-1.615265942e-02f, -1.622676709e-02f, -1.630083427e-02f, -1.637486085e-02f, -1.644884669e-02f, -1.652279170e-02f, -1.659669573e-02f, -1.667055868e-02f, -1.674438042e-02f, -1.681816084e-02f,
-1.689189981e-02f, -1.696559721e-02f, -1.703925293e-02f, -1.711286685e-02f, -1.718643884e-02f, -1.725996879e-02f, -1.733345658e-02f, -1.740690209e-02f, -1.748030520e-02f, -1.755366580e-02f,
-1.762698375e-02f, -1.770025896e-02f, -1.777349129e-02f, -1.784668063e-02f, -1.791982685e-02f, -1.799292985e-02f, -1.806598951e-02f, -1.813900570e-02f, -1.821197830e-02f, -1.828490721e-02f,
-1.835779230e-02f, -1.843063346e-02f, -1.850343056e-02f, -1.857618349e-02f, -1.864889213e-02f, -1.872155637e-02f, -1.879417609e-02f, -1.886675117e-02f, -1.893928149e-02f, -1.901176694e-02f,
-1.908420740e-02f, -1.915660276e-02f, -1.922895289e-02f, -1.930125768e-02f, -1.937351702e-02f, -1.944573078e-02f, -1.951789886e-02f, -1.959002113e-02f, -1.966209749e-02f, -1.973412780e-02f,
-1.980611197e-02f, -1.987804986e-02f, -1.994994138e-02f, -2.002178639e-02f, -2.009358479e-02f, -2.016533646e-02f, -2.023704129e-02f, -2.030869916e-02f, -2.038030995e-02f, -2.045187355e-02f,
-2.052338985e-02f, -2.059485873e-02f, -2.066628008e-02f, -2.073765377e-02f, -2.080897971e-02f, -2.088025776e-02f, -2.095148783e-02f, -2.102266979e-02f, -2.109380353e-02f, -2.116488894e-02f,
-2.123592590e-02f, -2.130691430e-02f, -2.137785403e-02f, -2.144874496e-02f, -2.151958700e-02f, -2.159038002e-02f, -2.166112392e-02f, -2.173181857e-02f, -2.180246387e-02f, -2.187305970e-02f,
-2.194360596e-02f, -2.201410252e-02f, -2.208454927e-02f, -2.215494611e-02f, -2.222529292e-02f, -2.229558959e-02f, -2.236583600e-02f, -2.243603205e-02f, -2.250617761e-02f, -2.257627259e-02f,
-2.264631687e-02f, -2.271631033e-02f, -2.278625287e-02f, -2.285614437e-02f, -2.292598473e-02f, -2.299577382e-02f, -2.306551155e-02f, -2.313519779e-02f, -2.320483244e-02f, -2.327441539e-02f,
-2.334394653e-02f, -2.341342574e-02f, -2.348285292e-02f, -2.355222795e-02f, -2.362155073e-02f, -2.369082114e-02f, -2.376003908e-02f, -2.382920443e-02f, -2.389831708e-02f, -2.396737693e-02f,
-2.403638387e-02f, -2.410533778e-02f, -2.417423856e-02f, -2.424308610e-02f, -2.431188028e-02f, -2.438062101e-02f, -2.444930816e-02f, -2.451794163e-02f, -2.458652132e-02f, -2.465504711e-02f,
-2.472351890e-02f, -2.479193657e-02f, -2.486030002e-02f, -2.492860914e-02f, -2.499686383e-02f, -2.506506396e-02f, -2.513320945e-02f, -2.520130017e-02f, -2.526933602e-02f, -2.533731690e-02f,
-2.540524269e-02f, -2.547311330e-02f, -2.554092860e-02f, -2.560868850e-02f, -2.567639288e-02f, -2.574404165e-02f, -2.581163468e-02f, -2.587917189e-02f, -2.594665316e-02f, -2.601407838e-02f,
-2.608144745e-02f, -2.614876026e-02f, -2.621601670e-02f, -2.628321668e-02f, -2.635036008e-02f, -2.641744679e-02f, -2.648447672e-02f, -2.655144976e-02f, -2.661836580e-02f, -2.668522473e-02f,
-2.675202646e-02f, -2.681877087e-02f, -2.688545786e-02f, -2.695208733e-02f, -2.701865917e-02f, -2.708517328e-02f, -2.715162955e-02f, -2.721802787e-02f, -2.728436815e-02f, -2.735065028e-02f,
-2.741687416e-02f, -2.748303968e-02f, -2.754914674e-02f, -2.761519523e-02f, -2.768118505e-02f, -2.774711610e-02f, -2.781298827e-02f, -2.787880146e-02f, -2.794455557e-02f, -2.801025050e-02f,
-2.807588614e-02f, -2.814146239e-02f, -2.820697914e-02f, -2.827243630e-02f, -2.833783376e-02f, -2.840317142e-02f, -2.846844918e-02f, -2.853366693e-02f, -2.859882457e-02f, -2.866392201e-02f,
-2.872895914e-02f, -2.879393586e-02f, -2.885885206e-02f, -2.892370765e-02f, -2.898850252e-02f, -2.905323658e-02f, -2.911790972e-02f, -2.918252184e-02f, -2.924707284e-02f, -2.931156262e-02f,
-2.937599109e-02f, -2.944035813e-02f, -2.950466365e-02f, -2.956890755e-02f, -2.963308974e-02f, -2.969721010e-02f, -2.976126854e-02f, -2.982526496e-02f, -2.988919926e-02f, -2.995307134e-02f,
-3.001688111e-02f, -3.008062846e-02f, -3.014431329e-02f, -3.020793550e-02f, -3.027149501e-02f, -3.033499170e-02f, -3.039842548e-02f, -3.046179625e-02f, -3.052510392e-02f, -3.058834837e-02f,
-3.065152953e-02f, -3.071464728e-02f, -3.077770154e-02f, -3.084069219e-02f, -3.090361916e-02f, -3.096648233e-02f, -3.102928161e-02f, -3.109201691e-02f, -3.115468812e-02f, -3.121729515e-02f,
-3.127983791e-02f, -3.134231629e-02f, -3.140473021e-02f, -3.146707955e-02f, -3.152936424e-02f, -3.159158416e-02f, -3.165373923e-02f, -3.171582935e-02f, -3.177785442e-02f, -3.183981435e-02f,
-3.190170905e-02f, -3.196353841e-02f, -3.202530234e-02f, -3.208700075e-02f, -3.214863354e-02f, -3.221020061e-02f, -3.227170188e-02f, -3.233313725e-02f, -3.239450662e-02f, -3.245580990e-02f,
-3.251704699e-02f, -3.257821780e-02f, -3.263932224e-02f, -3.270036021e-02f, -3.276133162e-02f, -3.282223638e-02f, -3.288307438e-02f, -3.294384555e-02f, -3.300454978e-02f, -3.306518698e-02f,
-3.312575706e-02f, -3.318625992e-02f, -3.324669548e-02f, -3.330706365e-02f, -3.336736432e-02f, -3.342759740e-02f, -3.348776281e-02f, -3.354786045e-02f, -3.360789024e-02f, -3.366785207e-02f,
-3.372774585e-02f, -3.378757150e-02f, -3.384732893e-02f, -3.390701804e-02f, -3.396663874e-02f, -3.402619094e-02f, -3.408567455e-02f, -3.414508948e-02f, -3.420443563e-02f, -3.426371293e-02f,
-3.432292127e-02f, -3.438206057e-02f, -3.444113074e-02f, -3.450013168e-02f, -3.455906331e-02f, -3.461792554e-02f, -3.467671827e-02f, -3.473544143e-02f, -3.479409491e-02f, -3.485267864e-02f,
-3.491119252e-02f, -3.496963646e-02f, -3.502801037e-02f, -3.508631417e-02f, -3.514454776e-02f, -3.520271106e-02f, -3.526080399e-02f, -3.531882644e-02f, -3.537677834e-02f, -3.543465960e-02f,
-3.549247012e-02f, -3.555020983e-02f, -3.560787863e-02f, -3.566547643e-02f, -3.572300316e-02f, -3.578045871e-02f, -3.583784302e-02f, -3.589515598e-02f, -3.595239751e-02f, -3.600956753e-02f,
-3.606666595e-02f, -3.612369268e-02f, -3.618064764e-02f, -3.623753074e-02f, -3.629434190e-02f, -3.635108102e-02f, -3.640774803e-02f, -3.646434284e-02f, -3.652086536e-02f, -3.657731551e-02f,
-3.663369321e-02f, -3.668999836e-02f, -3.674623089e-02f, -3.680239071e-02f, -3.685847773e-02f, -3.691449188e-02f, -3.697043306e-02f, -3.702630120e-02f, -3.708209620e-02f, -3.713781799e-02f,
-3.719346648e-02f, -3.724904159e-02f, -3.730454323e-02f, -3.735997133e-02f, -3.741532579e-02f, -3.747060655e-02f, -3.752581350e-02f, -3.758094658e-02f, -3.763600569e-02f, -3.769099076e-02f,
-3.774590170e-02f, -3.780073844e-02f, -3.785550088e-02f, -3.791018896e-02f, -3.796480258e-02f, -3.801934166e-02f, -3.807380613e-02f, -3.812819590e-02f, -3.818251089e-02f, -3.823675102e-02f,
-3.829091621e-02f, -3.834500638e-02f, -3.839902145e-02f, -3.845296134e-02f, -3.850682596e-02f, -3.856061525e-02f, -3.861432911e-02f, -3.866796747e-02f, -3.872153024e-02f, -3.877501736e-02f,
-3.882842874e-02f, -3.888176429e-02f, -3.893502395e-02f, -3.898820763e-02f, -3.904131525e-02f, -3.909434674e-02f, -3.914730201e-02f, -3.920018100e-02f, -3.925298361e-02f, -3.930570977e-02f,
-3.935835941e-02f, -3.941093244e-02f, -3.946342879e-02f, -3.951584838e-02f, -3.956819114e-02f, -3.962045698e-02f, -3.967264583e-02f, -3.972475761e-02f, -3.977679225e-02f, -3.982874967e-02f,
-3.988062979e-02f, -3.993243253e-02f, -3.998415782e-02f, -4.003580559e-02f, -4.008737576e-02f, -4.013886824e-02f, -4.019028297e-02f, -4.024161988e-02f, -4.029287887e-02f, -4.034405989e-02f,
-4.039516286e-02f, -4.044618769e-02f, -4.049713432e-02f, -4.054800267e-02f, -4.059879266e-02f, -4.064950423e-02f, -4.070013729e-02f, -4.075069178e-02f, -4.080116762e-02f, -4.085156473e-02f,
-4.090188304e-02f, -4.095212249e-02f, -4.100228299e-02f, -4.105236447e-02f, -4.110236686e-02f, -4.115229009e-02f, -4.120213408e-02f, -4.125189876e-02f, -4.130158406e-02f, -4.135118991e-02f,
-4.140071623e-02f, -4.145016295e-02f, -4.149953001e-02f, -4.154881732e-02f, -4.159802482e-02f, -4.164715243e-02f, -4.169620009e-02f, -4.174516773e-02f, -4.179405526e-02f, -4.184286263e-02f,
-4.189158976e-02f, -4.194023657e-02f, -4.198880301e-02f, -4.203728900e-02f, -4.208569447e-02f, -4.213401934e-02f, -4.218226356e-02f, -4.223042704e-02f, -4.227850973e-02f, -4.232651155e-02f,
-4.237443243e-02f, -4.242227231e-02f, -4.247003111e-02f, -4.251770876e-02f, -4.256530520e-02f, -4.261282036e-02f, -4.266025417e-02f, -4.270760656e-02f, -4.275487747e-02f, -4.280206682e-02f,
-4.284917455e-02f, -4.289620060e-02f, -4.294314488e-02f, -4.299000734e-02f, -4.303678792e-02f, -4.308348653e-02f, -4.313010312e-02f, -4.317663762e-02f, -4.322308996e-02f, -4.326946008e-02f,
-4.331574790e-02f, -4.336195338e-02f, -4.340807643e-02f, -4.345411699e-02f, -4.350007499e-02f, -4.354595038e-02f, -4.359174309e-02f, -4.363745305e-02f, -4.368308019e-02f, -4.372862445e-02f,
-4.377408577e-02f, -4.381946408e-02f, -4.386475932e-02f, -4.390997142e-02f, -4.395510032e-02f, -4.400014596e-02f, -4.404510827e-02f, -4.408998719e-02f, -4.413478265e-02f, -4.417949459e-02f,
-4.422412295e-02f, -4.426866766e-02f, -4.431312867e-02f, -4.435750590e-02f, -4.440179931e-02f, -4.444600881e-02f, -4.449013436e-02f, -4.453417589e-02f, -4.457813334e-02f, -4.462200664e-02f,
-4.466579574e-02f, -4.470950057e-02f, -4.475312108e-02f, -4.479665719e-02f, -4.484010886e-02f, -4.488347601e-02f, -4.492675859e-02f, -4.496995654e-02f, -4.501306980e-02f, -4.505609830e-02f,
-4.509904199e-02f, -4.514190081e-02f, -4.518467470e-02f, -4.522736359e-02f, -4.526996743e-02f, -4.531248616e-02f, -4.535491972e-02f, -4.539726805e-02f, -4.543953109e-02f, -4.548170879e-02f,
-4.552380108e-02f, -4.556580790e-02f, -4.560772920e-02f, -4.564956493e-02f, -4.569131501e-02f, -4.573297940e-02f, -4.577455804e-02f, -4.581605086e-02f, -4.585745782e-02f, -4.589877885e-02f,
-4.594001390e-02f, -4.598116291e-02f, -4.602222582e-02f, -4.606320258e-02f, -4.610409313e-02f, -4.614489742e-02f, -4.618561539e-02f, -4.622624698e-02f, -4.626679213e-02f, -4.630725080e-02f,
-4.634762293e-02f, -4.638790845e-02f, -4.642810732e-02f, -4.646821948e-02f, -4.650824488e-02f, -4.654818346e-02f, -4.658803517e-02f, -4.662779994e-02f, -4.666747774e-02f, -4.670706850e-02f,
-4.674657218e-02f, -4.678598870e-02f, -4.682531804e-02f, -4.686456012e-02f, -4.690371490e-02f, -4.694278232e-02f, -4.698176233e-02f, -4.702065488e-02f, -4.705945991e-02f, -4.709817738e-02f,
-4.713680723e-02f, -4.717534941e-02f, -4.721380386e-02f, -4.725217054e-02f, -4.729044939e-02f, -4.732864036e-02f, -4.736674340e-02f, -4.740475846e-02f, -4.744268549e-02f, -4.748052443e-02f,
-4.751827524e-02f, -4.755593787e-02f, -4.759351226e-02f, -4.763099837e-02f, -4.766839614e-02f, -4.770570553e-02f, -4.774292648e-02f, -4.778005895e-02f, -4.781710288e-02f, -4.785405823e-02f,
-4.789092495e-02f, -4.792770298e-02f, -4.796439229e-02f, -4.800099282e-02f, -4.803750452e-02f, -4.807392734e-02f, -4.811026124e-02f, -4.814650617e-02f, -4.818266208e-02f, -4.821872892e-02f,
-4.825470665e-02f, -4.829059522e-02f, -4.832639457e-02f, -4.836210467e-02f, -4.839772546e-02f, -4.843325691e-02f, -4.846869896e-02f, -4.850405156e-02f, -4.853931468e-02f, -4.857448826e-02f,
-4.860957226e-02f, -4.864456663e-02f, -4.867947133e-02f, -4.871428631e-02f, -4.874901152e-02f, -4.878364693e-02f, -4.881819248e-02f, -4.885264814e-02f, -4.888701385e-02f, -4.892128957e-02f,
-4.895547526e-02f, -4.898957088e-02f, -4.902357637e-02f, -4.905749170e-02f, -4.909131682e-02f, -4.912505169e-02f, -4.915869627e-02f, -4.919225051e-02f, -4.922571436e-02f, -4.925908779e-02f,
-4.929237076e-02f, -4.932556322e-02f, -4.935866512e-02f, -4.939167643e-02f, -4.942459710e-02f, -4.945742710e-02f, -4.949016638e-02f, -4.952281489e-02f, -4.955537260e-02f, -4.958783947e-02f,
-4.962021545e-02f, -4.965250051e-02f, -4.968469460e-02f, -4.971679768e-02f, -4.974880971e-02f, -4.978073066e-02f, -4.981256047e-02f, -4.984429912e-02f, -4.987594656e-02f, -4.990750275e-02f,
-4.993896765e-02f, -4.997034123e-02f, -5.000162344e-02f, -5.003281424e-02f, -5.006391360e-02f, -5.009492148e-02f, -5.012583784e-02f, -5.015666263e-02f, -5.018739583e-02f, -5.021803740e-02f,
-5.024858728e-02f, -5.027904546e-02f, -5.030941189e-02f, -5.033968653e-02f, -5.036986935e-02f, -5.039996030e-02f, -5.042995936e-02f, -5.045986649e-02f, -5.048968164e-02f, -5.051940479e-02f,
-5.054903589e-02f, -5.057857491e-02f, -5.060802182e-02f, -5.063737657e-02f, -5.066663914e-02f, -5.069580948e-02f, -5.072488757e-02f, -5.075387336e-02f, -5.078276682e-02f, -5.081156793e-02f,
-5.084027663e-02f, -5.086889290e-02f, -5.089741671e-02f, -5.092584802e-02f, -5.095418679e-02f, -5.098243299e-02f, -5.101058659e-02f, -5.103864756e-02f, -5.106661585e-02f, -5.109449145e-02f,
-5.112227431e-02f, -5.114996440e-02f, -5.117756169e-02f, -5.120506615e-02f, -5.123247774e-02f, -5.125979643e-02f, -5.128702220e-02f, -5.131415500e-02f, -5.134119482e-02f, -5.136814160e-02f,
-5.139499533e-02f, -5.142175598e-02f, -5.144842350e-02f, -5.147499788e-02f, -5.150147907e-02f, -5.152786706e-02f, -5.155416180e-02f, -5.158036327e-02f, -5.160647145e-02f, -5.163248629e-02f,
-5.165840777e-02f, -5.168423586e-02f, -5.170997053e-02f, -5.173561175e-02f, -5.176115949e-02f, -5.178661372e-02f, -5.181197442e-02f, -5.183724156e-02f, -5.186241510e-02f, -5.188749502e-02f,
-5.191248130e-02f, -5.193737389e-02f, -5.196217278e-02f, -5.198687794e-02f, -5.201148934e-02f, -5.203600695e-02f, -5.206043074e-02f, -5.208476070e-02f, -5.210899678e-02f, -5.213313898e-02f,
-5.215718725e-02f, -5.218114157e-02f, -5.220500192e-02f, -5.222876827e-02f, -5.225244060e-02f, -5.227601887e-02f, -5.229950307e-02f, -5.232289317e-02f, -5.234618913e-02f, -5.236939095e-02f,
-5.239249859e-02f, -5.241551203e-02f, -5.243843124e-02f, -5.246125621e-02f, -5.248398690e-02f, -5.250662329e-02f, -5.252916536e-02f, -5.255161308e-02f, -5.257396643e-02f, -5.259622539e-02f,
-5.261838994e-02f, -5.264046004e-02f, -5.266243569e-02f, -5.268431685e-02f, -5.270610350e-02f, -5.272779563e-02f, -5.274939320e-02f, -5.277089620e-02f, -5.279230460e-02f, -5.281361839e-02f,
-5.283483754e-02f, -5.285596203e-02f, -5.287699184e-02f, -5.289792694e-02f, -5.291876733e-02f, -5.293951297e-02f, -5.296016384e-02f, -5.298071993e-02f, -5.300118122e-02f, -5.302154768e-02f,
-5.304181930e-02f, -5.306199605e-02f, -5.308207792e-02f, -5.310206489e-02f, -5.312195693e-02f, -5.314175403e-02f, -5.316145617e-02f, -5.318106333e-02f, -5.320057550e-02f, -5.321999265e-02f,
-5.323931476e-02f, -5.325854182e-02f, -5.327767381e-02f, -5.329671072e-02f, -5.331565251e-02f, -5.333449919e-02f, -5.335325072e-02f, -5.337190710e-02f, -5.339046830e-02f, -5.340893431e-02f,
-5.342730512e-02f, -5.344558070e-02f, -5.346376104e-02f, -5.348184612e-02f, -5.349983593e-02f, -5.351773046e-02f, -5.353552968e-02f, -5.355323358e-02f, -5.357084215e-02f, -5.358835536e-02f,
-5.360577322e-02f, -5.362309569e-02f, -5.364032277e-02f, -5.365745444e-02f, -5.367449069e-02f, -5.369143151e-02f, -5.370827687e-02f, -5.372502677e-02f, -5.374168119e-02f, -5.375824012e-02f,
-5.377470355e-02f, -5.379107145e-02f, -5.380734383e-02f, -5.382352066e-02f, -5.383960194e-02f, -5.385558765e-02f, -5.387147778e-02f, -5.388727232e-02f, -5.390297125e-02f, -5.391857456e-02f,
-5.393408225e-02f, -5.394949429e-02f, -5.396481069e-02f, -5.398003142e-02f, -5.399515648e-02f, -5.401018585e-02f, -5.402511954e-02f, -5.403995751e-02f, -5.405469977e-02f, -5.406934631e-02f,
-5.408389711e-02f, -5.409835216e-02f, -5.411271146e-02f, -5.412697499e-02f, -5.414114275e-02f, -5.415521473e-02f, -5.416919091e-02f, -5.418307130e-02f, -5.419685587e-02f, -5.421054463e-02f,
-5.422413756e-02f, -5.423763466e-02f, -5.425103591e-02f, -5.426434131e-02f, -5.427755086e-02f, -5.429066453e-02f, -5.430368234e-02f, -5.431660427e-02f, -5.432943031e-02f, -5.434216045e-02f,
-5.435479469e-02f, -5.436733303e-02f, -5.437977545e-02f, -5.439212196e-02f, -5.440437253e-02f, -5.441652718e-02f, -5.442858589e-02f, -5.444054865e-02f, -5.445241547e-02f, -5.446418633e-02f,
-5.447586124e-02f, -5.448744018e-02f, -5.449892315e-02f, -5.451031015e-02f, -5.452160117e-02f, -5.453279621e-02f, -5.454389527e-02f, -5.455489834e-02f, -5.456580541e-02f, -5.457661649e-02f,
-5.458733156e-02f, -5.459795063e-02f, -5.460847370e-02f, -5.461890076e-02f, -5.462923180e-02f, -5.463946683e-02f, -5.464960585e-02f, -5.465964884e-02f, -5.466959581e-02f, -5.467944676e-02f,
-5.468920169e-02f, -5.469886058e-02f, -5.470842345e-02f, -5.471789029e-02f, -5.472726110e-02f, -5.473653588e-02f, -5.474571463e-02f, -5.475479734e-02f, -5.476378402e-02f, -5.477267466e-02f,
-5.478146927e-02f, -5.479016785e-02f, -5.479877040e-02f, -5.480727691e-02f, -5.481568738e-02f, -5.482400183e-02f, -5.483222025e-02f, -5.484034263e-02f, -5.484836899e-02f, -5.485629932e-02f,
-5.486413362e-02f, -5.487187190e-02f, -5.487951415e-02f, -5.488706039e-02f, -5.489451060e-02f, -5.490186480e-02f, -5.490912299e-02f, -5.491628516e-02f, -5.492335133e-02f, -5.493032149e-02f,
-5.493719565e-02f, -5.494397382e-02f, -5.495065598e-02f, -5.495724216e-02f, -5.496373234e-02f, -5.497012655e-02f, -5.497642477e-02f, -5.498262702e-02f, -5.498873330e-02f, -5.499474361e-02f,
-5.500065795e-02f, -5.500647635e-02f, -5.501219879e-02f, -5.501782528e-02f, -5.502335583e-02f, -5.502879045e-02f, -5.503412914e-02f, -5.503937190e-02f, -5.504451875e-02f, -5.504956969e-02f,
-5.505452472e-02f, -5.505938385e-02f, -5.506414709e-02f, -5.506881444e-02f, -5.507338592e-02f, -5.507786153e-02f, -5.508224127e-02f, -5.508652516e-02f, -5.509071320e-02f, -5.509480540e-02f,
-5.509880177e-02f, -5.510270232e-02f, -5.510650704e-02f, -5.511021597e-02f, -5.511382909e-02f, -5.511734642e-02f, -5.512076798e-02f, -5.512409376e-02f, -5.512732378e-02f, -5.513045804e-02f,
-5.513349657e-02f, -5.513643936e-02f, -5.513928643e-02f, -5.514203778e-02f, -5.514469344e-02f, -5.514725339e-02f, -5.514971767e-02f, -5.515208628e-02f, -5.515435923e-02f, -5.515653653e-02f,
-5.515861819e-02f, -5.516060422e-02f, -5.516249464e-02f, -5.516428946e-02f, -5.516598868e-02f, -5.516759233e-02f, -5.516910041e-02f, -5.517051293e-02f, -5.517182992e-02f, -5.517305137e-02f,
-5.517417731e-02f, -5.517520775e-02f, -5.517614269e-02f, -5.517698216e-02f, -5.517772616e-02f, -5.517837472e-02f, -5.517892784e-02f, -5.517938554e-02f, -5.517974783e-02f, -5.518001473e-02f,
-5.518018625e-02f, -5.518026240e-02f, -5.518024321e-02f, -5.518012868e-02f, -5.517991883e-02f, -5.517961368e-02f, -5.517921324e-02f, -5.517871752e-02f, -5.517812655e-02f, -5.517744034e-02f,
-5.517665890e-02f, -5.517578226e-02f, -5.517481042e-02f, -5.517374340e-02f, -5.517258123e-02f, -5.517132391e-02f, -5.516997147e-02f, -5.516852392e-02f, -5.516698128e-02f, -5.516534357e-02f,
-5.516361080e-02f, -5.516178299e-02f, -5.515986016e-02f, -5.515784233e-02f, -5.515572952e-02f, -5.515352174e-02f, -5.515121902e-02f, -5.514882137e-02f, -5.514632881e-02f, -5.514374136e-02f,
-5.514105904e-02f, -5.513828187e-02f, -5.513540986e-02f, -5.513244305e-02f, -5.512938145e-02f, -5.512622507e-02f, -5.512297394e-02f, -5.511962808e-02f, -5.511618751e-02f, -5.511265225e-02f,
-5.510902233e-02f, -5.510529775e-02f, -5.510147855e-02f, -5.509756474e-02f, -5.509355635e-02f, -5.508945340e-02f, -5.508525590e-02f, -5.508096389e-02f, -5.507657738e-02f, -5.507209640e-02f,
-5.506752096e-02f, -5.506285110e-02f, -5.505808683e-02f, -5.505322817e-02f, -5.504827516e-02f, -5.504322780e-02f, -5.503808614e-02f, -5.503285018e-02f, -5.502751996e-02f, -5.502209549e-02f,
-5.501657681e-02f, -5.501096393e-02f, -5.500525688e-02f, -5.499945568e-02f, -5.499356037e-02f, -5.498757095e-02f, -5.498148747e-02f, -5.497530994e-02f, -5.496903839e-02f, -5.496267284e-02f,
-5.495621332e-02f, -5.494965986e-02f, -5.494301247e-02f, -5.493627120e-02f, -5.492943606e-02f, -5.492250708e-02f, -5.491548429e-02f, -5.490836770e-02f, -5.490115736e-02f, -5.489385329e-02f,
-5.488645551e-02f, -5.487896405e-02f, -5.487137894e-02f, -5.486370020e-02f, -5.485592787e-02f, -5.484806198e-02f, -5.484010254e-02f, -5.483204959e-02f, -5.482390316e-02f, -5.481566327e-02f,
-5.480732995e-02f, -5.479890324e-02f, -5.479038316e-02f, -5.478176974e-02f, -5.477306301e-02f, -5.476426300e-02f, -5.475536974e-02f, -5.474638326e-02f, -5.473730359e-02f, -5.472813075e-02f,
-5.471886479e-02f, -5.470950572e-02f, -5.470005359e-02f, -5.469050841e-02f, -5.468087023e-02f, -5.467113907e-02f, -5.466131496e-02f, -5.465139794e-02f, -5.464138803e-02f, -5.463128527e-02f,
-5.462108969e-02f, -5.461080133e-02f, -5.460042020e-02f, -5.458994636e-02f, -5.457937982e-02f, -5.456872062e-02f, -5.455796880e-02f, -5.454712438e-02f, -5.453618740e-02f, -5.452515789e-02f,
-5.451403589e-02f, -5.450282143e-02f, -5.449151454e-02f, -5.448011526e-02f, -5.446862362e-02f, -5.445703965e-02f, -5.444536340e-02f, -5.443359488e-02f, -5.442173414e-02f, -5.440978122e-02f,
-5.439773614e-02f, -5.438559894e-02f, -5.437336966e-02f, -5.436104834e-02f, -5.434863500e-02f, -5.433612968e-02f, -5.432353243e-02f, -5.431084327e-02f, -5.429806224e-02f, -5.428518937e-02f,
-5.427222471e-02f, -5.425916829e-02f, -5.424602015e-02f, -5.423278032e-02f, -5.421944884e-02f, -5.420602575e-02f, -5.419251108e-02f, -5.417890488e-02f, -5.416520717e-02f, -5.415141801e-02f,
-5.413753741e-02f, -5.412356543e-02f, -5.410950210e-02f, -5.409534746e-02f, -5.408110155e-02f, -5.406676441e-02f, -5.405233607e-02f, -5.403781657e-02f, -5.402320596e-02f, -5.400850427e-02f,
-5.399371154e-02f, -5.397882782e-02f, -5.396385313e-02f, -5.394878752e-02f, -5.393363104e-02f, -5.391838371e-02f, -5.390304559e-02f, -5.388761671e-02f, -5.387209710e-02f, -5.385648683e-02f,
-5.384078591e-02f, -5.382499440e-02f, -5.380911233e-02f, -5.379313975e-02f, -5.377707670e-02f, -5.376092322e-02f, -5.374467934e-02f, -5.372834513e-02f, -5.371192060e-02f, -5.369540582e-02f,
-5.367880081e-02f, -5.366210562e-02f, -5.364532030e-02f, -5.362844489e-02f, -5.361147943e-02f, -5.359442396e-02f, -5.357727852e-02f, -5.356004317e-02f, -5.354271794e-02f, -5.352530287e-02f,
-5.350779802e-02f, -5.349020342e-02f, -5.347251912e-02f, -5.345474516e-02f, -5.343688159e-02f, -5.341892845e-02f, -5.340088579e-02f, -5.338275365e-02f, -5.336453207e-02f, -5.334622111e-02f,
-5.332782080e-02f, -5.330933119e-02f, -5.329075233e-02f, -5.327208426e-02f, -5.325332703e-02f, -5.323448069e-02f, -5.321554528e-02f, -5.319652084e-02f, -5.317740743e-02f, -5.315820508e-02f,
-5.313891385e-02f, -5.311953379e-02f, -5.310006494e-02f, -5.308050734e-02f, -5.306086105e-02f, -5.304112611e-02f, -5.302130257e-02f, -5.300139048e-02f, -5.298138988e-02f, -5.296130082e-02f,
-5.294112336e-02f, -5.292085753e-02f, -5.290050340e-02f, -5.288006100e-02f, -5.285953038e-02f, -5.283891160e-02f, -5.281820470e-02f, -5.279740974e-02f, -5.277652675e-02f, -5.275555580e-02f,
-5.273449692e-02f, -5.271335018e-02f, -5.269211561e-02f, -5.267079328e-02f, -5.264938322e-02f, -5.262788550e-02f, -5.260630015e-02f, -5.258462724e-02f, -5.256286681e-02f, -5.254101891e-02f,
-5.251908359e-02f, -5.249706091e-02f, -5.247495092e-02f, -5.245275366e-02f, -5.243046919e-02f, -5.240809756e-02f, -5.238563882e-02f, -5.236309303e-02f, -5.234046023e-02f, -5.231774049e-02f,
-5.229493384e-02f, -5.227204034e-02f, -5.224906006e-02f, -5.222599303e-02f, -5.220283931e-02f, -5.217959896e-02f, -5.215627202e-02f, -5.213285856e-02f, -5.210935862e-02f, -5.208577226e-02f,
-5.206209954e-02f, -5.203834049e-02f, -5.201449519e-02f, -5.199056369e-02f, -5.196654603e-02f, -5.194244228e-02f, -5.191825248e-02f, -5.189397669e-02f, -5.186961498e-02f, -5.184516738e-02f,
-5.182063397e-02f, -5.179601478e-02f, -5.177130989e-02f, -5.174651934e-02f, -5.172164319e-02f, -5.169668149e-02f, -5.167163431e-02f, -5.164650169e-02f, -5.162128370e-02f, -5.159598038e-02f,
-5.157059181e-02f, -5.154511802e-02f, -5.151955909e-02f, -5.149391507e-02f, -5.146818600e-02f, -5.144237196e-02f, -5.141647300e-02f, -5.139048918e-02f, -5.136442055e-02f, -5.133826717e-02f,
-5.131202910e-02f, -5.128570640e-02f, -5.125929912e-02f, -5.123280733e-02f, -5.120623108e-02f, -5.117957043e-02f, -5.115282544e-02f, -5.112599618e-02f, -5.109908268e-02f, -5.107208503e-02f,
-5.104500327e-02f, -5.101783746e-02f, -5.099058767e-02f, -5.096325396e-02f, -5.093583638e-02f, -5.090833499e-02f, -5.088074986e-02f, -5.085308104e-02f, -5.082532860e-02f, -5.079749259e-02f,
-5.076957308e-02f, -5.074157012e-02f, -5.071348379e-02f, -5.068531413e-02f, -5.065706121e-02f, -5.062872509e-02f, -5.060030583e-02f, -5.057180350e-02f, -5.054321815e-02f, -5.051454985e-02f,
-5.048579865e-02f, -5.045696463e-02f, -5.042804784e-02f, -5.039904835e-02f, -5.036996621e-02f, -5.034080150e-02f, -5.031155427e-02f, -5.028222458e-02f, -5.025281251e-02f, -5.022331810e-02f,
-5.019374143e-02f, -5.016408256e-02f, -5.013434155e-02f, -5.010451847e-02f, -5.007461338e-02f, -5.004462634e-02f, -5.001455742e-02f, -4.998440668e-02f, -4.995417418e-02f, -4.992386000e-02f,
-4.989346419e-02f, -4.986298682e-02f, -4.983242795e-02f, -4.980178765e-02f, -4.977106599e-02f, -4.974026302e-02f, -4.970937882e-02f, -4.967841346e-02f, -4.964736698e-02f, -4.961623947e-02f,
-4.958503098e-02f, -4.955374159e-02f, -4.952237136e-02f, -4.949092035e-02f, -4.945938863e-02f, -4.942777628e-02f, -4.939608334e-02f, -4.936430990e-02f, -4.933245602e-02f, -4.930052176e-02f,
-4.926850719e-02f, -4.923641238e-02f, -4.920423740e-02f, -4.917198232e-02f, -4.913964719e-02f, -4.910723210e-02f, -4.907473710e-02f, -4.904216227e-02f, -4.900950767e-02f, -4.897677338e-02f,
-4.894395945e-02f, -4.891106596e-02f, -4.887809298e-02f, -4.884504058e-02f, -4.881190882e-02f, -4.877869777e-02f, -4.874540751e-02f, -4.871203810e-02f, -4.867858961e-02f, -4.864506211e-02f,
-4.861145568e-02f, -4.857777037e-02f, -4.854400626e-02f, -4.851016343e-02f, -4.847624193e-02f, -4.844224184e-02f, -4.840816324e-02f, -4.837400618e-02f, -4.833977075e-02f, -4.830545701e-02f,
-4.827106504e-02f, -4.823659489e-02f, -4.820204666e-02f, -4.816742040e-02f, -4.813271619e-02f, -4.809793409e-02f, -4.806307419e-02f, -4.802813655e-02f, -4.799312125e-02f, -4.795802835e-02f,
-4.792285793e-02f, -4.788761006e-02f, -4.785228482e-02f, -4.781688227e-02f, -4.778140249e-02f, -4.774584555e-02f, -4.771021152e-02f, -4.767450048e-02f, -4.763871249e-02f, -4.760284764e-02f,
-4.756690600e-02f, -4.753088764e-02f, -4.749479262e-02f, -4.745862104e-02f, -4.742237295e-02f, -4.738604844e-02f, -4.734964758e-02f, -4.731317043e-02f, -4.727661709e-02f, -4.723998761e-02f,
-4.720328208e-02f, -4.716650057e-02f, -4.712964315e-02f, -4.709270991e-02f, -4.705570090e-02f, -4.701861622e-02f, -4.698145593e-02f, -4.694422011e-02f, -4.690690883e-02f, -4.686952218e-02f,
-4.683206022e-02f, -4.679452303e-02f, -4.675691070e-02f, -4.671922328e-02f, -4.668146086e-02f, -4.664362353e-02f, -4.660571134e-02f, -4.656772438e-02f, -4.652966273e-02f, -4.649152646e-02f,
-4.645331565e-02f, -4.641503037e-02f, -4.637667071e-02f, -4.633823673e-02f, -4.629972853e-02f, -4.626114617e-02f, -4.622248973e-02f, -4.618375929e-02f, -4.614495493e-02f, -4.610607672e-02f,
-4.606712475e-02f, -4.602809909e-02f, -4.598899982e-02f, -4.594982701e-02f, -4.591058075e-02f, -4.587126112e-02f, -4.583186819e-02f, -4.579240204e-02f, -4.575286276e-02f, -4.571325041e-02f,
-4.567356508e-02f, -4.563380685e-02f, -4.559397580e-02f, -4.555407201e-02f, -4.551409555e-02f, -4.547404651e-02f, -4.543392496e-02f, -4.539373099e-02f, -4.535346468e-02f, -4.531312610e-02f,
-4.527271534e-02f, -4.523223247e-02f, -4.519167759e-02f, -4.515105075e-02f, -4.511035206e-02f, -4.506958159e-02f, -4.502873941e-02f, -4.498782562e-02f, -4.494684029e-02f, -4.490578350e-02f,
-4.486465533e-02f, -4.482345587e-02f, -4.478218520e-02f, -4.474084340e-02f, -4.469943055e-02f, -4.465794673e-02f, -4.461639202e-02f, -4.457476651e-02f, -4.453307028e-02f, -4.449130341e-02f,
-4.444946599e-02f, -4.440755809e-02f, -4.436557980e-02f, -4.432353120e-02f, -4.428141237e-02f, -4.423922340e-02f, -4.419696437e-02f, -4.415463537e-02f, -4.411223647e-02f, -4.406976776e-02f,
-4.402722932e-02f, -4.398462124e-02f, -4.394194360e-02f, -4.389919649e-02f, -4.385637998e-02f, -4.381349417e-02f, -4.377053913e-02f, -4.372751496e-02f, -4.368442172e-02f, -4.364125952e-02f,
-4.359802843e-02f, -4.355472854e-02f, -4.351135994e-02f, -4.346792270e-02f, -4.342441691e-02f, -4.338084267e-02f, -4.333720004e-02f, -4.329348913e-02f, -4.324971001e-02f, -4.320586276e-02f,
-4.316194749e-02f, -4.311796426e-02f, -4.307391317e-02f, -4.302979430e-02f, -4.298560774e-02f, -4.294135358e-02f, -4.289703189e-02f, -4.285264277e-02f, -4.280818631e-02f, -4.276366258e-02f,
-4.271907168e-02f, -4.267441370e-02f, -4.262968871e-02f, -4.258489681e-02f, -4.254003809e-02f, -4.249511262e-02f, -4.245012051e-02f, -4.240506183e-02f, -4.235993667e-02f, -4.231474512e-02f,
-4.226948727e-02f, -4.222416321e-02f, -4.217877301e-02f, -4.213331678e-02f, -4.208779460e-02f, -4.204220656e-02f, -4.199655274e-02f, -4.195083324e-02f, -4.190504814e-02f, -4.185919753e-02f,
-4.181328150e-02f, -4.176730013e-02f, -4.172125353e-02f, -4.167514177e-02f, -4.162896494e-02f, -4.158272314e-02f, -4.153641645e-02f, -4.149004496e-02f, -4.144360877e-02f, -4.139710796e-02f,
-4.135054261e-02f, -4.130391283e-02f, -4.125721870e-02f, -4.121046031e-02f, -4.116363775e-02f, -4.111675111e-02f, -4.106980048e-02f, -4.102278594e-02f, -4.097570761e-02f, -4.092856555e-02f,
-4.088135986e-02f, -4.083409064e-02f, -4.078675797e-02f, -4.073936194e-02f, -4.069190265e-02f, -4.064438018e-02f, -4.059679464e-02f, -4.054914609e-02f, -4.050143465e-02f, -4.045366040e-02f,
-4.040582344e-02f, -4.035792384e-02f, -4.030996172e-02f, -4.026193715e-02f, -4.021385023e-02f, -4.016570105e-02f, -4.011748970e-02f, -4.006921628e-02f, -4.002088088e-02f, -3.997248359e-02f,
-3.992402449e-02f, -3.987550370e-02f, -3.982692129e-02f, -3.977827736e-02f, -3.972957201e-02f, -3.968080532e-02f, -3.963197739e-02f, -3.958308831e-02f, -3.953413817e-02f, -3.948512708e-02f,
-3.943605511e-02f, -3.938692237e-02f, -3.933772895e-02f, -3.928847494e-02f, -3.923916044e-02f, -3.918978553e-02f, -3.914035032e-02f, -3.909085490e-02f, -3.904129936e-02f, -3.899168379e-02f,
-3.894200829e-02f, -3.889227296e-02f, -3.884247788e-02f, -3.879262316e-02f, -3.874270888e-02f, -3.869273515e-02f, -3.864270205e-02f, -3.859260968e-02f, -3.854245815e-02f, -3.849224753e-02f,
-3.844197792e-02f, -3.839164943e-02f, -3.834126215e-02f, -3.829081617e-02f, -3.824031159e-02f, -3.818974850e-02f, -3.813912699e-02f, -3.808844718e-02f, -3.803770914e-02f, -3.798691298e-02f,
-3.793605879e-02f, -3.788514667e-02f, -3.783417671e-02f, -3.778314902e-02f, -3.773206368e-02f, -3.768092079e-02f, -3.762972045e-02f, -3.757846276e-02f, -3.752714781e-02f, -3.747577570e-02f,
-3.742434653e-02f, -3.737286038e-02f, -3.732131737e-02f, -3.726971759e-02f, -3.721806113e-02f, -3.716634809e-02f, -3.711457857e-02f, -3.706275266e-02f, -3.701087047e-02f, -3.695893209e-02f,
-3.690693762e-02f, -3.685488715e-02f, -3.680278079e-02f, -3.675061863e-02f, -3.669840077e-02f, -3.664612730e-02f, -3.659379834e-02f, -3.654141396e-02f, -3.648897428e-02f, -3.643647939e-02f,
-3.638392938e-02f, -3.633132437e-02f, -3.627866444e-02f, -3.622594969e-02f, -3.617318023e-02f, -3.612035615e-02f, -3.606747755e-02f, -3.601454453e-02f, -3.596155719e-02f, -3.590851563e-02f,
-3.585541995e-02f, -3.580227024e-02f, -3.574906660e-02f, -3.569580915e-02f, -3.564249796e-02f, -3.558913316e-02f, -3.553571482e-02f, -3.548224306e-02f, -3.542871797e-02f, -3.537513966e-02f,
-3.532150822e-02f, -3.526782375e-02f, -3.521408636e-02f, -3.516029614e-02f, -3.510645320e-02f, -3.505255763e-02f, -3.499860953e-02f, -3.494460901e-02f, -3.489055616e-02f, -3.483645110e-02f,
-3.478229390e-02f, -3.472808469e-02f, -3.467382356e-02f, -3.461951060e-02f, -3.456514593e-02f, -3.451072963e-02f, -3.445626183e-02f, -3.440174260e-02f, -3.434717206e-02f, -3.429255031e-02f,
-3.423787744e-02f, -3.418315357e-02f, -3.412837879e-02f, -3.407355320e-02f, -3.401867690e-02f, -3.396375000e-02f, -3.390877260e-02f, -3.385374480e-02f, -3.379866671e-02f, -3.374353841e-02f,
-3.368836003e-02f, -3.363313165e-02f, -3.357785339e-02f, -3.352252534e-02f, -3.346714760e-02f, -3.341172028e-02f, -3.335624349e-02f, -3.330071731e-02f, -3.324514187e-02f, -3.318951725e-02f,
-3.313384357e-02f, -3.307812092e-02f, -3.302234941e-02f, -3.296652914e-02f, -3.291066021e-02f, -3.285474273e-02f, -3.279877681e-02f, -3.274276253e-02f, -3.268670002e-02f, -3.263058936e-02f,
-3.257443067e-02f, -3.251822405e-02f, -3.246196960e-02f, -3.240566742e-02f, -3.234931763e-02f, -3.229292031e-02f, -3.223647559e-02f, -3.217998355e-02f, -3.212344431e-02f, -3.206685797e-02f,
-3.201022464e-02f, -3.195354441e-02f, -3.189681739e-02f, -3.184004369e-02f, -3.178322341e-02f, -3.172635665e-02f, -3.166944353e-02f, -3.161248414e-02f, -3.155547859e-02f, -3.149842698e-02f,
-3.144132942e-02f, -3.138418602e-02f, -3.132699687e-02f, -3.126976209e-02f, -3.121248178e-02f, -3.115515604e-02f, -3.109778498e-02f, -3.104036870e-02f, -3.098290731e-02f, -3.092540092e-02f,
-3.086784963e-02f, -3.081025355e-02f, -3.075261278e-02f, -3.069492742e-02f, -3.063719759e-02f, -3.057942338e-02f, -3.052160492e-02f, -3.046374229e-02f, -3.040583561e-02f, -3.034788498e-02f,
-3.028989050e-02f, -3.023185230e-02f, -3.017377046e-02f, -3.011564510e-02f, -3.005747633e-02f, -2.999926424e-02f, -2.994100895e-02f, -2.988271056e-02f, -2.982436919e-02f, -2.976598492e-02f,
-2.970755788e-02f, -2.964908817e-02f, -2.959057589e-02f, -2.953202116e-02f, -2.947342408e-02f, -2.941478475e-02f, -2.935610328e-02f, -2.929737979e-02f, -2.923861437e-02f, -2.917980714e-02f,
-2.912095820e-02f, -2.906206766e-02f, -2.900313562e-02f, -2.894416220e-02f, -2.888514750e-02f, -2.882609163e-02f, -2.876699469e-02f, -2.870785680e-02f, -2.864867806e-02f, -2.858945858e-02f,
-2.853019846e-02f, -2.847089782e-02f, -2.841155676e-02f, -2.835217540e-02f, -2.829275383e-02f, -2.823329216e-02f, -2.817379051e-02f, -2.811424899e-02f, -2.805466769e-02f, -2.799504674e-02f,
-2.793538623e-02f, -2.787568627e-02f, -2.781594698e-02f, -2.775616847e-02f, -2.769635083e-02f, -2.763649418e-02f, -2.757659863e-02f, -2.751666429e-02f, -2.745669126e-02f, -2.739667966e-02f,
-2.733662959e-02f, -2.727654116e-02f, -2.721641448e-02f, -2.715624966e-02f, -2.709604681e-02f, -2.703580603e-02f, -2.697552745e-02f, -2.691521116e-02f, -2.685485727e-02f, -2.679446590e-02f,
-2.673403715e-02f, -2.667357113e-02f, -2.661306795e-02f, -2.655252773e-02f, -2.649195057e-02f, -2.643133658e-02f, -2.637068586e-02f, -2.630999854e-02f, -2.624927472e-02f, -2.618851450e-02f,
-2.612771801e-02f, -2.606688534e-02f, -2.600601661e-02f, -2.594511193e-02f, -2.588417141e-02f, -2.582319515e-02f, -2.576218327e-02f, -2.570113588e-02f, -2.564005309e-02f, -2.557893501e-02f,
-2.551778175e-02f, -2.545659341e-02f, -2.539537011e-02f, -2.533411197e-02f, -2.527281908e-02f, -2.521149156e-02f, -2.515012953e-02f, -2.508873308e-02f, -2.502730234e-02f, -2.496583740e-02f,
-2.490433840e-02f, -2.484280542e-02f, -2.478123859e-02f, -2.471963801e-02f, -2.465800380e-02f, -2.459633607e-02f, -2.453463492e-02f, -2.447290047e-02f, -2.441113283e-02f, -2.434933211e-02f,
-2.428749843e-02f, -2.422563188e-02f, -2.416373259e-02f, -2.410180066e-02f, -2.403983621e-02f, -2.397783935e-02f, -2.391581018e-02f, -2.385374883e-02f, -2.379165539e-02f, -2.372952999e-02f,
-2.366737273e-02f, -2.360518373e-02f, -2.354296309e-02f, -2.348071093e-02f, -2.341842736e-02f, -2.335611249e-02f, -2.329376644e-02f, -2.323138931e-02f, -2.316898122e-02f, -2.310654227e-02f,
-2.304407259e-02f, -2.298157228e-02f, -2.291904145e-02f, -2.285648021e-02f, -2.279388869e-02f, -2.273126698e-02f, -2.266861521e-02f, -2.260593348e-02f, -2.254322190e-02f, -2.248048060e-02f,
-2.241770967e-02f, -2.235490924e-02f, -2.229207941e-02f, -2.222922029e-02f, -2.216633201e-02f, -2.210341467e-02f, -2.204046838e-02f, -2.197749325e-02f, -2.191448941e-02f, -2.185145695e-02f,
-2.178839600e-02f, -2.172530667e-02f, -2.166218906e-02f, -2.159904330e-02f, -2.153586949e-02f, -2.147266774e-02f, -2.140943817e-02f, -2.134618090e-02f, -2.128289603e-02f, -2.121958367e-02f,
-2.115624395e-02f, -2.109287697e-02f, -2.102948285e-02f, -2.096606169e-02f, -2.090261361e-02f, -2.083913873e-02f, -2.077563716e-02f, -2.071210901e-02f, -2.064855439e-02f, -2.058497341e-02f,
-2.052136620e-02f, -2.045773286e-02f, -2.039407350e-02f, -2.033038825e-02f, -2.026667720e-02f, -2.020294048e-02f, -2.013917820e-02f, -2.007539048e-02f, -2.001157741e-02f, -1.994773913e-02f,
-1.988387574e-02f, -1.981998735e-02f, -1.975607408e-02f, -1.969213605e-02f, -1.962817336e-02f, -1.956418612e-02f, -1.950017447e-02f, -1.943613849e-02f, -1.937207832e-02f, -1.930799406e-02f,
-1.924388583e-02f, -1.917975374e-02f, -1.911559790e-02f, -1.905141843e-02f, -1.898721545e-02f, -1.892298905e-02f, -1.885873937e-02f, -1.879446651e-02f, -1.873017059e-02f, -1.866585172e-02f,
-1.860151001e-02f, -1.853714558e-02f, -1.847275855e-02f, -1.840834901e-02f, -1.834391710e-02f, -1.827946293e-02f, -1.821498660e-02f, -1.815048823e-02f, -1.808596794e-02f, -1.802142585e-02f,
-1.795686205e-02f, -1.789227667e-02f, -1.782766983e-02f, -1.776304163e-02f, -1.769839219e-02f, -1.763372163e-02f, -1.756903006e-02f, -1.750431759e-02f, -1.743958434e-02f, -1.737483042e-02f,
-1.731005594e-02f, -1.724526103e-02f, -1.718044579e-02f, -1.711561034e-02f, -1.705075479e-02f, -1.698587926e-02f, -1.692098387e-02f, -1.685606871e-02f, -1.679113392e-02f, -1.672617961e-02f,
-1.666120588e-02f, -1.659621286e-02f, -1.653120066e-02f, -1.646616939e-02f, -1.640111917e-02f, -1.633605011e-02f, -1.627096233e-02f, -1.620585594e-02f, -1.614073105e-02f, -1.607558779e-02f,
-1.601042626e-02f, -1.594524658e-02f, -1.588004886e-02f, -1.581483322e-02f, -1.574959978e-02f, -1.568434864e-02f, -1.561907993e-02f, -1.555379376e-02f, -1.548849023e-02f, -1.542316948e-02f,
-1.535783160e-02f, -1.529247673e-02f, -1.522710496e-02f, -1.516171642e-02f, -1.509631122e-02f, -1.503088948e-02f, -1.496545130e-02f, -1.489999682e-02f, -1.483452613e-02f, -1.476903935e-02f,
-1.470353661e-02f, -1.463801801e-02f, -1.457248367e-02f, -1.450693371e-02f, -1.444136823e-02f, -1.437578736e-02f, -1.431019121e-02f, -1.424457989e-02f, -1.417895352e-02f, -1.411331222e-02f,
-1.404765609e-02f, -1.398198526e-02f, -1.391629983e-02f, -1.385059993e-02f, -1.378488567e-02f, -1.371915716e-02f, -1.365341453e-02f, -1.358765787e-02f, -1.352188731e-02f, -1.345610297e-02f,
-1.339030496e-02f, -1.332449339e-02f, -1.325866838e-02f, -1.319283004e-02f, -1.312697849e-02f, -1.306111385e-02f, -1.299523622e-02f, -1.292934573e-02f, -1.286344249e-02f, -1.279752661e-02f,
-1.273159821e-02f, -1.266565741e-02f, -1.259970431e-02f, -1.253373904e-02f, -1.246776172e-02f, -1.240177244e-02f, -1.233577134e-02f, -1.226975852e-02f, -1.220373410e-02f, -1.213769819e-02f,
-1.207165092e-02f, -1.200559239e-02f, -1.193952272e-02f, -1.187344203e-02f, -1.180735043e-02f, -1.174124804e-02f, -1.167513497e-02f, -1.160901133e-02f, -1.154287725e-02f, -1.147673283e-02f,
-1.141057819e-02f, -1.134441345e-02f, -1.127823872e-02f, -1.121205413e-02f, -1.114585977e-02f, -1.107965577e-02f, -1.101344224e-02f, -1.094721930e-02f, -1.088098707e-02f, -1.081474565e-02f,
-1.074849516e-02f, -1.068223573e-02f, -1.061596745e-02f, -1.054969046e-02f, -1.048340486e-02f, -1.041711077e-02f, -1.035080830e-02f, -1.028449757e-02f, -1.021817870e-02f, -1.015185180e-02f,
-1.008551698e-02f, -1.001917436e-02f, -9.952824053e-03f, -9.886466179e-03f, -9.820100849e-03f, -9.753728180e-03f, -9.687348286e-03f, -9.620961282e-03f, -9.554567284e-03f, -9.488166406e-03f,
-9.421758764e-03f, -9.355344473e-03f, -9.288923648e-03f, -9.222496403e-03f, -9.156062854e-03f, -9.089623117e-03f, -9.023177305e-03f, -8.956725535e-03f, -8.890267920e-03f, -8.823804577e-03f,
-8.757335620e-03f, -8.690861164e-03f, -8.624381324e-03f, -8.557896216e-03f, -8.491405954e-03f, -8.424910653e-03f, -8.358410428e-03f, -8.291905394e-03f, -8.225395666e-03f, -8.158881359e-03f,
-8.092362589e-03f, -8.025839469e-03f, -7.959312115e-03f, -7.892780642e-03f, -7.826245165e-03f, -7.759705798e-03f, -7.693162657e-03f, -7.626615856e-03f, -7.560065510e-03f, -7.493511734e-03f,
-7.426954643e-03f, -7.360394352e-03f, -7.293830976e-03f, -7.227264629e-03f, -7.160695426e-03f, -7.094123482e-03f, -7.027548912e-03f, -6.960971831e-03f, -6.894392353e-03f, -6.827810592e-03f,
-6.761226665e-03f, -6.694640685e-03f, -6.628052767e-03f, -6.561463026e-03f, -6.494871577e-03f, -6.428278534e-03f, -6.361684012e-03f, -6.295088125e-03f, -6.228490989e-03f, -6.161892717e-03f,
-6.095293424e-03f, -6.028693226e-03f, -5.962092235e-03f, -5.895490568e-03f, -5.828888339e-03f, -5.762285661e-03f, -5.695682650e-03f, -5.629079420e-03f, -5.562476086e-03f, -5.495872762e-03f,
-5.429269562e-03f, -5.362666601e-03f, -5.296063993e-03f, -5.229461853e-03f, -5.162860294e-03f, -5.096259433e-03f, -5.029659381e-03f, -4.963060255e-03f, -4.896462168e-03f, -4.829865235e-03f,
-4.763269570e-03f, -4.696675286e-03f, -4.630082499e-03f, -4.563491323e-03f, -4.496901871e-03f, -4.430314258e-03f, -4.363728598e-03f, -4.297145005e-03f, -4.230563594e-03f, -4.163984477e-03f,
-4.097407771e-03f, -4.030833587e-03f, -3.964262041e-03f, -3.897693247e-03f, -3.831127318e-03f, -3.764564369e-03f, -3.698004513e-03f, -3.631447864e-03f, -3.564894537e-03f, -3.498344644e-03f,
-3.431798301e-03f, -3.365255620e-03f, -3.298716716e-03f, -3.232181702e-03f, -3.165650692e-03f, -3.099123800e-03f, -3.032601140e-03f, -2.966082825e-03f, -2.899568969e-03f, -2.833059686e-03f,
-2.766555088e-03f, -2.700055291e-03f, -2.633560407e-03f, -2.567070550e-03f, -2.500585833e-03f, -2.434106371e-03f, -2.367632276e-03f, -2.301163661e-03f, -2.234700641e-03f, -2.168243329e-03f,
-2.101791838e-03f, -2.035346281e-03f, -1.968906772e-03f, -1.902473423e-03f, -1.836046350e-03f, -1.769625663e-03f, -1.703211478e-03f, -1.636803906e-03f, -1.570403062e-03f, -1.504009057e-03f,
-1.437622006e-03f, -1.371242022e-03f, -1.304869216e-03f, -1.238503703e-03f, -1.172145596e-03f, -1.105795007e-03f, -1.039452049e-03f, -9.731168359e-04f, -9.067894795e-04f, -8.404700930e-04f,
-7.741587893e-04f, -7.078556810e-04f, -6.415608811e-04f, -5.752745021e-04f, -5.089966568e-04f, -4.427274579e-04f, -3.764670179e-04f, -3.102154495e-04f, -2.439728652e-04f, -1.777393776e-04f,
-1.115150991e-04f, -4.530014231e-05f, 2.090538041e-05f, 8.710135665e-05f, 1.532876740e-04f, 2.194642202e-04f, 2.856308828e-04f, 3.517875497e-04f, 4.179341085e-04f, 4.840704471e-04f,
5.501964532e-04f, 6.163120148e-04f, 6.824170197e-04f, 7.485113558e-04f, 8.145949112e-04f, 8.806675737e-04f, 9.467292315e-04f, 1.012779773e-03f, 1.078819085e-03f, 1.144847057e-03f,
1.210863577e-03f, 1.276868532e-03f, 1.342861812e-03f, 1.408843304e-03f, 1.474812897e-03f, 1.540770479e-03f, 1.606715938e-03f, 1.672649163e-03f, 1.738570043e-03f, 1.804478465e-03f,
1.870374319e-03f, 1.936257492e-03f, 2.002127874e-03f, 2.067985354e-03f, 2.133829819e-03f, 2.199661159e-03f, 2.265479262e-03f, 2.331284017e-03f, 2.397075313e-03f, 2.462853039e-03f,
2.528617084e-03f, 2.594367336e-03f, 2.660103685e-03f, 2.725826020e-03f, 2.791534230e-03f, 2.857228204e-03f, 2.922907830e-03f, 2.988572999e-03f, 3.054223600e-03f, 3.119859521e-03f,
3.185480652e-03f, 3.251086883e-03f, 3.316678103e-03f, 3.382254200e-03f, 3.447815066e-03f, 3.513360589e-03f, 3.578890659e-03f, 3.644405165e-03f, 3.709903997e-03f, 3.775387045e-03f,
3.840854198e-03f, 3.906305347e-03f, 3.971740381e-03f, 4.037159190e-03f, 4.102561664e-03f, 4.167947692e-03f, 4.233317165e-03f, 4.298669974e-03f, 4.364006007e-03f, 4.429325155e-03f,
4.494627308e-03f, 4.559912357e-03f, 4.625180192e-03f, 4.690430702e-03f, 4.755663779e-03f, 4.820879313e-03f, 4.886077193e-03f, 4.951257312e-03f, 5.016419558e-03f, 5.081563824e-03f,
5.146689999e-03f, 5.211797974e-03f, 5.276887639e-03f, 5.341958887e-03f, 5.407011606e-03f, 5.472045689e-03f, 5.537061026e-03f, 5.602057508e-03f, 5.667035026e-03f, 5.731993471e-03f,
5.796932735e-03f, 5.861852708e-03f, 5.926753281e-03f, 5.991634346e-03f, 6.056495795e-03f, 6.121337517e-03f, 6.186159406e-03f, 6.250961352e-03f, 6.315743247e-03f, 6.380504981e-03f,
6.445246448e-03f, 6.509967539e-03f, 6.574668144e-03f, 6.639348156e-03f, 6.704007468e-03f, 6.768645969e-03f, 6.833263554e-03f, 6.897860112e-03f, 6.962435537e-03f, 7.026989721e-03f,
7.091522555e-03f, 7.156033931e-03f, 7.220523743e-03f, 7.284991882e-03f, 7.349438240e-03f, 7.413862710e-03f, 7.478265184e-03f, 7.542645554e-03f, 7.607003714e-03f, 7.671339556e-03f,
7.735652972e-03f, 7.799943855e-03f, 7.864212098e-03f, 7.928457594e-03f, 7.992680234e-03f, 8.056879913e-03f, 8.121056524e-03f, 8.185209958e-03f, 8.249340110e-03f, 8.313446872e-03f,
8.377530138e-03f, 8.441589801e-03f, 8.505625753e-03f, 8.569637889e-03f, 8.633626102e-03f, 8.697590285e-03f, 8.761530332e-03f, 8.825446136e-03f, 8.889337591e-03f, 8.953204590e-03f,
9.017047028e-03f, 9.080864798e-03f, 9.144657793e-03f, 9.208425909e-03f, 9.272169038e-03f, 9.335887075e-03f, 9.399579914e-03f, 9.463247448e-03f, 9.526889573e-03f, 9.590506182e-03f,
9.654097170e-03f, 9.717662432e-03f, 9.781201860e-03f, 9.844715351e-03f, 9.908202798e-03f, 9.971664096e-03f, 1.003509914e-02f, 1.009850782e-02f, 1.016189004e-02f, 1.022524569e-02f,
1.028857467e-02f, 1.035187686e-02f, 1.041515217e-02f, 1.047840049e-02f, 1.054162172e-02f, 1.060481574e-02f, 1.066798246e-02f, 1.073112177e-02f, 1.079423357e-02f, 1.085731775e-02f,
1.092037421e-02f, 1.098340284e-02f, 1.104640354e-02f, 1.110937620e-02f, 1.117232073e-02f, 1.123523700e-02f, 1.129812494e-02f, 1.136098441e-02f, 1.142381534e-02f, 1.148661760e-02f,
1.154939110e-02f, 1.161213573e-02f, 1.167485138e-02f, 1.173753797e-02f, 1.180019537e-02f, 1.186282349e-02f, 1.192542223e-02f, 1.198799147e-02f, 1.205053113e-02f, 1.211304108e-02f,
1.217552124e-02f, 1.223797150e-02f, 1.230039175e-02f, 1.236278189e-02f, 1.242514182e-02f, 1.248747144e-02f, 1.254977064e-02f, 1.261203932e-02f, 1.267427738e-02f, 1.273648471e-02f,
1.279866121e-02f, 1.286080679e-02f, 1.292292133e-02f, 1.298500474e-02f, 1.304705691e-02f, 1.310907774e-02f, 1.317106712e-02f, 1.323302497e-02f, 1.329495117e-02f, 1.335684562e-02f,
1.341870822e-02f, 1.348053887e-02f, 1.354233747e-02f, 1.360410391e-02f, 1.366583810e-02f, 1.372753993e-02f, 1.378920930e-02f, 1.385084611e-02f, 1.391245026e-02f, 1.397402164e-02f,
1.403556016e-02f, 1.409706572e-02f, 1.415853820e-02f, 1.421997752e-02f, 1.428138358e-02f, 1.434275626e-02f, 1.440409547e-02f, 1.446540111e-02f, 1.452667308e-02f, 1.458791128e-02f,
1.464911561e-02f, 1.471028596e-02f, 1.477142225e-02f, 1.483252435e-02f, 1.489359219e-02f, 1.495462565e-02f, 1.501562464e-02f, 1.507658905e-02f, 1.513751879e-02f, 1.519841376e-02f,
1.525927385e-02f, 1.532009898e-02f, 1.538088903e-02f, 1.544164390e-02f, 1.550236351e-02f, 1.556304775e-02f, 1.562369651e-02f, 1.568430971e-02f, 1.574488724e-02f, 1.580542900e-02f,
1.586593490e-02f, 1.592640483e-02f, 1.598683870e-02f, 1.604723640e-02f, 1.610759784e-02f, 1.616792293e-02f, 1.622821155e-02f, 1.628846362e-02f, 1.634867903e-02f, 1.640885769e-02f,
1.646899949e-02f, 1.652910435e-02f, 1.658917216e-02f, 1.664920282e-02f, 1.670919624e-02f, 1.676915231e-02f, 1.682907095e-02f, 1.688895204e-02f, 1.694879551e-02f, 1.700860124e-02f,
1.706836914e-02f, 1.712809911e-02f, 1.718779106e-02f, 1.724744488e-02f, 1.730706049e-02f, 1.736663778e-02f, 1.742617666e-02f, 1.748567702e-02f, 1.754513878e-02f, 1.760456184e-02f,
1.766394610e-02f, 1.772329145e-02f, 1.778259782e-02f, 1.784186510e-02f, 1.790109318e-02f, 1.796028199e-02f, 1.801943142e-02f, 1.807854137e-02f, 1.813761176e-02f, 1.819664247e-02f,
1.825563343e-02f, 1.831458452e-02f, 1.837349566e-02f, 1.843236675e-02f, 1.849119770e-02f, 1.854998840e-02f, 1.860873877e-02f, 1.866744871e-02f, 1.872611812e-02f, 1.878474691e-02f,
1.884333498e-02f, 1.890188224e-02f, 1.896038860e-02f, 1.901885395e-02f, 1.907727821e-02f, 1.913566127e-02f, 1.919400305e-02f, 1.925230345e-02f, 1.931056238e-02f, 1.936877974e-02f,
1.942695543e-02f, 1.948508937e-02f, 1.954318146e-02f, 1.960123160e-02f, 1.965923971e-02f, 1.971720568e-02f, 1.977512943e-02f, 1.983301086e-02f, 1.989084987e-02f, 1.994864638e-02f,
2.000640028e-02f, 2.006411150e-02f, 2.012177992e-02f, 2.017940547e-02f, 2.023698805e-02f, 2.029452756e-02f, 2.035202391e-02f, 2.040947701e-02f, 2.046688677e-02f, 2.052425309e-02f,
2.058157588e-02f, 2.063885505e-02f, 2.069609050e-02f, 2.075328215e-02f, 2.081042991e-02f, 2.086753367e-02f, 2.092459335e-02f, 2.098160886e-02f, 2.103858010e-02f, 2.109550699e-02f,
2.115238942e-02f, 2.120922732e-02f, 2.126602058e-02f, 2.132276912e-02f, 2.137947285e-02f, 2.143613167e-02f, 2.149274549e-02f, 2.154931423e-02f, 2.160583778e-02f, 2.166231607e-02f,
2.171874900e-02f, 2.177513648e-02f, 2.183147841e-02f, 2.188777472e-02f, 2.194402530e-02f, 2.200023007e-02f, 2.205638894e-02f, 2.211250181e-02f, 2.216856861e-02f, 2.222458923e-02f,
2.228056359e-02f, 2.233649159e-02f, 2.239237316e-02f, 2.244820819e-02f, 2.250399660e-02f, 2.255973831e-02f, 2.261543321e-02f, 2.267108122e-02f, 2.272668226e-02f, 2.278223623e-02f,
2.283774305e-02f, 2.289320262e-02f, 2.294861486e-02f, 2.300397968e-02f, 2.305929699e-02f, 2.311456670e-02f, 2.316978872e-02f, 2.322496297e-02f, 2.328008936e-02f, 2.333516779e-02f,
2.339019819e-02f, 2.344518046e-02f, 2.350011451e-02f, 2.355500027e-02f, 2.360983763e-02f, 2.366462651e-02f, 2.371936684e-02f, 2.377405850e-02f, 2.382870143e-02f, 2.388329554e-02f,
2.393784073e-02f, 2.399233692e-02f, 2.404678402e-02f, 2.410118195e-02f, 2.415553062e-02f, 2.420982994e-02f, 2.426407983e-02f, 2.431828020e-02f, 2.437243097e-02f, 2.442653204e-02f,
2.448058333e-02f, 2.453458476e-02f, 2.458853625e-02f, 2.464243769e-02f, 2.469628902e-02f, 2.475009013e-02f, 2.480384096e-02f, 2.485754141e-02f, 2.491119139e-02f, 2.496479083e-02f,
2.501833964e-02f, 2.507183773e-02f, 2.512528501e-02f, 2.517868141e-02f, 2.523202683e-02f, 2.528532120e-02f, 2.533856443e-02f, 2.539175643e-02f, 2.544489712e-02f, 2.549798642e-02f,
2.555102424e-02f, 2.560401050e-02f, 2.565694511e-02f, 2.570982799e-02f, 2.576265906e-02f, 2.581543824e-02f, 2.586816543e-02f, 2.592084056e-02f, 2.597346354e-02f, 2.602603429e-02f,
2.607855273e-02f, 2.613101877e-02f, 2.618343233e-02f, 2.623579334e-02f, 2.628810169e-02f, 2.634035732e-02f, 2.639256014e-02f, 2.644471007e-02f, 2.649680703e-02f, 2.654885093e-02f,
2.660084169e-02f, 2.665277923e-02f, 2.670466347e-02f, 2.675649432e-02f, 2.680827171e-02f, 2.685999555e-02f, 2.691166577e-02f, 2.696328227e-02f, 2.701484498e-02f, 2.706635383e-02f,
2.711780871e-02f, 2.716920957e-02f, 2.722055631e-02f, 2.727184885e-02f, 2.732308712e-02f, 2.737427103e-02f, 2.742540050e-02f, 2.747647546e-02f, 2.752749582e-02f, 2.757846150e-02f,
2.762937243e-02f, 2.768022851e-02f, 2.773102968e-02f, 2.778177585e-02f, 2.783246695e-02f, 2.788310289e-02f, 2.793368360e-02f, 2.798420899e-02f, 2.803467898e-02f, 2.808509351e-02f,
2.813545248e-02f, 2.818575582e-02f, 2.823600346e-02f, 2.828619530e-02f, 2.833633128e-02f, 2.838641132e-02f, 2.843643533e-02f, 2.848640324e-02f, 2.853631497e-02f, 2.858617045e-02f,
2.863596959e-02f, 2.868571231e-02f, 2.873539855e-02f, 2.878502822e-02f, 2.883460124e-02f, 2.888411754e-02f, 2.893357704e-02f, 2.898297966e-02f, 2.903232533e-02f, 2.908161397e-02f,
2.913084550e-02f, 2.918001985e-02f, 2.922913693e-02f, 2.927819668e-02f, 2.932719902e-02f, 2.937614386e-02f, 2.942503114e-02f, 2.947386078e-02f, 2.952263269e-02f, 2.957134682e-02f,
2.962000307e-02f, 2.966860138e-02f, 2.971714167e-02f, 2.976562386e-02f, 2.981404788e-02f, 2.986241366e-02f, 2.991072111e-02f, 2.995897017e-02f, 3.000716076e-02f, 3.005529280e-02f,
3.010336621e-02f, 3.015138094e-02f, 3.019933689e-02f, 3.024723401e-02f, 3.029507220e-02f, 3.034285140e-02f, 3.039057154e-02f, 3.043823253e-02f, 3.048583432e-02f, 3.053337681e-02f,
3.058085995e-02f, 3.062828365e-02f, 3.067564784e-02f, 3.072295246e-02f, 3.077019742e-02f, 3.081738266e-02f, 3.086450809e-02f, 3.091157366e-02f, 3.095857928e-02f, 3.100552488e-02f,
3.105241040e-02f, 3.109923575e-02f, 3.114600087e-02f, 3.119270568e-02f, 3.123935012e-02f, 3.128593411e-02f, 3.133245757e-02f, 3.137892045e-02f, 3.142532266e-02f, 3.147166413e-02f,
3.151794480e-02f, 3.156416459e-02f, 3.161032343e-02f, 3.165642126e-02f, 3.170245799e-02f, 3.174843356e-02f, 3.179434790e-02f, 3.184020093e-02f, 3.188599260e-02f, 3.193172282e-02f,
3.197739153e-02f, 3.202299866e-02f, 3.206854413e-02f, 3.211402789e-02f, 3.215944985e-02f, 3.220480995e-02f, 3.225010812e-02f, 3.229534429e-02f, 3.234051839e-02f, 3.238563035e-02f,
3.243068010e-02f, 3.247566758e-02f, 3.252059271e-02f, 3.256545543e-02f, 3.261025567e-02f, 3.265499336e-02f, 3.269966843e-02f, 3.274428082e-02f, 3.278883044e-02f, 3.283331725e-02f,
3.287774117e-02f, 3.292210213e-02f, 3.296640006e-02f, 3.301063490e-02f, 3.305480658e-02f, 3.309891504e-02f, 3.314296019e-02f, 3.318694199e-02f, 3.323086036e-02f, 3.327471524e-02f,
3.331850655e-02f, 3.336223424e-02f, 3.340589823e-02f, 3.344949846e-02f, 3.349303486e-02f, 3.353650737e-02f, 3.357991593e-02f, 3.362326046e-02f, 3.366654089e-02f, 3.370975718e-02f,
3.375290924e-02f, 3.379599701e-02f, 3.383902044e-02f, 3.388197945e-02f, 3.392487397e-02f, 3.396770395e-02f, 3.401046932e-02f, 3.405317002e-02f, 3.409580597e-02f, 3.413837712e-02f,
3.418088340e-02f, 3.422332475e-02f, 3.426570110e-02f, 3.430801239e-02f, 3.435025856e-02f, 3.439243954e-02f, 3.443455527e-02f, 3.447660568e-02f, 3.451859071e-02f, 3.456051031e-02f,
3.460236440e-02f, 3.464415292e-02f, 3.468587581e-02f, 3.472753301e-02f, 3.476912446e-02f, 3.481065009e-02f, 3.485210983e-02f, 3.489350364e-02f, 3.493483144e-02f, 3.497609318e-02f,
3.501728878e-02f, 3.505841820e-02f, 3.509948137e-02f, 3.514047823e-02f, 3.518140871e-02f, 3.522227275e-02f, 3.526307030e-02f, 3.530380130e-02f, 3.534446567e-02f, 3.538506337e-02f,
3.542559433e-02f, 3.546605848e-02f, 3.550645578e-02f, 3.554678616e-02f, 3.558704956e-02f, 3.562724592e-02f, 3.566737517e-02f, 3.570743727e-02f, 3.574743215e-02f, 3.578735975e-02f,
3.582722001e-02f, 3.586701287e-02f, 3.590673828e-02f, 3.594639617e-02f, 3.598598648e-02f, 3.602550916e-02f, 3.606496415e-02f, 3.610435140e-02f, 3.614367083e-02f, 3.618292239e-02f,
3.622210603e-02f, 3.626122169e-02f, 3.630026930e-02f, 3.633924882e-02f, 3.637816018e-02f, 3.641700332e-02f, 3.645577820e-02f, 3.649448474e-02f, 3.653312291e-02f, 3.657169262e-02f,
3.661019384e-02f, 3.664862650e-02f, 3.668699055e-02f, 3.672528593e-02f, 3.676351258e-02f, 3.680167046e-02f, 3.683975949e-02f, 3.687777963e-02f, 3.691573082e-02f, 3.695361300e-02f,
3.699142612e-02f, 3.702917013e-02f, 3.706684496e-02f, 3.710445056e-02f, 3.714198688e-02f, 3.717945387e-02f, 3.721685146e-02f, 3.725417960e-02f, 3.729143825e-02f, 3.732862733e-02f,
3.736574681e-02f, 3.740279662e-02f, 3.743977671e-02f, 3.747668702e-02f, 3.751352751e-02f, 3.755029812e-02f, 3.758699880e-02f, 3.762362948e-02f, 3.766019013e-02f, 3.769668068e-02f,
3.773310109e-02f, 3.776945129e-02f, 3.780573124e-02f, 3.784194088e-02f, 3.787808017e-02f, 3.791414904e-02f, 3.795014745e-02f, 3.798607535e-02f, 3.802193268e-02f, 3.805771939e-02f,
3.809343542e-02f, 3.812908073e-02f, 3.816465527e-02f, 3.820015898e-02f, 3.823559182e-02f, 3.827095373e-02f, 3.830624465e-02f, 3.834146455e-02f, 3.837661336e-02f, 3.841169104e-02f,
3.844669754e-02f, 3.848163281e-02f, 3.851649679e-02f, 3.855128944e-02f, 3.858601071e-02f, 3.862066054e-02f, 3.865523889e-02f, 3.868974570e-02f, 3.872418094e-02f, 3.875854454e-02f,
3.879283646e-02f, 3.882705665e-02f, 3.886120506e-02f, 3.889528165e-02f, 3.892928636e-02f, 3.896321914e-02f, 3.899707995e-02f, 3.903086873e-02f, 3.906458545e-02f, 3.909823005e-02f,
3.913180248e-02f, 3.916530269e-02f, 3.919873065e-02f, 3.923208629e-02f, 3.926536958e-02f, 3.929858047e-02f, 3.933171890e-02f, 3.936478484e-02f, 3.939777823e-02f, 3.943069902e-02f,
3.946354718e-02f, 3.949632266e-02f, 3.952902540e-02f, 3.956165536e-02f, 3.959421250e-02f, 3.962669677e-02f, 3.965910813e-02f, 3.969144652e-02f, 3.972371190e-02f, 3.975590424e-02f,
3.978802347e-02f, 3.982006956e-02f, 3.985204247e-02f, 3.988394214e-02f, 3.991576853e-02f, 3.994752160e-02f, 3.997920130e-02f, 4.001080759e-02f, 4.004234042e-02f, 4.007379976e-02f,
4.010518555e-02f, 4.013649775e-02f, 4.016773632e-02f, 4.019890121e-02f, 4.022999238e-02f, 4.026100980e-02f, 4.029195340e-02f, 4.032282316e-02f, 4.035361903e-02f, 4.038434096e-02f,
4.041498892e-02f, 4.044556285e-02f, 4.047606272e-02f, 4.050648849e-02f, 4.053684011e-02f, 4.056711755e-02f, 4.059732075e-02f, 4.062744968e-02f, 4.065750429e-02f, 4.068748455e-02f,
4.071739042e-02f, 4.074722184e-02f, 4.077697879e-02f, 4.080666121e-02f, 4.083626908e-02f, 4.086580234e-02f, 4.089526096e-02f, 4.092464489e-02f, 4.095395411e-02f, 4.098318856e-02f,
4.101234820e-02f, 4.104143301e-02f, 4.107044293e-02f, 4.109937792e-02f, 4.112823796e-02f, 4.115702299e-02f, 4.118573298e-02f, 4.121436790e-02f, 4.124292769e-02f, 4.127141232e-02f,
4.129982176e-02f, 4.132815597e-02f, 4.135641490e-02f, 4.138459851e-02f, 4.141270678e-02f, 4.144073966e-02f, 4.146869711e-02f, 4.149657910e-02f, 4.152438559e-02f, 4.155211654e-02f,
4.157977191e-02f, 4.160735167e-02f, 4.163485578e-02f, 4.166228420e-02f, 4.168963690e-02f, 4.171691383e-02f, 4.174411497e-02f, 4.177124027e-02f, 4.179828971e-02f, 4.182526323e-02f,
4.185216082e-02f, 4.187898242e-02f, 4.190572801e-02f, 4.193239755e-02f, 4.195899101e-02f, 4.198550834e-02f, 4.201194952e-02f, 4.203831451e-02f, 4.206460327e-02f, 4.209081577e-02f,
4.211695198e-02f, 4.214301185e-02f, 4.216899536e-02f, 4.219490247e-02f, 4.222073315e-02f, 4.224648736e-02f, 4.227216508e-02f, 4.229776625e-02f, 4.232329086e-02f, 4.234873887e-02f,
4.237411024e-02f, 4.239940495e-02f, 4.242462295e-02f, 4.244976422e-02f, 4.247482872e-02f, 4.249981643e-02f, 4.252472730e-02f, 4.254956131e-02f, 4.257431842e-02f, 4.259899860e-02f,
4.262360182e-02f, 4.264812805e-02f, 4.267257726e-02f, 4.269694941e-02f, 4.272124447e-02f, 4.274546242e-02f, 4.276960321e-02f, 4.279366683e-02f, 4.281765323e-02f, 4.284156239e-02f,
4.286539428e-02f, 4.288914887e-02f, 4.291282612e-02f, 4.293642601e-02f, 4.295994850e-02f, 4.298339357e-02f, 4.300676119e-02f, 4.303005132e-02f, 4.305326395e-02f, 4.307639903e-02f,
4.309945653e-02f, 4.312243644e-02f, 4.314533872e-02f, 4.316816334e-02f, 4.319091028e-02f, 4.321357950e-02f, 4.323617097e-02f, 4.325868468e-02f, 4.328112058e-02f, 4.330347865e-02f,
4.332575887e-02f, 4.334796121e-02f, 4.337008563e-02f, 4.339213212e-02f, 4.341410064e-02f, 4.343599116e-02f, 4.345780367e-02f, 4.347953813e-02f, 4.350119451e-02f, 4.352277279e-02f,
4.354427295e-02f, 4.356569495e-02f, 4.358703878e-02f, 4.360830439e-02f, 4.362949178e-02f, 4.365060091e-02f, 4.367163175e-02f, 4.369258429e-02f, 4.371345849e-02f, 4.373425433e-02f,
4.375497179e-02f, 4.377561083e-02f, 4.379617145e-02f, 4.381665360e-02f, 4.383705727e-02f, 4.385738244e-02f, 4.387762907e-02f, 4.389779714e-02f, 4.391788663e-02f, 4.393789752e-02f,
4.395782978e-02f, 4.397768339e-02f, 4.399745832e-02f, 4.401715456e-02f, 4.403677207e-02f, 4.405631084e-02f, 4.407577084e-02f, 4.409515204e-02f, 4.411445444e-02f, 4.413367800e-02f,
4.415282270e-02f, 4.417188852e-02f, 4.419087544e-02f, 4.420978344e-02f, 4.422861248e-02f, 4.424736257e-02f, 4.426603366e-02f, 4.428462574e-02f, 4.430313878e-02f, 4.432157278e-02f,
4.433992770e-02f, 4.435820353e-02f, 4.437640023e-02f, 4.439451781e-02f, 4.441255622e-02f, 4.443051546e-02f, 4.444839551e-02f, 4.446619633e-02f, 4.448391792e-02f, 4.450156025e-02f,
4.451912330e-02f, 4.453660706e-02f, 4.455401150e-02f, 4.457133661e-02f, 4.458858237e-02f, 4.460574875e-02f, 4.462283574e-02f, 4.463984332e-02f, 4.465677148e-02f, 4.467362018e-02f,
4.469038942e-02f, 4.470707918e-02f, 4.472368944e-02f, 4.474022018e-02f, 4.475667138e-02f, 4.477304303e-02f, 4.478933510e-02f, 4.480554759e-02f, 4.482168047e-02f, 4.483773373e-02f,
4.485370735e-02f, 4.486960131e-02f, 4.488541560e-02f, 4.490115021e-02f, 4.491680510e-02f, 4.493238027e-02f, 4.494787571e-02f, 4.496329139e-02f, 4.497862731e-02f, 4.499388344e-02f,
4.500905976e-02f, 4.502415628e-02f, 4.503917296e-02f, 4.505410979e-02f, 4.506896677e-02f, 4.508374387e-02f, 4.509844108e-02f, 4.511305838e-02f, 4.512759577e-02f, 4.514205322e-02f,
4.515643073e-02f, 4.517072827e-02f, 4.518494584e-02f, 4.519908342e-02f, 4.521314100e-02f, 4.522711856e-02f, 4.524101610e-02f, 4.525483359e-02f, 4.526857103e-02f, 4.528222840e-02f,
4.529580569e-02f, 4.530930289e-02f, 4.532271998e-02f, 4.533605695e-02f, 4.534931380e-02f, 4.536249050e-02f, 4.537558705e-02f, 4.538860344e-02f, 4.540153964e-02f, 4.541439566e-02f,
4.542717148e-02f, 4.543986709e-02f, 4.545248248e-02f, 4.546501764e-02f, 4.547747255e-02f, 4.548984721e-02f, 4.550214161e-02f, 4.551435573e-02f, 4.552648956e-02f, 4.553854310e-02f,
4.555051634e-02f, 4.556240926e-02f, 4.557422186e-02f, 4.558595412e-02f, 4.559760604e-02f, 4.560917761e-02f, 4.562066882e-02f, 4.563207966e-02f, 4.564341012e-02f, 4.565466019e-02f,
4.566582986e-02f, 4.567691914e-02f, 4.568792799e-02f, 4.569885643e-02f, 4.570970444e-02f, 4.572047201e-02f, 4.573115914e-02f, 4.574176581e-02f, 4.575229203e-02f, 4.576273778e-02f,
4.577310306e-02f, 4.578338785e-02f, 4.579359216e-02f, 4.580371598e-02f, 4.581375929e-02f, 4.582372210e-02f, 4.583360439e-02f, 4.584340616e-02f, 4.585312741e-02f, 4.586276813e-02f,
4.587232831e-02f, 4.588180794e-02f, 4.589120703e-02f, 4.590052556e-02f, 4.590976354e-02f, 4.591892095e-02f, 4.592799779e-02f, 4.593699406e-02f, 4.594590975e-02f, 4.595474486e-02f,
4.596349938e-02f, 4.597217331e-02f, 4.598076664e-02f, 4.598927938e-02f, 4.599771151e-02f, 4.600606304e-02f, 4.601433395e-02f, 4.602252425e-02f, 4.603063394e-02f, 4.603866300e-02f,
4.604661144e-02f, 4.605447926e-02f, 4.606226644e-02f, 4.606997300e-02f, 4.607759892e-02f, 4.608514421e-02f, 4.609260885e-02f, 4.609999286e-02f, 4.610729623e-02f, 4.611451895e-02f,
4.612166103e-02f, 4.612872246e-02f, 4.613570324e-02f, 4.614260338e-02f, 4.614942286e-02f, 4.615616170e-02f, 4.616281988e-02f, 4.616939741e-02f, 4.617589428e-02f, 4.618231050e-02f,
4.618864607e-02f, 4.619490099e-02f, 4.620107525e-02f, 4.620716886e-02f, 4.621318182e-02f, 4.621911412e-02f, 4.622496577e-02f, 4.623073678e-02f, 4.623642713e-02f, 4.624203683e-02f,
4.624756588e-02f, 4.625301429e-02f, 4.625838205e-02f, 4.626366917e-02f, 4.626887565e-02f, 4.627400149e-02f, 4.627904668e-02f, 4.628401125e-02f, 4.628889518e-02f, 4.629369848e-02f,
4.629842115e-02f, 4.630306319e-02f, 4.630762461e-02f, 4.631210541e-02f, 4.631650559e-02f, 4.632082516e-02f, 4.632506412e-02f, 4.632922248e-02f, 4.633330023e-02f, 4.633729738e-02f,
4.634121393e-02f, 4.634504989e-02f, 4.634880527e-02f, 4.635248006e-02f, 4.635607427e-02f, 4.635958791e-02f, 4.636302099e-02f, 4.636637349e-02f, 4.636964544e-02f, 4.637283683e-02f,
4.637594768e-02f, 4.637897798e-02f, 4.638192774e-02f, 4.638479698e-02f, 4.638758568e-02f, 4.639029387e-02f, 4.639292154e-02f, 4.639546870e-02f, 4.639793536e-02f, 4.640032153e-02f,
4.640262721e-02f, 4.640485241e-02f, 4.640699713e-02f, 4.640906139e-02f, 4.641104518e-02f, 4.641294853e-02f, 4.641477142e-02f, 4.641651388e-02f, 4.641817591e-02f, 4.641975752e-02f,
4.642125872e-02f, 4.642267950e-02f, 4.642401990e-02f, 4.642527990e-02f, 4.642645952e-02f, 4.642755877e-02f, 4.642857765e-02f, 4.642951619e-02f, 4.643037437e-02f, 4.643115223e-02f,
4.643184975e-02f, 4.643246696e-02f, 4.643300386e-02f, 4.643346047e-02f, 4.643383679e-02f, 4.643413283e-02f, 4.643434860e-02f, 4.643448412e-02f, 4.643453939e-02f, 4.643451443e-02f,
4.643440924e-02f, 4.643422384e-02f, 4.643395823e-02f, 4.643361244e-02f, 4.643318646e-02f, 4.643268032e-02f, 4.643209401e-02f, 4.643142756e-02f, 4.643068098e-02f, 4.642985428e-02f,
4.642894747e-02f, 4.642796056e-02f, 4.642689356e-02f, 4.642574649e-02f, 4.642451937e-02f, 4.642321219e-02f, 4.642182498e-02f, 4.642035775e-02f, 4.641881052e-02f, 4.641718329e-02f,
4.641547607e-02f, 4.641368889e-02f, 4.641182176e-02f, 4.640987469e-02f, 4.640784769e-02f, 4.640574078e-02f, 4.640355397e-02f, 4.640128728e-02f, 4.639894072e-02f, 4.639651431e-02f,
4.639400806e-02f, 4.639142198e-02f, 4.638875610e-02f, 4.638601042e-02f, 4.638318497e-02f, 4.638027975e-02f, 4.637729479e-02f, 4.637423009e-02f, 4.637108568e-02f, 4.636786157e-02f,
4.636455777e-02f, 4.636117431e-02f, 4.635771120e-02f, 4.635416846e-02f, 4.635054609e-02f, 4.634684413e-02f, 4.634306258e-02f, 4.633920147e-02f, 4.633526081e-02f, 4.633124062e-02f,
4.632714091e-02f, 4.632296171e-02f, 4.631870302e-02f, 4.631436488e-02f, 4.630994729e-02f, 4.630545028e-02f, 4.630087387e-02f, 4.629621806e-02f, 4.629148289e-02f, 4.628666836e-02f,
4.628177450e-02f, 4.627680134e-02f, 4.627174887e-02f, 4.626661714e-02f, 4.626140614e-02f, 4.625611591e-02f, 4.625074647e-02f, 4.624529783e-02f, 4.623977002e-02f, 4.623416304e-02f,
4.622847693e-02f, 4.622271171e-02f, 4.621686739e-02f, 4.621094400e-02f, 4.620494155e-02f, 4.619886007e-02f, 4.619269958e-02f, 4.618646009e-02f, 4.618014164e-02f, 4.617374423e-02f,
4.616726790e-02f, 4.616071267e-02f, 4.615407855e-02f, 4.614736557e-02f, 4.614057375e-02f, 4.613370311e-02f, 4.612675368e-02f, 4.611972548e-02f, 4.611261852e-02f, 4.610543284e-02f,
4.609816845e-02f, 4.609082538e-02f, 4.608340365e-02f, 4.607590329e-02f, 4.606832431e-02f, 4.606066675e-02f, 4.605293062e-02f, 4.604511595e-02f, 4.603722276e-02f, 4.602925108e-02f,
4.602120093e-02f, 4.601307233e-02f, 4.600486531e-02f, 4.599657990e-02f, 4.598821612e-02f, 4.597977399e-02f, 4.597125353e-02f, 4.596265478e-02f, 4.595397776e-02f, 4.594522250e-02f,
4.593638901e-02f, 4.592747732e-02f, 4.591848747e-02f, 4.590941948e-02f, 4.590027336e-02f, 4.589104916e-02f, 4.588174689e-02f, 4.587236658e-02f, 4.586290825e-02f, 4.585337194e-02f,
4.584375768e-02f, 4.583406548e-02f, 4.582429537e-02f, 4.581444739e-02f, 4.580452155e-02f, 4.579451790e-02f, 4.578443644e-02f, 4.577427722e-02f, 4.576404026e-02f, 4.575372558e-02f,
4.574333322e-02f, 4.573286320e-02f, 4.572231556e-02f, 4.571169032e-02f, 4.570098750e-02f, 4.569020714e-02f, 4.567934927e-02f, 4.566841391e-02f, 4.565740110e-02f, 4.564631086e-02f,
4.563514323e-02f, 4.562389822e-02f, 4.561257588e-02f, 4.560117623e-02f, 4.558969931e-02f, 4.557814513e-02f, 4.556651373e-02f, 4.555480515e-02f, 4.554301941e-02f, 4.553115654e-02f,
4.551921658e-02f, 4.550719955e-02f, 4.549510548e-02f, 4.548293441e-02f, 4.547068637e-02f, 4.545836138e-02f, 4.544595949e-02f, 4.543348071e-02f, 4.542092509e-02f, 4.540829265e-02f,
4.539558343e-02f, 4.538279746e-02f, 4.536993477e-02f, 4.535699539e-02f, 4.534397936e-02f, 4.533088670e-02f, 4.531771746e-02f, 4.530447165e-02f, 4.529114933e-02f, 4.527775051e-02f,
4.526427524e-02f, 4.525072354e-02f, 4.523709545e-02f, 4.522339100e-02f, 4.520961023e-02f, 4.519575317e-02f, 4.518181985e-02f, 4.516781031e-02f, 4.515372459e-02f, 4.513956271e-02f,
4.512532471e-02f, 4.511101062e-02f, 4.509662049e-02f, 4.508215434e-02f, 4.506761221e-02f, 4.505299414e-02f, 4.503830015e-02f, 4.502353029e-02f, 4.500868460e-02f, 4.499376309e-02f,
4.497876582e-02f, 4.496369282e-02f, 4.494854412e-02f, 4.493331976e-02f, 4.491801978e-02f, 4.490264421e-02f, 4.488719309e-02f, 4.487166645e-02f, 4.485606434e-02f, 4.484038678e-02f,
4.482463382e-02f, 4.480880549e-02f, 4.479290184e-02f, 4.477692289e-02f, 4.476086868e-02f, 4.474473925e-02f, 4.472853465e-02f, 4.471225490e-02f, 4.469590005e-02f, 4.467947013e-02f,
4.466296519e-02f, 4.464638525e-02f, 4.462973036e-02f, 4.461300056e-02f, 4.459619589e-02f, 4.457931638e-02f, 4.456236207e-02f, 4.454533300e-02f, 4.452822922e-02f, 4.451105075e-02f,
4.449379765e-02f, 4.447646995e-02f, 4.445906768e-02f, 4.444159089e-02f, 4.442403963e-02f, 4.440641392e-02f, 4.438871381e-02f, 4.437093934e-02f, 4.435309055e-02f, 4.433516748e-02f,
4.431717017e-02f, 4.429909866e-02f, 4.428095299e-02f, 4.426273321e-02f, 4.424443935e-02f, 4.422607146e-02f, 4.420762958e-02f, 4.418911374e-02f, 4.417052399e-02f, 4.415186038e-02f,
4.413312293e-02f, 4.411431171e-02f, 4.409542674e-02f, 4.407646807e-02f, 4.405743574e-02f, 4.403832980e-02f, 4.401915028e-02f, 4.399989724e-02f, 4.398057070e-02f, 4.396117073e-02f,
4.394169735e-02f, 4.392215061e-02f, 4.390253055e-02f, 4.388283723e-02f, 4.386307068e-02f, 4.384323094e-02f, 4.382331806e-02f, 4.380333209e-02f, 4.378327306e-02f, 4.376314102e-02f,
4.374293602e-02f, 4.372265810e-02f, 4.370230730e-02f, 4.368188367e-02f, 4.366138725e-02f, 4.364081810e-02f, 4.362017624e-02f, 4.359946174e-02f, 4.357867463e-02f, 4.355781495e-02f,
4.353688276e-02f, 4.351587810e-02f, 4.349480102e-02f, 4.347365156e-02f, 4.345242976e-02f, 4.343113568e-02f, 4.340976936e-02f, 4.338833084e-02f, 4.336682017e-02f, 4.334523740e-02f,
4.332358258e-02f, 4.330185575e-02f, 4.328005696e-02f, 4.325818625e-02f, 4.323624368e-02f, 4.321422928e-02f, 4.319214311e-02f, 4.316998522e-02f, 4.314775565e-02f, 4.312545444e-02f,
4.310308166e-02f, 4.308063734e-02f, 4.305812153e-02f, 4.303553428e-02f, 4.301287565e-02f, 4.299014567e-02f, 4.296734440e-02f, 4.294447188e-02f, 4.292152817e-02f, 4.289851330e-02f,
4.287542734e-02f, 4.285227033e-02f, 4.282904232e-02f, 4.280574336e-02f, 4.278237350e-02f, 4.275893278e-02f, 4.273542127e-02f, 4.271183899e-02f, 4.268818602e-02f, 4.266446239e-02f,
4.264066816e-02f, 4.261680338e-02f, 4.259286809e-02f, 4.256886235e-02f, 4.254478621e-02f, 4.252063972e-02f, 4.249642293e-02f, 4.247213589e-02f, 4.244777865e-02f, 4.242335126e-02f,
4.239885377e-02f, 4.237428625e-02f, 4.234964872e-02f, 4.232494126e-02f, 4.230016391e-02f, 4.227531672e-02f, 4.225039974e-02f, 4.222541302e-02f, 4.220035663e-02f, 4.217523060e-02f,
4.215003500e-02f, 4.212476987e-02f, 4.209943527e-02f, 4.207403125e-02f, 4.204855786e-02f, 4.202301516e-02f, 4.199740319e-02f, 4.197172202e-02f, 4.194597169e-02f, 4.192015226e-02f,
4.189426378e-02f, 4.186830631e-02f, 4.184227989e-02f, 4.181618459e-02f, 4.179002046e-02f, 4.176378754e-02f, 4.173748591e-02f, 4.171111560e-02f, 4.168467667e-02f, 4.165816918e-02f,
4.163159318e-02f, 4.160494873e-02f, 4.157823589e-02f, 4.155145470e-02f, 4.152460522e-02f, 4.149768751e-02f, 4.147070162e-02f, 4.144364760e-02f, 4.141652552e-02f, 4.138933543e-02f,
4.136207739e-02f, 4.133475144e-02f, 4.130735765e-02f, 4.127989607e-02f, 4.125236676e-02f, 4.122476977e-02f, 4.119710516e-02f, 4.116937299e-02f, 4.114157332e-02f, 4.111370619e-02f,
4.108577167e-02f, 4.105776981e-02f, 4.102970068e-02f, 4.100156432e-02f, 4.097336079e-02f, 4.094509016e-02f, 4.091675248e-02f, 4.088834781e-02f, 4.085987619e-02f, 4.083133771e-02f,
4.080273240e-02f, 4.077406033e-02f, 4.074532156e-02f, 4.071651614e-02f, 4.068764413e-02f, 4.065870559e-02f, 4.062970059e-02f, 4.060062917e-02f, 4.057149140e-02f, 4.054228733e-02f,
4.051301703e-02f, 4.048368055e-02f, 4.045427795e-02f, 4.042480929e-02f, 4.039527464e-02f, 4.036567405e-02f, 4.033600757e-02f, 4.030627528e-02f, 4.027647722e-02f, 4.024661346e-02f,
4.021668407e-02f, 4.018668909e-02f, 4.015662859e-02f, 4.012650263e-02f, 4.009631127e-02f, 4.006605457e-02f, 4.003573259e-02f, 4.000534539e-02f, 3.997489303e-02f, 3.994437558e-02f,
3.991379309e-02f, 3.988314563e-02f, 3.985243325e-02f, 3.982165602e-02f, 3.979081400e-02f, 3.975990725e-02f, 3.972893584e-02f, 3.969789981e-02f, 3.966679924e-02f, 3.963563419e-02f,
3.960440472e-02f, 3.957311089e-02f, 3.954175277e-02f, 3.951033041e-02f, 3.947884388e-02f, 3.944729324e-02f, 3.941567855e-02f, 3.938399988e-02f, 3.935225730e-02f, 3.932045085e-02f,
3.928858061e-02f, 3.925664663e-02f, 3.922464899e-02f, 3.919258774e-02f, 3.916046296e-02f, 3.912827469e-02f, 3.909602301e-02f, 3.906370798e-02f, 3.903132966e-02f, 3.899888812e-02f,
3.896638342e-02f, 3.893381562e-02f, 3.890118480e-02f, 3.886849101e-02f, 3.883573431e-02f, 3.880291478e-02f, 3.877003248e-02f, 3.873708747e-02f, 3.870407982e-02f, 3.867100958e-02f,
3.863787684e-02f, 3.860468165e-02f, 3.857142407e-02f, 3.853810418e-02f, 3.850472203e-02f, 3.847127770e-02f, 3.843777125e-02f, 3.840420274e-02f, 3.837057225e-02f, 3.833687983e-02f,
3.830312555e-02f, 3.826930948e-02f, 3.823543169e-02f, 3.820149223e-02f, 3.816749119e-02f, 3.813342862e-02f, 3.809930459e-02f, 3.806511917e-02f, 3.803087242e-02f, 3.799656441e-02f,
3.796219521e-02f, 3.792776489e-02f, 3.789327351e-02f, 3.785872114e-02f, 3.782410784e-02f, 3.778943369e-02f, 3.775469875e-02f, 3.771990309e-02f, 3.768504678e-02f, 3.765012988e-02f,
3.761515247e-02f, 3.758011461e-02f, 3.754501636e-02f, 3.750985781e-02f, 3.747463901e-02f, 3.743936003e-02f, 3.740402095e-02f, 3.736862182e-02f, 3.733316273e-02f, 3.729764374e-02f,
3.726206491e-02f, 3.722642632e-02f, 3.719072804e-02f, 3.715497013e-02f, 3.711915267e-02f, 3.708327571e-02f, 3.704733935e-02f, 3.701134363e-02f, 3.697528864e-02f, 3.693917443e-02f,
3.690300109e-02f, 3.686676868e-02f, 3.683047727e-02f, 3.679412694e-02f, 3.675771774e-02f, 3.672124976e-02f, 3.668472305e-02f, 3.664813771e-02f, 3.661149378e-02f, 3.657479135e-02f,
3.653803048e-02f, 3.650121125e-02f, 3.646433372e-02f, 3.642739798e-02f, 3.639040408e-02f, 3.635335210e-02f, 3.631624211e-02f, 3.627907418e-02f, 3.624184839e-02f, 3.620456480e-02f,
3.616722349e-02f, 3.612982452e-02f, 3.609236798e-02f, 3.605485393e-02f, 3.601728244e-02f, 3.597965359e-02f, 3.594196745e-02f, 3.590422409e-02f, 3.586642358e-02f, 3.582856600e-02f,
3.579065141e-02f, 3.575267990e-02f, 3.571465152e-02f, 3.567656637e-02f, 3.563842450e-02f, 3.560022600e-02f, 3.556197093e-02f, 3.552365937e-02f, 3.548529139e-02f, 3.544686706e-02f,
3.540838646e-02f, 3.536984966e-02f, 3.533125674e-02f, 3.529260777e-02f, 3.525390282e-02f, 3.521514196e-02f, 3.517632528e-02f, 3.513745284e-02f, 3.509852472e-02f, 3.505954099e-02f,
3.502050172e-02f, 3.498140700e-02f, 3.494225689e-02f, 3.490305148e-02f, 3.486379082e-02f, 3.482447501e-02f, 3.478510411e-02f, 3.474567820e-02f, 3.470619735e-02f, 3.466666164e-02f,
3.462707115e-02f, 3.458742594e-02f, 3.454772610e-02f, 3.450797170e-02f, 3.446816281e-02f, 3.442829952e-02f, 3.438838189e-02f, 3.434841000e-02f, 3.430838393e-02f, 3.426830375e-02f,
3.422816954e-02f, 3.418798138e-02f, 3.414773934e-02f, 3.410744350e-02f, 3.406709393e-02f, 3.402669071e-02f, 3.398623392e-02f, 3.394572363e-02f, 3.390515993e-02f, 3.386454287e-02f,
3.382387256e-02f, 3.378314905e-02f, 3.374237243e-02f, 3.370154277e-02f, 3.366066016e-02f, 3.361972466e-02f, 3.357873636e-02f, 3.353769533e-02f, 3.349660166e-02f, 3.345545541e-02f,
3.341425666e-02f, 3.337300550e-02f, 3.333170200e-02f, 3.329034624e-02f, 3.324893829e-02f, 3.320747824e-02f, 3.316596617e-02f, 3.312440214e-02f, 3.308278624e-02f, 3.304111855e-02f,
3.299939914e-02f, 3.295762810e-02f, 3.291580550e-02f, 3.287393142e-02f, 3.283200595e-02f, 3.279002915e-02f, 3.274800110e-02f, 3.270592190e-02f, 3.266379161e-02f, 3.262161031e-02f,
3.257937809e-02f, 3.253709502e-02f, 3.249476118e-02f, 3.245237665e-02f, 3.240994151e-02f, 3.236745585e-02f, 3.232491973e-02f, 3.228233325e-02f, 3.223969647e-02f, 3.219700948e-02f,
3.215427236e-02f, 3.211148519e-02f, 3.206864805e-02f, 3.202576102e-02f, 3.198282417e-02f, 3.193983760e-02f, 3.189680138e-02f, 3.185371559e-02f, 3.181058031e-02f, 3.176739562e-02f,
3.172416160e-02f, 3.168087833e-02f, 3.163754590e-02f, 3.159416439e-02f, 3.155073387e-02f, 3.150725442e-02f, 3.146372614e-02f, 3.142014909e-02f, 3.137652336e-02f, 3.133284904e-02f,
3.128912620e-02f, 3.124535492e-02f, 3.120153528e-02f, 3.115766738e-02f, 3.111375128e-02f, 3.106978708e-02f, 3.102577485e-02f, 3.098171467e-02f, 3.093760663e-02f, 3.089345080e-02f,
3.084924728e-02f, 3.080499614e-02f, 3.076069747e-02f, 3.071635134e-02f, 3.067195785e-02f, 3.062751706e-02f, 3.058302907e-02f, 3.053849396e-02f, 3.049391181e-02f, 3.044928270e-02f,
3.040460672e-02f, 3.035988394e-02f, 3.031511446e-02f, 3.027029835e-02f, 3.022543570e-02f, 3.018052659e-02f, 3.013557110e-02f, 3.009056932e-02f, 3.004552133e-02f, 3.000042722e-02f,
2.995528706e-02f, 2.991010095e-02f, 2.986486896e-02f, 2.981959118e-02f, 2.977426769e-02f, 2.972889857e-02f, 2.968348392e-02f, 2.963802381e-02f, 2.959251833e-02f, 2.954696756e-02f,
2.950137159e-02f, 2.945573050e-02f, 2.941004437e-02f, 2.936431329e-02f, 2.931853735e-02f, 2.927271662e-02f, 2.922685120e-02f, 2.918094117e-02f, 2.913498660e-02f, 2.908898760e-02f,
2.904294424e-02f, 2.899685660e-02f, 2.895072477e-02f, 2.890454884e-02f, 2.885832890e-02f, 2.881206502e-02f, 2.876575729e-02f, 2.871940580e-02f, 2.867301063e-02f, 2.862657188e-02f,
2.858008961e-02f, 2.853356393e-02f, 2.848699491e-02f, 2.844038264e-02f, 2.839372720e-02f, 2.834702869e-02f, 2.830028719e-02f, 2.825350278e-02f, 2.820667555e-02f, 2.815980559e-02f,
2.811289298e-02f, 2.806593780e-02f, 2.801894015e-02f, 2.797190012e-02f, 2.792481778e-02f, 2.787769322e-02f, 2.783052653e-02f, 2.778331780e-02f, 2.773606712e-02f, 2.768877456e-02f,
2.764144022e-02f, 2.759406418e-02f, 2.754664654e-02f, 2.749918737e-02f, 2.745168676e-02f, 2.740414481e-02f, 2.735656159e-02f, 2.730893720e-02f, 2.726127173e-02f, 2.721356525e-02f,
2.716581786e-02f, 2.711802964e-02f, 2.707020069e-02f, 2.702233109e-02f, 2.697442092e-02f, 2.692647028e-02f, 2.687847925e-02f, 2.683044792e-02f, 2.678237638e-02f, 2.673426471e-02f,
2.668611301e-02f, 2.663792136e-02f, 2.658968985e-02f, 2.654141856e-02f, 2.649310760e-02f, 2.644475703e-02f, 2.639636696e-02f, 2.634793747e-02f, 2.629946865e-02f, 2.625096059e-02f,
2.620241337e-02f, 2.615382709e-02f, 2.610520183e-02f, 2.605653768e-02f, 2.600783473e-02f, 2.595909307e-02f, 2.591031279e-02f, 2.586149398e-02f, 2.581263672e-02f, 2.576374110e-02f,
2.571480722e-02f, 2.566583517e-02f, 2.561682502e-02f, 2.556777688e-02f, 2.551869082e-02f, 2.546956695e-02f, 2.542040534e-02f, 2.537120609e-02f, 2.532196929e-02f, 2.527269503e-02f,
2.522338340e-02f, 2.517403448e-02f, 2.512464837e-02f, 2.507522515e-02f, 2.502576492e-02f, 2.497626776e-02f, 2.492673377e-02f, 2.487716304e-02f, 2.482755565e-02f, 2.477791170e-02f,
2.472823127e-02f, 2.467851446e-02f, 2.462876135e-02f, 2.457897204e-02f, 2.452914661e-02f, 2.447928516e-02f, 2.442938778e-02f, 2.437945456e-02f, 2.432948558e-02f, 2.427948094e-02f,
2.422944073e-02f, 2.417936504e-02f, 2.412925397e-02f, 2.407910759e-02f, 2.402892600e-02f, 2.397870930e-02f, 2.392845757e-02f, 2.387817090e-02f, 2.382784939e-02f, 2.377749313e-02f,
2.372710220e-02f, 2.367667670e-02f, 2.362621673e-02f, 2.357572236e-02f, 2.352519369e-02f, 2.347463082e-02f, 2.342403384e-02f, 2.337340283e-02f, 2.332273788e-02f, 2.327203910e-02f,
2.322130657e-02f, 2.317054038e-02f, 2.311974062e-02f, 2.306890739e-02f, 2.301804078e-02f, 2.296714088e-02f, 2.291620778e-02f, 2.286524157e-02f, 2.281424234e-02f, 2.276321019e-02f,
2.271214522e-02f, 2.266104750e-02f, 2.260991713e-02f, 2.255875421e-02f, 2.250755883e-02f, 2.245633107e-02f, 2.240507104e-02f, 2.235377882e-02f, 2.230245451e-02f, 2.225109820e-02f,
2.219970998e-02f, 2.214828994e-02f, 2.209683818e-02f, 2.204535478e-02f, 2.199383985e-02f, 2.194229347e-02f, 2.189071574e-02f, 2.183910675e-02f, 2.178746659e-02f, 2.173579535e-02f,
2.168409313e-02f, 2.163236003e-02f, 2.158059612e-02f, 2.152880152e-02f, 2.147697630e-02f, 2.142512056e-02f, 2.137323441e-02f, 2.132131792e-02f, 2.126937119e-02f, 2.121739432e-02f,
2.116538739e-02f, 2.111335051e-02f, 2.106128377e-02f, 2.100918725e-02f, 2.095706105e-02f, 2.090490527e-02f, 2.085272000e-02f, 2.080050533e-02f, 2.074826136e-02f, 2.069598818e-02f,
2.064368588e-02f, 2.059135456e-02f, 2.053899431e-02f, 2.048660522e-02f, 2.043418739e-02f, 2.038174092e-02f, 2.032926589e-02f, 2.027676240e-02f, 2.022423054e-02f, 2.017167041e-02f,
2.011908211e-02f, 2.006646572e-02f, 2.001382134e-02f, 1.996114906e-02f, 1.990844899e-02f, 1.985572120e-02f, 1.980296580e-02f, 1.975018289e-02f, 1.969737255e-02f, 1.964453488e-02f,
1.959166997e-02f, 1.953877792e-02f, 1.948585883e-02f, 1.943291278e-02f, 1.937993987e-02f, 1.932694021e-02f, 1.927391387e-02f, 1.922086096e-02f, 1.916778157e-02f, 1.911467579e-02f,
1.906154372e-02f, 1.900838546e-02f, 1.895520110e-02f, 1.890199073e-02f, 1.884875446e-02f, 1.879549236e-02f, 1.874220455e-02f, 1.868889110e-02f, 1.863555213e-02f, 1.858218772e-02f,
1.852879797e-02f, 1.847538298e-02f, 1.842194283e-02f, 1.836847763e-02f, 1.831498747e-02f, 1.826147244e-02f, 1.820793264e-02f, 1.815436816e-02f, 1.810077911e-02f, 1.804716557e-02f,
1.799352765e-02f, 1.793986543e-02f, 1.788617901e-02f, 1.783246849e-02f, 1.777873396e-02f, 1.772497552e-02f, 1.767119327e-02f, 1.761738729e-02f, 1.756355769e-02f, 1.750970456e-02f,
1.745582799e-02f, 1.740192809e-02f, 1.734800494e-02f, 1.729405865e-02f, 1.724008931e-02f, 1.718609701e-02f, 1.713208185e-02f, 1.707804393e-02f, 1.702398334e-02f, 1.696990018e-02f,
1.691579455e-02f, 1.686166653e-02f, 1.680751623e-02f, 1.675334374e-02f, 1.669914916e-02f, 1.664493259e-02f, 1.659069411e-02f, 1.653643383e-02f, 1.648215184e-02f, 1.642784825e-02f,
1.637352313e-02f, 1.631917660e-02f, 1.626480874e-02f, 1.621041966e-02f, 1.615600945e-02f, 1.610157820e-02f, 1.604712602e-02f, 1.599265299e-02f, 1.593815922e-02f, 1.588364480e-02f,
1.582910983e-02f, 1.577455440e-02f, 1.571997861e-02f, 1.566538256e-02f, 1.561076635e-02f, 1.555613006e-02f, 1.550147380e-02f, 1.544679766e-02f, 1.539210175e-02f, 1.533738615e-02f,
1.528265096e-02f, 1.522789628e-02f, 1.517312221e-02f, 1.511832885e-02f, 1.506351628e-02f, 1.500868461e-02f, 1.495383393e-02f, 1.489896434e-02f, 1.484407594e-02f, 1.478916883e-02f,
1.473424309e-02f, 1.467929883e-02f, 1.462433615e-02f, 1.456935514e-02f, 1.451435589e-02f, 1.445933851e-02f, 1.440430309e-02f, 1.434924974e-02f, 1.429417853e-02f, 1.423908958e-02f,
1.418398298e-02f, 1.412885883e-02f, 1.407371723e-02f, 1.401855826e-02f, 1.396338203e-02f, 1.390818864e-02f, 1.385297818e-02f, 1.379775075e-02f, 1.374250645e-02f, 1.368724537e-02f,
1.363196761e-02f, 1.357667327e-02f, 1.352136245e-02f, 1.346603524e-02f, 1.341069174e-02f, 1.335533204e-02f, 1.329995626e-02f, 1.324456447e-02f, 1.318915679e-02f, 1.313373330e-02f,
1.307829411e-02f, 1.302283930e-02f, 1.296736899e-02f, 1.291188326e-02f, 1.285638222e-02f, 1.280086596e-02f, 1.274533458e-02f, 1.268978817e-02f, 1.263422684e-02f, 1.257865067e-02f,
1.252305978e-02f, 1.246745425e-02f, 1.241183419e-02f, 1.235619969e-02f, 1.230055085e-02f, 1.224488776e-02f, 1.218921053e-02f, 1.213351925e-02f, 1.207781401e-02f, 1.202209493e-02f,
1.196636209e-02f, 1.191061559e-02f, 1.185485553e-02f, 1.179908201e-02f, 1.174329512e-02f, 1.168749496e-02f, 1.163168164e-02f, 1.157585524e-02f, 1.152001587e-02f, 1.146416363e-02f,
1.140829860e-02f, 1.135242089e-02f, 1.129653060e-02f, 1.124062783e-02f, 1.118471266e-02f, 1.112878521e-02f, 1.107284556e-02f, 1.101689382e-02f, 1.096093009e-02f, 1.090495445e-02f,
1.084896701e-02f, 1.079296787e-02f, 1.073695713e-02f, 1.068093488e-02f, 1.062490121e-02f, 1.056885624e-02f, 1.051280005e-02f, 1.045673274e-02f, 1.040065442e-02f, 1.034456518e-02f,
1.028846511e-02f, 1.023235432e-02f, 1.017623291e-02f, 1.012010096e-02f, 1.006395858e-02f, 1.000780587e-02f, 9.951642930e-03f, 9.895469849e-03f, 9.839286728e-03f, 9.783093667e-03f,
9.726890762e-03f, 9.670678111e-03f, 9.614455814e-03f, 9.558223967e-03f, 9.501982668e-03f, 9.445732016e-03f, 9.389472109e-03f, 9.333203044e-03f, 9.276924920e-03f, 9.220637834e-03f,
9.164341884e-03f, 9.108037169e-03f, 9.051723786e-03f, 8.995401834e-03f, 8.939071410e-03f, 8.882732612e-03f, 8.826385539e-03f, 8.770030288e-03f, 8.713666958e-03f, 8.657295646e-03f,
8.600916450e-03f, 8.544529469e-03f, 8.488134800e-03f, 8.431732542e-03f, 8.375322792e-03f, 8.318905648e-03f, 8.262481209e-03f, 8.206049572e-03f, 8.149610836e-03f, 8.093165099e-03f,
8.036712457e-03f, 7.980253011e-03f, 7.923786856e-03f, 7.867314093e-03f, 7.810834817e-03f, 7.754349129e-03f, 7.697857124e-03f, 7.641358903e-03f, 7.584854562e-03f, 7.528344199e-03f,
7.471827913e-03f, 7.415305802e-03f, 7.358777963e-03f, 7.302244494e-03f, 7.245705494e-03f, 7.189161061e-03f, 7.132611292e-03f, 7.076056285e-03f, 7.019496139e-03f, 6.962930951e-03f,
6.906360820e-03f, 6.849785843e-03f, 6.793206119e-03f, 6.736621744e-03f, 6.680032818e-03f, 6.623439438e-03f, 6.566841702e-03f, 6.510239708e-03f, 6.453633554e-03f, 6.397023338e-03f,
6.340409158e-03f, 6.283791112e-03f, 6.227169297e-03f, 6.170543812e-03f, 6.113914754e-03f, 6.057282222e-03f, 6.000646313e-03f, 5.944007126e-03f, 5.887364757e-03f, 5.830719305e-03f,
5.774070868e-03f, 5.717419543e-03f, 5.660765429e-03f, 5.604108624e-03f, 5.547449224e-03f, 5.490787329e-03f, 5.434123035e-03f, 5.377456441e-03f, 5.320787644e-03f, 5.264116742e-03f,
5.207443834e-03f, 5.150769016e-03f, 5.094092387e-03f, 5.037414044e-03f, 4.980734085e-03f, 4.924052608e-03f, 4.867369710e-03f, 4.810685490e-03f, 4.754000044e-03f, 4.697313471e-03f,
4.640625869e-03f, 4.583937334e-03f, 4.527247965e-03f, 4.470557860e-03f, 4.413867115e-03f, 4.357175829e-03f, 4.300484099e-03f, 4.243792024e-03f, 4.187099699e-03f, 4.130407224e-03f,
4.073714695e-03f, 4.017022211e-03f, 3.960329868e-03f, 3.903637765e-03f, 3.846945998e-03f, 3.790254666e-03f, 3.733563865e-03f, 3.676873694e-03f, 3.620184250e-03f, 3.563495630e-03f,
3.506807932e-03f, 3.450121252e-03f, 3.393435690e-03f, 3.336751341e-03f, 3.280068304e-03f, 3.223386676e-03f, 3.166706554e-03f, 3.110028035e-03f, 3.053351217e-03f, 2.996676197e-03f,
2.940003073e-03f, 2.883331941e-03f, 2.826662900e-03f, 2.769996045e-03f, 2.713331476e-03f, 2.656669288e-03f, 2.600009579e-03f, 2.543352446e-03f, 2.486697986e-03f, 2.430046297e-03f,
2.373397476e-03f, 2.316751619e-03f, 2.260108825e-03f, 2.203469189e-03f, 2.146832809e-03f, 2.090199783e-03f, 2.033570207e-03f, 1.976944177e-03f, 1.920321792e-03f, 1.863703149e-03f,
1.807088343e-03f, 1.750477472e-03f, 1.693870634e-03f, 1.637267924e-03f, 1.580669440e-03f, 1.524075279e-03f, 1.467485538e-03f, 1.410900313e-03f, 1.354319701e-03f, 1.297743799e-03f,
1.241172704e-03f, 1.184606512e-03f, 1.128045321e-03f, 1.071489226e-03f, 1.014938326e-03f, 9.583927154e-04f, 9.018524920e-04f, 8.453177523e-04f, 7.887885928e-04f, 7.322651102e-04f,
6.757474009e-04f, 6.192355616e-04f, 5.627296887e-04f, 5.062298788e-04f, 4.497362282e-04f, 3.932488336e-04f, 3.367677913e-04f, 2.802931977e-04f, 2.238251492e-04f, 1.673637422e-04f,
1.109090730e-04f, 5.446123792e-05f, -1.979666749e-06f, -5.841354473e-05f, -1.148402998e-04f, -1.712598357e-04f, -2.276720563e-04f, -2.840768653e-04f, -3.404741667e-04f, -3.968638643e-04f,
-4.532458620e-04f, -5.096200638e-04f, -5.659863735e-04f, -6.223446953e-04f, -6.786949330e-04f, -7.350369907e-04f, -7.913707726e-04f, -8.476961825e-04f, -9.040131247e-04f, -9.603215034e-04f,
-1.016621223e-03f, -1.072912186e-03f, -1.129194299e-03f, -1.185467465e-03f, -1.241731589e-03f, -1.297986574e-03f, -1.354232326e-03f, -1.410468748e-03f, -1.466695744e-03f, -1.522913220e-03f,
-1.579121080e-03f, -1.635319227e-03f, -1.691507568e-03f, -1.747686005e-03f, -1.803854444e-03f, -1.860012790e-03f, -1.916160946e-03f, -1.972298818e-03f, -2.028426310e-03f, -2.084543327e-03f,
-2.140649773e-03f, -2.196745554e-03f, -2.252830574e-03f, -2.308904738e-03f, -2.364967951e-03f, -2.421020117e-03f, -2.477061142e-03f, -2.533090931e-03f, -2.589109388e-03f, -2.645116418e-03f,
-2.701111928e-03f, -2.757095820e-03f, -2.813068002e-03f, -2.869028377e-03f, -2.924976851e-03f, -2.980913329e-03f, -3.036837717e-03f, -3.092749920e-03f, -3.148649842e-03f, -3.204537390e-03f,
-3.260412468e-03f, -3.316274982e-03f, -3.372124838e-03f, -3.427961940e-03f, -3.483786195e-03f, -3.539597508e-03f, -3.595395784e-03f, -3.651180929e-03f, -3.706952849e-03f, -3.762711449e-03f,
-3.818456636e-03f, -3.874188313e-03f, -3.929906389e-03f, -3.985610767e-03f, -4.041301355e-03f, -4.096978058e-03f, -4.152640782e-03f, -4.208289432e-03f, -4.263923915e-03f, -4.319544137e-03f,
-4.375150004e-03f, -4.430741422e-03f, -4.486318297e-03f, -4.541880535e-03f, -4.597428043e-03f, -4.652960726e-03f, -4.708478491e-03f, -4.763981244e-03f, -4.819468892e-03f, -4.874941340e-03f,
-4.930398496e-03f, -4.985840266e-03f, -5.041266556e-03f, -5.096677272e-03f, -5.152072322e-03f, -5.207451612e-03f, -5.262815049e-03f, -5.318162539e-03f, -5.373493989e-03f, -5.428809306e-03f,
-5.484108396e-03f, -5.539391167e-03f, -5.594657524e-03f, -5.649907377e-03f, -5.705140630e-03f, -5.760357191e-03f, -5.815556968e-03f, -5.870739867e-03f, -5.925905795e-03f, -5.981054660e-03f,
-6.036186368e-03f, -6.091300828e-03f, -6.146397946e-03f, -6.201477629e-03f, -6.256539785e-03f, -6.311584322e-03f, -6.366611146e-03f, -6.421620166e-03f, -6.476611288e-03f, -6.531584421e-03f,
-6.586539472e-03f, -6.641476349e-03f, -6.696394959e-03f, -6.751295210e-03f, -6.806177010e-03f, -6.861040266e-03f, -6.915884887e-03f, -6.970710781e-03f, -7.025517855e-03f, -7.080306018e-03f,
-7.135075177e-03f, -7.189825240e-03f, -7.244556117e-03f, -7.299267714e-03f, -7.353959940e-03f, -7.408632704e-03f, -7.463285913e-03f, -7.517919477e-03f, -7.572533303e-03f, -7.627127300e-03f,
-7.681701376e-03f, -7.736255440e-03f, -7.790789400e-03f, -7.845303166e-03f, -7.899796646e-03f, -7.954269748e-03f, -8.008722381e-03f, -8.063154455e-03f, -8.117565877e-03f, -8.171956557e-03f,
-8.226326404e-03f, -8.280675327e-03f, -8.335003235e-03f, -8.389310036e-03f, -8.443595641e-03f, -8.497859958e-03f, -8.552102897e-03f, -8.606324366e-03f, -8.660524275e-03f, -8.714702534e-03f,
-8.768859052e-03f, -8.822993738e-03f, -8.877106503e-03f, -8.931197254e-03f, -8.985265903e-03f, -9.039312359e-03f, -9.093336531e-03f, -9.147338329e-03f, -9.201317664e-03f, -9.255274444e-03f,
-9.309208580e-03f, -9.363119983e-03f, -9.417008561e-03f, -9.470874225e-03f, -9.524716885e-03f, -9.578536451e-03f, -9.632332834e-03f, -9.686105943e-03f, -9.739855690e-03f, -9.793581983e-03f,
-9.847284735e-03f, -9.900963855e-03f, -9.954619254e-03f, -1.000825084e-02f, -1.006185853e-02f, -1.011544223e-02f, -1.016900185e-02f, -1.022253730e-02f, -1.027604850e-02f, -1.032953535e-02f,
-1.038299776e-02f, -1.043643565e-02f, -1.048984893e-02f, -1.054323751e-02f, -1.059660129e-02f, -1.064994020e-02f, -1.070325413e-02f, -1.075654301e-02f, -1.080980675e-02f, -1.086304525e-02f,
-1.091625843e-02f, -1.096944619e-02f, -1.102260846e-02f, -1.107574514e-02f, -1.112885614e-02f, -1.118194138e-02f, -1.123500076e-02f, -1.128803421e-02f, -1.134104162e-02f, -1.139402292e-02f,
-1.144697801e-02f, -1.149990681e-02f, -1.155280923e-02f, -1.160568519e-02f, -1.165853458e-02f, -1.171135733e-02f, -1.176415335e-02f, -1.181692255e-02f, -1.186966484e-02f, -1.192238014e-02f,
-1.197506836e-02f, -1.202772941e-02f, -1.208036320e-02f, -1.213296965e-02f, -1.218554867e-02f, -1.223810017e-02f, -1.229062407e-02f, -1.234312027e-02f, -1.239558870e-02f, -1.244802926e-02f,
-1.250044187e-02f, -1.255282643e-02f, -1.260518288e-02f, -1.265751111e-02f, -1.270981104e-02f, -1.276208258e-02f, -1.281432565e-02f, -1.286654017e-02f, -1.291872603e-02f, -1.297088317e-02f,
-1.302301149e-02f, -1.307511091e-02f, -1.312718133e-02f, -1.317922268e-02f, -1.323123487e-02f, -1.328321781e-02f, -1.333517142e-02f, -1.338709560e-02f, -1.343899029e-02f, -1.349085538e-02f,
-1.354269079e-02f, -1.359449644e-02f, -1.364627225e-02f, -1.369801812e-02f, -1.374973397e-02f, -1.380141972e-02f, -1.385307528e-02f, -1.390470056e-02f, -1.395629549e-02f, -1.400785997e-02f,
-1.405939392e-02f, -1.411089725e-02f, -1.416236989e-02f, -1.421381174e-02f, -1.426522273e-02f, -1.431660276e-02f, -1.436795175e-02f, -1.441926962e-02f, -1.447055628e-02f, -1.452181165e-02f,
-1.457303564e-02f, -1.462422818e-02f, -1.467538916e-02f, -1.472651852e-02f, -1.477761617e-02f, -1.482868202e-02f, -1.487971598e-02f, -1.493071799e-02f, -1.498168794e-02f, -1.503262576e-02f,
-1.508353136e-02f, -1.513440467e-02f, -1.518524559e-02f, -1.523605404e-02f, -1.528682994e-02f, -1.533757321e-02f, -1.538828376e-02f, -1.543896151e-02f, -1.548960638e-02f, -1.554021827e-02f,
-1.559079712e-02f, -1.564134284e-02f, -1.569185534e-02f, -1.574233454e-02f, -1.579278035e-02f, -1.584319271e-02f, -1.589357151e-02f, -1.594391669e-02f, -1.599422815e-02f, -1.604450582e-02f,
-1.609474961e-02f, -1.614495944e-02f, -1.619513523e-02f, -1.624527690e-02f, -1.629538436e-02f, -1.634545753e-02f, -1.639549633e-02f, -1.644550068e-02f, -1.649547050e-02f, -1.654540570e-02f,
-1.659530620e-02f, -1.664517192e-02f, -1.669500279e-02f, -1.674479871e-02f, -1.679455960e-02f, -1.684428539e-02f, -1.689397600e-02f, -1.694363134e-02f, -1.699325133e-02f, -1.704283588e-02f,
-1.709238493e-02f, -1.714189839e-02f, -1.719137617e-02f, -1.724081821e-02f, -1.729022440e-02f, -1.733959468e-02f, -1.738892897e-02f, -1.743822718e-02f, -1.748748924e-02f, -1.753671506e-02f,
-1.758590456e-02f, -1.763505766e-02f, -1.768417429e-02f, -1.773325436e-02f, -1.778229779e-02f, -1.783130450e-02f, -1.788027442e-02f, -1.792920746e-02f, -1.797810354e-02f, -1.802696259e-02f,
-1.807578452e-02f, -1.812456926e-02f, -1.817331672e-02f, -1.822202683e-02f, -1.827069950e-02f, -1.831933466e-02f, -1.836793223e-02f, -1.841649213e-02f, -1.846501427e-02f, -1.851349859e-02f,
-1.856194500e-02f, -1.861035343e-02f, -1.865872379e-02f, -1.870705601e-02f, -1.875535000e-02f, -1.880360569e-02f, -1.885182301e-02f, -1.890000187e-02f, -1.894814219e-02f, -1.899624390e-02f,
-1.904430691e-02f, -1.909233116e-02f, -1.914031656e-02f, -1.918826303e-02f, -1.923617050e-02f, -1.928403889e-02f, -1.933186812e-02f, -1.937965811e-02f, -1.942740879e-02f, -1.947512008e-02f,
-1.952279190e-02f, -1.957042418e-02f, -1.961801683e-02f, -1.966556978e-02f, -1.971308296e-02f, -1.976055628e-02f, -1.980798967e-02f, -1.985538305e-02f, -1.990273635e-02f, -1.995004949e-02f,
-1.999732239e-02f, -2.004455498e-02f, -2.009174717e-02f, -2.013889891e-02f, -2.018601009e-02f, -2.023308066e-02f, -2.028011054e-02f, -2.032709964e-02f, -2.037404789e-02f, -2.042095523e-02f,
-2.046782156e-02f, -2.051464682e-02f, -2.056143094e-02f, -2.060817382e-02f, -2.065487541e-02f, -2.070153562e-02f, -2.074815437e-02f, -2.079473161e-02f, -2.084126724e-02f, -2.088776119e-02f,
-2.093421339e-02f, -2.098062377e-02f, -2.102699224e-02f, -2.107331874e-02f, -2.111960319e-02f, -2.116584551e-02f, -2.121204563e-02f, -2.125820348e-02f, -2.130431898e-02f, -2.135039206e-02f,
-2.139642264e-02f, -2.144241066e-02f, -2.148835602e-02f, -2.153425867e-02f, -2.158011853e-02f, -2.162593552e-02f, -2.167170957e-02f, -2.171744060e-02f, -2.176312855e-02f, -2.180877334e-02f,
-2.185437490e-02f, -2.189993315e-02f, -2.194544802e-02f, -2.199091943e-02f, -2.203634732e-02f, -2.208173162e-02f, -2.212707224e-02f, -2.217236911e-02f, -2.221762217e-02f, -2.226283134e-02f,
-2.230799655e-02f, -2.235311772e-02f, -2.239819478e-02f, -2.244322767e-02f, -2.248821631e-02f, -2.253316062e-02f, -2.257806054e-02f, -2.262291599e-02f, -2.266772690e-02f, -2.271249320e-02f,
-2.275721481e-02f, -2.280189168e-02f, -2.284652372e-02f, -2.289111086e-02f, -2.293565304e-02f, -2.298015017e-02f, -2.302460220e-02f, -2.306900904e-02f, -2.311337063e-02f, -2.315768690e-02f,
-2.320195778e-02f, -2.324618319e-02f, -2.329036306e-02f, -2.333449733e-02f, -2.337858592e-02f, -2.342262877e-02f, -2.346662580e-02f, -2.351057694e-02f, -2.355448213e-02f, -2.359834129e-02f,
-2.364215435e-02f, -2.368592125e-02f, -2.372964191e-02f, -2.377331626e-02f, -2.381694424e-02f, -2.386052577e-02f, -2.390406079e-02f, -2.394754922e-02f, -2.399099100e-02f, -2.403438606e-02f,
-2.407773433e-02f, -2.412103574e-02f, -2.416429022e-02f, -2.420749770e-02f, -2.425065811e-02f, -2.429377139e-02f, -2.433683747e-02f, -2.437985627e-02f, -2.442282774e-02f, -2.446575180e-02f,
-2.450862838e-02f, -2.455145741e-02f, -2.459423883e-02f, -2.463697258e-02f, -2.467965857e-02f, -2.472229675e-02f, -2.476488704e-02f, -2.480742939e-02f, -2.484992371e-02f, -2.489236995e-02f,
-2.493476804e-02f, -2.497711791e-02f, -2.501941949e-02f, -2.506167271e-02f, -2.510387752e-02f, -2.514603383e-02f, -2.518814160e-02f, -2.523020074e-02f, -2.527221119e-02f, -2.531417289e-02f,
-2.535608577e-02f, -2.539794977e-02f, -2.543976481e-02f, -2.548153083e-02f, -2.552324777e-02f, -2.556491555e-02f, -2.560653412e-02f, -2.564810341e-02f, -2.568962335e-02f, -2.573109388e-02f,
-2.577251493e-02f, -2.581388644e-02f, -2.585520833e-02f, -2.589648056e-02f, -2.593770304e-02f, -2.597887572e-02f, -2.601999853e-02f, -2.606107141e-02f, -2.610209428e-02f, -2.614306710e-02f,
-2.618398979e-02f, -2.622486229e-02f, -2.626568453e-02f, -2.630645645e-02f, -2.634717798e-02f, -2.638784907e-02f, -2.642846964e-02f, -2.646903964e-02f, -2.650955900e-02f, -2.655002766e-02f,
-2.659044555e-02f, -2.663081261e-02f, -2.667112877e-02f, -2.671139398e-02f, -2.675160817e-02f, -2.679177128e-02f, -2.683188324e-02f, -2.687194399e-02f, -2.691195346e-02f, -2.695191161e-02f,
-2.699181836e-02f, -2.703167364e-02f, -2.707147741e-02f, -2.711122959e-02f, -2.715093013e-02f, -2.719057895e-02f, -2.723017601e-02f, -2.726972123e-02f, -2.730921456e-02f, -2.734865594e-02f,
-2.738804530e-02f, -2.742738257e-02f, -2.746666771e-02f, -2.750590065e-02f, -2.754508132e-02f, -2.758420967e-02f, -2.762328563e-02f, -2.766230915e-02f, -2.770128016e-02f, -2.774019860e-02f,
-2.777906442e-02f, -2.781787754e-02f, -2.785663792e-02f, -2.789534549e-02f, -2.793400019e-02f, -2.797260195e-02f, -2.801115073e-02f, -2.804964646e-02f, -2.808808907e-02f, -2.812647852e-02f,
-2.816481474e-02f, -2.820309767e-02f, -2.824132725e-02f, -2.827950342e-02f, -2.831762613e-02f, -2.835569531e-02f, -2.839371090e-02f, -2.843167285e-02f, -2.846958110e-02f, -2.850743558e-02f,
-2.854523625e-02f, -2.858298303e-02f, -2.862067588e-02f, -2.865831473e-02f, -2.869589953e-02f, -2.873343021e-02f, -2.877090672e-02f, -2.880832901e-02f, -2.884569701e-02f, -2.888301066e-02f,
-2.892026992e-02f, -2.895747471e-02f, -2.899462499e-02f, -2.903172069e-02f, -2.906876176e-02f, -2.910574814e-02f, -2.914267978e-02f, -2.917955661e-02f, -2.921637858e-02f, -2.925314564e-02f,
-2.928985772e-02f, -2.932651478e-02f, -2.936311674e-02f, -2.939966357e-02f, -2.943615520e-02f, -2.947259157e-02f, -2.950897263e-02f, -2.954529832e-02f, -2.958156859e-02f, -2.961778338e-02f,
-2.965394264e-02f, -2.969004630e-02f, -2.972609433e-02f, -2.976208665e-02f, -2.979802321e-02f, -2.983390397e-02f, -2.986972885e-02f, -2.990549782e-02f, -2.994121081e-02f, -2.997686777e-02f,
-3.001246865e-02f, -3.004801338e-02f, -3.008350192e-02f, -3.011893422e-02f, -3.015431020e-02f, -3.018962984e-02f, -3.022489306e-02f, -3.026009981e-02f, -3.029525005e-02f, -3.033034372e-02f,
-3.036538076e-02f, -3.040036112e-02f, -3.043528474e-02f, -3.047015158e-02f, -3.050496159e-02f, -3.053971469e-02f, -3.057441086e-02f, -3.060905002e-02f, -3.064363214e-02f, -3.067815715e-02f,
-3.071262500e-02f, -3.074703564e-02f, -3.078138903e-02f, -3.081568510e-02f, -3.084992380e-02f, -3.088410509e-02f, -3.091822891e-02f, -3.095229520e-02f, -3.098630393e-02f, -3.102025502e-02f,
-3.105414845e-02f, -3.108798414e-02f, -3.112176206e-02f, -3.115548214e-02f, -3.118914434e-02f, -3.122274862e-02f, -3.125629490e-02f, -3.128978316e-02f, -3.132321333e-02f, -3.135658536e-02f,
-3.138989921e-02f, -3.142315482e-02f, -3.145635215e-02f, -3.148949114e-02f, -3.152257174e-02f, -3.155559391e-02f, -3.158855759e-02f, -3.162146274e-02f, -3.165430929e-02f, -3.168709722e-02f,
-3.171982646e-02f, -3.175249696e-02f, -3.178510869e-02f, -3.181766158e-02f, -3.185015559e-02f, -3.188259067e-02f, -3.191496677e-02f, -3.194728384e-02f, -3.197954184e-02f, -3.201174071e-02f,
-3.204388041e-02f, -3.207596089e-02f, -3.210798210e-02f, -3.213994400e-02f, -3.217184652e-02f, -3.220368964e-02f, -3.223547330e-02f, -3.226719744e-02f, -3.229886204e-02f, -3.233046703e-02f,
-3.236201236e-02f, -3.239349801e-02f, -3.242492390e-02f, -3.245629001e-02f, -3.248759628e-02f, -3.251884266e-02f, -3.255002911e-02f, -3.258115559e-02f, -3.261222204e-02f, -3.264322842e-02f,
-3.267417468e-02f, -3.270506078e-02f, -3.273588667e-02f, -3.276665231e-02f, -3.279735764e-02f, -3.282800263e-02f, -3.285858723e-02f, -3.288911139e-02f, -3.291957507e-02f, -3.294997822e-02f,
-3.298032080e-02f, -3.301060276e-02f, -3.304082406e-02f, -3.307098465e-02f, -3.310108449e-02f, -3.313112354e-02f, -3.316110174e-02f, -3.319101906e-02f, -3.322087545e-02f, -3.325067086e-02f,
-3.328040526e-02f, -3.331007860e-02f, -3.333969083e-02f, -3.336924191e-02f, -3.339873180e-02f, -3.342816046e-02f, -3.345752783e-02f, -3.348683388e-02f, -3.351607857e-02f, -3.354526185e-02f,
-3.357438368e-02f, -3.360344401e-02f, -3.363244281e-02f, -3.366138003e-02f, -3.369025563e-02f, -3.371906956e-02f, -3.374782179e-02f, -3.377651226e-02f, -3.380514095e-02f, -3.383370781e-02f,
-3.386221279e-02f, -3.389065585e-02f, -3.391903696e-02f, -3.394735607e-02f, -3.397561314e-02f, -3.400380813e-02f, -3.403194099e-02f, -3.406001170e-02f, -3.408802019e-02f, -3.411596645e-02f,
-3.414385041e-02f, -3.417167205e-02f, -3.419943133e-02f, -3.422712819e-02f, -3.425476261e-02f, -3.428233454e-02f, -3.430984395e-02f, -3.433729078e-02f, -3.436467501e-02f, -3.439199660e-02f,
-3.441925549e-02f, -3.444645166e-02f, -3.447358507e-02f, -3.450065567e-02f, -3.452766343e-02f, -3.455460830e-02f, -3.458149026e-02f, -3.460830925e-02f, -3.463506525e-02f, -3.466175821e-02f,
-3.468838809e-02f, -3.471495486e-02f, -3.474145848e-02f, -3.476789890e-02f, -3.479427610e-02f, -3.482059003e-02f, -3.484684066e-02f, -3.487302795e-02f, -3.489915186e-02f, -3.492521235e-02f,
-3.495120939e-02f, -3.497714293e-02f, -3.500301295e-02f, -3.502881941e-02f, -3.505456226e-02f, -3.508024147e-02f, -3.510585701e-02f, -3.513140884e-02f, -3.515689692e-02f, -3.518232121e-02f,
-3.520768169e-02f, -3.523297831e-02f, -3.525821103e-02f, -3.528337983e-02f, -3.530848467e-02f, -3.533352550e-02f, -3.535850230e-02f, -3.538341503e-02f, -3.540826365e-02f, -3.543304814e-02f,
-3.545776844e-02f, -3.548242454e-02f, -3.550701639e-02f, -3.553154396e-02f, -3.555600722e-02f, -3.558040613e-02f, -3.560474065e-02f, -3.562901076e-02f, -3.565321641e-02f, -3.567735758e-02f,
-3.570143423e-02f, -3.572544632e-02f, -3.574939383e-02f, -3.577327672e-02f, -3.579709496e-02f, -3.582084850e-02f, -3.584453733e-02f, -3.586816140e-02f, -3.589172069e-02f, -3.591521515e-02f,
-3.593864477e-02f, -3.596200950e-02f, -3.598530931e-02f, -3.600854418e-02f, -3.603171406e-02f, -3.605481893e-02f, -3.607785875e-02f, -3.610083349e-02f, -3.612374313e-02f, -3.614658762e-02f,
-3.616936694e-02f, -3.619208105e-02f, -3.621472993e-02f, -3.623731354e-02f, -3.625983186e-02f, -3.628228484e-02f, -3.630467247e-02f, -3.632699470e-02f, -3.634925152e-02f, -3.637144288e-02f,
-3.639356876e-02f, -3.641562912e-02f, -3.643762394e-02f, -3.645955319e-02f, -3.648141684e-02f, -3.650321486e-02f, -3.652494721e-02f, -3.654661387e-02f, -3.656821481e-02f, -3.658974999e-02f,
-3.661121940e-02f, -3.663262300e-02f, -3.665396076e-02f, -3.667523265e-02f, -3.669643865e-02f, -3.671757872e-02f, -3.673865284e-02f, -3.675966098e-02f, -3.678060310e-02f, -3.680147919e-02f,
-3.682228921e-02f, -3.684303314e-02f, -3.686371095e-02f, -3.688432260e-02f, -3.690486808e-02f, -3.692534736e-02f, -3.694576040e-02f, -3.696610718e-02f, -3.698638767e-02f, -3.700660185e-02f,
-3.702674969e-02f, -3.704683117e-02f, -3.706684624e-02f, -3.708679490e-02f, -3.710667711e-02f, -3.712649285e-02f, -3.714624208e-02f, -3.716592480e-02f, -3.718554095e-02f, -3.720509053e-02f,
-3.722457351e-02f, -3.724398986e-02f, -3.726333955e-02f, -3.728262257e-02f, -3.730183887e-02f, -3.732098845e-02f, -3.734007127e-02f, -3.735908731e-02f, -3.737803655e-02f, -3.739691895e-02f,
-3.741573451e-02f, -3.743448318e-02f, -3.745316495e-02f, -3.747177979e-02f, -3.749032768e-02f, -3.750880859e-02f, -3.752722250e-02f, -3.754556939e-02f, -3.756384924e-02f, -3.758206201e-02f,
-3.760020769e-02f, -3.761828625e-02f, -3.763629767e-02f, -3.765424193e-02f, -3.767211900e-02f, -3.768992886e-02f, -3.770767149e-02f, -3.772534687e-02f, -3.774295497e-02f, -3.776049577e-02f,
-3.777796924e-02f, -3.779537538e-02f, -3.781271415e-02f, -3.782998553e-02f, -3.784718950e-02f, -3.786432604e-02f, -3.788139513e-02f, -3.789839675e-02f, -3.791533087e-02f, -3.793219748e-02f,
-3.794899654e-02f, -3.796572805e-02f, -3.798239198e-02f, -3.799898832e-02f, -3.801551703e-02f, -3.803197810e-02f, -3.804837151e-02f, -3.806469724e-02f, -3.808095526e-02f, -3.809714557e-02f,
-3.811326813e-02f, -3.812932294e-02f, -3.814530996e-02f, -3.816122919e-02f, -3.817708059e-02f, -3.819286416e-02f, -3.820857987e-02f, -3.822422770e-02f, -3.823980764e-02f, -3.825531966e-02f,
-3.827076375e-02f, -3.828613989e-02f, -3.830144805e-02f, -3.831668823e-02f, -3.833186041e-02f, -3.834696456e-02f, -3.836200066e-02f, -3.837696871e-02f, -3.839186867e-02f, -3.840670055e-02f,
-3.842146430e-02f, -3.843615993e-02f, -3.845078741e-02f, -3.846534673e-02f, -3.847983786e-02f, -3.849426080e-02f, -3.850861551e-02f, -3.852290200e-02f, -3.853712024e-02f, -3.855127021e-02f,
-3.856535191e-02f, -3.857936530e-02f, -3.859331038e-02f, -3.860718713e-02f, -3.862099554e-02f, -3.863473558e-02f, -3.864840725e-02f, -3.866201052e-02f, -3.867554539e-02f, -3.868901184e-02f,
-3.870240985e-02f, -3.871573940e-02f, -3.872900049e-02f, -3.874219309e-02f, -3.875531720e-02f, -3.876837280e-02f, -3.878135987e-02f, -3.879427840e-02f, -3.880712838e-02f, -3.881990979e-02f,
-3.883262261e-02f, -3.884526684e-02f, -3.885784246e-02f, -3.887034946e-02f, -3.888278782e-02f, -3.889515753e-02f, -3.890745858e-02f, -3.891969095e-02f, -3.893185464e-02f, -3.894394962e-02f,
-3.895597588e-02f, -3.896793342e-02f, -3.897982222e-02f, -3.899164227e-02f, -3.900339355e-02f, -3.901507606e-02f, -3.902668977e-02f, -3.903823469e-02f, -3.904971080e-02f, -3.906111808e-02f,
-3.907245653e-02f, -3.908372613e-02f, -3.909492687e-02f, -3.910605874e-02f, -3.911712173e-02f, -3.912811584e-02f, -3.913904104e-02f, -3.914989732e-02f, -3.916068469e-02f, -3.917140312e-02f,
-3.918205261e-02f, -3.919263314e-02f, -3.920314471e-02f, -3.921358730e-02f, -3.922396091e-02f, -3.923426553e-02f, -3.924450114e-02f, -3.925466775e-02f, -3.926476532e-02f, -3.927479387e-02f,
-3.928475338e-02f, -3.929464384e-02f, -3.930446524e-02f, -3.931421757e-02f, -3.932390082e-02f, -3.933351500e-02f, -3.934306008e-02f, -3.935253605e-02f, -3.936194292e-02f, -3.937128068e-02f,
-3.938054930e-02f, -3.938974880e-02f, -3.939887915e-02f, -3.940794035e-02f, -3.941693240e-02f, -3.942585529e-02f, -3.943470900e-02f, -3.944349354e-02f, -3.945220889e-02f, -3.946085506e-02f,
-3.946943202e-02f, -3.947793978e-02f, -3.948637833e-02f, -3.949474766e-02f, -3.950304777e-02f, -3.951127865e-02f, -3.951944029e-02f, -3.952753269e-02f, -3.953555584e-02f, -3.954350974e-02f,
-3.955139438e-02f, -3.955920976e-02f, -3.956695586e-02f, -3.957463270e-02f, -3.958224025e-02f, -3.958977852e-02f, -3.959724750e-02f, -3.960464718e-02f, -3.961197756e-02f, -3.961923865e-02f,
-3.962643042e-02f, -3.963355288e-02f, -3.964060603e-02f, -3.964758986e-02f, -3.965450436e-02f, -3.966134953e-02f, -3.966812538e-02f, -3.967483189e-02f, -3.968146906e-02f, -3.968803689e-02f,
-3.969453537e-02f, -3.970096451e-02f, -3.970732430e-02f, -3.971361473e-02f, -3.971983581e-02f, -3.972598753e-02f, -3.973206989e-02f, -3.973808288e-02f, -3.974402651e-02f, -3.974990077e-02f,
-3.975570567e-02f, -3.976144119e-02f, -3.976710734e-02f, -3.977270411e-02f, -3.977823151e-02f, -3.978368953e-02f, -3.978907817e-02f, -3.979439743e-02f, -3.979964731e-02f, -3.980482781e-02f,
-3.980993892e-02f, -3.981498065e-02f, -3.981995300e-02f, -3.982485597e-02f, -3.982968955e-02f, -3.983445374e-02f, -3.983914855e-02f, -3.984377398e-02f, -3.984833002e-02f, -3.985281668e-02f,
-3.985723395e-02f, -3.986158184e-02f, -3.986586035e-02f, -3.987006948e-02f, -3.987420922e-02f, -3.987827959e-02f, -3.988228057e-02f, -3.988621218e-02f, -3.989007442e-02f, -3.989386727e-02f,
-3.989759076e-02f, -3.990124487e-02f, -3.990482962e-02f, -3.990834500e-02f, -3.991179101e-02f, -3.991516766e-02f, -3.991847495e-02f, -3.992171288e-02f, -3.992488145e-02f, -3.992798067e-02f,
-3.993101054e-02f, -3.993397106e-02f, -3.993686224e-02f, -3.993968408e-02f, -3.994243658e-02f, -3.994511975e-02f, -3.994773358e-02f, -3.995027809e-02f, -3.995275327e-02f, -3.995515913e-02f,
-3.995749568e-02f, -3.995976291e-02f, -3.996196084e-02f, -3.996408947e-02f, -3.996614879e-02f, -3.996813882e-02f, -3.997005957e-02f, -3.997191102e-02f, -3.997369320e-02f, -3.997540611e-02f,
-3.997704974e-02f, -3.997862411e-02f, -3.998012922e-02f, -3.998156508e-02f, -3.998293169e-02f, -3.998422906e-02f, -3.998545719e-02f, -3.998661609e-02f, -3.998770577e-02f, -3.998872623e-02f,
-3.998967748e-02f, -3.999055952e-02f, -3.999137237e-02f, -3.999211602e-02f, -3.999279049e-02f, -3.999339579e-02f, -3.999393191e-02f, -3.999439887e-02f, -3.999479667e-02f, -3.999512532e-02f,
-3.999538483e-02f, -3.999557521e-02f, -3.999569646e-02f, -3.999574859e-02f, -3.999573162e-02f, -3.999564554e-02f, -3.999549037e-02f, -3.999526611e-02f, -3.999497278e-02f, -3.999461037e-02f,
-3.999417891e-02f, -3.999367840e-02f, -3.999310884e-02f, -3.999247026e-02f, -3.999176265e-02f, -3.999098602e-02f, -3.999014039e-02f, -3.998922576e-02f, -3.998824215e-02f, -3.998718957e-02f,
-3.998606801e-02f, -3.998487750e-02f, -3.998361805e-02f, -3.998228966e-02f, -3.998089234e-02f, -3.997942611e-02f, -3.997789097e-02f, -3.997628694e-02f, -3.997461403e-02f, -3.997287225e-02f,
-3.997106160e-02f, -3.996918211e-02f, -3.996723377e-02f, -3.996521661e-02f, -3.996313064e-02f, -3.996097586e-02f, -3.995875228e-02f, -3.995645993e-02f, -3.995409881e-02f, -3.995166894e-02f,
-3.994917031e-02f, -3.994660296e-02f, -3.994396689e-02f, -3.994126211e-02f, -3.993848864e-02f, -3.993564649e-02f, -3.993273567e-02f, -3.992975619e-02f, -3.992670807e-02f, -3.992359132e-02f,
-3.992040596e-02f, -3.991715200e-02f, -3.991382944e-02f, -3.991043832e-02f, -3.990697863e-02f, -3.990345039e-02f, -3.989985363e-02f, -3.989618834e-02f, -3.989245455e-02f, -3.988865227e-02f,
-3.988478151e-02f, -3.988084230e-02f, -3.987683464e-02f, -3.987275854e-02f, -3.986861403e-02f, -3.986440113e-02f, -3.986011983e-02f, -3.985577017e-02f, -3.985135215e-02f, -3.984686579e-02f,
-3.984231110e-02f, -3.983768811e-02f, -3.983299683e-02f, -3.982823727e-02f, -3.982340946e-02f, -3.981851340e-02f, -3.981354911e-02f, -3.980851661e-02f, -3.980341592e-02f, -3.979824705e-02f,
-3.979301002e-02f, -3.978770485e-02f, -3.978233155e-02f, -3.977689015e-02f, -3.977138065e-02f, -3.976580307e-02f, -3.976015744e-02f, -3.975444378e-02f, -3.974866209e-02f, -3.974281239e-02f,
-3.973689471e-02f, -3.973090907e-02f, -3.972485547e-02f, -3.971873395e-02f, -3.971254451e-02f, -3.970628718e-02f, -3.969996197e-02f, -3.969356891e-02f, -3.968710801e-02f, -3.968057929e-02f,
-3.967398277e-02f, -3.966731848e-02f, -3.966058642e-02f, -3.965378662e-02f, -3.964691910e-02f, -3.963998388e-02f, -3.963298097e-02f, -3.962591041e-02f, -3.961877220e-02f, -3.961156637e-02f,
-3.960429294e-02f, -3.959695193e-02f, -3.958954335e-02f, -3.958206724e-02f, -3.957452361e-02f, -3.956691248e-02f, -3.955923387e-02f, -3.955148781e-02f, -3.954367431e-02f, -3.953579340e-02f,
-3.952784509e-02f, -3.951982942e-02f, -3.951174639e-02f, -3.950359604e-02f, -3.949537838e-02f, -3.948709344e-02f, -3.947874123e-02f, -3.947032179e-02f, -3.946183513e-02f, -3.945328127e-02f,
-3.944466025e-02f, -3.943597207e-02f, -3.942721677e-02f, -3.941839436e-02f, -3.940950487e-02f, -3.940054833e-02f, -3.939152475e-02f, -3.938243416e-02f, -3.937327658e-02f, -3.936405204e-02f,
-3.935476055e-02f, -3.934540215e-02f, -3.933597686e-02f, -3.932648470e-02f, -3.931692569e-02f, -3.930729987e-02f, -3.929760724e-02f, -3.928784785e-02f, -3.927802171e-02f, -3.926812884e-02f,
-3.925816928e-02f, -3.924814305e-02f, -3.923805017e-02f, -3.922789066e-02f, -3.921766456e-02f, -3.920737188e-02f, -3.919701266e-02f, -3.918658692e-02f, -3.917609468e-02f, -3.916553598e-02f,
-3.915491083e-02f, -3.914421926e-02f, -3.913346130e-02f, -3.912263697e-02f, -3.911174631e-02f, -3.910078933e-02f, -3.908976607e-02f, -3.907867655e-02f, -3.906752080e-02f, -3.905629884e-02f,
-3.904501070e-02f, -3.903365641e-02f, -3.902223600e-02f, -3.901074948e-02f, -3.899919690e-02f, -3.898757828e-02f, -3.897589365e-02f, -3.896414302e-02f, -3.895232644e-02f, -3.894044393e-02f,
-3.892849552e-02f, -3.891648123e-02f, -3.890440109e-02f, -3.889225514e-02f, -3.888004340e-02f, -3.886776590e-02f, -3.885542267e-02f, -3.884301373e-02f, -3.883053912e-02f, -3.881799887e-02f,
-3.880539300e-02f, -3.879272155e-02f, -3.877998453e-02f, -3.876718200e-02f, -3.875431396e-02f, -3.874138046e-02f, -3.872838151e-02f, -3.871531717e-02f, -3.870218744e-02f, -3.868899236e-02f,
-3.867573197e-02f, -3.866240629e-02f, -3.864901536e-02f, -3.863555920e-02f, -3.862203784e-02f, -3.860845132e-02f, -3.859479967e-02f, -3.858108291e-02f, -3.856730109e-02f, -3.855345422e-02f,
-3.853954234e-02f, -3.852556549e-02f, -3.851152370e-02f, -3.849741698e-02f, -3.848324539e-02f, -3.846900895e-02f, -3.845470769e-02f, -3.844034164e-02f, -3.842591084e-02f, -3.841141532e-02f,
-3.839685511e-02f, -3.838223025e-02f, -3.836754076e-02f, -3.835278668e-02f, -3.833796804e-02f, -3.832308488e-02f, -3.830813722e-02f, -3.829312511e-02f, -3.827804857e-02f, -3.826290764e-02f,
-3.824770236e-02f, -3.823243274e-02f, -3.821709884e-02f, -3.820170068e-02f, -3.818623829e-02f, -3.817071172e-02f, -3.815512099e-02f, -3.813946615e-02f, -3.812374721e-02f, -3.810796422e-02f,
-3.809211722e-02f, -3.807620623e-02f, -3.806023130e-02f, -3.804419245e-02f, -3.802808973e-02f, -3.801192316e-02f, -3.799569278e-02f, -3.797939864e-02f, -3.796304075e-02f, -3.794661917e-02f,
-3.793013392e-02f, -3.791358504e-02f, -3.789697256e-02f, -3.788029653e-02f, -3.786355698e-02f, -3.784675394e-02f, -3.782988745e-02f, -3.781295754e-02f, -3.779596426e-02f, -3.777890764e-02f,
-3.776178772e-02f, -3.774460453e-02f, -3.772735811e-02f, -3.771004850e-02f, -3.769267573e-02f, -3.767523985e-02f, -3.765774088e-02f, -3.764017887e-02f, -3.762255385e-02f, -3.760486587e-02f,
-3.758711495e-02f, -3.756930114e-02f, -3.755142448e-02f, -3.753348500e-02f, -3.751548274e-02f, -3.749741774e-02f, -3.747929004e-02f, -3.746109967e-02f, -3.744284668e-02f, -3.742453110e-02f,
-3.740615298e-02f, -3.738771234e-02f, -3.736920924e-02f, -3.735064370e-02f, -3.733201578e-02f, -3.731332550e-02f, -3.729457290e-02f, -3.727575804e-02f, -3.725688094e-02f, -3.723794164e-02f,
-3.721894019e-02f, -3.719987663e-02f, -3.718075099e-02f, -3.716156332e-02f, -3.714231365e-02f, -3.712300203e-02f, -3.710362850e-02f, -3.708419309e-02f, -3.706469585e-02f, -3.704513682e-02f,
-3.702551603e-02f, -3.700583354e-02f, -3.698608938e-02f, -3.696628359e-02f, -3.694641621e-02f, -3.692648729e-02f, -3.690649686e-02f, -3.688644497e-02f, -3.686633166e-02f, -3.684615697e-02f,
-3.682592095e-02f, -3.680562363e-02f, -3.678526505e-02f, -3.676484526e-02f, -3.674436431e-02f, -3.672382222e-02f, -3.670321906e-02f, -3.668255485e-02f, -3.666182964e-02f, -3.664104347e-02f,
-3.662019639e-02f, -3.659928844e-02f, -3.657831967e-02f, -3.655729011e-02f, -3.653619980e-02f, -3.651504880e-02f, -3.649383714e-02f, -3.647256488e-02f, -3.645123204e-02f, -3.642983868e-02f,
-3.640838484e-02f, -3.638687056e-02f, -3.636529590e-02f, -3.634366088e-02f, -3.632196556e-02f, -3.630020998e-02f, -3.627839419e-02f, -3.625651822e-02f, -3.623458213e-02f, -3.621258596e-02f,
-3.619052975e-02f, -3.616841354e-02f, -3.614623740e-02f, -3.612400135e-02f, -3.610170544e-02f, -3.607934972e-02f, -3.605693424e-02f, -3.603445904e-02f, -3.601192416e-02f, -3.598932965e-02f,
-3.596667556e-02f, -3.594396193e-02f, -3.592118881e-02f, -3.589835624e-02f, -3.587546428e-02f, -3.585251296e-02f, -3.582950234e-02f, -3.580643245e-02f, -3.578330335e-02f, -3.576011509e-02f,
-3.573686770e-02f, -3.571356124e-02f, -3.569019576e-02f, -3.566677129e-02f, -3.564328789e-02f, -3.561974561e-02f, -3.559614449e-02f, -3.557248458e-02f, -3.554876592e-02f, -3.552498857e-02f,
-3.550115258e-02f, -3.547725798e-02f, -3.545330483e-02f, -3.542929317e-02f, -3.540522306e-02f, -3.538109455e-02f, -3.535690767e-02f, -3.533266248e-02f, -3.530835903e-02f, -3.528399736e-02f,
-3.525957753e-02f, -3.523509958e-02f, -3.521056357e-02f, -3.518596953e-02f, -3.516131753e-02f, -3.513660760e-02f, -3.511183980e-02f, -3.508701418e-02f, -3.506213079e-02f, -3.503718967e-02f,
-3.501219088e-02f, -3.498713446e-02f, -3.496202047e-02f, -3.493684895e-02f, -3.491161996e-02f, -3.488633355e-02f, -3.486098976e-02f, -3.483558864e-02f, -3.481013026e-02f, -3.478461464e-02f,
-3.475904186e-02f, -3.473341195e-02f, -3.470772497e-02f, -3.468198097e-02f, -3.465618000e-02f, -3.463032211e-02f, -3.460440735e-02f, -3.457843577e-02f, -3.455240743e-02f, -3.452632237e-02f,
-3.450018066e-02f, -3.447398232e-02f, -3.444772743e-02f, -3.442141603e-02f, -3.439504818e-02f, -3.436862392e-02f, -3.434214331e-02f, -3.431560639e-02f, -3.428901323e-02f, -3.426236387e-02f,
-3.423565837e-02f, -3.420889678e-02f, -3.418207915e-02f, -3.415520553e-02f, -3.412827598e-02f, -3.410129054e-02f, -3.407424928e-02f, -3.404715225e-02f, -3.401999949e-02f, -3.399279107e-02f,
-3.396552702e-02f, -3.393820742e-02f, -3.391083231e-02f, -3.388340174e-02f, -3.385591577e-02f, -3.382837445e-02f, -3.380077784e-02f, -3.377312599e-02f, -3.374541895e-02f, -3.371765678e-02f,
-3.368983953e-02f, -3.366196725e-02f, -3.363404001e-02f, -3.360605785e-02f, -3.357802083e-02f, -3.354992901e-02f, -3.352178243e-02f, -3.349358115e-02f, -3.346532524e-02f, -3.343701473e-02f,
-3.340864970e-02f, -3.338023018e-02f, -3.335175625e-02f, -3.332322795e-02f, -3.329464533e-02f, -3.326600846e-02f, -3.323731739e-02f, -3.320857218e-02f, -3.317977287e-02f, -3.315091954e-02f,
-3.312201222e-02f, -3.309305099e-02f, -3.306403589e-02f, -3.303496697e-02f, -3.300584431e-02f, -3.297666795e-02f, -3.294743795e-02f, -3.291815436e-02f, -3.288881725e-02f, -3.285942667e-02f,
-3.282998267e-02f, -3.280048532e-02f, -3.277093466e-02f, -3.274133076e-02f, -3.271167368e-02f, -3.268196347e-02f, -3.265220018e-02f, -3.262238388e-02f, -3.259251463e-02f, -3.256259247e-02f,
-3.253261747e-02f, -3.250258969e-02f, -3.247250918e-02f, -3.244237600e-02f, -3.241219021e-02f, -3.238195187e-02f, -3.235166103e-02f, -3.232131776e-02f, -3.229092211e-02f, -3.226047413e-02f,
-3.222997390e-02f, -3.219942146e-02f, -3.216881688e-02f, -3.213816021e-02f, -3.210745152e-02f, -3.207669085e-02f, -3.204587828e-02f, -3.201501386e-02f, -3.198409764e-02f, -3.195312970e-02f,
-3.192211008e-02f, -3.189103884e-02f, -3.185991605e-02f, -3.182874177e-02f, -3.179751605e-02f, -3.176623896e-02f, -3.173491055e-02f, -3.170353088e-02f, -3.167210002e-02f, -3.164061802e-02f,
-3.160908495e-02f, -3.157750086e-02f, -3.154586581e-02f, -3.151417987e-02f, -3.148244310e-02f, -3.145065554e-02f, -3.141881728e-02f, -3.138692836e-02f, -3.135498885e-02f, -3.132299880e-02f,
-3.129095829e-02f, -3.125886736e-02f, -3.122672609e-02f, -3.119453452e-02f, -3.116229273e-02f, -3.113000078e-02f, -3.109765872e-02f, -3.106526661e-02f, -3.103282453e-02f, -3.100033253e-02f,
-3.096779066e-02f, -3.093519900e-02f, -3.090255761e-02f, -3.086986654e-02f, -3.083712586e-02f, -3.080433564e-02f, -3.077149592e-02f, -3.073860678e-02f, -3.070566828e-02f, -3.067268048e-02f,
-3.063964344e-02f, -3.060655723e-02f, -3.057342191e-02f, -3.054023753e-02f, -3.050700417e-02f, -3.047372188e-02f, -3.044039073e-02f, -3.040701079e-02f, -3.037358211e-02f, -3.034010475e-02f,
-3.030657879e-02f, -3.027300428e-02f, -3.023938129e-02f, -3.020570988e-02f, -3.017199012e-02f, -3.013822206e-02f, -3.010440577e-02f, -3.007054132e-02f, -3.003662877e-02f, -3.000266819e-02f,
-2.996865963e-02f, -2.993460316e-02f, -2.990049884e-02f, -2.986634675e-02f, -2.983214694e-02f, -2.979789948e-02f, -2.976360443e-02f, -2.972926185e-02f, -2.969487182e-02f, -2.966043440e-02f,
-2.962594964e-02f, -2.959141762e-02f, -2.955683840e-02f, -2.952221205e-02f, -2.948753863e-02f, -2.945281820e-02f, -2.941805083e-02f, -2.938323659e-02f, -2.934837554e-02f, -2.931346775e-02f,
-2.927851328e-02f, -2.924351219e-02f, -2.920846456e-02f, -2.917337045e-02f, -2.913822992e-02f, -2.910304304e-02f, -2.906780988e-02f, -2.903253050e-02f, -2.899720496e-02f, -2.896183335e-02f,
-2.892641571e-02f, -2.889095211e-02f, -2.885544264e-02f, -2.881988733e-02f, -2.878428628e-02f, -2.874863954e-02f, -2.871294717e-02f, -2.867720925e-02f, -2.864142585e-02f, -2.860559702e-02f,
-2.856972284e-02f, -2.853380337e-02f, -2.849783868e-02f, -2.846182883e-02f, -2.842577390e-02f, -2.838967395e-02f, -2.835352905e-02f, -2.831733927e-02f, -2.828110467e-02f, -2.824482532e-02f,
-2.820850128e-02f, -2.817213263e-02f, -2.813571944e-02f, -2.809926177e-02f, -2.806275968e-02f, -2.802621326e-02f, -2.798962256e-02f, -2.795298765e-02f, -2.791630860e-02f, -2.787958548e-02f,
-2.784281836e-02f, -2.780600731e-02f, -2.776915239e-02f, -2.773225367e-02f, -2.769531122e-02f, -2.765832512e-02f, -2.762129542e-02f, -2.758422220e-02f, -2.754710552e-02f, -2.750994546e-02f,
-2.747274208e-02f, -2.743549546e-02f, -2.739820566e-02f, -2.736087275e-02f, -2.732349679e-02f, -2.728607787e-02f, -2.724861605e-02f, -2.721111139e-02f, -2.717356398e-02f, -2.713597387e-02f,
-2.709834113e-02f, -2.706066584e-02f, -2.702294807e-02f, -2.698518788e-02f, -2.694738535e-02f, -2.690954055e-02f, -2.687165354e-02f, -2.683372439e-02f, -2.679575319e-02f, -2.675773998e-02f,
-2.671968485e-02f, -2.668158787e-02f, -2.664344911e-02f, -2.660526863e-02f, -2.656704651e-02f, -2.652878282e-02f, -2.649047763e-02f, -2.645213100e-02f, -2.641374302e-02f, -2.637531375e-02f,
-2.633684325e-02f, -2.629833162e-02f, -2.625977890e-02f, -2.622118518e-02f, -2.618255053e-02f, -2.614387501e-02f, -2.610515870e-02f, -2.606640167e-02f, -2.602760399e-02f, -2.598876573e-02f,
-2.594988697e-02f, -2.591096777e-02f, -2.587200821e-02f, -2.583300836e-02f, -2.579396829e-02f, -2.575488807e-02f, -2.571576777e-02f, -2.567660747e-02f, -2.563740724e-02f, -2.559816715e-02f,
-2.555888727e-02f, -2.551956767e-02f, -2.548020843e-02f, -2.544080962e-02f, -2.540137131e-02f, -2.536189357e-02f, -2.532237648e-02f, -2.528282011e-02f, -2.524322453e-02f, -2.520358981e-02f,
-2.516391603e-02f, -2.512420325e-02f, -2.508445156e-02f, -2.504466102e-02f, -2.500483172e-02f, -2.496496371e-02f, -2.492505707e-02f, -2.488511188e-02f, -2.484512821e-02f, -2.480510614e-02f,
-2.476504573e-02f, -2.472494706e-02f, -2.468481020e-02f, -2.464463523e-02f, -2.460442222e-02f, -2.456417124e-02f, -2.452388237e-02f, -2.448355568e-02f, -2.444319125e-02f, -2.440278914e-02f,
-2.436234944e-02f, -2.432187221e-02f, -2.428135753e-02f, -2.424080548e-02f, -2.420021612e-02f, -2.415958954e-02f, -2.411892580e-02f, -2.407822498e-02f, -2.403748716e-02f, -2.399671241e-02f,
-2.395590080e-02f, -2.391505241e-02f, -2.387416731e-02f, -2.383324558e-02f, -2.379228729e-02f, -2.375129252e-02f, -2.371026133e-02f, -2.366919382e-02f, -2.362809004e-02f, -2.358695008e-02f,
-2.354577401e-02f, -2.350456191e-02f, -2.346331385e-02f, -2.342202990e-02f, -2.338071014e-02f, -2.333935465e-02f, -2.329796351e-02f, -2.325653677e-02f, -2.321507453e-02f, -2.317357686e-02f,
-2.313204383e-02f, -2.309047552e-02f, -2.304887200e-02f, -2.300723336e-02f, -2.296555965e-02f, -2.292385097e-02f, -2.288210739e-02f, -2.284032898e-02f, -2.279851581e-02f, -2.275666798e-02f,
-2.271478554e-02f, -2.267286858e-02f, -2.263091717e-02f, -2.258893139e-02f, -2.254691131e-02f, -2.250485702e-02f, -2.246276858e-02f, -2.242064608e-02f, -2.237848959e-02f, -2.233629918e-02f,
-2.229407494e-02f, -2.225181693e-02f, -2.220952525e-02f, -2.216719995e-02f, -2.212484113e-02f, -2.208244885e-02f, -2.204002319e-02f, -2.199756424e-02f, -2.195507206e-02f, -2.191254673e-02f,
-2.186998834e-02f, -2.182739695e-02f, -2.178477265e-02f, -2.174211551e-02f, -2.169942561e-02f, -2.165670303e-02f, -2.161394784e-02f, -2.157116012e-02f, -2.152833995e-02f, -2.148548740e-02f,
-2.144260256e-02f, -2.139968549e-02f, -2.135673629e-02f, -2.131375502e-02f, -2.127074177e-02f, -2.122769660e-02f, -2.118461961e-02f, -2.114151086e-02f, -2.109837043e-02f, -2.105519841e-02f,
-2.101199487e-02f, -2.096875989e-02f, -2.092549354e-02f, -2.088219590e-02f, -2.083886706e-02f, -2.079550709e-02f, -2.075211607e-02f, -2.070869407e-02f, -2.066524118e-02f, -2.062175748e-02f,
-2.057824303e-02f, -2.053469793e-02f, -2.049112224e-02f, -2.044751605e-02f, -2.040387944e-02f, -2.036021248e-02f, -2.031651525e-02f, -2.027278784e-02f, -2.022903031e-02f, -2.018524276e-02f,
-2.014142525e-02f, -2.009757787e-02f, -2.005370069e-02f, -2.000979380e-02f, -1.996585727e-02f, -1.992189119e-02f, -1.987789562e-02f, -1.983387066e-02f, -1.978981637e-02f, -1.974573285e-02f,
-1.970162016e-02f, -1.965747839e-02f, -1.961330762e-02f, -1.956910792e-02f, -1.952487938e-02f, -1.948062207e-02f, -1.943633608e-02f, -1.939202148e-02f, -1.934767835e-02f, -1.930330678e-02f,
-1.925890684e-02f, -1.921447861e-02f, -1.917002218e-02f, -1.912553761e-02f, -1.908102500e-02f, -1.903648441e-02f, -1.899191594e-02f, -1.894731966e-02f, -1.890269565e-02f, -1.885804399e-02f,
-1.881336476e-02f, -1.876865804e-02f, -1.872392392e-02f, -1.867916246e-02f, -1.863437376e-02f, -1.858955788e-02f, -1.854471492e-02f, -1.849984495e-02f, -1.845494806e-02f, -1.841002431e-02f,
-1.836507380e-02f, -1.832009660e-02f, -1.827509280e-02f, -1.823006247e-02f, -1.818500569e-02f, -1.813992255e-02f, -1.809481313e-02f, -1.804967750e-02f, -1.800451575e-02f, -1.795932796e-02f,
-1.791411421e-02f, -1.786887458e-02f, -1.782360915e-02f, -1.777831800e-02f, -1.773300121e-02f, -1.768765886e-02f, -1.764229104e-02f, -1.759689783e-02f, -1.755147930e-02f, -1.750603553e-02f,
-1.746056662e-02f, -1.741507264e-02f, -1.736955366e-02f, -1.732400978e-02f, -1.727844107e-02f, -1.723284762e-02f, -1.718722950e-02f, -1.714158680e-02f, -1.709591959e-02f, -1.705022797e-02f,
-1.700451201e-02f, -1.695877179e-02f, -1.691300739e-02f, -1.686721890e-02f, -1.682140640e-02f, -1.677556997e-02f, -1.672970968e-02f, -1.668382563e-02f, -1.663791790e-02f, -1.659198656e-02f,
-1.654603169e-02f, -1.650005339e-02f, -1.645405172e-02f, -1.640802678e-02f, -1.636197865e-02f, -1.631590740e-02f, -1.626981312e-02f, -1.622369589e-02f, -1.617755579e-02f, -1.613139290e-02f,
-1.608520732e-02f, -1.603899911e-02f, -1.599276836e-02f, -1.594651516e-02f, -1.590023958e-02f, -1.585394171e-02f, -1.580762163e-02f, -1.576127942e-02f, -1.571491516e-02f, -1.566852894e-02f,
-1.562212084e-02f, -1.557569094e-02f, -1.552923932e-02f, -1.548276607e-02f, -1.543627127e-02f, -1.538975500e-02f, -1.534321735e-02f, -1.529665839e-02f, -1.525007821e-02f, -1.520347689e-02f,
-1.515685451e-02f, -1.511021116e-02f, -1.506354692e-02f, -1.501686187e-02f, -1.497015610e-02f, -1.492342968e-02f, -1.487668271e-02f, -1.482991525e-02f, -1.478312741e-02f, -1.473631925e-02f,
-1.468949086e-02f, -1.464264233e-02f, -1.459577374e-02f, -1.454888516e-02f, -1.450197670e-02f, -1.445504841e-02f, -1.440810040e-02f, -1.436113274e-02f, -1.431414551e-02f, -1.426713881e-02f,
-1.422011270e-02f, -1.417306728e-02f, -1.412600263e-02f, -1.407891883e-02f, -1.403181597e-02f, -1.398469413e-02f, -1.393755338e-02f, -1.389039382e-02f, -1.384321553e-02f, -1.379601859e-02f,
-1.374880308e-02f, -1.370156910e-02f, -1.365431671e-02f, -1.360704601e-02f, -1.355975708e-02f, -1.351245000e-02f, -1.346512485e-02f, -1.341778173e-02f, -1.337042071e-02f, -1.332304187e-02f,
-1.327564530e-02f, -1.322823109e-02f, -1.318079931e-02f, -1.313335006e-02f, -1.308588341e-02f, -1.303839944e-02f, -1.299089825e-02f, -1.294337992e-02f, -1.289584452e-02f, -1.284829214e-02f,
-1.280072288e-02f, -1.275313680e-02f, -1.270553400e-02f, -1.265791456e-02f, -1.261027856e-02f, -1.256262608e-02f, -1.251495722e-02f, -1.246727205e-02f, -1.241957065e-02f, -1.237185312e-02f,
-1.232411954e-02f, -1.227636999e-02f, -1.222860454e-02f, -1.218082330e-02f, -1.213302634e-02f, -1.208521375e-02f, -1.203738560e-02f, -1.198954199e-02f, -1.194168300e-02f, -1.189380871e-02f,
-1.184591921e-02f, -1.179801458e-02f, -1.175009491e-02f, -1.170216027e-02f, -1.165421076e-02f, -1.160624645e-02f, -1.155826744e-02f, -1.151027381e-02f, -1.146226563e-02f, -1.141424300e-02f,
-1.136620600e-02f, -1.131815472e-02f, -1.127008923e-02f, -1.122200962e-02f, -1.117391598e-02f, -1.112580839e-02f, -1.107768694e-02f, -1.102955171e-02f, -1.098140278e-02f, -1.093324024e-02f,
-1.088506418e-02f, -1.083687467e-02f, -1.078867181e-02f, -1.074045567e-02f, -1.069222635e-02f, -1.064398392e-02f, -1.059572847e-02f, -1.054746008e-02f, -1.049917885e-02f, -1.045088485e-02f,
-1.040257817e-02f, -1.035425889e-02f, -1.030592711e-02f, -1.025758289e-02f, -1.020922633e-02f, -1.016085752e-02f, -1.011247653e-02f, -1.006408345e-02f, -1.001567837e-02f, -9.967261369e-03f,
-9.918832535e-03f, -9.870391951e-03f, -9.821939702e-03f, -9.773475874e-03f, -9.725000550e-03f, -9.676513816e-03f, -9.628015755e-03f, -9.579506455e-03f, -9.530985998e-03f, -9.482454469e-03f,
-9.433911955e-03f, -9.385358538e-03f, -9.336794305e-03f, -9.288219340e-03f, -9.239633728e-03f, -9.191037554e-03f, -9.142430902e-03f, -9.093813858e-03f, -9.045186507e-03f, -8.996548933e-03f,
-8.947901221e-03f, -8.899243457e-03f, -8.850575725e-03f, -8.801898110e-03f, -8.753210696e-03f, -8.704513570e-03f, -8.655806816e-03f, -8.607090519e-03f, -8.558364764e-03f, -8.509629636e-03f,
-8.460885219e-03f, -8.412131600e-03f, -8.363368862e-03f, -8.314597091e-03f, -8.265816372e-03f, -8.217026790e-03f, -8.168228430e-03f, -8.119421377e-03f, -8.070605716e-03f, -8.021781532e-03f,
-7.972948910e-03f, -7.924107935e-03f, -7.875258693e-03f, -7.826401268e-03f, -7.777535745e-03f, -7.728662209e-03f, -7.679780746e-03f, -7.630891441e-03f, -7.581994378e-03f, -7.533089643e-03f,
-7.484177321e-03f, -7.435257497e-03f, -7.386330255e-03f, -7.337395682e-03f, -7.288453862e-03f, -7.239504881e-03f, -7.190548823e-03f, -7.141585773e-03f, -7.092615817e-03f, -7.043639040e-03f,
-6.994655527e-03f, -6.945665363e-03f, -6.896668633e-03f, -6.847665422e-03f, -6.798655816e-03f, -6.749639899e-03f, -6.700617757e-03f, -6.651589475e-03f, -6.602555138e-03f, -6.553514831e-03f,
-6.504468639e-03f, -6.455416647e-03f, -6.406358941e-03f, -6.357295605e-03f, -6.308226726e-03f, -6.259152387e-03f, -6.210072674e-03f, -6.160987673e-03f, -6.111897467e-03f, -6.062802144e-03f,
-6.013701786e-03f, -5.964596481e-03f, -5.915486312e-03f, -5.866371366e-03f, -5.817251726e-03f, -5.768127479e-03f, -5.718998709e-03f, -5.669865502e-03f, -5.620727942e-03f, -5.571586115e-03f,
-5.522440106e-03f, -5.473290000e-03f, -5.424135882e-03f, -5.374977837e-03f, -5.325815951e-03f, -5.276650308e-03f, -5.227480994e-03f, -5.178308093e-03f, -5.129131691e-03f, -5.079951873e-03f,
-5.030768724e-03f, -4.981582329e-03f, -4.932392774e-03f, -4.883200142e-03f, -4.834004520e-03f, -4.784805992e-03f, -4.735604643e-03f, -4.686400559e-03f, -4.637193825e-03f, -4.587984525e-03f,
-4.538772745e-03f, -4.489558569e-03f, -4.440342083e-03f, -4.391123372e-03f, -4.341902521e-03f, -4.292679615e-03f, -4.243454739e-03f, -4.194227977e-03f, -4.144999415e-03f, -4.095769139e-03f,
-4.046537232e-03f, -3.997303779e-03f, -3.948068867e-03f, -3.898832580e-03f, -3.849595002e-03f, -3.800356219e-03f, -3.751116315e-03f, -3.701875377e-03f, -3.652633487e-03f, -3.603390733e-03f,
-3.554147197e-03f, -3.504902966e-03f, -3.455658125e-03f, -3.406412757e-03f, -3.357166948e-03f, -3.307920783e-03f, -3.258674347e-03f, -3.209427725e-03f, -3.160181001e-03f, -3.110934260e-03f,
-3.061687587e-03f, -3.012441068e-03f, -2.963194786e-03f, -2.913948826e-03f, -2.864703274e-03f, -2.815458215e-03f, -2.766213732e-03f, -2.716969911e-03f, -2.667726836e-03f, -2.618484592e-03f,
-2.569243265e-03f, -2.520002938e-03f, -2.470763696e-03f, -2.421525624e-03f, -2.372288807e-03f, -2.323053330e-03f, -2.273819277e-03f, -2.224586732e-03f, -2.175355781e-03f, -2.126126507e-03f,
-2.076898997e-03f, -2.027673333e-03f, -1.978449602e-03f, -1.929227886e-03f, -1.880008272e-03f, -1.830790843e-03f, -1.781575684e-03f, -1.732362880e-03f, -1.683152515e-03f, -1.633944674e-03f,
-1.584739440e-03f, -1.535536899e-03f, -1.486337135e-03f, -1.437140233e-03f, -1.387946276e-03f, -1.338755350e-03f, -1.289567539e-03f, -1.240382926e-03f, -1.191201597e-03f, -1.142023636e-03f,
-1.092849127e-03f, -1.043678155e-03f, -9.945108030e-04f, -9.453471563e-04f, -8.961872991e-04f, -8.470313155e-04f, -7.978792898e-04f, -7.487313063e-04f, -6.995874491e-04f, -6.504478024e-04f,
-6.013124504e-04f, -5.521814774e-04f, -5.030549673e-04f, -4.539330045e-04f, -4.048156730e-04f, -3.557030568e-04f, -3.065952401e-04f, -2.574923070e-04f, -2.083943415e-04f, -1.593014275e-04f,
-1.102136492e-04f, -6.113109056e-05f, -1.205383548e-05f, 3.701803204e-05f, 8.608442808e-05f, 1.351452687e-04f, 1.842004700e-04f, 2.332499481e-04f, 2.822936192e-04f, 3.313313994e-04f,
3.803632048e-04f, 4.293889517e-04f, 4.784085563e-04f, 5.274219348e-04f, 5.764290035e-04f, 6.254296786e-04f, 6.744238765e-04f, 7.234115134e-04f, 7.723925057e-04f, 8.213667698e-04f,
8.703342220e-04f, 9.192947787e-04f, 9.682483564e-04f, 1.017194871e-03f, 1.066134240e-03f, 1.115066380e-03f, 1.163991206e-03f, 1.212908635e-03f, 1.261818584e-03f, 1.310720970e-03f,
1.359615709e-03f, 1.408502717e-03f, 1.457381912e-03f, 1.506253210e-03f, 1.555116527e-03f, 1.603971781e-03f, 1.652818888e-03f, 1.701657765e-03f, 1.750488328e-03f, 1.799310495e-03f,
1.848124182e-03f, 1.896929306e-03f, 1.945725784e-03f, 1.994513533e-03f, 2.043292469e-03f, 2.092062511e-03f, 2.140823573e-03f, 2.189575575e-03f, 2.238318432e-03f, 2.287052062e-03f,
2.335776382e-03f, 2.384491308e-03f, 2.433196759e-03f, 2.481892651e-03f, 2.530578901e-03f, 2.579255426e-03f, 2.627922144e-03f, 2.676578972e-03f, 2.725225827e-03f, 2.773862627e-03f,
2.822489288e-03f, 2.871105729e-03f, 2.919711866e-03f, 2.968307617e-03f, 3.016892900e-03f, 3.065467631e-03f, 3.114031728e-03f, 3.162585110e-03f, 3.211127692e-03f, 3.259659394e-03f,
3.308180132e-03f, 3.356689824e-03f, 3.405188388e-03f, 3.453675742e-03f, 3.502151802e-03f, 3.550616488e-03f, 3.599069716e-03f, 3.647511404e-03f, 3.695941471e-03f, 3.744359834e-03f,
3.792766411e-03f, 3.841161119e-03f, 3.889543878e-03f, 3.937914604e-03f, 3.986273216e-03f, 4.034619632e-03f, 4.082953770e-03f, 4.131275548e-03f, 4.179584883e-03f, 4.227881695e-03f,
4.276165902e-03f, 4.324437421e-03f, 4.372696170e-03f, 4.420942069e-03f, 4.469175035e-03f, 4.517394987e-03f, 4.565601843e-03f, 4.613795522e-03f, 4.661975941e-03f, 4.710143019e-03f,
4.758296676e-03f, 4.806436829e-03f, 4.854563397e-03f, 4.902676298e-03f, 4.950775451e-03f, 4.998860775e-03f, 5.046932189e-03f, 5.094989610e-03f, 5.143032959e-03f, 5.191062153e-03f,
5.239077112e-03f, 5.287077754e-03f, 5.335063998e-03f, 5.383035764e-03f, 5.430992969e-03f, 5.478935534e-03f, 5.526863376e-03f, 5.574776416e-03f, 5.622674572e-03f, 5.670557763e-03f,
5.718425909e-03f, 5.766278928e-03f, 5.814116741e-03f, 5.861939265e-03f, 5.909746421e-03f, 5.957538128e-03f, 6.005314304e-03f, 6.053074871e-03f, 6.100819746e-03f, 6.148548850e-03f,
6.196262101e-03f, 6.243959420e-03f, 6.291640727e-03f, 6.339305939e-03f, 6.386954979e-03f, 6.434587764e-03f, 6.482204215e-03f, 6.529804251e-03f, 6.577387793e-03f, 6.624954759e-03f,
6.672505071e-03f, 6.720038648e-03f, 6.767555409e-03f, 6.815055275e-03f, 6.862538167e-03f, 6.910004003e-03f, 6.957452704e-03f, 7.004884190e-03f, 7.052298382e-03f, 7.099695199e-03f,
7.147074562e-03f, 7.194436391e-03f, 7.241780606e-03f, 7.289107128e-03f, 7.336415877e-03f, 7.383706774e-03f, 7.430979739e-03f, 7.478234693e-03f, 7.525471556e-03f, 7.572690249e-03f,
7.619890692e-03f, 7.667072806e-03f, 7.714236512e-03f, 7.761381731e-03f, 7.808508383e-03f, 7.855616390e-03f, 7.902705671e-03f, 7.949776149e-03f, 7.996827743e-03f, 8.043860376e-03f,
8.090873968e-03f, 8.137868440e-03f, 8.184843714e-03f, 8.231799709e-03f, 8.278736349e-03f, 8.325653554e-03f, 8.372551245e-03f, 8.419429343e-03f, 8.466287771e-03f, 8.513126449e-03f,
8.559945298e-03f, 8.606744242e-03f, 8.653523200e-03f, 8.700282095e-03f, 8.747020848e-03f, 8.793739381e-03f, 8.840437615e-03f, 8.887115473e-03f, 8.933772876e-03f, 8.980409746e-03f,
9.027026005e-03f, 9.073621575e-03f, 9.120196378e-03f, 9.166750336e-03f, 9.213283371e-03f, 9.259795404e-03f, 9.306286360e-03f, 9.352756158e-03f, 9.399204723e-03f, 9.445631975e-03f,
9.492037838e-03f, 9.538422234e-03f, 9.584785085e-03f, 9.631126313e-03f, 9.677445842e-03f, 9.723743594e-03f, 9.770019491e-03f, 9.816273456e-03f, 9.862505412e-03f, 9.908715281e-03f,
9.954902987e-03f, 1.000106845e-02f, 1.004721160e-02f, 1.009333235e-02f, 1.013943063e-02f, 1.018550636e-02f, 1.023155947e-02f, 1.027758987e-02f, 1.032359750e-02f, 1.036958226e-02f,
1.041554410e-02f, 1.046148292e-02f, 1.050739866e-02f, 1.055329123e-02f, 1.059916057e-02f, 1.064500659e-02f, 1.069082922e-02f, 1.073662837e-02f, 1.078240399e-02f, 1.082815598e-02f,
1.087388427e-02f, 1.091958879e-02f, 1.096526946e-02f, 1.101092621e-02f, 1.105655895e-02f, 1.110216762e-02f, 1.114775213e-02f, 1.119331241e-02f, 1.123884838e-02f, 1.128435997e-02f,
1.132984711e-02f, 1.137530971e-02f, 1.142074770e-02f, 1.146616101e-02f, 1.151154956e-02f, 1.155691328e-02f, 1.160225208e-02f, 1.164756590e-02f, 1.169285465e-02f, 1.173811827e-02f,
1.178335668e-02f, 1.182856980e-02f, 1.187375756e-02f, 1.191891988e-02f, 1.196405668e-02f, 1.200916790e-02f, 1.205425346e-02f, 1.209931328e-02f, 1.214434729e-02f, 1.218935541e-02f,
1.223433757e-02f, 1.227929369e-02f, 1.232422370e-02f, 1.236912753e-02f, 1.241400510e-02f, 1.245885633e-02f, 1.250368115e-02f, 1.254847949e-02f, 1.259325128e-02f, 1.263799643e-02f,
1.268271487e-02f, 1.272740654e-02f, 1.277207135e-02f, 1.281670923e-02f, 1.286132012e-02f, 1.290590392e-02f, 1.295046058e-02f, 1.299499001e-02f, 1.303949214e-02f, 1.308396691e-02f,
1.312841422e-02f, 1.317283402e-02f, 1.321722623e-02f, 1.326159078e-02f, 1.330592758e-02f, 1.335023657e-02f, 1.339451768e-02f, 1.343877083e-02f, 1.348299594e-02f, 1.352719295e-02f,
1.357136179e-02f, 1.361550237e-02f, 1.365961463e-02f, 1.370369849e-02f, 1.374775388e-02f, 1.379178073e-02f, 1.383577896e-02f, 1.387974850e-02f, 1.392368929e-02f, 1.396760124e-02f,
1.401148428e-02f, 1.405533835e-02f, 1.409916336e-02f, 1.414295925e-02f, 1.418672595e-02f, 1.423046338e-02f, 1.427417147e-02f, 1.431785015e-02f, 1.436149934e-02f, 1.440511898e-02f,
1.444870899e-02f, 1.449226930e-02f, 1.453579984e-02f, 1.457930053e-02f, 1.462277132e-02f, 1.466621211e-02f, 1.470962284e-02f, 1.475300345e-02f, 1.479635386e-02f, 1.483967399e-02f,
1.488296378e-02f, 1.492622315e-02f, 1.496945204e-02f, 1.501265036e-02f, 1.505581806e-02f, 1.509895506e-02f, 1.514206129e-02f, 1.518513668e-02f, 1.522818116e-02f, 1.527119465e-02f,
1.531417709e-02f, 1.535712840e-02f, 1.540004852e-02f, 1.544293737e-02f, 1.548579488e-02f, 1.552862099e-02f, 1.557141562e-02f, 1.561417871e-02f, 1.565691017e-02f, 1.569960995e-02f,
1.574227797e-02f, 1.578491416e-02f, 1.582751846e-02f, 1.587009078e-02f, 1.591263107e-02f, 1.595513925e-02f, 1.599761525e-02f, 1.604005900e-02f, 1.608247044e-02f, 1.612484949e-02f,
1.616719609e-02f, 1.620951016e-02f, 1.625179163e-02f, 1.629404044e-02f, 1.633625652e-02f, 1.637843980e-02f, 1.642059020e-02f, 1.646270766e-02f, 1.650479212e-02f, 1.654684349e-02f,
1.658886172e-02f, 1.663084673e-02f, 1.667279846e-02f, 1.671471683e-02f, 1.675660178e-02f, 1.679845324e-02f, 1.684027114e-02f, 1.688205541e-02f, 1.692380599e-02f, 1.696552280e-02f,
1.700720578e-02f, 1.704885486e-02f, 1.709046997e-02f, 1.713205105e-02f, 1.717359801e-02f, 1.721511081e-02f, 1.725658937e-02f, 1.729803362e-02f, 1.733944349e-02f, 1.738081892e-02f,
1.742215983e-02f, 1.746346617e-02f, 1.750473787e-02f, 1.754597485e-02f, 1.758717705e-02f, 1.762834440e-02f, 1.766947684e-02f, 1.771057429e-02f, 1.775163670e-02f, 1.779266399e-02f,
1.783365609e-02f, 1.787461295e-02f, 1.791553449e-02f, 1.795642065e-02f, 1.799727136e-02f, 1.803808655e-02f, 1.807886616e-02f, 1.811961012e-02f, 1.816031837e-02f, 1.820099083e-02f,
1.824162744e-02f, 1.828222814e-02f, 1.832279287e-02f, 1.836332154e-02f, 1.840381410e-02f, 1.844427049e-02f, 1.848469063e-02f, 1.852507446e-02f, 1.856542192e-02f, 1.860573294e-02f,
1.864600745e-02f, 1.868624538e-02f, 1.872644669e-02f, 1.876661128e-02f, 1.880673912e-02f, 1.884683012e-02f, 1.888688422e-02f, 1.892690136e-02f, 1.896688147e-02f, 1.900682449e-02f,
1.904673035e-02f, 1.908659899e-02f, 1.912643034e-02f, 1.916622434e-02f, 1.920598093e-02f, 1.924570003e-02f, 1.928538159e-02f, 1.932502554e-02f, 1.936463182e-02f, 1.940420036e-02f,
1.944373110e-02f, 1.948322397e-02f, 1.952267892e-02f, 1.956209587e-02f, 1.960147476e-02f, 1.964081553e-02f, 1.968011812e-02f, 1.971938246e-02f, 1.975860849e-02f, 1.979779614e-02f,
1.983694535e-02f, 1.987605607e-02f, 1.991512822e-02f, 1.995416173e-02f, 1.999315656e-02f, 2.003211264e-02f, 2.007102989e-02f, 2.010990827e-02f, 2.014874771e-02f, 2.018754813e-02f,
2.022630949e-02f, 2.026503172e-02f, 2.030371476e-02f, 2.034235854e-02f, 2.038096300e-02f, 2.041952809e-02f, 2.045805373e-02f, 2.049653986e-02f, 2.053498643e-02f, 2.057339337e-02f,
2.061176062e-02f, 2.065008812e-02f, 2.068837580e-02f, 2.072662361e-02f, 2.076483148e-02f, 2.080299935e-02f, 2.084112717e-02f, 2.087921486e-02f, 2.091726236e-02f, 2.095526963e-02f,
2.099323658e-02f, 2.103116318e-02f, 2.106904934e-02f, 2.110689502e-02f, 2.114470014e-02f, 2.118246466e-02f, 2.122018851e-02f, 2.125787162e-02f, 2.129551394e-02f, 2.133311542e-02f,
2.137067598e-02f, 2.140819556e-02f, 2.144567411e-02f, 2.148311157e-02f, 2.152050788e-02f, 2.155786298e-02f, 2.159517680e-02f, 2.163244928e-02f, 2.166968038e-02f, 2.170687002e-02f,
2.174401815e-02f, 2.178112471e-02f, 2.181818964e-02f, 2.185521287e-02f, 2.189219436e-02f, 2.192913404e-02f, 2.196603185e-02f, 2.200288773e-02f, 2.203970163e-02f, 2.207647348e-02f,
2.211320323e-02f, 2.214989082e-02f, 2.218653618e-02f, 2.222313927e-02f, 2.225970001e-02f, 2.229621836e-02f, 2.233269426e-02f, 2.236912764e-02f, 2.240551845e-02f, 2.244186663e-02f,
2.247817212e-02f, 2.251443487e-02f, 2.255065481e-02f, 2.258683189e-02f, 2.262296605e-02f, 2.265905724e-02f, 2.269510539e-02f, 2.273111045e-02f, 2.276707236e-02f, 2.280299107e-02f,
2.283886651e-02f, 2.287469863e-02f, 2.291048737e-02f, 2.294623267e-02f, 2.298193449e-02f, 2.301759275e-02f, 2.305320742e-02f, 2.308877841e-02f, 2.312430569e-02f, 2.315978920e-02f,
2.319522887e-02f, 2.323062466e-02f, 2.326597650e-02f, 2.330128434e-02f, 2.333654812e-02f, 2.337176779e-02f, 2.340694330e-02f, 2.344207458e-02f, 2.347716157e-02f, 2.351220424e-02f,
2.354720251e-02f, 2.358215633e-02f, 2.361706566e-02f, 2.365193042e-02f, 2.368675057e-02f, 2.372152606e-02f, 2.375625682e-02f, 2.379094280e-02f, 2.382558395e-02f, 2.386018021e-02f,
2.389473152e-02f, 2.392923784e-02f, 2.396369911e-02f, 2.399811527e-02f, 2.403248627e-02f, 2.406681205e-02f, 2.410109257e-02f, 2.413532776e-02f, 2.416951757e-02f, 2.420366195e-02f,
2.423776084e-02f, 2.427181419e-02f, 2.430582195e-02f, 2.433978406e-02f, 2.437370047e-02f, 2.440757113e-02f, 2.444139598e-02f, 2.447517496e-02f, 2.450890804e-02f, 2.454259514e-02f,
2.457623622e-02f, 2.460983123e-02f, 2.464338011e-02f, 2.467688281e-02f, 2.471033928e-02f, 2.474374946e-02f, 2.477711331e-02f, 2.481043077e-02f, 2.484370178e-02f, 2.487692630e-02f,
2.491010427e-02f, 2.494323564e-02f, 2.497632035e-02f, 2.500935837e-02f, 2.504234963e-02f, 2.507529408e-02f, 2.510819167e-02f, 2.514104236e-02f, 2.517384607e-02f, 2.520660278e-02f,
2.523931242e-02f, 2.527197495e-02f, 2.530459030e-02f, 2.533715844e-02f, 2.536967931e-02f, 2.540215285e-02f, 2.543457903e-02f, 2.546695778e-02f, 2.549928906e-02f, 2.553157281e-02f,
2.556380899e-02f, 2.559599755e-02f, 2.562813843e-02f, 2.566023158e-02f, 2.569227696e-02f, 2.572427452e-02f, 2.575622419e-02f, 2.578812594e-02f, 2.581997972e-02f, 2.585178547e-02f,
2.588354315e-02f, 2.591525270e-02f, 2.594691408e-02f, 2.597852723e-02f, 2.601009211e-02f, 2.604160867e-02f, 2.607307686e-02f, 2.610449663e-02f, 2.613586793e-02f, 2.616719071e-02f,
2.619846493e-02f, 2.622969053e-02f, 2.626086747e-02f, 2.629199569e-02f, 2.632307515e-02f, 2.635410581e-02f, 2.638508760e-02f, 2.641602049e-02f, 2.644690443e-02f, 2.647773937e-02f,
2.650852526e-02f, 2.653926204e-02f, 2.656994969e-02f, 2.660058814e-02f, 2.663117735e-02f, 2.666171728e-02f, 2.669220787e-02f, 2.672264908e-02f, 2.675304085e-02f, 2.678338316e-02f,
2.681367593e-02f, 2.684391914e-02f, 2.687411274e-02f, 2.690425666e-02f, 2.693435088e-02f, 2.696439534e-02f, 2.699439000e-02f, 2.702433481e-02f, 2.705422972e-02f, 2.708407469e-02f,
2.711386967e-02f, 2.714361462e-02f, 2.717330949e-02f, 2.720295423e-02f, 2.723254880e-02f, 2.726209315e-02f, 2.729158724e-02f, 2.732103102e-02f, 2.735042445e-02f, 2.737976748e-02f,
2.740906007e-02f, 2.743830216e-02f, 2.746749372e-02f, 2.749663471e-02f, 2.752572507e-02f, 2.755476476e-02f, 2.758375374e-02f, 2.761269196e-02f, 2.764157938e-02f, 2.767041595e-02f,
2.769920163e-02f, 2.772793638e-02f, 2.775662015e-02f, 2.778525289e-02f, 2.781383457e-02f, 2.784236514e-02f, 2.787084456e-02f, 2.789927277e-02f, 2.792764975e-02f, 2.795597544e-02f,
2.798424980e-02f, 2.801247279e-02f, 2.804064437e-02f, 2.806876449e-02f, 2.809683311e-02f, 2.812485018e-02f, 2.815281567e-02f, 2.818072953e-02f, 2.820859172e-02f, 2.823640220e-02f,
2.826416092e-02f, 2.829186784e-02f, 2.831952292e-02f, 2.834712612e-02f, 2.837467739e-02f, 2.840217670e-02f, 2.842962400e-02f, 2.845701924e-02f, 2.848436240e-02f, 2.851165342e-02f,
2.853889227e-02f, 2.856607890e-02f, 2.859321327e-02f, 2.862029535e-02f, 2.864732508e-02f, 2.867430243e-02f, 2.870122737e-02f, 2.872809984e-02f, 2.875491980e-02f, 2.878168722e-02f,
2.880840206e-02f, 2.883506427e-02f, 2.886167382e-02f, 2.888823066e-02f, 2.891473476e-02f, 2.894118607e-02f, 2.896758456e-02f, 2.899393018e-02f, 2.902022290e-02f, 2.904646267e-02f,
2.907264945e-02f, 2.909878322e-02f, 2.912486392e-02f, 2.915089151e-02f, 2.917686597e-02f, 2.920278724e-02f, 2.922865530e-02f, 2.925447010e-02f, 2.928023159e-02f, 2.930593976e-02f,
2.933159455e-02f, 2.935719592e-02f, 2.938274384e-02f, 2.940823828e-02f, 2.943367918e-02f, 2.945906652e-02f, 2.948440026e-02f, 2.950968035e-02f, 2.953490676e-02f, 2.956007946e-02f,
2.958519839e-02f, 2.961026354e-02f, 2.963527486e-02f, 2.966023230e-02f, 2.968513585e-02f, 2.970998544e-02f, 2.973478107e-02f, 2.975952267e-02f, 2.978421022e-02f, 2.980884368e-02f,
2.983342301e-02f, 2.985794819e-02f, 2.988241916e-02f, 2.990683589e-02f, 2.993119835e-02f, 2.995550651e-02f, 2.997976031e-02f, 3.000395974e-02f, 3.002810475e-02f, 3.005219531e-02f,
3.007623138e-02f, 3.010021293e-02f, 3.012413992e-02f, 3.014801231e-02f, 3.017183007e-02f, 3.019559317e-02f, 3.021930156e-02f, 3.024295523e-02f, 3.026655412e-02f, 3.029009820e-02f,
3.031358745e-02f, 3.033702182e-02f, 3.036040128e-02f, 3.038372580e-02f, 3.040699534e-02f, 3.043020986e-02f, 3.045336935e-02f, 3.047647375e-02f, 3.049952303e-02f, 3.052251717e-02f,
3.054545613e-02f, 3.056833987e-02f, 3.059116836e-02f, 3.061394157e-02f, 3.063665946e-02f, 3.065932201e-02f, 3.068192917e-02f, 3.070448091e-02f, 3.072697721e-02f, 3.074941803e-02f,
3.077180333e-02f, 3.079413309e-02f, 3.081640726e-02f, 3.083862583e-02f, 3.086078875e-02f, 3.088289599e-02f, 3.090494753e-02f, 3.092694332e-02f, 3.094888334e-02f, 3.097076756e-02f,
3.099259594e-02f, 3.101436845e-02f, 3.103608507e-02f, 3.105774575e-02f, 3.107935047e-02f, 3.110089919e-02f, 3.112239189e-02f, 3.114382854e-02f, 3.116520910e-02f, 3.118653354e-02f,
3.120780183e-02f, 3.122901394e-02f, 3.125016984e-02f, 3.127126951e-02f, 3.129231290e-02f, 3.131329999e-02f, 3.133423075e-02f, 3.135510514e-02f, 3.137592315e-02f, 3.139668473e-02f,
3.141738987e-02f, 3.143803852e-02f, 3.145863066e-02f, 3.147916627e-02f, 3.149964530e-02f, 3.152006774e-02f, 3.154043355e-02f, 3.156074270e-02f, 3.158099516e-02f, 3.160119092e-02f,
3.162132992e-02f, 3.164141216e-02f, 3.166143760e-02f, 3.168140620e-02f, 3.170131795e-02f, 3.172117282e-02f, 3.174097077e-02f, 3.176071177e-02f, 3.178039581e-02f, 3.180002285e-02f,
3.181959287e-02f, 3.183910583e-02f, 3.185856171e-02f, 3.187796048e-02f, 3.189730212e-02f, 3.191658659e-02f, 3.193581387e-02f, 3.195498394e-02f, 3.197409676e-02f, 3.199315231e-02f,
3.201215057e-02f, 3.203109149e-02f, 3.204997507e-02f, 3.206880127e-02f, 3.208757007e-02f, 3.210628144e-02f, 3.212493535e-02f, 3.214353178e-02f, 3.216207070e-02f, 3.218055208e-02f,
3.219897591e-02f, 3.221734215e-02f, 3.223565078e-02f, 3.225390177e-02f, 3.227209510e-02f, 3.229023075e-02f, 3.230830868e-02f, 3.232632888e-02f, 3.234429131e-02f, 3.236219596e-02f,
3.238004279e-02f, 3.239783179e-02f, 3.241556293e-02f, 3.243323618e-02f, 3.245085152e-02f, 3.246840893e-02f, 3.248590838e-02f, 3.250334985e-02f, 3.252073331e-02f, 3.253805875e-02f,
3.255532613e-02f, 3.257253543e-02f, 3.258968663e-02f, 3.260677971e-02f, 3.262381464e-02f, 3.264079140e-02f, 3.265770997e-02f, 3.267457032e-02f, 3.269137244e-02f, 3.270811629e-02f,
3.272480185e-02f, 3.274142911e-02f, 3.275799804e-02f, 3.277450861e-02f, 3.279096081e-02f, 3.280735462e-02f, 3.282369000e-02f, 3.283996695e-02f, 3.285618543e-02f, 3.287234542e-02f,
3.288844692e-02f, 3.290448988e-02f, 3.292047430e-02f, 3.293640014e-02f, 3.295226739e-02f, 3.296807603e-02f, 3.298382604e-02f, 3.299951739e-02f, 3.301515007e-02f, 3.303072405e-02f,
3.304623931e-02f, 3.306169583e-02f, 3.307709360e-02f, 3.309243259e-02f, 3.310771278e-02f, 3.312293415e-02f, 3.313809668e-02f, 3.315320036e-02f, 3.316824515e-02f, 3.318323105e-02f,
3.319815803e-02f, 3.321302608e-02f, 3.322783517e-02f, 3.324258528e-02f, 3.325727639e-02f, 3.327190850e-02f, 3.328648157e-02f, 3.330099558e-02f, 3.331545053e-02f, 3.332984639e-02f,
3.334418314e-02f, 3.335846076e-02f, 3.337267924e-02f, 3.338683856e-02f, 3.340093869e-02f, 3.341497963e-02f, 3.342896134e-02f, 3.344288383e-02f, 3.345674706e-02f, 3.347055102e-02f,
3.348429569e-02f, 3.349798106e-02f, 3.351160711e-02f, 3.352517381e-02f, 3.353868116e-02f, 3.355212913e-02f, 3.356551772e-02f, 3.357884689e-02f, 3.359211664e-02f, 3.360532696e-02f,
3.361847781e-02f, 3.363156919e-02f, 3.364460108e-02f, 3.365757346e-02f, 3.367048632e-02f, 3.368333965e-02f, 3.369613341e-02f, 3.370886761e-02f, 3.372154223e-02f, 3.373415724e-02f,
3.374671263e-02f, 3.375920840e-02f, 3.377164451e-02f, 3.378402097e-02f, 3.379633775e-02f, 3.380859483e-02f, 3.382079221e-02f, 3.383292986e-02f, 3.384500778e-02f, 3.385702595e-02f,
3.386898436e-02f, 3.388088298e-02f, 3.389272181e-02f, 3.390450083e-02f, 3.391622003e-02f, 3.392787940e-02f, 3.393947891e-02f, 3.395101856e-02f, 3.396249834e-02f, 3.397391822e-02f,
3.398527820e-02f, 3.399657826e-02f, 3.400781840e-02f, 3.401899859e-02f, 3.403011882e-02f, 3.404117909e-02f, 3.405217937e-02f, 3.406311966e-02f, 3.407399994e-02f, 3.408482021e-02f,
3.409558044e-02f, 3.410628063e-02f, 3.411692076e-02f, 3.412750082e-02f, 3.413802081e-02f, 3.414848070e-02f, 3.415888049e-02f, 3.416922016e-02f, 3.417949971e-02f, 3.418971912e-02f,
3.419987838e-02f, 3.420997748e-02f, 3.422001641e-02f, 3.422999516e-02f, 3.423991372e-02f, 3.424977207e-02f, 3.425957020e-02f, 3.426930811e-02f, 3.427898579e-02f, 3.428860322e-02f,
3.429816039e-02f, 3.430765730e-02f, 3.431709393e-02f, 3.432647028e-02f, 3.433578633e-02f, 3.434504207e-02f, 3.435423750e-02f, 3.436337260e-02f, 3.437244737e-02f, 3.438146180e-02f,
3.439041587e-02f, 3.439930958e-02f, 3.440814292e-02f, 3.441691588e-02f, 3.442562846e-02f, 3.443428063e-02f, 3.444287241e-02f, 3.445140376e-02f, 3.445987470e-02f, 3.446828520e-02f,
3.447663527e-02f, 3.448492489e-02f, 3.449315405e-02f, 3.450132275e-02f, 3.450943098e-02f, 3.451747874e-02f, 3.452546600e-02f, 3.453339278e-02f, 3.454125906e-02f, 3.454906482e-02f,
3.455681008e-02f, 3.456449481e-02f, 3.457211902e-02f, 3.457968268e-02f, 3.458718581e-02f, 3.459462839e-02f, 3.460201042e-02f, 3.460933188e-02f, 3.461659278e-02f, 3.462379310e-02f,
3.463093285e-02f, 3.463801201e-02f, 3.464503057e-02f, 3.465198854e-02f, 3.465888591e-02f, 3.466572267e-02f, 3.467249882e-02f, 3.467921435e-02f, 3.468586925e-02f, 3.469246353e-02f,
3.469899717e-02f, 3.470547017e-02f, 3.471188253e-02f, 3.471823424e-02f, 3.472452529e-02f, 3.473075569e-02f, 3.473692543e-02f, 3.474303450e-02f, 3.474908290e-02f, 3.475507063e-02f,
3.476099768e-02f, 3.476686404e-02f, 3.477266972e-02f, 3.477841471e-02f, 3.478409901e-02f, 3.478972261e-02f, 3.479528551e-02f, 3.480078771e-02f, 3.480622920e-02f, 3.481160999e-02f,
3.481693006e-02f, 3.482218942e-02f, 3.482738805e-02f, 3.483252597e-02f, 3.483760317e-02f, 3.484261964e-02f, 3.484757539e-02f, 3.485247040e-02f, 3.485730468e-02f, 3.486207823e-02f,
3.486679105e-02f, 3.487144313e-02f, 3.487603447e-02f, 3.488056506e-02f, 3.488503492e-02f, 3.488944404e-02f, 3.489379241e-02f, 3.489808003e-02f, 3.490230691e-02f, 3.490647304e-02f,
3.491057842e-02f, 3.491462306e-02f, 3.491860694e-02f, 3.492253008e-02f, 3.492639247e-02f, 3.493019410e-02f, 3.493393498e-02f, 3.493761512e-02f, 3.494123450e-02f, 3.494479313e-02f,
3.494829101e-02f, 3.495172814e-02f, 3.495510452e-02f, 3.495842016e-02f, 3.496167504e-02f, 3.496486918e-02f, 3.496800257e-02f, 3.497107521e-02f, 3.497408711e-02f, 3.497703826e-02f,
3.497992868e-02f, 3.498275835e-02f, 3.498552728e-02f, 3.498823548e-02f, 3.499088294e-02f, 3.499346966e-02f, 3.499599565e-02f, 3.499846091e-02f, 3.500086545e-02f, 3.500320925e-02f,
3.500549234e-02f, 3.500771470e-02f, 3.500987634e-02f, 3.501197727e-02f, 3.501401748e-02f, 3.501599698e-02f, 3.501791578e-02f, 3.501977387e-02f, 3.502157126e-02f, 3.502330795e-02f,
3.502498394e-02f, 3.502659925e-02f, 3.502815386e-02f, 3.502964780e-02f, 3.503108105e-02f, 3.503245362e-02f, 3.503376553e-02f, 3.503501676e-02f, 3.503620733e-02f, 3.503733724e-02f,
3.503840649e-02f, 3.503941510e-02f, 3.504036306e-02f, 3.504125037e-02f, 3.504207705e-02f, 3.504284310e-02f, 3.504354851e-02f, 3.504419331e-02f, 3.504477749e-02f, 3.504530106e-02f,
3.504576403e-02f, 3.504616639e-02f, 3.504650816e-02f, 3.504678934e-02f, 3.504700993e-02f, 3.504716995e-02f, 3.504726940e-02f, 3.504730829e-02f, 3.504728661e-02f, 3.504720438e-02f,
3.504706161e-02f, 3.504685830e-02f, 3.504659445e-02f, 3.504627008e-02f, 3.504588519e-02f, 3.504543979e-02f, 3.504493389e-02f, 3.504436748e-02f, 3.504374059e-02f, 3.504305321e-02f,
3.504230536e-02f, 3.504149704e-02f, 3.504062826e-02f, 3.503969903e-02f, 3.503870935e-02f, 3.503765923e-02f, 3.503654869e-02f, 3.503537773e-02f, 3.503414636e-02f, 3.503285458e-02f,
3.503150241e-02f, 3.503008985e-02f, 3.502861692e-02f, 3.502708362e-02f, 3.502548995e-02f, 3.502383594e-02f, 3.502212159e-02f, 3.502034690e-02f, 3.501851189e-02f, 3.501661657e-02f,
3.501466094e-02f, 3.501264502e-02f, 3.501056882e-02f, 3.500843234e-02f, 3.500623560e-02f, 3.500397860e-02f, 3.500166136e-02f, 3.499928388e-02f, 3.499684618e-02f, 3.499434827e-02f,
3.499179016e-02f, 3.498917185e-02f, 3.498649336e-02f, 3.498375471e-02f, 3.498095589e-02f, 3.497809692e-02f, 3.497517782e-02f, 3.497219860e-02f, 3.496915926e-02f, 3.496605981e-02f,
3.496290028e-02f, 3.495968067e-02f, 3.495640099e-02f, 3.495306125e-02f, 3.494966147e-02f, 3.494620166e-02f, 3.494268183e-02f, 3.493910199e-02f, 3.493546216e-02f, 3.493176235e-02f,
3.492800257e-02f, 3.492418283e-02f, 3.492030315e-02f, 3.491636353e-02f, 3.491236400e-02f, 3.490830457e-02f, 3.490418524e-02f, 3.490000603e-02f, 3.489576697e-02f, 3.489146805e-02f,
3.488710929e-02f, 3.488269071e-02f, 3.487821232e-02f, 3.487367413e-02f, 3.486907616e-02f, 3.486441843e-02f, 3.485970094e-02f, 3.485492371e-02f, 3.485008676e-02f, 3.484519009e-02f,
3.484023374e-02f, 3.483521770e-02f, 3.483014199e-02f, 3.482500664e-02f, 3.481981165e-02f, 3.481455704e-02f, 3.480924282e-02f, 3.480386901e-02f, 3.479843563e-02f, 3.479294269e-02f,
3.478739021e-02f, 3.478177820e-02f, 3.477610668e-02f, 3.477037566e-02f, 3.476458517e-02f, 3.475873521e-02f, 3.475282580e-02f, 3.474685696e-02f, 3.474082871e-02f, 3.473474106e-02f,
3.472859403e-02f, 3.472238764e-02f, 3.471612189e-02f, 3.470979682e-02f, 3.470341244e-02f, 3.469696875e-02f, 3.469046579e-02f, 3.468390357e-02f, 3.467728211e-02f, 3.467060141e-02f,
3.466386151e-02f, 3.465706242e-02f, 3.465020416e-02f, 3.464328674e-02f, 3.463631018e-02f, 3.462927450e-02f, 3.462217973e-02f, 3.461502587e-02f, 3.460781295e-02f, 3.460054098e-02f,
3.459320998e-02f, 3.458581998e-02f, 3.457837099e-02f, 3.457086303e-02f, 3.456329612e-02f, 3.455567028e-02f, 3.454798552e-02f, 3.454024187e-02f, 3.453243935e-02f, 3.452457797e-02f,
3.451665776e-02f, 3.450867874e-02f, 3.450064092e-02f, 3.449254432e-02f, 3.448438898e-02f, 3.447617489e-02f, 3.446790209e-02f, 3.445957060e-02f, 3.445118044e-02f, 3.444273162e-02f,
3.443422417e-02f, 3.442565811e-02f, 3.441703346e-02f, 3.440835023e-02f, 3.439960846e-02f, 3.439080817e-02f, 3.438194936e-02f, 3.437303207e-02f, 3.436405632e-02f, 3.435502213e-02f,
3.434592951e-02f, 3.433677850e-02f, 3.432756911e-02f, 3.431830136e-02f, 3.430897529e-02f, 3.429959090e-02f, 3.429014822e-02f, 3.428064728e-02f, 3.427108809e-02f, 3.426147069e-02f,
3.425179508e-02f, 3.424206130e-02f, 3.423226937e-02f, 3.422241930e-02f, 3.421251113e-02f, 3.420254487e-02f, 3.419252056e-02f, 3.418243820e-02f, 3.417229784e-02f, 3.416209948e-02f,
3.415184315e-02f, 3.414152888e-02f, 3.413115670e-02f, 3.412072661e-02f, 3.411023866e-02f, 3.409969286e-02f, 3.408908923e-02f, 3.407842780e-02f, 3.406770861e-02f, 3.405693166e-02f,
3.404609698e-02f, 3.403520460e-02f, 3.402425455e-02f, 3.401324685e-02f, 3.400218151e-02f, 3.399105858e-02f, 3.397987807e-02f, 3.396864001e-02f, 3.395734443e-02f, 3.394599134e-02f,
3.393458078e-02f, 3.392311277e-02f, 3.391158734e-02f, 3.390000451e-02f, 3.388836431e-02f, 3.387666676e-02f, 3.386491189e-02f, 3.385309973e-02f, 3.384123030e-02f, 3.382930363e-02f,
3.381731975e-02f, 3.380527868e-02f, 3.379318045e-02f, 3.378102508e-02f, 3.376881261e-02f, 3.375654305e-02f, 3.374421645e-02f, 3.373183281e-02f, 3.371939218e-02f, 3.370689458e-02f,
3.369434003e-02f, 3.368172857e-02f, 3.366906021e-02f, 3.365633500e-02f, 3.364355295e-02f, 3.363071410e-02f, 3.361781847e-02f, 3.360486609e-02f, 3.359185698e-02f, 3.357879119e-02f,
3.356566873e-02f, 3.355248964e-02f, 3.353925393e-02f, 3.352596165e-02f, 3.351261282e-02f, 3.349920747e-02f, 3.348574562e-02f, 3.347222732e-02f, 3.345865257e-02f, 3.344502143e-02f,
3.343133391e-02f, 3.341759004e-02f, 3.340378985e-02f, 3.338993338e-02f, 3.337602065e-02f, 3.336205170e-02f, 3.334802654e-02f, 3.333394522e-02f, 3.331980776e-02f, 3.330561420e-02f,
3.329136455e-02f, 3.327705886e-02f, 3.326269716e-02f, 3.324827947e-02f, 3.323380582e-02f, 3.321927625e-02f, 3.320469079e-02f, 3.319004946e-02f, 3.317535230e-02f, 3.316059934e-02f,
3.314579061e-02f, 3.313092615e-02f, 3.311600597e-02f, 3.310103013e-02f, 3.308599863e-02f, 3.307091153e-02f, 3.305576885e-02f, 3.304057062e-02f, 3.302531687e-02f, 3.301000764e-02f,
3.299464295e-02f, 3.297922285e-02f, 3.296374735e-02f, 3.294821651e-02f, 3.293263034e-02f, 3.291698888e-02f, 3.290129216e-02f, 3.288554021e-02f, 3.286973308e-02f, 3.285387078e-02f,
3.283795336e-02f, 3.282198085e-02f, 3.280595328e-02f, 3.278987068e-02f, 3.277373309e-02f, 3.275754054e-02f, 3.274129306e-02f, 3.272499069e-02f, 3.270863346e-02f, 3.269222141e-02f,
3.267575456e-02f, 3.265923297e-02f, 3.264265664e-02f, 3.262602563e-02f, 3.260933997e-02f, 3.259259968e-02f, 3.257580481e-02f, 3.255895540e-02f, 3.254205146e-02f, 3.252509304e-02f,
3.250808018e-02f, 3.249101291e-02f, 3.247389126e-02f, 3.245671527e-02f, 3.243948497e-02f, 3.242220040e-02f, 3.240486160e-02f, 3.238746860e-02f, 3.237002143e-02f, 3.235252013e-02f,
3.233496475e-02f, 3.231735530e-02f, 3.229969184e-02f, 3.228197439e-02f, 3.226420299e-02f, 3.224637767e-02f, 3.222849848e-02f, 3.221056546e-02f, 3.219257862e-02f, 3.217453802e-02f,
3.215644369e-02f, 3.213829567e-02f, 3.212009399e-02f, 3.210183869e-02f, 3.208352981e-02f, 3.206516738e-02f, 3.204675144e-02f, 3.202828203e-02f, 3.200975919e-02f, 3.199118295e-02f,
3.197255335e-02f, 3.195387043e-02f, 3.193513422e-02f, 3.191634477e-02f, 3.189750211e-02f, 3.187860628e-02f, 3.185965732e-02f, 3.184065526e-02f, 3.182160015e-02f, 3.180249202e-02f,
3.178333091e-02f, 3.176411687e-02f, 3.174484991e-02f, 3.172553010e-02f, 3.170615746e-02f, 3.168673204e-02f, 3.166725386e-02f, 3.164772298e-02f, 3.162813943e-02f, 3.160850326e-02f,
3.158881449e-02f, 3.156907317e-02f, 3.154927933e-02f, 3.152943303e-02f, 3.150953429e-02f, 3.148958317e-02f, 3.146957968e-02f, 3.144952389e-02f, 3.142941582e-02f, 3.140925552e-02f,
3.138904302e-02f, 3.136877837e-02f, 3.134846161e-02f, 3.132809278e-02f, 3.130767192e-02f, 3.128719906e-02f, 3.126667425e-02f, 3.124609754e-02f, 3.122546895e-02f, 3.120478854e-02f,
3.118405634e-02f, 3.116327239e-02f, 3.114243674e-02f, 3.112154943e-02f, 3.110061049e-02f, 3.107961997e-02f, 3.105857791e-02f, 3.103748436e-02f, 3.101633934e-02f, 3.099514292e-02f,
3.097389512e-02f, 3.095259599e-02f, 3.093124557e-02f, 3.090984390e-02f, 3.088839103e-02f, 3.086688699e-02f, 3.084533184e-02f, 3.082372561e-02f, 3.080206834e-02f, 3.078036008e-02f,
3.075860088e-02f, 3.073679076e-02f, 3.071492978e-02f, 3.069301798e-02f, 3.067105540e-02f, 3.064904208e-02f, 3.062697807e-02f, 3.060486341e-02f, 3.058269815e-02f, 3.056048233e-02f,
3.053821598e-02f, 3.051589916e-02f, 3.049353191e-02f, 3.047111427e-02f, 3.044864629e-02f, 3.042612801e-02f, 3.040355947e-02f, 3.038094072e-02f, 3.035827180e-02f, 3.033555275e-02f,
3.031278363e-02f, 3.028996447e-02f, 3.026709532e-02f, 3.024417623e-02f, 3.022120723e-02f, 3.019818838e-02f, 3.017511971e-02f, 3.015200128e-02f, 3.012883313e-02f, 3.010561530e-02f,
3.008234783e-02f, 3.005903078e-02f, 3.003566419e-02f, 3.001224810e-02f, 2.998878257e-02f, 2.996526762e-02f, 2.994170332e-02f, 2.991808970e-02f, 2.989442682e-02f, 2.987071471e-02f,
2.984695343e-02f, 2.982314301e-02f, 2.979928351e-02f, 2.977537498e-02f, 2.975141745e-02f, 2.972741098e-02f, 2.970335560e-02f, 2.967925138e-02f, 2.965509834e-02f, 2.963089655e-02f,
2.960664605e-02f, 2.958234688e-02f, 2.955799909e-02f, 2.953360273e-02f, 2.950915784e-02f, 2.948466447e-02f, 2.946012268e-02f, 2.943553250e-02f, 2.941089398e-02f, 2.938620718e-02f,
2.936147213e-02f, 2.933668889e-02f, 2.931185751e-02f, 2.928697802e-02f, 2.926205049e-02f, 2.923707495e-02f, 2.921205146e-02f, 2.918698006e-02f, 2.916186080e-02f, 2.913669373e-02f,
2.911147890e-02f, 2.908621636e-02f, 2.906090615e-02f, 2.903554833e-02f, 2.901014293e-02f, 2.898469002e-02f, 2.895918963e-02f, 2.893364183e-02f, 2.890804665e-02f, 2.888240414e-02f,
2.885671437e-02f, 2.883097736e-02f, 2.880519318e-02f, 2.877936187e-02f, 2.875348348e-02f, 2.872755807e-02f, 2.870158567e-02f, 2.867556635e-02f, 2.864950014e-02f, 2.862338711e-02f,
2.859722729e-02f, 2.857102075e-02f, 2.854476752e-02f, 2.851846766e-02f, 2.849212122e-02f, 2.846572826e-02f, 2.843928881e-02f, 2.841280293e-02f, 2.838627067e-02f, 2.835969209e-02f,
2.833306722e-02f, 2.830639613e-02f, 2.827967886e-02f, 2.825291546e-02f, 2.822610599e-02f, 2.819925050e-02f, 2.817234903e-02f, 2.814540164e-02f, 2.811840838e-02f, 2.809136929e-02f,
2.806428444e-02f, 2.803715387e-02f, 2.800997764e-02f, 2.798275579e-02f, 2.795548838e-02f, 2.792817545e-02f, 2.790081707e-02f, 2.787341328e-02f, 2.784596413e-02f, 2.781846968e-02f,
2.779092998e-02f, 2.776334508e-02f, 2.773571503e-02f, 2.770803989e-02f, 2.768031970e-02f, 2.765255452e-02f, 2.762474440e-02f, 2.759688940e-02f, 2.756898957e-02f, 2.754104495e-02f,
2.751305561e-02f, 2.748502159e-02f, 2.745694295e-02f, 2.742881974e-02f, 2.740065202e-02f, 2.737243983e-02f, 2.734418323e-02f, 2.731588228e-02f, 2.728753702e-02f, 2.725914752e-02f,
2.723071381e-02f, 2.720223597e-02f, 2.717371403e-02f, 2.714514806e-02f, 2.711653811e-02f, 2.708788423e-02f, 2.705918647e-02f, 2.703044490e-02f, 2.700165956e-02f, 2.697283051e-02f,
2.694395779e-02f, 2.691504148e-02f, 2.688608162e-02f, 2.685707826e-02f, 2.682803146e-02f, 2.679894127e-02f, 2.676980775e-02f, 2.674063096e-02f, 2.671141094e-02f, 2.668214776e-02f,
2.665284146e-02f, 2.662349211e-02f, 2.659409975e-02f, 2.656466445e-02f, 2.653518625e-02f, 2.650566522e-02f, 2.647610140e-02f, 2.644649486e-02f, 2.641684564e-02f, 2.638715381e-02f,
2.635741942e-02f, 2.632764252e-02f, 2.629782318e-02f, 2.626796144e-02f, 2.623805736e-02f, 2.620811100e-02f, 2.617812242e-02f, 2.614809167e-02f, 2.611801880e-02f, 2.608790387e-02f,
2.605774695e-02f, 2.602754808e-02f, 2.599730732e-02f, 2.596702472e-02f, 2.593670035e-02f, 2.590633426e-02f, 2.587592651e-02f, 2.584547715e-02f, 2.581498625e-02f, 2.578445385e-02f,
2.575388001e-02f, 2.572326480e-02f, 2.569260826e-02f, 2.566191046e-02f, 2.563117145e-02f, 2.560039129e-02f, 2.556957003e-02f, 2.553870774e-02f, 2.550780447e-02f, 2.547686028e-02f,
2.544587523e-02f, 2.541484937e-02f, 2.538378276e-02f, 2.535267546e-02f, 2.532152753e-02f, 2.529033902e-02f, 2.525911000e-02f, 2.522784051e-02f, 2.519653063e-02f, 2.516518040e-02f,
2.513378989e-02f, 2.510235914e-02f, 2.507088823e-02f, 2.503937721e-02f, 2.500782614e-02f, 2.497623508e-02f, 2.494460408e-02f, 2.491293320e-02f, 2.488122250e-02f, 2.484947205e-02f,
2.481768190e-02f, 2.478585210e-02f, 2.475398272e-02f, 2.472207382e-02f, 2.469012545e-02f, 2.465813768e-02f, 2.462611056e-02f, 2.459404416e-02f, 2.456193853e-02f, 2.452979372e-02f,
2.449760981e-02f, 2.446538685e-02f, 2.443312490e-02f, 2.440082402e-02f, 2.436848427e-02f, 2.433610570e-02f, 2.430368839e-02f, 2.427123238e-02f, 2.423873774e-02f, 2.420620453e-02f,
2.417363281e-02f, 2.414102264e-02f, 2.410837407e-02f, 2.407568717e-02f, 2.404296201e-02f, 2.401019863e-02f, 2.397739710e-02f, 2.394455748e-02f, 2.391167983e-02f, 2.387876421e-02f,
2.384581068e-02f, 2.381281930e-02f, 2.377979014e-02f, 2.374672325e-02f, 2.371361869e-02f, 2.368047653e-02f, 2.364729683e-02f, 2.361407964e-02f, 2.358082503e-02f, 2.354753307e-02f,
2.351420380e-02f, 2.348083729e-02f, 2.344743361e-02f, 2.341399281e-02f, 2.338051495e-02f, 2.334700011e-02f, 2.331344833e-02f, 2.327985968e-02f, 2.324623423e-02f, 2.321257203e-02f,
2.317887314e-02f, 2.314513763e-02f, 2.311136556e-02f, 2.307755700e-02f, 2.304371199e-02f, 2.300983061e-02f, 2.297591292e-02f, 2.294195898e-02f, 2.290796885e-02f, 2.287394259e-02f,
2.283988027e-02f, 2.280578194e-02f, 2.277164768e-02f, 2.273747754e-02f, 2.270327159e-02f, 2.266902989e-02f, 2.263475249e-02f, 2.260043948e-02f, 2.256609089e-02f, 2.253170681e-02f,
2.249728729e-02f, 2.246283240e-02f, 2.242834219e-02f, 2.239381673e-02f, 2.235925609e-02f, 2.232466033e-02f, 2.229002951e-02f, 2.225536369e-02f, 2.222066294e-02f, 2.218592732e-02f,
2.215115689e-02f, 2.211635172e-02f, 2.208151187e-02f, 2.204663741e-02f, 2.201172839e-02f, 2.197678489e-02f, 2.194180696e-02f, 2.190679467e-02f, 2.187174809e-02f, 2.183666727e-02f,
2.180155228e-02f, 2.176640319e-02f, 2.173122005e-02f, 2.169600294e-02f, 2.166075192e-02f, 2.162546705e-02f, 2.159014839e-02f, 2.155479602e-02f, 2.151940999e-02f, 2.148399037e-02f,
2.144853722e-02f, 2.141305061e-02f, 2.137753060e-02f, 2.134197726e-02f, 2.130639065e-02f, 2.127077083e-02f, 2.123511788e-02f, 2.119943185e-02f, 2.116371282e-02f, 2.112796084e-02f,
2.109217598e-02f, 2.105635830e-02f, 2.102050788e-02f, 2.098462477e-02f, 2.094870904e-02f, 2.091276076e-02f, 2.087677999e-02f, 2.084076680e-02f, 2.080472125e-02f, 2.076864341e-02f,
2.073253334e-02f, 2.069639111e-02f, 2.066021678e-02f, 2.062401042e-02f, 2.058777210e-02f, 2.055150188e-02f, 2.051519983e-02f, 2.047886600e-02f, 2.044250048e-02f, 2.040610332e-02f,
2.036967459e-02f, 2.033321436e-02f, 2.029672269e-02f, 2.026019964e-02f, 2.022364530e-02f, 2.018705971e-02f, 2.015044295e-02f, 2.011379508e-02f, 2.007711617e-02f, 2.004040629e-02f,
2.000366550e-02f, 1.996689387e-02f, 1.993009146e-02f, 1.989325834e-02f, 1.985639459e-02f, 1.981950026e-02f, 1.978257542e-02f, 1.974562013e-02f, 1.970863448e-02f, 1.967161851e-02f,
1.963457231e-02f, 1.959749593e-02f, 1.956038944e-02f, 1.952325291e-02f, 1.948608641e-02f, 1.944889000e-02f, 1.941166376e-02f, 1.937440774e-02f, 1.933712201e-02f, 1.929980665e-02f,
1.926246172e-02f, 1.922508729e-02f, 1.918768342e-02f, 1.915025019e-02f, 1.911278765e-02f, 1.907529588e-02f, 1.903777495e-02f, 1.900022491e-02f, 1.896264585e-02f, 1.892503783e-02f,
1.888740091e-02f, 1.884973516e-02f, 1.881204066e-02f, 1.877431746e-02f, 1.873656564e-02f, 1.869878527e-02f, 1.866097641e-02f, 1.862313913e-02f, 1.858527350e-02f, 1.854737959e-02f,
1.850945746e-02f, 1.847150718e-02f, 1.843352883e-02f, 1.839552247e-02f, 1.835748816e-02f, 1.831942599e-02f, 1.828133600e-02f, 1.824321829e-02f, 1.820507290e-02f, 1.816689991e-02f,
1.812869940e-02f, 1.809047142e-02f, 1.805221605e-02f, 1.801393335e-02f, 1.797562340e-02f, 1.793728626e-02f, 1.789892200e-02f, 1.786053070e-02f, 1.782211241e-02f, 1.778366721e-02f,
1.774519517e-02f, 1.770669635e-02f, 1.766817083e-02f, 1.762961868e-02f, 1.759103996e-02f, 1.755243474e-02f, 1.751380309e-02f, 1.747514509e-02f, 1.743646079e-02f, 1.739775028e-02f,
1.735901361e-02f, 1.732025086e-02f, 1.728146211e-02f, 1.724264741e-02f, 1.720380683e-02f, 1.716494046e-02f, 1.712604835e-02f, 1.708713057e-02f, 1.704818720e-02f, 1.700921831e-02f,
1.697022396e-02f, 1.693120423e-02f, 1.689215918e-02f, 1.685308889e-02f, 1.681399342e-02f, 1.677487284e-02f, 1.673572723e-02f, 1.669655666e-02f, 1.665736118e-02f, 1.661814089e-02f,
1.657889583e-02f, 1.653962609e-02f, 1.650033174e-02f, 1.646101284e-02f, 1.642166947e-02f, 1.638230169e-02f, 1.634290958e-02f, 1.630349321e-02f, 1.626405264e-02f, 1.622458795e-02f,
1.618509920e-02f, 1.614558648e-02f, 1.610604984e-02f, 1.606648936e-02f, 1.602690511e-02f, 1.598729716e-02f, 1.594766559e-02f, 1.590801045e-02f, 1.586833183e-02f, 1.582862979e-02f,
1.578890440e-02f, 1.574915574e-02f, 1.570938388e-02f, 1.566958888e-02f, 1.562977082e-02f, 1.558992976e-02f, 1.555006579e-02f, 1.551017897e-02f, 1.547026936e-02f, 1.543033705e-02f,
1.539038211e-02f, 1.535040460e-02f, 1.531040459e-02f, 1.527038217e-02f, 1.523033739e-02f, 1.519027033e-02f, 1.515018106e-02f, 1.511006965e-02f, 1.506993618e-02f, 1.502978071e-02f,
1.498960332e-02f, 1.494940408e-02f, 1.490918306e-02f, 1.486894033e-02f, 1.482867596e-02f, 1.478839002e-02f, 1.474808259e-02f, 1.470775374e-02f, 1.466740354e-02f, 1.462703205e-02f,
1.458663936e-02f, 1.454622554e-02f, 1.450579065e-02f, 1.446533477e-02f, 1.442485797e-02f, 1.438436032e-02f, 1.434384189e-02f, 1.430330276e-02f, 1.426274299e-02f, 1.422216267e-02f,
1.418156186e-02f, 1.414094063e-02f, 1.410029905e-02f, 1.405963721e-02f, 1.401895516e-02f, 1.397825298e-02f, 1.393753075e-02f, 1.389678854e-02f, 1.385602641e-02f, 1.381524445e-02f,
1.377444271e-02f, 1.373362129e-02f, 1.369278024e-02f, 1.365191964e-02f, 1.361103956e-02f, 1.357014008e-02f, 1.352922126e-02f, 1.348828319e-02f, 1.344732593e-02f, 1.340634955e-02f,
1.336535413e-02f, 1.332433974e-02f, 1.328330645e-02f, 1.324225434e-02f, 1.320118347e-02f, 1.316009393e-02f, 1.311898578e-02f, 1.307785909e-02f, 1.303671395e-02f, 1.299555041e-02f,
1.295436856e-02f, 1.291316847e-02f, 1.287195021e-02f, 1.283071385e-02f, 1.278945946e-02f, 1.274818712e-02f, 1.270689691e-02f, 1.266558889e-02f, 1.262426314e-02f, 1.258291973e-02f,
1.254155873e-02f, 1.250018022e-02f, 1.245878426e-02f, 1.241737094e-02f, 1.237594033e-02f, 1.233449250e-02f, 1.229302752e-02f, 1.225154546e-02f, 1.221004640e-02f, 1.216853042e-02f,
1.212699758e-02f, 1.208544795e-02f, 1.204388162e-02f, 1.200229866e-02f, 1.196069913e-02f, 1.191908312e-02f, 1.187745069e-02f, 1.183580192e-02f, 1.179413688e-02f, 1.175245564e-02f,
1.171075829e-02f, 1.166904489e-02f, 1.162731551e-02f, 1.158557024e-02f, 1.154380913e-02f, 1.150203227e-02f, 1.146023974e-02f, 1.141843160e-02f, 1.137660792e-02f, 1.133476879e-02f,
1.129291427e-02f, 1.125104443e-02f, 1.120915937e-02f, 1.116725913e-02f, 1.112534381e-02f, 1.108341347e-02f, 1.104146819e-02f, 1.099950803e-02f, 1.095753309e-02f, 1.091554342e-02f,
1.087353910e-02f, 1.083152021e-02f, 1.078948682e-02f, 1.074743901e-02f, 1.070537684e-02f, 1.066330040e-02f, 1.062120975e-02f, 1.057910497e-02f, 1.053698613e-02f, 1.049485331e-02f,
1.045270659e-02f, 1.041054603e-02f, 1.036837171e-02f, 1.032618370e-02f, 1.028398209e-02f, 1.024176693e-02f, 1.019953831e-02f, 1.015729631e-02f, 1.011504098e-02f, 1.007277242e-02f,
1.003049069e-02f, 9.988195864e-03f, 9.945888022e-03f, 9.903567236e-03f, 9.861233579e-03f, 9.818887127e-03f, 9.776527954e-03f, 9.734156133e-03f, 9.691771739e-03f, 9.649374847e-03f,
9.606965530e-03f, 9.564543864e-03f, 9.522109922e-03f, 9.479663779e-03f, 9.437205509e-03f, 9.394735187e-03f, 9.352252887e-03f, 9.309758683e-03f, 9.267252650e-03f, 9.224734863e-03f,
9.182205395e-03f, 9.139664322e-03f, 9.097111717e-03f, 9.054547656e-03f, 9.011972212e-03f, 8.969385461e-03f, 8.926787477e-03f, 8.884178334e-03f, 8.841558107e-03f, 8.798926871e-03f,
8.756284700e-03f, 8.713631669e-03f, 8.670967851e-03f, 8.628293323e-03f, 8.585608159e-03f, 8.542912433e-03f, 8.500206219e-03f, 8.457489593e-03f, 8.414762630e-03f, 8.372025403e-03f,
8.329277988e-03f, 8.286520459e-03f, 8.243752891e-03f, 8.200975359e-03f, 8.158187938e-03f, 8.115390701e-03f, 8.072583725e-03f, 8.029767083e-03f, 7.986940851e-03f, 7.944105103e-03f,
7.901259914e-03f, 7.858405359e-03f, 7.815541513e-03f, 7.772668450e-03f, 7.729786245e-03f, 7.686894974e-03f, 7.643994710e-03f, 7.601085529e-03f, 7.558167506e-03f, 7.515240716e-03f,
7.472305233e-03f, 7.429361132e-03f, 7.386408488e-03f, 7.343447377e-03f, 7.300477872e-03f, 7.257500049e-03f, 7.214513983e-03f, 7.171519749e-03f, 7.128517421e-03f, 7.085507075e-03f,
7.042488785e-03f, 6.999462627e-03f, 6.956428675e-03f, 6.913387005e-03f, 6.870337690e-03f, 6.827280807e-03f, 6.784216431e-03f, 6.741144635e-03f, 6.698065496e-03f, 6.654979088e-03f,
6.611885486e-03f, 6.568784765e-03f, 6.525677001e-03f, 6.482562267e-03f, 6.439440640e-03f, 6.396312194e-03f, 6.353177005e-03f, 6.310035146e-03f, 6.266886694e-03f, 6.223731724e-03f,
6.180570309e-03f, 6.137402527e-03f, 6.094228450e-03f, 6.051048155e-03f, 6.007861717e-03f, 5.964669211e-03f, 5.921470711e-03f, 5.878266292e-03f, 5.835056031e-03f, 5.791840001e-03f,
5.748618279e-03f, 5.705390938e-03f, 5.662158055e-03f, 5.618919703e-03f, 5.575675959e-03f, 5.532426898e-03f, 5.489172593e-03f, 5.445913121e-03f, 5.402648557e-03f, 5.359378975e-03f,
5.316104451e-03f, 5.272825060e-03f, 5.229540877e-03f, 5.186251977e-03f, 5.142958435e-03f, 5.099660326e-03f, 5.056357725e-03f, 5.013050708e-03f, 4.969739349e-03f, 4.926423723e-03f,
4.883103906e-03f, 4.839779973e-03f, 4.796451999e-03f, 4.753120059e-03f, 4.709784227e-03f, 4.666444580e-03f, 4.623101192e-03f, 4.579754138e-03f, 4.536403493e-03f, 4.493049333e-03f,
4.449691732e-03f, 4.406330766e-03f, 4.362966509e-03f, 4.319599037e-03f, 4.276228425e-03f, 4.232854748e-03f, 4.189478081e-03f, 4.146098499e-03f, 4.102716077e-03f, 4.059330890e-03f,
4.015943013e-03f, 3.972552521e-03f, 3.929159490e-03f, 3.885763994e-03f, 3.842366108e-03f, 3.798965908e-03f, 3.755563469e-03f, 3.712158865e-03f, 3.668752171e-03f, 3.625343463e-03f,
3.581932816e-03f, 3.538520304e-03f, 3.495106003e-03f, 3.451689988e-03f, 3.408272333e-03f, 3.364853114e-03f, 3.321432406e-03f, 3.278010283e-03f, 3.234586821e-03f, 3.191162095e-03f,
3.147736179e-03f, 3.104309149e-03f, 3.060881080e-03f, 3.017452046e-03f, 2.974022122e-03f, 2.930591384e-03f, 2.887159907e-03f, 2.843727764e-03f, 2.800295032e-03f, 2.756861785e-03f,
2.713428099e-03f, 2.669994047e-03f, 2.626559705e-03f, 2.583125148e-03f, 2.539690451e-03f, 2.496255688e-03f, 2.452820935e-03f, 2.409386266e-03f, 2.365951756e-03f, 2.322517480e-03f,
2.279083514e-03f, 2.235649931e-03f, 2.192216806e-03f, 2.148784215e-03f, 2.105352232e-03f, 2.061920933e-03f, 2.018490391e-03f, 1.975060681e-03f, 1.931631879e-03f, 1.888204059e-03f,
1.844777296e-03f, 1.801351665e-03f, 1.757927240e-03f, 1.714504097e-03f, 1.671082309e-03f, 1.627661951e-03f, 1.584243099e-03f, 1.540825827e-03f, 1.497410210e-03f, 1.453996322e-03f,
1.410584238e-03f, 1.367174033e-03f, 1.323765780e-03f, 1.280359556e-03f, 1.236955435e-03f, 1.193553490e-03f, 1.150153797e-03f, 1.106756431e-03f, 1.063361466e-03f, 1.019968976e-03f,
9.765790356e-04f, 9.331917202e-04f, 8.898071039e-04f, 8.464252612e-04f, 8.030462667e-04f, 7.596701947e-04f, 7.162971199e-04f, 6.729271166e-04f, 6.295602593e-04f, 5.861966225e-04f,
5.428362806e-04f, 4.994793080e-04f, 4.561257790e-04f, 4.127757682e-04f, 3.694293498e-04f, 3.260865983e-04f, 2.827475880e-04f, 2.394123931e-04f, 1.960810882e-04f, 1.527537473e-04f,
1.094304449e-04f, 6.611125521e-05f, 2.279625250e-05f, -2.051448898e-05f, -6.382089500e-05f, -1.071228913e-04f, -1.504204038e-04f, -1.937133581e-04f, -2.370016802e-04f, -2.802852959e-04f,
-3.235641311e-04f, -3.668381115e-04f, -4.101071631e-04f, -4.533712119e-04f, -4.966301837e-04f, -5.398840044e-04f, -5.831326000e-04f, -6.263758965e-04f, -6.696138199e-04f, -7.128462961e-04f,
-7.560732512e-04f, -7.992946112e-04f, -8.425103022e-04f, -8.857202502e-04f, -9.289243813e-04f, -9.721226217e-04f, -1.015314897e-03f, -1.058501134e-03f, -1.101681259e-03f, -1.144855198e-03f,
-1.188022876e-03f, -1.231184221e-03f, -1.274339158e-03f, -1.317487614e-03f, -1.360629515e-03f, -1.403764787e-03f, -1.446893357e-03f, -1.490015150e-03f, -1.533130094e-03f, -1.576238114e-03f,
-1.619339137e-03f, -1.662433089e-03f, -1.705519897e-03f, -1.748599488e-03f, -1.791671786e-03f, -1.834736720e-03f, -1.877794216e-03f, -1.920844200e-03f, -1.963886598e-03f, -2.006921337e-03f,
-2.049948345e-03f, -2.092967546e-03f, -2.135978869e-03f, -2.178982239e-03f, -2.221977584e-03f, -2.264964829e-03f, -2.307943902e-03f, -2.350914730e-03f, -2.393877239e-03f, -2.436831355e-03f,
-2.479777006e-03f, -2.522714119e-03f, -2.565642620e-03f, -2.608562437e-03f, -2.651473495e-03f, -2.694375722e-03f, -2.737269045e-03f, -2.780153391e-03f, -2.823028687e-03f, -2.865894859e-03f,
-2.908751836e-03f, -2.951599543e-03f, -2.994437908e-03f, -3.037266857e-03f, -3.080086319e-03f, -3.122896220e-03f, -3.165696488e-03f, -3.208487049e-03f, -3.251267830e-03f, -3.294038760e-03f,
-3.336799764e-03f, -3.379550772e-03f, -3.422291708e-03f, -3.465022502e-03f, -3.507743081e-03f, -3.550453371e-03f, -3.593153300e-03f, -3.635842796e-03f, -3.678521786e-03f, -3.721190197e-03f,
-3.763847957e-03f, -3.806494994e-03f, -3.849131235e-03f, -3.891756607e-03f, -3.934371039e-03f, -3.976974458e-03f, -4.019566791e-03f, -4.062147966e-03f, -4.104717911e-03f, -4.147276553e-03f,
-4.189823821e-03f, -4.232359643e-03f, -4.274883945e-03f, -4.317396656e-03f, -4.359897703e-03f, -4.402387015e-03f, -4.444864519e-03f, -4.487330144e-03f, -4.529783817e-03f, -4.572225467e-03f,
-4.614655021e-03f, -4.657072407e-03f, -4.699477554e-03f, -4.741870390e-03f, -4.784250842e-03f, -4.826618839e-03f, -4.868974310e-03f, -4.911317181e-03f, -4.953647383e-03f, -4.995964842e-03f,
-5.038269487e-03f, -5.080561247e-03f, -5.122840050e-03f, -5.165105825e-03f, -5.207358499e-03f, -5.249598001e-03f, -5.291824260e-03f, -5.334037204e-03f, -5.376236762e-03f, -5.418422862e-03f,
-5.460595433e-03f, -5.502754404e-03f, -5.544899703e-03f, -5.587031259e-03f, -5.629149000e-03f, -5.671252856e-03f, -5.713342755e-03f, -5.755418627e-03f, -5.797480399e-03f, -5.839528001e-03f,
-5.881561362e-03f, -5.923580410e-03f, -5.965585075e-03f, -6.007575286e-03f, -6.049550971e-03f, -6.091512060e-03f, -6.133458482e-03f, -6.175390166e-03f, -6.217307041e-03f, -6.259209037e-03f,
-6.301096082e-03f, -6.342968106e-03f, -6.384825039e-03f, -6.426666808e-03f, -6.468493345e-03f, -6.510304578e-03f, -6.552100437e-03f, -6.593880851e-03f, -6.635645749e-03f, -6.677395062e-03f,
-6.719128719e-03f, -6.760846649e-03f, -6.802548782e-03f, -6.844235048e-03f, -6.885905376e-03f, -6.927559697e-03f, -6.969197939e-03f, -7.010820033e-03f, -7.052425909e-03f, -7.094015496e-03f,
-7.135588725e-03f, -7.177145524e-03f, -7.218685826e-03f, -7.260209558e-03f, -7.301716652e-03f, -7.343207037e-03f, -7.384680644e-03f, -7.426137403e-03f, -7.467577243e-03f, -7.509000096e-03f,
-7.550405891e-03f, -7.591794559e-03f, -7.633166030e-03f, -7.674520235e-03f, -7.715857103e-03f, -7.757176566e-03f, -7.798478554e-03f, -7.839762997e-03f, -7.881029825e-03f, -7.922278971e-03f,
-7.963510363e-03f, -8.004723933e-03f, -8.045919612e-03f, -8.087097330e-03f, -8.128257018e-03f, -8.169398607e-03f, -8.210522028e-03f, -8.251627211e-03f, -8.292714088e-03f, -8.333782590e-03f,
-8.374832647e-03f, -8.415864190e-03f, -8.456877151e-03f, -8.497871462e-03f, -8.538847052e-03f, -8.579803853e-03f, -8.620741797e-03f, -8.661660815e-03f, -8.702560837e-03f, -8.743441796e-03f,
-8.784303623e-03f, -8.825146250e-03f, -8.865969606e-03f, -8.906773626e-03f, -8.947558239e-03f, -8.988323377e-03f, -9.029068973e-03f, -9.069794958e-03f, -9.110501263e-03f, -9.151187820e-03f,
-9.191854561e-03f, -9.232501418e-03f, -9.273128323e-03f, -9.313735208e-03f, -9.354322005e-03f, -9.394888645e-03f, -9.435435061e-03f, -9.475961185e-03f, -9.516466949e-03f, -9.556952285e-03f,
-9.597417125e-03f, -9.637861402e-03f, -9.678285048e-03f, -9.718687996e-03f, -9.759070177e-03f, -9.799431524e-03f, -9.839771970e-03f, -9.880091446e-03f, -9.920389887e-03f, -9.960667224e-03f,
-1.000092339e-02f, -1.004115832e-02f, -1.008137194e-02f, -1.012156419e-02f, -1.016173500e-02f, -1.020188430e-02f, -1.024201202e-02f, -1.028211811e-02f, -1.032220249e-02f, -1.036226509e-02f,
-1.040230585e-02f, -1.044232470e-02f, -1.048232157e-02f, -1.052229641e-02f, -1.056224913e-02f, -1.060217967e-02f, -1.064208798e-02f, -1.068197397e-02f, -1.072183759e-02f, -1.076167876e-02f,
-1.080149743e-02f, -1.084129352e-02f, -1.088106697e-02f, -1.092081771e-02f, -1.096054567e-02f, -1.100025080e-02f, -1.103993302e-02f, -1.107959226e-02f, -1.111922847e-02f, -1.115884157e-02f,
-1.119843150e-02f, -1.123799819e-02f, -1.127754158e-02f, -1.131706160e-02f, -1.135655818e-02f, -1.139603126e-02f, -1.143548078e-02f, -1.147490667e-02f, -1.151430885e-02f, -1.155368728e-02f,
-1.159304187e-02f, -1.163237257e-02f, -1.167167931e-02f, -1.171096203e-02f, -1.175022065e-02f, -1.178945512e-02f, -1.182866537e-02f, -1.186785133e-02f, -1.190701294e-02f, -1.194615013e-02f,
-1.198526284e-02f, -1.202435101e-02f, -1.206341456e-02f, -1.210245344e-02f, -1.214146757e-02f, -1.218045690e-02f, -1.221942135e-02f, -1.225836087e-02f, -1.229727539e-02f, -1.233616485e-02f,
-1.237502917e-02f, -1.241386830e-02f, -1.245268218e-02f, -1.249147072e-02f, -1.253023388e-02f, -1.256897159e-02f, -1.260768378e-02f, -1.264637040e-02f, -1.268503136e-02f, -1.272366662e-02f,
-1.276227610e-02f, -1.280085975e-02f, -1.283941750e-02f, -1.287794928e-02f, -1.291645504e-02f, -1.295493470e-02f, -1.299338820e-02f, -1.303181549e-02f, -1.307021649e-02f, -1.310859114e-02f,
-1.314693938e-02f, -1.318526115e-02f, -1.322355638e-02f, -1.326182501e-02f, -1.330006697e-02f, -1.333828221e-02f, -1.337647065e-02f, -1.341463224e-02f, -1.345276692e-02f, -1.349087461e-02f,
-1.352895526e-02f, -1.356700880e-02f, -1.360503517e-02f, -1.364303431e-02f, -1.368100615e-02f, -1.371895064e-02f, -1.375686770e-02f, -1.379475728e-02f, -1.383261931e-02f, -1.387045374e-02f,
-1.390826049e-02f, -1.394603951e-02f, -1.398379074e-02f, -1.402151410e-02f, -1.405920955e-02f, -1.409687701e-02f, -1.413451642e-02f, -1.417212773e-02f, -1.420971087e-02f, -1.424726578e-02f,
-1.428479239e-02f, -1.432229065e-02f, -1.435976049e-02f, -1.439720185e-02f, -1.443461467e-02f, -1.447199889e-02f, -1.450935444e-02f, -1.454668127e-02f, -1.458397931e-02f, -1.462124850e-02f,
-1.465848878e-02f, -1.469570009e-02f, -1.473288236e-02f, -1.477003554e-02f, -1.480715957e-02f, -1.484425438e-02f, -1.488131991e-02f, -1.491835610e-02f, -1.495536290e-02f, -1.499234023e-02f,
-1.502928804e-02f, -1.506620627e-02f, -1.510309485e-02f, -1.513995374e-02f, -1.517678285e-02f, -1.521358215e-02f, -1.525035155e-02f, -1.528709101e-02f, -1.532380047e-02f, -1.536047986e-02f,
-1.539712912e-02f, -1.543374819e-02f, -1.547033702e-02f, -1.550689554e-02f, -1.554342369e-02f, -1.557992141e-02f, -1.561638865e-02f, -1.565282533e-02f, -1.568923142e-02f, -1.572560683e-02f,
-1.576195152e-02f, -1.579826542e-02f, -1.583454847e-02f, -1.587080062e-02f, -1.590702181e-02f, -1.594321197e-02f, -1.597937104e-02f, -1.601549898e-02f, -1.605159571e-02f, -1.608766118e-02f,
-1.612369532e-02f, -1.615969809e-02f, -1.619566942e-02f, -1.623160926e-02f, -1.626751753e-02f, -1.630339419e-02f, -1.633923918e-02f, -1.637505243e-02f, -1.641083390e-02f, -1.644658351e-02f,
-1.648230121e-02f, -1.651798695e-02f, -1.655364066e-02f, -1.658926229e-02f, -1.662485178e-02f, -1.666040906e-02f, -1.669593409e-02f, -1.673142680e-02f, -1.676688714e-02f, -1.680231504e-02f,
-1.683771046e-02f, -1.687307332e-02f, -1.690840358e-02f, -1.694370118e-02f, -1.697896605e-02f, -1.701419815e-02f, -1.704939741e-02f, -1.708456377e-02f, -1.711969719e-02f, -1.715479759e-02f,
-1.718986493e-02f, -1.722489914e-02f, -1.725990018e-02f, -1.729486798e-02f, -1.732980248e-02f, -1.736470363e-02f, -1.739957138e-02f, -1.743440565e-02f, -1.746920641e-02f, -1.750397359e-02f,
-1.753870713e-02f, -1.757340698e-02f, -1.760807308e-02f, -1.764270537e-02f, -1.767730381e-02f, -1.771186832e-02f, -1.774639887e-02f, -1.778089538e-02f, -1.781535780e-02f, -1.784978608e-02f,
-1.788418017e-02f, -1.791854000e-02f, -1.795286552e-02f, -1.798715667e-02f, -1.802141340e-02f, -1.805563565e-02f, -1.808982337e-02f, -1.812397651e-02f, -1.815809499e-02f, -1.819217878e-02f,
-1.822622781e-02f, -1.826024203e-02f, -1.829422139e-02f, -1.832816582e-02f, -1.836207528e-02f, -1.839594970e-02f, -1.842978904e-02f, -1.846359324e-02f, -1.849736225e-02f, -1.853109600e-02f,
-1.856479445e-02f, -1.859845753e-02f, -1.863208521e-02f, -1.866567741e-02f, -1.869923409e-02f, -1.873275519e-02f, -1.876624066e-02f, -1.879969044e-02f, -1.883310448e-02f, -1.886648273e-02f,
-1.889982513e-02f, -1.893313162e-02f, -1.896640216e-02f, -1.899963669e-02f, -1.903283515e-02f, -1.906599750e-02f, -1.909912367e-02f, -1.913221362e-02f, -1.916526728e-02f, -1.919828462e-02f,
-1.923126557e-02f, -1.926421008e-02f, -1.929711810e-02f, -1.932998957e-02f, -1.936282444e-02f, -1.939562267e-02f, -1.942838418e-02f, -1.946110894e-02f, -1.949379689e-02f, -1.952644798e-02f,
-1.955906215e-02f, -1.959163935e-02f, -1.962417953e-02f, -1.965668264e-02f, -1.968914862e-02f, -1.972157742e-02f, -1.975396899e-02f, -1.978632328e-02f, -1.981864023e-02f, -1.985091980e-02f,
-1.988316193e-02f, -1.991536656e-02f, -1.994753366e-02f, -1.997966316e-02f, -2.001175501e-02f, -2.004380916e-02f, -2.007582557e-02f, -2.010780417e-02f, -2.013974492e-02f, -2.017164776e-02f,
-2.020351265e-02f, -2.023533954e-02f, -2.026712836e-02f, -2.029887908e-02f, -2.033059164e-02f, -2.036226598e-02f, -2.039390207e-02f, -2.042549984e-02f, -2.045705925e-02f, -2.048858024e-02f,
-2.052006277e-02f, -2.055150678e-02f, -2.058291223e-02f, -2.061427906e-02f, -2.064560723e-02f, -2.067689668e-02f, -2.070814736e-02f, -2.073935923e-02f, -2.077053222e-02f, -2.080166631e-02f,
-2.083276142e-02f, -2.086381752e-02f, -2.089483455e-02f, -2.092581247e-02f, -2.095675121e-02f, -2.098765075e-02f, -2.101851102e-02f, -2.104933197e-02f, -2.108011357e-02f, -2.111085575e-02f,
-2.114155846e-02f, -2.117222167e-02f, -2.120284532e-02f, -2.123342936e-02f, -2.126397374e-02f, -2.129447841e-02f, -2.132494333e-02f, -2.135536844e-02f, -2.138575370e-02f, -2.141609907e-02f,
-2.144640448e-02f, -2.147666989e-02f, -2.150689526e-02f, -2.153708053e-02f, -2.156722566e-02f, -2.159733060e-02f, -2.162739530e-02f, -2.165741972e-02f, -2.168740380e-02f, -2.171734749e-02f,
-2.174725076e-02f, -2.177711355e-02f, -2.180693582e-02f, -2.183671751e-02f, -2.186645859e-02f, -2.189615899e-02f, -2.192581868e-02f, -2.195543761e-02f, -2.198501573e-02f, -2.201455300e-02f,
-2.204404936e-02f, -2.207350477e-02f, -2.210291919e-02f, -2.213229256e-02f, -2.216162485e-02f, -2.219091599e-02f, -2.222016596e-02f, -2.224937469e-02f, -2.227854215e-02f, -2.230766828e-02f,
-2.233675305e-02f, -2.236579641e-02f, -2.239479830e-02f, -2.242375869e-02f, -2.245267752e-02f, -2.248155476e-02f, -2.251039035e-02f, -2.253918425e-02f, -2.256793642e-02f, -2.259664681e-02f,
-2.262531537e-02f, -2.265394206e-02f, -2.268252683e-02f, -2.271106964e-02f, -2.273957045e-02f, -2.276802920e-02f, -2.279644585e-02f, -2.282482036e-02f, -2.285315269e-02f, -2.288144278e-02f,
-2.290969060e-02f, -2.293789610e-02f, -2.296605923e-02f, -2.299417995e-02f, -2.302225821e-02f, -2.305029398e-02f, -2.307828721e-02f, -2.310623784e-02f, -2.313414585e-02f, -2.316201118e-02f,
-2.318983380e-02f, -2.321761365e-02f, -2.324535069e-02f, -2.327304488e-02f, -2.330069618e-02f, -2.332830455e-02f, -2.335586993e-02f, -2.338339228e-02f, -2.341087157e-02f, -2.343830775e-02f,
-2.346570078e-02f, -2.349305061e-02f, -2.352035720e-02f, -2.354762051e-02f, -2.357484049e-02f, -2.360201710e-02f, -2.362915030e-02f, -2.365624005e-02f, -2.368328630e-02f, -2.371028902e-02f,
-2.373724815e-02f, -2.376416367e-02f, -2.379103551e-02f, -2.381786365e-02f, -2.384464804e-02f, -2.387138864e-02f, -2.389808541e-02f, -2.392473830e-02f, -2.395134727e-02f, -2.397791229e-02f,
-2.400443330e-02f, -2.403091028e-02f, -2.405734317e-02f, -2.408373194e-02f, -2.411007655e-02f, -2.413637694e-02f, -2.416263309e-02f, -2.418884496e-02f, -2.421501249e-02f, -2.424113565e-02f,
-2.426721441e-02f, -2.429324871e-02f, -2.431923852e-02f, -2.434518379e-02f, -2.437108450e-02f, -2.439694059e-02f, -2.442275203e-02f, -2.444851877e-02f, -2.447424078e-02f, -2.449991802e-02f,
-2.452555044e-02f, -2.455113801e-02f, -2.457668068e-02f, -2.460217842e-02f, -2.462763119e-02f, -2.465303895e-02f, -2.467840166e-02f, -2.470371927e-02f, -2.472899175e-02f, -2.475421907e-02f,
-2.477940118e-02f, -2.480453803e-02f, -2.482962961e-02f, -2.485467585e-02f, -2.487967673e-02f, -2.490463221e-02f, -2.492954225e-02f, -2.495440680e-02f, -2.497922584e-02f, -2.500399932e-02f,
-2.502872721e-02f, -2.505340946e-02f, -2.507804604e-02f, -2.510263691e-02f, -2.512718203e-02f, -2.515168137e-02f, -2.517613488e-02f, -2.520054253e-02f, -2.522490428e-02f, -2.524922010e-02f,
-2.527348994e-02f, -2.529771377e-02f, -2.532189155e-02f, -2.534602325e-02f, -2.537010882e-02f, -2.539414823e-02f, -2.541814145e-02f, -2.544208843e-02f, -2.546598914e-02f, -2.548984354e-02f,
-2.551365160e-02f, -2.553741328e-02f, -2.556112854e-02f, -2.558479734e-02f, -2.560841966e-02f, -2.563199545e-02f, -2.565552468e-02f, -2.567900730e-02f, -2.570244330e-02f, -2.572583262e-02f,
-2.574917524e-02f, -2.577247111e-02f, -2.579572021e-02f, -2.581892250e-02f, -2.584207793e-02f, -2.586518648e-02f, -2.588824812e-02f, -2.591126279e-02f, -2.593423048e-02f, -2.595715114e-02f,
-2.598002475e-02f, -2.600285125e-02f, -2.602563063e-02f, -2.604836285e-02f, -2.607104786e-02f, -2.609368564e-02f, -2.611627616e-02f, -2.613881937e-02f, -2.616131524e-02f, -2.618376375e-02f,
-2.620616485e-02f, -2.622851851e-02f, -2.625082469e-02f, -2.627308337e-02f, -2.629529451e-02f, -2.631745808e-02f, -2.633957403e-02f, -2.636164235e-02f, -2.638366299e-02f, -2.640563592e-02f,
-2.642756111e-02f, -2.644943853e-02f, -2.647126813e-02f, -2.649304990e-02f, -2.651478379e-02f, -2.653646978e-02f, -2.655810782e-02f, -2.657969789e-02f, -2.660123996e-02f, -2.662273399e-02f,
-2.664417995e-02f, -2.666557781e-02f, -2.668692754e-02f, -2.670822910e-02f, -2.672948245e-02f, -2.675068758e-02f, -2.677184445e-02f, -2.679295302e-02f, -2.681401327e-02f, -2.683502515e-02f,
-2.685598865e-02f, -2.687690373e-02f, -2.689777035e-02f, -2.691858849e-02f, -2.693935812e-02f, -2.696007920e-02f, -2.698075171e-02f, -2.700137560e-02f, -2.702195086e-02f, -2.704247745e-02f,
-2.706295533e-02f, -2.708338449e-02f, -2.710376488e-02f, -2.712409648e-02f, -2.714437926e-02f, -2.716461319e-02f, -2.718479824e-02f, -2.720493437e-02f, -2.722502156e-02f, -2.724505978e-02f,
-2.726504899e-02f, -2.728498917e-02f, -2.730488029e-02f, -2.732472232e-02f, -2.734451523e-02f, -2.736425898e-02f, -2.738395356e-02f, -2.740359893e-02f, -2.742319506e-02f, -2.744274192e-02f,
-2.746223949e-02f, -2.748168773e-02f, -2.750108661e-02f, -2.752043612e-02f, -2.753973621e-02f, -2.755898687e-02f, -2.757818805e-02f, -2.759733974e-02f, -2.761644191e-02f, -2.763549452e-02f,
-2.765449755e-02f, -2.767345098e-02f, -2.769235476e-02f, -2.771120888e-02f, -2.773001331e-02f, -2.774876802e-02f, -2.776747298e-02f, -2.778612817e-02f, -2.780473355e-02f, -2.782328911e-02f,
-2.784179480e-02f, -2.786025062e-02f, -2.787865652e-02f, -2.789701248e-02f, -2.791531848e-02f, -2.793357449e-02f, -2.795178048e-02f, -2.796993642e-02f, -2.798804230e-02f, -2.800609807e-02f,
-2.802410373e-02f, -2.804205923e-02f, -2.805996455e-02f, -2.807781967e-02f, -2.809562457e-02f, -2.811337921e-02f, -2.813108357e-02f, -2.814873762e-02f, -2.816634134e-02f, -2.818389471e-02f,
-2.820139769e-02f, -2.821885027e-02f, -2.823625241e-02f, -2.825360410e-02f, -2.827090530e-02f, -2.828815599e-02f, -2.830535615e-02f, -2.832250575e-02f, -2.833960478e-02f, -2.835665319e-02f,
-2.837365097e-02f, -2.839059809e-02f, -2.840749454e-02f, -2.842434028e-02f, -2.844113529e-02f, -2.845787955e-02f, -2.847457303e-02f, -2.849121571e-02f, -2.850780757e-02f, -2.852434857e-02f,
-2.854083871e-02f, -2.855727795e-02f, -2.857366627e-02f, -2.859000364e-02f, -2.860629006e-02f, -2.862252548e-02f, -2.863870989e-02f, -2.865484327e-02f, -2.867092559e-02f, -2.868695682e-02f,
-2.870293696e-02f, -2.871886596e-02f, -2.873474382e-02f, -2.875057051e-02f, -2.876634600e-02f, -2.878207028e-02f, -2.879774332e-02f, -2.881336510e-02f, -2.882893560e-02f, -2.884445479e-02f,
-2.885992266e-02f, -2.887533918e-02f, -2.889070433e-02f, -2.890601809e-02f, -2.892128044e-02f, -2.893649135e-02f, -2.895165081e-02f, -2.896675879e-02f, -2.898181528e-02f, -2.899682024e-02f,
-2.901177367e-02f, -2.902667554e-02f, -2.904152582e-02f, -2.905632451e-02f, -2.907107157e-02f, -2.908576699e-02f, -2.910041075e-02f, -2.911500282e-02f, -2.912954319e-02f, -2.914403183e-02f,
-2.915846874e-02f, -2.917285388e-02f, -2.918718723e-02f, -2.920146878e-02f, -2.921569851e-02f, -2.922987640e-02f, -2.924400242e-02f, -2.925807657e-02f, -2.927209881e-02f, -2.928606913e-02f,
-2.929998752e-02f, -2.931385395e-02f, -2.932766839e-02f, -2.934143085e-02f, -2.935514129e-02f, -2.936879969e-02f, -2.938240605e-02f, -2.939596033e-02f, -2.940946253e-02f, -2.942291262e-02f,
-2.943631058e-02f, -2.944965641e-02f, -2.946295007e-02f, -2.947619155e-02f, -2.948938083e-02f, -2.950251790e-02f, -2.951560274e-02f, -2.952863533e-02f, -2.954161565e-02f, -2.955454368e-02f,
-2.956741941e-02f, -2.958024283e-02f, -2.959301391e-02f, -2.960573263e-02f, -2.961839899e-02f, -2.963101295e-02f, -2.964357452e-02f, -2.965608366e-02f, -2.966854037e-02f, -2.968094462e-02f,
-2.969329640e-02f, -2.970559570e-02f, -2.971784250e-02f, -2.973003677e-02f, -2.974217851e-02f, -2.975426771e-02f, -2.976630433e-02f, -2.977828838e-02f, -2.979021982e-02f, -2.980209866e-02f,
-2.981392486e-02f, -2.982569842e-02f, -2.983741933e-02f, -2.984908756e-02f, -2.986070310e-02f, -2.987226593e-02f, -2.988377605e-02f, -2.989523343e-02f, -2.990663806e-02f, -2.991798993e-02f,
-2.992928902e-02f, -2.994053532e-02f, -2.995172882e-02f, -2.996286949e-02f, -2.997395733e-02f, -2.998499231e-02f, -2.999597444e-02f, -3.000690369e-02f, -3.001778005e-02f, -3.002860350e-02f,
-3.003937403e-02f, -3.005009164e-02f, -3.006075630e-02f, -3.007136800e-02f, -3.008192673e-02f, -3.009243247e-02f, -3.010288522e-02f, -3.011328495e-02f, -3.012363167e-02f, -3.013392534e-02f,
-3.014416597e-02f, -3.015435353e-02f, -3.016448803e-02f, -3.017456943e-02f, -3.018459774e-02f, -3.019457293e-02f, -3.020449500e-02f, -3.021436394e-02f, -3.022417973e-02f, -3.023394236e-02f,
-3.024365182e-02f, -3.025330810e-02f, -3.026291118e-02f, -3.027246106e-02f, -3.028195772e-02f, -3.029140116e-02f, -3.030079135e-02f, -3.031012830e-02f, -3.031941198e-02f, -3.032864239e-02f,
-3.033781951e-02f, -3.034694335e-02f, -3.035601388e-02f, -3.036503109e-02f, -3.037399498e-02f, -3.038290553e-02f, -3.039176274e-02f, -3.040056658e-02f, -3.040931707e-02f, -3.041801417e-02f,
-3.042665789e-02f, -3.043524822e-02f, -3.044378514e-02f, -3.045226864e-02f, -3.046069872e-02f, -3.046907536e-02f, -3.047739856e-02f, -3.048566830e-02f, -3.049388459e-02f, -3.050204740e-02f,
-3.051015673e-02f, -3.051821258e-02f, -3.052621492e-02f, -3.053416376e-02f, -3.054205908e-02f, -3.054990088e-02f, -3.055768915e-02f, -3.056542388e-02f, -3.057310506e-02f, -3.058073268e-02f,
-3.058830673e-02f, -3.059582722e-02f, -3.060329412e-02f, -3.061070743e-02f, -3.061806715e-02f, -3.062537327e-02f, -3.063262577e-02f, -3.063982466e-02f, -3.064696992e-02f, -3.065406154e-02f,
-3.066109953e-02f, -3.066808387e-02f, -3.067501455e-02f, -3.068189157e-02f, -3.068871493e-02f, -3.069548461e-02f, -3.070220061e-02f, -3.070886292e-02f, -3.071547154e-02f, -3.072202646e-02f,
-3.072852767e-02f, -3.073497517e-02f, -3.074136895e-02f, -3.074770901e-02f, -3.075399534e-02f, -3.076022793e-02f, -3.076640678e-02f, -3.077253189e-02f, -3.077860324e-02f, -3.078462083e-02f,
-3.079058466e-02f, -3.079649472e-02f, -3.080235101e-02f, -3.080815352e-02f, -3.081390225e-02f, -3.081959719e-02f, -3.082523834e-02f, -3.083082569e-02f, -3.083635923e-02f, -3.084183898e-02f,
-3.084726491e-02f, -3.085263703e-02f, -3.085795532e-02f, -3.086321980e-02f, -3.086843045e-02f, -3.087358727e-02f, -3.087869025e-02f, -3.088373939e-02f, -3.088873470e-02f, -3.089367616e-02f,
-3.089856377e-02f, -3.090339753e-02f, -3.090817743e-02f, -3.091290347e-02f, -3.091757566e-02f, -3.092219398e-02f, -3.092675843e-02f, -3.093126901e-02f, -3.093572572e-02f, -3.094012856e-02f,
-3.094447752e-02f, -3.094877259e-02f, -3.095301379e-02f, -3.095720110e-02f, -3.096133453e-02f, -3.096541406e-02f, -3.096943971e-02f, -3.097341147e-02f, -3.097732933e-02f, -3.098119329e-02f,
-3.098500336e-02f, -3.098875953e-02f, -3.099246180e-02f, -3.099611017e-02f, -3.099970464e-02f, -3.100324520e-02f, -3.100673186e-02f, -3.101016462e-02f, -3.101354347e-02f, -3.101686841e-02f,
-3.102013945e-02f, -3.102335657e-02f, -3.102651979e-02f, -3.102962910e-02f, -3.103268451e-02f, -3.103568600e-02f, -3.103863358e-02f, -3.104152726e-02f, -3.104436702e-02f, -3.104715288e-02f,
-3.104988483e-02f, -3.105256287e-02f, -3.105518701e-02f, -3.105775724e-02f, -3.106027356e-02f, -3.106273598e-02f, -3.106514449e-02f, -3.106749910e-02f, -3.106979981e-02f, -3.107204661e-02f,
-3.107423952e-02f, -3.107637853e-02f, -3.107846364e-02f, -3.108049485e-02f, -3.108247217e-02f, -3.108439560e-02f, -3.108626514e-02f, -3.108808079e-02f, -3.108984255e-02f, -3.109155043e-02f,
-3.109320442e-02f, -3.109480454e-02f, -3.109635078e-02f, -3.109784314e-02f, -3.109928163e-02f, -3.110066625e-02f, -3.110199700e-02f, -3.110327389e-02f, -3.110449692e-02f, -3.110566608e-02f,
-3.110678140e-02f, -3.110784286e-02f, -3.110885047e-02f, -3.110980423e-02f, -3.111070416e-02f, -3.111155024e-02f, -3.111234249e-02f, -3.111308091e-02f, -3.111376550e-02f, -3.111439626e-02f,
-3.111497321e-02f, -3.111549634e-02f, -3.111596566e-02f, -3.111638118e-02f, -3.111674289e-02f, -3.111705080e-02f, -3.111730492e-02f, -3.111750525e-02f, -3.111765180e-02f, -3.111774457e-02f,
-3.111778356e-02f, -3.111776879e-02f, -3.111770025e-02f, -3.111757795e-02f, -3.111740190e-02f, -3.111717210e-02f, -3.111688856e-02f, -3.111655128e-02f, -3.111616026e-02f, -3.111571553e-02f,
-3.111521707e-02f, -3.111466490e-02f, -3.111405902e-02f, -3.111339944e-02f, -3.111268617e-02f, -3.111191920e-02f, -3.111109856e-02f, -3.111022423e-02f, -3.110929624e-02f, -3.110831459e-02f,
-3.110727927e-02f, -3.110619031e-02f, -3.110504771e-02f, -3.110385147e-02f, -3.110260160e-02f, -3.110129812e-02f, -3.109994102e-02f, -3.109853031e-02f, -3.109706600e-02f, -3.109554811e-02f,
-3.109397663e-02f, -3.109235157e-02f, -3.109067295e-02f, -3.108894077e-02f, -3.108715503e-02f, -3.108531576e-02f, -3.108342294e-02f, -3.108147660e-02f, -3.107947675e-02f, -3.107742338e-02f,
-3.107531651e-02f, -3.107315615e-02f, -3.107094230e-02f, -3.106867498e-02f, -3.106635419e-02f, -3.106397995e-02f, -3.106155226e-02f, -3.105907113e-02f, -3.105653657e-02f, -3.105394859e-02f,
-3.105130720e-02f, -3.104861241e-02f, -3.104586423e-02f, -3.104306267e-02f, -3.104020774e-02f, -3.103729944e-02f, -3.103433780e-02f, -3.103132281e-02f, -3.102825450e-02f, -3.102513286e-02f,
-3.102195791e-02f, -3.101872966e-02f, -3.101544813e-02f, -3.101211331e-02f, -3.100872523e-02f, -3.100528389e-02f, -3.100178931e-02f, -3.099824149e-02f, -3.099464045e-02f, -3.099098620e-02f,
-3.098727874e-02f, -3.098351810e-02f, -3.097970428e-02f, -3.097583729e-02f, -3.097191715e-02f, -3.096794387e-02f, -3.096391745e-02f, -3.095983792e-02f, -3.095570527e-02f, -3.095151954e-02f,
-3.094728072e-02f, -3.094298883e-02f, -3.093864389e-02f, -3.093424589e-02f, -3.092979487e-02f, -3.092529083e-02f, -3.092073378e-02f, -3.091612373e-02f, -3.091146071e-02f, -3.090674471e-02f,
-3.090197576e-02f, -3.089715387e-02f, -3.089227905e-02f, -3.088735131e-02f, -3.088237068e-02f, -3.087733715e-02f, -3.087225075e-02f, -3.086711149e-02f, -3.086191939e-02f, -3.085667445e-02f,
-3.085137669e-02f, -3.084602613e-02f, -3.084062277e-02f, -3.083516664e-02f, -3.082965775e-02f, -3.082409611e-02f, -3.081848174e-02f, -3.081281465e-02f, -3.080709486e-02f, -3.080132238e-02f,
-3.079549722e-02f, -3.078961941e-02f, -3.078368896e-02f, -3.077770587e-02f, -3.077167017e-02f, -3.076558188e-02f, -3.075944100e-02f, -3.075324756e-02f, -3.074700156e-02f, -3.074070304e-02f,
-3.073435199e-02f, -3.072794843e-02f, -3.072149240e-02f, -3.071498388e-02f, -3.070842292e-02f, -3.070180951e-02f, -3.069514369e-02f, -3.068842545e-02f, -3.068165483e-02f, -3.067483184e-02f,
-3.066795648e-02f, -3.066102879e-02f, -3.065404878e-02f, -3.064701646e-02f, -3.063993185e-02f, -3.063279497e-02f, -3.062560584e-02f, -3.061836447e-02f, -3.061107088e-02f, -3.060372509e-02f,
-3.059632711e-02f, -3.058887697e-02f, -3.058137468e-02f, -3.057382026e-02f, -3.056621372e-02f, -3.055855509e-02f, -3.055084439e-02f, -3.054308162e-02f, -3.053526681e-02f, -3.052739999e-02f,
-3.051948116e-02f, -3.051151034e-02f, -3.050348756e-02f, -3.049541283e-02f, -3.048728617e-02f, -3.047910760e-02f, -3.047087714e-02f, -3.046259481e-02f, -3.045426062e-02f, -3.044587461e-02f,
-3.043743678e-02f, -3.042894715e-02f, -3.042040575e-02f, -3.041181259e-02f, -3.040316770e-02f, -3.039447109e-02f, -3.038572279e-02f, -3.037692281e-02f, -3.036807117e-02f, -3.035916790e-02f,
-3.035021301e-02f, -3.034120653e-02f, -3.033214847e-02f, -3.032303886e-02f, -3.031387771e-02f, -3.030466505e-02f, -3.029540090e-02f, -3.028608528e-02f, -3.027671820e-02f, -3.026729969e-02f,
-3.025782978e-02f, -3.024830848e-02f, -3.023873581e-02f, -3.022911180e-02f, -3.021943646e-02f, -3.020970982e-02f, -3.019993190e-02f, -3.019010273e-02f, -3.018022231e-02f, -3.017029068e-02f,
-3.016030786e-02f, -3.015027387e-02f, -3.014018872e-02f, -3.013005245e-02f, -3.011986508e-02f, -3.010962662e-02f, -3.009933711e-02f, -3.008899655e-02f, -3.007860498e-02f, -3.006816242e-02f,
-3.005766890e-02f, -3.004712442e-02f, -3.003652902e-02f, -3.002588273e-02f, -3.001518555e-02f, -3.000443752e-02f, -2.999363866e-02f, -2.998278900e-02f, -2.997188855e-02f, -2.996093734e-02f,
-2.994993540e-02f, -2.993888274e-02f, -2.992777939e-02f, -2.991662538e-02f, -2.990542073e-02f, -2.989416546e-02f, -2.988285960e-02f, -2.987150317e-02f, -2.986009620e-02f, -2.984863871e-02f,
-2.983713072e-02f, -2.982557226e-02f, -2.981396336e-02f, -2.980230403e-02f, -2.979059431e-02f, -2.977883422e-02f, -2.976702379e-02f, -2.975516303e-02f, -2.974325197e-02f, -2.973129065e-02f,
-2.971927908e-02f, -2.970721729e-02f, -2.969510530e-02f, -2.968294315e-02f, -2.967073086e-02f, -2.965846844e-02f, -2.964615594e-02f, -2.963379337e-02f, -2.962138076e-02f, -2.960891814e-02f,
-2.959640553e-02f, -2.958384296e-02f, -2.957123045e-02f, -2.955856804e-02f, -2.954585575e-02f, -2.953309360e-02f, -2.952028162e-02f, -2.950741984e-02f, -2.949450829e-02f, -2.948154699e-02f,
-2.946853597e-02f, -2.945547525e-02f, -2.944236487e-02f, -2.942920485e-02f, -2.941599522e-02f, -2.940273601e-02f, -2.938942723e-02f, -2.937606893e-02f, -2.936266113e-02f, -2.934920385e-02f,
-2.933569713e-02f, -2.932214099e-02f, -2.930853546e-02f, -2.929488057e-02f, -2.928117634e-02f, -2.926742281e-02f, -2.925362000e-02f, -2.923976795e-02f, -2.922586667e-02f, -2.921191620e-02f,
-2.919791657e-02f, -2.918386781e-02f, -2.916976994e-02f, -2.915562299e-02f, -2.914142700e-02f, -2.912718199e-02f, -2.911288798e-02f, -2.909854502e-02f, -2.908415313e-02f, -2.906971234e-02f,
-2.905522268e-02f, -2.904068417e-02f, -2.902609686e-02f, -2.901146076e-02f, -2.899677590e-02f, -2.898204233e-02f, -2.896726006e-02f, -2.895242913e-02f, -2.893754957e-02f, -2.892262140e-02f,
-2.890764466e-02f, -2.889261938e-02f, -2.887754559e-02f, -2.886242332e-02f, -2.884725259e-02f, -2.883203345e-02f, -2.881676592e-02f, -2.880145003e-02f, -2.878608582e-02f, -2.877067331e-02f,
-2.875521253e-02f, -2.873970352e-02f, -2.872414631e-02f, -2.870854093e-02f, -2.869288740e-02f, -2.867718577e-02f, -2.866143607e-02f, -2.864563832e-02f, -2.862979255e-02f, -2.861389881e-02f,
-2.859795711e-02f, -2.858196750e-02f, -2.856593000e-02f, -2.854984465e-02f, -2.853371148e-02f, -2.851753052e-02f, -2.850130181e-02f, -2.848502537e-02f, -2.846870124e-02f, -2.845232945e-02f,
-2.843591003e-02f, -2.841944302e-02f, -2.840292846e-02f, -2.838636636e-02f, -2.836975677e-02f, -2.835309972e-02f, -2.833639524e-02f, -2.831964336e-02f, -2.830284413e-02f, -2.828599757e-02f,
-2.826910371e-02f, -2.825216259e-02f, -2.823517424e-02f, -2.821813870e-02f, -2.820105600e-02f, -2.818392618e-02f, -2.816674926e-02f, -2.814952528e-02f, -2.813225428e-02f, -2.811493629e-02f,
-2.809757135e-02f, -2.808015948e-02f, -2.806270073e-02f, -2.804519512e-02f, -2.802764270e-02f, -2.801004349e-02f, -2.799239754e-02f, -2.797470487e-02f, -2.795696553e-02f, -2.793917954e-02f,
-2.792134694e-02f, -2.790346777e-02f, -2.788554206e-02f, -2.786756985e-02f, -2.784955116e-02f, -2.783148605e-02f, -2.781337454e-02f, -2.779521667e-02f, -2.777701248e-02f, -2.775876199e-02f,
-2.774046525e-02f, -2.772212229e-02f, -2.770373315e-02f, -2.768529787e-02f, -2.766681647e-02f, -2.764828900e-02f, -2.762971549e-02f, -2.761109598e-02f, -2.759243051e-02f, -2.757371911e-02f,
-2.755496181e-02f, -2.753615866e-02f, -2.751730970e-02f, -2.749841495e-02f, -2.747947445e-02f, -2.746048825e-02f, -2.744145638e-02f, -2.742237887e-02f, -2.740325577e-02f, -2.738408710e-02f,
-2.736487292e-02f, -2.734561325e-02f, -2.732630813e-02f, -2.730695761e-02f, -2.728756171e-02f, -2.726812048e-02f, -2.724863395e-02f, -2.722910216e-02f, -2.720952515e-02f, -2.718990296e-02f,
-2.717023563e-02f, -2.715052318e-02f, -2.713076567e-02f, -2.711096313e-02f, -2.709111560e-02f, -2.707122311e-02f, -2.705128571e-02f, -2.703130343e-02f, -2.701127631e-02f, -2.699120440e-02f,
-2.697108772e-02f, -2.695092633e-02f, -2.693072025e-02f, -2.691046953e-02f, -2.689017420e-02f, -2.686983431e-02f, -2.684944990e-02f, -2.682902099e-02f, -2.680854764e-02f, -2.678802988e-02f,
-2.676746776e-02f, -2.674686130e-02f, -2.672621056e-02f, -2.670551557e-02f, -2.668477636e-02f, -2.666399299e-02f, -2.664316549e-02f, -2.662229390e-02f, -2.660137826e-02f, -2.658041861e-02f,
-2.655941499e-02f, -2.653836745e-02f, -2.651727601e-02f, -2.649614073e-02f, -2.647496164e-02f, -2.645373879e-02f, -2.643247220e-02f, -2.641116194e-02f, -2.638980803e-02f, -2.636841051e-02f,
-2.634696943e-02f, -2.632548484e-02f, -2.630395676e-02f, -2.628238524e-02f, -2.626077032e-02f, -2.623911205e-02f, -2.621741046e-02f, -2.619566560e-02f, -2.617387751e-02f, -2.615204623e-02f,
-2.613017179e-02f, -2.610825425e-02f, -2.608629365e-02f, -2.606429002e-02f, -2.604224341e-02f, -2.602015386e-02f, -2.599802141e-02f, -2.597584611e-02f, -2.595362800e-02f, -2.593136711e-02f,
-2.590906350e-02f, -2.588671720e-02f, -2.586432825e-02f, -2.584189671e-02f, -2.581942261e-02f, -2.579690599e-02f, -2.577434690e-02f, -2.575174538e-02f, -2.572910148e-02f, -2.570641523e-02f,
-2.568368668e-02f, -2.566091587e-02f, -2.563810285e-02f, -2.561524765e-02f, -2.559235033e-02f, -2.556941092e-02f, -2.554642948e-02f, -2.552340603e-02f, -2.550034064e-02f, -2.547723333e-02f,
-2.545408416e-02f, -2.543089316e-02f, -2.540766038e-02f, -2.538438588e-02f, -2.536106968e-02f, -2.533771183e-02f, -2.531431238e-02f, -2.529087137e-02f, -2.526738885e-02f, -2.524386486e-02f,
-2.522029945e-02f, -2.519669265e-02f, -2.517304452e-02f, -2.514935510e-02f, -2.512562443e-02f, -2.510185256e-02f, -2.507803953e-02f, -2.505418539e-02f, -2.503029018e-02f, -2.500635395e-02f,
-2.498237674e-02f, -2.495835860e-02f, -2.493429958e-02f, -2.491019971e-02f, -2.488605905e-02f, -2.486187763e-02f, -2.483765551e-02f, -2.481339274e-02f, -2.478908934e-02f, -2.476474538e-02f,
-2.474036090e-02f, -2.471593594e-02f, -2.469147055e-02f, -2.466696478e-02f, -2.464241866e-02f, -2.461783226e-02f, -2.459320560e-02f, -2.456853875e-02f, -2.454383174e-02f, -2.451908463e-02f,
-2.449429745e-02f, -2.446947026e-02f, -2.444460310e-02f, -2.441969602e-02f, -2.439474906e-02f, -2.436976227e-02f, -2.434473571e-02f, -2.431966941e-02f, -2.429456342e-02f, -2.426941779e-02f,
-2.424423256e-02f, -2.421900779e-02f, -2.419374352e-02f, -2.416843980e-02f, -2.414309667e-02f, -2.411771419e-02f, -2.409229240e-02f, -2.406683134e-02f, -2.404133107e-02f, -2.401579163e-02f,
-2.399021307e-02f, -2.396459544e-02f, -2.393893878e-02f, -2.391324315e-02f, -2.388750859e-02f, -2.386173515e-02f, -2.383592288e-02f, -2.381007182e-02f, -2.378418202e-02f, -2.375825354e-02f,
-2.373228642e-02f, -2.370628071e-02f, -2.368023646e-02f, -2.365415371e-02f, -2.362803251e-02f, -2.360187292e-02f, -2.357567498e-02f, -2.354943874e-02f, -2.352316425e-02f, -2.349685156e-02f,
-2.347050072e-02f, -2.344411177e-02f, -2.341768476e-02f, -2.339121975e-02f, -2.336471679e-02f, -2.333817591e-02f, -2.331159718e-02f, -2.328498064e-02f, -2.325832634e-02f, -2.323163433e-02f,
-2.320490466e-02f, -2.317813738e-02f, -2.315133253e-02f, -2.312449018e-02f, -2.309761036e-02f, -2.307069313e-02f, -2.304373854e-02f, -2.301674664e-02f, -2.298971748e-02f, -2.296265110e-02f,
-2.293554756e-02f, -2.290840691e-02f, -2.288122920e-02f, -2.285401448e-02f, -2.282676280e-02f, -2.279947420e-02f, -2.277214875e-02f, -2.274478649e-02f, -2.271738747e-02f, -2.268995174e-02f,
-2.266247935e-02f, -2.263497036e-02f, -2.260742481e-02f, -2.257984276e-02f, -2.255222425e-02f, -2.252456934e-02f, -2.249687808e-02f, -2.246915051e-02f, -2.244138670e-02f, -2.241358669e-02f,
-2.238575053e-02f, -2.235787828e-02f, -2.232996998e-02f, -2.230202570e-02f, -2.227404546e-02f, -2.224602934e-02f, -2.221797739e-02f, -2.218988964e-02f, -2.216176616e-02f, -2.213360700e-02f,
-2.210541221e-02f, -2.207718184e-02f, -2.204891594e-02f, -2.202061456e-02f, -2.199227777e-02f, -2.196390560e-02f, -2.193549812e-02f, -2.190705537e-02f, -2.187857740e-02f, -2.185006427e-02f,
-2.182151604e-02f, -2.179293275e-02f, -2.176431445e-02f, -2.173566120e-02f, -2.170697306e-02f, -2.167825006e-02f, -2.164949228e-02f, -2.162069975e-02f, -2.159187254e-02f, -2.156301069e-02f,
-2.153411426e-02f, -2.150518330e-02f, -2.147621787e-02f, -2.144721801e-02f, -2.141818378e-02f, -2.138911524e-02f, -2.136001243e-02f, -2.133087542e-02f, -2.130170425e-02f, -2.127249898e-02f,
-2.124325966e-02f, -2.121398634e-02f, -2.118467908e-02f, -2.115533793e-02f, -2.112596295e-02f, -2.109655419e-02f, -2.106711170e-02f, -2.103763554e-02f, -2.100812576e-02f, -2.097858242e-02f,
-2.094900556e-02f, -2.091939525e-02f, -2.088975154e-02f, -2.086007447e-02f, -2.083036412e-02f, -2.080062052e-02f, -2.077084374e-02f, -2.074103382e-02f, -2.071119083e-02f, -2.068131482e-02f,
-2.065140584e-02f, -2.062146395e-02f, -2.059148920e-02f, -2.056148165e-02f, -2.053144135e-02f, -2.050136835e-02f, -2.047126272e-02f, -2.044112450e-02f, -2.041095376e-02f, -2.038075054e-02f,
-2.035051490e-02f, -2.032024689e-02f, -2.028994658e-02f, -2.025961402e-02f, -2.022924926e-02f, -2.019885235e-02f, -2.016842336e-02f, -2.013796234e-02f, -2.010746934e-02f, -2.007694441e-02f,
-2.004638763e-02f, -2.001579903e-02f, -1.998517868e-02f, -1.995452664e-02f, -1.992384295e-02f, -1.989312767e-02f, -1.986238087e-02f, -1.983160259e-02f, -1.980079289e-02f, -1.976995182e-02f,
-1.973907946e-02f, -1.970817584e-02f, -1.967724102e-02f, -1.964627507e-02f, -1.961527804e-02f, -1.958424998e-02f, -1.955319096e-02f, -1.952210102e-02f, -1.949098022e-02f, -1.945982863e-02f,
-1.942864629e-02f, -1.939743327e-02f, -1.936618961e-02f, -1.933491538e-02f, -1.930361064e-02f, -1.927227544e-02f, -1.924090983e-02f, -1.920951388e-02f, -1.917808764e-02f, -1.914663117e-02f,
-1.911514453e-02f, -1.908362776e-02f, -1.905208094e-02f, -1.902050411e-02f, -1.898889734e-02f, -1.895726068e-02f, -1.892559418e-02f, -1.889389792e-02f, -1.886217193e-02f, -1.883041629e-02f,
-1.879863104e-02f, -1.876681625e-02f, -1.873497198e-02f, -1.870309827e-02f, -1.867119519e-02f, -1.863926280e-02f, -1.860730116e-02f, -1.857531031e-02f, -1.854329033e-02f, -1.851124126e-02f,
-1.847916317e-02f, -1.844705612e-02f, -1.841492015e-02f, -1.838275534e-02f, -1.835056173e-02f, -1.831833939e-02f, -1.828608837e-02f, -1.825380874e-02f, -1.822150054e-02f, -1.818916385e-02f,
-1.815679871e-02f, -1.812440519e-02f, -1.809198335e-02f, -1.805953324e-02f, -1.802705492e-02f, -1.799454845e-02f, -1.796201389e-02f, -1.792945129e-02f, -1.789686073e-02f, -1.786424224e-02f,
-1.783159591e-02f, -1.779892177e-02f, -1.776621990e-02f, -1.773349035e-02f, -1.770073318e-02f, -1.766794844e-02f, -1.763513621e-02f, -1.760229653e-02f, -1.756942946e-02f, -1.753653508e-02f,
-1.750361342e-02f, -1.747066457e-02f, -1.743768856e-02f, -1.740468547e-02f, -1.737165535e-02f, -1.733859826e-02f, -1.730551426e-02f, -1.727240341e-02f, -1.723926577e-02f, -1.720610140e-02f,
-1.717291037e-02f, -1.713969272e-02f, -1.710644851e-02f, -1.707317782e-02f, -1.703988070e-02f, -1.700655720e-02f, -1.697320739e-02f, -1.693983133e-02f, -1.690642908e-02f, -1.687300070e-02f,
-1.683954624e-02f, -1.680606577e-02f, -1.677255936e-02f, -1.673902704e-02f, -1.670546890e-02f, -1.667188499e-02f, -1.663827537e-02f, -1.660464009e-02f, -1.657097923e-02f, -1.653729283e-02f,
-1.650358097e-02f, -1.646984370e-02f, -1.643608108e-02f, -1.640229317e-02f, -1.636848003e-02f, -1.633464173e-02f, -1.630077833e-02f, -1.626688987e-02f, -1.623297644e-02f, -1.619903808e-02f,
-1.616507485e-02f, -1.613108683e-02f, -1.609707406e-02f, -1.606303662e-02f, -1.602897455e-02f, -1.599488793e-02f, -1.596077681e-02f, -1.592664126e-02f, -1.589248133e-02f, -1.585829708e-02f,
-1.582408859e-02f, -1.578985590e-02f, -1.575559908e-02f, -1.572131819e-02f, -1.568701330e-02f, -1.565268446e-02f, -1.561833174e-02f, -1.558395519e-02f, -1.554955488e-02f, -1.551513087e-02f,
-1.548068323e-02f, -1.544621200e-02f, -1.541171726e-02f, -1.537719907e-02f, -1.534265748e-02f, -1.530809257e-02f, -1.527350438e-02f, -1.523889299e-02f, -1.520425845e-02f, -1.516960083e-02f,
-1.513492019e-02f, -1.510021659e-02f, -1.506549010e-02f, -1.503074076e-02f, -1.499596866e-02f, -1.496117384e-02f, -1.492635637e-02f, -1.489151632e-02f, -1.485665374e-02f, -1.482176870e-02f,
-1.478686126e-02f, -1.475193148e-02f, -1.471697942e-02f, -1.468200515e-02f, -1.464700873e-02f, -1.461199022e-02f, -1.457694969e-02f, -1.454188719e-02f, -1.450680278e-02f, -1.447169654e-02f,
-1.443656853e-02f, -1.440141880e-02f, -1.436624741e-02f, -1.433105444e-02f, -1.429583995e-02f, -1.426060399e-02f, -1.422534663e-02f, -1.419006793e-02f, -1.415476796e-02f, -1.411944677e-02f,
-1.408410444e-02f, -1.404874102e-02f, -1.401335657e-02f, -1.397795117e-02f, -1.394252487e-02f, -1.390707773e-02f, -1.387160982e-02f, -1.383612120e-02f, -1.380061194e-02f, -1.376508210e-02f,
-1.372953174e-02f, -1.369396092e-02f, -1.365836971e-02f, -1.362275817e-02f, -1.358712636e-02f, -1.355147435e-02f, -1.351580220e-02f, -1.348010998e-02f, -1.344439774e-02f, -1.340866556e-02f,
-1.337291349e-02f, -1.333714159e-02f, -1.330134994e-02f, -1.326553859e-02f, -1.322970761e-02f, -1.319385706e-02f, -1.315798701e-02f, -1.312209752e-02f, -1.308618865e-02f, -1.305026047e-02f,
-1.301431303e-02f, -1.297834641e-02f, -1.294236067e-02f, -1.290635587e-02f, -1.287033208e-02f, -1.283428936e-02f, -1.279822776e-02f, -1.276214737e-02f, -1.272604824e-02f, -1.268993043e-02f,
-1.265379401e-02f, -1.261763905e-02f, -1.258146560e-02f, -1.254527373e-02f, -1.250906351e-02f, -1.247283500e-02f, -1.243658826e-02f, -1.240032336e-02f, -1.236404036e-02f, -1.232773933e-02f,
-1.229142033e-02f, -1.225508342e-02f, -1.221872868e-02f, -1.218235615e-02f, -1.214596592e-02f, -1.210955803e-02f, -1.207313256e-02f, -1.203668958e-02f, -1.200022914e-02f, -1.196375131e-02f,
-1.192725615e-02f, -1.189074373e-02f, -1.185421412e-02f, -1.181766737e-02f, -1.178110356e-02f, -1.174452275e-02f, -1.170792499e-02f, -1.167131036e-02f, -1.163467893e-02f, -1.159803075e-02f,
-1.156136589e-02f, -1.152468442e-02f, -1.148798639e-02f, -1.145127189e-02f, -1.141454096e-02f, -1.137779368e-02f, -1.134103010e-02f, -1.130425030e-02f, -1.126745434e-02f, -1.123064229e-02f,
-1.119381420e-02f, -1.115697015e-02f, -1.112011020e-02f, -1.108323441e-02f, -1.104634285e-02f, -1.100943559e-02f, -1.097251269e-02f, -1.093557421e-02f, -1.089862022e-02f, -1.086165078e-02f,
-1.082466597e-02f, -1.078766584e-02f, -1.075065046e-02f, -1.071361990e-02f, -1.067657422e-02f, -1.063951348e-02f, -1.060243776e-02f, -1.056534711e-02f, -1.052824160e-02f, -1.049112131e-02f,
-1.045398628e-02f, -1.041683660e-02f, -1.037967231e-02f, -1.034249350e-02f, -1.030530022e-02f, -1.026809254e-02f, -1.023087053e-02f, -1.019363425e-02f, -1.015638376e-02f, -1.011911914e-02f,
-1.008184044e-02f, -1.004454774e-02f, -1.000724110e-02f, -9.969920579e-03f, -9.932586250e-03f, -9.895238177e-03f, -9.857876425e-03f, -9.820501060e-03f, -9.783112148e-03f, -9.745709755e-03f,
-9.708293946e-03f, -9.670864786e-03f, -9.633422343e-03f, -9.595966681e-03f, -9.558497866e-03f, -9.521015965e-03f, -9.483521042e-03f, -9.446013165e-03f, -9.408492398e-03f, -9.370958807e-03f,
-9.333412460e-03f, -9.295853420e-03f, -9.258281755e-03f, -9.220697531e-03f, -9.183100812e-03f, -9.145491666e-03f, -9.107870158e-03f, -9.070236355e-03f, -9.032590321e-03f, -8.994932124e-03f,
-8.957261830e-03f, -8.919579504e-03f, -8.881885212e-03f, -8.844179021e-03f, -8.806460997e-03f, -8.768731205e-03f, -8.730989713e-03f, -8.693236586e-03f, -8.655471890e-03f, -8.617695691e-03f,
-8.579908057e-03f, -8.542109052e-03f, -8.504298744e-03f, -8.466477198e-03f, -8.428644480e-03f, -8.390800658e-03f, -8.352945796e-03f, -8.315079962e-03f, -8.277203222e-03f, -8.239315642e-03f,
-8.201417289e-03f, -8.163508228e-03f, -8.125588527e-03f, -8.087658251e-03f, -8.049717466e-03f, -8.011766241e-03f, -7.973804639e-03f, -7.935832729e-03f, -7.897850577e-03f, -7.859858248e-03f,
-7.821855810e-03f, -7.783843328e-03f, -7.745820870e-03f, -7.707788502e-03f, -7.669746290e-03f, -7.631694301e-03f, -7.593632601e-03f, -7.555561257e-03f, -7.517480335e-03f, -7.479389903e-03f,
-7.441290026e-03f, -7.403180770e-03f, -7.365062204e-03f, -7.326934393e-03f, -7.288797404e-03f, -7.250651303e-03f, -7.212496157e-03f, -7.174332032e-03f, -7.136158997e-03f, -7.097977116e-03f,
-7.059786456e-03f, -7.021587085e-03f, -6.983379069e-03f, -6.945162475e-03f, -6.906937369e-03f, -6.868703817e-03f, -6.830461888e-03f, -6.792211647e-03f, -6.753953161e-03f, -6.715686497e-03f,
-6.677411722e-03f, -6.639128902e-03f, -6.600838104e-03f, -6.562539396e-03f, -6.524232842e-03f, -6.485918512e-03f, -6.447596470e-03f, -6.409266784e-03f, -6.370929522e-03f, -6.332584749e-03f,
-6.294232532e-03f, -6.255872939e-03f, -6.217506035e-03f, -6.179131889e-03f, -6.140750566e-03f, -6.102362134e-03f, -6.063966660e-03f, -6.025564209e-03f, -5.987154850e-03f, -5.948738649e-03f,
-5.910315673e-03f, -5.871885989e-03f, -5.833449663e-03f, -5.795006763e-03f, -5.756557355e-03f, -5.718101507e-03f, -5.679639285e-03f, -5.641170757e-03f, -5.602695988e-03f, -5.564215046e-03f,
-5.525727999e-03f, -5.487234912e-03f, -5.448735853e-03f, -5.410230889e-03f, -5.371720086e-03f, -5.333203512e-03f, -5.294681234e-03f, -5.256153318e-03f, -5.217619832e-03f, -5.179080842e-03f,
-5.140536416e-03f, -5.101986620e-03f, -5.063431522e-03f, -5.024871188e-03f, -4.986305685e-03f, -4.947735080e-03f, -4.909159441e-03f, -4.870578834e-03f, -4.831993326e-03f, -4.793402985e-03f,
-4.754807877e-03f, -4.716208069e-03f, -4.677603628e-03f, -4.638994621e-03f, -4.600381116e-03f, -4.561763179e-03f, -4.523140877e-03f, -4.484514277e-03f, -4.445883447e-03f, -4.407248453e-03f,
-4.368609362e-03f, -4.329966242e-03f, -4.291319158e-03f, -4.252668179e-03f, -4.214013371e-03f, -4.175354802e-03f, -4.136692538e-03f, -4.098026646e-03f, -4.059357194e-03f, -4.020684248e-03f,
-3.982007875e-03f, -3.943328143e-03f, -3.904645118e-03f, -3.865958867e-03f, -3.827269458e-03f, -3.788576958e-03f, -3.749881433e-03f, -3.711182950e-03f, -3.672481577e-03f, -3.633777380e-03f,
-3.595070426e-03f, -3.556360783e-03f, -3.517648518e-03f, -3.478933697e-03f, -3.440216388e-03f, -3.401496657e-03f, -3.362774571e-03f, -3.324050198e-03f, -3.285323604e-03f, -3.246594857e-03f,
-3.207864023e-03f, -3.169131170e-03f, -3.130396364e-03f, -3.091659673e-03f, -3.052921162e-03f, -3.014180900e-03f, -2.975438954e-03f, -2.936695390e-03f, -2.897950274e-03f, -2.859203675e-03f,
-2.820455660e-03f, -2.781706294e-03f, -2.742955645e-03f, -2.704203781e-03f, -2.665450767e-03f, -2.626696671e-03f, -2.587941560e-03f, -2.549185501e-03f, -2.510428560e-03f, -2.471670805e-03f,
-2.432912302e-03f, -2.394153119e-03f, -2.355393322e-03f, -2.316632978e-03f, -2.277872155e-03f, -2.239110918e-03f, -2.200349335e-03f, -2.161587473e-03f, -2.122825399e-03f, -2.084063179e-03f,
-2.045300880e-03f, -2.006538570e-03f, -1.967776315e-03f, -1.929014181e-03f, -1.890252237e-03f, -1.851490548e-03f, -1.812729181e-03f, -1.773968204e-03f, -1.735207682e-03f, -1.696447684e-03f,
-1.657688275e-03f, -1.618929522e-03f, -1.580171493e-03f, -1.541414254e-03f, -1.502657871e-03f, -1.463902412e-03f, -1.425147944e-03f, -1.386394532e-03f, -1.347642244e-03f, -1.308891146e-03f,
-1.270141306e-03f, -1.231392790e-03f, -1.192645664e-03f, -1.153899996e-03f, -1.115155851e-03f, -1.076413297e-03f, -1.037672401e-03f, -9.989332286e-04f, -9.601958469e-04f, -9.214603226e-04f,
-8.827267222e-04f, -8.439951123e-04f, -8.052655597e-04f, -7.665381308e-04f, -7.278128924e-04f, -6.890899109e-04f, -6.503692530e-04f, -6.116509852e-04f, -5.729351741e-04f, -5.342218863e-04f,
-4.955111882e-04f, -4.568031464e-04f, -4.180978274e-04f, -3.793952977e-04f, -3.406956238e-04f, -3.019988722e-04f, -2.633051094e-04f, -2.246144017e-04f, -1.859268158e-04f, -1.472424179e-04f,
-1.085612746e-04f, -6.988345225e-05f, -3.120901722e-05f, 7.461964059e-06f, 4.612942522e-05f, 8.479329990e-05f, 1.234535217e-04f, 1.621100244e-04f, 2.007627415e-04f, 2.394116069e-04f,
2.780565540e-04f, 3.166975168e-04f, 3.553344288e-04f, 3.939672239e-04f, 4.325958357e-04f, 4.712201981e-04f, 5.098402448e-04f, 5.484559096e-04f, 5.870671263e-04f, 6.256738286e-04f,
6.642759506e-04f, 7.028734259e-04f, 7.414661884e-04f, 7.800541720e-04f, 8.186373106e-04f, 8.572155381e-04f, 8.957887884e-04f, 9.343569954e-04f, 9.729200931e-04f, 1.011478015e-03f,
1.050030696e-03f, 1.088578070e-03f, 1.127120070e-03f, 1.165656631e-03f, 1.204187686e-03f, 1.242713170e-03f, 1.281233017e-03f, 1.319747160e-03f, 1.358255535e-03f, 1.396758074e-03f,
1.435254713e-03f, 1.473745385e-03f, 1.512230024e-03f, 1.550708565e-03f, 1.589180942e-03f, 1.627647089e-03f, 1.666106940e-03f, 1.704560429e-03f, 1.743007492e-03f, 1.781448061e-03f,
1.819882072e-03f, 1.858309458e-03f, 1.896730154e-03f, 1.935144095e-03f, 1.973551214e-03f, 2.011951446e-03f, 2.050344726e-03f, 2.088730988e-03f, 2.127110165e-03f, 2.165482194e-03f,
2.203847008e-03f, 2.242204541e-03f, 2.280554729e-03f, 2.318897505e-03f, 2.357232805e-03f, 2.395560563e-03f, 2.433880713e-03f, 2.472193190e-03f, 2.510497928e-03f, 2.548794863e-03f,
2.587083929e-03f, 2.625365061e-03f, 2.663638192e-03f, 2.701903259e-03f, 2.740160196e-03f, 2.778408937e-03f, 2.816649417e-03f, 2.854881572e-03f, 2.893105335e-03f, 2.931320642e-03f,
2.969527428e-03f, 3.007725627e-03f, 3.045915175e-03f, 3.084096006e-03f, 3.122268055e-03f, 3.160431257e-03f, 3.198585548e-03f, 3.236730862e-03f, 3.274867134e-03f, 3.312994299e-03f,
3.351112293e-03f, 3.389221050e-03f, 3.427320505e-03f, 3.465410594e-03f, 3.503491252e-03f, 3.541562414e-03f, 3.579624015e-03f, 3.617675991e-03f, 3.655718276e-03f, 3.693750807e-03f,
3.731773517e-03f, 3.769786343e-03f, 3.807789220e-03f, 3.845782083e-03f, 3.883764868e-03f, 3.921737509e-03f, 3.959699943e-03f, 3.997652106e-03f, 4.035593931e-03f, 4.073525355e-03f,
4.111446314e-03f, 4.149356742e-03f, 4.187256576e-03f, 4.225145752e-03f, 4.263024204e-03f, 4.300891868e-03f, 4.338748680e-03f, 4.376594576e-03f, 4.414429491e-03f, 4.452253362e-03f,
4.490066123e-03f, 4.527867712e-03f, 4.565658062e-03f, 4.603437112e-03f, 4.641204795e-03f, 4.678961048e-03f, 4.716705808e-03f, 4.754439010e-03f, 4.792160589e-03f, 4.829870483e-03f,
4.867568626e-03f, 4.905254955e-03f, 4.942929407e-03f, 4.980591917e-03f, 5.018242421e-03f, 5.055880855e-03f, 5.093507156e-03f, 5.131121260e-03f, 5.168723103e-03f, 5.206312622e-03f,
5.243889752e-03f, 5.281454430e-03f, 5.319006592e-03f, 5.356546174e-03f, 5.394073114e-03f, 5.431587347e-03f, 5.469088811e-03f, 5.506577440e-03f, 5.544053172e-03f, 5.581515944e-03f,
5.618965692e-03f, 5.656402352e-03f, 5.693825861e-03f, 5.731236157e-03f, 5.768633174e-03f, 5.806016851e-03f, 5.843387124e-03f, 5.880743929e-03f, 5.918087204e-03f, 5.955416885e-03f,
5.992732909e-03f, 6.030035214e-03f, 6.067323735e-03f, 6.104598410e-03f, 6.141859175e-03f, 6.179105969e-03f, 6.216338727e-03f, 6.253557387e-03f, 6.290761886e-03f, 6.327952161e-03f,
6.365128150e-03f, 6.402289788e-03f, 6.439437015e-03f, 6.476569766e-03f, 6.513687979e-03f, 6.550791591e-03f, 6.587880540e-03f, 6.624954763e-03f, 6.662014198e-03f, 6.699058781e-03f,
6.736088451e-03f, 6.773103145e-03f, 6.810102799e-03f, 6.847087353e-03f, 6.884056743e-03f, 6.921010907e-03f, 6.957949783e-03f, 6.994873308e-03f, 7.031781420e-03f, 7.068674057e-03f,
7.105551156e-03f, 7.142412655e-03f, 7.179258493e-03f, 7.216088607e-03f, 7.252902935e-03f, 7.289701414e-03f, 7.326483984e-03f, 7.363250581e-03f, 7.400001144e-03f, 7.436735611e-03f,
7.473453920e-03f, 7.510156009e-03f, 7.546841816e-03f, 7.583511280e-03f, 7.620164338e-03f, 7.656800930e-03f, 7.693420992e-03f, 7.730024465e-03f, 7.766611285e-03f, 7.803181392e-03f,
7.839734723e-03f, 7.876271218e-03f, 7.912790814e-03f, 7.949293451e-03f, 7.985779067e-03f, 8.022247600e-03f, 8.058698989e-03f, 8.095133173e-03f, 8.131550090e-03f, 8.167949680e-03f,
8.204331881e-03f, 8.240696632e-03f, 8.277043871e-03f, 8.313373538e-03f, 8.349685572e-03f, 8.385979911e-03f, 8.422256495e-03f, 8.458515262e-03f, 8.494756151e-03f, 8.530979103e-03f,
8.567184055e-03f, 8.603370947e-03f, 8.639539718e-03f, 8.675690308e-03f, 8.711822656e-03f, 8.747936701e-03f, 8.784032382e-03f, 8.820109639e-03f, 8.856168411e-03f, 8.892208638e-03f,
8.928230259e-03f, 8.964233215e-03f, 9.000217443e-03f, 9.036182885e-03f, 9.072129479e-03f, 9.108057166e-03f, 9.143965884e-03f, 9.179855575e-03f, 9.215726177e-03f, 9.251577631e-03f,
9.287409877e-03f, 9.323222853e-03f, 9.359016501e-03f, 9.394790761e-03f, 9.430545572e-03f, 9.466280874e-03f, 9.501996608e-03f, 9.537692713e-03f, 9.573369131e-03f, 9.609025801e-03f,
9.644662663e-03f, 9.680279658e-03f, 9.715876726e-03f, 9.751453808e-03f, 9.787010844e-03f, 9.822547774e-03f, 9.858064539e-03f, 9.893561080e-03f, 9.929037337e-03f, 9.964493250e-03f,
9.999928761e-03f, 1.003534381e-02f, 1.007073834e-02f, 1.010611229e-02f, 1.014146560e-02f, 1.017679821e-02f, 1.021211006e-02f, 1.024740109e-02f, 1.028267125e-02f, 1.031792048e-02f,
1.035314871e-02f, 1.038835589e-02f, 1.042354196e-02f, 1.045870686e-02f, 1.049385052e-02f, 1.052897291e-02f, 1.056407394e-02f, 1.059915357e-02f, 1.063421174e-02f, 1.066924839e-02f,
1.070426345e-02f, 1.073925688e-02f, 1.077422861e-02f, 1.080917858e-02f, 1.084410674e-02f, 1.087901303e-02f, 1.091389739e-02f, 1.094875975e-02f, 1.098360008e-02f, 1.101841829e-02f,
1.105321435e-02f, 1.108798818e-02f, 1.112273973e-02f, 1.115746895e-02f, 1.119217577e-02f, 1.122686014e-02f, 1.126152200e-02f, 1.129616129e-02f, 1.133077795e-02f, 1.136537194e-02f,
1.139994318e-02f, 1.143449162e-02f, 1.146901720e-02f, 1.150351987e-02f, 1.153799957e-02f, 1.157245624e-02f, 1.160688983e-02f, 1.164130027e-02f, 1.167568751e-02f, 1.171005149e-02f,
1.174439216e-02f, 1.177870945e-02f, 1.181300332e-02f, 1.184727370e-02f, 1.188152054e-02f, 1.191574377e-02f, 1.194994335e-02f, 1.198411922e-02f, 1.201827131e-02f, 1.205239958e-02f,
1.208650396e-02f, 1.212058440e-02f, 1.215464084e-02f, 1.218867323e-02f, 1.222268151e-02f, 1.225666562e-02f, 1.229062551e-02f, 1.232456111e-02f, 1.235847238e-02f, 1.239235926e-02f,
1.242622169e-02f, 1.246005961e-02f, 1.249387298e-02f, 1.252766172e-02f, 1.256142579e-02f, 1.259516513e-02f, 1.262887969e-02f, 1.266256940e-02f, 1.269623422e-02f, 1.272987408e-02f,
1.276348893e-02f, 1.279707872e-02f, 1.283064339e-02f, 1.286418288e-02f, 1.289769714e-02f, 1.293118612e-02f, 1.296464975e-02f, 1.299808798e-02f, 1.303150076e-02f, 1.306488803e-02f,
1.309824973e-02f, 1.313158582e-02f, 1.316489623e-02f, 1.319818091e-02f, 1.323143981e-02f, 1.326467287e-02f, 1.329788003e-02f, 1.333106124e-02f, 1.336421645e-02f, 1.339734560e-02f,
1.343044863e-02f, 1.346352549e-02f, 1.349657613e-02f, 1.352960049e-02f, 1.356259852e-02f, 1.359557016e-02f, 1.362851536e-02f, 1.366143406e-02f, 1.369432621e-02f, 1.372719176e-02f,
1.376003064e-02f, 1.379284281e-02f, 1.382562821e-02f, 1.385838679e-02f, 1.389111850e-02f, 1.392382327e-02f, 1.395650106e-02f, 1.398915181e-02f, 1.402177547e-02f, 1.405437198e-02f,
1.408694129e-02f, 1.411948335e-02f, 1.415199810e-02f, 1.418448549e-02f, 1.421694546e-02f, 1.424937797e-02f, 1.428178295e-02f, 1.431416036e-02f, 1.434651014e-02f, 1.437883224e-02f,
1.441112661e-02f, 1.444339318e-02f, 1.447563192e-02f, 1.450784276e-02f, 1.454002565e-02f, 1.457218054e-02f, 1.460430738e-02f, 1.463640611e-02f, 1.466847668e-02f, 1.470051904e-02f,
1.473253314e-02f, 1.476451891e-02f, 1.479647632e-02f, 1.482840531e-02f, 1.486030582e-02f, 1.489217780e-02f, 1.492402120e-02f, 1.495583597e-02f, 1.498762205e-02f, 1.501937940e-02f,
1.505110796e-02f, 1.508280767e-02f, 1.511447849e-02f, 1.514612037e-02f, 1.517773325e-02f, 1.520931708e-02f, 1.524087181e-02f, 1.527239738e-02f, 1.530389375e-02f, 1.533536087e-02f,
1.536679867e-02f, 1.539820712e-02f, 1.542958615e-02f, 1.546093572e-02f, 1.549225578e-02f, 1.552354627e-02f, 1.555480714e-02f, 1.558603835e-02f, 1.561723983e-02f, 1.564841154e-02f,
1.567955344e-02f, 1.571066546e-02f, 1.574174755e-02f, 1.577279967e-02f, 1.580382177e-02f, 1.583481378e-02f, 1.586577567e-02f, 1.589670739e-02f, 1.592760887e-02f, 1.595848008e-02f,
1.598932095e-02f, 1.602013144e-02f, 1.605091151e-02f, 1.608166109e-02f, 1.611238014e-02f, 1.614306861e-02f, 1.617372645e-02f, 1.620435360e-02f, 1.623495003e-02f, 1.626551567e-02f,
1.629605048e-02f, 1.632655440e-02f, 1.635702740e-02f, 1.638746941e-02f, 1.641788039e-02f, 1.644826029e-02f, 1.647860906e-02f, 1.650892665e-02f, 1.653921301e-02f, 1.656946809e-02f,
1.659969184e-02f, 1.662988422e-02f, 1.666004516e-02f, 1.669017463e-02f, 1.672027258e-02f, 1.675033895e-02f, 1.678037369e-02f, 1.681037677e-02f, 1.684034812e-02f, 1.687028770e-02f,
1.690019546e-02f, 1.693007135e-02f, 1.695991533e-02f, 1.698972734e-02f, 1.701950734e-02f, 1.704925527e-02f, 1.707897110e-02f, 1.710865476e-02f, 1.713830622e-02f, 1.716792542e-02f,
1.719751232e-02f, 1.722706686e-02f, 1.725658901e-02f, 1.728607870e-02f, 1.731553590e-02f, 1.734496056e-02f, 1.737435262e-02f, 1.740371204e-02f, 1.743303878e-02f, 1.746233278e-02f,
1.749159399e-02f, 1.752082238e-02f, 1.755001789e-02f, 1.757918047e-02f, 1.760831008e-02f, 1.763740668e-02f, 1.766647020e-02f, 1.769550061e-02f, 1.772449786e-02f, 1.775346189e-02f,
1.778239268e-02f, 1.781129016e-02f, 1.784015429e-02f, 1.786898502e-02f, 1.789778232e-02f, 1.792654612e-02f, 1.795527638e-02f, 1.798397307e-02f, 1.801263612e-02f, 1.804126550e-02f,
1.806986115e-02f, 1.809842304e-02f, 1.812695111e-02f, 1.815544532e-02f, 1.818390563e-02f, 1.821233198e-02f, 1.824072433e-02f, 1.826908264e-02f, 1.829740685e-02f, 1.832569693e-02f,
1.835395283e-02f, 1.838217450e-02f, 1.841036189e-02f, 1.843851497e-02f, 1.846663368e-02f, 1.849471798e-02f, 1.852276782e-02f, 1.855078316e-02f, 1.857876396e-02f, 1.860671016e-02f,
1.863462173e-02f, 1.866249862e-02f, 1.869034078e-02f, 1.871814817e-02f, 1.874592074e-02f, 1.877365845e-02f, 1.880136125e-02f, 1.882902911e-02f, 1.885666197e-02f, 1.888425979e-02f,
1.891182252e-02f, 1.893935013e-02f, 1.896684256e-02f, 1.899429977e-02f, 1.902172173e-02f, 1.904910838e-02f, 1.907645967e-02f, 1.910377558e-02f, 1.913105604e-02f, 1.915830103e-02f,
1.918551049e-02f, 1.921268438e-02f, 1.923982265e-02f, 1.926692527e-02f, 1.929399219e-02f, 1.932102337e-02f, 1.934801876e-02f, 1.937497831e-02f, 1.940190200e-02f, 1.942878976e-02f,
1.945564157e-02f, 1.948245737e-02f, 1.950923713e-02f, 1.953598080e-02f, 1.956268833e-02f, 1.958935969e-02f, 1.961599483e-02f, 1.964259371e-02f, 1.966915629e-02f, 1.969568252e-02f,
1.972217236e-02f, 1.974862577e-02f, 1.977504271e-02f, 1.980142314e-02f, 1.982776700e-02f, 1.985407426e-02f, 1.988034489e-02f, 1.990657882e-02f, 1.993277604e-02f, 1.995893648e-02f,
1.998506011e-02f, 2.001114689e-02f, 2.003719678e-02f, 2.006320973e-02f, 2.008918571e-02f, 2.011512467e-02f, 2.014102656e-02f, 2.016689136e-02f, 2.019271901e-02f, 2.021850948e-02f,
2.024426273e-02f, 2.026997871e-02f, 2.029565738e-02f, 2.032129870e-02f, 2.034690264e-02f, 2.037246915e-02f, 2.039799818e-02f, 2.042348970e-02f, 2.044894368e-02f, 2.047436005e-02f,
2.049973880e-02f, 2.052507987e-02f, 2.055038323e-02f, 2.057564884e-02f, 2.060087665e-02f, 2.062606662e-02f, 2.065121873e-02f, 2.067633291e-02f, 2.070140915e-02f, 2.072644738e-02f,
2.075144759e-02f, 2.077640972e-02f, 2.080133374e-02f, 2.082621960e-02f, 2.085106727e-02f, 2.087587671e-02f, 2.090064788e-02f, 2.092538073e-02f, 2.095007524e-02f, 2.097473135e-02f,
2.099934904e-02f, 2.102392826e-02f, 2.104846898e-02f, 2.107297114e-02f, 2.109743473e-02f, 2.112185969e-02f, 2.114624599e-02f, 2.117059359e-02f, 2.119490245e-02f, 2.121917253e-02f,
2.124340379e-02f, 2.126759621e-02f, 2.129174973e-02f, 2.131586432e-02f, 2.133993994e-02f, 2.136397655e-02f, 2.138797412e-02f, 2.141193260e-02f, 2.143585197e-02f, 2.145973218e-02f,
2.148357319e-02f, 2.150737496e-02f, 2.153113747e-02f, 2.155486066e-02f, 2.157854451e-02f, 2.160218898e-02f, 2.162579402e-02f, 2.164935961e-02f, 2.167288570e-02f, 2.169637226e-02f,
2.171981925e-02f, 2.174322663e-02f, 2.176659437e-02f, 2.178992243e-02f, 2.181321078e-02f, 2.183645937e-02f, 2.185966816e-02f, 2.188283714e-02f, 2.190596625e-02f, 2.192905546e-02f,
2.195210473e-02f, 2.197511404e-02f, 2.199808333e-02f, 2.202101259e-02f, 2.204390176e-02f, 2.206675081e-02f, 2.208955972e-02f, 2.211232843e-02f, 2.213505693e-02f, 2.215774516e-02f,
2.218039310e-02f, 2.220300071e-02f, 2.222556796e-02f, 2.224809480e-02f, 2.227058121e-02f, 2.229302714e-02f, 2.231543257e-02f, 2.233779746e-02f, 2.236012178e-02f, 2.238240548e-02f,
2.240464853e-02f, 2.242685091e-02f, 2.244901256e-02f, 2.247113347e-02f, 2.249321360e-02f, 2.251525290e-02f, 2.253725135e-02f, 2.255920891e-02f, 2.258112555e-02f, 2.260300124e-02f,
2.262483593e-02f, 2.264662960e-02f, 2.266838221e-02f, 2.269009373e-02f, 2.271176412e-02f, 2.273339335e-02f, 2.275498139e-02f, 2.277652820e-02f, 2.279803375e-02f, 2.281949801e-02f,
2.284092094e-02f, 2.286230251e-02f, 2.288364268e-02f, 2.290494143e-02f, 2.292619872e-02f, 2.294741451e-02f, 2.296858878e-02f, 2.298972149e-02f, 2.301081260e-02f, 2.303186210e-02f,
2.305286993e-02f, 2.307383608e-02f, 2.309476050e-02f, 2.311564317e-02f, 2.313648405e-02f, 2.315728311e-02f, 2.317804033e-02f, 2.319875566e-02f, 2.321942907e-02f, 2.324006053e-02f,
2.326065002e-02f, 2.328119750e-02f, 2.330170293e-02f, 2.332216629e-02f, 2.334258754e-02f, 2.336296666e-02f, 2.338330360e-02f, 2.340359835e-02f, 2.342385086e-02f, 2.344406111e-02f,
2.346422907e-02f, 2.348435471e-02f, 2.350443798e-02f, 2.352447887e-02f, 2.354447735e-02f, 2.356443337e-02f, 2.358434692e-02f, 2.360421795e-02f, 2.362404645e-02f, 2.364383238e-02f,
2.366357570e-02f, 2.368327639e-02f, 2.370293443e-02f, 2.372254977e-02f, 2.374212239e-02f, 2.376165225e-02f, 2.378113934e-02f, 2.380058362e-02f, 2.381998505e-02f, 2.383934361e-02f,
2.385865928e-02f, 2.387793201e-02f, 2.389716178e-02f, 2.391634857e-02f, 2.393549233e-02f, 2.395459305e-02f, 2.397365070e-02f, 2.399266523e-02f, 2.401163664e-02f, 2.403056488e-02f,
2.404944993e-02f, 2.406829175e-02f, 2.408709033e-02f, 2.410584563e-02f, 2.412455762e-02f, 2.414322628e-02f, 2.416185158e-02f, 2.418043348e-02f, 2.419897196e-02f, 2.421746699e-02f,
2.423591855e-02f, 2.425432660e-02f, 2.427269113e-02f, 2.429101209e-02f, 2.430928946e-02f, 2.432752322e-02f, 2.434571333e-02f, 2.436385978e-02f, 2.438196252e-02f, 2.440002155e-02f,
2.441803681e-02f, 2.443600830e-02f, 2.445393598e-02f, 2.447181983e-02f, 2.448965982e-02f, 2.450745592e-02f, 2.452520810e-02f, 2.454291634e-02f, 2.456058062e-02f, 2.457820090e-02f,
2.459577716e-02f, 2.461330937e-02f, 2.463079750e-02f, 2.464824154e-02f, 2.466564145e-02f, 2.468299721e-02f, 2.470030878e-02f, 2.471757616e-02f, 2.473479930e-02f, 2.475197819e-02f,
2.476911279e-02f, 2.478620309e-02f, 2.480324905e-02f, 2.482025066e-02f, 2.483720788e-02f, 2.485412069e-02f, 2.487098907e-02f, 2.488781298e-02f, 2.490459242e-02f, 2.492132734e-02f,
2.493801772e-02f, 2.495466355e-02f, 2.497126479e-02f, 2.498782143e-02f, 2.500433342e-02f, 2.502080076e-02f, 2.503722342e-02f, 2.505360137e-02f, 2.506993459e-02f, 2.508622305e-02f,
2.510246673e-02f, 2.511866561e-02f, 2.513481966e-02f, 2.515092886e-02f, 2.516699318e-02f, 2.518301260e-02f, 2.519898710e-02f, 2.521491666e-02f, 2.523080124e-02f, 2.524664082e-02f,
2.526243540e-02f, 2.527818493e-02f, 2.529388939e-02f, 2.530954877e-02f, 2.532516304e-02f, 2.534073218e-02f, 2.535625616e-02f, 2.537173496e-02f, 2.538716857e-02f, 2.540255694e-02f,
2.541790008e-02f, 2.543319794e-02f, 2.544845051e-02f, 2.546365777e-02f, 2.547881969e-02f, 2.549393625e-02f, 2.550900744e-02f, 2.552403322e-02f, 2.553901358e-02f, 2.555394849e-02f,
2.556883793e-02f, 2.558368189e-02f, 2.559848033e-02f, 2.561323325e-02f, 2.562794061e-02f, 2.564260239e-02f, 2.565721858e-02f, 2.567178914e-02f, 2.568631407e-02f, 2.570079335e-02f,
2.571522694e-02f, 2.572961482e-02f, 2.574395699e-02f, 2.575825341e-02f, 2.577250407e-02f, 2.578670895e-02f, 2.580086802e-02f, 2.581498126e-02f, 2.582904866e-02f, 2.584307019e-02f,
2.585704584e-02f, 2.587097558e-02f, 2.588485940e-02f, 2.589869727e-02f, 2.591248917e-02f, 2.592623509e-02f, 2.593993500e-02f, 2.595358889e-02f, 2.596719674e-02f, 2.598075852e-02f,
2.599427422e-02f, 2.600774381e-02f, 2.602116729e-02f, 2.603454462e-02f, 2.604787580e-02f, 2.606116080e-02f, 2.607439960e-02f, 2.608759218e-02f, 2.610073853e-02f, 2.611383862e-02f,
2.612689245e-02f, 2.613989998e-02f, 2.615286121e-02f, 2.616577610e-02f, 2.617864466e-02f, 2.619146684e-02f, 2.620424265e-02f, 2.621697206e-02f, 2.622965505e-02f, 2.624229161e-02f,
2.625488171e-02f, 2.626742535e-02f, 2.627992249e-02f, 2.629237313e-02f, 2.630477725e-02f, 2.631713483e-02f, 2.632944585e-02f, 2.634171030e-02f, 2.635392815e-02f, 2.636609940e-02f,
2.637822402e-02f, 2.639030200e-02f, 2.640233332e-02f, 2.641431796e-02f, 2.642625591e-02f, 2.643814716e-02f, 2.644999168e-02f, 2.646178945e-02f, 2.647354047e-02f, 2.648524472e-02f,
2.649690218e-02f, 2.650851283e-02f, 2.652007666e-02f, 2.653159365e-02f, 2.654306379e-02f, 2.655448706e-02f, 2.656586344e-02f, 2.657719293e-02f, 2.658847550e-02f, 2.659971113e-02f,
2.661089983e-02f, 2.662204156e-02f, 2.663313631e-02f, 2.664418408e-02f, 2.665518483e-02f, 2.666613857e-02f, 2.667704527e-02f, 2.668790492e-02f, 2.669871750e-02f, 2.670948301e-02f,
2.672020142e-02f, 2.673087272e-02f, 2.674149690e-02f, 2.675207394e-02f, 2.676260383e-02f, 2.677308656e-02f, 2.678352211e-02f, 2.679391046e-02f, 2.680425161e-02f, 2.681454554e-02f,
2.682479223e-02f, 2.683499167e-02f, 2.684514386e-02f, 2.685524877e-02f, 2.686530639e-02f, 2.687531672e-02f, 2.688527972e-02f, 2.689519541e-02f, 2.690506375e-02f, 2.691488474e-02f,
2.692465836e-02f, 2.693438460e-02f, 2.694406346e-02f, 2.695369491e-02f, 2.696327894e-02f, 2.697281555e-02f, 2.698230472e-02f, 2.699174643e-02f, 2.700114068e-02f, 2.701048745e-02f,
2.701978673e-02f, 2.702903852e-02f, 2.703824278e-02f, 2.704739953e-02f, 2.705650874e-02f, 2.706557040e-02f, 2.707458451e-02f, 2.708355104e-02f, 2.709246999e-02f, 2.710134135e-02f,
2.711016510e-02f, 2.711894124e-02f, 2.712766976e-02f, 2.713635064e-02f, 2.714498387e-02f, 2.715356944e-02f, 2.716210734e-02f, 2.717059756e-02f, 2.717904010e-02f, 2.718743493e-02f,
2.719578205e-02f, 2.720408145e-02f, 2.721233312e-02f, 2.722053705e-02f, 2.722869323e-02f, 2.723680165e-02f, 2.724486230e-02f, 2.725287516e-02f, 2.726084024e-02f, 2.726875752e-02f,
2.727662699e-02f, 2.728444864e-02f, 2.729222246e-02f, 2.729994844e-02f, 2.730762658e-02f, 2.731525687e-02f, 2.732283929e-02f, 2.733037383e-02f, 2.733786050e-02f, 2.734529927e-02f,
2.735269015e-02f, 2.736003312e-02f, 2.736732817e-02f, 2.737457529e-02f, 2.738177449e-02f, 2.738892574e-02f, 2.739602905e-02f, 2.740308439e-02f, 2.741009177e-02f, 2.741705118e-02f,
2.742396261e-02f, 2.743082605e-02f, 2.743764149e-02f, 2.744440893e-02f, 2.745112836e-02f, 2.745779977e-02f, 2.746442315e-02f, 2.747099850e-02f, 2.747752581e-02f, 2.748400507e-02f,
2.749043628e-02f, 2.749681942e-02f, 2.750315450e-02f, 2.750944150e-02f, 2.751568042e-02f, 2.752187126e-02f, 2.752801400e-02f, 2.753410864e-02f, 2.754015517e-02f, 2.754615358e-02f,
2.755210388e-02f, 2.755800606e-02f, 2.756386010e-02f, 2.756966600e-02f, 2.757542376e-02f, 2.758113337e-02f, 2.758679483e-02f, 2.759240813e-02f, 2.759797326e-02f, 2.760349022e-02f,
2.760895900e-02f, 2.761437961e-02f, 2.761975202e-02f, 2.762507625e-02f, 2.763035227e-02f, 2.763558010e-02f, 2.764075972e-02f, 2.764589113e-02f, 2.765097432e-02f, 2.765600930e-02f,
2.766099604e-02f, 2.766593456e-02f, 2.767082485e-02f, 2.767566690e-02f, 2.768046070e-02f, 2.768520626e-02f, 2.768990357e-02f, 2.769455263e-02f, 2.769915343e-02f, 2.770370597e-02f,
2.770821024e-02f, 2.771266625e-02f, 2.771707398e-02f, 2.772143344e-02f, 2.772574462e-02f, 2.773000751e-02f, 2.773422213e-02f, 2.773838845e-02f, 2.774250649e-02f, 2.774657623e-02f,
2.775059767e-02f, 2.775457081e-02f, 2.775849566e-02f, 2.776237219e-02f, 2.776620043e-02f, 2.776998035e-02f, 2.777371196e-02f, 2.777739525e-02f, 2.778103023e-02f, 2.778461690e-02f,
2.778815524e-02f, 2.779164526e-02f, 2.779508696e-02f, 2.779848033e-02f, 2.780182537e-02f, 2.780512209e-02f, 2.780837047e-02f, 2.781157053e-02f, 2.781472225e-02f, 2.781782564e-02f,
2.782088069e-02f, 2.782388741e-02f, 2.782684578e-02f, 2.782975583e-02f, 2.783261753e-02f, 2.783543089e-02f, 2.783819591e-02f, 2.784091260e-02f, 2.784358094e-02f, 2.784620094e-02f,
2.784877260e-02f, 2.785129591e-02f, 2.785377089e-02f, 2.785619752e-02f, 2.785857581e-02f, 2.786090575e-02f, 2.786318736e-02f, 2.786542062e-02f, 2.786760555e-02f, 2.786974213e-02f,
2.787183037e-02f, 2.787387027e-02f, 2.787586184e-02f, 2.787780506e-02f, 2.787969995e-02f, 2.788154650e-02f, 2.788334472e-02f, 2.788509460e-02f, 2.788679615e-02f, 2.788844937e-02f,
2.789005425e-02f, 2.789161081e-02f, 2.789311904e-02f, 2.789457895e-02f, 2.789599053e-02f, 2.789735379e-02f, 2.789866873e-02f, 2.789993535e-02f, 2.790115365e-02f, 2.790232364e-02f,
2.790344532e-02f, 2.790451868e-02f, 2.790554374e-02f, 2.790652050e-02f, 2.790744895e-02f, 2.790832910e-02f, 2.790916096e-02f, 2.790994452e-02f, 2.791067979e-02f, 2.791136677e-02f,
2.791200547e-02f, 2.791259588e-02f, 2.791313801e-02f, 2.791363187e-02f, 2.791407745e-02f, 2.791447477e-02f, 2.791482382e-02f, 2.791512461e-02f, 2.791537714e-02f, 2.791558141e-02f,
2.791573744e-02f, 2.791584521e-02f, 2.791590475e-02f, 2.791591604e-02f, 2.791587910e-02f, 2.791579393e-02f, 2.791566054e-02f, 2.791547892e-02f, 2.791524909e-02f, 2.791497104e-02f,
2.791464479e-02f, 2.791427033e-02f, 2.791384768e-02f, 2.791337683e-02f, 2.791285779e-02f, 2.791229057e-02f, 2.791167518e-02f, 2.791101161e-02f, 2.791029987e-02f, 2.790953997e-02f,
2.790873192e-02f, 2.790787571e-02f, 2.790697136e-02f, 2.790601887e-02f, 2.790501824e-02f, 2.790396949e-02f, 2.790287262e-02f, 2.790172763e-02f, 2.790053453e-02f, 2.789929333e-02f,
2.789800403e-02f, 2.789666664e-02f, 2.789528117e-02f, 2.789384762e-02f, 2.789236600e-02f, 2.789083632e-02f, 2.788925858e-02f, 2.788763279e-02f, 2.788595895e-02f, 2.788423708e-02f,
2.788246718e-02f, 2.788064926e-02f, 2.787878332e-02f, 2.787686938e-02f, 2.787490744e-02f, 2.787289750e-02f, 2.787083958e-02f, 2.786873369e-02f, 2.786657982e-02f, 2.786437800e-02f,
2.786212822e-02f, 2.785983050e-02f, 2.785748484e-02f, 2.785509125e-02f, 2.785264974e-02f, 2.785016032e-02f, 2.784762300e-02f, 2.784503778e-02f, 2.784240467e-02f, 2.783972369e-02f,
2.783699484e-02f, 2.783421813e-02f, 2.783139357e-02f, 2.782852116e-02f, 2.782560093e-02f, 2.782263287e-02f, 2.781961699e-02f, 2.781655331e-02f, 2.781344184e-02f, 2.781028258e-02f,
2.780707554e-02f, 2.780382074e-02f, 2.780051817e-02f, 2.779716787e-02f, 2.779376982e-02f, 2.779032405e-02f, 2.778683056e-02f, 2.778328936e-02f, 2.777970047e-02f, 2.777606389e-02f,
2.777237964e-02f, 2.776864772e-02f, 2.776486814e-02f, 2.776104092e-02f, 2.775716607e-02f, 2.775324360e-02f, 2.774927351e-02f, 2.774525582e-02f, 2.774119054e-02f, 2.773707769e-02f,
2.773291727e-02f, 2.772870929e-02f, 2.772445377e-02f, 2.772015071e-02f, 2.771580013e-02f, 2.771140204e-02f, 2.770695646e-02f, 2.770246339e-02f, 2.769792284e-02f, 2.769333483e-02f,
2.768869937e-02f, 2.768401647e-02f, 2.767928615e-02f, 2.767450841e-02f, 2.766968327e-02f, 2.766481075e-02f, 2.765989084e-02f, 2.765492357e-02f, 2.764990895e-02f, 2.764484699e-02f,
2.763973771e-02f, 2.763458111e-02f, 2.762937722e-02f, 2.762412603e-02f, 2.761882757e-02f, 2.761348186e-02f, 2.760808889e-02f, 2.760264870e-02f, 2.759716128e-02f, 2.759162665e-02f,
2.758604484e-02f, 2.758041584e-02f, 2.757473968e-02f, 2.756901637e-02f, 2.756324591e-02f, 2.755742834e-02f, 2.755156366e-02f, 2.754565188e-02f, 2.753969302e-02f, 2.753368710e-02f,
2.752763412e-02f, 2.752153410e-02f, 2.751538706e-02f, 2.750919302e-02f, 2.750295198e-02f, 2.749666396e-02f, 2.749032898e-02f, 2.748394705e-02f, 2.747751819e-02f, 2.747104240e-02f,
2.746451972e-02f, 2.745795014e-02f, 2.745133370e-02f, 2.744467040e-02f, 2.743796025e-02f, 2.743120328e-02f, 2.742439950e-02f, 2.741754893e-02f, 2.741065158e-02f, 2.740370746e-02f,
2.739671660e-02f, 2.738967901e-02f, 2.738259470e-02f, 2.737546370e-02f, 2.736828601e-02f, 2.736106166e-02f, 2.735379066e-02f, 2.734647303e-02f, 2.733910879e-02f, 2.733169794e-02f,
2.732424052e-02f, 2.731673652e-02f, 2.730918599e-02f, 2.730158892e-02f, 2.729394533e-02f, 2.728625525e-02f, 2.727851869e-02f, 2.727073567e-02f, 2.726290621e-02f, 2.725503032e-02f,
2.724710802e-02f, 2.723913932e-02f, 2.723112426e-02f, 2.722306284e-02f, 2.721495508e-02f, 2.720680100e-02f, 2.719860061e-02f, 2.719035395e-02f, 2.718206102e-02f, 2.717372184e-02f,
2.716533643e-02f, 2.715690482e-02f, 2.714842701e-02f, 2.713990303e-02f, 2.713133289e-02f, 2.712271662e-02f, 2.711405423e-02f, 2.710534574e-02f, 2.709659118e-02f, 2.708779055e-02f,
2.707894389e-02f, 2.707005120e-02f, 2.706111251e-02f, 2.705212784e-02f, 2.704309720e-02f, 2.703402062e-02f, 2.702489812e-02f, 2.701572972e-02f, 2.700651543e-02f, 2.699725527e-02f,
2.698794927e-02f, 2.697859745e-02f, 2.696919982e-02f, 2.695975640e-02f, 2.695026723e-02f, 2.694073230e-02f, 2.693115166e-02f, 2.692152531e-02f, 2.691185328e-02f, 2.690213559e-02f,
2.689237226e-02f, 2.688256331e-02f, 2.687270876e-02f, 2.686280863e-02f, 2.685286294e-02f, 2.684287171e-02f, 2.683283498e-02f, 2.682275274e-02f, 2.681262504e-02f, 2.680245188e-02f,
2.679223330e-02f, 2.678196931e-02f, 2.677165993e-02f, 2.676130518e-02f, 2.675090509e-02f, 2.674045969e-02f, 2.672996898e-02f, 2.671943299e-02f, 2.670885176e-02f, 2.669822528e-02f,
2.668755360e-02f, 2.667683673e-02f, 2.666607469e-02f, 2.665526751e-02f, 2.664441521e-02f, 2.663351781e-02f, 2.662257534e-02f, 2.661158781e-02f, 2.660055525e-02f, 2.658947769e-02f,
2.657835514e-02f, 2.656718763e-02f, 2.655597519e-02f, 2.654471783e-02f, 2.653341557e-02f, 2.652206845e-02f, 2.651067649e-02f, 2.649923970e-02f, 2.648775812e-02f, 2.647623176e-02f,
2.646466066e-02f, 2.645304483e-02f, 2.644138429e-02f, 2.642967908e-02f, 2.641792921e-02f, 2.640613472e-02f, 2.639429561e-02f, 2.638241193e-02f, 2.637048369e-02f, 2.635851092e-02f,
2.634649364e-02f, 2.633443187e-02f, 2.632232565e-02f, 2.631017499e-02f, 2.629797992e-02f, 2.628574047e-02f, 2.627345666e-02f, 2.626112851e-02f, 2.624875606e-02f, 2.623633932e-02f,
2.622387832e-02f, 2.621137308e-02f, 2.619882364e-02f, 2.618623002e-02f, 2.617359224e-02f, 2.616091032e-02f, 2.614818431e-02f, 2.613541421e-02f, 2.612260005e-02f, 2.610974187e-02f,
2.609683968e-02f, 2.608389352e-02f, 2.607090341e-02f, 2.605786937e-02f, 2.604479144e-02f, 2.603166964e-02f, 2.601850398e-02f, 2.600529452e-02f, 2.599204125e-02f, 2.597874423e-02f,
2.596540346e-02f, 2.595201898e-02f, 2.593859082e-02f, 2.592511900e-02f, 2.591160355e-02f, 2.589804449e-02f, 2.588444186e-02f, 2.587079568e-02f, 2.585710597e-02f, 2.584337277e-02f,
2.582959611e-02f, 2.581577600e-02f, 2.580191248e-02f, 2.578800558e-02f, 2.577405531e-02f, 2.576006172e-02f, 2.574602483e-02f, 2.573194467e-02f, 2.571782126e-02f, 2.570365463e-02f,
2.568944481e-02f, 2.567519183e-02f, 2.566089572e-02f, 2.564655651e-02f, 2.563217422e-02f, 2.561774888e-02f, 2.560328052e-02f, 2.558876917e-02f, 2.557421487e-02f, 2.555961763e-02f,
2.554497748e-02f, 2.553029446e-02f, 2.551556860e-02f, 2.550079992e-02f, 2.548598845e-02f, 2.547113423e-02f, 2.545623727e-02f, 2.544129762e-02f, 2.542631530e-02f, 2.541129033e-02f,
2.539622276e-02f, 2.538111260e-02f, 2.536595989e-02f, 2.535076467e-02f, 2.533552695e-02f, 2.532024676e-02f, 2.530492415e-02f, 2.528955913e-02f, 2.527415175e-02f, 2.525870202e-02f,
2.524320998e-02f, 2.522767566e-02f, 2.521209909e-02f, 2.519648030e-02f, 2.518081932e-02f, 2.516511618e-02f, 2.514937092e-02f, 2.513358356e-02f, 2.511775413e-02f, 2.510188267e-02f,
2.508596920e-02f, 2.507001376e-02f, 2.505401638e-02f, 2.503797708e-02f, 2.502189591e-02f, 2.500577289e-02f, 2.498960806e-02f, 2.497340143e-02f, 2.495715306e-02f, 2.494086296e-02f,
2.492453117e-02f, 2.490815773e-02f, 2.489174266e-02f, 2.487528599e-02f, 2.485878776e-02f, 2.484224800e-02f, 2.482566674e-02f, 2.480904401e-02f, 2.479237985e-02f, 2.477567429e-02f,
2.475892736e-02f, 2.474213909e-02f, 2.472530951e-02f, 2.470843867e-02f, 2.469152658e-02f, 2.467457329e-02f, 2.465757882e-02f, 2.464054322e-02f, 2.462346650e-02f, 2.460634871e-02f,
2.458918988e-02f, 2.457199004e-02f, 2.455474923e-02f, 2.453746747e-02f, 2.452014480e-02f, 2.450278126e-02f, 2.448537687e-02f, 2.446793168e-02f, 2.445044571e-02f, 2.443291900e-02f,
2.441535158e-02f, 2.439774349e-02f, 2.438009476e-02f, 2.436240542e-02f, 2.434467551e-02f, 2.432690507e-02f, 2.430909411e-02f, 2.429124269e-02f, 2.427335084e-02f, 2.425541858e-02f,
2.423744596e-02f, 2.421943300e-02f, 2.420137975e-02f, 2.418328623e-02f, 2.416515249e-02f, 2.414697855e-02f, 2.412876446e-02f, 2.411051023e-02f, 2.409221593e-02f, 2.407388156e-02f,
2.405550718e-02f, 2.403709282e-02f, 2.401863850e-02f, 2.400014428e-02f, 2.398161017e-02f, 2.396303622e-02f, 2.394442247e-02f, 2.392576894e-02f, 2.390707568e-02f, 2.388834272e-02f,
2.386957009e-02f, 2.385075784e-02f, 2.383190599e-02f, 2.381301459e-02f, 2.379408366e-02f, 2.377511325e-02f, 2.375610339e-02f, 2.373705412e-02f, 2.371796547e-02f, 2.369883749e-02f,
2.367967019e-02f, 2.366046364e-02f, 2.364121785e-02f, 2.362193286e-02f, 2.360260872e-02f, 2.358324546e-02f, 2.356384312e-02f, 2.354440172e-02f, 2.352492132e-02f, 2.350540194e-02f,
2.348584363e-02f, 2.346624642e-02f, 2.344661034e-02f, 2.342693545e-02f, 2.340722176e-02f, 2.338746932e-02f, 2.336767817e-02f, 2.334784835e-02f, 2.332797989e-02f, 2.330807282e-02f,
2.328812720e-02f, 2.326814305e-02f, 2.324812041e-02f, 2.322805932e-02f, 2.320795982e-02f, 2.318782195e-02f, 2.316764575e-02f, 2.314743124e-02f, 2.312717848e-02f, 2.310688749e-02f,
2.308655833e-02f, 2.306619102e-02f, 2.304578560e-02f, 2.302534212e-02f, 2.300486060e-02f, 2.298434110e-02f, 2.296378364e-02f, 2.294318828e-02f, 2.292255504e-02f, 2.290188396e-02f,
2.288117509e-02f, 2.286042845e-02f, 2.283964411e-02f, 2.281882208e-02f, 2.279796241e-02f, 2.277706514e-02f, 2.275613031e-02f, 2.273515796e-02f, 2.271414812e-02f, 2.269310084e-02f,
2.267201616e-02f, 2.265089411e-02f, 2.262973474e-02f, 2.260853808e-02f, 2.258730418e-02f, 2.256603307e-02f, 2.254472480e-02f, 2.252337940e-02f, 2.250199692e-02f, 2.248057739e-02f,
2.245912085e-02f, 2.243762735e-02f, 2.241609693e-02f, 2.239452962e-02f, 2.237292546e-02f, 2.235128451e-02f, 2.232960679e-02f, 2.230789234e-02f, 2.228614122e-02f, 2.226435345e-02f,
2.224252908e-02f, 2.222066815e-02f, 2.219877071e-02f, 2.217683678e-02f, 2.215486642e-02f, 2.213285966e-02f, 2.211081654e-02f, 2.208873712e-02f, 2.206662142e-02f, 2.204446948e-02f,
2.202228136e-02f, 2.200005709e-02f, 2.197779671e-02f, 2.195550026e-02f, 2.193316780e-02f, 2.191079934e-02f, 2.188839495e-02f, 2.186595466e-02f, 2.184347851e-02f, 2.182096654e-02f,
2.179841880e-02f, 2.177583533e-02f, 2.175321617e-02f, 2.173056136e-02f, 2.170787095e-02f, 2.168514497e-02f, 2.166238347e-02f, 2.163958649e-02f, 2.161675407e-02f, 2.159388627e-02f,
2.157098311e-02f, 2.154804464e-02f, 2.152507090e-02f, 2.150206194e-02f, 2.147901780e-02f, 2.145593852e-02f, 2.143282414e-02f, 2.140967472e-02f, 2.138649028e-02f, 2.136327088e-02f,
2.134001655e-02f, 2.131672734e-02f, 2.129340329e-02f, 2.127004445e-02f, 2.124665086e-02f, 2.122322256e-02f, 2.119975960e-02f, 2.117626202e-02f, 2.115272986e-02f, 2.112916316e-02f,
2.110556198e-02f, 2.108192635e-02f, 2.105825631e-02f, 2.103455192e-02f, 2.101081321e-02f, 2.098704024e-02f, 2.096323303e-02f, 2.093939164e-02f, 2.091551611e-02f, 2.089160649e-02f,
2.086766281e-02f, 2.084368513e-02f, 2.081967349e-02f, 2.079562793e-02f, 2.077154849e-02f, 2.074743522e-02f, 2.072328817e-02f, 2.069910738e-02f, 2.067489290e-02f, 2.065064476e-02f,
2.062636302e-02f, 2.060204771e-02f, 2.057769889e-02f, 2.055331660e-02f, 2.052890088e-02f, 2.050445178e-02f, 2.047996934e-02f, 2.045545361e-02f, 2.043090463e-02f, 2.040632245e-02f,
2.038170711e-02f, 2.035705867e-02f, 2.033237716e-02f, 2.030766262e-02f, 2.028291512e-02f, 2.025813468e-02f, 2.023332136e-02f, 2.020847520e-02f, 2.018359625e-02f, 2.015868456e-02f,
2.013374016e-02f, 2.010876310e-02f, 2.008375344e-02f, 2.005871122e-02f, 2.003363647e-02f, 2.000852926e-02f, 1.998338962e-02f, 1.995821760e-02f, 1.993301325e-02f, 1.990777661e-02f,
1.988250774e-02f, 1.985720666e-02f, 1.983187345e-02f, 1.980650812e-02f, 1.978111075e-02f, 1.975568137e-02f, 1.973022002e-02f, 1.970472676e-02f, 1.967920164e-02f, 1.965364469e-02f,
1.962805596e-02f, 1.960243551e-02f, 1.957678338e-02f, 1.955109962e-02f, 1.952538426e-02f, 1.949963737e-02f, 1.947385899e-02f, 1.944804916e-02f, 1.942220793e-02f, 1.939633535e-02f,
1.937043147e-02f, 1.934449633e-02f, 1.931852998e-02f, 1.929253247e-02f, 1.926650384e-02f, 1.924044415e-02f, 1.921435345e-02f, 1.918823177e-02f, 1.916207916e-02f, 1.913589568e-02f,
1.910968138e-02f, 1.908343629e-02f, 1.905716047e-02f, 1.903085397e-02f, 1.900451683e-02f, 1.897814910e-02f, 1.895175083e-02f, 1.892532207e-02f, 1.889886287e-02f, 1.887237327e-02f,
1.884585333e-02f, 1.881930308e-02f, 1.879272259e-02f, 1.876611189e-02f, 1.873947104e-02f, 1.871280009e-02f, 1.868609908e-02f, 1.865936806e-02f, 1.863260708e-02f, 1.860581619e-02f,
1.857899544e-02f, 1.855214488e-02f, 1.852526455e-02f, 1.849835451e-02f, 1.847141480e-02f, 1.844444548e-02f, 1.841744658e-02f, 1.839041817e-02f, 1.836336029e-02f, 1.833627299e-02f,
1.830915632e-02f, 1.828201032e-02f, 1.825483505e-02f, 1.822763056e-02f, 1.820039690e-02f, 1.817313411e-02f, 1.814584224e-02f, 1.811852135e-02f, 1.809117149e-02f, 1.806379270e-02f,
1.803638503e-02f, 1.800894853e-02f, 1.798148326e-02f, 1.795398926e-02f, 1.792646659e-02f, 1.789891528e-02f, 1.787133540e-02f, 1.784372700e-02f, 1.781609011e-02f, 1.778842480e-02f,
1.776073111e-02f, 1.773300910e-02f, 1.770525881e-02f, 1.767748029e-02f, 1.764967359e-02f, 1.762183877e-02f, 1.759397588e-02f, 1.756608496e-02f, 1.753816607e-02f, 1.751021925e-02f,
1.748224456e-02f, 1.745424205e-02f, 1.742621176e-02f, 1.739815376e-02f, 1.737006808e-02f, 1.734195479e-02f, 1.731381393e-02f, 1.728564555e-02f, 1.725744970e-02f, 1.722922643e-02f,
1.720097581e-02f, 1.717269787e-02f, 1.714439266e-02f, 1.711606025e-02f, 1.708770067e-02f, 1.705931399e-02f, 1.703090024e-02f, 1.700245949e-02f, 1.697399179e-02f, 1.694549718e-02f,
1.691697572e-02f, 1.688842746e-02f, 1.685985246e-02f, 1.683125075e-02f, 1.680262240e-02f, 1.677396745e-02f, 1.674528596e-02f, 1.671657798e-02f, 1.668784356e-02f, 1.665908275e-02f,
1.663029561e-02f, 1.660148219e-02f, 1.657264253e-02f, 1.654377669e-02f, 1.651488473e-02f, 1.648596669e-02f, 1.645702263e-02f, 1.642805259e-02f, 1.639905664e-02f, 1.637003482e-02f,
1.634098719e-02f, 1.631191379e-02f, 1.628281468e-02f, 1.625368992e-02f, 1.622453955e-02f, 1.619536363e-02f, 1.616616221e-02f, 1.613693534e-02f, 1.610768307e-02f, 1.607840547e-02f,
1.604910257e-02f, 1.601977444e-02f, 1.599042112e-02f, 1.596104267e-02f, 1.593163915e-02f, 1.590221059e-02f, 1.587275707e-02f, 1.584327862e-02f, 1.581377531e-02f, 1.578424718e-02f,
1.575469429e-02f, 1.572511670e-02f, 1.569551445e-02f, 1.566588760e-02f, 1.563623620e-02f, 1.560656030e-02f, 1.557685997e-02f, 1.554713524e-02f, 1.551738618e-02f, 1.548761284e-02f,
1.545781527e-02f, 1.542799352e-02f, 1.539814766e-02f, 1.536827772e-02f, 1.533838377e-02f, 1.530846586e-02f, 1.527852405e-02f, 1.524855838e-02f, 1.521856891e-02f, 1.518855569e-02f,
1.515851879e-02f, 1.512845824e-02f, 1.509837411e-02f, 1.506826645e-02f, 1.503813532e-02f, 1.500798076e-02f, 1.497780283e-02f, 1.494760159e-02f, 1.491737709e-02f, 1.488712938e-02f,
1.485685852e-02f, 1.482656456e-02f, 1.479624756e-02f, 1.476590757e-02f, 1.473554464e-02f, 1.470515883e-02f, 1.467475020e-02f, 1.464431879e-02f, 1.461386467e-02f, 1.458338788e-02f,
1.455288849e-02f, 1.452236654e-02f, 1.449182209e-02f, 1.446125520e-02f, 1.443066591e-02f, 1.440005429e-02f, 1.436942039e-02f, 1.433876426e-02f, 1.430808597e-02f, 1.427738555e-02f,
1.424666308e-02f, 1.421591859e-02f, 1.418515216e-02f, 1.415436382e-02f, 1.412355365e-02f, 1.409272169e-02f, 1.406186800e-02f, 1.403099263e-02f, 1.400009563e-02f, 1.396917707e-02f,
1.393823700e-02f, 1.390727548e-02f, 1.387629255e-02f, 1.384528828e-02f, 1.381426271e-02f, 1.378321591e-02f, 1.375214793e-02f, 1.372105883e-02f, 1.368994866e-02f, 1.365881747e-02f,
1.362766533e-02f, 1.359649228e-02f, 1.356529839e-02f, 1.353408370e-02f, 1.350284828e-02f, 1.347159218e-02f, 1.344031545e-02f, 1.340901816e-02f, 1.337770035e-02f, 1.334636208e-02f,
1.331500342e-02f, 1.328362441e-02f, 1.325222510e-02f, 1.322080557e-02f, 1.318936586e-02f, 1.315790602e-02f, 1.312642612e-02f, 1.309492621e-02f, 1.306340634e-02f, 1.303186658e-02f,
1.300030697e-02f, 1.296872758e-02f, 1.293712846e-02f, 1.290550967e-02f, 1.287387125e-02f, 1.284221328e-02f, 1.281053581e-02f, 1.277883888e-02f, 1.274712256e-02f, 1.271538691e-02f,
1.268363198e-02f, 1.265185782e-02f, 1.262006450e-02f, 1.258825207e-02f, 1.255642059e-02f, 1.252457011e-02f, 1.249270068e-02f, 1.246081238e-02f, 1.242890524e-02f, 1.239697934e-02f,
1.236503472e-02f, 1.233307145e-02f, 1.230108958e-02f, 1.226908916e-02f, 1.223707025e-02f, 1.220503292e-02f, 1.217297721e-02f, 1.214090318e-02f, 1.210881090e-02f, 1.207670041e-02f,
1.204457178e-02f, 1.201242506e-02f, 1.198026031e-02f, 1.194807758e-02f, 1.191587693e-02f, 1.188365843e-02f, 1.185142212e-02f, 1.181916806e-02f, 1.178689632e-02f, 1.175460694e-02f,
1.172229999e-02f, 1.168997552e-02f, 1.165763359e-02f, 1.162527425e-02f, 1.159289758e-02f, 1.156050361e-02f, 1.152809241e-02f, 1.149566404e-02f, 1.146321855e-02f, 1.143075600e-02f,
1.139827645e-02f, 1.136577996e-02f, 1.133326658e-02f, 1.130073637e-02f, 1.126818939e-02f, 1.123562570e-02f, 1.120304535e-02f, 1.117044840e-02f, 1.113783491e-02f, 1.110520493e-02f,
1.107255854e-02f, 1.103989577e-02f, 1.100721669e-02f, 1.097452136e-02f, 1.094180984e-02f, 1.090908218e-02f, 1.087633844e-02f, 1.084357867e-02f, 1.081080295e-02f, 1.077801132e-02f,
1.074520384e-02f, 1.071238057e-02f, 1.067954157e-02f, 1.064668690e-02f, 1.061381661e-02f, 1.058093076e-02f, 1.054802942e-02f, 1.051511263e-02f, 1.048218046e-02f, 1.044923296e-02f,
1.041627020e-02f, 1.038329223e-02f, 1.035029910e-02f, 1.031729089e-02f, 1.028426764e-02f, 1.025122941e-02f, 1.021817627e-02f, 1.018510826e-02f, 1.015202546e-02f, 1.011892791e-02f,
1.008581568e-02f, 1.005268882e-02f, 1.001954739e-02f, 9.986391454e-03f, 9.953221066e-03f, 9.920036285e-03f, 9.886837171e-03f, 9.853623781e-03f, 9.820396173e-03f, 9.787154407e-03f,
9.753898541e-03f, 9.720628633e-03f, 9.687344743e-03f, 9.654046928e-03f, 9.620735247e-03f, 9.587409759e-03f, 9.554070523e-03f, 9.520717597e-03f, 9.487351040e-03f, 9.453970911e-03f,
9.420577268e-03f, 9.387170170e-03f, 9.353749676e-03f, 9.320315845e-03f, 9.286868735e-03f, 9.253408405e-03f, 9.219934915e-03f, 9.186448323e-03f, 9.152948688e-03f, 9.119436068e-03f,
9.085910523e-03f, 9.052372112e-03f, 9.018820894e-03f, 8.985256927e-03f, 8.951680270e-03f, 8.918090983e-03f, 8.884489125e-03f, 8.850874754e-03f, 8.817247930e-03f, 8.783608711e-03f,
8.749957158e-03f, 8.716293328e-03f, 8.682617281e-03f, 8.648929076e-03f, 8.615228772e-03f, 8.581516429e-03f, 8.547792106e-03f, 8.514055861e-03f, 8.480307754e-03f, 8.446547844e-03f,
8.412776191e-03f, 8.378992854e-03f, 8.345197891e-03f, 8.311391363e-03f, 8.277573328e-03f, 8.243743846e-03f, 8.209902977e-03f, 8.176050779e-03f, 8.142187311e-03f, 8.108312634e-03f,
8.074426807e-03f, 8.040529889e-03f, 8.006621939e-03f, 7.972703017e-03f, 7.938773182e-03f, 7.904832495e-03f, 7.870881013e-03f, 7.836918797e-03f, 7.802945907e-03f, 7.768962401e-03f,
7.734968339e-03f, 7.700963781e-03f, 7.666948787e-03f, 7.632923415e-03f, 7.598887726e-03f, 7.564841779e-03f, 7.530785634e-03f, 7.496719350e-03f, 7.462642987e-03f, 7.428556604e-03f,
7.394460262e-03f, 7.360354020e-03f, 7.326237937e-03f, 7.292112073e-03f, 7.257976488e-03f, 7.223831242e-03f, 7.189676395e-03f, 7.155512005e-03f, 7.121338133e-03f, 7.087154839e-03f,
7.052962182e-03f, 7.018760222e-03f, 6.984549020e-03f, 6.950328633e-03f, 6.916099124e-03f, 6.881860551e-03f, 6.847612974e-03f, 6.813356453e-03f, 6.779091048e-03f, 6.744816818e-03f,
6.710533825e-03f, 6.676242126e-03f, 6.641941784e-03f, 6.607632856e-03f, 6.573315404e-03f, 6.538989487e-03f, 6.504655164e-03f, 6.470312497e-03f, 6.435961545e-03f, 6.401602368e-03f,
6.367235026e-03f, 6.332859578e-03f, 6.298476086e-03f, 6.264084608e-03f, 6.229685205e-03f, 6.195277937e-03f, 6.160862864e-03f, 6.126440045e-03f, 6.092009542e-03f, 6.057571414e-03f,
6.023125721e-03f, 5.988672522e-03f, 5.954211879e-03f, 5.919743852e-03f, 5.885268499e-03f, 5.850785883e-03f, 5.816296061e-03f, 5.781799096e-03f, 5.747295046e-03f, 5.712783972e-03f,
5.678265934e-03f, 5.643740992e-03f, 5.609209206e-03f, 5.574670637e-03f, 5.540125345e-03f, 5.505573389e-03f, 5.471014830e-03f, 5.436449729e-03f, 5.401878144e-03f, 5.367300138e-03f,
5.332715768e-03f, 5.298125097e-03f, 5.263528184e-03f, 5.228925089e-03f, 5.194315873e-03f, 5.159700595e-03f, 5.125079316e-03f, 5.090452097e-03f, 5.055818997e-03f, 5.021180077e-03f,
4.986535396e-03f, 4.951885016e-03f, 4.917228996e-03f, 4.882567397e-03f, 4.847900279e-03f, 4.813227702e-03f, 4.778549727e-03f, 4.743866414e-03f, 4.709177822e-03f, 4.674484013e-03f,
4.639785047e-03f, 4.605080983e-03f, 4.570371883e-03f, 4.535657807e-03f, 4.500938814e-03f, 4.466214966e-03f, 4.431486322e-03f, 4.396752943e-03f, 4.362014888e-03f, 4.327272220e-03f,
4.292524997e-03f, 4.257773281e-03f, 4.223017130e-03f, 4.188256607e-03f, 4.153491771e-03f, 4.118722682e-03f, 4.083949401e-03f, 4.049171988e-03f, 4.014390503e-03f, 3.979605008e-03f,
3.944815562e-03f, 3.910022225e-03f, 3.875225058e-03f, 3.840424121e-03f, 3.805619475e-03f, 3.770811180e-03f, 3.735999296e-03f, 3.701183884e-03f, 3.666365004e-03f, 3.631542716e-03f,
3.596717081e-03f, 3.561888159e-03f, 3.527056011e-03f, 3.492220696e-03f, 3.457382276e-03f, 3.422540810e-03f, 3.387696359e-03f, 3.352848984e-03f, 3.317998744e-03f, 3.283145700e-03f,
3.248289912e-03f, 3.213431442e-03f, 3.178570348e-03f, 3.143706692e-03f, 3.108840534e-03f, 3.073971934e-03f, 3.039100953e-03f, 3.004227650e-03f, 2.969352087e-03f, 2.934474323e-03f,
2.899594420e-03f, 2.864712437e-03f, 2.829828434e-03f, 2.794942473e-03f, 2.760054613e-03f, 2.725164914e-03f, 2.690273438e-03f, 2.655380244e-03f, 2.620485393e-03f, 2.585588946e-03f,
2.550690961e-03f, 2.515791501e-03f, 2.480890625e-03f, 2.445988393e-03f, 2.411084865e-03f, 2.376180104e-03f, 2.341274167e-03f, 2.306367116e-03f, 2.271459011e-03f, 2.236549913e-03f,
2.201639882e-03f, 2.166728977e-03f, 2.131817260e-03f, 2.096904790e-03f, 2.061991628e-03f, 2.027077834e-03f, 1.992163469e-03f, 1.957248593e-03f, 1.922333266e-03f, 1.887417548e-03f,
1.852501499e-03f, 1.817585180e-03f, 1.782668652e-03f, 1.747751974e-03f, 1.712835206e-03f, 1.677918410e-03f, 1.643001644e-03f, 1.608084970e-03f, 1.573168447e-03f, 1.538252136e-03f,
1.503336097e-03f, 1.468420391e-03f, 1.433505076e-03f, 1.398590215e-03f, 1.363675866e-03f, 1.328762091e-03f, 1.293848948e-03f, 1.258936499e-03f, 1.224024803e-03f, 1.189113922e-03f,
1.154203914e-03f, 1.119294840e-03f, 1.084386760e-03f, 1.049479735e-03f, 1.014573824e-03f, 9.796690881e-04f, 9.447655866e-04f, 9.098633800e-04f, 8.749625282e-04f, 8.400630916e-04f,
8.051651300e-04f, 7.702687037e-04f, 7.353738726e-04f, 7.004806969e-04f, 6.655892366e-04f, 6.306995517e-04f, 5.958117024e-04f, 5.609257486e-04f, 5.260417504e-04f, 4.911597677e-04f,
4.562798607e-04f, 4.214020892e-04f, 3.865265134e-04f, 3.516531931e-04f, 3.167821884e-04f, 2.819135591e-04f, 2.470473654e-04f, 2.121836671e-04f, 1.773225241e-04f, 1.424639964e-04f,
1.076081440e-04f, 7.275502664e-05f, 3.790470432e-05f, 3.057236898e-06f, -3.178731573e-05f, -6.662889370e-05f, -1.014674371e-04f, -1.363028862e-04f, -1.711351811e-04f, -2.059642619e-04f,
-2.407900689e-04f, -2.756125422e-04f, -3.104316221e-04f, -3.452472487e-04f, -3.800593622e-04f, -4.148679030e-04f, -4.496728112e-04f, -4.844740272e-04f, -5.192714911e-04f, -5.540651433e-04f,
-5.888549241e-04f, -6.236407737e-04f, -6.584226325e-04f, -6.932004408e-04f, -7.279741390e-04f, -7.627436673e-04f, -7.975089662e-04f, -8.322699761e-04f, -8.670266372e-04f, -9.017788901e-04f,
-9.365266752e-04f, -9.712699328e-04f, -1.006008603e-03f, -1.040742627e-03f, -1.075471945e-03f, -1.110196498e-03f, -1.144916225e-03f, -1.179631068e-03f, -1.214340966e-03f, -1.249045861e-03f,
-1.283745693e-03f, -1.318440403e-03f, -1.353129930e-03f, -1.387814217e-03f, -1.422493203e-03f, -1.457166828e-03f, -1.491835034e-03f, -1.526497762e-03f, -1.561154951e-03f, -1.595806543e-03f,
-1.630452477e-03f, -1.665092696e-03f, -1.699727140e-03f, -1.734355748e-03f, -1.768978463e-03f, -1.803595225e-03f, -1.838205975e-03f, -1.872810652e-03f, -1.907409199e-03f, -1.942001556e-03f,
-1.976587664e-03f, -2.011167464e-03f, -2.045740897e-03f, -2.080307902e-03f, -2.114868423e-03f, -2.149422398e-03f, -2.183969770e-03f, -2.218510479e-03f, -2.253044466e-03f, -2.287571673e-03f,
-2.322092039e-03f, -2.356605507e-03f, -2.391112017e-03f, -2.425611510e-03f, -2.460103928e-03f, -2.494589210e-03f, -2.529067300e-03f, -2.563538137e-03f, -2.598001663e-03f, -2.632457818e-03f,
-2.666906545e-03f, -2.701347784e-03f, -2.735781476e-03f, -2.770207564e-03f, -2.804625987e-03f, -2.839036687e-03f, -2.873439606e-03f, -2.907834685e-03f, -2.942221864e-03f, -2.976601086e-03f,
-3.010972292e-03f, -3.045335423e-03f, -3.079690421e-03f, -3.114037227e-03f, -3.148375782e-03f, -3.182706027e-03f, -3.217027905e-03f, -3.251341357e-03f, -3.285646324e-03f, -3.319942748e-03f,
-3.354230571e-03f, -3.388509733e-03f, -3.422780177e-03f, -3.457041843e-03f, -3.491294675e-03f, -3.525538613e-03f, -3.559773599e-03f, -3.593999575e-03f, -3.628216482e-03f, -3.662424262e-03f,
-3.696622857e-03f, -3.730812209e-03f, -3.764992259e-03f, -3.799162950e-03f, -3.833324222e-03f, -3.867476019e-03f, -3.901618281e-03f, -3.935750951e-03f, -3.969873971e-03f, -4.003987282e-03f,
-4.038090826e-03f, -4.072184547e-03f, -4.106268384e-03f, -4.140342281e-03f, -4.174406180e-03f, -4.208460022e-03f, -4.242503750e-03f, -4.276537306e-03f, -4.310560632e-03f, -4.344573670e-03f,
-4.378576362e-03f, -4.412568650e-03f, -4.446550478e-03f, -4.480521786e-03f, -4.514482517e-03f, -4.548432614e-03f, -4.582372019e-03f, -4.616300674e-03f, -4.650218521e-03f, -4.684125504e-03f,
-4.718021563e-03f, -4.751906643e-03f, -4.785780684e-03f, -4.819643631e-03f, -4.853495424e-03f, -4.887336007e-03f, -4.921165323e-03f, -4.954983313e-03f, -4.988789921e-03f, -5.022585089e-03f,
-5.056368759e-03f, -5.090140875e-03f, -5.123901379e-03f, -5.157650214e-03f, -5.191387322e-03f, -5.225112647e-03f, -5.258826131e-03f, -5.292527716e-03f, -5.326217347e-03f, -5.359894965e-03f,
-5.393560514e-03f, -5.427213936e-03f, -5.460855175e-03f, -5.494484173e-03f, -5.528100874e-03f, -5.561705220e-03f, -5.595297154e-03f, -5.628876620e-03f, -5.662443561e-03f, -5.695997920e-03f,
-5.729539640e-03f, -5.763068663e-03f, -5.796584935e-03f, -5.830088396e-03f, -5.863578992e-03f, -5.897056665e-03f, -5.930521358e-03f, -5.963973016e-03f, -5.997411580e-03f, -6.030836995e-03f,
-6.064249204e-03f, -6.097648151e-03f, -6.131033778e-03f, -6.164406030e-03f, -6.197764851e-03f, -6.231110182e-03f, -6.264441969e-03f, -6.297760155e-03f, -6.331064683e-03f, -6.364355498e-03f,
-6.397632542e-03f, -6.430895760e-03f, -6.464145095e-03f, -6.497380491e-03f, -6.530601892e-03f, -6.563809242e-03f, -6.597002485e-03f, -6.630181565e-03f, -6.663346425e-03f, -6.696497009e-03f,
-6.729633262e-03f, -6.762755128e-03f, -6.795862550e-03f, -6.828955472e-03f, -6.862033840e-03f, -6.895097596e-03f, -6.928146686e-03f, -6.961181053e-03f, -6.994200641e-03f, -7.027205395e-03f,
-7.060195260e-03f, -7.093170178e-03f, -7.126130096e-03f, -7.159074957e-03f, -7.192004705e-03f, -7.224919285e-03f, -7.257818642e-03f, -7.290702719e-03f, -7.323571462e-03f, -7.356424816e-03f,
-7.389262724e-03f, -7.422085131e-03f, -7.454891982e-03f, -7.487683222e-03f, -7.520458796e-03f, -7.553218647e-03f, -7.585962722e-03f, -7.618690964e-03f, -7.651403319e-03f, -7.684099732e-03f,
-7.716780147e-03f, -7.749444509e-03f, -7.782092764e-03f, -7.814724856e-03f, -7.847340730e-03f, -7.879940332e-03f, -7.912523607e-03f, -7.945090499e-03f, -7.977640955e-03f, -8.010174918e-03f,
-8.042692335e-03f, -8.075193150e-03f, -8.107677310e-03f, -8.140144758e-03f, -8.172595442e-03f, -8.205029305e-03f, -8.237446294e-03f, -8.269846354e-03f, -8.302229431e-03f, -8.334595470e-03f,
-8.366944416e-03f, -8.399276215e-03f, -8.431590814e-03f, -8.463888157e-03f, -8.496168190e-03f, -8.528430859e-03f, -8.560676110e-03f, -8.592903889e-03f, -8.625114141e-03f, -8.657306812e-03f,
-8.689481849e-03f, -8.721639197e-03f, -8.753778802e-03f, -8.785900611e-03f, -8.818004569e-03f, -8.850090622e-03f, -8.882158717e-03f, -8.914208799e-03f, -8.946240816e-03f, -8.978254712e-03f,
-9.010250435e-03f, -9.042227931e-03f, -9.074187146e-03f, -9.106128026e-03f, -9.138050518e-03f, -9.169954568e-03f, -9.201840123e-03f, -9.233707130e-03f, -9.265555534e-03f, -9.297385283e-03f,
-9.329196323e-03f, -9.360988601e-03f, -9.392762064e-03f, -9.424516657e-03f, -9.456252329e-03f, -9.487969025e-03f, -9.519666693e-03f, -9.551345280e-03f, -9.583004733e-03f, -9.614644997e-03f,
-9.646266022e-03f, -9.677867753e-03f, -9.709450137e-03f, -9.741013123e-03f, -9.772556656e-03f, -9.804080684e-03f, -9.835585155e-03f, -9.867070015e-03f, -9.898535212e-03f, -9.929980693e-03f,
-9.961406406e-03f, -9.992812298e-03f, -1.002419832e-02f, -1.005556441e-02f, -1.008691052e-02f, -1.011823661e-02f, -1.014954261e-02f, -1.018082847e-02f, -1.021209415e-02f, -1.024333958e-02f,
-1.027456473e-02f, -1.030576953e-02f, -1.033695393e-02f, -1.036811788e-02f, -1.039926134e-02f, -1.043038424e-02f, -1.046148653e-02f, -1.049256817e-02f, -1.052362910e-02f, -1.055466927e-02f,
-1.058568863e-02f, -1.061668712e-02f, -1.064766469e-02f, -1.067862130e-02f, -1.070955689e-02f, -1.074047141e-02f, -1.077136480e-02f, -1.080223703e-02f, -1.083308802e-02f, -1.086391774e-02f,
-1.089472613e-02f, -1.092551314e-02f, -1.095627872e-02f, -1.098702281e-02f, -1.101774537e-02f, -1.104844635e-02f, -1.107912569e-02f, -1.110978335e-02f, -1.114041926e-02f, -1.117103339e-02f,
-1.120162567e-02f, -1.123219606e-02f, -1.126274451e-02f, -1.129327097e-02f, -1.132377538e-02f, -1.135425770e-02f, -1.138471788e-02f, -1.141515585e-02f, -1.144557158e-02f, -1.147596501e-02f,
-1.150633609e-02f, -1.153668478e-02f, -1.156701101e-02f, -1.159731475e-02f, -1.162759593e-02f, -1.165785452e-02f, -1.168809045e-02f, -1.171830368e-02f, -1.174849416e-02f, -1.177866184e-02f,
-1.180880666e-02f, -1.183892859e-02f, -1.186902756e-02f, -1.189910353e-02f, -1.192915645e-02f, -1.195918627e-02f, -1.198919293e-02f, -1.201917639e-02f, -1.204913660e-02f, -1.207907351e-02f,
-1.210898707e-02f, -1.213887723e-02f, -1.216874394e-02f, -1.219858714e-02f, -1.222840680e-02f, -1.225820286e-02f, -1.228797527e-02f, -1.231772398e-02f, -1.234744895e-02f, -1.237715012e-02f,
-1.240682744e-02f, -1.243648087e-02f, -1.246611035e-02f, -1.249571584e-02f, -1.252529729e-02f, -1.255485465e-02f, -1.258438786e-02f, -1.261389689e-02f, -1.264338168e-02f, -1.267284218e-02f,
-1.270227835e-02f, -1.273169013e-02f, -1.276107747e-02f, -1.279044034e-02f, -1.281977867e-02f, -1.284909243e-02f, -1.287838155e-02f, -1.290764600e-02f, -1.293688573e-02f, -1.296610068e-02f,
-1.299529081e-02f, -1.302445607e-02f, -1.305359641e-02f, -1.308271179e-02f, -1.311180215e-02f, -1.314086745e-02f, -1.316990763e-02f, -1.319892266e-02f, -1.322791248e-02f, -1.325687705e-02f,
-1.328581632e-02f, -1.331473023e-02f, -1.334361875e-02f, -1.337248182e-02f, -1.340131939e-02f, -1.343013143e-02f, -1.345891787e-02f, -1.348767868e-02f, -1.351641381e-02f, -1.354512320e-02f,
-1.357380682e-02f, -1.360246461e-02f, -1.363109652e-02f, -1.365970252e-02f, -1.368828254e-02f, -1.371683656e-02f, -1.374536451e-02f, -1.377386635e-02f, -1.380234203e-02f, -1.383079151e-02f,
-1.385921474e-02f, -1.388761167e-02f, -1.391598226e-02f, -1.394432646e-02f, -1.397264423e-02f, -1.400093550e-02f, -1.402920025e-02f, -1.405743842e-02f, -1.408564997e-02f, -1.411383484e-02f,
-1.414199300e-02f, -1.417012440e-02f, -1.419822898e-02f, -1.422630672e-02f, -1.425435755e-02f, -1.428238143e-02f, -1.431037831e-02f, -1.433834816e-02f, -1.436629092e-02f, -1.439420655e-02f,
-1.442209500e-02f, -1.444995623e-02f, -1.447779019e-02f, -1.450559683e-02f, -1.453337611e-02f, -1.456112798e-02f, -1.458885240e-02f, -1.461654932e-02f, -1.464421870e-02f, -1.467186049e-02f,
-1.469947465e-02f, -1.472706112e-02f, -1.475461987e-02f, -1.478215085e-02f, -1.480965402e-02f, -1.483712932e-02f, -1.486457672e-02f, -1.489199616e-02f, -1.491938761e-02f, -1.494675102e-02f,
-1.497408635e-02f, -1.500139354e-02f, -1.502867256e-02f, -1.505592335e-02f, -1.508314589e-02f, -1.511034011e-02f, -1.513750598e-02f, -1.516464345e-02f, -1.519175248e-02f, -1.521883302e-02f,
-1.524588502e-02f, -1.527290846e-02f, -1.529990327e-02f, -1.532686941e-02f, -1.535380685e-02f, -1.538071554e-02f, -1.540759543e-02f, -1.543444647e-02f, -1.546126863e-02f, -1.548806187e-02f,
-1.551482613e-02f, -1.554156137e-02f, -1.556826756e-02f, -1.559494464e-02f, -1.562159257e-02f, -1.564821131e-02f, -1.567480082e-02f, -1.570136105e-02f, -1.572789196e-02f, -1.575439350e-02f,
-1.578086563e-02f, -1.580730832e-02f, -1.583372151e-02f, -1.586010516e-02f, -1.588645923e-02f, -1.591278368e-02f, -1.593907846e-02f, -1.596534353e-02f, -1.599157884e-02f, -1.601778437e-02f,
-1.604396005e-02f, -1.607010586e-02f, -1.609622174e-02f, -1.612230765e-02f, -1.614836356e-02f, -1.617438941e-02f, -1.620038517e-02f, -1.622635080e-02f, -1.625228625e-02f, -1.627819147e-02f,
-1.630406644e-02f, -1.632991110e-02f, -1.635572541e-02f, -1.638150933e-02f, -1.640726283e-02f, -1.643298585e-02f, -1.645867835e-02f, -1.648434030e-02f, -1.650997165e-02f, -1.653557236e-02f,
-1.656114239e-02f, -1.658668170e-02f, -1.661219024e-02f, -1.663766798e-02f, -1.666311486e-02f, -1.668853086e-02f, -1.671391593e-02f, -1.673927003e-02f, -1.676459311e-02f, -1.678988515e-02f,
-1.681514608e-02f, -1.684037588e-02f, -1.686557450e-02f, -1.689074191e-02f, -1.691587806e-02f, -1.694098290e-02f, -1.696605641e-02f, -1.699109854e-02f, -1.701610924e-02f, -1.704108849e-02f,
-1.706603623e-02f, -1.709095242e-02f, -1.711583704e-02f, -1.714069003e-02f, -1.716551135e-02f, -1.719030098e-02f, -1.721505885e-02f, -1.723978495e-02f, -1.726447922e-02f, -1.728914162e-02f,
-1.731377212e-02f, -1.733837068e-02f, -1.736293725e-02f, -1.738747180e-02f, -1.741197428e-02f, -1.743644466e-02f, -1.746088290e-02f, -1.748528896e-02f, -1.750966279e-02f, -1.753400437e-02f,
-1.755831364e-02f, -1.758259057e-02f, -1.760683513e-02f, -1.763104727e-02f, -1.765522695e-02f, -1.767937413e-02f, -1.770348878e-02f, -1.772757085e-02f, -1.775162031e-02f, -1.777563712e-02f,
-1.779962124e-02f, -1.782357263e-02f, -1.784749125e-02f, -1.787137706e-02f, -1.789523003e-02f, -1.791905012e-02f, -1.794283728e-02f, -1.796659149e-02f, -1.799031269e-02f, -1.801400086e-02f,
-1.803765596e-02f, -1.806127794e-02f, -1.808486677e-02f, -1.810842241e-02f, -1.813194482e-02f, -1.815543397e-02f, -1.817888982e-02f, -1.820231233e-02f, -1.822570146e-02f, -1.824905717e-02f,
-1.827237944e-02f, -1.829566821e-02f, -1.831892345e-02f, -1.834214513e-02f, -1.836533320e-02f, -1.838848764e-02f, -1.841160840e-02f, -1.843469544e-02f, -1.845774873e-02f, -1.848076824e-02f,
-1.850375392e-02f, -1.852670574e-02f, -1.854962365e-02f, -1.857250764e-02f, -1.859535765e-02f, -1.861817365e-02f, -1.864095561e-02f, -1.866370348e-02f, -1.868641724e-02f, -1.870909684e-02f,
-1.873174225e-02f, -1.875435344e-02f, -1.877693036e-02f, -1.879947298e-02f, -1.882198126e-02f, -1.884445517e-02f, -1.886689468e-02f, -1.888929974e-02f, -1.891167032e-02f, -1.893400639e-02f,
-1.895630790e-02f, -1.897857483e-02f, -1.900080714e-02f, -1.902300479e-02f, -1.904516774e-02f, -1.906729597e-02f, -1.908938944e-02f, -1.911144810e-02f, -1.913347193e-02f, -1.915546089e-02f,
-1.917741495e-02f, -1.919933407e-02f, -1.922121821e-02f, -1.924306734e-02f, -1.926488143e-02f, -1.928666044e-02f, -1.930840434e-02f, -1.933011309e-02f, -1.935178665e-02f, -1.937342500e-02f,
-1.939502810e-02f, -1.941659591e-02f, -1.943812840e-02f, -1.945962554e-02f, -1.948108729e-02f, -1.950251361e-02f, -1.952390448e-02f, -1.954525985e-02f, -1.956657970e-02f, -1.958786400e-02f,
-1.960911270e-02f, -1.963032577e-02f, -1.965150318e-02f, -1.967264490e-02f, -1.969375090e-02f, -1.971482113e-02f, -1.973585556e-02f, -1.975685418e-02f, -1.977781692e-02f, -1.979874378e-02f,
-1.981963471e-02f, -1.984048968e-02f, -1.986130865e-02f, -1.988209160e-02f, -1.990283849e-02f, -1.992354929e-02f, -1.994422396e-02f, -1.996486248e-02f, -1.998546480e-02f, -2.000603091e-02f,
-2.002656076e-02f, -2.004705432e-02f, -2.006751156e-02f, -2.008793244e-02f, -2.010831695e-02f, -2.012866503e-02f, -2.014897667e-02f, -2.016925183e-02f, -2.018949047e-02f, -2.020969257e-02f,
-2.022985810e-02f, -2.024998701e-02f, -2.027007929e-02f, -2.029013489e-02f, -2.031015379e-02f, -2.033013595e-02f, -2.035008135e-02f, -2.036998995e-02f, -2.038986172e-02f, -2.040969663e-02f,
-2.042949465e-02f, -2.044925575e-02f, -2.046897989e-02f, -2.048866705e-02f, -2.050831719e-02f, -2.052793028e-02f, -2.054750630e-02f, -2.056704521e-02f, -2.058654698e-02f, -2.060601158e-02f,
-2.062543898e-02f, -2.064482915e-02f, -2.066418206e-02f, -2.068349768e-02f, -2.070277598e-02f, -2.072201693e-02f, -2.074122049e-02f, -2.076038664e-02f, -2.077951535e-02f, -2.079860659e-02f,
-2.081766033e-02f, -2.083667654e-02f, -2.085565518e-02f, -2.087459623e-02f, -2.089349967e-02f, -2.091236545e-02f, -2.093119355e-02f, -2.094998395e-02f, -2.096873661e-02f, -2.098745150e-02f,
-2.100612859e-02f, -2.102476786e-02f, -2.104336927e-02f, -2.106193280e-02f, -2.108045841e-02f, -2.109894609e-02f, -2.111739579e-02f, -2.113580750e-02f, -2.115418117e-02f, -2.117251680e-02f,
-2.119081433e-02f, -2.120907375e-02f, -2.122729504e-02f, -2.124547815e-02f, -2.126362306e-02f, -2.128172975e-02f, -2.129979818e-02f, -2.131782833e-02f, -2.133582017e-02f, -2.135377367e-02f,
-2.137168880e-02f, -2.138956554e-02f, -2.140740386e-02f, -2.142520373e-02f, -2.144296512e-02f, -2.146068801e-02f, -2.147837237e-02f, -2.149601816e-02f, -2.151362538e-02f, -2.153119397e-02f,
-2.154872393e-02f, -2.156621522e-02f, -2.158366781e-02f, -2.160108168e-02f, -2.161845680e-02f, -2.163579315e-02f, -2.165309069e-02f, -2.167034941e-02f, -2.168756927e-02f, -2.170475025e-02f,
-2.172189232e-02f, -2.173899545e-02f, -2.175605962e-02f, -2.177308481e-02f, -2.179007098e-02f, -2.180701811e-02f, -2.182392618e-02f, -2.184079515e-02f, -2.185762501e-02f, -2.187441572e-02f,
-2.189116727e-02f, -2.190787961e-02f, -2.192455274e-02f, -2.194118662e-02f, -2.195778123e-02f, -2.197433655e-02f, -2.199085254e-02f, -2.200732918e-02f, -2.202376645e-02f, -2.204016432e-02f,
-2.205652277e-02f, -2.207284177e-02f, -2.208912129e-02f, -2.210536132e-02f, -2.212156183e-02f, -2.213772279e-02f, -2.215384417e-02f, -2.216992596e-02f, -2.218596813e-02f, -2.220197066e-02f,
-2.221793351e-02f, -2.223385667e-02f, -2.224974011e-02f, -2.226558380e-02f, -2.228138774e-02f, -2.229715187e-02f, -2.231287620e-02f, -2.232856069e-02f, -2.234420531e-02f, -2.235981005e-02f,
-2.237537488e-02f, -2.239089977e-02f, -2.240638471e-02f, -2.242182966e-02f, -2.243723462e-02f, -2.245259954e-02f, -2.246792442e-02f, -2.248320922e-02f, -2.249845393e-02f, -2.251365851e-02f,
-2.252882296e-02f, -2.254394724e-02f, -2.255903133e-02f, -2.257407520e-02f, -2.258907885e-02f, -2.260404224e-02f, -2.261896535e-02f, -2.263384816e-02f, -2.264869064e-02f, -2.266349278e-02f,
-2.267825455e-02f, -2.269297593e-02f, -2.270765690e-02f, -2.272229744e-02f, -2.273689751e-02f, -2.275145711e-02f, -2.276597621e-02f, -2.278045479e-02f, -2.279489282e-02f, -2.280929029e-02f,
-2.282364717e-02f, -2.283796345e-02f, -2.285223909e-02f, -2.286647408e-02f, -2.288066840e-02f, -2.289482203e-02f, -2.290893494e-02f, -2.292300712e-02f, -2.293703854e-02f, -2.295102919e-02f,
-2.296497904e-02f, -2.297888806e-02f, -2.299275625e-02f, -2.300658358e-02f, -2.302037003e-02f, -2.303411557e-02f, -2.304782020e-02f, -2.306148388e-02f, -2.307510661e-02f, -2.308868835e-02f,
-2.310222908e-02f, -2.311572880e-02f, -2.312918747e-02f, -2.314260508e-02f, -2.315598161e-02f, -2.316931704e-02f, -2.318261135e-02f, -2.319586452e-02f, -2.320907652e-02f, -2.322224735e-02f,
-2.323537698e-02f, -2.324846538e-02f, -2.326151256e-02f, -2.327451847e-02f, -2.328748311e-02f, -2.330040645e-02f, -2.331328849e-02f, -2.332612918e-02f, -2.333892853e-02f, -2.335168651e-02f,
-2.336440310e-02f, -2.337707828e-02f, -2.338971203e-02f, -2.340230434e-02f, -2.341485519e-02f, -2.342736456e-02f, -2.343983243e-02f, -2.345225878e-02f, -2.346464360e-02f, -2.347698686e-02f,
-2.348928855e-02f, -2.350154865e-02f, -2.351376715e-02f, -2.352594402e-02f, -2.353807925e-02f, -2.355017283e-02f, -2.356222472e-02f, -2.357423492e-02f, -2.358620341e-02f, -2.359813017e-02f,
-2.361001518e-02f, -2.362185843e-02f, -2.363365990e-02f, -2.364541957e-02f, -2.365713743e-02f, -2.366881346e-02f, -2.368044764e-02f, -2.369203995e-02f, -2.370359039e-02f, -2.371509893e-02f,
-2.372656555e-02f, -2.373799024e-02f, -2.374937299e-02f, -2.376071378e-02f, -2.377201258e-02f, -2.378326939e-02f, -2.379448419e-02f, -2.380565697e-02f, -2.381678770e-02f, -2.382787637e-02f,
-2.383892297e-02f, -2.384992747e-02f, -2.386088988e-02f, -2.387181016e-02f, -2.388268830e-02f, -2.389352430e-02f, -2.390431812e-02f, -2.391506977e-02f, -2.392577922e-02f, -2.393644645e-02f,
-2.394707146e-02f, -2.395765423e-02f, -2.396819474e-02f, -2.397869298e-02f, -2.398914893e-02f, -2.399956258e-02f, -2.400993391e-02f, -2.402026292e-02f, -2.403054958e-02f, -2.404079388e-02f,
-2.405099581e-02f, -2.406115536e-02f, -2.407127250e-02f, -2.408134723e-02f, -2.409137953e-02f, -2.410136938e-02f, -2.411131678e-02f, -2.412122171e-02f, -2.413108416e-02f, -2.414090410e-02f,
-2.415068154e-02f, -2.416041645e-02f, -2.417010883e-02f, -2.417975865e-02f, -2.418936591e-02f, -2.419893059e-02f, -2.420845269e-02f, -2.421793218e-02f, -2.422736905e-02f, -2.423676329e-02f,
-2.424611490e-02f, -2.425542384e-02f, -2.426469013e-02f, -2.427391373e-02f, -2.428309464e-02f, -2.429223284e-02f, -2.430132833e-02f, -2.431038109e-02f, -2.431939111e-02f, -2.432835838e-02f,
-2.433728288e-02f, -2.434616461e-02f, -2.435500354e-02f, -2.436379968e-02f, -2.437255300e-02f, -2.438126350e-02f, -2.438993117e-02f, -2.439855599e-02f, -2.440713795e-02f, -2.441567704e-02f,
-2.442417325e-02f, -2.443262656e-02f, -2.444103698e-02f, -2.444940448e-02f, -2.445772905e-02f, -2.446601069e-02f, -2.447424939e-02f, -2.448244512e-02f, -2.449059789e-02f, -2.449870768e-02f,
-2.450677448e-02f, -2.451479828e-02f, -2.452277907e-02f, -2.453071684e-02f, -2.453861158e-02f, -2.454646328e-02f, -2.455427193e-02f, -2.456203752e-02f, -2.456976004e-02f, -2.457743948e-02f,
-2.458507582e-02f, -2.459266907e-02f, -2.460021921e-02f, -2.460772623e-02f, -2.461519013e-02f, -2.462261088e-02f, -2.462998849e-02f, -2.463732294e-02f, -2.464461423e-02f, -2.465186234e-02f,
-2.465906727e-02f, -2.466622901e-02f, -2.467334754e-02f, -2.468042287e-02f, -2.468745498e-02f, -2.469444386e-02f, -2.470138950e-02f, -2.470829190e-02f, -2.471515105e-02f, -2.472196694e-02f,
-2.472873956e-02f, -2.473546890e-02f, -2.474215495e-02f, -2.474879772e-02f, -2.475539718e-02f, -2.476195333e-02f, -2.476846616e-02f, -2.477493567e-02f, -2.478136185e-02f, -2.478774469e-02f,
-2.479408418e-02f, -2.480038031e-02f, -2.480663309e-02f, -2.481284249e-02f, -2.481900852e-02f, -2.482513116e-02f, -2.483121041e-02f, -2.483724627e-02f, -2.484323872e-02f, -2.484918776e-02f,
-2.485509338e-02f, -2.486095557e-02f, -2.486677434e-02f, -2.487254966e-02f, -2.487828155e-02f, -2.488396998e-02f, -2.488961495e-02f, -2.489521646e-02f, -2.490077450e-02f, -2.490628907e-02f,
-2.491176015e-02f, -2.491718775e-02f, -2.492257185e-02f, -2.492791246e-02f, -2.493320956e-02f, -2.493846315e-02f, -2.494367323e-02f, -2.494883978e-02f, -2.495396280e-02f, -2.495904230e-02f,
-2.496407826e-02f, -2.496907067e-02f, -2.497401954e-02f, -2.497892486e-02f, -2.498378661e-02f, -2.498860481e-02f, -2.499337944e-02f, -2.499811050e-02f, -2.500279798e-02f, -2.500744188e-02f,
-2.501204219e-02f, -2.501659892e-02f, -2.502111205e-02f, -2.502558158e-02f, -2.503000751e-02f, -2.503438984e-02f, -2.503872855e-02f, -2.504302365e-02f, -2.504727513e-02f, -2.505148299e-02f,
-2.505564722e-02f, -2.505976782e-02f, -2.506384479e-02f, -2.506787813e-02f, -2.507186782e-02f, -2.507581387e-02f, -2.507971627e-02f, -2.508357502e-02f, -2.508739012e-02f, -2.509116157e-02f,
-2.509488935e-02f, -2.509857348e-02f, -2.510221394e-02f, -2.510581073e-02f, -2.510936385e-02f, -2.511287330e-02f, -2.511633907e-02f, -2.511976117e-02f, -2.512313958e-02f, -2.512647431e-02f,
-2.512976536e-02f, -2.513301272e-02f, -2.513621640e-02f, -2.513937638e-02f, -2.514249267e-02f, -2.514556527e-02f, -2.514859417e-02f, -2.515157937e-02f, -2.515452087e-02f, -2.515741867e-02f,
-2.516027277e-02f, -2.516308317e-02f, -2.516584985e-02f, -2.516857284e-02f, -2.517125211e-02f, -2.517388768e-02f, -2.517647954e-02f, -2.517902769e-02f, -2.518153212e-02f, -2.518399284e-02f,
-2.518640985e-02f, -2.518878315e-02f, -2.519111273e-02f, -2.519339860e-02f, -2.519564076e-02f, -2.519783919e-02f, -2.519999392e-02f, -2.520210492e-02f, -2.520417221e-02f, -2.520619579e-02f,
-2.520817565e-02f, -2.521011179e-02f, -2.521200422e-02f, -2.521385293e-02f, -2.521565793e-02f, -2.521741921e-02f, -2.521913678e-02f, -2.522081064e-02f, -2.522244078e-02f, -2.522402722e-02f,
-2.522556994e-02f, -2.522706895e-02f, -2.522852425e-02f, -2.522993584e-02f, -2.523130373e-02f, -2.523262791e-02f, -2.523390838e-02f, -2.523514515e-02f, -2.523633822e-02f, -2.523748759e-02f,
-2.523859326e-02f, -2.523965523e-02f, -2.524067351e-02f, -2.524164809e-02f, -2.524257898e-02f, -2.524346618e-02f, -2.524430969e-02f, -2.524510952e-02f, -2.524586566e-02f, -2.524657813e-02f,
-2.524724691e-02f, -2.524787201e-02f, -2.524845344e-02f, -2.524899120e-02f, -2.524948529e-02f, -2.524993571e-02f, -2.525034247e-02f, -2.525070557e-02f, -2.525102501e-02f, -2.525130079e-02f,
-2.525153292e-02f, -2.525172141e-02f, -2.525186624e-02f, -2.525196744e-02f, -2.525202499e-02f, -2.525203891e-02f, -2.525200920e-02f, -2.525193586e-02f, -2.525181889e-02f, -2.525165831e-02f,
-2.525145410e-02f, -2.525120628e-02f, -2.525091486e-02f, -2.525057982e-02f, -2.525020119e-02f, -2.524977896e-02f, -2.524931313e-02f, -2.524880372e-02f, -2.524825072e-02f, -2.524765414e-02f,
-2.524701399e-02f, -2.524633026e-02f, -2.524560297e-02f, -2.524483212e-02f, -2.524401771e-02f, -2.524315975e-02f, -2.524225825e-02f, -2.524131320e-02f, -2.524032462e-02f, -2.523929251e-02f,
-2.523821687e-02f, -2.523709771e-02f, -2.523593503e-02f, -2.523472885e-02f, -2.523347916e-02f, -2.523218598e-02f, -2.523084930e-02f, -2.522946914e-02f, -2.522804549e-02f, -2.522657837e-02f,
-2.522506778e-02f, -2.522351373e-02f, -2.522191623e-02f, -2.522027527e-02f, -2.521859087e-02f, -2.521686304e-02f, -2.521509177e-02f, -2.521327708e-02f, -2.521141897e-02f, -2.520951745e-02f,
-2.520757252e-02f, -2.520558420e-02f, -2.520355249e-02f, -2.520147739e-02f, -2.519935892e-02f, -2.519719708e-02f, -2.519499188e-02f, -2.519274333e-02f, -2.519045142e-02f, -2.518811618e-02f,
-2.518573761e-02f, -2.518331571e-02f, -2.518085049e-02f, -2.517834197e-02f, -2.517579014e-02f, -2.517319502e-02f, -2.517055662e-02f, -2.516787494e-02f, -2.516514999e-02f, -2.516238178e-02f,
-2.515957031e-02f, -2.515671560e-02f, -2.515381766e-02f, -2.515087649e-02f, -2.514789210e-02f, -2.514486450e-02f, -2.514179369e-02f, -2.513867970e-02f, -2.513552252e-02f, -2.513232217e-02f,
-2.512907865e-02f, -2.512579197e-02f, -2.512246215e-02f, -2.511908918e-02f, -2.511567309e-02f, -2.511221388e-02f, -2.510871156e-02f, -2.510516613e-02f, -2.510157762e-02f, -2.509794603e-02f,
-2.509427136e-02f, -2.509055363e-02f, -2.508679285e-02f, -2.508298903e-02f, -2.507914217e-02f, -2.507525229e-02f, -2.507131940e-02f, -2.506734351e-02f, -2.506332463e-02f, -2.505926277e-02f,
-2.505515794e-02f, -2.505101014e-02f, -2.504681940e-02f, -2.504258572e-02f, -2.503830911e-02f, -2.503398959e-02f, -2.502962716e-02f, -2.502522183e-02f, -2.502077362e-02f, -2.501628254e-02f,
-2.501174860e-02f, -2.500717180e-02f, -2.500255217e-02f, -2.499788971e-02f, -2.499318443e-02f, -2.498843635e-02f, -2.498364548e-02f, -2.497881182e-02f, -2.497393540e-02f, -2.496901622e-02f,
-2.496405429e-02f, -2.495904963e-02f, -2.495400225e-02f, -2.494891216e-02f, -2.494377937e-02f, -2.493860390e-02f, -2.493338575e-02f, -2.492812495e-02f, -2.492282150e-02f, -2.491747541e-02f,
-2.491208670e-02f, -2.490665538e-02f, -2.490118147e-02f, -2.489566497e-02f, -2.489010590e-02f, -2.488450427e-02f, -2.487886010e-02f, -2.487317340e-02f, -2.486744418e-02f, -2.486167245e-02f,
-2.485585824e-02f, -2.485000154e-02f, -2.484410238e-02f, -2.483816077e-02f, -2.483217672e-02f, -2.482615025e-02f, -2.482008137e-02f, -2.481397009e-02f, -2.480781643e-02f, -2.480162040e-02f,
-2.479538202e-02f, -2.478910130e-02f, -2.478277826e-02f, -2.477641290e-02f, -2.477000525e-02f, -2.476355531e-02f, -2.475706311e-02f, -2.475052866e-02f, -2.474395196e-02f, -2.473733304e-02f,
-2.473067192e-02f, -2.472396860e-02f, -2.471722310e-02f, -2.471043544e-02f, -2.470360563e-02f, -2.469673368e-02f, -2.468981962e-02f, -2.468286345e-02f, -2.467586520e-02f, -2.466882487e-02f,
-2.466174249e-02f, -2.465461807e-02f, -2.464745162e-02f, -2.464024316e-02f, -2.463299271e-02f, -2.462570028e-02f, -2.461836589e-02f, -2.461098955e-02f, -2.460357128e-02f, -2.459611110e-02f,
-2.458860902e-02f, -2.458106506e-02f, -2.457347924e-02f, -2.456585157e-02f, -2.455818207e-02f, -2.455047075e-02f, -2.454271763e-02f, -2.453492273e-02f, -2.452708607e-02f, -2.451920766e-02f,
-2.451128752e-02f, -2.450332566e-02f, -2.449532211e-02f, -2.448727688e-02f, -2.447918998e-02f, -2.447106144e-02f, -2.446289127e-02f, -2.445467950e-02f, -2.444642612e-02f, -2.443813118e-02f,
-2.442979468e-02f, -2.442141663e-02f, -2.441299707e-02f, -2.440453600e-02f, -2.439603344e-02f, -2.438748942e-02f, -2.437890394e-02f, -2.437027704e-02f, -2.436160872e-02f, -2.435289900e-02f,
-2.434414791e-02f, -2.433535546e-02f, -2.432652167e-02f, -2.431764656e-02f, -2.430873014e-02f, -2.429977244e-02f, -2.429077348e-02f, -2.428173326e-02f, -2.427265182e-02f, -2.426352918e-02f,
-2.425436534e-02f, -2.424516033e-02f, -2.423591417e-02f, -2.422662688e-02f, -2.421729847e-02f, -2.420792897e-02f, -2.419851840e-02f, -2.418906677e-02f, -2.417957411e-02f, -2.417004044e-02f,
-2.416046576e-02f, -2.415085012e-02f, -2.414119351e-02f, -2.413149597e-02f, -2.412175752e-02f, -2.411197817e-02f, -2.410215794e-02f, -2.409229686e-02f, -2.408239495e-02f, -2.407245222e-02f,
-2.406246869e-02f, -2.405244440e-02f, -2.404237935e-02f, -2.403227356e-02f, -2.402212707e-02f, -2.401193988e-02f, -2.400171203e-02f, -2.399144352e-02f, -2.398113439e-02f, -2.397078465e-02f,
-2.396039432e-02f, -2.394996343e-02f, -2.393949200e-02f, -2.392898004e-02f, -2.391842759e-02f, -2.390783465e-02f, -2.389720126e-02f, -2.388652742e-02f, -2.387581318e-02f, -2.386505854e-02f,
-2.385426353e-02f, -2.384342818e-02f, -2.383255249e-02f, -2.382163650e-02f, -2.381068023e-02f, -2.379968369e-02f, -2.378864692e-02f, -2.377756993e-02f, -2.376645275e-02f, -2.375529539e-02f,
-2.374409789e-02f, -2.373286026e-02f, -2.372158252e-02f, -2.371026470e-02f, -2.369890683e-02f, -2.368750892e-02f, -2.367607099e-02f, -2.366459308e-02f, -2.365307519e-02f, -2.364151737e-02f,
-2.362991962e-02f, -2.361828198e-02f, -2.360660446e-02f, -2.359488709e-02f, -2.358312990e-02f, -2.357133289e-02f, -2.355949611e-02f, -2.354761958e-02f, -2.353570330e-02f, -2.352374732e-02f,
-2.351175166e-02f, -2.349971633e-02f, -2.348764136e-02f, -2.347552678e-02f, -2.346337261e-02f, -2.345117888e-02f, -2.343894560e-02f, -2.342667281e-02f, -2.341436052e-02f, -2.340200877e-02f,
-2.338961757e-02f, -2.337718695e-02f, -2.336471694e-02f, -2.335220756e-02f, -2.333965883e-02f, -2.332707079e-02f, -2.331444344e-02f, -2.330177683e-02f, -2.328907097e-02f, -2.327632589e-02f,
-2.326354161e-02f, -2.325071817e-02f, -2.323785558e-02f, -2.322495387e-02f, -2.321201306e-02f, -2.319903319e-02f, -2.318601428e-02f, -2.317295634e-02f, -2.315985942e-02f, -2.314672352e-02f,
-2.313354869e-02f, -2.312033494e-02f, -2.310708231e-02f, -2.309379081e-02f, -2.308046048e-02f, -2.306709133e-02f, -2.305368340e-02f, -2.304023671e-02f, -2.302675129e-02f, -2.301322717e-02f,
-2.299966436e-02f, -2.298606291e-02f, -2.297242283e-02f, -2.295874414e-02f, -2.294502689e-02f, -2.293127109e-02f, -2.291747677e-02f, -2.290364396e-02f, -2.288977268e-02f, -2.287586297e-02f,
-2.286191484e-02f, -2.284792834e-02f, -2.283390347e-02f, -2.281984027e-02f, -2.280573878e-02f, -2.279159900e-02f, -2.277742099e-02f, -2.276320475e-02f, -2.274895032e-02f, -2.273465772e-02f,
-2.272032699e-02f, -2.270595815e-02f, -2.269155123e-02f, -2.267710625e-02f, -2.266262325e-02f, -2.264810225e-02f, -2.263354329e-02f, -2.261894638e-02f, -2.260431156e-02f, -2.258963885e-02f,
-2.257492829e-02f, -2.256017990e-02f, -2.254539372e-02f, -2.253056976e-02f, -2.251570806e-02f, -2.250080865e-02f, -2.248587155e-02f, -2.247089679e-02f, -2.245588441e-02f, -2.244083443e-02f,
-2.242574689e-02f, -2.241062180e-02f, -2.239545920e-02f, -2.238025912e-02f, -2.236502159e-02f, -2.234974663e-02f, -2.233443428e-02f, -2.231908457e-02f, -2.230369752e-02f, -2.228827316e-02f,
-2.227281153e-02f, -2.225731265e-02f, -2.224177656e-02f, -2.222620328e-02f, -2.221059284e-02f, -2.219494528e-02f, -2.217926062e-02f, -2.216353889e-02f, -2.214778013e-02f, -2.213198435e-02f,
-2.211615161e-02f, -2.210028191e-02f, -2.208437530e-02f, -2.206843181e-02f, -2.205245146e-02f, -2.203643428e-02f, -2.202038032e-02f, -2.200428958e-02f, -2.198816212e-02f, -2.197199795e-02f,
-2.195579712e-02f, -2.193955964e-02f, -2.192328556e-02f, -2.190697489e-02f, -2.189062768e-02f, -2.187424395e-02f, -2.185782374e-02f, -2.184136708e-02f, -2.182487399e-02f, -2.180834451e-02f,
-2.179177868e-02f, -2.177517651e-02f, -2.175853805e-02f, -2.174186333e-02f, -2.172515237e-02f, -2.170840521e-02f, -2.169162188e-02f, -2.167480241e-02f, -2.165794684e-02f, -2.164105519e-02f,
-2.162412750e-02f, -2.160716381e-02f, -2.159016413e-02f, -2.157312851e-02f, -2.155605698e-02f, -2.153894957e-02f, -2.152180630e-02f, -2.150462723e-02f, -2.148741236e-02f, -2.147016175e-02f,
-2.145287542e-02f, -2.143555341e-02f, -2.141819574e-02f, -2.140080245e-02f, -2.138337358e-02f, -2.136590915e-02f, -2.134840920e-02f, -2.133087376e-02f, -2.131330287e-02f, -2.129569655e-02f,
-2.127805485e-02f, -2.126037779e-02f, -2.124266541e-02f, -2.122491774e-02f, -2.120713481e-02f, -2.118931667e-02f, -2.117146333e-02f, -2.115357484e-02f, -2.113565123e-02f, -2.111769253e-02f,
-2.109969878e-02f, -2.108167001e-02f, -2.106360626e-02f, -2.104550755e-02f, -2.102737393e-02f, -2.100920542e-02f, -2.099100206e-02f, -2.097276389e-02f, -2.095449093e-02f, -2.093618323e-02f,
-2.091784082e-02f, -2.089946373e-02f, -2.088105200e-02f, -2.086260565e-02f, -2.084412474e-02f, -2.082560928e-02f, -2.080705932e-02f, -2.078847489e-02f, -2.076985602e-02f, -2.075120275e-02f,
-2.073251512e-02f, -2.071379316e-02f, -2.069503690e-02f, -2.067624638e-02f, -2.065742163e-02f, -2.063856270e-02f, -2.061966961e-02f, -2.060074240e-02f, -2.058178111e-02f, -2.056278577e-02f,
-2.054375642e-02f, -2.052469309e-02f, -2.050559581e-02f, -2.048646463e-02f, -2.046729958e-02f, -2.044810070e-02f, -2.042886802e-02f, -2.040960157e-02f, -2.039030140e-02f, -2.037096753e-02f,
-2.035160001e-02f, -2.033219887e-02f, -2.031276415e-02f, -2.029329588e-02f, -2.027379411e-02f, -2.025425885e-02f, -2.023469016e-02f, -2.021508807e-02f, -2.019545262e-02f, -2.017578383e-02f,
-2.015608176e-02f, -2.013634643e-02f, -2.011657788e-02f, -2.009677615e-02f, -2.007694128e-02f, -2.005707329e-02f, -2.003717224e-02f, -2.001723816e-02f, -1.999727107e-02f, -1.997727103e-02f,
-1.995723806e-02f, -1.993717221e-02f, -1.991707351e-02f, -1.989694200e-02f, -1.987677772e-02f, -1.985658070e-02f, -1.983635098e-02f, -1.981608860e-02f, -1.979579360e-02f, -1.977546601e-02f,
-1.975510588e-02f, -1.973471323e-02f, -1.971428811e-02f, -1.969383055e-02f, -1.967334060e-02f, -1.965281829e-02f, -1.963226366e-02f, -1.961167674e-02f, -1.959105758e-02f, -1.957040622e-02f,
-1.954972268e-02f, -1.952900702e-02f, -1.950825926e-02f, -1.948747945e-02f, -1.946666762e-02f, -1.944582382e-02f, -1.942494808e-02f, -1.940404044e-02f, -1.938310093e-02f, -1.936212961e-02f,
-1.934112650e-02f, -1.932009165e-02f, -1.929902509e-02f, -1.927792686e-02f, -1.925679701e-02f, -1.923563556e-02f, -1.921444257e-02f, -1.919321806e-02f, -1.917196209e-02f, -1.915067468e-02f,
-1.912935587e-02f, -1.910800571e-02f, -1.908662424e-02f, -1.906521149e-02f, -1.904376751e-02f, -1.902229233e-02f, -1.900078599e-02f, -1.897924853e-02f, -1.895768000e-02f, -1.893608042e-02f,
-1.891444985e-02f, -1.889278832e-02f, -1.887109587e-02f, -1.884937255e-02f, -1.882761838e-02f, -1.880583341e-02f, -1.878401769e-02f, -1.876217125e-02f, -1.874029413e-02f, -1.871838637e-02f,
-1.869644801e-02f, -1.867447909e-02f, -1.865247966e-02f, -1.863044974e-02f, -1.860838940e-02f, -1.858629865e-02f, -1.856417755e-02f, -1.854202613e-02f, -1.851984444e-02f, -1.849763252e-02f,
-1.847539040e-02f, -1.845311813e-02f, -1.843081575e-02f, -1.840848330e-02f, -1.838612082e-02f, -1.836372835e-02f, -1.834130593e-02f, -1.831885360e-02f, -1.829637141e-02f, -1.827385940e-02f,
-1.825131760e-02f, -1.822874606e-02f, -1.820614482e-02f, -1.818351392e-02f, -1.816085341e-02f, -1.813816331e-02f, -1.811544368e-02f, -1.809269456e-02f, -1.806991599e-02f, -1.804710801e-02f,
-1.802427065e-02f, -1.800140398e-02f, -1.797850801e-02f, -1.795558281e-02f, -1.793262840e-02f, -1.790964483e-02f, -1.788663215e-02f, -1.786359039e-02f, -1.784051960e-02f, -1.781741982e-02f,
-1.779429109e-02f, -1.777113345e-02f, -1.774794695e-02f, -1.772473163e-02f, -1.770148752e-02f, -1.767821468e-02f, -1.765491315e-02f, -1.763158296e-02f, -1.760822416e-02f, -1.758483680e-02f,
-1.756142091e-02f, -1.753797654e-02f, -1.751450373e-02f, -1.749100252e-02f, -1.746747296e-02f, -1.744391509e-02f, -1.742032895e-02f, -1.739671459e-02f, -1.737307204e-02f, -1.734940136e-02f,
-1.732570257e-02f, -1.730197574e-02f, -1.727822090e-02f, -1.725443809e-02f, -1.723062736e-02f, -1.720678875e-02f, -1.718292230e-02f, -1.715902806e-02f, -1.713510607e-02f, -1.711115637e-02f,
-1.708717901e-02f, -1.706317404e-02f, -1.703914148e-02f, -1.701508140e-02f, -1.699099383e-02f, -1.696687881e-02f, -1.694273639e-02f, -1.691856662e-02f, -1.689436953e-02f, -1.687014518e-02f,
-1.684589360e-02f, -1.682161484e-02f, -1.679730894e-02f, -1.677297595e-02f, -1.674861591e-02f, -1.672422887e-02f, -1.669981487e-02f, -1.667537395e-02f, -1.665090616e-02f, -1.662641154e-02f,
-1.660189014e-02f, -1.657734200e-02f, -1.655276717e-02f, -1.652816569e-02f, -1.650353760e-02f, -1.647888295e-02f, -1.645420179e-02f, -1.642949416e-02f, -1.640476010e-02f, -1.637999966e-02f,
-1.635521289e-02f, -1.633039982e-02f, -1.630556050e-02f, -1.628069499e-02f, -1.625580331e-02f, -1.623088553e-02f, -1.620594168e-02f, -1.618097180e-02f, -1.615597596e-02f, -1.613095417e-02f,
-1.610590651e-02f, -1.608083300e-02f, -1.605573370e-02f, -1.603060865e-02f, -1.600545789e-02f, -1.598028147e-02f, -1.595507944e-02f, -1.592985185e-02f, -1.590459872e-02f, -1.587932013e-02f,
-1.585401610e-02f, -1.582868668e-02f, -1.580333193e-02f, -1.577795188e-02f, -1.575254658e-02f, -1.572711608e-02f, -1.570166043e-02f, -1.567617966e-02f, -1.565067383e-02f, -1.562514298e-02f,
-1.559958715e-02f, -1.557400640e-02f, -1.554840077e-02f, -1.552277031e-02f, -1.549711506e-02f, -1.547143506e-02f, -1.544573037e-02f, -1.542000103e-02f, -1.539424709e-02f, -1.536846859e-02f,
-1.534266558e-02f, -1.531683810e-02f, -1.529098621e-02f, -1.526510995e-02f, -1.523920937e-02f, -1.521328450e-02f, -1.518733541e-02f, -1.516136213e-02f, -1.513536472e-02f, -1.510934321e-02f,
-1.508329766e-02f, -1.505722812e-02f, -1.503113462e-02f, -1.500501722e-02f, -1.497887596e-02f, -1.495271090e-02f, -1.492652207e-02f, -1.490030953e-02f, -1.487407332e-02f, -1.484781349e-02f,
-1.482153009e-02f, -1.479522315e-02f, -1.476889275e-02f, -1.474253890e-02f, -1.471616168e-02f, -1.468976111e-02f, -1.466333726e-02f, -1.463689017e-02f, -1.461041988e-02f, -1.458392644e-02f,
-1.455740990e-02f, -1.453087031e-02f, -1.450430772e-02f, -1.447772217e-02f, -1.445111371e-02f, -1.442448239e-02f, -1.439782826e-02f, -1.437115136e-02f, -1.434445174e-02f, -1.431772945e-02f,
-1.429098454e-02f, -1.426421705e-02f, -1.423742704e-02f, -1.421061455e-02f, -1.418377963e-02f, -1.415692233e-02f, -1.413004270e-02f, -1.410314078e-02f, -1.407621662e-02f, -1.404927027e-02f,
-1.402230178e-02f, -1.399531119e-02f, -1.396829857e-02f, -1.394126394e-02f, -1.391420737e-02f, -1.388712890e-02f, -1.386002858e-02f, -1.383290645e-02f, -1.380576257e-02f, -1.377859699e-02f,
-1.375140975e-02f, -1.372420090e-02f, -1.369697049e-02f, -1.366971857e-02f, -1.364244519e-02f, -1.361515039e-02f, -1.358783423e-02f, -1.356049676e-02f, -1.353313802e-02f, -1.350575806e-02f,
-1.347835693e-02f, -1.345093468e-02f, -1.342349136e-02f, -1.339602702e-02f, -1.336854170e-02f, -1.334103546e-02f, -1.331350835e-02f, -1.328596041e-02f, -1.325839170e-02f, -1.323080225e-02f,
-1.320319213e-02f, -1.317556138e-02f, -1.314791005e-02f, -1.312023819e-02f, -1.309254585e-02f, -1.306483308e-02f, -1.303709993e-02f, -1.300934645e-02f, -1.298157268e-02f, -1.295377868e-02f,
-1.292596449e-02f, -1.289813017e-02f, -1.287027577e-02f, -1.284240133e-02f, -1.281450691e-02f, -1.278659255e-02f, -1.275865830e-02f, -1.273070422e-02f, -1.270273035e-02f, -1.267473675e-02f,
-1.264672346e-02f, -1.261869053e-02f, -1.259063802e-02f, -1.256256597e-02f, -1.253447443e-02f, -1.250636346e-02f, -1.247823310e-02f, -1.245008340e-02f, -1.242191442e-02f, -1.239372620e-02f,
-1.236551880e-02f, -1.233729226e-02f, -1.230904663e-02f, -1.228078197e-02f, -1.225249832e-02f, -1.222419574e-02f, -1.219587427e-02f, -1.216753397e-02f, -1.213917488e-02f, -1.211079706e-02f,
-1.208240056e-02f, -1.205398543e-02f, -1.202555171e-02f, -1.199709947e-02f, -1.196862874e-02f, -1.194013958e-02f, -1.191163204e-02f, -1.188310617e-02f, -1.185456203e-02f, -1.182599966e-02f,
-1.179741911e-02f, -1.176882043e-02f, -1.174020368e-02f, -1.171156890e-02f, -1.168291615e-02f, -1.165424548e-02f, -1.162555694e-02f, -1.159685057e-02f, -1.156812643e-02f, -1.153938458e-02f,
-1.151062506e-02f, -1.148184792e-02f, -1.145305321e-02f, -1.142424099e-02f, -1.139541130e-02f, -1.136656421e-02f, -1.133769975e-02f, -1.130881798e-02f, -1.127991895e-02f, -1.125100271e-02f,
-1.122206932e-02f, -1.119311882e-02f, -1.116415127e-02f, -1.113516671e-02f, -1.110616520e-02f, -1.107714679e-02f, -1.104811154e-02f, -1.101905948e-02f, -1.098999069e-02f, -1.096090519e-02f,
-1.093180306e-02f, -1.090268433e-02f, -1.087354906e-02f, -1.084439731e-02f, -1.081522911e-02f, -1.078604454e-02f, -1.075684363e-02f, -1.072762644e-02f, -1.069839302e-02f, -1.066914342e-02f,
-1.063987769e-02f, -1.061059589e-02f, -1.058129807e-02f, -1.055198427e-02f, -1.052265456e-02f, -1.049330898e-02f, -1.046394759e-02f, -1.043457043e-02f, -1.040517756e-02f, -1.037576903e-02f,
-1.034634489e-02f, -1.031690520e-02f, -1.028745000e-02f, -1.025797935e-02f, -1.022849331e-02f, -1.019899191e-02f, -1.016947522e-02f, -1.013994329e-02f, -1.011039617e-02f, -1.008083390e-02f,
-1.005125655e-02f, -1.002166417e-02f, -9.992056807e-03f, -9.962434512e-03f, -9.932797340e-03f, -9.903145343e-03f, -9.873478573e-03f, -9.843797083e-03f, -9.814100924e-03f, -9.784390150e-03f,
-9.754664813e-03f, -9.724924965e-03f, -9.695170659e-03f, -9.665401947e-03f, -9.635618882e-03f, -9.605821516e-03f, -9.576009902e-03f, -9.546184092e-03f, -9.516344139e-03f, -9.486490095e-03f,
-9.456622014e-03f, -9.426739947e-03f, -9.396843948e-03f, -9.366934069e-03f, -9.337010364e-03f, -9.307072883e-03f, -9.277121681e-03f, -9.247156810e-03f, -9.217178323e-03f, -9.187186273e-03f,
-9.157180712e-03f, -9.127161694e-03f, -9.097129271e-03f, -9.067083496e-03f, -9.037024422e-03f, -9.006952101e-03f, -8.976866588e-03f, -8.946767935e-03f, -8.916656194e-03f, -8.886531420e-03f,
-8.856393664e-03f, -8.826242980e-03f, -8.796079420e-03f, -8.765903039e-03f, -8.735713889e-03f, -8.705512023e-03f, -8.675297494e-03f, -8.645070356e-03f, -8.614830661e-03f, -8.584578462e-03f,
-8.554313814e-03f, -8.524036769e-03f, -8.493747380e-03f, -8.463445701e-03f, -8.433131785e-03f, -8.402805685e-03f, -8.372467454e-03f, -8.342117146e-03f, -8.311754814e-03f, -8.281380511e-03f,
-8.250994291e-03f, -8.220596207e-03f, -8.190186313e-03f, -8.159764661e-03f, -8.129331306e-03f, -8.098886301e-03f, -8.068429699e-03f, -8.037961554e-03f, -8.007481918e-03f, -7.976990847e-03f,
-7.946488393e-03f, -7.915974609e-03f, -7.885449550e-03f, -7.854913268e-03f, -7.824365818e-03f, -7.793807253e-03f, -7.763237627e-03f, -7.732656993e-03f, -7.702065405e-03f, -7.671462916e-03f,
-7.640849580e-03f, -7.610225452e-03f, -7.579590584e-03f, -7.548945030e-03f, -7.518288844e-03f, -7.487622080e-03f, -7.456944792e-03f, -7.426257033e-03f, -7.395558857e-03f, -7.364850317e-03f,
-7.334131469e-03f, -7.303402365e-03f, -7.272663059e-03f, -7.241913605e-03f, -7.211154058e-03f, -7.180384470e-03f, -7.149604896e-03f, -7.118815390e-03f, -7.088016005e-03f, -7.057206796e-03f,
-7.026387816e-03f, -6.995559120e-03f, -6.964720761e-03f, -6.933872793e-03f, -6.903015271e-03f, -6.872148248e-03f, -6.841271779e-03f, -6.810385917e-03f, -6.779490716e-03f, -6.748586231e-03f,
-6.717672515e-03f, -6.686749623e-03f, -6.655817608e-03f, -6.624876526e-03f, -6.593926429e-03f, -6.562967372e-03f, -6.531999409e-03f, -6.501022595e-03f, -6.470036983e-03f, -6.439042628e-03f,
-6.408039583e-03f, -6.377027904e-03f, -6.346007643e-03f, -6.314978856e-03f, -6.283941596e-03f, -6.252895918e-03f, -6.221841876e-03f, -6.190779525e-03f, -6.159708918e-03f, -6.128630110e-03f,
-6.097543154e-03f, -6.066448107e-03f, -6.035345020e-03f, -6.004233950e-03f, -5.973114950e-03f, -5.941988075e-03f, -5.910853378e-03f, -5.879710915e-03f, -5.848560739e-03f, -5.817402906e-03f,
-5.786237468e-03f, -5.755064482e-03f, -5.723884000e-03f, -5.692696078e-03f, -5.661500770e-03f, -5.630298130e-03f, -5.599088213e-03f, -5.567871074e-03f, -5.536646765e-03f, -5.505415343e-03f,
-5.474176862e-03f, -5.442931375e-03f, -5.411678938e-03f, -5.380419604e-03f, -5.349153429e-03f, -5.317880467e-03f, -5.286600773e-03f, -5.255314400e-03f, -5.224021404e-03f, -5.192721838e-03f,
-5.161415758e-03f, -5.130103219e-03f, -5.098784273e-03f, -5.067458977e-03f, -5.036127384e-03f, -5.004789550e-03f, -4.973445528e-03f, -4.942095374e-03f, -4.910739141e-03f, -4.879376886e-03f,
-4.848008661e-03f, -4.816634522e-03f, -4.785254523e-03f, -4.753868719e-03f, -4.722477165e-03f, -4.691079915e-03f, -4.659677024e-03f, -4.628268546e-03f, -4.596854536e-03f, -4.565435049e-03f,
-4.534010140e-03f, -4.502579862e-03f, -4.471144271e-03f, -4.439703422e-03f, -4.408257368e-03f, -4.376806165e-03f, -4.345349867e-03f, -4.313888530e-03f, -4.282422207e-03f, -4.250950954e-03f,
-4.219474825e-03f, -4.187993874e-03f, -4.156508157e-03f, -4.125017729e-03f, -4.093522643e-03f, -4.062022955e-03f, -4.030518720e-03f, -3.999009991e-03f, -3.967496824e-03f, -3.935979274e-03f,
-3.904457395e-03f, -3.872931243e-03f, -3.841400871e-03f, -3.809866334e-03f, -3.778327688e-03f, -3.746784986e-03f, -3.715238285e-03f, -3.683687638e-03f, -3.652133100e-03f, -3.620574726e-03f,
-3.589012571e-03f, -3.557446690e-03f, -3.525877137e-03f, -3.494303967e-03f, -3.462727235e-03f, -3.431146995e-03f, -3.399563303e-03f, -3.367976213e-03f, -3.336385780e-03f, -3.304792058e-03f,
-3.273195104e-03f, -3.241594970e-03f, -3.209991712e-03f, -3.178385386e-03f, -3.146776044e-03f, -3.115163744e-03f, -3.083548538e-03f, -3.051930483e-03f, -3.020309632e-03f, -2.988686040e-03f,
-2.957059763e-03f, -2.925430856e-03f, -2.893799372e-03f, -2.862165366e-03f, -2.830528895e-03f, -2.798890011e-03f, -2.767248771e-03f, -2.735605228e-03f, -2.703959438e-03f, -2.672311455e-03f,
-2.640661335e-03f, -2.609009132e-03f, -2.577354900e-03f, -2.545698695e-03f, -2.514040571e-03f, -2.482380583e-03f, -2.450718787e-03f, -2.419055236e-03f, -2.387389985e-03f, -2.355723090e-03f,
-2.324054604e-03f, -2.292384584e-03f, -2.260713083e-03f, -2.229040156e-03f, -2.197365859e-03f, -2.165690245e-03f, -2.134013370e-03f, -2.102335288e-03f, -2.070656055e-03f, -2.038975724e-03f,
-2.007294351e-03f, -1.975611990e-03f, -1.943928697e-03f, -1.912244526e-03f, -1.880559531e-03f, -1.848873768e-03f, -1.817187290e-03f, -1.785500154e-03f, -1.753812413e-03f, -1.722124123e-03f,
-1.690435338e-03f, -1.658746112e-03f, -1.627056501e-03f, -1.595366560e-03f, -1.563676342e-03f, -1.531985903e-03f, -1.500295297e-03f, -1.468604579e-03f, -1.436913804e-03f, -1.405223027e-03f,
-1.373532302e-03f, -1.341841683e-03f, -1.310151226e-03f, -1.278460985e-03f, -1.246771015e-03f, -1.215081371e-03f, -1.183392107e-03f, -1.151703277e-03f, -1.120014937e-03f, -1.088327142e-03f,
-1.056639945e-03f, -1.024953401e-03f, -9.932675654e-04f, -9.615824925e-04f, -9.298982368e-04f, -8.982148531e-04f, -8.665323959e-04f, -8.348509198e-04f, -8.031704793e-04f, -7.714911292e-04f,
-7.398129239e-04f, -7.081359181e-04f, -6.764601664e-04f, -6.447857232e-04f, -6.131126431e-04f, -5.814409807e-04f, -5.497707906e-04f, -5.181021273e-04f, -4.864350452e-04f, -4.547695990e-04f,
-4.231058432e-04f, -3.914438322e-04f, -3.597836205e-04f, -3.281252628e-04f, -2.964688133e-04f, -2.648143267e-04f, -2.331618574e-04f, -2.015114599e-04f, -1.698631885e-04f, -1.382170979e-04f,
-1.065732423e-04f, -7.493167631e-05f, -4.329245426e-05f, -1.165563059e-05f, 1.997874028e-05f, 5.161060397e-05f, 8.323990608e-05f, 1.148665922e-04f, 1.464906080e-04f, 1.781118991e-04f,
2.097304112e-04f, 2.413460898e-04f, 2.729588807e-04f, 3.045687296e-04f, 3.361755820e-04f, 3.677793837e-04f, 3.993800805e-04f, 4.309776179e-04f, 4.625719418e-04f, 4.941629979e-04f,
5.257507318e-04f, 5.573350894e-04f, 5.889160164e-04f, 6.204934586e-04f, 6.520673617e-04f, 6.836376716e-04f, 7.152043340e-04f, 7.467672947e-04f, 7.783264997e-04f, 8.098818946e-04f,
8.414334254e-04f, 8.729810379e-04f, 9.045246779e-04f, 9.360642914e-04f, 9.675998242e-04f, 9.991312223e-04f, 1.030658431e-03f, 1.062181398e-03f, 1.093700067e-03f, 1.125214385e-03f,
1.156724298e-03f, 1.188229752e-03f, 1.219730693e-03f, 1.251227066e-03f, 1.282718819e-03f, 1.314205896e-03f, 1.345688244e-03f, 1.377165809e-03f, 1.408638537e-03f, 1.440106374e-03f,
1.471569266e-03f, 1.503027159e-03f, 1.534480000e-03f, 1.565927734e-03f, 1.597370308e-03f, 1.628807667e-03f, 1.660239758e-03f, 1.691666527e-03f, 1.723087920e-03f, 1.754503884e-03f,
1.785914364e-03f, 1.817319308e-03f, 1.848718660e-03f, 1.880112367e-03f, 1.911500376e-03f, 1.942882633e-03f, 1.974259084e-03f, 2.005629676e-03f, 2.036994354e-03f, 2.068353065e-03f,
2.099705756e-03f, 2.131052373e-03f, 2.162392862e-03f, 2.193727169e-03f, 2.225055242e-03f, 2.256377025e-03f, 2.287692467e-03f, 2.319001513e-03f, 2.350304110e-03f, 2.381600204e-03f,
2.412889742e-03f, 2.444172670e-03f, 2.475448935e-03f, 2.506718483e-03f, 2.537981262e-03f, 2.569237216e-03f, 2.600486294e-03f, 2.631728442e-03f, 2.662963606e-03f, 2.694191733e-03f,
2.725412769e-03f, 2.756626662e-03f, 2.787833358e-03f, 2.819032803e-03f, 2.850224945e-03f, 2.881409730e-03f, 2.912587105e-03f, 2.943757017e-03f, 2.974919412e-03f, 3.006074237e-03f,
3.037221440e-03f, 3.068360966e-03f, 3.099492764e-03f, 3.130616779e-03f, 3.161732958e-03f, 3.192841250e-03f, 3.223941599e-03f, 3.255033954e-03f, 3.286118262e-03f, 3.317194469e-03f,
3.348262522e-03f, 3.379322368e-03f, 3.410373955e-03f, 3.441417229e-03f, 3.472452138e-03f, 3.503478629e-03f, 3.534496648e-03f, 3.565506143e-03f, 3.596507061e-03f, 3.627499350e-03f,
3.658482956e-03f, 3.689457826e-03f, 3.720423908e-03f, 3.751381149e-03f, 3.782329497e-03f, 3.813268898e-03f, 3.844199300e-03f, 3.875120651e-03f, 3.906032897e-03f, 3.936935986e-03f,
3.967829865e-03f, 3.998714482e-03f, 4.029589784e-03f, 4.060455719e-03f, 4.091312234e-03f, 4.122159277e-03f, 4.152996794e-03f, 4.183824734e-03f, 4.214643045e-03f, 4.245451672e-03f,
4.276250566e-03f, 4.307039672e-03f, 4.337818939e-03f, 4.368588313e-03f, 4.399347744e-03f, 4.430097178e-03f, 4.460836564e-03f, 4.491565848e-03f, 4.522284979e-03f, 4.552993905e-03f,
4.583692573e-03f, 4.614380931e-03f, 4.645058928e-03f, 4.675726510e-03f, 4.706383625e-03f, 4.737030223e-03f, 4.767666250e-03f, 4.798291654e-03f, 4.828906384e-03f, 4.859510388e-03f,
4.890103613e-03f, 4.920686007e-03f, 4.951257520e-03f, 4.981818098e-03f, 5.012367689e-03f, 5.042906243e-03f, 5.073433707e-03f, 5.103950029e-03f, 5.134455158e-03f, 5.164949042e-03f,
5.195431628e-03f, 5.225902866e-03f, 5.256362703e-03f, 5.286811088e-03f, 5.317247970e-03f, 5.347673296e-03f, 5.378087015e-03f, 5.408489075e-03f, 5.438879426e-03f, 5.469258014e-03f,
5.499624790e-03f, 5.529979700e-03f, 5.560322695e-03f, 5.590653722e-03f, 5.620972730e-03f, 5.651279668e-03f, 5.681574484e-03f, 5.711857127e-03f, 5.742127545e-03f, 5.772385688e-03f,
5.802631504e-03f, 5.832864942e-03f, 5.863085950e-03f, 5.893294478e-03f, 5.923490474e-03f, 5.953673887e-03f, 5.983844666e-03f, 6.014002760e-03f, 6.044148118e-03f, 6.074280689e-03f,
6.104400422e-03f, 6.134507266e-03f, 6.164601169e-03f, 6.194682081e-03f, 6.224749952e-03f, 6.254804730e-03f, 6.284846364e-03f, 6.314874803e-03f, 6.344889998e-03f, 6.374891896e-03f,
6.404880448e-03f, 6.434855602e-03f, 6.464817308e-03f, 6.494765515e-03f, 6.524700172e-03f, 6.554621230e-03f, 6.584528636e-03f, 6.614422342e-03f, 6.644302296e-03f, 6.674168448e-03f,
6.704020747e-03f, 6.733859142e-03f, 6.763683585e-03f, 6.793494023e-03f, 6.823290407e-03f, 6.853072687e-03f, 6.882840811e-03f, 6.912594731e-03f, 6.942334394e-03f, 6.972059753e-03f,
7.001770755e-03f, 7.031467352e-03f, 7.061149492e-03f, 7.090817126e-03f, 7.120470204e-03f, 7.150108675e-03f, 7.179732490e-03f, 7.209341599e-03f, 7.238935952e-03f, 7.268515498e-03f,
7.298080188e-03f, 7.327629972e-03f, 7.357164800e-03f, 7.386684623e-03f, 7.416189390e-03f, 7.445679053e-03f, 7.475153560e-03f, 7.504612863e-03f, 7.534056911e-03f, 7.563485656e-03f,
7.592899047e-03f, 7.622297035e-03f, 7.651679571e-03f, 7.681046605e-03f, 7.710398087e-03f, 7.739733968e-03f, 7.769054199e-03f, 7.798358730e-03f, 7.827647511e-03f, 7.856920495e-03f,
7.886177630e-03f, 7.915418869e-03f, 7.944644161e-03f, 7.973853458e-03f, 8.003046711e-03f, 8.032223869e-03f, 8.061384885e-03f, 8.090529709e-03f, 8.119658292e-03f, 8.148770585e-03f,
8.177866539e-03f, 8.206946105e-03f, 8.236009235e-03f, 8.265055879e-03f, 8.294085988e-03f, 8.323099514e-03f, 8.352096408e-03f, 8.381076620e-03f, 8.410040104e-03f, 8.438986809e-03f,
8.467916687e-03f, 8.496829690e-03f, 8.525725768e-03f, 8.554604874e-03f, 8.583466959e-03f, 8.612311974e-03f, 8.641139871e-03f, 8.669950601e-03f, 8.698744116e-03f, 8.727520368e-03f,
8.756279309e-03f, 8.785020889e-03f, 8.813745062e-03f, 8.842451777e-03f, 8.871140989e-03f, 8.899812647e-03f, 8.928466705e-03f, 8.957103114e-03f, 8.985721826e-03f, 9.014322793e-03f,
9.042905967e-03f, 9.071471299e-03f, 9.100018744e-03f, 9.128548251e-03f, 9.157059774e-03f, 9.185553264e-03f, 9.214028674e-03f, 9.242485957e-03f, 9.270925064e-03f, 9.299345947e-03f,
9.327748560e-03f, 9.356132854e-03f, 9.384498782e-03f, 9.412846296e-03f, 9.441175350e-03f, 9.469485895e-03f, 9.497777884e-03f, 9.526051269e-03f, 9.554306004e-03f, 9.582542041e-03f,
9.610759332e-03f, 9.638957831e-03f, 9.667137490e-03f, 9.695298263e-03f, 9.723440101e-03f, 9.751562958e-03f, 9.779666787e-03f, 9.807751541e-03f, 9.835817172e-03f, 9.863863635e-03f,
9.891890881e-03f, 9.919898864e-03f, 9.947887537e-03f, 9.975856854e-03f, 1.000380677e-02f, 1.003173723e-02f, 1.005964820e-02f, 1.008753962e-02f, 1.011541145e-02f, 1.014326365e-02f,
1.017109616e-02f, 1.019890895e-02f, 1.022670195e-02f, 1.025447514e-02f, 1.028222845e-02f, 1.030996185e-02f, 1.033767529e-02f, 1.036536872e-02f, 1.039304210e-02f, 1.042069537e-02f,
1.044832850e-02f, 1.047594144e-02f, 1.050353414e-02f, 1.053110655e-02f, 1.055865863e-02f, 1.058619034e-02f, 1.061370162e-02f, 1.064119243e-02f, 1.066866273e-02f, 1.069611247e-02f,
1.072354160e-02f, 1.075095008e-02f, 1.077833786e-02f, 1.080570490e-02f, 1.083305116e-02f, 1.086037657e-02f, 1.088768111e-02f, 1.091496472e-02f, 1.094222736e-02f, 1.096946898e-02f,
1.099668954e-02f, 1.102388900e-02f, 1.105106730e-02f, 1.107822441e-02f, 1.110536027e-02f, 1.113247484e-02f, 1.115956808e-02f, 1.118663994e-02f, 1.121369038e-02f, 1.124071935e-02f,
1.126772681e-02f, 1.129471271e-02f, 1.132167700e-02f, 1.134861965e-02f, 1.137554060e-02f, 1.140243982e-02f, 1.142931725e-02f, 1.145617286e-02f, 1.148300659e-02f, 1.150981841e-02f,
1.153660827e-02f, 1.156337612e-02f, 1.159012192e-02f, 1.161684563e-02f, 1.164354720e-02f, 1.167022658e-02f, 1.169688374e-02f, 1.172351863e-02f, 1.175013120e-02f, 1.177672140e-02f,
1.180328921e-02f, 1.182983456e-02f, 1.185635743e-02f, 1.188285775e-02f, 1.190933550e-02f, 1.193579062e-02f, 1.196222307e-02f, 1.198863281e-02f, 1.201501980e-02f, 1.204138398e-02f,
1.206772532e-02f, 1.209404377e-02f, 1.212033929e-02f, 1.214661184e-02f, 1.217286137e-02f, 1.219908784e-02f, 1.222529120e-02f, 1.225147141e-02f, 1.227762843e-02f, 1.230376221e-02f,
1.232987272e-02f, 1.235595991e-02f, 1.238202372e-02f, 1.240806413e-02f, 1.243408109e-02f, 1.246007456e-02f, 1.248604448e-02f, 1.251199083e-02f, 1.253791355e-02f, 1.256381261e-02f,
1.258968796e-02f, 1.261553955e-02f, 1.264136735e-02f, 1.266717131e-02f, 1.269295139e-02f, 1.271870755e-02f, 1.274443974e-02f, 1.277014793e-02f, 1.279583206e-02f, 1.282149210e-02f,
1.284712800e-02f, 1.287273973e-02f, 1.289832724e-02f, 1.292389048e-02f, 1.294942942e-02f, 1.297494401e-02f, 1.300043421e-02f, 1.302589998e-02f, 1.305134128e-02f, 1.307675806e-02f,
1.310215029e-02f, 1.312751791e-02f, 1.315286090e-02f, 1.317817920e-02f, 1.320347278e-02f, 1.322874159e-02f, 1.325398559e-02f, 1.327920474e-02f, 1.330439900e-02f, 1.332956833e-02f,
1.335471268e-02f, 1.337983202e-02f, 1.340492630e-02f, 1.342999548e-02f, 1.345503952e-02f, 1.348005838e-02f, 1.350505201e-02f, 1.353002038e-02f, 1.355496345e-02f, 1.357988117e-02f,
1.360477351e-02f, 1.362964041e-02f, 1.365448185e-02f, 1.367929778e-02f, 1.370408815e-02f, 1.372885294e-02f, 1.375359209e-02f, 1.377830557e-02f, 1.380299334e-02f, 1.382765535e-02f,
1.385229156e-02f, 1.387690194e-02f, 1.390148645e-02f, 1.392604503e-02f, 1.395057767e-02f, 1.397508430e-02f, 1.399956490e-02f, 1.402401942e-02f, 1.404844782e-02f, 1.407285006e-02f,
1.409722610e-02f, 1.412157591e-02f, 1.414589944e-02f, 1.417019665e-02f, 1.419446750e-02f, 1.421871196e-02f, 1.424292998e-02f, 1.426712152e-02f, 1.429128654e-02f, 1.431542500e-02f,
1.433953687e-02f, 1.436362211e-02f, 1.438768067e-02f, 1.441171251e-02f, 1.443571760e-02f, 1.445969589e-02f, 1.448364736e-02f, 1.450757195e-02f, 1.453146962e-02f, 1.455534035e-02f,
1.457918409e-02f, 1.460300080e-02f, 1.462679044e-02f, 1.465055297e-02f, 1.467428836e-02f, 1.469799657e-02f, 1.472167755e-02f, 1.474533127e-02f, 1.476895768e-02f, 1.479255676e-02f,
1.481612846e-02f, 1.483967275e-02f, 1.486318957e-02f, 1.488667891e-02f, 1.491014071e-02f, 1.493357494e-02f, 1.495698156e-02f, 1.498036054e-02f, 1.500371183e-02f, 1.502703539e-02f,
1.505033120e-02f, 1.507359920e-02f, 1.509683937e-02f, 1.512005166e-02f, 1.514323604e-02f, 1.516639247e-02f, 1.518952090e-02f, 1.521262131e-02f, 1.523569366e-02f, 1.525873790e-02f,
1.528175401e-02f, 1.530474193e-02f, 1.532770164e-02f, 1.535063310e-02f, 1.537353627e-02f, 1.539641111e-02f, 1.541925759e-02f, 1.544207566e-02f, 1.546486530e-02f, 1.548762646e-02f,
1.551035910e-02f, 1.553306320e-02f, 1.555573871e-02f, 1.557838560e-02f, 1.560100382e-02f, 1.562359335e-02f, 1.564615414e-02f, 1.566868616e-02f, 1.569118937e-02f, 1.571366374e-02f,
1.573610922e-02f, 1.575852579e-02f, 1.578091341e-02f, 1.580327203e-02f, 1.582560163e-02f, 1.584790216e-02f, 1.587017360e-02f, 1.589241589e-02f, 1.591462902e-02f, 1.593681294e-02f,
1.595896762e-02f, 1.598109301e-02f, 1.600318909e-02f, 1.602525582e-02f, 1.604729316e-02f, 1.606930107e-02f, 1.609127953e-02f, 1.611322850e-02f, 1.613514793e-02f, 1.615703779e-02f,
1.617889806e-02f, 1.620072869e-02f, 1.622252965e-02f, 1.624430089e-02f, 1.626604240e-02f, 1.628775413e-02f, 1.630943604e-02f, 1.633108811e-02f, 1.635271029e-02f, 1.637430256e-02f,
1.639586487e-02f, 1.641739719e-02f, 1.643889949e-02f, 1.646037173e-02f, 1.648181388e-02f, 1.650322590e-02f, 1.652460776e-02f, 1.654595942e-02f, 1.656728086e-02f, 1.658857202e-02f,
1.660983289e-02f, 1.663106342e-02f, 1.665226358e-02f, 1.667343334e-02f, 1.669457267e-02f, 1.671568152e-02f, 1.673675986e-02f, 1.675780767e-02f, 1.677882490e-02f, 1.679981153e-02f,
1.682076752e-02f, 1.684169283e-02f, 1.686258743e-02f, 1.688345129e-02f, 1.690428437e-02f, 1.692508664e-02f, 1.694585807e-02f, 1.696659862e-02f, 1.698730827e-02f, 1.700798697e-02f,
1.702863469e-02f, 1.704925140e-02f, 1.706983707e-02f, 1.709039167e-02f, 1.711091515e-02f, 1.713140749e-02f, 1.715186866e-02f, 1.717229861e-02f, 1.719269733e-02f, 1.721306477e-02f,
1.723340091e-02f, 1.725370571e-02f, 1.727397913e-02f, 1.729422115e-02f, 1.731443173e-02f, 1.733461084e-02f, 1.735475846e-02f, 1.737487453e-02f, 1.739495904e-02f, 1.741501195e-02f,
1.743503323e-02f, 1.745502285e-02f, 1.747498077e-02f, 1.749490696e-02f, 1.751480140e-02f, 1.753466404e-02f, 1.755449486e-02f, 1.757429383e-02f, 1.759406091e-02f, 1.761379607e-02f,
1.763349928e-02f, 1.765317051e-02f, 1.767280973e-02f, 1.769241690e-02f, 1.771199200e-02f, 1.773153499e-02f, 1.775104584e-02f, 1.777052452e-02f, 1.778997100e-02f, 1.780938525e-02f,
1.782876724e-02f, 1.784811694e-02f, 1.786743431e-02f, 1.788671932e-02f, 1.790597195e-02f, 1.792519216e-02f, 1.794437992e-02f, 1.796353521e-02f, 1.798265799e-02f, 1.800174822e-02f,
1.802080589e-02f, 1.803983096e-02f, 1.805882340e-02f, 1.807778317e-02f, 1.809671026e-02f, 1.811560462e-02f, 1.813446624e-02f, 1.815329507e-02f, 1.817209109e-02f, 1.819085427e-02f,
1.820958458e-02f, 1.822828198e-02f, 1.824694646e-02f, 1.826557798e-02f, 1.828417650e-02f, 1.830274201e-02f, 1.832127447e-02f, 1.833977385e-02f, 1.835824012e-02f, 1.837667326e-02f,
1.839507323e-02f, 1.841344000e-02f, 1.843177355e-02f, 1.845007385e-02f, 1.846834086e-02f, 1.848657456e-02f, 1.850477492e-02f, 1.852294191e-02f, 1.854107550e-02f, 1.855917566e-02f,
1.857724237e-02f, 1.859527560e-02f, 1.861327531e-02f, 1.863124148e-02f, 1.864917408e-02f, 1.866707308e-02f, 1.868493846e-02f, 1.870277018e-02f, 1.872056821e-02f, 1.873833254e-02f,
1.875606313e-02f, 1.877375995e-02f, 1.879142297e-02f, 1.880905217e-02f, 1.882664753e-02f, 1.884420900e-02f, 1.886173656e-02f, 1.887923020e-02f, 1.889668987e-02f, 1.891411555e-02f,
1.893150721e-02f, 1.894886483e-02f, 1.896618838e-02f, 1.898347783e-02f, 1.900073316e-02f, 1.901795433e-02f, 1.903514132e-02f, 1.905229410e-02f, 1.906941265e-02f, 1.908649694e-02f,
1.910354694e-02f, 1.912056263e-02f, 1.913754398e-02f, 1.915449095e-02f, 1.917140353e-02f, 1.918828170e-02f, 1.920512541e-02f, 1.922193465e-02f, 1.923870939e-02f, 1.925544960e-02f,
1.927215526e-02f, 1.928882633e-02f, 1.930546281e-02f, 1.932206465e-02f, 1.933863183e-02f, 1.935516434e-02f, 1.937166213e-02f, 1.938812518e-02f, 1.940455348e-02f, 1.942094699e-02f,
1.943730569e-02f, 1.945362954e-02f, 1.946991854e-02f, 1.948617265e-02f, 1.950239184e-02f, 1.951857610e-02f, 1.953472538e-02f, 1.955083968e-02f, 1.956691897e-02f, 1.958296321e-02f,
1.959897239e-02f, 1.961494648e-02f, 1.963088546e-02f, 1.964678929e-02f, 1.966265796e-02f, 1.967849144e-02f, 1.969428971e-02f, 1.971005274e-02f, 1.972578051e-02f, 1.974147299e-02f,
1.975713015e-02f, 1.977275198e-02f, 1.978833846e-02f, 1.980388954e-02f, 1.981940522e-02f, 1.983488547e-02f, 1.985033026e-02f, 1.986573956e-02f, 1.988111337e-02f, 1.989645164e-02f,
1.991175437e-02f, 1.992702152e-02f, 1.994225306e-02f, 1.995744899e-02f, 1.997260927e-02f, 1.998773388e-02f, 2.000282280e-02f, 2.001787600e-02f, 2.003289346e-02f, 2.004787515e-02f,
2.006282107e-02f, 2.007773117e-02f, 2.009260544e-02f, 2.010744385e-02f, 2.012224639e-02f, 2.013701303e-02f, 2.015174374e-02f, 2.016643851e-02f, 2.018109731e-02f, 2.019572011e-02f,
2.021030691e-02f, 2.022485766e-02f, 2.023937236e-02f, 2.025385098e-02f, 2.026829350e-02f, 2.028269989e-02f, 2.029707013e-02f, 2.031140420e-02f, 2.032570208e-02f, 2.033996375e-02f,
2.035418919e-02f, 2.036837836e-02f, 2.038253126e-02f, 2.039664786e-02f, 2.041072814e-02f, 2.042477207e-02f, 2.043877964e-02f, 2.045275082e-02f, 2.046668560e-02f, 2.048058394e-02f,
2.049444584e-02f, 2.050827126e-02f, 2.052206020e-02f, 2.053581262e-02f, 2.054952850e-02f, 2.056320783e-02f, 2.057685059e-02f, 2.059045675e-02f, 2.060402629e-02f, 2.061755919e-02f,
2.063105544e-02f, 2.064451500e-02f, 2.065793787e-02f, 2.067132402e-02f, 2.068467342e-02f, 2.069798607e-02f, 2.071126194e-02f, 2.072450100e-02f, 2.073770325e-02f, 2.075086866e-02f,
2.076399720e-02f, 2.077708887e-02f, 2.079014363e-02f, 2.080316148e-02f, 2.081614238e-02f, 2.082908633e-02f, 2.084199330e-02f, 2.085486327e-02f, 2.086769622e-02f, 2.088049214e-02f,
2.089325100e-02f, 2.090597278e-02f, 2.091865748e-02f, 2.093130506e-02f, 2.094391550e-02f, 2.095648880e-02f, 2.096902492e-02f, 2.098152386e-02f, 2.099398559e-02f, 2.100641009e-02f,
2.101879735e-02f, 2.103114735e-02f, 2.104346006e-02f, 2.105573547e-02f, 2.106797357e-02f, 2.108017432e-02f, 2.109233773e-02f, 2.110446376e-02f, 2.111655239e-02f, 2.112860362e-02f,
2.114061743e-02f, 2.115259378e-02f, 2.116453268e-02f, 2.117643409e-02f, 2.118829801e-02f, 2.120012441e-02f, 2.121191327e-02f, 2.122366459e-02f, 2.123537834e-02f, 2.124705450e-02f,
2.125869306e-02f, 2.127029399e-02f, 2.128185730e-02f, 2.129338294e-02f, 2.130487092e-02f, 2.131632121e-02f, 2.132773379e-02f, 2.133910865e-02f, 2.135044577e-02f, 2.136174513e-02f,
2.137300673e-02f, 2.138423053e-02f, 2.139541653e-02f, 2.140656471e-02f, 2.141767505e-02f, 2.142874754e-02f, 2.143978215e-02f, 2.145077888e-02f, 2.146173771e-02f, 2.147265862e-02f,
2.148354159e-02f, 2.149438661e-02f, 2.150519367e-02f, 2.151596274e-02f, 2.152669382e-02f, 2.153738688e-02f, 2.154804192e-02f, 2.155865891e-02f, 2.156923784e-02f, 2.157977869e-02f,
2.159028146e-02f, 2.160074612e-02f, 2.161117265e-02f, 2.162156106e-02f, 2.163191131e-02f, 2.164222339e-02f, 2.165249730e-02f, 2.166273300e-02f, 2.167293050e-02f, 2.168308978e-02f,
2.169321081e-02f, 2.170329359e-02f, 2.171333810e-02f, 2.172334433e-02f, 2.173331226e-02f, 2.174324187e-02f, 2.175313317e-02f, 2.176298612e-02f, 2.177280072e-02f, 2.178257695e-02f,
2.179231479e-02f, 2.180201424e-02f, 2.181167529e-02f, 2.182129790e-02f, 2.183088209e-02f, 2.184042781e-02f, 2.184993508e-02f, 2.185940387e-02f, 2.186883416e-02f, 2.187822596e-02f,
2.188757923e-02f, 2.189689397e-02f, 2.190617017e-02f, 2.191540781e-02f, 2.192460688e-02f, 2.193376737e-02f, 2.194288926e-02f, 2.195197254e-02f, 2.196101720e-02f, 2.197002323e-02f,
2.197899061e-02f, 2.198791933e-02f, 2.199680938e-02f, 2.200566074e-02f, 2.201447341e-02f, 2.202324736e-02f, 2.203198260e-02f, 2.204067910e-02f, 2.204933686e-02f, 2.205795586e-02f,
2.206653609e-02f, 2.207507755e-02f, 2.208358020e-02f, 2.209204406e-02f, 2.210046909e-02f, 2.210885530e-02f, 2.211720267e-02f, 2.212551119e-02f, 2.213378085e-02f, 2.214201163e-02f,
2.215020353e-02f, 2.215835653e-02f, 2.216647063e-02f, 2.217454581e-02f, 2.218258206e-02f, 2.219057937e-02f, 2.219853772e-02f, 2.220645712e-02f, 2.221433755e-02f, 2.222217899e-02f,
2.222998144e-02f, 2.223774488e-02f, 2.224546931e-02f, 2.225315472e-02f, 2.226080109e-02f, 2.226840841e-02f, 2.227597668e-02f, 2.228350589e-02f, 2.229099602e-02f, 2.229844706e-02f,
2.230585901e-02f, 2.231323185e-02f, 2.232056558e-02f, 2.232786018e-02f, 2.233511565e-02f, 2.234233198e-02f, 2.234950915e-02f, 2.235664716e-02f, 2.236374600e-02f, 2.237080566e-02f,
2.237782612e-02f, 2.238480739e-02f, 2.239174945e-02f, 2.239865229e-02f, 2.240551591e-02f, 2.241234029e-02f, 2.241912542e-02f, 2.242587130e-02f, 2.243257792e-02f, 2.243924527e-02f,
2.244587335e-02f, 2.245246213e-02f, 2.245901162e-02f, 2.246552181e-02f, 2.247199268e-02f, 2.247842423e-02f, 2.248481646e-02f, 2.249116935e-02f, 2.249748289e-02f, 2.250375708e-02f,
2.250999192e-02f, 2.251618738e-02f, 2.252234347e-02f, 2.252846017e-02f, 2.253453749e-02f, 2.254057541e-02f, 2.254657392e-02f, 2.255253301e-02f, 2.255845269e-02f, 2.256433294e-02f,
2.257017376e-02f, 2.257597513e-02f, 2.258173706e-02f, 2.258745953e-02f, 2.259314253e-02f, 2.259878607e-02f, 2.260439013e-02f, 2.260995471e-02f, 2.261547980e-02f, 2.262096539e-02f,
2.262641149e-02f, 2.263181807e-02f, 2.263718514e-02f, 2.264251268e-02f, 2.264780070e-02f, 2.265304918e-02f, 2.265825813e-02f, 2.266342753e-02f, 2.266855738e-02f, 2.267364767e-02f,
2.267869839e-02f, 2.268370955e-02f, 2.268868113e-02f, 2.269361314e-02f, 2.269850556e-02f, 2.270335838e-02f, 2.270817161e-02f, 2.271294524e-02f, 2.271767926e-02f, 2.272237367e-02f,
2.272702846e-02f, 2.273164363e-02f, 2.273621918e-02f, 2.274075509e-02f, 2.274525136e-02f, 2.274970799e-02f, 2.275412498e-02f, 2.275850231e-02f, 2.276283999e-02f, 2.276713801e-02f,
2.277139636e-02f, 2.277561505e-02f, 2.277979406e-02f, 2.278393340e-02f, 2.278803305e-02f, 2.279209302e-02f, 2.279611330e-02f, 2.280009389e-02f, 2.280403478e-02f, 2.280793597e-02f,
2.281179745e-02f, 2.281561923e-02f, 2.281940129e-02f, 2.282314364e-02f, 2.282684627e-02f, 2.283050918e-02f, 2.283413236e-02f, 2.283771581e-02f, 2.284125953e-02f, 2.284476352e-02f,
2.284822777e-02f, 2.285165228e-02f, 2.285503704e-02f, 2.285838206e-02f, 2.286168732e-02f, 2.286495284e-02f, 2.286817860e-02f, 2.287136460e-02f, 2.287451085e-02f, 2.287761733e-02f,
2.288068404e-02f, 2.288371099e-02f, 2.288669817e-02f, 2.288964558e-02f, 2.289255322e-02f, 2.289542108e-02f, 2.289824916e-02f, 2.290103747e-02f, 2.290378599e-02f, 2.290649474e-02f,
2.290916369e-02f, 2.291179286e-02f, 2.291438225e-02f, 2.291693184e-02f, 2.291944165e-02f, 2.292191166e-02f, 2.292434189e-02f, 2.292673231e-02f, 2.292908295e-02f, 2.293139378e-02f,
2.293366482e-02f, 2.293589606e-02f, 2.293808751e-02f, 2.294023915e-02f, 2.294235099e-02f, 2.294442304e-02f, 2.294645528e-02f, 2.294844772e-02f, 2.295040036e-02f, 2.295231319e-02f,
2.295418622e-02f, 2.295601945e-02f, 2.295781288e-02f, 2.295956650e-02f, 2.296128032e-02f, 2.296295433e-02f, 2.296458855e-02f, 2.296618296e-02f, 2.296773756e-02f, 2.296925237e-02f,
2.297072737e-02f, 2.297216257e-02f, 2.297355797e-02f, 2.297491357e-02f, 2.297622937e-02f, 2.297750538e-02f, 2.297874158e-02f, 2.297993799e-02f, 2.298109460e-02f, 2.298221141e-02f,
2.298328843e-02f, 2.298432566e-02f, 2.298532310e-02f, 2.298628074e-02f, 2.298719860e-02f, 2.298807667e-02f, 2.298891495e-02f, 2.298971345e-02f, 2.299047217e-02f, 2.299119110e-02f,
2.299187026e-02f, 2.299250964e-02f, 2.299310924e-02f, 2.299366907e-02f, 2.299418912e-02f, 2.299466941e-02f, 2.299510993e-02f, 2.299551069e-02f, 2.299587168e-02f, 2.299619291e-02f,
2.299647438e-02f, 2.299671610e-02f, 2.299691807e-02f, 2.299708028e-02f, 2.299720275e-02f, 2.299728548e-02f, 2.299732846e-02f, 2.299733170e-02f, 2.299729521e-02f, 2.299721898e-02f,
2.299710303e-02f, 2.299694735e-02f, 2.299675194e-02f, 2.299651682e-02f, 2.299624198e-02f, 2.299592742e-02f, 2.299557316e-02f, 2.299517919e-02f, 2.299474552e-02f, 2.299427215e-02f,
2.299375909e-02f, 2.299320634e-02f, 2.299261390e-02f, 2.299198177e-02f, 2.299130997e-02f, 2.299059850e-02f, 2.298984735e-02f, 2.298905654e-02f, 2.298822607e-02f, 2.298735594e-02f,
2.298644616e-02f, 2.298549673e-02f, 2.298450766e-02f, 2.298347895e-02f, 2.298241060e-02f, 2.298130263e-02f, 2.298015503e-02f, 2.297896782e-02f, 2.297774099e-02f, 2.297647455e-02f,
2.297516850e-02f, 2.297382286e-02f, 2.297243763e-02f, 2.297101281e-02f, 2.296954840e-02f, 2.296804442e-02f, 2.296650087e-02f, 2.296491775e-02f, 2.296329508e-02f, 2.296163285e-02f,
2.295993107e-02f, 2.295818975e-02f, 2.295640889e-02f, 2.295458850e-02f, 2.295272859e-02f, 2.295082916e-02f, 2.294889022e-02f, 2.294691178e-02f, 2.294489383e-02f, 2.294283640e-02f,
2.294073948e-02f, 2.293860307e-02f, 2.293642720e-02f, 2.293421186e-02f, 2.293195706e-02f, 2.292966281e-02f, 2.292732912e-02f, 2.292495599e-02f, 2.292254342e-02f, 2.292009144e-02f,
2.291760003e-02f, 2.291506922e-02f, 2.291249900e-02f, 2.290988939e-02f, 2.290724040e-02f, 2.290455202e-02f, 2.290182427e-02f, 2.289905716e-02f, 2.289625069e-02f, 2.289340487e-02f,
2.289051971e-02f, 2.288759522e-02f, 2.288463141e-02f, 2.288162827e-02f, 2.287858583e-02f, 2.287550409e-02f, 2.287238306e-02f, 2.286922274e-02f, 2.286602315e-02f, 2.286278429e-02f,
2.285950617e-02f, 2.285618881e-02f, 2.285283220e-02f, 2.284943636e-02f, 2.284600130e-02f, 2.284252702e-02f, 2.283901354e-02f, 2.283546086e-02f, 2.283186899e-02f, 2.282823795e-02f,
2.282456773e-02f, 2.282085836e-02f, 2.281710984e-02f, 2.281332218e-02f, 2.280949538e-02f, 2.280562946e-02f, 2.280172443e-02f, 2.279778030e-02f, 2.279379708e-02f, 2.278977477e-02f,
2.278571339e-02f, 2.278161295e-02f, 2.277747345e-02f, 2.277329492e-02f, 2.276907734e-02f, 2.276482075e-02f, 2.276052514e-02f, 2.275619054e-02f, 2.275181694e-02f, 2.274740436e-02f,
2.274295281e-02f, 2.273846230e-02f, 2.273393284e-02f, 2.272936444e-02f, 2.272475712e-02f, 2.272011088e-02f, 2.271542573e-02f, 2.271070169e-02f, 2.270593876e-02f, 2.270113697e-02f,
2.269629631e-02f, 2.269141680e-02f, 2.268649846e-02f, 2.268154128e-02f, 2.267654530e-02f, 2.267151050e-02f, 2.266643692e-02f, 2.266132455e-02f, 2.265617342e-02f, 2.265098353e-02f,
2.264575489e-02f, 2.264048752e-02f, 2.263518143e-02f, 2.262983663e-02f, 2.262445313e-02f, 2.261903095e-02f, 2.261357010e-02f, 2.260807058e-02f, 2.260253242e-02f, 2.259695562e-02f,
2.259134020e-02f, 2.258568617e-02f, 2.257999354e-02f, 2.257426233e-02f, 2.256849255e-02f, 2.256268420e-02f, 2.255683731e-02f, 2.255095189e-02f, 2.254502795e-02f, 2.253906550e-02f,
2.253306456e-02f, 2.252702513e-02f, 2.252094724e-02f, 2.251483090e-02f, 2.250867611e-02f, 2.250248290e-02f, 2.249625128e-02f, 2.248998125e-02f, 2.248367284e-02f, 2.247732606e-02f,
2.247094092e-02f, 2.246451744e-02f, 2.245805562e-02f, 2.245155549e-02f, 2.244501706e-02f, 2.243844034e-02f, 2.243182534e-02f, 2.242517209e-02f, 2.241848059e-02f, 2.241175086e-02f,
2.240498292e-02f, 2.239817677e-02f, 2.239133243e-02f, 2.238444993e-02f, 2.237752927e-02f, 2.237057046e-02f, 2.236357353e-02f, 2.235653848e-02f, 2.234946534e-02f, 2.234235411e-02f,
2.233520481e-02f, 2.232801747e-02f, 2.232079208e-02f, 2.231352868e-02f, 2.230622727e-02f, 2.229888786e-02f, 2.229151049e-02f, 2.228409515e-02f, 2.227664187e-02f, 2.226915066e-02f,
2.226162154e-02f, 2.225405452e-02f, 2.224644962e-02f, 2.223880685e-02f, 2.223112624e-02f, 2.222340779e-02f, 2.221565153e-02f, 2.220785747e-02f, 2.220002562e-02f, 2.219215601e-02f,
2.218424864e-02f, 2.217630354e-02f, 2.216832073e-02f, 2.216030021e-02f, 2.215224200e-02f, 2.214414613e-02f, 2.213601261e-02f, 2.212784145e-02f, 2.211963268e-02f, 2.211138630e-02f,
2.210310234e-02f, 2.209478082e-02f, 2.208642174e-02f, 2.207802514e-02f, 2.206959102e-02f, 2.206111940e-02f, 2.205261031e-02f, 2.204406375e-02f, 2.203547975e-02f, 2.202685832e-02f,
2.201819948e-02f, 2.200950325e-02f, 2.200076964e-02f, 2.199199868e-02f, 2.198319039e-02f, 2.197434477e-02f, 2.196546185e-02f, 2.195654165e-02f, 2.194758418e-02f, 2.193858947e-02f,
2.192955752e-02f, 2.192048837e-02f, 2.191138202e-02f, 2.190223851e-02f, 2.189305783e-02f, 2.188384002e-02f, 2.187458510e-02f, 2.186529307e-02f, 2.185596397e-02f, 2.184659780e-02f,
2.183719459e-02f, 2.182775436e-02f, 2.181827713e-02f, 2.180876291e-02f, 2.179921172e-02f, 2.178962359e-02f, 2.177999853e-02f, 2.177033657e-02f, 2.176063771e-02f, 2.175090199e-02f,
2.174112942e-02f, 2.173132002e-02f, 2.172147381e-02f, 2.171159081e-02f, 2.170167104e-02f, 2.169171452e-02f, 2.168172127e-02f, 2.167169131e-02f, 2.166162466e-02f, 2.165152134e-02f,
2.164138137e-02f, 2.163120477e-02f, 2.162099156e-02f, 2.161074176e-02f, 2.160045540e-02f, 2.159013248e-02f, 2.157977304e-02f, 2.156937709e-02f, 2.155894466e-02f, 2.154847576e-02f,
2.153797042e-02f, 2.152742865e-02f, 2.151685048e-02f, 2.150623593e-02f, 2.149558502e-02f, 2.148489777e-02f, 2.147417420e-02f, 2.146341433e-02f, 2.145261819e-02f, 2.144178579e-02f,
2.143091716e-02f, 2.142001232e-02f, 2.140907129e-02f, 2.139809409e-02f, 2.138708075e-02f, 2.137603128e-02f, 2.136494570e-02f, 2.135382405e-02f, 2.134266634e-02f, 2.133147258e-02f,
2.132024282e-02f, 2.130897706e-02f, 2.129767533e-02f, 2.128633765e-02f, 2.127496404e-02f, 2.126355453e-02f, 2.125210914e-02f, 2.124062788e-02f, 2.122911080e-02f, 2.121755789e-02f,
2.120596920e-02f, 2.119434473e-02f, 2.118268452e-02f, 2.117098859e-02f, 2.115925695e-02f, 2.114748964e-02f, 2.113568668e-02f, 2.112384808e-02f, 2.111197387e-02f, 2.110006408e-02f,
2.108811872e-02f, 2.107613783e-02f, 2.106412142e-02f, 2.105206952e-02f, 2.103998215e-02f, 2.102785934e-02f, 2.101570110e-02f, 2.100350747e-02f, 2.099127846e-02f, 2.097901410e-02f,
2.096671442e-02f, 2.095437943e-02f, 2.094200917e-02f, 2.092960365e-02f, 2.091716289e-02f, 2.090468694e-02f, 2.089217580e-02f, 2.087962950e-02f, 2.086704807e-02f, 2.085443152e-02f,
2.084177990e-02f, 2.082909321e-02f, 2.081637149e-02f, 2.080361475e-02f, 2.079082303e-02f, 2.077799635e-02f, 2.076513473e-02f, 2.075223819e-02f, 2.073930677e-02f, 2.072634049e-02f,
2.071333937e-02f, 2.070030343e-02f, 2.068723271e-02f, 2.067412723e-02f, 2.066098701e-02f, 2.064781208e-02f, 2.063460246e-02f, 2.062135818e-02f, 2.060807926e-02f, 2.059476573e-02f,
2.058141762e-02f, 2.056803495e-02f, 2.055461775e-02f, 2.054116604e-02f, 2.052767985e-02f, 2.051415920e-02f, 2.050060413e-02f, 2.048701464e-02f, 2.047339079e-02f, 2.045973258e-02f,
2.044604004e-02f, 2.043231320e-02f, 2.041855209e-02f, 2.040475674e-02f, 2.039092716e-02f, 2.037706339e-02f, 2.036316546e-02f, 2.034923338e-02f, 2.033526719e-02f, 2.032126690e-02f,
2.030723256e-02f, 2.029316419e-02f, 2.027906181e-02f, 2.026492544e-02f, 2.025075513e-02f, 2.023655088e-02f, 2.022231274e-02f, 2.020804073e-02f, 2.019373487e-02f, 2.017939519e-02f,
2.016502172e-02f, 2.015061449e-02f, 2.013617352e-02f, 2.012169885e-02f, 2.010719049e-02f, 2.009264848e-02f, 2.007807285e-02f, 2.006346361e-02f, 2.004882081e-02f, 2.003414446e-02f,
2.001943460e-02f, 2.000469125e-02f, 1.998991445e-02f, 1.997510421e-02f, 1.996026057e-02f, 1.994538356e-02f, 1.993047320e-02f, 1.991552952e-02f, 1.990055255e-02f, 1.988554232e-02f,
1.987049885e-02f, 1.985542219e-02f, 1.984031234e-02f, 1.982516935e-02f, 1.980999324e-02f, 1.979478404e-02f, 1.977954178e-02f, 1.976426648e-02f, 1.974895818e-02f, 1.973361691e-02f,
1.971824269e-02f, 1.970283555e-02f, 1.968739553e-02f, 1.967192264e-02f, 1.965641693e-02f, 1.964087841e-02f, 1.962530713e-02f, 1.960970310e-02f, 1.959406636e-02f, 1.957839694e-02f,
1.956269486e-02f, 1.954696016e-02f, 1.953119287e-02f, 1.951539301e-02f, 1.949956061e-02f, 1.948369571e-02f, 1.946779834e-02f, 1.945186852e-02f, 1.943590628e-02f, 1.941991166e-02f,
1.940388468e-02f, 1.938782538e-02f, 1.937173378e-02f, 1.935560991e-02f, 1.933945381e-02f, 1.932326551e-02f, 1.930704503e-02f, 1.929079241e-02f, 1.927450767e-02f, 1.925819085e-02f,
1.924184198e-02f, 1.922546109e-02f, 1.920904821e-02f, 1.919260336e-02f, 1.917612659e-02f, 1.915961792e-02f, 1.914307738e-02f, 1.912650500e-02f, 1.910990082e-02f, 1.909326486e-02f,
1.907659716e-02f, 1.905989774e-02f, 1.904316665e-02f, 1.902640390e-02f, 1.900960953e-02f, 1.899278358e-02f, 1.897592607e-02f, 1.895903704e-02f, 1.894211651e-02f, 1.892516452e-02f,
1.890818110e-02f, 1.889116629e-02f, 1.887412010e-02f, 1.885704259e-02f, 1.883993376e-02f, 1.882279367e-02f, 1.880562234e-02f, 1.878841980e-02f, 1.877118609e-02f, 1.875392123e-02f,
1.873662526e-02f, 1.871929821e-02f, 1.870194012e-02f, 1.868455101e-02f, 1.866713092e-02f, 1.864967988e-02f, 1.863219792e-02f, 1.861468508e-02f, 1.859714139e-02f, 1.857956687e-02f,
1.856196157e-02f, 1.854432552e-02f, 1.852665874e-02f, 1.850896128e-02f, 1.849123316e-02f, 1.847347441e-02f, 1.845568508e-02f, 1.843786519e-02f, 1.842001478e-02f, 1.840213387e-02f,
1.838422251e-02f, 1.836628072e-02f, 1.834830854e-02f, 1.833030600e-02f, 1.831227314e-02f, 1.829420999e-02f, 1.827611658e-02f, 1.825799294e-02f, 1.823983912e-02f, 1.822165513e-02f,
1.820344103e-02f, 1.818519683e-02f, 1.816692258e-02f, 1.814861830e-02f, 1.813028404e-02f, 1.811191982e-02f, 1.809352568e-02f, 1.807510165e-02f, 1.805664778e-02f, 1.803816408e-02f,
1.801965060e-02f, 1.800110737e-02f, 1.798253442e-02f, 1.796393179e-02f, 1.794529951e-02f, 1.792663762e-02f, 1.790794615e-02f, 1.788922514e-02f, 1.787047462e-02f, 1.785169462e-02f,
1.783288518e-02f, 1.781404634e-02f, 1.779517812e-02f, 1.777628057e-02f, 1.775735372e-02f, 1.773839760e-02f, 1.771941225e-02f, 1.770039770e-02f, 1.768135399e-02f, 1.766228116e-02f,
1.764317923e-02f, 1.762404824e-02f, 1.760488824e-02f, 1.758569925e-02f, 1.756648130e-02f, 1.754723444e-02f, 1.752795871e-02f, 1.750865412e-02f, 1.748932073e-02f, 1.746995857e-02f,
1.745056766e-02f, 1.743114806e-02f, 1.741169978e-02f, 1.739222288e-02f, 1.737271738e-02f, 1.735318332e-02f, 1.733362074e-02f, 1.731402967e-02f, 1.729441015e-02f, 1.727476221e-02f,
1.725508589e-02f, 1.723538123e-02f, 1.721564826e-02f, 1.719588702e-02f, 1.717609754e-02f, 1.715627987e-02f, 1.713643403e-02f, 1.711656007e-02f, 1.709665802e-02f, 1.707672791e-02f,
1.705676979e-02f, 1.703678368e-02f, 1.701676963e-02f, 1.699672768e-02f, 1.697665785e-02f, 1.695656019e-02f, 1.693643474e-02f, 1.691628152e-02f, 1.689610058e-02f, 1.687589195e-02f,
1.685565568e-02f, 1.683539179e-02f, 1.681510033e-02f, 1.679478132e-02f, 1.677443482e-02f, 1.675406085e-02f, 1.673365946e-02f, 1.671323067e-02f, 1.669277454e-02f, 1.667229109e-02f,
1.665178036e-02f, 1.663124239e-02f, 1.661067722e-02f, 1.659008488e-02f, 1.656946542e-02f, 1.654881886e-02f, 1.652814526e-02f, 1.650744464e-02f, 1.648671704e-02f, 1.646596250e-02f,
1.644518106e-02f, 1.642437276e-02f, 1.640353763e-02f, 1.638267572e-02f, 1.636178706e-02f, 1.634087168e-02f, 1.631992963e-02f, 1.629896095e-02f, 1.627796567e-02f, 1.625694383e-02f,
1.623589547e-02f, 1.621482063e-02f, 1.619371934e-02f, 1.617259165e-02f, 1.615143759e-02f, 1.613025721e-02f, 1.610905053e-02f, 1.608781760e-02f, 1.606655846e-02f, 1.604527315e-02f,
1.602396170e-02f, 1.600262415e-02f, 1.598126054e-02f, 1.595987092e-02f, 1.593845531e-02f, 1.591701377e-02f, 1.589554632e-02f, 1.587405301e-02f, 1.585253387e-02f, 1.583098895e-02f,
1.580941828e-02f, 1.578782190e-02f, 1.576619986e-02f, 1.574455219e-02f, 1.572287893e-02f, 1.570118012e-02f, 1.567945579e-02f, 1.565770600e-02f, 1.563593077e-02f, 1.561413016e-02f,
1.559230418e-02f, 1.557045290e-02f, 1.554857634e-02f, 1.552667455e-02f, 1.550474756e-02f, 1.548279542e-02f, 1.546081817e-02f, 1.543881583e-02f, 1.541678847e-02f, 1.539473611e-02f,
1.537265879e-02f, 1.535055656e-02f, 1.532842945e-02f, 1.530627750e-02f, 1.528410076e-02f, 1.526189927e-02f, 1.523967306e-02f, 1.521742218e-02f, 1.519514666e-02f, 1.517284654e-02f,
1.515052188e-02f, 1.512817269e-02f, 1.510579904e-02f, 1.508340095e-02f, 1.506097847e-02f, 1.503853164e-02f, 1.501606050e-02f, 1.499356509e-02f, 1.497104544e-02f, 1.494850161e-02f,
1.492593363e-02f, 1.490334154e-02f, 1.488072538e-02f, 1.485808520e-02f, 1.483542103e-02f, 1.481273292e-02f, 1.479002090e-02f, 1.476728502e-02f, 1.474452532e-02f, 1.472174184e-02f,
1.469893462e-02f, 1.467610370e-02f, 1.465324913e-02f, 1.463037094e-02f, 1.460746917e-02f, 1.458454387e-02f, 1.456159508e-02f, 1.453862284e-02f, 1.451562719e-02f, 1.449260817e-02f,
1.446956582e-02f, 1.444650019e-02f, 1.442341132e-02f, 1.440029924e-02f, 1.437716401e-02f, 1.435400565e-02f, 1.433082422e-02f, 1.430761975e-02f, 1.428439229e-02f, 1.426114188e-02f,
1.423786856e-02f, 1.421457237e-02f, 1.419125336e-02f, 1.416791156e-02f, 1.414454702e-02f, 1.412115978e-02f, 1.409774988e-02f, 1.407431737e-02f, 1.405086228e-02f, 1.402738467e-02f,
1.400388456e-02f, 1.398036200e-02f, 1.395681704e-02f, 1.393324972e-02f, 1.390966008e-02f, 1.388604816e-02f, 1.386241400e-02f, 1.383875766e-02f, 1.381507916e-02f, 1.379137855e-02f,
1.376765588e-02f, 1.374391119e-02f, 1.372014451e-02f, 1.369635590e-02f, 1.367254539e-02f, 1.364871303e-02f, 1.362485886e-02f, 1.360098293e-02f, 1.357708527e-02f, 1.355316593e-02f,
1.352922496e-02f, 1.350526238e-02f, 1.348127826e-02f, 1.345727263e-02f, 1.343324553e-02f, 1.340919701e-02f, 1.338512711e-02f, 1.336103587e-02f, 1.333692334e-02f, 1.331278955e-02f,
1.328863457e-02f, 1.326445841e-02f, 1.324026114e-02f, 1.321604279e-02f, 1.319180340e-02f, 1.316754303e-02f, 1.314326171e-02f, 1.311895948e-02f, 1.309463640e-02f, 1.307029250e-02f,
1.304592782e-02f, 1.302154242e-02f, 1.299713633e-02f, 1.297270960e-02f, 1.294826227e-02f, 1.292379439e-02f, 1.289930599e-02f, 1.287479713e-02f, 1.285026784e-02f, 1.282571818e-02f,
1.280114818e-02f, 1.277655789e-02f, 1.275194735e-02f, 1.272731661e-02f, 1.270266571e-02f, 1.267799469e-02f, 1.265330360e-02f, 1.262859248e-02f, 1.260386138e-02f, 1.257911035e-02f,
1.255433941e-02f, 1.252954863e-02f, 1.250473804e-02f, 1.247990769e-02f, 1.245505762e-02f, 1.243018787e-02f, 1.240529850e-02f, 1.238038954e-02f, 1.235546105e-02f, 1.233051305e-02f,
1.230554561e-02f, 1.228055876e-02f, 1.225555255e-02f, 1.223052702e-02f, 1.220548222e-02f, 1.218041819e-02f, 1.215533497e-02f, 1.213023262e-02f, 1.210511117e-02f, 1.207997068e-02f,
1.205481118e-02f, 1.202963272e-02f, 1.200443534e-02f, 1.197921910e-02f, 1.195398403e-02f, 1.192873018e-02f, 1.190345760e-02f, 1.187816632e-02f, 1.185285641e-02f, 1.182752789e-02f,
1.180218081e-02f, 1.177681523e-02f, 1.175143119e-02f, 1.172602872e-02f, 1.170060788e-02f, 1.167516871e-02f, 1.164971126e-02f, 1.162423557e-02f, 1.159874168e-02f, 1.157322965e-02f,
1.154769952e-02f, 1.152215133e-02f, 1.149658513e-02f, 1.147100096e-02f, 1.144539888e-02f, 1.141977891e-02f, 1.139414112e-02f, 1.136848555e-02f, 1.134281223e-02f, 1.131712123e-02f,
1.129141258e-02f, 1.126568632e-02f, 1.123994251e-02f, 1.121418120e-02f, 1.118840241e-02f, 1.116260621e-02f, 1.113679264e-02f, 1.111096174e-02f, 1.108511356e-02f, 1.105924815e-02f,
1.103336554e-02f, 1.100746580e-02f, 1.098154895e-02f, 1.095561506e-02f, 1.092966416e-02f, 1.090369630e-02f, 1.087771153e-02f, 1.085170990e-02f, 1.082569144e-02f, 1.079965621e-02f,
1.077360425e-02f, 1.074753561e-02f, 1.072145033e-02f, 1.069534846e-02f, 1.066923005e-02f, 1.064309515e-02f, 1.061694379e-02f, 1.059077603e-02f, 1.056459191e-02f, 1.053839148e-02f,
1.051217479e-02f, 1.048594187e-02f, 1.045969279e-02f, 1.043342758e-02f, 1.040714629e-02f, 1.038084897e-02f, 1.035453566e-02f, 1.032820641e-02f, 1.030186127e-02f, 1.027550028e-02f,
1.024912350e-02f, 1.022273096e-02f, 1.019632272e-02f, 1.016989882e-02f, 1.014345930e-02f, 1.011700422e-02f, 1.009053362e-02f, 1.006404755e-02f, 1.003754606e-02f, 1.001102918e-02f,
9.984496979e-03f, 9.957949490e-03f, 9.931386763e-03f, 9.904808846e-03f, 9.878215786e-03f, 9.851607629e-03f, 9.824984424e-03f, 9.798346216e-03f, 9.771693053e-03f, 9.745024982e-03f,
9.718342050e-03f, 9.691644304e-03f, 9.664931792e-03f, 9.638204560e-03f, 9.611462657e-03f, 9.584706128e-03f, 9.557935022e-03f, 9.531149386e-03f, 9.504349266e-03f, 9.477534711e-03f,
9.450705768e-03f, 9.423862484e-03f, 9.397004906e-03f, 9.370133082e-03f, 9.343247059e-03f, 9.316346885e-03f, 9.289432608e-03f, 9.262504274e-03f, 9.235561931e-03f, 9.208605627e-03f,
9.181635410e-03f, 9.154651327e-03f, 9.127653425e-03f, 9.100641752e-03f, 9.073616356e-03f, 9.046577284e-03f, 9.019524585e-03f, 8.992458306e-03f, 8.965378494e-03f, 8.938285197e-03f,
8.911178464e-03f, 8.884058341e-03f, 8.856924877e-03f, 8.829778120e-03f, 8.802618117e-03f, 8.775444916e-03f, 8.748258565e-03f, 8.721059112e-03f, 8.693846605e-03f, 8.666621092e-03f,
8.639382621e-03f, 8.612131240e-03f, 8.584866996e-03f, 8.557589938e-03f, 8.530300113e-03f, 8.502997571e-03f, 8.475682359e-03f, 8.448354524e-03f, 8.421014116e-03f, 8.393661181e-03f,
8.366295770e-03f, 8.338917928e-03f, 8.311527706e-03f, 8.284125150e-03f, 8.256710309e-03f, 8.229283232e-03f, 8.201843966e-03f, 8.174392560e-03f, 8.146929062e-03f, 8.119453521e-03f,
8.091965984e-03f, 8.064466500e-03f, 8.036955118e-03f, 8.009431886e-03f, 7.981896851e-03f, 7.954350063e-03f, 7.926791570e-03f, 7.899221421e-03f, 7.871639663e-03f, 7.844046346e-03f,
7.816441518e-03f, 7.788825226e-03f, 7.761197521e-03f, 7.733558450e-03f, 7.705908062e-03f, 7.678246405e-03f, 7.650573528e-03f, 7.622889480e-03f, 7.595194309e-03f, 7.567488064e-03f,
7.539770794e-03f, 7.512042546e-03f, 7.484303371e-03f, 7.456553316e-03f, 7.428792430e-03f, 7.401020762e-03f, 7.373238361e-03f, 7.345445275e-03f, 7.317641553e-03f, 7.289827245e-03f,
7.262002398e-03f, 7.234167061e-03f, 7.206321284e-03f, 7.178465116e-03f, 7.150598604e-03f, 7.122721798e-03f, 7.094834747e-03f, 7.066937500e-03f, 7.039030105e-03f, 7.011112611e-03f,
6.983185069e-03f, 6.955247525e-03f, 6.927300030e-03f, 6.899342632e-03f, 6.871375381e-03f, 6.843398325e-03f, 6.815411513e-03f, 6.787414994e-03f, 6.759408818e-03f, 6.731393034e-03f,
6.703367690e-03f, 6.675332835e-03f, 6.647288519e-03f, 6.619234791e-03f, 6.591171700e-03f, 6.563099295e-03f, 6.535017625e-03f, 6.506926739e-03f, 6.478826687e-03f, 6.450717518e-03f,
6.422599280e-03f, 6.394472024e-03f, 6.366335797e-03f, 6.338190651e-03f, 6.310036633e-03f, 6.281873793e-03f, 6.253702180e-03f, 6.225521844e-03f, 6.197332834e-03f, 6.169135199e-03f,
6.140928988e-03f, 6.112714251e-03f, 6.084491037e-03f, 6.056259396e-03f, 6.028019376e-03f, 5.999771027e-03f, 5.971514399e-03f, 5.943249541e-03f, 5.914976502e-03f, 5.886695332e-03f,
5.858406080e-03f, 5.830108795e-03f, 5.801803527e-03f, 5.773490326e-03f, 5.745169241e-03f, 5.716840321e-03f, 5.688503615e-03f, 5.660159175e-03f, 5.631807047e-03f, 5.603447283e-03f,
5.575079932e-03f, 5.546705044e-03f, 5.518322667e-03f, 5.489932851e-03f, 5.461535647e-03f, 5.433131103e-03f, 5.404719269e-03f, 5.376300194e-03f, 5.347873929e-03f, 5.319440523e-03f,
5.291000025e-03f, 5.262552486e-03f, 5.234097954e-03f, 5.205636479e-03f, 5.177168111e-03f, 5.148692900e-03f, 5.120210895e-03f, 5.091722146e-03f, 5.063226703e-03f, 5.034724615e-03f,
5.006215931e-03f, 4.977700703e-03f, 4.949178979e-03f, 4.920650809e-03f, 4.892116242e-03f, 4.863575329e-03f, 4.835028120e-03f, 4.806474663e-03f, 4.777915009e-03f, 4.749349207e-03f,
4.720777308e-03f, 4.692199361e-03f, 4.663615415e-03f, 4.635025521e-03f, 4.606429728e-03f, 4.577828087e-03f, 4.549220646e-03f, 4.520607456e-03f, 4.491988567e-03f, 4.463364028e-03f,
4.434733889e-03f, 4.406098200e-03f, 4.377457011e-03f, 4.348810371e-03f, 4.320158331e-03f, 4.291500941e-03f, 4.262838250e-03f, 4.234170308e-03f, 4.205497165e-03f, 4.176818870e-03f,
4.148135475e-03f, 4.119447028e-03f, 4.090753579e-03f, 4.062055179e-03f, 4.033351878e-03f, 4.004643724e-03f, 3.975930769e-03f, 3.947213061e-03f, 3.918490652e-03f, 3.889763590e-03f,
3.861031927e-03f, 3.832295711e-03f, 3.803554992e-03f, 3.774809822e-03f, 3.746060248e-03f, 3.717306323e-03f, 3.688548094e-03f, 3.659785614e-03f, 3.631018930e-03f, 3.602248094e-03f,
3.573473155e-03f, 3.544694163e-03f, 3.515911169e-03f, 3.487124222e-03f, 3.458333372e-03f, 3.429538669e-03f, 3.400740163e-03f, 3.371937905e-03f, 3.343131943e-03f, 3.314322329e-03f,
3.285509112e-03f, 3.256692342e-03f, 3.227872069e-03f, 3.199048343e-03f, 3.170221215e-03f, 3.141390733e-03f, 3.112556949e-03f, 3.083719911e-03f, 3.054879671e-03f, 3.026036279e-03f,
2.997189783e-03f, 2.968340235e-03f, 2.939487683e-03f, 2.910632180e-03f, 2.881773773e-03f, 2.852912514e-03f, 2.824048452e-03f, 2.795181637e-03f, 2.766312120e-03f, 2.737439950e-03f,
2.708565178e-03f, 2.679687853e-03f, 2.650808026e-03f, 2.621925746e-03f, 2.593041064e-03f, 2.564154029e-03f, 2.535264693e-03f, 2.506373103e-03f, 2.477479312e-03f, 2.448583368e-03f,
2.419685322e-03f, 2.390785224e-03f, 2.361883124e-03f, 2.332979072e-03f, 2.304073117e-03f, 2.275165311e-03f, 2.246255703e-03f, 2.217344342e-03f, 2.188431280e-03f, 2.159516565e-03f,
2.130600249e-03f, 2.101682381e-03f, 2.072763011e-03f, 2.043842190e-03f, 2.014919966e-03f, 1.985996391e-03f, 1.957071514e-03f, 1.928145386e-03f, 1.899218056e-03f, 1.870289574e-03f,
1.841359990e-03f, 1.812429355e-03f, 1.783497718e-03f, 1.754565130e-03f, 1.725631640e-03f, 1.696697298e-03f, 1.667762155e-03f, 1.638826260e-03f, 1.609889663e-03f, 1.580952416e-03f,
1.552014566e-03f, 1.523076165e-03f, 1.494137262e-03f, 1.465197908e-03f, 1.436258152e-03f, 1.407318044e-03f, 1.378377635e-03f, 1.349436973e-03f, 1.320496111e-03f, 1.291555096e-03f,
1.262613980e-03f, 1.233672812e-03f, 1.204731642e-03f, 1.175790520e-03f, 1.146849496e-03f, 1.117908620e-03f, 1.088967941e-03f, 1.060027511e-03f, 1.031087379e-03f, 1.002147594e-03f,
9.732082070e-04f, 9.442692675e-04f, 9.153308254e-04f, 8.863929308e-04f, 8.574556335e-04f, 8.285189834e-04f, 7.995830304e-04f, 7.706478244e-04f, 7.417134152e-04f, 7.127798529e-04f,
6.838471872e-04f, 6.549154681e-04f, 6.259847453e-04f, 5.970550688e-04f, 5.681264884e-04f, 5.391990540e-04f, 5.102728153e-04f, 4.813478224e-04f, 4.524241249e-04f, 4.235017727e-04f,
3.945808157e-04f, 3.656613037e-04f, 3.367432864e-04f, 3.078268136e-04f, 2.789119353e-04f, 2.499987011e-04f, 2.210871608e-04f, 1.921773643e-04f, 1.632693613e-04f, 1.343632015e-04f,
1.054589348e-04f, 7.655661079e-05f, 4.765627933e-05f, 1.875799012e-05f, -1.013820710e-05f, -3.903226262e-05f, -6.792412672e-05f, -9.681374969e-05f, -1.257010818e-04f, -1.545860734e-04f,
-1.834686749e-04f, -2.123488364e-04f, -2.412265084e-04f, -2.701016411e-04f, -2.989741850e-04f, -3.278440904e-04f, -3.567113076e-04f, -3.855757870e-04f, -4.144374790e-04f, -4.432963340e-04f,
-4.721523024e-04f, -5.010053346e-04f, -5.298553810e-04f, -5.587023920e-04f, -5.875463180e-04f, -6.163871096e-04f, -6.452247171e-04f, -6.740590909e-04f, -7.028901817e-04f, -7.317179398e-04f,
-7.605423157e-04f, -7.893632600e-04f, -8.181807231e-04f, -8.469946555e-04f, -8.758050078e-04f, -9.046117305e-04f, -9.334147742e-04f, -9.622140894e-04f, -9.910096266e-04f, -1.019801336e-03f,
-1.048589170e-03f, -1.077373077e-03f, -1.106153008e-03f, -1.134928914e-03f, -1.163700746e-03f, -1.192468455e-03f, -1.221231990e-03f, -1.249991303e-03f, -1.278746344e-03f, -1.307497065e-03f,
-1.336243414e-03f, -1.364985345e-03f, -1.393722806e-03f, -1.422455749e-03f, -1.451184125e-03f, -1.479907884e-03f, -1.508626976e-03f, -1.537341354e-03f, -1.566050968e-03f, -1.594755767e-03f,
-1.623455704e-03f, -1.652150729e-03f, -1.680840793e-03f, -1.709525847e-03f, -1.738205841e-03f, -1.766880726e-03f, -1.795550454e-03f, -1.824214975e-03f, -1.852874240e-03f, -1.881528200e-03f,
-1.910176806e-03f, -1.938820009e-03f, -1.967457760e-03f, -1.996090009e-03f, -2.024716709e-03f, -2.053337809e-03f, -2.081953261e-03f, -2.110563015e-03f, -2.139167024e-03f, -2.167765238e-03f,
-2.196357607e-03f, -2.224944084e-03f, -2.253524618e-03f, -2.282099162e-03f, -2.310667666e-03f, -2.339230082e-03f, -2.367786360e-03f, -2.396336453e-03f, -2.424880310e-03f, -2.453417883e-03f,
-2.481949124e-03f, -2.510473983e-03f, -2.538992412e-03f, -2.567504362e-03f, -2.596009784e-03f, -2.624508630e-03f, -2.653000851e-03f, -2.681486398e-03f, -2.709965223e-03f, -2.738437276e-03f,
-2.766902510e-03f, -2.795360875e-03f, -2.823812323e-03f, -2.852256806e-03f, -2.880694274e-03f, -2.909124680e-03f, -2.937547974e-03f, -2.965964108e-03f, -2.994373034e-03f, -3.022774702e-03f,
-3.051169066e-03f, -3.079556075e-03f, -3.107935682e-03f, -3.136307839e-03f, -3.164672496e-03f, -3.193029605e-03f, -3.221379119e-03f, -3.249720988e-03f, -3.278055164e-03f, -3.306381599e-03f,
-3.334700245e-03f, -3.363011053e-03f, -3.391313975e-03f, -3.419608962e-03f, -3.447895967e-03f, -3.476174942e-03f, -3.504445837e-03f, -3.532708605e-03f, -3.560963197e-03f, -3.589209566e-03f,
-3.617447663e-03f, -3.645677441e-03f, -3.673898850e-03f, -3.702111843e-03f, -3.730316372e-03f, -3.758512389e-03f, -3.786699845e-03f, -3.814878694e-03f, -3.843048885e-03f, -3.871210373e-03f,
-3.899363108e-03f, -3.927507043e-03f, -3.955642130e-03f, -3.983768321e-03f, -4.011885567e-03f, -4.039993822e-03f, -4.068093037e-03f, -4.096183165e-03f, -4.124264157e-03f, -4.152335966e-03f,
-4.180398544e-03f, -4.208451843e-03f, -4.236495816e-03f, -4.264530415e-03f, -4.292555592e-03f, -4.320571299e-03f, -4.348577489e-03f, -4.376574114e-03f, -4.404561126e-03f, -4.432538479e-03f,
-4.460506124e-03f, -4.488464013e-03f, -4.516412100e-03f, -4.544350336e-03f, -4.572278675e-03f, -4.600197068e-03f, -4.628105468e-03f, -4.656003829e-03f, -4.683892101e-03f, -4.711770239e-03f,
-4.739638194e-03f, -4.767495919e-03f, -4.795343368e-03f, -4.823180491e-03f, -4.851007244e-03f, -4.878823577e-03f, -4.906629444e-03f, -4.934424797e-03f, -4.962209590e-03f, -4.989983775e-03f,
-5.017747305e-03f, -5.045500133e-03f, -5.073242211e-03f, -5.100973493e-03f, -5.128693932e-03f, -5.156403480e-03f, -5.184102091e-03f, -5.211789717e-03f, -5.239466311e-03f, -5.267131827e-03f,
-5.294786218e-03f, -5.322429436e-03f, -5.350061435e-03f, -5.377682168e-03f, -5.405291588e-03f, -5.432889648e-03f, -5.460476301e-03f, -5.488051501e-03f, -5.515615201e-03f, -5.543167354e-03f,
-5.570707913e-03f, -5.598236832e-03f, -5.625754064e-03f, -5.653259563e-03f, -5.680753281e-03f, -5.708235172e-03f, -5.735705190e-03f, -5.763163288e-03f, -5.790609420e-03f, -5.818043538e-03f,
-5.845465597e-03f, -5.872875551e-03f, -5.900273352e-03f, -5.927658954e-03f, -5.955032311e-03f, -5.982393377e-03f, -6.009742105e-03f, -6.037078448e-03f, -6.064402362e-03f, -6.091713799e-03f,
-6.119012713e-03f, -6.146299058e-03f, -6.173572787e-03f, -6.200833856e-03f, -6.228082217e-03f, -6.255317824e-03f, -6.282540631e-03f, -6.309750593e-03f, -6.336947663e-03f, -6.364131795e-03f,
-6.391302944e-03f, -6.418461063e-03f, -6.445606106e-03f, -6.472738027e-03f, -6.499856782e-03f, -6.526962322e-03f, -6.554054604e-03f, -6.581133581e-03f, -6.608199208e-03f, -6.635251438e-03f,
-6.662290226e-03f, -6.689315526e-03f, -6.716327293e-03f, -6.743325480e-03f, -6.770310043e-03f, -6.797280936e-03f, -6.824238113e-03f, -6.851181528e-03f, -6.878111137e-03f, -6.905026893e-03f,
-6.931928752e-03f, -6.958816667e-03f, -6.985690594e-03f, -7.012550487e-03f, -7.039396300e-03f, -7.066227989e-03f, -7.093045508e-03f, -7.119848812e-03f, -7.146637856e-03f, -7.173412594e-03f,
-7.200172981e-03f, -7.226918972e-03f, -7.253650523e-03f, -7.280367587e-03f, -7.307070120e-03f, -7.333758077e-03f, -7.360431413e-03f, -7.387090083e-03f, -7.413734042e-03f, -7.440363245e-03f,
-7.466977646e-03f, -7.493577202e-03f, -7.520161868e-03f, -7.546731598e-03f, -7.573286348e-03f, -7.599826073e-03f, -7.626350729e-03f, -7.652860270e-03f, -7.679354653e-03f, -7.705833831e-03f,
-7.732297762e-03f, -7.758746400e-03f, -7.785179701e-03f, -7.811597620e-03f, -7.838000112e-03f, -7.864387134e-03f, -7.890758641e-03f, -7.917114589e-03f, -7.943454932e-03f, -7.969779627e-03f,
-7.996088630e-03f, -8.022381897e-03f, -8.048659382e-03f, -8.074921042e-03f, -8.101166833e-03f, -8.127396710e-03f, -8.153610629e-03f, -8.179808547e-03f, -8.205990420e-03f, -8.232156202e-03f,
-8.258305851e-03f, -8.284439322e-03f, -8.310556571e-03f, -8.336657555e-03f, -8.362742229e-03f, -8.388810550e-03f, -8.414862474e-03f, -8.440897957e-03f, -8.466916956e-03f, -8.492919427e-03f,
-8.518905325e-03f, -8.544874608e-03f, -8.570827232e-03f, -8.596763153e-03f, -8.622682327e-03f, -8.648584712e-03f, -8.674470263e-03f, -8.700338938e-03f, -8.726190693e-03f, -8.752025483e-03f,
-8.777843267e-03f, -8.803644001e-03f, -8.829427641e-03f, -8.855194144e-03f, -8.880943468e-03f, -8.906675568e-03f, -8.932390401e-03f, -8.958087925e-03f, -8.983768097e-03f, -9.009430872e-03f,
-9.035076209e-03f, -9.060704065e-03f, -9.086314395e-03f, -9.111907158e-03f, -9.137482311e-03f, -9.163039810e-03f, -9.188579613e-03f, -9.214101677e-03f, -9.239605960e-03f, -9.265092418e-03f,
-9.290561009e-03f, -9.316011690e-03f, -9.341444418e-03f, -9.366859152e-03f, -9.392255847e-03f, -9.417634463e-03f, -9.442994957e-03f, -9.468337285e-03f, -9.493661405e-03f, -9.518967276e-03f,
-9.544254855e-03f, -9.569524099e-03f, -9.594774967e-03f, -9.620007415e-03f, -9.645221402e-03f, -9.670416886e-03f, -9.695593824e-03f, -9.720752174e-03f, -9.745891895e-03f, -9.771012944e-03f,
-9.796115279e-03f, -9.821198858e-03f, -9.846263640e-03f, -9.871309582e-03f, -9.896336643e-03f, -9.921344780e-03f, -9.946333953e-03f, -9.971304118e-03f, -9.996255235e-03f, -1.002118726e-02f,
-1.004610016e-02f, -1.007099388e-02f, -1.009586839e-02f, -1.012072364e-02f, -1.014555959e-02f, -1.017037620e-02f, -1.019517343e-02f, -1.021995124e-02f, -1.024470959e-02f, -1.026944843e-02f,
-1.029416772e-02f, -1.031886743e-02f, -1.034354751e-02f, -1.036820791e-02f, -1.039284861e-02f, -1.041746956e-02f, -1.044207071e-02f, -1.046665203e-02f, -1.049121347e-02f, -1.051575499e-02f,
-1.054027656e-02f, -1.056477813e-02f, -1.058925967e-02f, -1.061372112e-02f, -1.063816245e-02f, -1.066258362e-02f, -1.068698459e-02f, -1.071136532e-02f, -1.073572576e-02f, -1.076006588e-02f,
-1.078438564e-02f, -1.080868499e-02f, -1.083296390e-02f, -1.085722232e-02f, -1.088146022e-02f, -1.090567755e-02f, -1.092987427e-02f, -1.095405035e-02f, -1.097820573e-02f, -1.100234040e-02f,
-1.102645429e-02f, -1.105054738e-02f, -1.107461962e-02f, -1.109867097e-02f, -1.112270139e-02f, -1.114671085e-02f, -1.117069930e-02f, -1.119466670e-02f, -1.121861302e-02f, -1.124253821e-02f,
-1.126644223e-02f, -1.129032504e-02f, -1.131418661e-02f, -1.133802690e-02f, -1.136184585e-02f, -1.138564345e-02f, -1.140941963e-02f, -1.143317438e-02f, -1.145690764e-02f, -1.148061938e-02f,
-1.150430956e-02f, -1.152797813e-02f, -1.155162506e-02f, -1.157525032e-02f, -1.159885385e-02f, -1.162243563e-02f, -1.164599561e-02f, -1.166953375e-02f, -1.169305002e-02f, -1.171654437e-02f,
-1.174001677e-02f, -1.176346718e-02f, -1.178689555e-02f, -1.181030186e-02f, -1.183368605e-02f, -1.185704810e-02f, -1.188038797e-02f, -1.190370560e-02f, -1.192700097e-02f, -1.195027405e-02f,
-1.197352478e-02f, -1.199675313e-02f, -1.201995906e-02f, -1.204314253e-02f, -1.206630352e-02f, -1.208944197e-02f, -1.211255784e-02f, -1.213565111e-02f, -1.215872173e-02f, -1.218176966e-02f,
-1.220479487e-02f, -1.222779732e-02f, -1.225077697e-02f, -1.227373378e-02f, -1.229666771e-02f, -1.231957873e-02f, -1.234246680e-02f, -1.236533187e-02f, -1.238817392e-02f, -1.241099291e-02f,
-1.243378879e-02f, -1.245656153e-02f, -1.247931109e-02f, -1.250203743e-02f, -1.252474053e-02f, -1.254742033e-02f, -1.257007680e-02f, -1.259270990e-02f, -1.261531961e-02f, -1.263790587e-02f,
-1.266046866e-02f, -1.268300792e-02f, -1.270552364e-02f, -1.272801577e-02f, -1.275048427e-02f, -1.277292911e-02f, -1.279535025e-02f, -1.281774764e-02f, -1.284012127e-02f, -1.286247108e-02f,
-1.288479705e-02f, -1.290709913e-02f, -1.292937728e-02f, -1.295163148e-02f, -1.297386169e-02f, -1.299606786e-02f, -1.301824996e-02f, -1.304040796e-02f, -1.306254182e-02f, -1.308465150e-02f,
-1.310673696e-02f, -1.312879817e-02f, -1.315083510e-02f, -1.317284770e-02f, -1.319483595e-02f, -1.321679980e-02f, -1.323873921e-02f, -1.326065416e-02f, -1.328254460e-02f, -1.330441051e-02f,
-1.332625183e-02f, -1.334806855e-02f, -1.336986062e-02f, -1.339162800e-02f, -1.341337067e-02f, -1.343508858e-02f, -1.345678170e-02f, -1.347844999e-02f, -1.350009342e-02f, -1.352171195e-02f,
-1.354330555e-02f, -1.356487418e-02f, -1.358641781e-02f, -1.360793640e-02f, -1.362942991e-02f, -1.365089831e-02f, -1.367234157e-02f, -1.369375965e-02f, -1.371515251e-02f, -1.373652012e-02f,
-1.375786245e-02f, -1.377917945e-02f, -1.380047110e-02f, -1.382173736e-02f, -1.384297819e-02f, -1.386419356e-02f, -1.388538344e-02f, -1.390654779e-02f, -1.392768657e-02f, -1.394879975e-02f,
-1.396988731e-02f, -1.399094919e-02f, -1.401198537e-02f, -1.403299581e-02f, -1.405398048e-02f, -1.407493934e-02f, -1.409587237e-02f, -1.411677952e-02f, -1.413766076e-02f, -1.415851606e-02f,
-1.417934538e-02f, -1.420014869e-02f, -1.422092596e-02f, -1.424167715e-02f, -1.426240222e-02f, -1.428310115e-02f, -1.430377389e-02f, -1.432442042e-02f, -1.434504071e-02f, -1.436563471e-02f,
-1.438620240e-02f, -1.440674373e-02f, -1.442725869e-02f, -1.444774723e-02f, -1.446820931e-02f, -1.448864492e-02f, -1.450905401e-02f, -1.452943655e-02f, -1.454979251e-02f, -1.457012185e-02f,
-1.459042454e-02f, -1.461070055e-02f, -1.463094984e-02f, -1.465117239e-02f, -1.467136815e-02f, -1.469153710e-02f, -1.471167920e-02f, -1.473179442e-02f, -1.475188273e-02f, -1.477194410e-02f,
-1.479197848e-02f, -1.481198585e-02f, -1.483196619e-02f, -1.485191944e-02f, -1.487184559e-02f, -1.489174459e-02f, -1.491161643e-02f, -1.493146105e-02f, -1.495127844e-02f, -1.497106856e-02f,
-1.499083138e-02f, -1.501056686e-02f, -1.503027498e-02f, -1.504995569e-02f, -1.506960898e-02f, -1.508923480e-02f, -1.510883313e-02f, -1.512840394e-02f, -1.514794718e-02f, -1.516746284e-02f,
-1.518695088e-02f, -1.520641126e-02f, -1.522584395e-02f, -1.524524893e-02f, -1.526462617e-02f, -1.528397562e-02f, -1.530329727e-02f, -1.532259107e-02f, -1.534185700e-02f, -1.536109502e-02f,
-1.538030511e-02f, -1.539948723e-02f, -1.541864136e-02f, -1.543776745e-02f, -1.545686549e-02f, -1.547593544e-02f, -1.549497726e-02f, -1.551399093e-02f, -1.553297642e-02f, -1.555193369e-02f,
-1.557086272e-02f, -1.558976348e-02f, -1.560863593e-02f, -1.562748004e-02f, -1.564629579e-02f, -1.566508314e-02f, -1.568384206e-02f, -1.570257252e-02f, -1.572127450e-02f, -1.573994795e-02f,
-1.575859286e-02f, -1.577720919e-02f, -1.579579691e-02f, -1.581435599e-02f, -1.583288641e-02f, -1.585138812e-02f, -1.586986111e-02f, -1.588830533e-02f, -1.590672077e-02f, -1.592510740e-02f,
-1.594346517e-02f, -1.596179407e-02f, -1.598009406e-02f, -1.599836511e-02f, -1.601660720e-02f, -1.603482030e-02f, -1.605300437e-02f, -1.607115939e-02f, -1.608928532e-02f, -1.610738214e-02f,
-1.612544982e-02f, -1.614348834e-02f, -1.616149765e-02f, -1.617947773e-02f, -1.619742856e-02f, -1.621535010e-02f, -1.623324232e-02f, -1.625110521e-02f, -1.626893872e-02f, -1.628674283e-02f,
-1.630451751e-02f, -1.632226273e-02f, -1.633997847e-02f, -1.635766469e-02f, -1.637532136e-02f, -1.639294847e-02f, -1.641054597e-02f, -1.642811385e-02f, -1.644565207e-02f, -1.646316061e-02f,
-1.648063943e-02f, -1.649808852e-02f, -1.651550783e-02f, -1.653289735e-02f, -1.655025704e-02f, -1.656758689e-02f, -1.658488685e-02f, -1.660215690e-02f, -1.661939702e-02f, -1.663660718e-02f,
-1.665378734e-02f, -1.667093749e-02f, -1.668805759e-02f, -1.670514762e-02f, -1.672220755e-02f, -1.673923735e-02f, -1.675623700e-02f, -1.677320647e-02f, -1.679014572e-02f, -1.680705475e-02f,
-1.682393350e-02f, -1.684078197e-02f, -1.685760013e-02f, -1.687438793e-02f, -1.689114537e-02f, -1.690787241e-02f, -1.692456903e-02f, -1.694123520e-02f, -1.695787089e-02f, -1.697447608e-02f,
-1.699105073e-02f, -1.700759483e-02f, -1.702410835e-02f, -1.704059126e-02f, -1.705704354e-02f, -1.707346515e-02f, -1.708985607e-02f, -1.710621629e-02f, -1.712254576e-02f, -1.713884447e-02f,
-1.715511238e-02f, -1.717134948e-02f, -1.718755573e-02f, -1.720373112e-02f, -1.721987561e-02f, -1.723598918e-02f, -1.725207181e-02f, -1.726812346e-02f, -1.728414412e-02f, -1.730013376e-02f,
-1.731609235e-02f, -1.733201986e-02f, -1.734791628e-02f, -1.736378157e-02f, -1.737961572e-02f, -1.739541869e-02f, -1.741119046e-02f, -1.742693101e-02f, -1.744264032e-02f, -1.745831834e-02f,
-1.747396507e-02f, -1.748958048e-02f, -1.750516454e-02f, -1.752071723e-02f, -1.753623852e-02f, -1.755172839e-02f, -1.756718682e-02f, -1.758261377e-02f, -1.759800923e-02f, -1.761337317e-02f,
-1.762870557e-02f, -1.764400640e-02f, -1.765927564e-02f, -1.767451327e-02f, -1.768971925e-02f, -1.770489358e-02f, -1.772003621e-02f, -1.773514713e-02f, -1.775022632e-02f, -1.776527375e-02f,
-1.778028940e-02f, -1.779527324e-02f, -1.781022525e-02f, -1.782514541e-02f, -1.784003369e-02f, -1.785489008e-02f, -1.786971454e-02f, -1.788450705e-02f, -1.789926759e-02f, -1.791399614e-02f,
-1.792869268e-02f, -1.794335717e-02f, -1.795798960e-02f, -1.797258995e-02f, -1.798715819e-02f, -1.800169430e-02f, -1.801619826e-02f, -1.803067004e-02f, -1.804510962e-02f, -1.805951698e-02f,
-1.807389209e-02f, -1.808823494e-02f, -1.810254550e-02f, -1.811682375e-02f, -1.813106966e-02f, -1.814528322e-02f, -1.815946440e-02f, -1.817361319e-02f, -1.818772954e-02f, -1.820181346e-02f,
-1.821586491e-02f, -1.822988387e-02f, -1.824387031e-02f, -1.825782423e-02f, -1.827174560e-02f, -1.828563438e-02f, -1.829949058e-02f, -1.831331415e-02f, -1.832710508e-02f, -1.834086336e-02f,
-1.835458894e-02f, -1.836828183e-02f, -1.838194199e-02f, -1.839556940e-02f, -1.840916405e-02f, -1.842272590e-02f, -1.843625495e-02f, -1.844975116e-02f, -1.846321453e-02f, -1.847664502e-02f,
-1.849004261e-02f, -1.850340730e-02f, -1.851673904e-02f, -1.853003784e-02f, -1.854330365e-02f, -1.855653647e-02f, -1.856973627e-02f, -1.858290304e-02f, -1.859603674e-02f, -1.860913737e-02f,
-1.862220490e-02f, -1.863523931e-02f, -1.864824058e-02f, -1.866120870e-02f, -1.867414363e-02f, -1.868704537e-02f, -1.869991389e-02f, -1.871274916e-02f, -1.872555118e-02f, -1.873831993e-02f,
-1.875105537e-02f, -1.876375750e-02f, -1.877642629e-02f, -1.878906173e-02f, -1.880166379e-02f, -1.881423245e-02f, -1.882676770e-02f, -1.883926952e-02f, -1.885173789e-02f, -1.886417278e-02f,
-1.887657418e-02f, -1.888894207e-02f, -1.890127644e-02f, -1.891357726e-02f, -1.892584451e-02f, -1.893807817e-02f, -1.895027823e-02f, -1.896244467e-02f, -1.897457747e-02f, -1.898667661e-02f,
-1.899874207e-02f, -1.901077383e-02f, -1.902277188e-02f, -1.903473620e-02f, -1.904666677e-02f, -1.905856356e-02f, -1.907042657e-02f, -1.908225578e-02f, -1.909405115e-02f, -1.910581269e-02f,
-1.911754037e-02f, -1.912923417e-02f, -1.914089408e-02f, -1.915252008e-02f, -1.916411214e-02f, -1.917567026e-02f, -1.918719441e-02f, -1.919868458e-02f, -1.921014075e-02f, -1.922156290e-02f,
-1.923295101e-02f, -1.924430508e-02f, -1.925562508e-02f, -1.926691099e-02f, -1.927816279e-02f, -1.928938048e-02f, -1.930056403e-02f, -1.931171343e-02f, -1.932282865e-02f, -1.933390969e-02f,
-1.934495652e-02f, -1.935596914e-02f, -1.936694751e-02f, -1.937789164e-02f, -1.938880149e-02f, -1.939967705e-02f, -1.941051832e-02f, -1.942132526e-02f, -1.943209787e-02f, -1.944283613e-02f,
-1.945354002e-02f, -1.946420953e-02f, -1.947484464e-02f, -1.948544533e-02f, -1.949601159e-02f, -1.950654341e-02f, -1.951704076e-02f, -1.952750363e-02f, -1.953793202e-02f, -1.954832589e-02f,
-1.955868524e-02f, -1.956901004e-02f, -1.957930029e-02f, -1.958955598e-02f, -1.959977707e-02f, -1.960996357e-02f, -1.962011544e-02f, -1.963023269e-02f, -1.964031529e-02f, -1.965036323e-02f,
-1.966037650e-02f, -1.967035507e-02f, -1.968029894e-02f, -1.969020809e-02f, -1.970008250e-02f, -1.970992216e-02f, -1.971972707e-02f, -1.972949719e-02f, -1.973923252e-02f, -1.974893304e-02f,
-1.975859874e-02f, -1.976822961e-02f, -1.977782563e-02f, -1.978738678e-02f, -1.979691306e-02f, -1.980640445e-02f, -1.981586093e-02f, -1.982528249e-02f, -1.983466912e-02f, -1.984402080e-02f,
-1.985333752e-02f, -1.986261927e-02f, -1.987186603e-02f, -1.988107779e-02f, -1.989025454e-02f, -1.989939626e-02f, -1.990850294e-02f, -1.991757456e-02f, -1.992661112e-02f, -1.993561260e-02f,
-1.994457899e-02f, -1.995351027e-02f, -1.996240643e-02f, -1.997126746e-02f, -1.998009334e-02f, -1.998888407e-02f, -1.999763963e-02f, -2.000636001e-02f, -2.001504519e-02f, -2.002369516e-02f,
-2.003230991e-02f, -2.004088944e-02f, -2.004943371e-02f, -2.005794273e-02f, -2.006641649e-02f, -2.007485496e-02f, -2.008325814e-02f, -2.009162601e-02f, -2.009995857e-02f, -2.010825580e-02f,
-2.011651768e-02f, -2.012474422e-02f, -2.013293539e-02f, -2.014109119e-02f, -2.014921160e-02f, -2.015729661e-02f, -2.016534621e-02f, -2.017336039e-02f, -2.018133914e-02f, -2.018928245e-02f,
-2.019719030e-02f, -2.020506268e-02f, -2.021289959e-02f, -2.022070101e-02f, -2.022846693e-02f, -2.023619734e-02f, -2.024389223e-02f, -2.025155159e-02f, -2.025917541e-02f, -2.026676368e-02f,
-2.027431638e-02f, -2.028183351e-02f, -2.028931505e-02f, -2.029676100e-02f, -2.030417135e-02f, -2.031154608e-02f, -2.031888519e-02f, -2.032618866e-02f, -2.033345648e-02f, -2.034068865e-02f,
-2.034788516e-02f, -2.035504599e-02f, -2.036217114e-02f, -2.036926059e-02f, -2.037631434e-02f, -2.038333237e-02f, -2.039031468e-02f, -2.039726126e-02f, -2.040417210e-02f, -2.041104718e-02f,
-2.041788651e-02f, -2.042469006e-02f, -2.043145784e-02f, -2.043818982e-02f, -2.044488601e-02f, -2.045154639e-02f, -2.045817096e-02f, -2.046475970e-02f, -2.047131261e-02f, -2.047782968e-02f,
-2.048431090e-02f, -2.049075626e-02f, -2.049716575e-02f, -2.050353936e-02f, -2.050987710e-02f, -2.051617893e-02f, -2.052244487e-02f, -2.052867490e-02f, -2.053486901e-02f, -2.054102719e-02f,
-2.054714944e-02f, -2.055323575e-02f, -2.055928611e-02f, -2.056530051e-02f, -2.057127895e-02f, -2.057722141e-02f, -2.058312790e-02f, -2.058899839e-02f, -2.059483289e-02f, -2.060063138e-02f,
-2.060639387e-02f, -2.061212034e-02f, -2.061781078e-02f, -2.062346518e-02f, -2.062908355e-02f, -2.063466587e-02f, -2.064021214e-02f, -2.064572235e-02f, -2.065119649e-02f, -2.065663455e-02f,
-2.066203653e-02f, -2.066740243e-02f, -2.067273222e-02f, -2.067802592e-02f, -2.068328351e-02f, -2.068850499e-02f, -2.069369034e-02f, -2.069883956e-02f, -2.070395266e-02f, -2.070902961e-02f,
-2.071407042e-02f, -2.071907507e-02f, -2.072404356e-02f, -2.072897590e-02f, -2.073387206e-02f, -2.073873204e-02f, -2.074355585e-02f, -2.074834346e-02f, -2.075309488e-02f, -2.075781011e-02f,
-2.076248913e-02f, -2.076713194e-02f, -2.077173853e-02f, -2.077630891e-02f, -2.078084305e-02f, -2.078534097e-02f, -2.078980265e-02f, -2.079422809e-02f, -2.079861728e-02f, -2.080297022e-02f,
-2.080728691e-02f, -2.081156733e-02f, -2.081581149e-02f, -2.082001937e-02f, -2.082419099e-02f, -2.082832632e-02f, -2.083242536e-02f, -2.083648812e-02f, -2.084051459e-02f, -2.084450475e-02f,
-2.084845862e-02f, -2.085237618e-02f, -2.085625742e-02f, -2.086010236e-02f, -2.086391097e-02f, -2.086768327e-02f, -2.087141923e-02f, -2.087511887e-02f, -2.087878217e-02f, -2.088240913e-02f,
-2.088599976e-02f, -2.088955403e-02f, -2.089307196e-02f, -2.089655354e-02f, -2.089999876e-02f, -2.090340762e-02f, -2.090678012e-02f, -2.091011626e-02f, -2.091341603e-02f, -2.091667942e-02f,
-2.091990644e-02f, -2.092309709e-02f, -2.092625135e-02f, -2.092936923e-02f, -2.093245072e-02f, -2.093549583e-02f, -2.093850454e-02f, -2.094147686e-02f, -2.094441279e-02f, -2.094731231e-02f,
-2.095017543e-02f, -2.095300215e-02f, -2.095579247e-02f, -2.095854637e-02f, -2.096126387e-02f, -2.096394495e-02f, -2.096658962e-02f, -2.096919787e-02f, -2.097176971e-02f, -2.097430512e-02f,
-2.097680411e-02f, -2.097926668e-02f, -2.098169282e-02f, -2.098408254e-02f, -2.098643583e-02f, -2.098875269e-02f, -2.099103311e-02f, -2.099327711e-02f, -2.099548467e-02f, -2.099765579e-02f,
-2.099979048e-02f, -2.100188874e-02f, -2.100395055e-02f, -2.100597593e-02f, -2.100796486e-02f, -2.100991736e-02f, -2.101183341e-02f, -2.101371302e-02f, -2.101555619e-02f, -2.101736292e-02f,
-2.101913320e-02f, -2.102086703e-02f, -2.102256442e-02f, -2.102422537e-02f, -2.102584987e-02f, -2.102743793e-02f, -2.102898954e-02f, -2.103050470e-02f, -2.103198342e-02f, -2.103342569e-02f,
-2.103483152e-02f, -2.103620090e-02f, -2.103753383e-02f, -2.103883032e-02f, -2.104009037e-02f, -2.104131397e-02f, -2.104250113e-02f, -2.104365185e-02f, -2.104476612e-02f, -2.104584395e-02f,
-2.104688534e-02f, -2.104789029e-02f, -2.104885881e-02f, -2.104979088e-02f, -2.105068651e-02f, -2.105154571e-02f, -2.105236848e-02f, -2.105315481e-02f, -2.105390470e-02f, -2.105461817e-02f,
-2.105529521e-02f, -2.105593581e-02f, -2.105653999e-02f, -2.105710775e-02f, -2.105763908e-02f, -2.105813399e-02f, -2.105859248e-02f, -2.105901454e-02f, -2.105940020e-02f, -2.105974943e-02f,
-2.106006226e-02f, -2.106033867e-02f, -2.106057868e-02f, -2.106078228e-02f, -2.106094947e-02f, -2.106108026e-02f, -2.106117466e-02f, -2.106123265e-02f, -2.106125426e-02f, -2.106123947e-02f,
-2.106118829e-02f, -2.106110072e-02f, -2.106097677e-02f, -2.106081644e-02f, -2.106061973e-02f, -2.106038664e-02f, -2.106011718e-02f, -2.105981136e-02f, -2.105946916e-02f, -2.105909061e-02f,
-2.105867569e-02f, -2.105822442e-02f, -2.105773680e-02f, -2.105721282e-02f, -2.105665250e-02f, -2.105605584e-02f, -2.105542284e-02f, -2.105475350e-02f, -2.105404783e-02f, -2.105330584e-02f,
-2.105252752e-02f, -2.105171288e-02f, -2.105086192e-02f, -2.104997466e-02f, -2.104905108e-02f, -2.104809121e-02f, -2.104709503e-02f, -2.104606256e-02f, -2.104499379e-02f, -2.104388875e-02f,
-2.104274742e-02f, -2.104156981e-02f, -2.104035593e-02f, -2.103910579e-02f, -2.103781938e-02f, -2.103649671e-02f, -2.103513779e-02f, -2.103374262e-02f, -2.103231121e-02f, -2.103084356e-02f,
-2.102933968e-02f, -2.102779956e-02f, -2.102622323e-02f, -2.102461068e-02f, -2.102296192e-02f, -2.102127695e-02f, -2.101955578e-02f, -2.101779841e-02f, -2.101600485e-02f, -2.101417511e-02f,
-2.101230920e-02f, -2.101040711e-02f, -2.100846885e-02f, -2.100649443e-02f, -2.100448386e-02f, -2.100243713e-02f, -2.100035427e-02f, -2.099823527e-02f, -2.099608014e-02f, -2.099388888e-02f,
-2.099166151e-02f, -2.098939802e-02f, -2.098709843e-02f, -2.098476275e-02f, -2.098239097e-02f, -2.097998310e-02f, -2.097753916e-02f, -2.097505915e-02f, -2.097254307e-02f, -2.096999094e-02f,
-2.096740275e-02f, -2.096477852e-02f, -2.096211826e-02f, -2.095942196e-02f, -2.095668965e-02f, -2.095392132e-02f, -2.095111698e-02f, -2.094827664e-02f, -2.094540031e-02f, -2.094248799e-02f,
-2.093953970e-02f, -2.093655543e-02f, -2.093353521e-02f, -2.093047903e-02f, -2.092738690e-02f, -2.092425884e-02f, -2.092109484e-02f, -2.091789493e-02f, -2.091465910e-02f, -2.091138736e-02f,
-2.090807972e-02f, -2.090473620e-02f, -2.090135679e-02f, -2.089794151e-02f, -2.089449036e-02f, -2.089100336e-02f, -2.088748051e-02f, -2.088392183e-02f, -2.088032731e-02f, -2.087669697e-02f,
-2.087303082e-02f, -2.086932887e-02f, -2.086559112e-02f, -2.086181758e-02f, -2.085800827e-02f, -2.085416319e-02f, -2.085028235e-02f, -2.084636576e-02f, -2.084241344e-02f, -2.083842538e-02f,
-2.083440160e-02f, -2.083034211e-02f, -2.082624692e-02f, -2.082211604e-02f, -2.081794947e-02f, -2.081374723e-02f, -2.080950933e-02f, -2.080523577e-02f, -2.080092658e-02f, -2.079658174e-02f,
-2.079220129e-02f, -2.078778522e-02f, -2.078333355e-02f, -2.077884628e-02f, -2.077432344e-02f, -2.076976502e-02f, -2.076517104e-02f, -2.076054150e-02f, -2.075587643e-02f, -2.075117583e-02f,
-2.074643970e-02f, -2.074166807e-02f, -2.073686094e-02f, -2.073201833e-02f, -2.072714023e-02f, -2.072222667e-02f, -2.071727766e-02f, -2.071229320e-02f, -2.070727332e-02f, -2.070221801e-02f,
-2.069712729e-02f, -2.069200117e-02f, -2.068683966e-02f, -2.068164278e-02f, -2.067641054e-02f, -2.067114294e-02f, -2.066584001e-02f, -2.066050174e-02f, -2.065512815e-02f, -2.064971926e-02f,
-2.064427508e-02f, -2.063879561e-02f, -2.063328087e-02f, -2.062773088e-02f, -2.062214564e-02f, -2.061652517e-02f, -2.061086947e-02f, -2.060517857e-02f, -2.059945246e-02f, -2.059369118e-02f,
-2.058789472e-02f, -2.058206310e-02f, -2.057619634e-02f, -2.057029444e-02f, -2.056435742e-02f, -2.055838529e-02f, -2.055237806e-02f, -2.054633575e-02f, -2.054025837e-02f, -2.053414593e-02f,
-2.052799845e-02f, -2.052181594e-02f, -2.051559841e-02f, -2.050934587e-02f, -2.050305835e-02f, -2.049673584e-02f, -2.049037837e-02f, -2.048398595e-02f, -2.047755859e-02f, -2.047109631e-02f,
-2.046459912e-02f, -2.045806703e-02f, -2.045150006e-02f, -2.044489821e-02f, -2.043826152e-02f, -2.043158998e-02f, -2.042488361e-02f, -2.041814243e-02f, -2.041136645e-02f, -2.040455569e-02f,
-2.039771015e-02f, -2.039082986e-02f, -2.038391483e-02f, -2.037696507e-02f, -2.036998059e-02f, -2.036296142e-02f, -2.035590756e-02f, -2.034881904e-02f, -2.034169585e-02f, -2.033453803e-02f,
-2.032734558e-02f, -2.032011853e-02f, -2.031285687e-02f, -2.030556064e-02f, -2.029822984e-02f, -2.029086449e-02f, -2.028346461e-02f, -2.027603020e-02f, -2.026856129e-02f, -2.026105790e-02f,
-2.025352003e-02f, -2.024594770e-02f, -2.023834092e-02f, -2.023069972e-02f, -2.022302411e-02f, -2.021531410e-02f, -2.020756972e-02f, -2.019979096e-02f, -2.019197786e-02f, -2.018413043e-02f,
-2.017624868e-02f, -2.016833263e-02f, -2.016038230e-02f, -2.015239769e-02f, -2.014437884e-02f, -2.013632575e-02f, -2.012823844e-02f, -2.012011693e-02f, -2.011196123e-02f, -2.010377136e-02f,
-2.009554734e-02f, -2.008728918e-02f, -2.007899690e-02f, -2.007067051e-02f, -2.006231004e-02f, -2.005391551e-02f, -2.004548691e-02f, -2.003702429e-02f, -2.002852764e-02f, -2.001999699e-02f,
-2.001143236e-02f, -2.000283376e-02f, -1.999420121e-02f, -1.998553472e-02f, -1.997683432e-02f, -1.996810003e-02f, -1.995933185e-02f, -1.995052981e-02f, -1.994169392e-02f, -1.993282421e-02f,
-1.992392069e-02f, -1.991498337e-02f, -1.990601228e-02f, -1.989700744e-02f, -1.988796885e-02f, -1.987889654e-02f, -1.986979054e-02f, -1.986065084e-02f, -1.985147749e-02f, -1.984227048e-02f,
-1.983302984e-02f, -1.982375559e-02f, -1.981444775e-02f, -1.980510634e-02f, -1.979573137e-02f, -1.978632286e-02f, -1.977688083e-02f, -1.976740530e-02f, -1.975789630e-02f, -1.974835382e-02f,
-1.973877791e-02f, -1.972916857e-02f, -1.971952582e-02f, -1.970984969e-02f, -1.970014019e-02f, -1.969039734e-02f, -1.968062116e-02f, -1.967081168e-02f, -1.966096890e-02f, -1.965109285e-02f,
-1.964118354e-02f, -1.963124101e-02f, -1.962126526e-02f, -1.961125632e-02f, -1.960121420e-02f, -1.959113893e-02f, -1.958103052e-02f, -1.957088900e-02f, -1.956071439e-02f, -1.955050670e-02f,
-1.954026596e-02f, -1.952999218e-02f, -1.951968538e-02f, -1.950934559e-02f, -1.949897283e-02f, -1.948856711e-02f, -1.947812846e-02f, -1.946765690e-02f, -1.945715244e-02f, -1.944661511e-02f,
-1.943604493e-02f, -1.942544191e-02f, -1.941480609e-02f, -1.940413747e-02f, -1.939343609e-02f, -1.938270195e-02f, -1.937193509e-02f, -1.936113552e-02f, -1.935030327e-02f, -1.933943835e-02f,
-1.932854079e-02f, -1.931761060e-02f, -1.930664781e-02f, -1.929565245e-02f, -1.928462452e-02f, -1.927356405e-02f, -1.926247107e-02f, -1.925134560e-02f, -1.924018765e-02f, -1.922899725e-02f,
-1.921777442e-02f, -1.920651918e-02f, -1.919523155e-02f, -1.918391156e-02f, -1.917255923e-02f, -1.916117457e-02f, -1.914975762e-02f, -1.913830839e-02f, -1.912682690e-02f, -1.911531318e-02f,
-1.910376725e-02f, -1.909218913e-02f, -1.908057884e-02f, -1.906893641e-02f, -1.905726186e-02f, -1.904555521e-02f, -1.903381648e-02f, -1.902204570e-02f, -1.901024289e-02f, -1.899840806e-02f,
-1.898654126e-02f, -1.897464248e-02f, -1.896271177e-02f, -1.895074914e-02f, -1.893875461e-02f, -1.892672821e-02f, -1.891466997e-02f, -1.890257989e-02f, -1.889045802e-02f, -1.887830436e-02f,
-1.886611895e-02f, -1.885390181e-02f, -1.884165295e-02f, -1.882937241e-02f, -1.881706021e-02f, -1.880471636e-02f, -1.879234090e-02f, -1.877993385e-02f, -1.876749523e-02f, -1.875502507e-02f,
-1.874252338e-02f, -1.872999020e-02f, -1.871742554e-02f, -1.870482944e-02f, -1.869220191e-02f, -1.867954297e-02f, -1.866685266e-02f, -1.865413100e-02f, -1.864137801e-02f, -1.862859371e-02f,
-1.861577813e-02f, -1.860293130e-02f, -1.859005323e-02f, -1.857714396e-02f, -1.856420350e-02f, -1.855123189e-02f, -1.853822914e-02f, -1.852519528e-02f, -1.851213034e-02f, -1.849903434e-02f,
-1.848590730e-02f, -1.847274926e-02f, -1.845956022e-02f, -1.844634023e-02f, -1.843308931e-02f, -1.841980747e-02f, -1.840649475e-02f, -1.839315117e-02f, -1.837977675e-02f, -1.836637153e-02f,
-1.835293552e-02f, -1.833946875e-02f, -1.832597125e-02f, -1.831244305e-02f, -1.829888416e-02f, -1.828529461e-02f, -1.827167443e-02f, -1.825802365e-02f, -1.824434229e-02f, -1.823063037e-02f,
-1.821688793e-02f, -1.820311499e-02f, -1.818931157e-02f, -1.817547770e-02f, -1.816161340e-02f, -1.814771871e-02f, -1.813379364e-02f, -1.811983823e-02f, -1.810585251e-02f, -1.809183648e-02f,
-1.807779019e-02f, -1.806371367e-02f, -1.804960692e-02f, -1.803546999e-02f, -1.802130290e-02f, -1.800710568e-02f, -1.799287834e-02f, -1.797862093e-02f, -1.796433346e-02f, -1.795001597e-02f,
-1.793566847e-02f, -1.792129100e-02f, -1.790688359e-02f, -1.789244625e-02f, -1.787797902e-02f, -1.786348193e-02f, -1.784895500e-02f, -1.783439825e-02f, -1.781981173e-02f, -1.780519544e-02f,
-1.779054943e-02f, -1.777587372e-02f, -1.776116833e-02f, -1.774643329e-02f, -1.773166863e-02f, -1.771687439e-02f, -1.770205058e-02f, -1.768719723e-02f, -1.767231437e-02f, -1.765740203e-02f,
-1.764246024e-02f, -1.762748902e-02f, -1.761248841e-02f, -1.759745842e-02f, -1.758239910e-02f, -1.756731046e-02f, -1.755219254e-02f, -1.753704536e-02f, -1.752186895e-02f, -1.750666334e-02f,
-1.749142855e-02f, -1.747616463e-02f, -1.746087159e-02f, -1.744554946e-02f, -1.743019827e-02f, -1.741481805e-02f, -1.739940883e-02f, -1.738397064e-02f, -1.736850351e-02f, -1.735300746e-02f,
-1.733748252e-02f, -1.732192873e-02f, -1.730634610e-02f, -1.729073468e-02f, -1.727509449e-02f, -1.725942555e-02f, -1.724372790e-02f, -1.722800157e-02f, -1.721224659e-02f, -1.719646297e-02f,
-1.718065077e-02f, -1.716480999e-02f, -1.714894068e-02f, -1.713304287e-02f, -1.711711657e-02f, -1.710116182e-02f, -1.708517866e-02f, -1.706916711e-02f, -1.705312719e-02f, -1.703705895e-02f,
-1.702096240e-02f, -1.700483759e-02f, -1.698868453e-02f, -1.697250326e-02f, -1.695629381e-02f, -1.694005621e-02f, -1.692379049e-02f, -1.690749668e-02f, -1.689117481e-02f, -1.687482491e-02f,
-1.685844700e-02f, -1.684204113e-02f, -1.682560731e-02f, -1.680914559e-02f, -1.679265599e-02f, -1.677613853e-02f, -1.675959326e-02f, -1.674302021e-02f, -1.672641939e-02f, -1.670979085e-02f,
-1.669313461e-02f, -1.667645071e-02f, -1.665973917e-02f, -1.664300003e-02f, -1.662623331e-02f, -1.660943906e-02f, -1.659261729e-02f, -1.657576804e-02f, -1.655889135e-02f, -1.654198724e-02f,
-1.652505573e-02f, -1.650809688e-02f, -1.649111070e-02f, -1.647409722e-02f, -1.645705649e-02f, -1.643998852e-02f, -1.642289336e-02f, -1.640577102e-02f, -1.638862155e-02f, -1.637144498e-02f,
-1.635424133e-02f, -1.633701065e-02f, -1.631975295e-02f, -1.630246827e-02f, -1.628515665e-02f, -1.626781811e-02f, -1.625045269e-02f, -1.623306042e-02f, -1.621564133e-02f, -1.619819545e-02f,
-1.618072282e-02f, -1.616322346e-02f, -1.614569742e-02f, -1.612814471e-02f, -1.611056538e-02f, -1.609295946e-02f, -1.607532697e-02f, -1.605766795e-02f, -1.603998244e-02f, -1.602227046e-02f,
-1.600453205e-02f, -1.598676723e-02f, -1.596897605e-02f, -1.595115854e-02f, -1.593331472e-02f, -1.591544464e-02f, -1.589754831e-02f, -1.587962579e-02f, -1.586167709e-02f, -1.584370225e-02f,
-1.582570131e-02f, -1.580767429e-02f, -1.578962124e-02f, -1.577154217e-02f, -1.575343714e-02f, -1.573530616e-02f, -1.571714928e-02f, -1.569896652e-02f, -1.568075792e-02f, -1.566252351e-02f,
-1.564426333e-02f, -1.562597740e-02f, -1.560766577e-02f, -1.558932847e-02f, -1.557096552e-02f, -1.555257697e-02f, -1.553416284e-02f, -1.551572317e-02f, -1.549725799e-02f, -1.547876735e-02f,
-1.546025126e-02f, -1.544170977e-02f, -1.542314290e-02f, -1.540455070e-02f, -1.538593319e-02f, -1.536729042e-02f, -1.534862240e-02f, -1.532992919e-02f, -1.531121081e-02f, -1.529246729e-02f,
-1.527369867e-02f, -1.525490499e-02f, -1.523608628e-02f, -1.521724257e-02f, -1.519837389e-02f, -1.517948029e-02f, -1.516056179e-02f, -1.514161844e-02f, -1.512265026e-02f, -1.510365728e-02f,
-1.508463956e-02f, -1.506559711e-02f, -1.504652997e-02f, -1.502743818e-02f, -1.500832177e-02f, -1.498918078e-02f, -1.497001524e-02f, -1.495082519e-02f, -1.493161066e-02f, -1.491237169e-02f,
-1.489310830e-02f, -1.487382055e-02f, -1.485450845e-02f, -1.483517205e-02f, -1.481581139e-02f, -1.479642649e-02f, -1.477701739e-02f, -1.475758413e-02f, -1.473812674e-02f, -1.471864525e-02f,
-1.469913971e-02f, -1.467961015e-02f, -1.466005661e-02f, -1.464047911e-02f, -1.462087769e-02f, -1.460125240e-02f, -1.458160326e-02f, -1.456193031e-02f, -1.454223359e-02f, -1.452251314e-02f,
-1.450276898e-02f, -1.448300115e-02f, -1.446320970e-02f, -1.444339465e-02f, -1.442355604e-02f, -1.440369391e-02f, -1.438380829e-02f, -1.436389922e-02f, -1.434396674e-02f, -1.432401088e-02f,
-1.430403168e-02f, -1.428402917e-02f, -1.426400339e-02f, -1.424395437e-02f, -1.422388216e-02f, -1.420378679e-02f, -1.418366829e-02f, -1.416352670e-02f, -1.414336207e-02f, -1.412317441e-02f,
-1.410296378e-02f, -1.408273020e-02f, -1.406247372e-02f, -1.404219436e-02f, -1.402189218e-02f, -1.400156719e-02f, -1.398121945e-02f, -1.396084898e-02f, -1.394045583e-02f, -1.392004003e-02f,
-1.389960162e-02f, -1.387914063e-02f, -1.385865710e-02f, -1.383815107e-02f, -1.381762257e-02f, -1.379707165e-02f, -1.377649833e-02f, -1.375590267e-02f, -1.373528468e-02f, -1.371464442e-02f,
-1.369398191e-02f, -1.367329720e-02f, -1.365259032e-02f, -1.363186131e-02f, -1.361111021e-02f, -1.359033705e-02f, -1.356954187e-02f, -1.354872471e-02f, -1.352788561e-02f, -1.350702461e-02f,
-1.348614173e-02f, -1.346523703e-02f, -1.344431053e-02f, -1.342336227e-02f, -1.340239230e-02f, -1.338140065e-02f, -1.336038735e-02f, -1.333935246e-02f, -1.331829599e-02f, -1.329721800e-02f,
-1.327611851e-02f, -1.325499757e-02f, -1.323385522e-02f, -1.321269149e-02f, -1.319150642e-02f, -1.317030006e-02f, -1.314907242e-02f, -1.312782357e-02f, -1.310655352e-02f, -1.308526233e-02f,
-1.306395003e-02f, -1.304261666e-02f, -1.302126225e-02f, -1.299988685e-02f, -1.297849050e-02f, -1.295707322e-02f, -1.293563507e-02f, -1.291417607e-02f, -1.289269627e-02f, -1.287119571e-02f,
-1.284967442e-02f, -1.282813244e-02f, -1.280656982e-02f, -1.278498658e-02f, -1.276338278e-02f, -1.274175844e-02f, -1.272011361e-02f, -1.269844833e-02f, -1.267676263e-02f, -1.265505655e-02f,
-1.263333013e-02f, -1.261158342e-02f, -1.258981644e-02f, -1.256802924e-02f, -1.254622187e-02f, -1.252439434e-02f, -1.250254672e-02f, -1.248067903e-02f, -1.245879131e-02f, -1.243688361e-02f,
-1.241495596e-02f, -1.239300840e-02f, -1.237104098e-02f, -1.234905372e-02f, -1.232704668e-02f, -1.230501988e-02f, -1.228297337e-02f, -1.226090719e-02f, -1.223882138e-02f, -1.221671598e-02f,
-1.219459102e-02f, -1.217244655e-02f, -1.215028261e-02f, -1.212809923e-02f, -1.210589645e-02f, -1.208367432e-02f, -1.206143288e-02f, -1.203917216e-02f, -1.201689220e-02f, -1.199459305e-02f,
-1.197227474e-02f, -1.194993732e-02f, -1.192758082e-02f, -1.190520528e-02f, -1.188281075e-02f, -1.186039726e-02f, -1.183796485e-02f, -1.181551357e-02f, -1.179304345e-02f, -1.177055453e-02f,
-1.174804686e-02f, -1.172552048e-02f, -1.170297541e-02f, -1.168041172e-02f, -1.165782942e-02f, -1.163522857e-02f, -1.161260921e-02f, -1.158997137e-02f, -1.156731510e-02f, -1.154464044e-02f,
-1.152194742e-02f, -1.149923609e-02f, -1.147650649e-02f, -1.145375866e-02f, -1.143099263e-02f, -1.140820846e-02f, -1.138540617e-02f, -1.136258582e-02f, -1.133974744e-02f, -1.131689107e-02f,
-1.129401675e-02f, -1.127112453e-02f, -1.124821444e-02f, -1.122528653e-02f, -1.120234083e-02f, -1.117937739e-02f, -1.115639625e-02f, -1.113339745e-02f, -1.111038102e-02f, -1.108734702e-02f,
-1.106429548e-02f, -1.104122644e-02f, -1.101813995e-02f, -1.099503604e-02f, -1.097191475e-02f, -1.094877614e-02f, -1.092562023e-02f, -1.090244707e-02f, -1.087925670e-02f, -1.085604916e-02f,
-1.083282450e-02f, -1.080958275e-02f, -1.078632396e-02f, -1.076304816e-02f, -1.073975541e-02f, -1.071644573e-02f, -1.069311917e-02f, -1.066977578e-02f, -1.064641559e-02f, -1.062303865e-02f,
-1.059964499e-02f, -1.057623467e-02f, -1.055280771e-02f, -1.052936417e-02f, -1.050590408e-02f, -1.048242748e-02f, -1.045893442e-02f, -1.043542495e-02f, -1.041189909e-02f, -1.038835689e-02f,
-1.036479840e-02f, -1.034122365e-02f, -1.031763270e-02f, -1.029402557e-02f, -1.027040231e-02f, -1.024676297e-02f, -1.022310758e-02f, -1.019943619e-02f, -1.017574883e-02f, -1.015204556e-02f,
-1.012832642e-02f, -1.010459143e-02f, -1.008084066e-02f, -1.005707414e-02f, -1.003329190e-02f, -1.000949400e-02f, -9.985680481e-03f, -9.961851376e-03f, -9.938006732e-03f, -9.914146591e-03f,
-9.890270995e-03f, -9.866379986e-03f, -9.842473607e-03f, -9.818551899e-03f, -9.794614906e-03f, -9.770662670e-03f, -9.746695234e-03f, -9.722712638e-03f, -9.698714927e-03f, -9.674702143e-03f,
-9.650674328e-03f, -9.626631524e-03f, -9.602573775e-03f, -9.578501122e-03f, -9.554413609e-03f, -9.530311277e-03f, -9.506194171e-03f, -9.482062332e-03f, -9.457915803e-03f, -9.433754626e-03f,
-9.409578845e-03f, -9.385388503e-03f, -9.361183641e-03f, -9.336964303e-03f, -9.312730532e-03f, -9.288482370e-03f, -9.264219861e-03f, -9.239943047e-03f, -9.215651971e-03f, -9.191346677e-03f,
-9.167027206e-03f, -9.142693602e-03f, -9.118345909e-03f, -9.093984168e-03f, -9.069608424e-03f, -9.045218719e-03f, -9.020815096e-03f, -8.996397598e-03f, -8.971966269e-03f, -8.947521152e-03f,
-8.923062289e-03f, -8.898589725e-03f, -8.874103501e-03f, -8.849603662e-03f, -8.825090251e-03f, -8.800563310e-03f, -8.776022884e-03f, -8.751469016e-03f, -8.726901748e-03f, -8.702321125e-03f,
-8.677727189e-03f, -8.653119984e-03f, -8.628499553e-03f, -8.603865941e-03f, -8.579219189e-03f, -8.554559342e-03f, -8.529886444e-03f, -8.505200537e-03f, -8.480501666e-03f, -8.455789873e-03f,
-8.431065203e-03f, -8.406327699e-03f, -8.381577404e-03f, -8.356814363e-03f, -8.332038618e-03f, -8.307250214e-03f, -8.282449195e-03f, -8.257635603e-03f, -8.232809482e-03f, -8.207970877e-03f,
-8.183119831e-03f, -8.158256388e-03f, -8.133380592e-03f, -8.108492486e-03f, -8.083592114e-03f, -8.058679520e-03f, -8.033754749e-03f, -8.008817843e-03f, -7.983868847e-03f, -7.958907805e-03f,
-7.933934761e-03f, -7.908949758e-03f, -7.883952840e-03f, -7.858944053e-03f, -7.833923438e-03f, -7.808891042e-03f, -7.783846906e-03f, -7.758791077e-03f, -7.733723597e-03f, -7.708644512e-03f,
-7.683553864e-03f, -7.658451698e-03f, -7.633338058e-03f, -7.608212989e-03f, -7.583076534e-03f, -7.557928738e-03f, -7.532769645e-03f, -7.507599300e-03f, -7.482417745e-03f, -7.457225026e-03f,
-7.432021188e-03f, -7.406806273e-03f, -7.381580327e-03f, -7.356343394e-03f, -7.331095518e-03f, -7.305836743e-03f, -7.280567115e-03f, -7.255286676e-03f, -7.229995473e-03f, -7.204693548e-03f,
-7.179380947e-03f, -7.154057714e-03f, -7.128723894e-03f, -7.103379530e-03f, -7.078024668e-03f, -7.052659352e-03f, -7.027283626e-03f, -7.001897535e-03f, -6.976501124e-03f, -6.951094436e-03f,
-6.925677518e-03f, -6.900250412e-03f, -6.874813165e-03f, -6.849365820e-03f, -6.823908422e-03f, -6.798441016e-03f, -6.772963646e-03f, -6.747476358e-03f, -6.721979195e-03f, -6.696472203e-03f,
-6.670955426e-03f, -6.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 