/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static Configuration toConfiguration(Element element) {
        Object object;
        Object object2;
        int n;
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration(element.getNodeName(), "dom-created");
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (n = 0; n < n2; ++n) {
            object2 = namedNodeMap.item(n);
            object = object2.getNodeName();
            String string = object2.getNodeValue();
            defaultConfiguration.setAttribute((String)object, string);
        }
        n = 0;
        object2 = "";
        object = element.getChildNodes();
        int n3 = object.getLength();
        for (int i = 0; i < n3; ++i) {
            Object object3;
            Node node = object.item(i);
            if (node instanceof Element) {
                object3 = ConfigurationUtil.toConfiguration((Element)node);
                defaultConfiguration.addChild((Configuration)object3);
                continue;
            }
            if (!(node instanceof CharacterData)) continue;
            object3 = (CharacterData)node;
            object2 = (String)object2 + object3.getData();
            n = 1;
        }
        if (n != 0) {
            defaultConfiguration.setValue((String)object2);
        }
        return defaultConfiguration;
    }

    public static Element toElement(Configuration configuration) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return ConfigurationUtil.createElement(document, configuration);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException.toString());
        }
    }

    public static String toString(Configuration configuration) {
        DefaultConfigurationSerializer defaultConfigurationSerializer = new DefaultConfigurationSerializer();
        try {
            return defaultConfigurationSerializer.serialize(configuration);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public static boolean equals(Configuration configuration, Configuration configuration2) {
        return configuration.getName().equals(configuration2.getName()) && ConfigurationUtil.areValuesEqual(configuration, configuration2) && ConfigurationUtil.areAttributesEqual(configuration, configuration2) && ConfigurationUtil.areChildrenEqual(configuration, configuration2);
    }

    private static boolean areChildrenEqual(Configuration configuration, Configuration configuration2) {
        ArrayList<Configuration> arrayList;
        Configuration[] configurationArray = configuration.getChildren();
        if (configurationArray.length != (arrayList = new ArrayList<Configuration>(Arrays.asList(configuration2.getChildren()))).size()) {
            return false;
        }
        for (int i = 0; i < configurationArray.length; ++i) {
            if (ConfigurationUtil.findMatchingChild(configurationArray[i], arrayList)) continue;
            return false;
        }
        return arrayList.isEmpty();
    }

    private static boolean findMatchingChild(Configuration configuration, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!ConfigurationUtil.equals(configuration, (Configuration)iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private static boolean areAttributesEqual(Configuration configuration, Configuration configuration2) {
        String[] stringArray;
        String[] stringArray2 = configuration.getAttributeNames();
        if (stringArray2.length != (stringArray = configuration2.getAttributeNames()).length) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String string;
            String string2 = stringArray2[i];
            String string3 = configuration.getAttribute(string2, null);
            if (string3.equals(string = configuration2.getAttribute(string2, null))) continue;
            return false;
        }
        return true;
    }

    private static boolean areValuesEqual(Configuration configuration, Configuration configuration2) {
        String string = configuration.getValue(null);
        String string2 = configuration2.getValue(null);
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    private static Element createElement(Document document, Configuration configuration) {
        Object object;
        Object object2;
        Element element = document.createElement(configuration.getName());
        String string = configuration.getValue(null);
        if (null != string) {
            object2 = document.createTextNode(string);
            element.appendChild((Node)object2);
        }
        object2 = configuration.getAttributeNames();
        for (int i = 0; i < ((String[])object2).length; ++i) {
            String string2 = object2[i];
            object = configuration.getAttribute(string2, null);
            element.setAttribute(string2, (String)object);
        }
        Configuration[] configurationArray = configuration.getChildren();
        for (int i = 0; i < configurationArray.length; ++i) {
            object = ConfigurationUtil.createElement(document, configurationArray[i]);
            element.appendChild((Node)object);
        }
        return element;
    }
}

