/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.context;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Resolvable;

public class DefaultContext
implements Context {
    private static final Hidden HIDDEN_MAKER = new Hidden();
    private final Map m_contextData;
    private final Context m_parent;
    private boolean m_readOnly;

    public DefaultContext(Map map, Context context) {
        this.m_parent = context;
        this.m_contextData = map;
    }

    public DefaultContext(Map map) {
        this(map, null);
    }

    public DefaultContext(Context context) {
        this(new Hashtable(), context);
    }

    public DefaultContext() {
        this((Context)null);
    }

    @Override
    public Object get(Object object) throws ContextException {
        Object v = this.m_contextData.get(object);
        if (null != v) {
            if (v instanceof Hidden) {
                String string = "Unable to locate " + object;
                throw new ContextException(string);
            }
            if (v instanceof Resolvable) {
                return ((Resolvable)v).resolve(this);
            }
            return v;
        }
        if (null == this.m_parent) {
            String string = "Unable to resolve context key: " + object;
            throw new ContextException(string);
        }
        return this.m_parent.get(object);
    }

    public void put(Object object, Object object2) throws IllegalStateException {
        this.checkWriteable();
        if (null == object2) {
            this.m_contextData.remove(object);
        } else {
            this.m_contextData.put(object, object2);
        }
    }

    public void hide(Object object) throws IllegalStateException {
        this.checkWriteable();
        this.m_contextData.put(object, HIDDEN_MAKER);
    }

    protected final Map getContextData() {
        return this.m_contextData;
    }

    protected final Context getParent() {
        return this.m_parent;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    private static final class Hidden
    implements Serializable {
        private Hidden() {
        }
    }
}

