/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.DOMViewer;
import org.apache.batik.apps.svgbrowser.DOMViewerController;
import org.apache.batik.apps.svgbrowser.ElementOverlayManager;
import org.apache.batik.apps.svgbrowser.FindDialog;
import org.apache.batik.apps.svgbrowser.JPEGOptionPanel;
import org.apache.batik.apps.svgbrowser.LocalHistory;
import org.apache.batik.apps.svgbrowser.PNGOptionPanel;
import org.apache.batik.apps.svgbrowser.Resources;
import org.apache.batik.apps.svgbrowser.SVGInputHandler;
import org.apache.batik.apps.svgbrowser.SVGOptionPanel;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandler;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandlerFilter;
import org.apache.batik.apps.svgbrowser.StatusBar;
import org.apache.batik.apps.svgbrowser.ThumbnailDialog;
import org.apache.batik.apps.svgbrowser.TransformHistory;
import org.apache.batik.apps.svgbrowser.WindowsAltFileSystemView;
import org.apache.batik.bridge.DefaultExternalResourceSecurity;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.EmbededExternalResourceSecurity;
import org.apache.batik.bridge.EmbededScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.NoLoadExternalResourceSecurity;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.dom.StyleSheetProcessingInstruction;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.ext.swing.JAffineTransformChooser;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGFileFilter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Platform;
import org.apache.batik.util.Service;
import org.apache.batik.util.gui.JErrorPane;
import org.apache.batik.util.gui.LocationBar;
import org.apache.batik.util.gui.MemoryMonitor;
import org.apache.batik.util.gui.URIChooser;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MenuFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ToolBarFactory;
import org.apache.batik.util.gui.xmleditor.XMLDocument;
import org.apache.batik.util.gui.xmleditor.XMLTextEditor;
import org.apache.batik.util.resources.ResourceManager;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGViewerFrame
extends JFrame
implements ActionMap,
SVGDocumentLoaderListener,
GVTTreeBuilderListener,
SVGLoadEventDispatcherListener,
GVTTreeRendererListener,
LinkActivationListener,
UpdateManagerListener {
    private static String EOL;
    protected static boolean priorJDK1_4;
    protected static final String JDK_1_4_PRESENCE_TEST_CLASS = "java.util.logging.LoggingPermission";
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.GUI";
    public static final String ABOUT_ACTION = "AboutAction";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OPEN_LOCATION_ACTION = "OpenLocationAction";
    public static final String NEW_WINDOW_ACTION = "NewWindowAction";
    public static final String RELOAD_ACTION = "ReloadAction";
    public static final String SAVE_AS_ACTION = "SaveAsAction";
    public static final String BACK_ACTION = "BackAction";
    public static final String FORWARD_ACTION = "ForwardAction";
    public static final String FULL_SCREEN_ACTION = "FullScreenAction";
    public static final String PRINT_ACTION = "PrintAction";
    public static final String EXPORT_AS_JPG_ACTION = "ExportAsJPGAction";
    public static final String EXPORT_AS_PNG_ACTION = "ExportAsPNGAction";
    public static final String EXPORT_AS_TIFF_ACTION = "ExportAsTIFFAction";
    public static final String PREFERENCES_ACTION = "PreferencesAction";
    public static final String CLOSE_ACTION = "CloseAction";
    public static final String VIEW_SOURCE_ACTION = "ViewSourceAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransformAction";
    public static final String ZOOM_IN_ACTION = "ZoomInAction";
    public static final String ZOOM_OUT_ACTION = "ZoomOutAction";
    public static final String PREVIOUS_TRANSFORM_ACTION = "PreviousTransformAction";
    public static final String NEXT_TRANSFORM_ACTION = "NextTransformAction";
    public static final String USE_STYLESHEET_ACTION = "UseStylesheetAction";
    public static final String PLAY_ACTION = "PlayAction";
    public static final String PAUSE_ACTION = "PauseAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String MONITOR_ACTION = "MonitorAction";
    public static final String DOM_VIEWER_ACTION = "DOMViewerAction";
    public static final String SET_TRANSFORM_ACTION = "SetTransformAction";
    public static final String FIND_DIALOG_ACTION = "FindDialogAction";
    public static final String THUMBNAIL_DIALOG_ACTION = "ThumbnailDialogAction";
    public static final String FLUSH_ACTION = "FlushAction";
    public static final String TOGGLE_DEBUGGER_ACTION = "ToggleDebuggerAction";
    public static final Cursor WAIT_CURSOR;
    public static final Cursor DEFAULT_CURSOR;
    public static final String PROPERTY_OS_NAME;
    public static final String PROPERTY_OS_NAME_DEFAULT;
    public static final String PROPERTY_OS_WINDOWS_PREFIX;
    protected static final String OPEN_TITLE = "Open.title";
    protected static Vector handlers;
    protected static SquiggleInputHandler defaultHandler;
    protected static ResourceBundle bundle;
    protected static ResourceManager resources;
    protected Application application;
    protected Canvas svgCanvas;
    protected JPanel svgCanvasPanel;
    protected JWindow window;
    protected static JFrame memoryMonitorFrame;
    protected File currentPath = new File("");
    protected File currentSavePath = new File("");
    protected BackAction backAction = new BackAction();
    protected ForwardAction forwardAction = new ForwardAction();
    protected PlayAction playAction = new PlayAction();
    protected PauseAction pauseAction = new PauseAction();
    protected StopAction stopAction = new StopAction();
    protected PreviousTransformAction previousTransformAction = new PreviousTransformAction();
    protected NextTransformAction nextTransformAction = new NextTransformAction();
    protected UseStylesheetAction useStylesheetAction = new UseStylesheetAction();
    protected boolean debug;
    protected boolean autoAdjust = true;
    protected boolean managerStopped;
    protected SVGUserAgent userAgent = new UserAgent();
    protected SVGDocument svgDocument;
    protected URIChooser uriChooser;
    protected DOMViewer domViewer;
    protected FindDialog findDialog;
    protected ThumbnailDialog thumbnailDialog;
    protected JAffineTransformChooser.Dialog transformDialog;
    protected LocationBar locationBar;
    protected StatusBar statusBar;
    protected String title;
    protected LocalHistory localHistory;
    protected TransformHistory transformHistory = new TransformHistory();
    protected String alternateStyleSheet;
    protected Debugger debugger;
    protected Map listeners = new HashMap();
    long time;

    public JSVGViewerFrame(Application app) {
        this.application = app;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JSVGViewerFrame.this.application.closeJSVGViewerFrame(JSVGViewerFrame.this);
            }
        });
        this.svgCanvas = new Canvas(this.userAgent, true, true){
            Dimension screenSize;
            {
                this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setMaximumSize(this.screenSize);
            }

            public Dimension getPreferredSize() {
                Dimension s = super.getPreferredSize();
                if (s.width > this.screenSize.width) {
                    s.width = this.screenSize.width;
                }
                if (s.height > this.screenSize.height) {
                    s.height = this.screenSize.height;
                }
                return s;
            }

            public void setMySize(Dimension d) {
                this.setPreferredSize(d);
                this.invalidate();
                if (JSVGViewerFrame.this.autoAdjust) {
                    JSVGViewerFrame.this.setExtendedState(JSVGViewerFrame.this.getExtendedState() & 0xFFFFFFF9);
                    JSVGViewerFrame.this.pack();
                }
            }

            public void setDisableInteractions(boolean b) {
                super.setDisableInteractions(b);
                ((Action)JSVGViewerFrame.this.listeners.get(JSVGViewerFrame.SET_TRANSFORM_ACTION)).setEnabled(!b);
                if (JSVGViewerFrame.this.thumbnailDialog != null) {
                    JSVGViewerFrame.this.thumbnailDialog.setInteractionEnabled(!b);
                }
            }
        };
        javax.swing.ActionMap map = this.svgCanvas.getActionMap();
        map.put(FULL_SCREEN_ACTION, new FullScreenAction());
        InputMap imap = this.svgCanvas.getInputMap(0);
        KeyStroke key = KeyStroke.getKeyStroke(122, 0);
        imap.put(key, FULL_SCREEN_ACTION);
        this.svgCanvas.setDoubleBufferedRendering(true);
        this.listeners.put(ABOUT_ACTION, new AboutAction());
        this.listeners.put(OPEN_ACTION, new OpenAction());
        this.listeners.put(OPEN_LOCATION_ACTION, new OpenLocationAction());
        this.listeners.put(NEW_WINDOW_ACTION, new NewWindowAction());
        this.listeners.put(RELOAD_ACTION, new ReloadAction());
        this.listeners.put(SAVE_AS_ACTION, new SaveAsAction());
        this.listeners.put(BACK_ACTION, this.backAction);
        this.listeners.put(FORWARD_ACTION, this.forwardAction);
        this.listeners.put(PRINT_ACTION, new PrintAction());
        this.listeners.put(EXPORT_AS_JPG_ACTION, new ExportAsJPGAction());
        this.listeners.put(EXPORT_AS_PNG_ACTION, new ExportAsPNGAction());
        this.listeners.put(EXPORT_AS_TIFF_ACTION, new ExportAsTIFFAction());
        this.listeners.put(PREFERENCES_ACTION, new PreferencesAction());
        this.listeners.put(CLOSE_ACTION, new CloseAction());
        this.listeners.put(EXIT_ACTION, this.application.createExitAction(this));
        this.listeners.put(VIEW_SOURCE_ACTION, new ViewSourceAction());
        javax.swing.ActionMap cMap = this.svgCanvas.getActionMap();
        this.listeners.put(RESET_TRANSFORM_ACTION, cMap.get("ResetTransform"));
        this.listeners.put(ZOOM_IN_ACTION, cMap.get("ZoomIn"));
        this.listeners.put(ZOOM_OUT_ACTION, cMap.get("ZoomOut"));
        this.listeners.put(PREVIOUS_TRANSFORM_ACTION, this.previousTransformAction);
        key = KeyStroke.getKeyStroke(75, 2);
        imap.put(key, this.previousTransformAction);
        this.listeners.put(NEXT_TRANSFORM_ACTION, this.nextTransformAction);
        key = KeyStroke.getKeyStroke(76, 2);
        imap.put(key, this.nextTransformAction);
        this.listeners.put(USE_STYLESHEET_ACTION, this.useStylesheetAction);
        this.listeners.put(PLAY_ACTION, this.playAction);
        this.listeners.put(PAUSE_ACTION, this.pauseAction);
        this.listeners.put(STOP_ACTION, this.stopAction);
        this.listeners.put(MONITOR_ACTION, new MonitorAction());
        this.listeners.put(DOM_VIEWER_ACTION, new DOMViewerAction());
        this.listeners.put(SET_TRANSFORM_ACTION, new SetTransformAction());
        this.listeners.put(FIND_DIALOG_ACTION, new FindDialogAction());
        this.listeners.put(THUMBNAIL_DIALOG_ACTION, new ThumbnailDialogAction());
        this.listeners.put(FLUSH_ACTION, new FlushAction());
        this.listeners.put(TOGGLE_DEBUGGER_ACTION, new ToggleDebuggerAction());
        JPanel p = null;
        try {
            MenuFactory mf = new MenuFactory(bundle, (ActionMap)this);
            JMenuBar mb = mf.createJMenuBar("MenuBar", this.application.getUISpecialization());
            this.setJMenuBar(mb);
            this.localHistory = new LocalHistory(mb, this);
            String[] uri = this.application.getVisitedURIs();
            for (int i = 0; i < uri.length; ++i) {
                if (uri[i] == null || "".equals(uri[i])) continue;
                this.localHistory.update(uri[i]);
            }
            p = new JPanel(new BorderLayout());
            ToolBarFactory tbf = new ToolBarFactory(bundle, (ActionMap)this);
            JToolBar tb = tbf.createJToolBar("ToolBar");
            tb.setFloatable(false);
            this.getContentPane().add((Component)p, "North");
            p.add((Component)tb, "North");
            p.add((Component)new JSeparator(), "Center");
            this.locationBar = new LocationBar();
            p.add((Component)this.locationBar, "South");
            this.locationBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        catch (MissingResourceException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
        this.svgCanvasPanel = new JPanel(new BorderLayout());
        this.svgCanvasPanel.setBorder(BorderFactory.createEtchedBorder());
        this.svgCanvasPanel.add((Component)((Object)this.svgCanvas), "Center");
        p = new JPanel(new BorderLayout());
        p.add((Component)this.svgCanvasPanel, "Center");
        this.statusBar = new StatusBar();
        p.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)p, "Center");
        this.svgCanvas.addSVGDocumentLoaderListener(this);
        this.svgCanvas.addGVTTreeBuilderListener(this);
        this.svgCanvas.addSVGLoadEventDispatcherListener(this);
        this.svgCanvas.addGVTTreeRendererListener(this);
        this.svgCanvas.addLinkActivationListener(this);
        this.svgCanvas.addUpdateManagerListener(this);
        this.svgCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setXPosition(e.getX());
                    JSVGViewerFrame.this.statusBar.setYPosition(e.getY());
                } else {
                    try {
                        AffineTransform at = JSVGViewerFrame.this.svgCanvas.getViewBoxTransform();
                        if (at != null) {
                            at = at.createInverse();
                            Point2D p2d = at.transform(new Point2D.Float(e.getX(), e.getY()), null);
                            JSVGViewerFrame.this.statusBar.setXPosition((float)p2d.getX());
                            JSVGViewerFrame.this.statusBar.setYPosition((float)p2d.getY());
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setXPosition(e.getX());
                    JSVGViewerFrame.this.statusBar.setYPosition(e.getY());
                }
            }
        });
        this.svgCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Dimension dim = JSVGViewerFrame.this.svgCanvas.getSize();
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setWidth(dim.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dim.height);
                } else {
                    try {
                        AffineTransform at = JSVGViewerFrame.this.svgCanvas.getViewBoxTransform();
                        if (at != null) {
                            at = at.createInverse();
                            Point2D o = at.transform(new Point2D.Float(0.0f, 0.0f), null);
                            Point2D p2d = at.transform(new Point2D.Float(dim.width, dim.height), null);
                            JSVGViewerFrame.this.statusBar.setWidth((float)(p2d.getX() - o.getX()));
                            JSVGViewerFrame.this.statusBar.setHeight((float)(p2d.getY() - o.getY()));
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setWidth(dim.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dim.height);
                }
            }
        });
        this.svgCanvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dim = JSVGViewerFrame.this.svgCanvas.getSize();
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setWidth(dim.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dim.height);
                } else {
                    try {
                        AffineTransform at = JSVGViewerFrame.this.svgCanvas.getViewBoxTransform();
                        if (at != null) {
                            at = at.createInverse();
                            Point2D o = at.transform(new Point2D.Float(0.0f, 0.0f), null);
                            Point2D p2d = at.transform(new Point2D.Float(dim.width, dim.height), null);
                            JSVGViewerFrame.this.statusBar.setWidth((float)(p2d.getX() - o.getX()));
                            JSVGViewerFrame.this.statusBar.setHeight((float)(p2d.getY() - o.getY()));
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setWidth(dim.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dim.height);
                }
            }
        });
        this.locationBar.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String t;
                String st;
                block11: {
                    st = JSVGViewerFrame.this.locationBar.getText().trim();
                    int i = st.indexOf(35);
                    t = "";
                    if (i != -1) {
                        t = st.substring(i + 1);
                        st = st.substring(0, i);
                    }
                    if (st.equals("")) {
                        return;
                    }
                    try {
                        File f = new File(st);
                        if (!f.exists()) break block11;
                        if (f.isDirectory()) {
                            return;
                        }
                        try {
                            st = f.getCanonicalPath();
                            if (st.startsWith("/")) {
                                st = "file:" + st;
                                break block11;
                            }
                            st = "file:/" + st;
                        }
                        catch (IOException iOException) {}
                    }
                    catch (SecurityException f) {
                        // empty catch block
                    }
                }
                String fi = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                if (JSVGViewerFrame.this.svgDocument != null) {
                    ParsedURL docPURL = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
                    ParsedURL purl = new ParsedURL(docPURL, st);
                    String string = fi = fi == null ? "" : fi;
                    if (docPURL.equals((Object)purl) && t.equals(fi)) {
                        return;
                    }
                }
                if (t.length() != 0) {
                    st = st + '#' + t;
                }
                JSVGViewerFrame.this.locationBar.setText(st);
                JSVGViewerFrame.this.locationBar.addToHistory(st);
                JSVGViewerFrame.this.showSVGDocument(st);
            }
        });
    }

    @Override
    public void dispose() {
        this.hideDebugger();
        this.svgCanvas.dispose();
        super.dispose();
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setAutoAdjust(boolean b) {
        this.autoAdjust = b;
    }

    public JSVGCanvas getJSVGCanvas() {
        return this.svgCanvas;
    }

    private static File makeAbsolute(File f) {
        if (!f.isAbsolute()) {
            return f.getAbsoluteFile();
        }
        return f;
    }

    public void showDebugger() {
        if (this.debugger == null && Debugger.isPresent) {
            this.debugger = new Debugger(this, this.locationBar.getText());
            this.debugger.initialize();
        }
    }

    public void hideDebugger() {
        if (this.debugger != null) {
            this.debugger.clearAllBreakpoints();
            this.debugger.go();
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    public void showSVGDocument(String uri) {
        block2: {
            try {
                ParsedURL purl = new ParsedURL(uri);
                SquiggleInputHandler handler = this.getInputHandler(purl);
                handler.handle(purl, this);
            }
            catch (Exception e) {
                if (this.userAgent == null) break block2;
                this.userAgent.displayError(e);
            }
        }
    }

    public SquiggleInputHandler getInputHandler(ParsedURL purl) throws IOException {
        Iterator iter = JSVGViewerFrame.getHandlers().iterator();
        SquiggleInputHandler handler = null;
        while (iter.hasNext()) {
            SquiggleInputHandler curHandler = (SquiggleInputHandler)iter.next();
            if (!curHandler.accept(purl)) continue;
            handler = curHandler;
            break;
        }
        if (handler == null) {
            handler = defaultHandler;
        }
        return handler;
    }

    protected static Vector getHandlers() {
        if (handlers != null) {
            return handlers;
        }
        handlers = new Vector();
        JSVGViewerFrame.registerHandler(new SVGInputHandler());
        Iterator iter = Service.providers(SquiggleInputHandler.class);
        while (iter.hasNext()) {
            SquiggleInputHandler handler = (SquiggleInputHandler)iter.next();
            JSVGViewerFrame.registerHandler(handler);
        }
        return handlers;
    }

    public static synchronized void registerHandler(SquiggleInputHandler handler) {
        Vector handlers = JSVGViewerFrame.getHandlers();
        handlers.addElement(handler);
    }

    public Action getAction(String key) throws MissingListenerException {
        Action result = (Action)this.listeners.get(key);
        if (result == null) {
            throw new MissingListenerException("Can't find action.", RESOURCES, key);
        }
        return result;
    }

    public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
        String msg = resources.getString("Message.documentLoad");
        if (this.debug) {
            System.out.println(msg);
            this.time = System.currentTimeMillis();
        }
        this.statusBar.setMainMessage(msg);
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
    }

    public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
        if (this.debug) {
            System.out.print(resources.getString("Message.documentLoadTime"));
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.setSVGDocument(e.getSVGDocument(), e.getSVGDocument().getURL(), e.getSVGDocument().getTitle());
    }

    public void setSVGDocument(SVGDocument svgDocument, String svgDocumentURL, String svgDocumentTitle) {
        String dt;
        this.svgDocument = svgDocument;
        if (this.domViewer != null) {
            if (this.domViewer.isVisible() && svgDocument != null) {
                this.domViewer.setDocument((org.w3c.dom.Document)svgDocument, (ViewCSS)((Object)svgDocument.getDocumentElement()));
            } else {
                this.domViewer.dispose();
                this.domViewer = null;
            }
        }
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        String s = svgDocumentURL;
        this.locationBar.setText(s);
        if (this.debugger != null) {
            this.debugger.detach();
            this.debugger.setDocumentURL(s);
        }
        if (this.title == null) {
            this.title = this.getTitle();
        }
        if ((dt = svgDocumentTitle).length() != 0) {
            this.setTitle(this.title + ": " + dt);
        } else {
            int i = s.lastIndexOf("/");
            if (i == -1) {
                i = s.lastIndexOf("\\");
            }
            if (i == -1) {
                this.setTitle(this.title + ": " + s);
            } else {
                this.setTitle(this.title + ": " + s.substring(i + 1));
            }
        }
        this.localHistory.update(s);
        this.application.addVisitedURI(s);
        this.backAction.update();
        this.forwardAction.update();
        this.transformHistory = new TransformHistory();
        this.previousTransformAction.update();
        this.nextTransformAction.update();
        this.useStylesheetAction.update();
    }

    public void documentLoadingCancelled(SVGDocumentLoaderEvent e) {
        String msg = resources.getString("Message.documentCancelled");
        if (this.debug) {
            System.out.println(msg);
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
        String msg = resources.getString("Message.documentFailed");
        if (this.debug) {
            System.out.println(msg);
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtBuildStarted(GVTTreeBuilderEvent e) {
        String msg = resources.getString("Message.treeBuild");
        if (this.debug) {
            System.out.println(msg);
            this.time = System.currentTimeMillis();
        }
        this.statusBar.setMainMessage(msg);
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
    }

    public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
        if (this.debug) {
            System.out.print(resources.getString("Message.treeBuildTime"));
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        if (this.findDialog != null) {
            if (this.findDialog.isVisible()) {
                this.findDialog.setGraphicsNode(this.svgCanvas.getGraphicsNode());
            } else {
                this.findDialog.dispose();
                this.findDialog = null;
            }
        }
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.svgCanvas.setSelectionOverlayXORMode(this.application.isSelectionOverlayXORMode());
        this.svgCanvas.requestFocus();
        if (this.debugger != null) {
            this.debugger.attach();
        }
    }

    public void gvtBuildCancelled(GVTTreeBuilderEvent e) {
        String msg = resources.getString("Message.treeCancelled");
        if (this.debug) {
            System.out.println(msg);
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.svgCanvas.setSelectionOverlayXORMode(this.application.isSelectionOverlayXORMode());
    }

    public void gvtBuildFailed(GVTTreeBuilderEvent e) {
        String msg = resources.getString("Message.treeFailed");
        if (this.debug) {
            System.out.println(msg);
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.svgCanvas.setSelectionOverlayXORMode(this.application.isSelectionOverlayXORMode());
        if (this.autoAdjust) {
            this.pack();
        }
    }

    public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
        String msg = resources.getString("Message.onload");
        if (this.debug) {
            System.out.println(msg);
            this.time = System.currentTimeMillis();
        }
        this.stopAction.update(true);
        this.statusBar.setMainMessage(msg);
    }

    public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent e) {
        if (this.debug) {
            System.out.print(resources.getString("Message.onloadTime"));
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.stopAction.update(false);
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.done"));
    }

    public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent e) {
        String msg = resources.getString("Message.onloadCancelled");
        if (this.debug) {
            System.out.println(msg);
        }
        this.stopAction.update(false);
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
    }

    public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent e) {
        String msg = resources.getString("Message.onloadFailed");
        if (this.debug) {
            System.out.println(msg);
        }
        this.stopAction.update(false);
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
    }

    public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.treeRenderingPrep");
            System.out.println(msg);
            this.time = System.currentTimeMillis();
        }
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
        this.statusBar.setMainMessage(resources.getString("Message.treeRendering"));
    }

    public void gvtRenderingStarted(GVTTreeRendererEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.treeRenderingPrepTime");
            System.out.print(msg);
            System.out.println(System.currentTimeMillis() - this.time + " ms");
            this.time = System.currentTimeMillis();
            msg = resources.getString("Message.treeRenderingStart");
            System.out.println(msg);
        }
    }

    public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.treeRenderingTime");
            System.out.print(msg);
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.done"));
        if (!this.svgCanvas.isDynamic() || this.managerStopped) {
            this.stopAction.update(false);
        }
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.transformHistory.update(this.svgCanvas.getRenderingTransform());
        this.previousTransformAction.update();
        this.nextTransformAction.update();
    }

    public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
        String msg = resources.getString("Message.treeRenderingCancelled");
        if (this.debug) {
            System.out.println(msg);
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
        if (!this.svgCanvas.isDynamic()) {
            this.stopAction.update(false);
        }
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtRenderingFailed(GVTTreeRendererEvent e) {
        String msg = resources.getString("Message.treeRenderingFailed");
        if (this.debug) {
            System.out.println(msg);
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(msg);
        if (!this.svgCanvas.isDynamic()) {
            this.stopAction.update(false);
        }
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void linkActivated(LinkActivationEvent e) {
        String s = e.getReferencedURI();
        if (this.svgDocument != null) {
            ParsedURL docURL = new ParsedURL(this.svgDocument.getURL());
            ParsedURL url = new ParsedURL(docURL, s);
            if (!url.sameFile(docURL)) {
                return;
            }
            if (s.indexOf(35) != -1) {
                this.localHistory.update(s);
                this.locationBar.setText(s);
                if (this.debugger != null) {
                    this.debugger.detach();
                    this.debugger.setDocumentURL(s);
                }
                this.application.addVisitedURI(s);
                this.backAction.update();
                this.forwardAction.update();
                this.transformHistory = new TransformHistory();
                this.previousTransformAction.update();
                this.nextTransformAction.update();
            }
        }
    }

    public void managerStarted(UpdateManagerEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.updateManagerStarted");
            System.out.println(msg);
        }
        this.managerStopped = false;
        this.playAction.update(false);
        this.pauseAction.update(true);
        this.stopAction.update(true);
    }

    public void managerSuspended(UpdateManagerEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.updateManagerSuspended");
            System.out.println(msg);
        }
        this.playAction.update(true);
        this.pauseAction.update(false);
    }

    public void managerResumed(UpdateManagerEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.updateManagerResumed");
            System.out.println(msg);
        }
        this.playAction.update(false);
        this.pauseAction.update(true);
    }

    public void managerStopped(UpdateManagerEvent e) {
        if (this.debug) {
            String msg = resources.getString("Message.updateManagerStopped");
            System.out.println(msg);
        }
        this.managerStopped = true;
        this.playAction.update(false);
        this.pauseAction.update(false);
        this.stopAction.update(false);
    }

    public void updateStarted(UpdateManagerEvent e) {
    }

    public void updateCompleted(UpdateManagerEvent e) {
    }

    public void updateFailed(UpdateManagerEvent e) {
    }

    static {
        try {
            EOL = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            EOL = "\n";
        }
        priorJDK1_4 = true;
        try {
            Class.forName(JDK_1_4_PRESENCE_TEST_CLASS);
            priorJDK1_4 = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        WAIT_CURSOR = new Cursor(3);
        DEFAULT_CURSOR = new Cursor(0);
        PROPERTY_OS_NAME = Resources.getString("JSVGViewerFrame.property.os.name");
        PROPERTY_OS_NAME_DEFAULT = Resources.getString("JSVGViewerFrame.property.os.name.default");
        PROPERTY_OS_WINDOWS_PREFIX = Resources.getString("JSVGViewerFrame.property.os.windows.prefix");
        defaultHandler = new SVGInputHandler();
        bundle = ResourceBundle.getBundle(RESOURCES, Locale.getDefault());
        resources = new ResourceManager(bundle);
    }

    protected static class ImageFileFilter
    extends FileFilter {
        protected String extension;

        public ImageFileFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File f) {
            boolean accept = false;
            String fileName = null;
            if (f != null) {
                if (f.isDirectory()) {
                    accept = true;
                } else {
                    fileName = f.getPath().toLowerCase();
                    if (fileName.endsWith(this.extension)) {
                        accept = true;
                    }
                }
            }
            return accept;
        }

        @Override
        public String getDescription() {
            return this.extension;
        }
    }

    protected class UserAgent
    implements SVGUserAgent {
        protected UserAgent() {
        }

        public void displayError(String message) {
            if (JSVGViewerFrame.this.debug) {
                System.err.println(message);
            }
            JOptionPane pane = new JOptionPane(message, 0);
            JDialog dialog = pane.createDialog(JSVGViewerFrame.this, "ERROR");
            dialog.setModal(false);
            dialog.setVisible(true);
        }

        public void displayError(Exception ex) {
            if (JSVGViewerFrame.this.debug) {
                ex.printStackTrace();
            }
            JErrorPane pane = new JErrorPane((Throwable)ex, 0);
            JDialog dialog = pane.createDialog((Component)JSVGViewerFrame.this, "ERROR");
            dialog.setModal(false);
            dialog.setVisible(true);
        }

        public void displayMessage(String message) {
            JSVGViewerFrame.this.statusBar.setMessage(message);
        }

        public void showAlert(String message) {
            JSVGViewerFrame.this.svgCanvas.showAlert(message);
        }

        public String showPrompt(String message) {
            return JSVGViewerFrame.this.svgCanvas.showPrompt(message);
        }

        public String showPrompt(String message, String defaultValue) {
            return JSVGViewerFrame.this.svgCanvas.showPrompt(message, defaultValue);
        }

        public boolean showConfirm(String message) {
            return JSVGViewerFrame.this.svgCanvas.showConfirm(message);
        }

        public float getPixelUnitToMillimeter() {
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            return JSVGViewerFrame.this.application.getDefaultFontFamily();
        }

        public float getMediumFontSize() {
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            int weight = (int)((f + 50.0f) / 100.0f) * 100;
            switch (weight) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            return JSVGViewerFrame.this.application.getLanguages();
        }

        public String getUserStyleSheetURI() {
            return JSVGViewerFrame.this.application.getUserStyleSheetURI();
        }

        public String getXMLParserClassName() {
            return JSVGViewerFrame.this.application.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            return JSVGViewerFrame.this.application.isXMLParserValidating();
        }

        public String getMedia() {
            return JSVGViewerFrame.this.application.getMedia();
        }

        public String getAlternateStyleSheet() {
            return JSVGViewerFrame.this.alternateStyleSheet;
        }

        public void openLink(String uri, boolean newc) {
            if (newc) {
                JSVGViewerFrame.this.application.openLink(uri);
            } else {
                JSVGViewerFrame.this.showSVGDocument(uri);
            }
        }

        public boolean supportExtension(String s) {
            return false;
        }

        public void handleElement(Element elt, Object data) {
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
            if (!JSVGViewerFrame.this.application.canLoadScriptType(scriptType)) {
                return new NoLoadScriptSecurity(scriptType);
            }
            switch (JSVGViewerFrame.this.application.getAllowedScriptOrigin()) {
                case 1: {
                    return new RelaxedScriptSecurity(scriptType, scriptURL, docURL);
                }
                case 2: {
                    return new DefaultScriptSecurity(scriptType, scriptURL, docURL);
                }
                case 4: {
                    return new EmbededScriptSecurity(scriptType, scriptURL, docURL);
                }
            }
            return new NoLoadScriptSecurity(scriptType);
        }

        public void checkLoadScript(String scriptType, ParsedURL scriptURL, ParsedURL docURL) throws SecurityException {
            ScriptSecurity s = this.getScriptSecurity(scriptType, scriptURL, docURL);
            if (s != null) {
                s.checkLoadScript();
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
            switch (JSVGViewerFrame.this.application.getAllowedExternalResourceOrigin()) {
                case 1: {
                    return new RelaxedExternalResourceSecurity(resourceURL, docURL);
                }
                case 2: {
                    return new DefaultExternalResourceSecurity(resourceURL, docURL);
                }
                case 4: {
                    return new EmbededExternalResourceSecurity(resourceURL);
                }
            }
            return new NoLoadExternalResourceSecurity();
        }

        public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
            ExternalResourceSecurity s = this.getExternalResourceSecurity(resourceURL, docURL);
            if (s != null) {
                s.checkLoadExternalResource();
            }
        }
    }

    public class DOMViewerAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            this.openDOMViewer();
        }

        public void openDOMViewer() {
            if (JSVGViewerFrame.this.domViewer == null || JSVGViewerFrame.this.domViewer.isDisplayable()) {
                JSVGViewerFrame.this.domViewer = new DOMViewer(JSVGViewerFrame.this.svgCanvas.new Canvas.JSVGViewerDOMViewerController());
                Rectangle fr = JSVGViewerFrame.this.getBounds();
                Dimension td = JSVGViewerFrame.this.domViewer.getSize();
                JSVGViewerFrame.this.domViewer.setLocation(fr.x + (fr.width - td.width) / 2, fr.y + (fr.height - td.height) / 2);
            }
            JSVGViewerFrame.this.domViewer.setVisible(true);
        }

        public DOMViewer getDOMViewer() {
            return JSVGViewerFrame.this.domViewer;
        }
    }

    public class FullScreenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.window == null || !JSVGViewerFrame.this.window.isVisible()) {
                if (JSVGViewerFrame.this.window == null) {
                    JSVGViewerFrame.this.window = new JWindow(JSVGViewerFrame.this);
                    Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                    JSVGViewerFrame.this.window.setSize(size);
                }
                JSVGViewerFrame.this.svgCanvas.getParent().remove((Component)((Object)JSVGViewerFrame.this.svgCanvas));
                JSVGViewerFrame.this.window.getContentPane().add((Component)((Object)JSVGViewerFrame.this.svgCanvas));
                JSVGViewerFrame.this.window.setVisible(true);
                JSVGViewerFrame.this.window.toFront();
                JSVGViewerFrame.this.svgCanvas.requestFocus();
            } else {
                JSVGViewerFrame.this.svgCanvas.getParent().remove((Component)((Object)JSVGViewerFrame.this.svgCanvas));
                JSVGViewerFrame.this.svgCanvasPanel.add((Component)((Object)JSVGViewerFrame.this.svgCanvas), "Center");
                JSVGViewerFrame.this.window.setVisible(false);
            }
        }
    }

    public class ThumbnailDialogAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.thumbnailDialog == null) {
                JSVGViewerFrame.this.thumbnailDialog = new ThumbnailDialog((Frame)JSVGViewerFrame.this, JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.thumbnailDialog.pack();
                Rectangle fr = JSVGViewerFrame.this.getBounds();
                Dimension td = JSVGViewerFrame.this.thumbnailDialog.getSize();
                JSVGViewerFrame.this.thumbnailDialog.setLocation(fr.x + (fr.width - td.width) / 2, fr.y + (fr.height - td.height) / 2);
            }
            JSVGViewerFrame.this.thumbnailDialog.setInteractionEnabled(!JSVGViewerFrame.this.svgCanvas.getDisableInteractions());
            JSVGViewerFrame.this.thumbnailDialog.setVisible(true);
        }
    }

    public class FindDialogAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.findDialog == null) {
                JSVGViewerFrame.this.findDialog = new FindDialog((Frame)JSVGViewerFrame.this, JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.findDialog.setGraphicsNode(JSVGViewerFrame.this.svgCanvas.getGraphicsNode());
                JSVGViewerFrame.this.findDialog.pack();
                Rectangle fr = JSVGViewerFrame.this.getBounds();
                Dimension td = JSVGViewerFrame.this.findDialog.getSize();
                JSVGViewerFrame.this.findDialog.setLocation(fr.x + (fr.width - td.width) / 2, fr.y + (fr.height - td.height) / 2);
            }
            JSVGViewerFrame.this.findDialog.setVisible(true);
        }
    }

    public class MonitorAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (memoryMonitorFrame == null) {
                memoryMonitorFrame = new MemoryMonitor();
                Rectangle fr = JSVGViewerFrame.this.getBounds();
                Dimension md = memoryMonitorFrame.getSize();
                memoryMonitorFrame.setLocation(fr.x + (fr.width - md.width) / 2, fr.y + (fr.height - md.height) / 2);
            }
            memoryMonitorFrame.setVisible(true);
        }
    }

    public class SetTransformAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AffineTransform txf;
            if (JSVGViewerFrame.this.transformDialog == null) {
                JSVGViewerFrame.this.transformDialog = JAffineTransformChooser.createDialog((Component)JSVGViewerFrame.this, (String)resources.getString("SetTransform.title"));
            }
            if ((txf = JSVGViewerFrame.this.transformDialog.showDialog()) != null) {
                AffineTransform at = JSVGViewerFrame.this.svgCanvas.getRenderingTransform();
                if (at == null) {
                    at = new AffineTransform();
                }
                txf.concatenate(at);
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(txf);
            }
        }
    }

    public class StopAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame.this.svgCanvas.stopProcessing();
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        public void update(boolean enabled) {
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(enabled);
            }
        }
    }

    public class PauseAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame.this.svgCanvas.suspendProcessing();
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        public void update(boolean enabled) {
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(enabled);
            }
        }
    }

    public class PlayAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame.this.svgCanvas.resumeProcessing();
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        public void update(boolean enabled) {
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(enabled);
            }
        }
    }

    public class UseStylesheetAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            JSVGViewerFrame.this.alternateStyleSheet = null;
            Iterator it = this.components.iterator();
            SVGDocument doc = JSVGViewerFrame.this.svgCanvas.getSVGDocument();
            while (it.hasNext()) {
                JComponent stylesheetMenu = (JComponent)it.next();
                stylesheetMenu.removeAll();
                stylesheetMenu.setEnabled(false);
                ButtonGroup buttonGroup = new ButtonGroup();
                for (Node n = doc.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
                    if (!(n instanceof StyleSheetProcessingInstruction)) continue;
                    StyleSheetProcessingInstruction sspi = (StyleSheetProcessingInstruction)n;
                    HashTable attrs = sspi.getPseudoAttributes();
                    final String title = (String)attrs.get((Object)"title");
                    String alt = (String)attrs.get((Object)"alternate");
                    if (title == null || !"yes".equals(alt)) continue;
                    JRadioButtonMenuItem button = new JRadioButtonMenuItem(title);
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SVGOMDocument doc = (SVGOMDocument)JSVGViewerFrame.this.svgCanvas.getSVGDocument();
                            doc.clearViewCSS();
                            JSVGViewerFrame.this.alternateStyleSheet = title;
                            JSVGViewerFrame.this.svgCanvas.setSVGDocument((SVGDocument)doc);
                        }
                    });
                    buttonGroup.add(button);
                    stylesheetMenu.add(button);
                    stylesheetMenu.setEnabled(true);
                }
            }
        }
    }

    public class NextTransformAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.transformHistory.canGoForward()) {
                JSVGViewerFrame.this.transformHistory.forward();
                this.update();
                JSVGViewerFrame.this.previousTransformAction.update();
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.transformHistory.currentTransform());
            }
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            boolean b = JSVGViewerFrame.this.transformHistory.canGoForward();
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(b);
            }
        }
    }

    public class PreviousTransformAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.transformHistory.canGoBack()) {
                JSVGViewerFrame.this.transformHistory.back();
                this.update();
                JSVGViewerFrame.this.nextTransformAction.update();
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.transformHistory.currentTransform());
            }
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            boolean b = JSVGViewerFrame.this.transformHistory.canGoBack();
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(b);
            }
        }
    }

    public class ToggleDebuggerAction
    extends AbstractAction {
        public ToggleDebuggerAction() {
            super("Toggle Debugger Action");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.debugger == null) {
                JSVGViewerFrame.this.showDebugger();
            } else {
                JSVGViewerFrame.this.hideDebugger();
            }
        }
    }

    public class FlushAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame.this.svgCanvas.flush();
            JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.svgCanvas.getRenderingTransform());
        }
    }

    public class ViewSourceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.svgDocument == null) {
                return;
            }
            final ParsedURL u = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
            final JFrame fr = new JFrame(u.toString());
            fr.setSize(resources.getInteger("ViewSource.width"), resources.getInteger("ViewSource.height"));
            final XMLTextEditor ta = new XMLTextEditor();
            ta.setFont(new Font("monospaced", 0, 12));
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add((Component)ta);
            scroll.setVerticalScrollBarPolicy(22);
            fr.getContentPane().add((Component)scroll, "Center");
            new Thread(){

                @Override
                public void run() {
                    char[] buffer = new char[4096];
                    try {
                        int len;
                        XMLDocument doc = new XMLDocument();
                        ParsedURL purl = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
                        InputStream is = u.openStream(JSVGViewerFrame.this.getInputHandler(purl).getHandledMimeTypes());
                        Reader in = XMLUtilities.createXMLDocumentReader((InputStream)is);
                        while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                            doc.insertString(doc.getLength(), new String(buffer, 0, len), null);
                        }
                        ta.setDocument((Document)doc);
                        ta.setEditable(false);
                        fr.setVisible(true);
                    }
                    catch (Exception ex) {
                        JSVGViewerFrame.this.userAgent.displayError(ex);
                    }
                }
            }.start();
        }
    }

    public class ExportAsTIFFAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentSavePath));
            fileChooser.setDialogTitle(resources.getString("ExportAsTIFF.title"));
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.addChoosableFileFilter(new ImageFileFilter(".tiff"));
            int choice = fileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (choice == 0) {
                final File f = fileChooser.getSelectedFile();
                BufferedImage buffer = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (buffer != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsTIFF"));
                    int w = buffer.getWidth();
                    int h = buffer.getHeight();
                    TIFFTranscoder trans = new TIFFTranscoder();
                    if (JSVGViewerFrame.this.application.getXMLParserClassName() != null) {
                        trans.addTranscodingHint(JPEGTranscoder.KEY_XML_PARSER_CLASSNAME, (Object)JSVGViewerFrame.this.application.getXMLParserClassName());
                    }
                    BufferedImage img = trans.createImage(w, h);
                    Graphics2D g2d = img.createGraphics();
                    g2d.drawImage(buffer, null, 0, 0);
                    new Thread((ImageTranscoder)trans, img){
                        final /* synthetic */ ImageTranscoder val$trans;
                        final /* synthetic */ BufferedImage val$img;
                        {
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        @Override
                        public void run() {
                            try {
                                JSVGViewerFrame.this.currentSavePath = f;
                                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput((OutputStream)ostream));
                                ((OutputStream)ostream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }
    }

    public class ExportAsPNGAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentSavePath));
            fileChooser.setDialogTitle(resources.getString("ExportAsPNG.title"));
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.addChoosableFileFilter(new ImageFileFilter(".png"));
            int choice = fileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (choice == 0) {
                boolean isIndexed = PNGOptionPanel.showDialog(JSVGViewerFrame.this);
                final File f = fileChooser.getSelectedFile();
                BufferedImage buffer = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (buffer != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsPNG"));
                    int w = buffer.getWidth();
                    int h = buffer.getHeight();
                    PNGTranscoder trans = new PNGTranscoder();
                    if (JSVGViewerFrame.this.application.getXMLParserClassName() != null) {
                        trans.addTranscodingHint(JPEGTranscoder.KEY_XML_PARSER_CLASSNAME, (Object)JSVGViewerFrame.this.application.getXMLParserClassName());
                    }
                    trans.addTranscodingHint(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.TRUE);
                    if (isIndexed) {
                        trans.addTranscodingHint(PNGTranscoder.KEY_INDEXED, (Object)new Integer(8));
                    }
                    BufferedImage img = trans.createImage(w, h);
                    Graphics2D g2d = img.createGraphics();
                    g2d.drawImage(buffer, null, 0, 0);
                    new Thread((ImageTranscoder)trans, img){
                        final /* synthetic */ ImageTranscoder val$trans;
                        final /* synthetic */ BufferedImage val$img;
                        {
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        @Override
                        public void run() {
                            try {
                                JSVGViewerFrame.this.currentSavePath = f;
                                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput((OutputStream)ostream));
                                ((OutputStream)ostream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }
    }

    public class ExportAsJPGAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentSavePath));
            fileChooser.setDialogTitle(resources.getString("ExportAsJPG.title"));
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.addChoosableFileFilter(new ImageFileFilter(".jpg"));
            int choice = fileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (choice == 0) {
                float quality = JPEGOptionPanel.showDialog(JSVGViewerFrame.this);
                final File f = fileChooser.getSelectedFile();
                BufferedImage buffer = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (buffer != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsJPG"));
                    int w = buffer.getWidth();
                    int h = buffer.getHeight();
                    JPEGTranscoder trans = new JPEGTranscoder();
                    if (JSVGViewerFrame.this.application.getXMLParserClassName() != null) {
                        trans.addTranscodingHint(JPEGTranscoder.KEY_XML_PARSER_CLASSNAME, (Object)JSVGViewerFrame.this.application.getXMLParserClassName());
                    }
                    trans.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(quality));
                    BufferedImage img = trans.createImage(w, h);
                    Graphics2D g2d = img.createGraphics();
                    g2d.setColor(Color.white);
                    g2d.fillRect(0, 0, w, h);
                    g2d.drawImage(buffer, null, 0, 0);
                    new Thread((ImageTranscoder)trans, img){
                        final /* synthetic */ ImageTranscoder val$trans;
                        final /* synthetic */ BufferedImage val$img;
                        {
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        @Override
                        public void run() {
                            try {
                                JSVGViewerFrame.this.currentSavePath = f;
                                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput((OutputStream)ostream));
                                ((OutputStream)ostream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentSavePath));
            fileChooser.setDialogTitle(resources.getString("SaveAs.title"));
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.addChoosableFileFilter(new ImageFileFilter(".svg"));
            int choice = fileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (choice != 0) {
                return;
            }
            File f = fileChooser.getSelectedFile();
            SVGOptionPanel sop = SVGOptionPanel.showDialog(JSVGViewerFrame.this);
            final boolean useXMLBase = sop.getUseXMLBase();
            final boolean prettyPrint = sop.getPrettyPrint();
            sop = null;
            final SVGDocument svgDoc = JSVGViewerFrame.this.svgCanvas.getSVGDocument();
            if (svgDoc == null) {
                return;
            }
            JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.saveAs"));
            JSVGViewerFrame.this.currentSavePath = f;
            OutputStreamWriter w = null;
            try {
                OutputStream tos = null;
                tos = new FileOutputStream(f);
                tos = new BufferedOutputStream(tos);
                w = new OutputStreamWriter(tos, "utf-8");
            }
            catch (Exception ex) {
                JSVGViewerFrame.this.userAgent.displayError(ex);
                return;
            }
            final OutputStreamWriter writer = w;
            final Runnable doneRun = new Runnable(){

                @Override
                public void run() {
                    String doneStr = resources.getString("Message.done");
                    JSVGViewerFrame.this.statusBar.setMessage(doneStr);
                }
            };
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                        writer.write(EOL);
                        Node fc = svgDoc.getFirstChild();
                        if (fc.getNodeType() != 10) {
                            writer.write("<!DOCTYPE svg PUBLIC '");
                            writer.write("-//W3C//DTD SVG 1.0//EN");
                            writer.write("' '");
                            writer.write("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
                            writer.write("'>");
                            writer.write(EOL);
                            writer.write(EOL);
                        }
                        SVGSVGElement root = svgDoc.getRootElement();
                        boolean doXMLBase = useXMLBase;
                        if (root.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "base")) {
                            doXMLBase = false;
                        }
                        if (doXMLBase) {
                            root.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", svgDoc.getURL());
                        }
                        if (prettyPrint) {
                            SVGTranscoder trans = new SVGTranscoder();
                            trans.transcode(new TranscoderInput((org.w3c.dom.Document)svgDoc), new TranscoderOutput((Writer)writer));
                        } else {
                            DOMUtilities.writeDocument((org.w3c.dom.Document)svgDoc, (Writer)writer);
                        }
                        writer.close();
                        if (doXMLBase) {
                            root.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base");
                        }
                        if (EventQueue.isDispatchThread()) {
                            doneRun.run();
                        } else {
                            EventQueue.invokeLater(doneRun);
                        }
                    }
                    catch (Exception ex) {
                        JSVGViewerFrame.this.userAgent.displayError(ex);
                    }
                }
            };
            UpdateManager um = JSVGViewerFrame.this.svgCanvas.getUpdateManager();
            if (um != null && um.isRunning()) {
                um.getUpdateRunnableQueue().invokeLater(r);
            } else {
                r.run();
            }
        }
    }

    public class PrintAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.svgDocument != null) {
                final SVGDocument doc = JSVGViewerFrame.this.svgDocument;
                new Thread(){

                    @Override
                    public void run() {
                        String uri = doc.getURL();
                        String fragment = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                        if (fragment != null) {
                            uri = uri + '#' + fragment;
                        }
                        PrintTranscoder pt = new PrintTranscoder();
                        if (JSVGViewerFrame.this.application.getXMLParserClassName() != null) {
                            pt.addTranscodingHint(JPEGTranscoder.KEY_XML_PARSER_CLASSNAME, (Object)JSVGViewerFrame.this.application.getXMLParserClassName());
                        }
                        pt.addTranscodingHint(PrintTranscoder.KEY_SHOW_PAGE_DIALOG, (Object)Boolean.TRUE);
                        pt.addTranscodingHint(PrintTranscoder.KEY_SHOW_PRINTER_DIALOG, (Object)Boolean.TRUE);
                        pt.transcode(new TranscoderInput(uri), null);
                        try {
                            pt.print();
                        }
                        catch (PrinterException ex) {
                            JSVGViewerFrame.this.userAgent.displayError((Exception)ex);
                        }
                    }
                }.start();
            }
        }
    }

    public class ForwardAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.localHistory.canGoForward()) {
                JSVGViewerFrame.this.localHistory.forward();
            }
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            boolean b = JSVGViewerFrame.this.localHistory.canGoForward();
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(b);
            }
        }
    }

    public class BackAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.localHistory.canGoBack()) {
                JSVGViewerFrame.this.localHistory.back();
            }
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            boolean b = JSVGViewerFrame.this.localHistory.canGoBack();
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(b);
            }
        }
    }

    public class ReloadAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 1) == 1) {
                JSVGViewerFrame.this.svgCanvas.flushImageCache();
            }
            if (JSVGViewerFrame.this.svgDocument != null) {
                JSVGViewerFrame.this.localHistory.reload();
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame.this.application.closeJSVGViewerFrame(JSVGViewerFrame.this);
        }
    }

    public class PreferencesAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame.this.application.showPreferenceDialog(JSVGViewerFrame.this);
        }
    }

    public class NewWindowAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JSVGViewerFrame vf = JSVGViewerFrame.this.application.createAndShowJSVGViewerFrame();
            vf.autoAdjust = JSVGViewerFrame.this.autoAdjust;
            vf.debug = JSVGViewerFrame.this.debug;
            vf.svgCanvas.setProgressivePaint(JSVGViewerFrame.this.svgCanvas.getProgressivePaint());
            vf.svgCanvas.setDoubleBufferedRendering(JSVGViewerFrame.this.svgCanvas.getDoubleBufferedRendering());
        }
    }

    public class OpenLocationAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSVGViewerFrame.this.uriChooser == null) {
                JSVGViewerFrame.this.uriChooser = new URIChooser((JFrame)JSVGViewerFrame.this);
                JSVGViewerFrame.this.uriChooser.setFileFilter((FileFilter)new SVGFileFilter());
                JSVGViewerFrame.this.uriChooser.pack();
                Rectangle fr = JSVGViewerFrame.this.getBounds();
                Dimension sd = JSVGViewerFrame.this.uriChooser.getSize();
                JSVGViewerFrame.this.uriChooser.setLocation(fr.x + (fr.width - sd.width) / 2, fr.y + (fr.height - sd.height) / 2);
            }
            if (JSVGViewerFrame.this.uriChooser.showDialog() == 0) {
                String s = JSVGViewerFrame.this.uriChooser.getText();
                if (s == null) {
                    return;
                }
                int i = s.indexOf(35);
                String t = "";
                if (i != -1) {
                    t = s.substring(i + 1);
                    s = s.substring(0, i);
                }
                if (!s.equals("")) {
                    File f = new File(s);
                    if (f.exists()) {
                        if (f.isDirectory()) {
                            s = null;
                        } else {
                            try {
                                s = f.getCanonicalPath();
                                s = s.startsWith("/") ? "file:" + s : "file:/" + s;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (s != null) {
                        if (JSVGViewerFrame.this.svgDocument != null) {
                            ParsedURL docPURL = new ParsedURL(JSVGViewerFrame.this.svgDocument.getURL());
                            ParsedURL purl = new ParsedURL(docPURL, s);
                            String fi = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                            if (docPURL.equals((Object)purl) && t.equals(fi)) {
                                return;
                            }
                        }
                        if (t.length() != 0) {
                            s = s + '#' + t;
                        }
                        JSVGViewerFrame.this.showSVGDocument(s);
                    }
                }
            }
        }
    }

    public class OpenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            block8: {
                File f = null;
                if (Platform.isOSX) {
                    FileDialog fileDialog = new FileDialog((Frame)JSVGViewerFrame.this, Resources.getString(JSVGViewerFrame.OPEN_TITLE));
                    fileDialog.setFilenameFilter(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            for (SquiggleInputHandler handler : JSVGViewerFrame.getHandlers()) {
                                if (!handler.accept(new File(dir, name))) continue;
                                return true;
                            }
                            return false;
                        }
                    });
                    fileDialog.setVisible(true);
                    String filename = fileDialog.getFile();
                    if (fileDialog != null) {
                        String dirname = fileDialog.getDirectory();
                        f = new File(dirname, filename);
                    }
                } else {
                    JFileChooser fileChooser = null;
                    String os = System.getProperty(PROPERTY_OS_NAME, PROPERTY_OS_NAME_DEFAULT);
                    SecurityManager sm = System.getSecurityManager();
                    fileChooser = priorJDK1_4 && sm != null && os.indexOf(PROPERTY_OS_WINDOWS_PREFIX) != -1 ? new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentPath), (FileSystemView)new WindowsAltFileSystemView()) : new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentPath));
                    fileChooser.setFileHidingEnabled(false);
                    fileChooser.setFileSelectionMode(0);
                    for (SquiggleInputHandler handler : JSVGViewerFrame.getHandlers()) {
                        fileChooser.addChoosableFileFilter(new SquiggleInputHandlerFilter(handler));
                    }
                    int choice = fileChooser.showOpenDialog(JSVGViewerFrame.this);
                    if (choice == 0) {
                        JSVGViewerFrame.this.currentPath = f = fileChooser.getSelectedFile();
                    }
                }
                if (f != null) {
                    try {
                        String furl = f.toURI().toURL().toString();
                        JSVGViewerFrame.this.showSVGDocument(furl);
                    }
                    catch (MalformedURLException ex) {
                        if (JSVGViewerFrame.this.userAgent == null) break block8;
                        JSVGViewerFrame.this.userAgent.displayError((Exception)ex);
                    }
                }
            }
        }
    }

    public class AboutAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog dlg = new AboutDialog(JSVGViewerFrame.this);
            dlg.setSize(dlg.getPreferredSize());
            dlg.setLocationRelativeTo(JSVGViewerFrame.this);
            dlg.setVisible(true);
            dlg.toFront();
        }
    }

    protected static class Debugger {
        protected static boolean isPresent;
        protected static Class debuggerClass;
        protected static Class contextFactoryClass;
        protected static final int CLEAR_ALL_BREAKPOINTS_METHOD = 0;
        protected static final int GO_METHOD = 1;
        protected static final int SET_EXIT_ACTION_METHOD = 2;
        protected static final int ATTACH_TO_METHOD = 3;
        protected static final int DETACH_METHOD = 4;
        protected static final int DISPOSE_METHOD = 5;
        protected static final int GET_DEBUG_FRAME_METHOD = 6;
        protected static Constructor debuggerConstructor;
        protected static Method[] debuggerMethods;
        protected static Class rhinoInterpreterClass;
        protected static Method getContextFactoryMethod;
        protected Object debuggerInstance;
        protected JSVGViewerFrame svgFrame;

        public Debugger(JSVGViewerFrame frame, String url) {
            this.svgFrame = frame;
            try {
                this.debuggerInstance = debuggerConstructor.newInstance("JavaScript Debugger - " + url);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
                throw new RuntimeException(ite.getMessage());
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie.getMessage());
            }
        }

        public void setDocumentURL(String url) {
            this.getDebugFrame().setTitle("JavaScript Debugger - " + url);
        }

        public void initialize() {
            JFrame debugGui = this.getDebugFrame();
            JMenuBar menuBar = debugGui.getJMenuBar();
            JMenu menu = menuBar.getMenu(0);
            menu.getItem(0).setEnabled(false);
            menu.getItem(1).setEnabled(false);
            menu.getItem(3).setText(Resources.getString("Close.text"));
            menu.getItem(3).setAccelerator(KeyStroke.getKeyStroke(87, 2));
            debugGui.setSize(600, 460);
            debugGui.pack();
            this.setExitAction(new Runnable(){

                @Override
                public void run() {
                    Debugger.this.svgFrame.hideDebugger();
                }
            });
            WindowAdapter wa = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Debugger.this.svgFrame.hideDebugger();
                }
            };
            debugGui.addWindowListener(wa);
            debugGui.setVisible(true);
            this.attach();
        }

        public void attach() {
            Object interpreter = this.svgFrame.svgCanvas.getRhinoInterpreter();
            if (interpreter != null) {
                this.attachTo(this.getContextFactory(interpreter));
            }
        }

        protected JFrame getDebugFrame() {
            try {
                return (JFrame)debuggerMethods[6].invoke(this.debuggerInstance, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        protected void setExitAction(Runnable r) {
            try {
                debuggerMethods[2].invoke(this.debuggerInstance, r);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        public void attachTo(Object contextFactory) {
            try {
                debuggerMethods[3].invoke(this.debuggerInstance, contextFactory);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        public void detach() {
            try {
                debuggerMethods[4].invoke(this.debuggerInstance, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        public void go() {
            try {
                debuggerMethods[1].invoke(this.debuggerInstance, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        public void clearAllBreakpoints() {
            try {
                debuggerMethods[0].invoke(this.debuggerInstance, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        public void dispose() {
            try {
                debuggerMethods[5].invoke(this.debuggerInstance, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        protected Object getContextFactory(Object rhinoInterpreter) {
            try {
                return getContextFactoryMethod.invoke(rhinoInterpreter, (Object[])null);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }

        static {
            try {
                Class<?> dc = Class.forName("org.mozilla.javascript.tools.debugger.Main");
                Class<?> cfc = Class.forName("org.mozilla.javascript.ContextFactory");
                rhinoInterpreterClass = Class.forName("org.apache.batik.script.rhino.RhinoInterpreter");
                debuggerConstructor = dc.getConstructor(String.class);
                debuggerMethods = new Method[]{dc.getMethod("clearAllBreakpoints", null), dc.getMethod("go", null), dc.getMethod("setExitAction", Runnable.class), dc.getMethod("attachTo", cfc), dc.getMethod("detach", null), dc.getMethod("dispose", null), dc.getMethod("getDebugFrame", null)};
                getContextFactoryMethod = rhinoInterpreterClass.getMethod("getContextFactory", null);
                debuggerClass = dc;
                isPresent = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    protected class Canvas
    extends JSVGCanvas {
        public Canvas(SVGUserAgent ua, boolean eventsEnabled, boolean selectableText) {
            super(ua, eventsEnabled, selectableText);
        }

        public Object getRhinoInterpreter() {
            if (this.bridgeContext == null) {
                return null;
            }
            return this.bridgeContext.getInterpreter("text/ecmascript");
        }

        protected class JSVGViewerDOMViewerController
        implements DOMViewerController {
            protected JSVGViewerDOMViewerController() {
            }

            @Override
            public boolean canEdit() {
                return Canvas.this.getUpdateManager() != null;
            }

            @Override
            public ElementOverlayManager createSelectionManager() {
                if (this.canEdit()) {
                    return new ElementOverlayManager(Canvas.this);
                }
                return null;
            }

            @Override
            public org.w3c.dom.Document getDocument() {
                return Canvas.this.svgDocument;
            }

            @Override
            public void performUpdate(Runnable r) {
                if (this.canEdit()) {
                    Canvas.this.getUpdateManager().getUpdateRunnableQueue().invokeLater(r);
                } else {
                    r.run();
                }
            }

            @Override
            public void removeSelectionOverlay(Overlay selectionOverlay) {
                Canvas.this.getOverlays().remove(selectionOverlay);
            }

            @Override
            public void selectNode(Node node) {
                DOMViewerAction dViewerAction = (DOMViewerAction)JSVGViewerFrame.this.getAction(JSVGViewerFrame.DOM_VIEWER_ACTION);
                dViewerAction.openDOMViewer();
                JSVGViewerFrame.this.domViewer.selectNode(node);
            }
        }
    }
}

