/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Properties;

final class PropertyCacheFile {
    private static final String CONFIG_HASH_KEY = "configuration*?";
    private final String mDetailsFile;
    private final Properties mDetails = new Properties();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MASK_0X0F = 15;
    private static final int SHIFT_4 = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    PropertyCacheFile(Configuration aCurrentConfig, String aFileName) {
        boolean setInActive = true;
        if (aFileName != null) {
            FileInputStream inStream;
            block7: {
                inStream = null;
                String currentConfigHash = this.getConfigHashCode(aCurrentConfig);
                try {
                    inStream = new FileInputStream(aFileName);
                    this.mDetails.load(inStream);
                    String cachedConfigHash = this.mDetails.getProperty(CONFIG_HASH_KEY);
                    setInActive = false;
                    if (cachedConfigHash != null && cachedConfigHash.equals(currentConfigHash)) break block7;
                    this.mDetails.clear();
                    this.mDetails.put(CONFIG_HASH_KEY, currentConfigHash);
                }
                catch (FileNotFoundException e) {
                    setInActive = false;
                    this.mDetails.put(CONFIG_HASH_KEY, currentConfigHash);
                    Utils.closeQuietly(inStream);
                }
                catch (IOException e2) {
                    Utils.getExceptionLogger().debug((Object)"Unable to open cache file, ignoring.", (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            Utils.closeQuietly(inStream);
                            throw throwable;
                        }
                    }
                    Utils.closeQuietly(inStream);
                }
            }
            Utils.closeQuietly(inStream);
        }
        this.mDetailsFile = setInActive ? null : aFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (this.mDetailsFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.mDetailsFile);
                this.mDetails.store(out, null);
                this.flushAndCloseOutStream(out);
            }
            catch (IOException e) {
                try {
                    Utils.getExceptionLogger().debug((Object)"Unable to save cache file.", (Throwable)e);
                    this.flushAndCloseOutStream(out);
                }
                catch (Throwable throwable) {
                    this.flushAndCloseOutStream(out);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAndCloseOutStream(OutputStream aStream) {
        if (aStream != null) {
            try {
                aStream.flush();
            }
            catch (IOException ex) {
                Utils.getExceptionLogger().debug((Object)"Unable to flush output stream.", (Throwable)ex);
            }
            finally {
                Utils.closeQuietly(aStream);
            }
        }
    }

    boolean alreadyChecked(String aFileName, long aTimestamp) {
        String lastChecked = this.mDetails.getProperty(aFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(aTimestamp));
    }

    void checkedOk(String aFileName, long aTimestamp) {
        this.mDetails.put(aFileName, Long.toString(aTimestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConfigHashCode(Serializable aConfiguration) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(aConfiguration);
            }
            finally {
                this.flushAndCloseOutStream(oos);
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(baos.toByteArray());
            return PropertyCacheFile.hexEncode(md.digest());
        }
        catch (Exception ex) {
            Utils.getExceptionLogger().debug((Object)"Unable to calculate hashcode.", (Throwable)ex);
            return "ALWAYS FRESH: " + System.currentTimeMillis();
        }
    }

    private static String hexEncode(byte[] aByteArray) {
        StringBuffer buf = new StringBuffer(2 * aByteArray.length);
        for (byte b : aByteArray) {
            int low = b & 0xF;
            int high = b >> 4 & 0xF;
            buf.append(HEX_CHARS[high]);
            buf.append(HEX_CHARS[low]);
        }
        return buf.toString();
    }
}

