/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class OneStatementPerLineCheck
extends Check {
    private int mLastStatementEnd = -1;
    private int mExprDepth;
    private boolean mInForHeader;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{29, 46, 36, 38};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mExprDepth = 0;
        this.mInForHeader = false;
        this.mLastStatementEnd = -1;
    }

    @Override
    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 29: {
                this.visitExpr(aAst);
                break;
            }
            case 46: {
                this.visitSemi(aAst);
                break;
            }
            case 36: {
                this.mInForHeader = true;
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 38: {
                this.mInForHeader = false;
                break;
            }
            case 29: {
                --this.mExprDepth;
                break;
            }
        }
    }

    private void visitExpr(DetailAST aAst) {
        ++this.mExprDepth;
        if (this.mExprDepth == 1 && !this.mInForHeader && this.mLastStatementEnd == aAst.getLineNo()) {
            this.log(aAst, "multiple.statements.line", new Object[0]);
        }
    }

    private void visitSemi(DetailAST aAst) {
        if (this.mExprDepth == 0) {
            this.mLastStatementEnd = aAst.getLineNo();
        }
    }
}

