/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.CacheUtils;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginRealmCache.class)
public class DefaultPluginRealmCache
implements PluginRealmCache {
    protected final Map<PluginRealmCache.Key, PluginRealmCache.CacheRecord> cache = new ConcurrentHashMap<PluginRealmCache.Key, PluginRealmCache.CacheRecord>();

    @Override
    public PluginRealmCache.Key createKey(Plugin plugin, ClassLoader parentRealm, List<String> parentImports, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return new CacheKey(plugin, parentRealm, parentImports, dependencyFilter, repositories, session);
    }

    @Override
    public PluginRealmCache.CacheRecord get(PluginRealmCache.Key key) {
        return this.cache.get(key);
    }

    @Override
    public PluginRealmCache.CacheRecord put(PluginRealmCache.Key key, ClassRealm pluginRealm, List<Artifact> pluginArtifacts) {
        if (pluginRealm == null || pluginArtifacts == null) {
            throw new IllegalArgumentException();
        }
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate plugin realm for plugin " + key);
        }
        PluginRealmCache.CacheRecord record = new PluginRealmCache.CacheRecord(pluginRealm, pluginArtifacts);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        return CacheUtils.pluginHashCode(plugin);
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.pluginEquals(a, b);
    }

    @Override
    public void register(MavenProject project, PluginRealmCache.CacheRecord record) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheKey
    implements PluginRealmCache.Key {
        private final Plugin plugin;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final ClassLoader parentRealm;
        private final List<String> parentImports;
        private final DependencyFilter filter;
        private final int hashCode;

        public CacheKey(Plugin plugin, ClassLoader parentRealm, List<String> parentImports, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
            this.plugin = plugin.clone();
            this.workspace = CacheUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.parentRealm = parentRealm;
            this.parentImports = parentImports != null ? parentImports : Collections.emptyList();
            this.filter = dependencyFilter;
            int hash = 17;
            hash = hash * 31 + CacheUtils.pluginHashCode(plugin);
            hash = hash * 31 + CacheKey.hash(this.workspace);
            hash = hash * 31 + CacheKey.hash(this.localRepo);
            hash = hash * 31 + CacheUtils.repositoriesHashCode(repositories);
            hash = hash * 31 + CacheKey.hash(parentRealm);
            hash = hash * 31 + ((Object)this.parentImports).hashCode();
            this.hashCode = hash = hash * 31 + CacheKey.hash(dependencyFilter);
        }

        public String toString() {
            return this.plugin.getId();
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.parentRealm == that.parentRealm && CacheUtils.pluginEquals(this.plugin, that.plugin) && CacheKey.eq(this.workspace, that.workspace) && CacheKey.eq(this.localRepo, that.localRepo) && CacheUtils.repositoriesEquals(this.repositories, that.repositories) && CacheKey.eq(this.filter, that.filter) && CacheKey.eq(this.parentImports, that.parentImports);
        }

        private static <T> boolean eq(T s1, T s2) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
    }
}

