/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtMultimedia.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtMultimedia/qvideoframe.sip"
#include <qvideoframe.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtMultimedia/qabstractvideobuffer.sip"
#include <qabstractvideobuffer.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qimage.sip"
#include <qimage.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 24 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvariantmap.sip"
#include <qvariant.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"


PyDoc_STRVAR(doc_QVideoFrame_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isValid(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isValid, doc_QVideoFrame_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_pixelFormat, "pixelFormat(self) -> QVideoFrame.PixelFormat");

extern "C" {static PyObject *meth_QVideoFrame_pixelFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_pixelFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrame::PixelFormat sipRes;

            sipRes = sipCpp->pixelFormat();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrame_PixelFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_pixelFormat, doc_QVideoFrame_pixelFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_handleType, "handleType(self) -> QAbstractVideoBuffer.HandleType");

extern "C" {static PyObject *meth_QVideoFrame_handleType(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_handleType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QAbstractVideoBuffer::HandleType sipRes;

            sipRes = sipCpp->handleType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAbstractVideoBuffer_HandleType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_handleType, doc_QVideoFrame_handleType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_size, "size(self) -> QSize");

extern "C" {static PyObject *meth_QVideoFrame_size(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->size());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_size, doc_QVideoFrame_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_width, "width(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_width(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->width();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_width, doc_QVideoFrame_width);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_height, "height(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_height(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->height();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_height, doc_QVideoFrame_height);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_fieldType, "fieldType(self) -> QVideoFrame.FieldType");

extern "C" {static PyObject *meth_QVideoFrame_fieldType(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_fieldType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrame::FieldType sipRes;

            sipRes = sipCpp->fieldType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrame_FieldType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_fieldType, doc_QVideoFrame_fieldType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setFieldType, "setFieldType(self, a0: QVideoFrame.FieldType)");

extern "C" {static PyObject *meth_QVideoFrame_setFieldType(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setFieldType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame::FieldType a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QVideoFrame_FieldType, &a0))
        {
            sipCpp->setFieldType(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setFieldType, doc_QVideoFrame_setFieldType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_isMapped, "isMapped(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isMapped(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isMapped(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isMapped();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isMapped, doc_QVideoFrame_isMapped);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_isReadable, "isReadable(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isReadable(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isReadable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isReadable();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isReadable, doc_QVideoFrame_isReadable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_isWritable, "isWritable(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isWritable(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isWritable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isWritable();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isWritable, doc_QVideoFrame_isWritable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_mapMode, "mapMode(self) -> QAbstractVideoBuffer.MapMode");

extern "C" {static PyObject *meth_QVideoFrame_mapMode(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_mapMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QAbstractVideoBuffer::MapMode sipRes;

            sipRes = sipCpp->mapMode();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAbstractVideoBuffer_MapMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_mapMode, doc_QVideoFrame_mapMode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_map, "map(self, mode: QAbstractVideoBuffer.MapMode) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_map(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_map(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QAbstractVideoBuffer::MapMode a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QAbstractVideoBuffer_MapMode, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->map(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_map, doc_QVideoFrame_map);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_unmap, "unmap(self)");

extern "C" {static PyObject *meth_QVideoFrame_unmap(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_unmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            sipCpp->unmap();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_unmap, doc_QVideoFrame_unmap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_bytesPerLine, "bytesPerLine(self) -> int\n"
"bytesPerLine(self, plane: int) -> int");

extern "C" {static PyObject *meth_QVideoFrame_bytesPerLine(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_bytesPerLine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->bytesPerLine();

            return PyLong_FromLong(sipRes);
        }
    }

    {
        int a0;
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->bytesPerLine(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_bytesPerLine, doc_QVideoFrame_bytesPerLine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_bits, "bits(self) -> PyQt5.sip.voidptr\n"
"bits(self, plane: int) -> Optional[PyQt5.sip.voidptr]");

extern "C" {static PyObject *meth_QVideoFrame_bits(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_bits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 108 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtMultimedia/qvideoframe.sip"
        uchar *mem;
        
        Py_BEGIN_ALLOW_THREADS
        mem = sipCpp->bits();
        Py_END_ALLOW_THREADS
        
        if (mem)
        {
            sipRes = sipConvertFromVoidPtrAndSize(mem, sipCpp->mappedBytes());
        }
        else
        {
            sipRes = Py_None;
            Py_INCREF(sipRes);
        }
#line 487 "/build/pyqt5/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"

            return sipRes;
        }
    }

    {
        int a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            void*sipRes;

            sipRes = sipCpp->bits(a0);

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_bits, doc_QVideoFrame_bits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_mappedBytes, "mappedBytes(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_mappedBytes(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_mappedBytes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->mappedBytes();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_mappedBytes, doc_QVideoFrame_mappedBytes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_handle, "handle(self) -> Any");

extern "C" {static PyObject *meth_QVideoFrame_handle(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_handle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->handle());

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_handle, doc_QVideoFrame_handle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_startTime, "startTime(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_startTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_startTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->startTime();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_startTime, doc_QVideoFrame_startTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setStartTime, "setStartTime(self, time: int)");

extern "C" {static PyObject *meth_QVideoFrame_setStartTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setStartTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            sipCpp->setStartTime(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setStartTime, doc_QVideoFrame_setStartTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_endTime, "endTime(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_endTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_endTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->endTime();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_endTime, doc_QVideoFrame_endTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setEndTime, "setEndTime(self, time: int)");

extern "C" {static PyObject *meth_QVideoFrame_setEndTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setEndTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            sipCpp->setEndTime(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setEndTime, doc_QVideoFrame_setEndTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_pixelFormatFromImageFormat, "pixelFormatFromImageFormat(format: QImage.Format) -> QVideoFrame.PixelFormat");

extern "C" {static PyObject *meth_QVideoFrame_pixelFormatFromImageFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_pixelFormatFromImageFormat(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QImage::Format a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QImage_Format, &a0))
        {
            ::QVideoFrame::PixelFormat sipRes;

            sipRes = ::QVideoFrame::pixelFormatFromImageFormat(a0);

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrame_PixelFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_pixelFormatFromImageFormat, doc_QVideoFrame_pixelFormatFromImageFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_imageFormatFromPixelFormat, "imageFormatFromPixelFormat(format: QVideoFrame.PixelFormat) -> QImage.Format");

extern "C" {static PyObject *meth_QVideoFrame_imageFormatFromPixelFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_imageFormatFromPixelFormat(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame::PixelFormat a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QVideoFrame_PixelFormat, &a0))
        {
            ::QImage::Format sipRes;

            sipRes = ::QVideoFrame::imageFormatFromPixelFormat(a0);

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QImage_Format);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_imageFormatFromPixelFormat, doc_QVideoFrame_imageFormatFromPixelFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_availableMetaData, "availableMetaData(self) -> dict[str, Any]");

extern "C" {static PyObject *meth_QVideoFrame_availableMetaData(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_availableMetaData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVariantMap*sipRes;

            sipRes = new ::QVariantMap(sipCpp->availableMetaData());

            return sipConvertFromNewType(sipRes, sipType_QVariantMap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_availableMetaData, doc_QVideoFrame_availableMetaData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_metaData, "metaData(self, key: Optional[str]) -> Any");

extern "C" {static PyObject *meth_QVideoFrame_metaData(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_metaData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->metaData(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_metaData, doc_QVideoFrame_metaData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setMetaData, "setMetaData(self, key: Optional[str], value: Any)");

extern "C" {static PyObject *meth_QVideoFrame_setMetaData(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setMetaData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QVariant* a1;
        int a1State = 0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QString, &a0, &a0State, sipType_QVariant, &a1, &a1State))
        {
            sipCpp->setMetaData(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setMetaData, doc_QVideoFrame_setMetaData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_planeCount, "planeCount(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_planeCount(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_planeCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->planeCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_planeCount, doc_QVideoFrame_planeCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_buffer, "buffer(self) -> Optional[QAbstractVideoBuffer]");

extern "C" {static PyObject *meth_QVideoFrame_buffer(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_buffer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QAbstractVideoBuffer*sipRes;

            sipRes = sipCpp->buffer();

            return sipConvertFromType(sipRes, sipType_QAbstractVideoBuffer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_buffer, doc_QVideoFrame_buffer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_image, "image(self) -> QImage");

extern "C" {static PyObject *meth_QVideoFrame_image(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_image(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QImage*sipRes;

            sipRes = new ::QImage(sipCpp->image());

            return sipConvertFromNewType(sipRes, sipType_QImage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_image, doc_QVideoFrame_image);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVideoFrame___ne__(PyObject *, PyObject *);}
static PyObject *slot_QVideoFrame___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVideoFrame *sipCpp = reinterpret_cast< ::QVideoFrame *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVideoFrame));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVideoFrame, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QVideoFrame::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ne_slot, sipType_QVideoFrame, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVideoFrame___eq__(PyObject *, PyObject *);}
static PyObject *slot_QVideoFrame___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVideoFrame *sipCpp = reinterpret_cast< ::QVideoFrame *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVideoFrame));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVideoFrame, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QVideoFrame::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, eq_slot, sipType_QVideoFrame, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QVideoFrame(void *, int);}
static void release_QVideoFrame(void *sipCppV, int)
{
    delete reinterpret_cast< ::QVideoFrame *>(sipCppV);
}


extern "C" {static void *array_QVideoFrame(Py_ssize_t);}
static void *array_QVideoFrame(Py_ssize_t sipNrElem)
{
    return new ::QVideoFrame[sipNrElem];
}


extern "C" {static void array_delete_QVideoFrame(void *);}
static void array_delete_QVideoFrame(void *sipCpp)
{
    delete[] reinterpret_cast< ::QVideoFrame *>(sipCpp);
}


extern "C" {static void assign_QVideoFrame(void *, Py_ssize_t, void *);}
static void assign_QVideoFrame(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVideoFrame *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVideoFrame *>(sipSrc);
}


extern "C" {static void *copy_QVideoFrame(const void *, Py_ssize_t);}
static void *copy_QVideoFrame(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVideoFrame(reinterpret_cast<const ::QVideoFrame *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVideoFrame(sipSimpleWrapper *);}
static void dealloc_QVideoFrame(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QVideoFrame(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QVideoFrame(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QVideoFrame(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QVideoFrame *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QVideoFrame();

            return sipCpp;
        }
    }

    {
        ::QAbstractVideoBuffer* a0;
        const ::QSize* a1;
        ::QVideoFrame::PixelFormat a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J8J9E", sipType_QAbstractVideoBuffer, &a0, sipType_QSize, &a1, sipType_QVideoFrame_PixelFormat, &a2))
        {
            sipCpp = new ::QVideoFrame(a0, *a1, a2);

            return sipCpp;
        }
    }

    {
        int a0;
        const ::QSize* a1;
        int a2;
        ::QVideoFrame::PixelFormat a3;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "iJ9iE", &a0, sipType_QSize, &a1, &a2, sipType_QVideoFrame_PixelFormat, &a3))
        {
            sipCpp = new ::QVideoFrame(a0, *a1, a2, a3);

            return sipCpp;
        }
    }

    {
        const ::QImage* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QImage, &a0))
        {
            sipCpp = new ::QVideoFrame(*a0);

            return sipCpp;
        }
    }

    {
        const ::QVideoFrame* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVideoFrame, &a0))
        {
            sipCpp = new ::QVideoFrame(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVideoFrame[] = {
    {(void *)slot_QVideoFrame___ne__, ne_slot},
    {(void *)slot_QVideoFrame___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVideoFrame[] = {
    {sipName_availableMetaData, meth_QVideoFrame_availableMetaData, METH_VARARGS, doc_QVideoFrame_availableMetaData},
    {sipName_bits, meth_QVideoFrame_bits, METH_VARARGS, doc_QVideoFrame_bits},
    {sipName_buffer, meth_QVideoFrame_buffer, METH_VARARGS, doc_QVideoFrame_buffer},
    {sipName_bytesPerLine, meth_QVideoFrame_bytesPerLine, METH_VARARGS, doc_QVideoFrame_bytesPerLine},
    {sipName_endTime, meth_QVideoFrame_endTime, METH_VARARGS, doc_QVideoFrame_endTime},
    {sipName_fieldType, meth_QVideoFrame_fieldType, METH_VARARGS, doc_QVideoFrame_fieldType},
    {sipName_handle, meth_QVideoFrame_handle, METH_VARARGS, doc_QVideoFrame_handle},
    {sipName_handleType, meth_QVideoFrame_handleType, METH_VARARGS, doc_QVideoFrame_handleType},
    {sipName_height, meth_QVideoFrame_height, METH_VARARGS, doc_QVideoFrame_height},
    {sipName_image, meth_QVideoFrame_image, METH_VARARGS, doc_QVideoFrame_image},
    {sipName_imageFormatFromPixelFormat, meth_QVideoFrame_imageFormatFromPixelFormat, METH_VARARGS, doc_QVideoFrame_imageFormatFromPixelFormat},
    {sipName_isMapped, meth_QVideoFrame_isMapped, METH_VARARGS, doc_QVideoFrame_isMapped},
    {sipName_isReadable, meth_QVideoFrame_isReadable, METH_VARARGS, doc_QVideoFrame_isReadable},
    {sipName_isValid, meth_QVideoFrame_isValid, METH_VARARGS, doc_QVideoFrame_isValid},
    {sipName_isWritable, meth_QVideoFrame_isWritable, METH_VARARGS, doc_QVideoFrame_isWritable},
    {sipName_map, meth_QVideoFrame_map, METH_VARARGS, doc_QVideoFrame_map},
    {sipName_mapMode, meth_QVideoFrame_mapMode, METH_VARARGS, doc_QVideoFrame_mapMode},
    {sipName_mappedBytes, meth_QVideoFrame_mappedBytes, METH_VARARGS, doc_QVideoFrame_mappedBytes},
    {sipName_metaData, meth_QVideoFrame_metaData, METH_VARARGS, doc_QVideoFrame_metaData},
    {sipName_pixelFormat, meth_QVideoFrame_pixelFormat, METH_VARARGS, doc_QVideoFrame_pixelFormat},
    {sipName_pixelFormatFromImageFormat, meth_QVideoFrame_pixelFormatFromImageFormat, METH_VARARGS, doc_QVideoFrame_pixelFormatFromImageFormat},
    {sipName_planeCount, meth_QVideoFrame_planeCount, METH_VARARGS, doc_QVideoFrame_planeCount},
    {sipName_setEndTime, meth_QVideoFrame_setEndTime, METH_VARARGS, doc_QVideoFrame_setEndTime},
    {sipName_setFieldType, meth_QVideoFrame_setFieldType, METH_VARARGS, doc_QVideoFrame_setFieldType},
    {sipName_setMetaData, meth_QVideoFrame_setMetaData, METH_VARARGS, doc_QVideoFrame_setMetaData},
    {sipName_setStartTime, meth_QVideoFrame_setStartTime, METH_VARARGS, doc_QVideoFrame_setStartTime},
    {sipName_size, meth_QVideoFrame_size, METH_VARARGS, doc_QVideoFrame_size},
    {sipName_startTime, meth_QVideoFrame_startTime, METH_VARARGS, doc_QVideoFrame_startTime},
    {sipName_unmap, meth_QVideoFrame_unmap, METH_VARARGS, doc_QVideoFrame_unmap},
    {sipName_width, meth_QVideoFrame_width, METH_VARARGS, doc_QVideoFrame_width}
};

static sipEnumMemberDef enummembers_QVideoFrame[] = {
    {sipName_BottomField, static_cast<int>(::QVideoFrame::BottomField), 162},
    {sipName_Format_ABGR32, static_cast<int>(::QVideoFrame::Format_ABGR32), 163},
    {sipName_Format_ARGB32, static_cast<int>(::QVideoFrame::Format_ARGB32), 163},
    {sipName_Format_ARGB32_Premultiplied, static_cast<int>(::QVideoFrame::Format_ARGB32_Premultiplied), 163},
    {sipName_Format_ARGB8565_Premultiplied, static_cast<int>(::QVideoFrame::Format_ARGB8565_Premultiplied), 163},
    {sipName_Format_AYUV444, static_cast<int>(::QVideoFrame::Format_AYUV444), 163},
    {sipName_Format_AYUV444_Premultiplied, static_cast<int>(::QVideoFrame::Format_AYUV444_Premultiplied), 163},
    {sipName_Format_AdobeDng, static_cast<int>(::QVideoFrame::Format_AdobeDng), 163},
    {sipName_Format_BGR24, static_cast<int>(::QVideoFrame::Format_BGR24), 163},
    {sipName_Format_BGR32, static_cast<int>(::QVideoFrame::Format_BGR32), 163},
    {sipName_Format_BGR555, static_cast<int>(::QVideoFrame::Format_BGR555), 163},
    {sipName_Format_BGR565, static_cast<int>(::QVideoFrame::Format_BGR565), 163},
    {sipName_Format_BGRA32, static_cast<int>(::QVideoFrame::Format_BGRA32), 163},
    {sipName_Format_BGRA32_Premultiplied, static_cast<int>(::QVideoFrame::Format_BGRA32_Premultiplied), 163},
    {sipName_Format_BGRA5658_Premultiplied, static_cast<int>(::QVideoFrame::Format_BGRA5658_Premultiplied), 163},
    {sipName_Format_CameraRaw, static_cast<int>(::QVideoFrame::Format_CameraRaw), 163},
    {sipName_Format_IMC1, static_cast<int>(::QVideoFrame::Format_IMC1), 163},
    {sipName_Format_IMC2, static_cast<int>(::QVideoFrame::Format_IMC2), 163},
    {sipName_Format_IMC3, static_cast<int>(::QVideoFrame::Format_IMC3), 163},
    {sipName_Format_IMC4, static_cast<int>(::QVideoFrame::Format_IMC4), 163},
    {sipName_Format_Invalid, static_cast<int>(::QVideoFrame::Format_Invalid), 163},
    {sipName_Format_Jpeg, static_cast<int>(::QVideoFrame::Format_Jpeg), 163},
    {sipName_Format_NV12, static_cast<int>(::QVideoFrame::Format_NV12), 163},
    {sipName_Format_NV21, static_cast<int>(::QVideoFrame::Format_NV21), 163},
    {sipName_Format_RGB24, static_cast<int>(::QVideoFrame::Format_RGB24), 163},
    {sipName_Format_RGB32, static_cast<int>(::QVideoFrame::Format_RGB32), 163},
    {sipName_Format_RGB555, static_cast<int>(::QVideoFrame::Format_RGB555), 163},
    {sipName_Format_RGB565, static_cast<int>(::QVideoFrame::Format_RGB565), 163},
    {sipName_Format_UYVY, static_cast<int>(::QVideoFrame::Format_UYVY), 163},
    {sipName_Format_User, static_cast<int>(::QVideoFrame::Format_User), 163},
    {sipName_Format_Y16, static_cast<int>(::QVideoFrame::Format_Y16), 163},
    {sipName_Format_Y8, static_cast<int>(::QVideoFrame::Format_Y8), 163},
    {sipName_Format_YUV420P, static_cast<int>(::QVideoFrame::Format_YUV420P), 163},
    {sipName_Format_YUV422P, static_cast<int>(::QVideoFrame::Format_YUV422P), 163},
    {sipName_Format_YUV444, static_cast<int>(::QVideoFrame::Format_YUV444), 163},
    {sipName_Format_YUYV, static_cast<int>(::QVideoFrame::Format_YUYV), 163},
    {sipName_Format_YV12, static_cast<int>(::QVideoFrame::Format_YV12), 163},
    {sipName_InterlacedFrame, static_cast<int>(::QVideoFrame::InterlacedFrame), 162},
    {sipName_ProgressiveFrame, static_cast<int>(::QVideoFrame::ProgressiveFrame), 162},
    {sipName_TopField, static_cast<int>(::QVideoFrame::TopField), 162},
};

PyDoc_STRVAR(doc_QVideoFrame, "\1QVideoFrame()\n"
"QVideoFrame(buffer: Optional[QAbstractVideoBuffer], size: QSize, format: QVideoFrame.PixelFormat)\n"
"QVideoFrame(bytes: int, size: QSize, bytesPerLine: int, format: QVideoFrame.PixelFormat)\n"
"QVideoFrame(image: QImage)\n"
"QVideoFrame(other: QVideoFrame)");


static pyqt5ClassPluginDef plugin_QVideoFrame = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtMultimedia_QVideoFrame = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QVideoFrame,
        SIP_NULLPTR,
        &plugin_QVideoFrame,
    },
    {
        sipNameNr_QVideoFrame,
        {0, 0, 1},
        30, methods_QVideoFrame,
        40, enummembers_QVideoFrame,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QVideoFrame,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QVideoFrame,
    init_type_QVideoFrame,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QVideoFrame,
    assign_QVideoFrame,
    array_QVideoFrame,
    copy_QVideoFrame,
    release_QVideoFrame,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QVideoFrame,
    sizeof (::QVideoFrame),
};
