/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequirePrerequisite
extends AbstractNonCacheableEnforcerRule {
    private String mavenVersion;

    public void setMavenVersion(String mavenVersion) {
        this.mavenVersion = mavenVersion;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            Prerequisites prerequisites = project.getPrerequisites();
            if (prerequisites == null) {
                throw new EnforcerRuleException("Requires prerequisite not set");
            }
            if (this.mavenVersion != null) {
                VersionRange specifiedVersion;
                VersionRange restrictedVersionRange;
                VersionRange requiredVersionRange = VersionRange.createFromVersionSpec((String)this.mavenVersion);
                if (!requiredVersionRange.hasRestrictions()) {
                    requiredVersionRange = VersionRange.createFromVersionSpec((String)("[" + this.mavenVersion + ",)"));
                }
                if ((restrictedVersionRange = requiredVersionRange.restrict(specifiedVersion = VersionRange.createFromVersionSpec((String)prerequisites.getMaven()))).getRecommendedVersion() == null) {
                    throw new EnforcerRuleException("The specified Maven prerequisite( " + specifiedVersion + " ) doesn't match the required version: " + this.mavenVersion);
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

