/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class BaseLicense {
    private String licenseFamilyCategory;
    private String licenseFamilyName;
    private String notes;

    public BaseLicense() {
    }

    public BaseLicense(MetaData.Datum licenseFamilyCategory, MetaData.Datum licenseFamilyName, String notes) {
        if (!"http://org/apache/rat/meta-data#LicenseFamilyCategory".equals(licenseFamilyCategory.getName())) {
            throw new IllegalStateException("Expected http://org/apache/rat/meta-data#LicenseFamilyCategory, got " + licenseFamilyCategory.getName());
        }
        this.setLicenseFamilyCategory(licenseFamilyCategory.getValue());
        if (!"http://org/apache/rat/meta-data#LicenseFamilyName".equals(licenseFamilyName.getName())) {
            throw new IllegalStateException("Expected http://org/apache/rat/meta-data#LicenseFamilyName, got " + licenseFamilyName.getName());
        }
        this.setLicenseFamilyName(licenseFamilyName.getValue());
        this.setNotes(notes);
    }

    public String getLicenseFamilyCategory() {
        return this.licenseFamilyCategory;
    }

    public void setLicenseFamilyCategory(String pDocumentCategory) {
        this.licenseFamilyCategory = pDocumentCategory;
    }

    public String getLicenseFamilyName() {
        return this.licenseFamilyName;
    }

    public void setLicenseFamilyName(String pLicenseFamilyCategory) {
        this.licenseFamilyName = pLicenseFamilyCategory;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String pNotes) {
        this.notes = pNotes;
    }

    public final void reportOnLicense(Document subject) {
        MetaData metaData = subject.getMetaData();
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderSample", this.notes));
        String licFamilyCategory = this.getLicenseFamilyCategory();
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderCategory", licFamilyCategory));
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#LicenseFamilyCategory", licFamilyCategory));
        metaData.set(new MetaData.Datum("http://org/apache/rat/meta-data#LicenseFamilyName", this.getLicenseFamilyName()));
    }

    protected static final String prune(String text) {
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char at = text.charAt(i);
            if (!Character.isLetterOrDigit(at)) continue;
            buffer.append(at);
        }
        return buffer.toString();
    }
}

