/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirePropertyDiverges
implements EnforcerRule {
    private String message;
    static final String MAVEN_ENFORCER_PLUGIN = "org.apache.maven.plugins:maven-enforcer-plugin";
    private String property = null;
    private String regex = null;
    private final String ruleName = StringUtils.lowercaseFirstLetter((String)this.getClass().getSimpleName());

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        Object propValue = this.getPropertyValue(helper);
        this.checkPropValueNotBlank(propValue);
        MavenProject project = this.getMavenProject(helper);
        log.debug((CharSequence)(this.getRuleName() + ": checking property '" + this.property + "' for project " + project));
        MavenProject parent = this.findDefiningParent(project);
        if (parent == null) {
            throw new IllegalStateException("Failed to find parent POM which defines the current rule");
        }
        if (project.equals((Object)parent)) {
            log.debug((CharSequence)(this.getRuleName() + ": skip for property '" + this.property + "' as " + project + " defines rule."));
        } else {
            log.debug((CharSequence)("Check configuration defined in " + parent));
            if (this.regex == null) {
                this.checkAgainstParentValue(project, parent, helper, propValue);
            } else {
                this.checkAgainstRegex(propValue);
            }
        }
    }

    void checkAgainstParentValue(MavenProject project, MavenProject parent, EnforcerRuleHelper helper, Object propValue) throws EnforcerRuleException {
        StringBuilder parentHierarchy = new StringBuilder("project.");
        MavenProject needle = project;
        while (!needle.equals((Object)parent)) {
            parentHierarchy.append("parent.");
            needle = needle.getParent();
        }
        String propertyNameInParent = this.property.replace("project.", parentHierarchy.toString());
        Object parentValue = this.getPropertyValue(helper, propertyNameInParent);
        if (propValue.equals(parentValue)) {
            String errorMessage = this.createResultingErrorMessage(String.format("Property '%s' evaluates to '%s'. This does match '%s' from parent %s", this.property, propValue, parentValue, parent));
            throw new EnforcerRuleException(errorMessage);
        }
    }

    void checkAgainstRegex(Object propValue) throws EnforcerRuleException {
        if (propValue.toString().matches(this.regex)) {
            String errorMessage = this.createResultingErrorMessage(String.format("Property '%s' evaluates to '%s'. This does match the regular expression '%s'", this.property, propValue, this.regex));
            throw new EnforcerRuleException(errorMessage);
        }
    }

    final MavenProject findDefiningParent(MavenProject project) {
        List<Xpp3Dom> rules;
        Model model;
        Build build;
        MavenProject parent;
        Xpp3Dom invokingRule = this.createInvokingRuleDom();
        for (parent = project; !(parent == null || (build = (model = parent.getOriginalModel()).getBuild()) != null && this.isDefiningProject(rules = this.getRuleConfigurations(build), invokingRule)); parent = parent.getParent()) {
        }
        return parent;
    }

    Xpp3Dom createInvokingRuleDom() {
        return new CreateInvokingRuleDom(this).getRuleDom();
    }

    final boolean isDefiningProject(List<Xpp3Dom> rulesFromModel, Xpp3Dom invokingRule) {
        for (Xpp3Dom rule : rulesFromModel) {
            if (!rule.equals((Object)invokingRule)) continue;
            return true;
        }
        return false;
    }

    final String getRuleName() {
        return this.ruleName;
    }

    final List<Xpp3Dom> getRuleConfigurations(Build build) {
        Map plugins = build.getPluginsAsMap();
        List<Xpp3Dom> ruleConfigurationsForPlugins = this.getRuleConfigurations(plugins);
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            Map pluginsFromManagementAsMap = pluginManagement.getPluginsAsMap();
            List<Xpp3Dom> ruleConfigurationsFromManagement = this.getRuleConfigurations(pluginsFromManagementAsMap);
            ruleConfigurationsForPlugins.addAll(ruleConfigurationsFromManagement);
        }
        return ruleConfigurationsForPlugins;
    }

    List<Xpp3Dom> getRuleConfigurations(Map<String, Plugin> plugins) {
        if (plugins.containsKey(MAVEN_ENFORCER_PLUGIN)) {
            ArrayList<Xpp3Dom> ruleConfigurations = new ArrayList<Xpp3Dom>();
            Plugin enforcer = plugins.get(MAVEN_ENFORCER_PLUGIN);
            Xpp3Dom configuration = (Xpp3Dom)enforcer.getConfiguration();
            this.addRules(configuration, ruleConfigurations);
            for (Object execution : enforcer.getExecutions()) {
                this.addRules((Xpp3Dom)((PluginExecution)execution).getConfiguration(), ruleConfigurations);
            }
            return ruleConfigurations;
        }
        return new ArrayList<Xpp3Dom>();
    }

    private void addRules(Xpp3Dom configuration, List<Xpp3Dom> ruleConfigurations) {
        Xpp3Dom rules;
        if (configuration != null && (rules = configuration.getChild("rules")) != null) {
            List<Xpp3Dom> originalListFromPom = Arrays.asList(rules.getChildren(this.getRuleName()));
            ruleConfigurations.addAll(this.createRuleListWithNameSortedChildren(originalListFromPom));
        }
    }

    private List<Xpp3Dom> createRuleListWithNameSortedChildren(List<Xpp3Dom> originalListFromPom) {
        ArrayList<Xpp3Dom> listWithSortedEntries = new ArrayList<Xpp3Dom>(originalListFromPom.size());
        for (Xpp3Dom unsortedXpp3Dom : originalListFromPom) {
            Xpp3Dom[] children;
            Xpp3Dom sortedXpp3Dom = new Xpp3Dom(this.getRuleName());
            TreeMap<String, Xpp3Dom> childrenMap = new TreeMap<String, Xpp3Dom>();
            for (Xpp3Dom child : children = unsortedXpp3Dom.getChildren()) {
                childrenMap.put(child.getName(), child);
            }
            for (Xpp3Dom entry : childrenMap.values()) {
                sortedXpp3Dom.addChild(entry);
            }
            listWithSortedEntries.add(sortedXpp3Dom);
        }
        return listWithSortedEntries;
    }

    Object getPropertyValue(EnforcerRuleHelper helper) throws EnforcerRuleException {
        return this.getPropertyValue(helper, this.property);
    }

    Object getPropertyValue(EnforcerRuleHelper helper, String propertyName) throws EnforcerRuleException {
        try {
            return helper.evaluate("${" + propertyName + "}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to evaluate property: " + propertyName, (Exception)((Object)eee));
        }
    }

    MavenProject getMavenProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to get project.", (Exception)((Object)eee));
        }
    }

    void checkPropValueNotBlank(Object propValue) throws EnforcerRuleException {
        if (propValue == null || StringUtils.isBlank((String)propValue.toString())) {
            throw new EnforcerRuleException(String.format("Property '%s' is required for this build and not defined in hierarchy at all.", this.property));
        }
    }

    String createResultingErrorMessage(String errorMessage) {
        if (StringUtils.isNotEmpty((String)this.message)) {
            return "Property '" + this.property + "' must be overridden:\n" + this.message;
        }
        return errorMessage;
    }

    void setProperty(String property) {
        this.property = property;
    }

    void setRegex(String regex) {
        this.regex = regex;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String getCacheId() {
        return "0";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    private static class CreateInvokingRuleDom {
        private final Xpp3Dom ruleDom;
        private final SortedMap<String, Xpp3Dom> map = new TreeMap<String, Xpp3Dom>();

        public CreateInvokingRuleDom(RequirePropertyDiverges rule) {
            this.ruleDom = new Xpp3Dom(rule.getRuleName());
            this.addToMapWhenNotNull(rule.property, "property");
            this.addToMapWhenNotNull(rule.message, "message");
            this.addToMapWhenNotNull(rule.regex, "regex");
            this.addChildrenToRuleDom();
        }

        public Xpp3Dom getRuleDom() {
            return this.ruleDom;
        }

        private void addToMapWhenNotNull(String member, String memberName) {
            if (member != null) {
                Xpp3Dom memberDom = new Xpp3Dom(memberName);
                memberDom.setValue(member);
                this.map.put(memberName, memberDom);
            }
        }

        private void addChildrenToRuleDom() {
            for (Xpp3Dom entry : this.map.values()) {
                this.ruleDom.addChild(entry);
            }
        }
    }
}

