/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.blocks.RightCurlyOption;

public class RightCurlyCheck
extends AbstractOptionCheck<RightCurlyOption> {
    private boolean mShouldStartLine = true;

    public RightCurlyCheck() {
        super(RightCurlyOption.SAME, RightCurlyOption.class);
    }

    public void setShouldStartLine(boolean aFlag) {
        this.mShouldStartLine = aFlag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{97, 98, 99, 85, 94};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{97, 98, 99, 85, 94, 14, 9, 8, 93, 86, 87, 12, 11};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST rcurly;
        DetailAST nextToken;
        DetailAST lcurly;
        boolean shouldCheckLastRcurly = false;
        switch (aAST.getType()) {
            case 97: {
                lcurly = aAST.getFirstChild();
                nextToken = lcurly.getNextSibling();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 98: {
                nextToken = aAST.getNextSibling();
                lcurly = aAST.getLastChild();
                rcurly = lcurly.getLastChild();
                if (nextToken != null) break;
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                break;
            }
            case 85: {
                nextToken = aAST.findFirstToken(94);
                if (nextToken != null) {
                    lcurly = nextToken.getPreviousSibling();
                    rcurly = lcurly.getLastChild();
                    break;
                }
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                lcurly = aAST.getLastChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 94: {
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                lcurly = aAST.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 99: {
                shouldCheckLastRcurly = true;
                nextToken = this.getNextToken(aAST);
                lcurly = aAST.getFirstChild();
                rcurly = lcurly.getLastChild();
                break;
            }
            case 14: {
                DetailAST child = aAST.getLastChild();
                lcurly = child.getFirstChild();
                rcurly = child.getLastChild();
                nextToken = aAST;
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                lcurly = aAST.findFirstToken(7);
                rcurly = lcurly.getLastChild();
                nextToken = aAST;
                break;
            }
            case 9: 
            case 86: 
            case 87: 
            case 93: {
                lcurly = aAST.findFirstToken(7);
                if (lcurly == null) {
                    return;
                }
                rcurly = lcurly.getLastChild();
                nextToken = aAST;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected token type (" + TokenTypes.getTokenName(aAST.getType()) + ")");
            }
        }
        if (rcurly == null || rcurly.getType() != 74) {
            return;
        }
        if (this.getAbstractOption() == RightCurlyOption.SAME && !this.hasLineBreakBefore(rcurly)) {
            this.log(rcurly, "line.break.before", new Object[0]);
        }
        if (shouldCheckLastRcurly) {
            if (rcurly.getLineNo() == nextToken.getLineNo()) {
                this.log(rcurly, "line.alone", "}");
            }
        } else if (this.getAbstractOption() == RightCurlyOption.SAME && rcurly.getLineNo() != nextToken.getLineNo()) {
            this.log(rcurly, "line.same", "}");
        } else if (this.getAbstractOption() == RightCurlyOption.ALONE && rcurly.getLineNo() == nextToken.getLineNo() && !this.isEmptyBody(lcurly)) {
            this.log(rcurly, "line.alone", "}");
        }
        if (!this.mShouldStartLine) {
            return;
        }
        boolean startsLine = Utils.whitespaceBefore(rcurly.getColumnNo(), this.getLines()[rcurly.getLineNo() - 1]);
        if (!startsLine && lcurly.getLineNo() != rcurly.getLineNo()) {
            this.log(rcurly, "line.new", "}");
        }
    }

    private boolean isEmptyBody(DetailAST aLcurly) {
        boolean result = false;
        if (aLcurly.getParent().getType() == 6) {
            if (aLcurly.getNextSibling().getType() == 74) {
                result = true;
            }
        } else if (aLcurly.getFirstChild().getType() == 74) {
            result = true;
        }
        return result;
    }

    private DetailAST getNextToken(DetailAST aAST) {
        DetailAST next = null;
        for (DetailAST parent = aAST; parent != null && next == null; parent = parent.getParent()) {
            next = parent.getNextSibling();
        }
        return CheckUtils.getFirstNode(next);
    }

    private boolean hasLineBreakBefore(DetailAST aRightCurly) {
        DetailAST previousToken;
        return aRightCurly == null || (previousToken = aRightCurly.getPreviousSibling()) == null || aRightCurly.getLineNo() != previousToken.getLineNo();
    }
}

