/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SpoolFile {
    private static final long LIMIT = 0x20000000L;
    private static final long MEMORY_TRESHOLD = 102400L;
    private File myDirectory;
    private LinkedList myFiles;
    private ByteArrayOutputStream myBuffer;

    public SpoolFile(File directory) {
        this.myDirectory = directory;
        this.myFiles = new LinkedList();
        this.myBuffer = new ByteArrayOutputStream();
    }

    public OutputStream openForWriting() {
        return new SpoolOutputStream();
    }

    public InputStream openForReading() {
        return new SpoolInputStream();
    }

    public void delete() throws SVNException {
        for (File file : this.myFiles) {
            SVNFileUtil.deleteFile(file);
        }
        this.myBuffer = null;
    }

    private class SpoolOutputStream
    extends OutputStream {
        private OutputStream myCurrentOutput;
        private long myCurrentSize;

        private SpoolOutputStream() {
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (SpoolFile.this.myBuffer != null) {
                SpoolFile.this.myBuffer.write(b, off, len);
                if ((long)SpoolFile.this.myBuffer.size() < 102400L) {
                    return;
                }
            }
            if (this.myCurrentOutput == null) {
                File file = this.createNextFile();
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SPOOLING RESPONSE TO FILE: " + file);
                SpoolFile.this.myFiles.add(file);
                try {
                    this.myCurrentOutput = SVNFileUtil.openFileForWriting(file);
                }
                catch (SVNException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(e.getMessage());
                }
            }
            if (SpoolFile.this.myBuffer != null) {
                SpoolFile.this.myBuffer.close();
                SpoolFile.this.myBuffer.writeTo(this.myCurrentOutput);
                this.myCurrentSize += (long)SpoolFile.this.myBuffer.size();
                SpoolFile.this.myBuffer = null;
            } else {
                this.myCurrentOutput.write(b, off, len);
                this.myCurrentSize += (long)len;
            }
            if (this.myCurrentSize >= 0x20000000L) {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.myCurrentOutput != null) {
                try {
                    this.myCurrentOutput.close();
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SPOOLED: " + this.myCurrentSize);
                }
                finally {
                    this.myCurrentOutput = null;
                }
            }
            this.myCurrentSize = 0L;
        }

        public void flush() throws IOException {
            if (this.myCurrentOutput != null) {
                this.myCurrentOutput.flush();
            }
        }

        private File createNextFile() throws IOException {
            File file = File.createTempFile("svnkit.", ".spool", SpoolFile.this.myDirectory);
            file.createNewFile();
            return file;
        }
    }

    private class SpoolInputStream
    extends InputStream {
        private File myCurrentFile;
        private long myCurrentSize;
        private int myBufferOffset;
        private InputStream myCurrentInput;

        private SpoolInputStream() {
        }

        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int read = this.read(buffer);
            if (read != 1) {
                return -1;
            }
            return buffer[0] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (SpoolFile.this.myBuffer != null) {
                int bufferSize = SpoolFile.this.myBuffer.size() - this.myBufferOffset;
                if (bufferSize <= 0) {
                    return -1;
                }
                int toRead = Math.min(bufferSize, len);
                byte[] buffer = SpoolFile.this.myBuffer.toByteArray();
                System.arraycopy(buffer, this.myBufferOffset, b, off, toRead);
                this.myBufferOffset += toRead;
                return toRead;
            }
            int read = 0;
            while (len - read > 0) {
                int toRead;
                int wasRead;
                if (this.myCurrentFile == null) {
                    if (SpoolFile.this.myFiles.isEmpty()) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "FAILED TO READ SPOOLED RESPONSE FULLY (no more files): " + (read == 0 ? -1 : read));
                        return read == 0 ? -1 : read;
                    }
                    this.openNextFile();
                }
                if ((wasRead = this.myCurrentInput.read(b, off + read, toRead = (int)Math.min((long)(len - read), this.myCurrentSize))) < 0) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "FAILED TO READ SPOOLED RESPONSE FULLY (cannot read more from the current file): " + (read == 0 ? -1 : read));
                    return read == 0 ? -1 : read;
                }
                read += wasRead;
                this.myCurrentSize -= (long)wasRead;
                if (this.myCurrentSize != 0L) continue;
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "SPOOLED RESPONSE FULLY READ");
                this.closeCurrentFile();
            }
            return read;
        }

        private void openNextFile() throws IOException {
            this.myCurrentFile = (File)SpoolFile.this.myFiles.removeFirst();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "READING SPOOLED FILE: " + this.myCurrentFile);
            this.myCurrentSize = this.myCurrentFile.length();
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "ABOUT TO READ: " + this.myCurrentSize);
            try {
                this.myCurrentInput = SVNFileUtil.openFileForReading(this.myCurrentFile, SVNLogType.NETWORK);
            }
            catch (SVNException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getMessage());
            }
        }

        public long skip(long n) throws IOException {
            if (SpoolFile.this.myBuffer != null) {
                int bufferSize = SpoolFile.this.myBuffer.size() - this.myBufferOffset;
                if (bufferSize <= 0) {
                    return 0L;
                }
                long toSkip = Math.min((long)bufferSize, n);
                this.myBufferOffset += (int)toSkip;
                return toSkip;
            }
            int skipped = 0;
            while (n - (long)skipped > 0L) {
                long toSkip;
                long wasSkipped;
                if (this.myCurrentFile == null) {
                    if (SpoolFile.this.myFiles.isEmpty()) {
                        return skipped == 0 ? -1L : (long)skipped;
                    }
                    this.openNextFile();
                }
                if ((wasSkipped = this.myCurrentInput.skip(toSkip = Math.min(n - (long)skipped, this.myCurrentSize))) < 0L) {
                    return skipped == 0 ? -1L : (long)skipped;
                }
                skipped = (int)((long)skipped + wasSkipped);
                this.myCurrentSize -= wasSkipped;
                if (this.myCurrentSize != 0L) continue;
                this.closeCurrentFile();
            }
            return skipped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeCurrentFile() throws IOException {
            try {
                this.myCurrentInput.close();
            }
            finally {
                try {
                    SVNFileUtil.deleteFile(this.myCurrentFile);
                }
                catch (SVNException sVNException) {}
                this.myCurrentFile = null;
            }
        }

        public void close() throws IOException {
            if (this.myCurrentFile != null) {
                this.closeCurrentFile();
            }
            SpoolFile.this.myBuffer = null;
            this.myBufferOffset = 0;
        }
    }
}

