/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel.desktopintegrationeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import net.sourceforge.jnlp.config.InfrastructureFileDescriptor;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.FreeDesktopIntegrationEditorFrame;
import net.sourceforge.jnlp.util.XDesktopEntry;

public class JListUtils {
    private static Map<File, Icon> iconCache = new HashMap<File, Icon>();
    private static Map<File, String> textFilesCache = new HashMap<File, String>();
    private static Map<File, Long> stamps = new HashMap<File, Long>();

    private static Icon processIconCache(File f) {
        Icon i = iconCache.get(f);
        if (i == null) {
            i = JListUtils.updateIconCache(f, i);
        } else if (f.lastModified() != stamps.get(f).longValue()) {
            i = JListUtils.updateIconCache(f, i);
        }
        return i;
    }

    private static Icon updateIconCache(File f, Icon i) {
        i = JListUtils.createImageIcon(f, f.getAbsolutePath());
        if (i != null) {
            iconCache.put(f, i);
            stamps.put(f, f.lastModified());
        }
        return i;
    }

    private static String processTextFilesCache(File f) {
        String s = textFilesCache.get(f);
        if (s == null) {
            s = JListUtils.updateTextCache(f, s);
        } else if (f.lastModified() != stamps.get(f).longValue()) {
            s = JListUtils.updateTextCache(f, s);
        }
        return s;
    }

    private static String updateTextCache(File f, String s) {
        s = FreeDesktopIntegrationEditorFrame.fileToString(f, false);
        if (s != null) {
            textFilesCache.put(f, s);
            stamps.put(f, f.lastModified());
        }
        return s;
    }

    private static ImageIcon createImageIcon(File f, String description) {
        try {
            BufferedImage i = ImageIO.read(f);
            return new ImageIcon(i.getScaledInstance(50, 50, 4));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static class IconisedCellRenderer
    extends DefaultListCellRenderer {
        private IconisedCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File f = (File)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(JListUtils.processIconCache(f));
            label.setText(f.getName());
            label.setHorizontalTextPosition(4);
            return label;
        }
    }

    private static class ValidatingFileCellRenderer
    extends FileCellRenderer {
        private ValidatingFileCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            File f = (File)value;
            String s = JListUtils.processTextFilesCache(f);
            if (!isSelected) {
                if (this.isJavaws(s)) {
                    l.setBackground(new Color(0, 200, 0));
                } else if (this.isBrowser(s)) {
                    l.setBackground(new Color(100, 150, 0));
                } else {
                    l.setBackground(new Color(255, 200, 200));
                }
            } else if (this.isJavaws(s)) {
                l.setForeground(new Color(0, 200, 0));
            } else if (this.isBrowser(s)) {
                l.setForeground(new Color(100, 150, 0));
            } else {
                l.setForeground(new Color(255, 200, 200));
            }
            return l;
        }

        private boolean isJavaws(String s) {
            return this.haveString(s, "javaws");
        }

        private boolean isBrowser(String s) {
            String[] browsers;
            for (String browser : browsers = XDesktopEntry.BROWSERS) {
                if (!this.haveString(s, browser)) continue;
                return true;
            }
            return false;
        }

        private boolean haveString(String s, String i) {
            return s.matches("(?sm).*^.*Exec.*=.*" + i + ".*$.*");
        }
    }

    private static class FileCellRenderer
    extends DefaultListCellRenderer {
        private FileCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File f = (File)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setText(f.getName());
            return label;
        }
    }

    public static class CustomRendererWithIconJList
    extends JList<File> {
        public CustomRendererWithIconJList() {
            this.setCellRenderer(new IconisedCellRenderer());
        }
    }

    public static class CustomValidatingRendererJList
    extends JList<File> {
        public CustomValidatingRendererJList() {
            this.setCellRenderer(new ValidatingFileCellRenderer());
        }
    }

    public static class CustomRendererJList
    extends JList<File> {
        public CustomRendererJList() {
            this.setCellRenderer(new FileCellRenderer());
        }
    }

    public static class FileListBasedJListModel
    implements ListModel {
        private final File directory;
        private File[] list;
        private final Pattern mask;

        public FileListBasedJListModel(File dir) {
            this(dir, ".*");
        }

        public FileListBasedJListModel(File dir, String mask) {
            this.directory = dir;
            this.mask = Pattern.compile(mask);
        }

        protected File getFile() {
            return this.directory;
        }

        public String toString() {
            return this.getFile().getAbsolutePath();
        }

        private File[] populateList() {
            this.list = this.getFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return mask.matcher(name).matches();
                }
            });
            if (this.list == null) {
                this.list = new File[0];
            }
            return this.list;
        }

        @Override
        public int getSize() {
            if (this.list == null) {
                this.populateList();
            }
            return this.list.length;
        }

        public Object getElementAt(int index) {
            if (this.list == null) {
                this.populateList();
            }
            if (this.list.length == 0) {
                return "??";
            }
            return this.list[index];
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    public static class InfrastructureFileDescriptorListingBasedJListModel
    extends FileListBasedJListModel {
        private final InfrastructureFileDescriptor source;

        public InfrastructureFileDescriptorListingBasedJListModel(InfrastructureFileDescriptor source, String mask) {
            super(source.getFile(), mask);
            this.source = source;
        }

        public InfrastructureFileDescriptorListingBasedJListModel(InfrastructureFileDescriptor source) {
            super(source.getFile());
            this.source = source;
        }

        public InfrastructureFileDescriptor getSource() {
            return this.source;
        }

        @Override
        protected File getFile() {
            return this.source.getFile();
        }

        @Override
        public String toString() {
            return this.source.toString();
        }
    }
}

