/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.InfrastructureFileDescriptor;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.docprovider.TextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.Formatter;

public class ItwebSettingsTextsProvider
extends TextsProvider {
    public ItwebSettingsTextsProvider(String encoding, Formatter formatter, boolean forceTitles, boolean expandFiles) {
        super(encoding, formatter, forceTitles, expandFiles);
    }

    @Override
    public String getId() {
        return "itweb-settings";
    }

    @Override
    public String getIntroduction() {
        return super.getIntroduction() + this.getFormatter().wrapParagraph(this.getFormatter().process(this.getId() + " " + Translator.R("ITWSintro")));
    }

    @Override
    public String getSynopsis() {
        return super.getSynopsis() + this.getFormatter().wrapParagraph(this.getFormatter().getBoldOpening() + this.getId() + " " + this.getFormatter().getBoldCloseNwlineBoldOpen() + this.getId() + " " + this.getFormatter().getBoldClosing() + Translator.R("ITWSsynops"));
    }

    @Override
    public String getDescription() {
        return super.getDescription() + this.getFormatter().wrapParagraph(this.getFormatter().getBold(this.getId() + " ") + this.getFormatter().process(Translator.R("IWSdescL1") + this.getFormatter().getNewLine() + this.getFormatter().getNewLine() + Translator.R("IWSdescL2") + this.getFormatter().getNewLine() + this.getFormatter().getNewLine() + Translator.R("IWSdescL3")));
    }

    @Override
    public String getOptions() {
        return "";
    }

    @Override
    public String getCommands() {
        return super.getDescription() + this.getFormatter().wrapParagraph(this.optionsToString(OptionsDefinitions.getItwsettingsCommands()));
    }

    @Override
    public String getExamples() {
        return super.getExamples() + this.getFormatter().wrapParagraph(this.getFormatter().getOption(this.getId(), Translator.R("IWSexampleL1")) + this.getFormatter().getOption(this.getId() + "  " + OptionsDefinitions.OPTIONS.RESET.option + " " + "deployment.proxy.type", " " + Translator.R("IWSexampleL2", "deployment.proxy.type"))) + this.getFormatter().getNewLine() + this.getFormatter().wrapParagraph(this.getKpMinorTitle() + this.getFormatter().getNewLine() + this.getFormatter().wrapParagraph(this.getProperties()));
    }

    @Override
    public String getFiles() {
        return super.getFiles() + this.getFiles(PathsAndFiles.getAllItWebSettingsFiles()) + this.getFilesAppendix();
    }

    public static void main(String[] args) throws IOException {
        TextsProvider.main(new String[]{"all", "true", "3.51.a"});
    }

    private String getProperties() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<String, Setting<String>>> defaults = new ArrayList<Map.Entry<String, Setting<String>>>(Defaults.getDefaults().entrySet());
        Collections.sort(defaults, new Comparator<Map.Entry<String, Setting<String>>>(){

            @Override
            public int compare(Map.Entry<String, Setting<String>> o1, Map.Entry<String, Setting<String>> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        List<InfrastructureFileDescriptor> files = PathsAndFiles.getAllFiles();
        for (Map.Entry entry : defaults) {
            String defaultValue = (String)((Setting)entry.getValue()).getDefaultValue();
            String fileAcronom = null;
            for (InfrastructureFileDescriptor f : files) {
                if (!this.matchSttingsValueWithInfrastrucutreFile((Setting)entry.getValue(), f)) continue;
                fileAcronom = f.toString();
                break;
            }
            String setValue = JNLPRuntime.getConfiguration().getProperty((String)entry.getKey());
            if (defaultValue == null) {
                defaultValue = "null";
            }
            if (setValue == null) {
                setValue = "null";
            }
            String value = this.expandVariables ? (defaultValue.equals(setValue) ? defaultValue : setValue + " (" + Translator.R("ITWSdefault") + ": " + defaultValue + ")") : (fileAcronom == null ? defaultValue : fileAcronom);
            ValueValidator v = ((Setting)entry.getValue()).getValidator();
            if (v != null && v.getPossibleValues() != null && !v.getPossibleValues().trim().isEmpty()) {
                value = value + " (" + Translator.R("IWSpossible") + " " + v.getPossibleValues() + ")";
            }
            sb.append(this.getFormatter().getOption((String)entry.getKey(), value));
        }
        return sb.toString();
    }

    public String getKpMinorTitle() {
        if (this.expandVariables) {
            return this.getFormatter().getBold(Translator.R("IWSexampleL3") + " " + Translator.R("IWSexampleL31"));
        }
        return this.getFormatter().getBold(Translator.R("IWSexampleL3") + " " + Translator.R("IWSexampleL32"));
    }
}

