/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DefaultConfigurationSerializer {
    private SAXTransformerFactory m_tfactory;
    private Properties m_format = new Properties();

    public void setIndent(boolean bl) {
        if (bl) {
            this.m_format.put("indent", "yes");
        } else {
            this.m_format.put("indent", "no");
        }
    }

    protected ContentHandler createContentHandler(Result result) {
        try {
            TransformerHandler transformerHandler = this.getTransformerFactory().newTransformerHandler();
            this.m_format.put("method", "xml");
            transformerHandler.setResult(result);
            transformerHandler.getTransformer().setOutputProperties(this.m_format);
            return transformerHandler;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    protected SAXTransformerFactory getTransformerFactory() {
        if (this.m_tfactory == null) {
            this.m_tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return this.m_tfactory;
    }

    public void serialize(ContentHandler contentHandler, Configuration configuration) throws SAXException, ConfigurationException {
        contentHandler.startDocument();
        this.serializeElement(contentHandler, new NamespaceSupport(), configuration);
        contentHandler.endDocument();
    }

    protected void serializeElement(ContentHandler contentHandler, NamespaceSupport namespaceSupport, Configuration configuration) throws SAXException, ConfigurationException {
        namespaceSupport.pushContext();
        AttributesImpl attributesImpl = new AttributesImpl();
        String[] stringArray = configuration.getAttributeNames();
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                attributesImpl.addAttribute("", stringArray[i], stringArray[i], "CDATA", configuration.getAttribute(stringArray[i], ""));
            }
        }
        String string = configuration.getNamespace();
        String string2 = "";
        if (configuration instanceof AbstractConfiguration) {
            string2 = ((AbstractConfiguration)configuration).getPrefix();
        }
        boolean bl = false;
        String string3 = namespaceSupport.getURI(string2);
        if (string3 == null || !string3.equals(string)) {
            bl = true;
            if (!string2.equals("") || !string.equals("")) {
                if (string2.equals("")) {
                    attributesImpl.addAttribute("", "xmlns", "xmlns", "CDATA", string);
                } else {
                    attributesImpl.addAttribute("", "xmlns:" + string2, "xmlns:" + string2, "CDATA", string);
                }
            }
            contentHandler.startPrefixMapping(string2, string);
            namespaceSupport.declarePrefix(string2, string);
        }
        String string4 = configuration.getName();
        String string5 = configuration.getName();
        string5 = string2 == null || string2.length() == 0 ? string4 : string2 + ":" + string4;
        contentHandler.startElement(string, string4, string5, attributesImpl);
        String string6 = configuration.getValue(null);
        if (null == string6) {
            Configuration[] configurationArray = configuration.getChildren();
            for (int i = 0; i < configurationArray.length; ++i) {
                this.serializeElement(contentHandler, namespaceSupport, configurationArray[i]);
            }
        } else {
            contentHandler.characters(string6.toCharArray(), 0, string6.length());
        }
        contentHandler.endElement(string, string4, string5);
        if (bl) {
            contentHandler.endPrefixMapping(string2);
        }
        namespaceSupport.popContext();
    }

    public void serializeToFile(String string, Configuration configuration) throws SAXException, IOException, ConfigurationException {
        this.serializeToFile(new File(string), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeToFile(File file, Configuration configuration) throws SAXException, IOException, ConfigurationException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            this.serialize(fileOutputStream, configuration);
        }
    }

    public void serialize(OutputStream outputStream, Configuration configuration) throws SAXException, IOException, ConfigurationException {
        this.serialize(this.createContentHandler(new StreamResult(outputStream)), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(String string, Configuration configuration) throws SAXException, IOException, ConfigurationException {
        try (OutputStream outputStream = null;){
            outputStream = new URL(string).openConnection().getOutputStream();
            this.serialize(outputStream, configuration);
        }
    }

    public String serialize(Configuration configuration) throws SAXException, ConfigurationException {
        StringWriter stringWriter = new StringWriter();
        this.serialize(this.createContentHandler(new StreamResult(stringWriter)), configuration);
        return stringWriter.toString();
    }
}

