/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.generator.qdox.DefaultJavaClassCache;
import org.hamcrest.generator.qdox.JavaDocBuilder;
import org.hamcrest.generator.qdox.model.ClassLibrary;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassCache;
import org.hamcrest.generator.qdox.model.JavaPackage;

public class JavaClassContext
implements Serializable {
    private final JavaClassCache cache;
    private ClassLibrary classLibrary;
    private JavaDocBuilder builder;
    private Map packageMap = new HashMap();

    public JavaClassContext(JavaDocBuilder javaDocBuilder) {
        this.builder = javaDocBuilder;
        this.cache = new DefaultJavaClassCache();
    }

    public JavaClassContext(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
        this.cache = new DefaultJavaClassCache();
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    public JavaClass getClassByName(String string) {
        JavaClass javaClass = this.cache.getClassByName(string);
        if (javaClass == null && this.builder != null) {
            javaClass = this.builder.createBinaryClass(string);
            if (javaClass == null) {
                javaClass = this.builder.createSourceClass(string);
            }
            if (javaClass == null) {
                javaClass = this.builder.createUnknownClass(string);
            }
            if (javaClass != null) {
                this.add(javaClass);
                javaClass.setJavaClassContext(this);
            }
        }
        return javaClass;
    }

    public JavaClass[] getClasses() {
        return this.cache.getClasses();
    }

    public void add(JavaClass javaClass) {
        this.cache.putClassByName(javaClass.getFullyQualifiedName(), javaClass);
        JavaPackage javaPackage = this.getPackageByName(javaClass.getPackageName());
        if (javaPackage != null) {
            javaPackage.addClass(javaClass);
        }
    }

    public void add(String string) {
        this.classLibrary.add(string);
    }

    public Class getClass(String string) {
        return this.classLibrary.getClass(string);
    }

    public JavaPackage getPackageByName(String string) {
        return (JavaPackage)this.packageMap.get(string);
    }

    public void add(JavaPackage javaPackage) {
        String string = javaPackage.getName();
        JavaPackage javaPackage2 = this.getPackageByName(string);
        if (javaPackage2 == null) {
            javaPackage2 = new JavaPackage(string);
            javaPackage2.setContext(this);
            this.packageMap.put(string, javaPackage2);
        }
        javaPackage.setContext(this);
    }

    public JavaPackage[] getPackages() {
        return this.packageMap.values().toArray(new JavaPackage[0]);
    }
}

