/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import jline.ConsoleReader;
import jline.UnixTerminal;
import junit.framework.TestCase;

public abstract class JLineTestCase
extends TestCase {
    ConsoleReader console;

    public JLineTestCase(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.console = new ConsoleReader(null, new PrintWriter(new OutputStreamWriter(new ByteArrayOutputStream())), null, new UnixTerminal());
    }

    public void assertBuffer(String expected, Buffer buffer) throws IOException {
        this.assertBuffer(expected, buffer, true);
    }

    public void assertBuffer(String expected, Buffer buffer, boolean clear) throws IOException {
        if (clear) {
            this.console.finishBuffer();
            this.console.getHistory().clear();
        }
        this.console.setInput(new ByteArrayInputStream(buffer.getBytes()));
        while (this.console.readLine((String)null) != null) {
        }
        JLineTestCase.assertEquals((String)expected, (String)this.console.getCursorBuffer().toString());
    }

    private int getKeyForAction(short logicalAction) {
        int action = this.console.getKeyForAction(logicalAction);
        if (action == -1) {
            JLineTestCase.fail((String)("Keystroke for logical action " + logicalAction + " was not bound in the console"));
        }
        return action;
    }

    class Buffer {
        private final ByteArrayOutputStream bout = new ByteArrayOutputStream();

        public Buffer() {
        }

        public Buffer(String str) {
            this.append(str);
        }

        public byte[] getBytes() {
            return this.bout.toByteArray();
        }

        public Buffer op(short operation) {
            return this.append(JLineTestCase.this.getKeyForAction(operation));
        }

        public Buffer ctrlA() {
            return this.append(JLineTestCase.this.getKeyForAction((short)-1));
        }

        public Buffer ctrlU() {
            return this.append(JLineTestCase.this.getKeyForAction((short)-15));
        }

        public Buffer tab() {
            return this.append(JLineTestCase.this.getKeyForAction((short)-58));
        }

        public Buffer back() {
            return this.append(JLineTestCase.this.getKeyForAction((short)-41));
        }

        public Buffer left() {
            return this.append(27).append(91).append(68);
        }

        public Buffer right() {
            return this.append(27).append(91).append(67);
        }

        public Buffer up() {
            return this.append(27).append(91).append(65);
        }

        public Buffer down() {
            return this.append(27).append(91).append(66);
        }

        public Buffer append(String str) {
            byte[] bytes = str.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.append(bytes[i]);
            }
            return this;
        }

        public Buffer append(int i) {
            return this.append((byte)i);
        }

        public Buffer append(byte b) {
            this.bout.write(b);
            return this;
        }
    }
}

