/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRaw;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawPNG;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class ImageLoaderFactoryRaw
extends AbstractImageLoaderFactory {
    public static final String MIME_EMF = "image/x-emf";
    private static final String[] MIMES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/x-emf"};
    private static final ImageFlavor[][] FLAVORS = new ImageFlavor[][]{{ImageFlavor.RAW_PNG}, {ImageFlavor.RAW_JPEG}, {ImageFlavor.RAW_TIFF}, {ImageFlavor.RAW_EMF}};

    public static String getMimeForRawFlavor(ImageFlavor imageFlavor) {
        int n = FLAVORS.length;
        for (int i = 0; i < n; ++i) {
            int n2 = FLAVORS[i].length;
            for (int j = 0; j < n2; ++j) {
                if (!FLAVORS[i][j].equals(imageFlavor)) continue;
                return MIMES[i];
            }
        }
        throw new IllegalArgumentException("ImageFlavor is not a \"raw\" flavor: " + imageFlavor);
    }

    @Override
    public String[] getSupportedMIMETypes() {
        return MIMES;
    }

    @Override
    public ImageFlavor[] getSupportedFlavors(String string) {
        int n = MIMES.length;
        for (int i = 0; i < n; ++i) {
            if (!MIMES[i].equals(string)) continue;
            return FLAVORS[i];
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + string);
    }

    @Override
    public ImageLoader newImageLoader(ImageFlavor imageFlavor) {
        if (imageFlavor.equals(ImageFlavor.RAW_JPEG)) {
            return new ImageLoaderRawJPEG();
        }
        if (imageFlavor.equals(ImageFlavor.RAW_PNG)) {
            return new ImageLoaderRawPNG();
        }
        return new ImageLoaderRaw(imageFlavor);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

