/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import org.apache.xmlgraphics.image.writer.Endianness;
import org.apache.xmlgraphics.image.writer.ResolutionUnit;

public class ImageWriterParams {
    public static final int SINGLE_STRIP = -1;
    public static final int ONE_ROW_PER_STRIP = 1;
    private Integer xResolution;
    private Integer yResolution;
    private Float jpegQuality;
    private Boolean jpegForceBaseline;
    private String compressionMethod;
    private ResolutionUnit resolutionUnit = ResolutionUnit.INCH;
    private int rowsPerStrip = 1;
    private Endianness endianness = Endianness.DEFAULT;

    public boolean hasResolution() {
        return this.getXResolution() != null && this.getYResolution() != null;
    }

    public Integer getResolution() {
        return this.getXResolution();
    }

    public Float getJPEGQuality() {
        return this.jpegQuality;
    }

    public Boolean getJPEGForceBaseline() {
        return this.jpegForceBaseline;
    }

    public String getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setResolution(int n) {
        this.setXResolution(n);
        this.setYResolution(n);
    }

    public void setJPEGQuality(float f, boolean bl) {
        this.jpegQuality = Float.valueOf(f);
        this.jpegForceBaseline = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setCompressionMethod(String string) {
        this.compressionMethod = string;
    }

    public boolean isSingleStrip() {
        return this.rowsPerStrip == -1;
    }

    public void setSingleStrip(boolean bl) {
        this.rowsPerStrip = bl ? -1 : 1;
    }

    public void setRowsPerStrip(int n) {
        this.rowsPerStrip = n;
    }

    public int getRowsPerStrip() {
        return this.rowsPerStrip;
    }

    public ResolutionUnit getResolutionUnit() {
        return this.resolutionUnit;
    }

    public void setResolutionUnit(ResolutionUnit resolutionUnit) {
        this.resolutionUnit = resolutionUnit;
    }

    public Integer getXResolution() {
        return this.xResolution;
    }

    public void setXResolution(int n) {
        this.xResolution = n;
    }

    public Integer getYResolution() {
        return this.yResolution;
    }

    public void setYResolution(int n) {
        this.yResolution = n;
    }

    public Endianness getEndianness() {
        return this.endianness;
    }

    public void setEndianness(Endianness endianness) {
        this.endianness = endianness;
    }
}

