/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorSpaceOrigin;

public class NamedColorSpace
extends ColorSpace
implements ColorSpaceOrigin {
    private static final long serialVersionUID = -8957543225908514658L;
    private final String name;
    private final float[] xyz;
    private final String profileName;
    private final String profileURI;

    public NamedColorSpace(String string, float[] fArray) {
        this(string, fArray, null, null);
    }

    public NamedColorSpace(String string, float[] fArray, String string2, String string3) {
        super(6, 1);
        this.checkNumComponents(fArray, 3);
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("No name provided for named color space");
        }
        this.name = string.trim();
        this.xyz = new float[3];
        System.arraycopy(fArray, 0, this.xyz, 0, 3);
        this.profileName = string2;
        this.profileURI = string3;
    }

    public NamedColorSpace(String string, Color color, String string2, String string3) {
        this(string, color.getColorSpace().toCIEXYZ(color.getColorComponents(null)), string2, string3);
    }

    public NamedColorSpace(String string, Color color) {
        this(string, color.getColorSpace().toCIEXYZ(color.getColorComponents(null)), null, null);
    }

    private void checkNumComponents(float[] fArray, int n) {
        if (fArray == null) {
            throw new NullPointerException("color value may not be null");
        }
        if (fArray.length != n) {
            throw new IllegalArgumentException("Expected " + n + " components, but got " + fArray.length);
        }
    }

    public String getColorName() {
        return this.name;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public String getProfileURI() {
        return this.profileURI;
    }

    public float[] getXYZ() {
        float[] fArray = new float[this.xyz.length];
        System.arraycopy(this.xyz, 0, fArray, 0, this.xyz.length);
        return fArray;
    }

    public Color getRGBColor() {
        float[] fArray = this.toRGB(this.xyz);
        return new Color(fArray[0], fArray[1], fArray[2]);
    }

    @Override
    public float getMinValue(int n) {
        return this.getMaxValue(n);
    }

    @Override
    public float getMaxValue(int n) {
        switch (n) {
            case 0: {
                return 1.0f;
            }
        }
        throw new IllegalArgumentException("A named color space only has 1 component!");
    }

    @Override
    public String getName(int n) {
        switch (n) {
            case 0: {
                return "Tint";
            }
        }
        throw new IllegalArgumentException("A named color space only has 1 component!");
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return new float[]{1.0f};
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        return new float[]{1.0f};
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        float[] fArray2 = new float[3];
        System.arraycopy(this.xyz, 0, fArray2, 0, this.xyz.length);
        return fArray2;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        return colorSpace.fromCIEXYZ(this.xyz);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NamedColorSpace)) {
            return false;
        }
        NamedColorSpace namedColorSpace = (NamedColorSpace)object;
        if (!this.name.equals(namedColorSpace.name)) {
            return false;
        }
        int n = this.xyz.length;
        for (int i = 0; i < n; ++i) {
            if (this.xyz[i] == namedColorSpace.xyz[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return (this.profileName + this.name).hashCode();
    }

    public String toString() {
        return "Named Color Space: " + this.getColorName();
    }
}

