/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.xmlgraphics.util.i18n.LocaleGroup;
import org.apache.xmlgraphics.util.i18n.Localizable;

public class LocalizableSupport
implements Localizable {
    protected LocaleGroup localeGroup = LocaleGroup.DEFAULT;
    protected String bundleName;
    protected ClassLoader classLoader;
    protected Locale locale;
    protected Locale usedLocale;
    protected ResourceBundle resourceBundle;

    public LocalizableSupport(String string) {
        this(string, null);
    }

    public LocalizableSupport(String string, ClassLoader classLoader) {
        this.bundleName = string;
        this.classLoader = classLoader;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.resourceBundle = null;
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocaleGroup(LocaleGroup localeGroup) {
        this.localeGroup = localeGroup;
    }

    public LocaleGroup getLocaleGroup() {
        return this.localeGroup;
    }

    public void setDefaultLocale(Locale locale) {
        this.localeGroup.setLocale(locale);
    }

    public Locale getDefaultLocale() {
        return this.localeGroup.getLocale();
    }

    @Override
    public String formatMessage(String string, Object[] objectArray) {
        this.getResourceBundle();
        return MessageFormat.format(this.resourceBundle.getString(string), objectArray);
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            Locale locale;
            this.usedLocale = this.locale == null ? ((locale = this.localeGroup.getLocale()) == null ? Locale.getDefault() : locale) : this.locale;
            this.resourceBundle = this.classLoader == null ? ResourceBundle.getBundle(this.bundleName, this.usedLocale) : ResourceBundle.getBundle(this.bundleName, this.usedLocale, this.classLoader);
        } else if (this.locale == null) {
            Locale locale = this.localeGroup.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
                if (this.usedLocale != locale) {
                    this.usedLocale = locale;
                    this.resourceBundle = this.classLoader == null ? ResourceBundle.getBundle(this.bundleName, this.usedLocale) : ResourceBundle.getBundle(this.bundleName, this.usedLocale, this.classLoader);
                }
            } else if (this.usedLocale != locale) {
                this.usedLocale = locale;
                this.resourceBundle = this.classLoader == null ? ResourceBundle.getBundle(this.bundleName, this.usedLocale) : ResourceBundle.getBundle(this.bundleName, this.usedLocale, this.classLoader);
            }
        }
        return this.resourceBundle;
    }
}

