/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.IOException;
import java.io.InputStream;

public class Base64DecodeStream
extends InputStream {
    InputStream src;
    private static final byte[] PEM_ARRAY;
    byte[] decodeBuffer = new byte[4];
    byte[] outBuffer = new byte[3];
    int outOffset = 3;
    boolean eof;

    public Base64DecodeStream(InputStream inputStream) {
        this.src = inputStream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.eof = true;
    }

    @Override
    public int available() throws IOException {
        return 3 - this.outOffset;
    }

    @Override
    public int read() throws IOException {
        if (this.outOffset == 3 && (this.eof || this.getNextAtom())) {
            this.eof = true;
            return -1;
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.outOffset == 3 && (this.eof || this.getNextAtom())) {
                this.eof = true;
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            byArray[n + n3] = this.outBuffer[this.outOffset++];
        }
        return n3;
    }

    final boolean getNextAtom() throws IOException {
        int n = 0;
        while (n != 4) {
            int n2 = this.src.read(this.decodeBuffer, n, 4 - n);
            if (n2 == -1) {
                return true;
            }
            int n3 = n;
            for (int i = n; i < n + n2; ++i) {
                if (this.decodeBuffer[i] == 10 || this.decodeBuffer[i] == 13 || this.decodeBuffer[i] == 32) continue;
                this.decodeBuffer[n3++] = this.decodeBuffer[i];
            }
            n = n3;
        }
        byte by = PEM_ARRAY[this.decodeBuffer[0] & 0xFF];
        byte by2 = PEM_ARRAY[this.decodeBuffer[1] & 0xFF];
        byte by3 = PEM_ARRAY[this.decodeBuffer[2] & 0xFF];
        byte by4 = PEM_ARRAY[this.decodeBuffer[3] & 0xFF];
        this.outBuffer[0] = (byte)(by << 2 | by2 >>> 4);
        this.outBuffer[1] = (byte)(by2 << 4 | by3 >>> 2);
        this.outBuffer[2] = (byte)(by3 << 6 | by4);
        if (this.decodeBuffer[3] != 61) {
            this.outOffset = 0;
        } else if (this.decodeBuffer[2] == 61) {
            this.outBuffer[2] = this.outBuffer[0];
            this.outOffset = 2;
            this.eof = true;
        } else {
            this.outBuffer[2] = this.outBuffer[1];
            this.outBuffer[1] = this.outBuffer[0];
            this.outOffset = 1;
            this.eof = true;
        }
        return false;
    }

    static {
        int n;
        int n2;
        PEM_ARRAY = new byte[256];
        for (n2 = 0; n2 < PEM_ARRAY.length; ++n2) {
            Base64DecodeStream.PEM_ARRAY[n2] = -1;
        }
        n2 = 0;
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            Base64DecodeStream.PEM_ARRAY[n] = (byte)n2++;
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            Base64DecodeStream.PEM_ARRAY[n] = (byte)n2++;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            Base64DecodeStream.PEM_ARRAY[n] = (byte)n2++;
        }
        Base64DecodeStream.PEM_ARRAY[43] = (byte)n2++;
        Base64DecodeStream.PEM_ARRAY[47] = (byte)n2++;
    }
}

